/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.assignment.instance;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.helix.model.InstanceConfig;
import org.apache.pinot.common.assignment.InstancePartitions;
import org.apache.pinot.controller.helix.core.assignment.instance.InstancePartitionSelector;
import org.apache.pinot.spi.config.table.assignment.InstanceReplicaGroupPartitionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FDAwareInstancePartitionSelector
extends InstancePartitionSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(FDAwareInstancePartitionSelector.class);

    public FDAwareInstancePartitionSelector(InstanceReplicaGroupPartitionConfig replicaGroupPartitionConfig, String tableNameWithType, @Nullable InstancePartitions existingInstancePartitions, boolean minimizeDataMovement) {
        super(replicaGroupPartitionConfig, tableNameWithType, existingInstancePartitions, minimizeDataMovement);
    }

    private Pair<Integer, Integer> processFaultDomainPreconditions(Map<Integer, List<InstanceConfig>> faultDomainToInstanceConfigsMap) {
        int numFDs = faultDomainToInstanceConfigsMap.size();
        Preconditions.checkState((numFDs != 0 ? 1 : 0) != 0, (Object)"No pool (fault-domain) qualified for selection");
        List numInstancesPerFD = faultDomainToInstanceConfigsMap.values().stream().map(List::size).sorted().collect(Collectors.toList());
        Optional totalInstancesOptional = numInstancesPerFD.stream().reduce(Integer::sum);
        Preconditions.checkState((totalInstancesOptional.orElse(0) > 0 ? 1 : 0) != 0, (Object)"The number of total instances is zero");
        int numTotalInstances = (Integer)totalInstancesOptional.get();
        Preconditions.checkState(((Integer)numInstancesPerFD.get(numInstancesPerFD.size() - 1) - (Integer)numInstancesPerFD.get(0) <= 1 ? 1 : 0) != 0, (Object)"The instances are not balanced for each pool (fault-domain)");
        return new ImmutablePair((Object)numFDs, (Object)numTotalInstances);
    }

    private Pair<Integer, Integer> processReplicaGroupAssignmentPreconditions(int numFaultDomains, int numTotalInstances, InstanceReplicaGroupPartitionConfig replicaGroupPartitionConfig) {
        int numReplicaGroups = replicaGroupPartitionConfig.getNumReplicaGroups();
        Preconditions.checkState((numReplicaGroups > 0 ? 1 : 0) != 0, (Object)"Number of replica-groups must be positive");
        int numInstancesPerReplicaGroup = replicaGroupPartitionConfig.getNumInstancesPerReplicaGroup();
        if (numInstancesPerReplicaGroup > 0) {
            int numInstancesToSelect = numInstancesPerReplicaGroup * numReplicaGroups;
            Preconditions.checkState((numInstancesToSelect <= numTotalInstances ? 1 : 0) != 0, (String)"Not enough qualified instances, ask for: (numInstancesPerReplicaGroup: %s) * (numReplicaGroups: %s) = %s, having only %s", (Object)numInstancesPerReplicaGroup, (Object)numReplicaGroups, (Object)numInstancesToSelect, (Object)numTotalInstances);
        } else {
            Preconditions.checkState((numTotalInstances % numReplicaGroups == 0 ? 1 : 0) != 0, (String)"The total num instances %s cannot be assigned evenly to %s replica groups, please specify a numInstancesPerReplicaGroup in _replicaGroupPartitionConfig", (int)numTotalInstances, (int)numReplicaGroups);
            numInstancesPerReplicaGroup = numTotalInstances / numReplicaGroups;
        }
        if (numReplicaGroups > numFaultDomains) {
            LOGGER.info("Assigning {} replica groups to {} fault domains, will have more than one replica group down if one fault domain is down", (Object)numReplicaGroups, (Object)numFaultDomains);
        } else {
            LOGGER.info("Assigning {} replica groups to {} fault domains", (Object)numReplicaGroups, (Object)numFaultDomains);
        }
        return new ImmutablePair((Object)numReplicaGroups, (Object)numInstancesPerReplicaGroup);
    }

    @Override
    public void selectInstances(Map<Integer, List<InstanceConfig>> faultDomainToInstanceConfigsMap, InstancePartitions instancePartitions) {
        Pair<Integer, Integer> fdRet = this.processFaultDomainPreconditions(faultDomainToInstanceConfigsMap);
        int numFaultDomains = (Integer)fdRet.getLeft();
        int numTotalInstances = (Integer)fdRet.getRight();
        if (this._replicaGroupPartitionConfig.isReplicaGroupBased()) {
            int numInstancesPerPartition;
            Pair<Integer, Integer> rgRet = this.processReplicaGroupAssignmentPreconditions(numFaultDomains, numTotalInstances, this._replicaGroupPartitionConfig);
            int numReplicaGroups = (Integer)rgRet.getLeft();
            int numInstancesPerReplicaGroup = (Integer)rgRet.getRight();
            TreeMap<Integer, LinkedHashSet<String>> faultDomainToCandidateInstancesMap = new TreeMap<Integer, LinkedHashSet<String>>();
            faultDomainToInstanceConfigsMap.forEach((k, v) -> faultDomainToCandidateInstancesMap.put((Integer)k, new LinkedHashSet<String>(){
                {
                    v.forEach(instance -> this.add(instance.getInstanceName()));
                }
            }));
            HashMap<String, Integer> aliveInstanceNameToFDMap = new HashMap<String, Integer>();
            faultDomainToCandidateInstancesMap.forEach((faultDomainId, value) -> value.forEach(instance -> aliveInstanceNameToFDMap.put((String)instance, (Integer)faultDomainId)));
            ReplicaGroupBasedAssignmentState replicaGroupBasedAssignmentState = null;
            if (this._minimizeDataMovement) {
                int numExistingReplicaGroups = this._existingInstancePartitions.getNumReplicaGroups();
                int numExistingPartitions = this._existingInstancePartitions.getNumPartitions();
                LinkedHashSet<String> existingReplicaGroup = new LinkedHashSet<String>();
                for (int i = 0; i < numExistingReplicaGroups; ++i) {
                    for (int j = 0; j < numExistingPartitions; ++j) {
                        existingReplicaGroup.addAll(this._existingInstancePartitions.getInstances(j, i));
                    }
                    if (i == 0) {
                        int numExistingInstancesPerReplicaGroup = existingReplicaGroup.size();
                        replicaGroupBasedAssignmentState = new ReplicaGroupBasedAssignmentState(numReplicaGroups, numInstancesPerReplicaGroup, numExistingReplicaGroups, numExistingInstancesPerReplicaGroup, numFaultDomains);
                    }
                    replicaGroupBasedAssignmentState.reconstructExistingAssignment(existingReplicaGroup, i, aliveInstanceNameToFDMap);
                    existingReplicaGroup.clear();
                }
            } else {
                replicaGroupBasedAssignmentState = new ReplicaGroupBasedAssignmentState(numReplicaGroups, numInstancesPerReplicaGroup, numFaultDomains);
            }
            Preconditions.checkState((replicaGroupBasedAssignmentState != null ? 1 : 0) != 0);
            replicaGroupBasedAssignmentState.preprocessing(faultDomainToCandidateInstancesMap);
            replicaGroupBasedAssignmentState.normalize(faultDomainToCandidateInstancesMap);
            replicaGroupBasedAssignmentState.fill(faultDomainToCandidateInstancesMap);
            replicaGroupBasedAssignmentState.swapToInvariantState();
            int numPartitions = this._replicaGroupPartitionConfig.getNumPartitions();
            if (numPartitions <= 0) {
                numPartitions = 1;
            }
            if ((numInstancesPerPartition = this._replicaGroupPartitionConfig.getNumInstancesPerPartition()) > 0) {
                Preconditions.checkState((numInstancesPerPartition <= numInstancesPerReplicaGroup ? 1 : 0) != 0, (String)"Number of instances per partition: %s must be smaller or equal to number of instances per replica-group: %s", (int)numInstancesPerPartition, (int)numInstancesPerReplicaGroup);
            } else {
                numInstancesPerPartition = numInstancesPerReplicaGroup;
            }
            LOGGER.info("Selecting {} partitions, {} instances per partition within a replica-group for table: {}", new Object[]{numPartitions, numInstancesPerPartition, this._tableNameWithType});
            for (int replicaGroupId = 0; replicaGroupId < numReplicaGroups; ++replicaGroupId) {
                int instanceIdInReplicaGroup = 0;
                for (int partitionId = 0; partitionId < numPartitions; ++partitionId) {
                    ArrayList<String> instancesInPartition = new ArrayList<String>(numInstancesPerPartition);
                    for (int instanceIdInPartition = 0; instanceIdInPartition < numInstancesPerPartition; ++instanceIdInPartition) {
                        instancesInPartition.add(replicaGroupBasedAssignmentState._replicaGroupIdToInstancesMap[replicaGroupId][instanceIdInReplicaGroup].getInstanceName());
                        instanceIdInReplicaGroup = (instanceIdInReplicaGroup + 1) % numInstancesPerReplicaGroup;
                    }
                    LOGGER.info("Selecting instances: {} for replica-group: {}, partition: {} for table: {}", new Object[]{instancesInPartition, replicaGroupId, partitionId, this._tableNameWithType});
                    instancePartitions.setInstances(partitionId, replicaGroupId, instancesInPartition);
                }
            }
        } else {
            throw new IllegalStateException("Non-replica-group based selection unfinished");
        }
    }

    private static class Instance {
        static final int NEW_INSTANCE = -1;
        private final String _instanceName;
        private final int _faultDomainId;
        private final int _existingReplicaGroupId;

        public Instance(String instance, int faultDomainId, int existingReplicaGroupId) {
            this._instanceName = instance;
            this._faultDomainId = faultDomainId;
            this._existingReplicaGroupId = existingReplicaGroupId;
        }

        String getInstanceName() {
            return this._instanceName;
        }

        int getFaultDomainId() {
            return this._faultDomainId;
        }

        int getExistingReplicaGroupId() {
            return this._existingReplicaGroupId;
        }
    }

    private static class ReplicaGroupBasedAssignmentState {
        private static final int INVALID_FD = -1;
        Instance[][] _replicaGroupIdToInstancesMap;
        int _numReplicaGroups;
        int _numInstancesPerReplicaGroup;
        int _numExistingReplicaGroups;
        int _numExistingInstancesPerReplicaGroup;
        int _numDownInstances = 0;
        int _mapDimReplicaGroup;
        int _mapDimInstancePerReplicaGroup;
        HashMap<String, Integer> _usedInstances = new HashMap();
        int _numFaultDomains;
        int[][] _fdCounter;

        ReplicaGroupBasedAssignmentState(int numReplicaGroups, int numInstancesPerReplicaGroup, int numExistingReplicaGroups, int numExistingInstancesPerReplicaGroup, int numFaultDomains) {
            this._numFaultDomains = numFaultDomains;
            this._numReplicaGroups = numReplicaGroups;
            this._numInstancesPerReplicaGroup = numInstancesPerReplicaGroup;
            this._numExistingReplicaGroups = numExistingReplicaGroups;
            this._numExistingInstancesPerReplicaGroup = numExistingInstancesPerReplicaGroup;
            this._mapDimReplicaGroup = Math.max(numExistingReplicaGroups, numReplicaGroups);
            this._mapDimInstancePerReplicaGroup = Math.max(numExistingInstancesPerReplicaGroup, numInstancesPerReplicaGroup);
            this._replicaGroupIdToInstancesMap = new Instance[this._mapDimReplicaGroup][this._mapDimInstancePerReplicaGroup];
            this._fdCounter = new int[this._mapDimInstancePerReplicaGroup][this._numFaultDomains];
        }

        ReplicaGroupBasedAssignmentState(int numReplicaGroups, int numInstancesPerReplicaGroup, int numFaultDomains) {
            this(numReplicaGroups, numInstancesPerReplicaGroup, 0, numInstancesPerReplicaGroup, numFaultDomains);
        }

        public void preprocessing(Map<Integer, LinkedHashSet<String>> faultDomainToCandidateInstancesMap) {
            if (this._numReplicaGroups < this._numExistingReplicaGroups || this._numInstancesPerReplicaGroup < this._numExistingInstancesPerReplicaGroup) {
                throw new IllegalStateException("Downsizing unfinished");
            }
            for (Map.Entry<String, Integer> instanceFDPair : this.getUsedInstances().entrySet()) {
                faultDomainToCandidateInstancesMap.get(instanceFDPair.getValue()).remove(instanceFDPair.getKey());
            }
        }

        private void setNewInstance(int replicaGroupId, int instanceIndex, Instance instance) {
            Preconditions.checkState((instance.getExistingReplicaGroupId() == -1 ? 1 : 0) != 0);
            this._replicaGroupIdToInstancesMap[replicaGroupId][instanceIndex] = instance;
            this._usedInstances.put(instance.getInstanceName(), instance.getFaultDomainId());
            int[] nArray = this._fdCounter[instanceIndex];
            int n = instance.getFaultDomainId();
            nArray[n] = nArray[n] + 1;
        }

        private void setExistingInstance(int replicaGroupId, int instanceIndex, String instance, int fdId) {
            this._replicaGroupIdToInstancesMap[replicaGroupId][instanceIndex] = new Instance(instance, fdId, replicaGroupId);
            this._usedInstances.put(instance, fdId);
            int[] nArray = this._fdCounter[instanceIndex];
            int n = fdId;
            nArray[n] = nArray[n] + 1;
        }

        private void unSetInstance(int replicaGroupId, int instanceIndex) {
            int fdId = this._replicaGroupIdToInstancesMap[replicaGroupId][instanceIndex].getFaultDomainId();
            this._usedInstances.remove(this._replicaGroupIdToInstancesMap[replicaGroupId][instanceIndex].getInstanceName());
            this._replicaGroupIdToInstancesMap[replicaGroupId][instanceIndex] = null;
            int[] nArray = this._fdCounter[instanceIndex];
            int n = fdId;
            nArray[n] = nArray[n] - 1;
        }

        public void reconstructExistingAssignment(LinkedHashSet<String> existingReplicaGroup, int replicaGroupId, Map<String, Integer> aliveInstanceNameToFDMap) {
            int instanceIndex = 0;
            for (String instance : existingReplicaGroup) {
                int fdId = aliveInstanceNameToFDMap.getOrDefault(instance, -1);
                if (fdId != -1) {
                    Preconditions.checkState((this._replicaGroupIdToInstancesMap != null ? 1 : 0) != 0, (Object)"Error state, replicaGroupBasedAssignmentState is not initialized");
                    this.setExistingInstance(replicaGroupId, instanceIndex, instance, fdId);
                } else {
                    ++this._numDownInstances;
                }
                ++instanceIndex;
            }
        }

        public HashMap<String, Integer> getUsedInstances() {
            return this._usedInstances;
        }

        public void normalize(Map<Integer, LinkedHashSet<String>> faultDomainToCandidateInstancesMap) {
            LOGGER.info("Warning, normalizing isn't finished yet");
        }

        private boolean isEmpty(int replicaGroupId, int instanceId) {
            return this._replicaGroupIdToInstancesMap[replicaGroupId][instanceId] == null;
        }

        public void fill(Map<Integer, LinkedHashSet<String>> faultDomainToCandidateInstancesMap) {
            int j;
            int i;
            CandidateQueue candidateQueue = new CandidateQueue(faultDomainToCandidateInstancesMap);
            if (this._numReplicaGroups != 0) {
                for (int j2 = this._numExistingInstancesPerReplicaGroup; j2 < this._numInstancesPerReplicaGroup; ++j2) {
                    for (int i2 = 0; i2 < this._numReplicaGroups; ++i2) {
                        this.setNewInstance(i2, j2, candidateQueue.getNextCandidate());
                    }
                }
            }
            candidateQueue.seekKey(this._numExistingReplicaGroups * this._numExistingInstancesPerReplicaGroup % this._numFaultDomains);
            for (i = this._numExistingReplicaGroups; i < this._numReplicaGroups; ++i) {
                for (j = 0; j < this._numExistingInstancesPerReplicaGroup; ++j) {
                    int rotatedInstanceIter = j;
                    if (this._numExistingInstancesPerReplicaGroup % this._numFaultDomains == 0) {
                        rotatedInstanceIter = (rotatedInstanceIter + i) % this._numExistingInstancesPerReplicaGroup;
                    }
                    this.setNewInstance(i, rotatedInstanceIter, candidateQueue.getNextCandidate());
                }
            }
            for (i = 0; i < this._numExistingReplicaGroups; ++i) {
                for (j = 0; j < this._numExistingInstancesPerReplicaGroup; ++j) {
                    if (!this.isEmpty(i, j)) continue;
                    this.setNewInstance(i, j, candidateQueue.getNextCandidate());
                }
            }
        }

        public void swapToInvariantState() {
        }
    }

    private static class CandidateQueue {
        NavigableMap<Integer, Deque<String>> _map = new TreeMap<Integer, Deque<String>>();
        Integer _iter;

        CandidateQueue(Map<Integer, LinkedHashSet<String>> faultDomainToCandidateInstancesMap) {
            faultDomainToCandidateInstancesMap.entrySet().stream().filter(kv -> !((LinkedHashSet)kv.getValue()).isEmpty()).forEach(kv -> this._map.put((Integer)kv.getKey(), new LinkedList((Collection)kv.getValue())));
            this._iter = (Integer)this._map.firstKey();
        }

        void seekKey(int startKey) {
            if (this._map.containsKey(startKey)) {
                this._iter = startKey;
            } else {
                this._iter = this._map.ceilingKey(this._iter);
                this._iter = this._iter == null && !this._map.isEmpty() ? (Integer)this._map.firstKey() : this._iter;
            }
        }

        Instance getNextCandidate() {
            if (this._iter == null) {
                throw new IllegalStateException("Illegal state in fault-domain-aware assignment");
            }
            Instance ret = new Instance((String)((Deque)this._map.get(this._iter)).pollFirst(), this._iter, -1);
            if (((Deque)this._map.get(this._iter)).isEmpty()) {
                this._map.remove(this._iter);
            }
            this._iter = this._map.higherKey(this._iter);
            this._iter = this._iter == null && !this._map.isEmpty() ? (Integer)this._map.firstKey() : this._iter;
            return ret;
        }
    }
}

