/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.assignment.instance;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.helix.model.InstanceConfig;
import org.apache.pinot.common.assignment.InstancePartitions;
import org.apache.pinot.controller.helix.core.assignment.instance.InstancePartitionSelector;
import org.apache.pinot.spi.config.table.assignment.InstanceReplicaGroupPartitionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceReplicaGroupPartitionSelector
extends InstancePartitionSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceReplicaGroupPartitionSelector.class);

    public InstanceReplicaGroupPartitionSelector(InstanceReplicaGroupPartitionConfig replicaGroupPartitionConfig, String tableNameWithType, @Nullable InstancePartitions existingInstancePartitions, boolean minimizeDataMovement) {
        super(replicaGroupPartitionConfig, tableNameWithType, existingInstancePartitions, minimizeDataMovement);
    }

    @Override
    public void selectInstances(Map<Integer, List<InstanceConfig>> poolToInstanceConfigsMap, InstancePartitions instancePartitions) {
        int numPools = poolToInstanceConfigsMap.size();
        Preconditions.checkState((numPools != 0 ? 1 : 0) != 0, (Object)"No pool qualified for selection");
        int tableNameHash = Math.abs(this._tableNameWithType.hashCode());
        ArrayList<Integer> pools = new ArrayList<Integer>(poolToInstanceConfigsMap.keySet());
        pools.sort(null);
        LOGGER.info("Starting instance replica-group/partition selection for table: {} with hash: {} from pools: {}, minimize data movement: {}", new Object[]{this._tableNameWithType, tableNameHash, pools, this._minimizeDataMovement});
        if (this._replicaGroupPartitionConfig.isReplicaGroupBased()) {
            if (this._minimizeDataMovement) {
                this.replicaGroupBasedMinimumMovement(poolToInstanceConfigsMap, instancePartitions, pools, tableNameHash);
            } else {
                this.replicaGroupBasedSimple(poolToInstanceConfigsMap, instancePartitions, pools, tableNameHash);
            }
        } else {
            this.nonReplicaGroupBased(poolToInstanceConfigsMap, instancePartitions, pools, tableNameHash);
        }
    }

    private void nonReplicaGroupBased(Map<Integer, List<InstanceConfig>> poolToInstanceConfigsMap, InstancePartitions instancePartitions, List<Integer> pools, int tableNameHash) {
        List<String> instancesToSelect;
        int pool = pools.get(Math.abs(tableNameHash % pools.size()));
        LOGGER.info("Selecting pool: {} for table: {}", (Object)pool, (Object)this._tableNameWithType);
        List<InstanceConfig> instanceConfigs = poolToInstanceConfigsMap.get(pool);
        int numInstances = instanceConfigs.size();
        int numInstancesToSelect = this._replicaGroupPartitionConfig.getNumInstances();
        if (numInstancesToSelect > 0) {
            Preconditions.checkState((numInstancesToSelect <= numInstances ? 1 : 0) != 0, (String)"Not enough qualified instances from pool: %s (%s in the pool, asked for %s)", (Object)pool, (Object)numInstances, (Object)numInstancesToSelect);
        } else {
            numInstancesToSelect = numInstances;
        }
        if (this._minimizeDataMovement) {
            List existingInstances = this._existingInstancePartitions.getInstances(0, 0);
            LinkedHashSet candidateInstances = Sets.newLinkedHashSetWithExpectedSize((int)instanceConfigs.size());
            instanceConfigs.forEach(k -> candidateInstances.add(k.getInstanceName()));
            instancesToSelect = InstanceReplicaGroupPartitionSelector.selectInstancesWithMinimumMovement(numInstancesToSelect, candidateInstances, existingInstances);
            LOGGER.info("Selecting instances: {} for table: {}, existing instances: {}", new Object[]{instancesToSelect, this._tableNameWithType, existingInstances});
        } else {
            instancesToSelect = new ArrayList<String>(numInstancesToSelect);
            for (int i = 0; i < numInstancesToSelect; ++i) {
                instancesToSelect.add(instanceConfigs.get(i).getInstanceName());
            }
            LOGGER.info("Selecting instances: {} for table: {}", instancesToSelect, (Object)this._tableNameWithType);
        }
        instancePartitions.setInstances(0, 0, instancesToSelect);
    }

    private static List<String> selectInstancesWithMinimumMovement(int numInstancesToSelect, LinkedHashSet<String> candidateInstances, List<String> existingInstances) {
        ArrayList<String> instancesToSelect = new ArrayList<String>(numInstancesToSelect);
        for (int i = 0; i < numInstancesToSelect; ++i) {
            instancesToSelect.add(null);
        }
        int numInstancesToCheck = Math.min(numInstancesToSelect, existingInstances.size());
        for (int i = 0; i < numInstancesToCheck; ++i) {
            String existingInstance = existingInstances.get(i);
            if (!candidateInstances.remove(existingInstance)) continue;
            instancesToSelect.set(i, existingInstance);
        }
        Iterator iterator = candidateInstances.iterator();
        for (int i = 0; i < numInstancesToSelect; ++i) {
            if (instancesToSelect.get(i) != null) continue;
            instancesToSelect.set(i, (String)iterator.next());
        }
        return instancesToSelect;
    }

    private void replicaGroupBasedSimple(Map<Integer, List<InstanceConfig>> poolToInstanceConfigsMap, InstancePartitions instancePartitions, List<Integer> pools, int tableNameHash) {
        int numPools = pools.size();
        int numReplicaGroups = this.getNumReplicaGroups();
        TreeMap<Integer, List<Integer>> poolToReplicaGroupIdsMap = new TreeMap<Integer, List<Integer>>();
        int startIndex = Math.abs(tableNameHash % numPools);
        for (int replicaGroupId = 0; replicaGroupId < numReplicaGroups; ++replicaGroupId) {
            int pool = pools.get((startIndex + replicaGroupId) % numPools);
            poolToReplicaGroupIdsMap.computeIfAbsent(pool, k -> new ArrayList()).add(replicaGroupId);
        }
        LOGGER.info("Selecting {} replica-groups from pool: {} for table: {}", new Object[]{numReplicaGroups, poolToReplicaGroupIdsMap, this._tableNameWithType});
        int numInstancesPerReplicaGroup = this.getNumInstancesPerReplicaGroup(poolToInstanceConfigsMap, poolToReplicaGroupIdsMap);
        LOGGER.info("Selecting {} instances per replica-group for table: {}", (Object)numInstancesPerReplicaGroup, (Object)this._tableNameWithType);
        int numPartitions = this.getNumPartitions();
        int numInstancesPerPartition = this.getNumInstancesPerPartition(numInstancesPerReplicaGroup);
        LOGGER.info("Selecting {} partitions, {} instances per partition within a replica-group for table: {}", new Object[]{numPartitions, numInstancesPerPartition, this._tableNameWithType});
        String[][] replicaGroupIdToInstancesMap = new String[numReplicaGroups][numInstancesPerReplicaGroup];
        for (Map.Entry entry : poolToReplicaGroupIdsMap.entrySet()) {
            List<InstanceConfig> instanceConfigsInPool = poolToInstanceConfigsMap.get(entry.getKey());
            List replicaGroupIdsInPool = (List)entry.getValue();
            int instanceIdInPool = 0;
            for (int instanceIdInReplicaGroup = 0; instanceIdInReplicaGroup < numInstancesPerReplicaGroup; ++instanceIdInReplicaGroup) {
                Iterator iterator = replicaGroupIdsInPool.iterator();
                while (iterator.hasNext()) {
                    int replicaGroupId = (Integer)iterator.next();
                    replicaGroupIdToInstancesMap[replicaGroupId][instanceIdInReplicaGroup] = instanceConfigsInPool.get(instanceIdInPool++).getInstanceName();
                }
            }
        }
        for (int replicaGroupId = 0; replicaGroupId < numReplicaGroups; ++replicaGroupId) {
            String[] instancesInReplicaGroup = replicaGroupIdToInstancesMap[replicaGroupId];
            int instanceIdInReplicaGroup = 0;
            for (int partitionId = 0; partitionId < numPartitions; ++partitionId) {
                ArrayList<String> instances = new ArrayList<String>(numInstancesPerPartition);
                for (int i = 0; i < numInstancesPerPartition; ++i) {
                    instances.add(instancesInReplicaGroup[instanceIdInReplicaGroup]);
                    instanceIdInReplicaGroup = (instanceIdInReplicaGroup + 1) % numInstancesPerReplicaGroup;
                }
                LOGGER.info("Selecting instances: {} for replica-group: {}, partition: {} for table: {}", new Object[]{instances, replicaGroupId, partitionId, this._tableNameWithType});
                instancePartitions.setInstances(partitionId, replicaGroupId, instances);
            }
        }
    }

    private int getNumReplicaGroups() {
        int numReplicaGroups = this._replicaGroupPartitionConfig.getNumReplicaGroups();
        Preconditions.checkState((numReplicaGroups > 0 ? 1 : 0) != 0, (Object)"Number of replica-groups must be positive");
        return numReplicaGroups;
    }

    private int getNumInstancesPerReplicaGroup(Map<Integer, List<InstanceConfig>> poolToInstanceConfigsMap, Map<Integer, List<Integer>> poolToReplicaGroupIdsMap) {
        int numInstancesPerReplicaGroup = this._replicaGroupPartitionConfig.getNumInstancesPerReplicaGroup();
        if (numInstancesPerReplicaGroup > 0) {
            for (Map.Entry<Integer, List<Integer>> entry : poolToReplicaGroupIdsMap.entrySet()) {
                int pool = entry.getKey();
                int numInstancesInPool = poolToInstanceConfigsMap.get(pool).size();
                int numInstancesToSelect = numInstancesPerReplicaGroup * entry.getValue().size();
                Preconditions.checkState((numInstancesToSelect <= numInstancesInPool ? 1 : 0) != 0, (String)"Not enough qualified instances from pool: %s (%s in the pool, asked for %s)", (Object)pool, (Object)numInstancesInPool, (Object)numInstancesToSelect);
            }
        } else {
            numInstancesPerReplicaGroup = Integer.MAX_VALUE;
            for (Map.Entry<Integer, List<Integer>> entry : poolToReplicaGroupIdsMap.entrySet()) {
                int numInstancesInPool;
                int pool = entry.getKey();
                int numReplicaGroupsInPool = entry.getValue().size();
                Preconditions.checkState((numReplicaGroupsInPool <= (numInstancesInPool = poolToInstanceConfigsMap.get(pool).size()) ? 1 : 0) != 0, (String)"Not enough qualified instances from pool: %s, cannot select %s replica-groups from %s instances", (Object)pool, (Object)numReplicaGroupsInPool, (Object)numInstancesInPool);
                numInstancesPerReplicaGroup = Math.min(numInstancesPerReplicaGroup, numInstancesInPool / numReplicaGroupsInPool);
            }
        }
        return numInstancesPerReplicaGroup;
    }

    private int getNumPartitions() {
        int numPartitions = this._replicaGroupPartitionConfig.getNumPartitions();
        if (numPartitions <= 0) {
            numPartitions = 1;
        }
        return numPartitions;
    }

    private int getNumInstancesPerPartition(int numInstancesPerReplicaGroup) {
        int numInstancesPerPartition = this._replicaGroupPartitionConfig.getNumInstancesPerPartition();
        if (numInstancesPerPartition > 0) {
            Preconditions.checkState((numInstancesPerPartition <= numInstancesPerReplicaGroup ? 1 : 0) != 0, (String)"Number of instances per partition: %s must be smaller or equal to number of instances per replica-group: %s", (int)numInstancesPerPartition, (int)numInstancesPerReplicaGroup);
        } else {
            numInstancesPerPartition = numInstancesPerReplicaGroup;
        }
        return numInstancesPerPartition;
    }

    /*
     * WARNING - void declaration
     */
    private void replicaGroupBasedMinimumMovement(Map<Integer, List<InstanceConfig>> poolToInstanceConfigsMap, InstancePartitions instancePartitions, List<Integer> pools, int tableNameHash) {
        List<String> instances;
        List replicaGroupIds;
        int numPools = pools.size();
        int numReplicaGroups = this.getNumReplicaGroups();
        HashMap<String, Integer> instanceToPoolMap = new HashMap<String, Integer>();
        for (Map.Entry<Integer, List<InstanceConfig>> entry : poolToInstanceConfigsMap.entrySet()) {
            int pool = entry.getKey();
            for (InstanceConfig instanceConfig : entry.getValue()) {
                instanceToPoolMap.put(instanceConfig.getInstanceName(), pool);
            }
        }
        ArrayList replicaGroupIdToExistingInstancesMap = new ArrayList(numReplicaGroups);
        TreeMap<Integer, List<Integer>> poolToReplicaGroupIdsMap = new TreeMap<Integer, List<Integer>>();
        int maxReplicaGroupsPerPool = (numReplicaGroups + numPools - 1) / numPools;
        int startIndex = Math.abs(tableNameHash % numPools);
        int existingNumReplicaGroups = this._existingInstancePartitions.getNumReplicaGroups();
        int existingNumPartitions = this._existingInstancePartitions.getNumPartitions();
        block2: for (int replicaGroupId = 0; replicaGroupId < numReplicaGroups; ++replicaGroupId) {
            HashSet existingInstanceSet = new HashSet();
            replicaGroupIdToExistingInstancesMap.add(existingInstanceSet);
            TreeMap<Integer, Integer> poolToNumExistingInstancesMap = new TreeMap<Integer, Integer>();
            if (replicaGroupId < existingNumReplicaGroups) {
                for (int partitionId = 0; partitionId < existingNumPartitions; ++partitionId) {
                    List existingInstances = this._existingInstancePartitions.getInstances(partitionId, replicaGroupId);
                    existingInstanceSet.addAll(existingInstances);
                    for (String existingInstance : existingInstances) {
                        Integer existingPool = (Integer)instanceToPoolMap.get(existingInstance);
                        if (existingPool == null) continue;
                        poolToNumExistingInstancesMap.merge(existingPool, 1, Integer::sum);
                    }
                }
            }
            ArrayList<Triple> triples = new ArrayList<Triple>(numPools);
            for (int i = 0; i < numPools; ++i) {
                int pool = pools.get((startIndex + replicaGroupId + i) % numPools);
                triples.add(Triple.of((Object)pool, (Object)poolToNumExistingInstancesMap.getOrDefault(pool, 0), (Object)i));
            }
            triples.sort((o1, o2) -> {
                int result = Integer.compare((Integer)o2.getMiddle(), (Integer)o1.getMiddle());
                return result != 0 ? result : Integer.compare((Integer)o1.getRight(), (Integer)o2.getRight());
            });
            for (Triple triple : triples) {
                int pool = (Integer)triple.getLeft();
                replicaGroupIds = poolToReplicaGroupIdsMap.computeIfAbsent(pool, k -> new ArrayList());
                if (replicaGroupIds.size() >= maxReplicaGroupsPerPool) continue;
                replicaGroupIds.add(replicaGroupId);
                continue block2;
            }
        }
        LOGGER.info("Selecting {} replica-groups from pool: {} for table: {}", new Object[]{numReplicaGroups, poolToReplicaGroupIdsMap, this._tableNameWithType});
        int numInstancesPerReplicaGroup = this.getNumInstancesPerReplicaGroup(poolToInstanceConfigsMap, poolToReplicaGroupIdsMap);
        LOGGER.info("Selecting {} instances per replica-group for table: {}", (Object)numInstancesPerReplicaGroup, (Object)this._tableNameWithType);
        int numPartitions = this.getNumPartitions();
        int numInstancesPerPartition = this.getNumInstancesPerPartition(numInstancesPerReplicaGroup);
        LOGGER.info("Selecting {} partitions, {} instances per partition within a replica-group for table: {}", new Object[]{numPartitions, numInstancesPerPartition, this._tableNameWithType});
        ArrayList replicaGroupIdToInstancesMap = new ArrayList(numReplicaGroups);
        for (int i = 0; i < numReplicaGroups; ++i) {
            replicaGroupIdToInstancesMap.add(new ArrayList(numInstancesPerReplicaGroup));
        }
        for (Map.Entry entry : poolToReplicaGroupIdsMap.entrySet()) {
            void var24_49;
            int replicaGroupId;
            Iterator iterator;
            int pool = (Integer)entry.getKey();
            replicaGroupIds = (List)entry.getValue();
            ArrayList<String> newInstances = new ArrayList<String>();
            for (InstanceConfig instanceConfig : poolToInstanceConfigsMap.get(pool)) {
                String instanceName = instanceConfig.getInstanceName();
                boolean isExistingInstance = false;
                iterator = replicaGroupIds.iterator();
                while (iterator.hasNext()) {
                    replicaGroupId = (Integer)iterator.next();
                    List instances2 = (List)replicaGroupIdToInstancesMap.get(replicaGroupId);
                    if (instances2.size() == numInstancesPerReplicaGroup || !((Set)replicaGroupIdToExistingInstancesMap.get(replicaGroupId)).contains(instanceName)) continue;
                    instances2.add(instanceName);
                    isExistingInstance = true;
                    break;
                }
                if (isExistingInstance) continue;
                newInstances.add(instanceName);
            }
            int numInstancesToFill = numInstancesPerReplicaGroup * replicaGroupIds.size();
            Iterator iterator2 = replicaGroupIds.iterator();
            while (iterator2.hasNext()) {
                int replicaGroupId2 = (Integer)iterator2.next();
                numInstancesToFill -= ((List)replicaGroupIdToInstancesMap.get(replicaGroupId2)).size();
            }
            boolean bl = false;
            while (var24_49 < numInstancesToFill) {
                int leastNumInstances = Integer.MAX_VALUE;
                int replicaGroupIdWithLeastInstances = -1;
                iterator = replicaGroupIds.iterator();
                while (iterator.hasNext()) {
                    replicaGroupId = (Integer)iterator.next();
                    int numInstances = ((List)replicaGroupIdToInstancesMap.get(replicaGroupId)).size();
                    if (numInstances >= leastNumInstances) continue;
                    leastNumInstances = numInstances;
                    replicaGroupIdWithLeastInstances = replicaGroupId;
                }
                ((List)replicaGroupIdToInstancesMap.get(replicaGroupIdWithLeastInstances)).add((String)newInstances.get((int)var24_49));
                ++var24_49;
            }
        }
        if (numPartitions == 1) {
            for (int replicaGroupId = 0; replicaGroupId < numReplicaGroups; ++replicaGroupId) {
                List instancesInReplicaGroup = (List)replicaGroupIdToInstancesMap.get(replicaGroupId);
                if (replicaGroupId < existingNumReplicaGroups) {
                    List existingInstances = this._existingInstancePartitions.getInstances(0, replicaGroupId);
                    LinkedHashSet<String> candidateInstances = new LinkedHashSet<String>(instancesInReplicaGroup);
                    instances = InstanceReplicaGroupPartitionSelector.selectInstancesWithMinimumMovement(numInstancesPerReplicaGroup, candidateInstances, existingInstances);
                    LOGGER.info("Selecting instances: {} for replica-group: {}, partition: 0 for table: {}, existing instances: {}", new Object[]{instances, replicaGroupId, this._tableNameWithType, existingInstances});
                    instancePartitions.setInstances(0, replicaGroupId, instances);
                    continue;
                }
                LOGGER.info("Selecting instances: {} for replica-group: {}, partition: 0 for table: {}, there is no existing instances", new Object[]{instancesInReplicaGroup, replicaGroupId, this._tableNameWithType});
                instancePartitions.setInstances(0, replicaGroupId, instancesInReplicaGroup);
            }
        } else {
            for (int replicaGroupId = 0; replicaGroupId < numReplicaGroups; ++replicaGroupId) {
                List instancesInReplicaGroup = (List)replicaGroupIdToInstancesMap.get(replicaGroupId);
                if (replicaGroupId < existingNumReplicaGroups) {
                    int i;
                    Set instanceSet;
                    int partitionId;
                    int maxNumPartitionsPerInstance = (numInstancesPerReplicaGroup + numPartitions - 1) / numPartitions;
                    HashMap instanceToNumPartitionsMap = Maps.newHashMapWithExpectedSize((int)numInstancesPerReplicaGroup);
                    for (String instance : instancesInReplicaGroup) {
                        instanceToNumPartitionsMap.put(instance, 0);
                    }
                    ArrayList partitionIdToInstancesMap = new ArrayList(numPartitions);
                    ArrayList<Set> partitionIdToInstanceSetMap = new ArrayList<Set>(numPartitions);
                    ArrayList<List> arrayList = new ArrayList<List>(existingNumPartitions);
                    for (partitionId = 0; partitionId < numPartitions; ++partitionId) {
                        ArrayList<String> instances3 = new ArrayList<String>(numInstancesPerPartition);
                        for (int i2 = 0; i2 < numInstancesPerPartition; ++i2) {
                            instances3.add(null);
                        }
                        partitionIdToInstancesMap.add(instances3);
                        instanceSet = Sets.newHashSetWithExpectedSize((int)numInstancesPerPartition);
                        partitionIdToInstanceSetMap.add(instanceSet);
                        if (partitionId >= existingNumPartitions) continue;
                        List existingInstances = this._existingInstancePartitions.getInstances(partitionId, replicaGroupId);
                        arrayList.add(existingInstances);
                        int numInstancesToCheck = Math.min(numInstancesPerPartition, existingInstances.size());
                        for (i = 0; i < numInstancesToCheck; ++i) {
                            String existingInstance = (String)existingInstances.get(i);
                            Integer numPartitionsOnInstance = (Integer)instanceToNumPartitionsMap.get(existingInstance);
                            if (numPartitionsOnInstance == null || numPartitionsOnInstance >= maxNumPartitionsPerInstance) continue;
                            instances3.set(i, existingInstance);
                            instanceSet.add(existingInstance);
                            instanceToNumPartitionsMap.put(existingInstance, numPartitionsOnInstance + 1);
                        }
                    }
                    for (partitionId = 0; partitionId < numPartitions; ++partitionId) {
                        List instances2 = (List)partitionIdToInstancesMap.get(partitionId);
                        instanceSet = (Set)partitionIdToInstanceSetMap.get(partitionId);
                        int numInstancesToFill = numInstancesPerPartition - instanceSet.size();
                        if (numInstancesToFill > 0) {
                            ArrayList<Triple> triples = new ArrayList<Triple>(numInstancesPerReplicaGroup);
                            for (i = 0; i < numInstancesPerReplicaGroup; ++i) {
                                String instance = (String)instancesInReplicaGroup.get(i);
                                if (instanceSet.contains(instance)) continue;
                                triples.add(Triple.of((Object)instance, (Object)((Integer)instanceToNumPartitionsMap.get(instance)), (Object)i));
                            }
                            triples.sort((o1, o2) -> {
                                int result = Integer.compare((Integer)o1.getMiddle(), (Integer)o2.getMiddle());
                                return result != 0 ? result : Integer.compare((Integer)o1.getRight(), (Integer)o2.getRight());
                            });
                            int instanceIdToFill = 0;
                            for (int i3 = 0; i3 < numInstancesPerPartition; ++i3) {
                                if (instances2.get(i3) != null) continue;
                                String instance = (String)((Triple)triples.get(instanceIdToFill++)).getLeft();
                                instances2.set(i3, instance);
                                instanceToNumPartitionsMap.put(instance, (Integer)instanceToNumPartitionsMap.get(instance) + 1);
                            }
                        }
                        if (partitionId < existingNumPartitions) {
                            LOGGER.info("Selecting instances: {} for replica-group: {}, partition: {} for table: {}, existing instances: {}", new Object[]{instances2, replicaGroupId, partitionId, this._tableNameWithType, arrayList.get(partitionId)});
                        } else {
                            LOGGER.info("Selecting instances: {} for replica-group: {}, partition: {} for table: {}, there is no existing instances", new Object[]{instances2, replicaGroupId, partitionId, this._tableNameWithType});
                        }
                        instancePartitions.setInstances(partitionId, replicaGroupId, instances2);
                    }
                    continue;
                }
                int instanceIdInReplicaGroup = 0;
                for (int partitionId = 0; partitionId < numPartitions; ++partitionId) {
                    instances = new ArrayList(numInstancesPerPartition);
                    for (int i = 0; i < numInstancesPerPartition; ++i) {
                        instances.add((String)instancesInReplicaGroup.get(instanceIdInReplicaGroup));
                        instanceIdInReplicaGroup = (instanceIdInReplicaGroup + 1) % numInstancesPerReplicaGroup;
                    }
                    LOGGER.info("Selecting instances: {} for replica-group: {}, partition: {} for table: {}, there is no existing instances", new Object[]{instances, replicaGroupId, partitionId, this._tableNameWithType});
                    instancePartitions.setInstances(partitionId, replicaGroupId, instances);
                }
            }
        }
    }
}

