/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.assignment.instance;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.helix.model.InstanceConfig;
import org.apache.pinot.common.assignment.InstancePartitions;
import org.apache.pinot.spi.config.table.assignment.InstanceTagPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceTagPoolSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceTagPoolSelector.class);
    private final InstanceTagPoolConfig _tagPoolConfig;
    private final String _tableNameWithType;
    private final boolean _minimizeDataMovement;
    private final InstancePartitions _existingInstancePartitions;

    public InstanceTagPoolSelector(InstanceTagPoolConfig tagPoolConfig, String tableNameWithType, boolean minimizeDataMovement, @Nullable InstancePartitions existingInstancePartitions) {
        this._tagPoolConfig = tagPoolConfig;
        this._tableNameWithType = tableNameWithType;
        this._minimizeDataMovement = minimizeDataMovement && existingInstancePartitions != null;
        this._existingInstancePartitions = existingInstancePartitions;
    }

    /*
     * WARNING - void declaration
     */
    public Map<Integer, List<InstanceConfig>> selectInstances(List<InstanceConfig> instanceConfigs) {
        int tableNameHash = Math.abs(this._tableNameWithType.hashCode());
        LOGGER.info("Starting instance tag/pool selection for table: {} with hash: {}", (Object)this._tableNameWithType, (Object)tableNameHash);
        String tag = this._tagPoolConfig.getTag();
        ArrayList<InstanceConfig> candidateInstanceConfigs = new ArrayList<InstanceConfig>();
        for (InstanceConfig instanceConfig : instanceConfigs) {
            if (!instanceConfig.getTags().contains(tag)) continue;
            candidateInstanceConfigs.add(instanceConfig);
        }
        candidateInstanceConfigs.sort(Comparator.comparing(InstanceConfig::getInstanceName));
        int numCandidateInstances = candidateInstanceConfigs.size();
        Preconditions.checkState((numCandidateInstances > 0 ? 1 : 0) != 0, (String)"No enabled instance has the tag: %s", (Object)tag);
        LOGGER.info("{} enabled instances have the tag: {} for table: {}", new Object[]{numCandidateInstances, tag, this._tableNameWithType});
        TreeMap<Integer, List<InstanceConfig>> poolToInstanceConfigsMap = new TreeMap<Integer, List<InstanceConfig>>();
        if (this._tagPoolConfig.isPoolBased()) {
            void var10_18;
            HashMap<String, Integer> instanceToPoolMap = new HashMap<String, Integer>();
            for (InstanceConfig instanceConfig : candidateInstanceConfigs) {
                Map map = instanceConfig.getRecord().getMapField("pool");
                if (map == null || !map.containsKey(tag)) continue;
                int pool = Integer.parseInt((String)map.get(tag));
                poolToInstanceConfigsMap.computeIfAbsent(pool, k -> new ArrayList()).add(instanceConfig);
                instanceToPoolMap.put(instanceConfig.getInstanceName(), pool);
            }
            Preconditions.checkState((!poolToInstanceConfigsMap.isEmpty() ? 1 : 0) != 0, (String)"No enabled instance has the pool configured for the tag: %s", (Object)tag);
            TreeMap<Integer, Integer> poolToNumInstancesMap = new TreeMap<Integer, Integer>();
            for (Map.Entry entry : poolToInstanceConfigsMap.entrySet()) {
                poolToNumInstancesMap.put((Integer)entry.getKey(), ((List)entry.getValue()).size());
            }
            LOGGER.info("Number instances for each pool: {} for table: {}", poolToNumInstancesMap, (Object)this._tableNameWithType);
            Set set = poolToInstanceConfigsMap.keySet();
            List list = this._tagPoolConfig.getPools();
            if (!CollectionUtils.isEmpty((Collection)list)) {
                Preconditions.checkState((boolean)set.containsAll(list), (String)"Cannot find all instance pools configured: %s", (Object)list);
            } else {
                int numPools = poolToInstanceConfigsMap.size();
                int numPoolsToSelect = this._tagPoolConfig.getNumPools();
                if (numPoolsToSelect > 0) {
                    Preconditions.checkState((numPoolsToSelect <= numPools ? 1 : 0) != 0, (String)"Not enough instance pools (%s in the cluster, asked for %s)", (int)numPools, (int)numPoolsToSelect);
                } else {
                    numPoolsToSelect = numPools;
                }
                if (numPools == numPoolsToSelect) {
                    LOGGER.info("Selecting all {} pools: {} for table: {}", new Object[]{numPools, set, this._tableNameWithType});
                    return poolToInstanceConfigsMap;
                }
                ArrayList poolsInCluster = new ArrayList(set);
                int startIndex = Math.abs(tableNameHash % numPools);
                ArrayList<Integer> arrayList = new ArrayList<Integer>(numPoolsToSelect);
                if (this._minimizeDataMovement) {
                    int i;
                    assert (this._existingInstancePartitions != null);
                    TreeMap<Integer, Integer> poolToNumExistingInstancesMap = new TreeMap<Integer, Integer>();
                    int existingNumPartitions = this._existingInstancePartitions.getNumPartitions();
                    int existingNumReplicaGroups = this._existingInstancePartitions.getNumReplicaGroups();
                    for (int partitionId = 0; partitionId < existingNumPartitions; ++partitionId) {
                        for (int replicaGroupId = 0; replicaGroupId < existingNumReplicaGroups; ++replicaGroupId) {
                            List existingInstances = this._existingInstancePartitions.getInstances(partitionId, replicaGroupId);
                            for (String existingInstance : existingInstances) {
                                Integer existingPool = (Integer)instanceToPoolMap.get(existingInstance);
                                if (existingPool == null) continue;
                                poolToNumExistingInstancesMap.merge(existingPool, 1, Integer::sum);
                            }
                        }
                    }
                    ArrayList<Triple> triples = new ArrayList<Triple>(numPools);
                    for (i = 0; i < numPools; ++i) {
                        int pool = (Integer)poolsInCluster.get((startIndex + i) % numPools);
                        triples.add(Triple.of((Object)pool, (Object)poolToNumExistingInstancesMap.getOrDefault(pool, 0), (Object)i));
                    }
                    triples.sort((o1, o2) -> {
                        int result = Integer.compare((Integer)o2.getMiddle(), (Integer)o1.getMiddle());
                        return result != 0 ? result : Integer.compare((Integer)o1.getRight(), (Integer)o2.getRight());
                    });
                    for (i = 0; i < numPoolsToSelect; ++i) {
                        arrayList.add((Integer)((Triple)triples.get(i)).getLeft());
                    }
                } else {
                    for (int i = 0; i < numPoolsToSelect; ++i) {
                        arrayList.add((Integer)poolsInCluster.get((startIndex + i) % numPools));
                    }
                }
            }
            LOGGER.info("Selecting pools: {} for table: {}", (Object)var10_18, (Object)this._tableNameWithType);
            set.retainAll((Collection<?>)var10_18);
        } else {
            LOGGER.info("Selecting {} instances for table: {}", (Object)numCandidateInstances, (Object)this._tableNameWithType);
            poolToInstanceConfigsMap.put(0, candidateInstanceConfigs);
        }
        return poolToInstanceConfigsMap;
    }
}

