/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.assignment.instance;

import com.google.common.base.Preconditions;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.helix.model.InstanceConfig;
import org.apache.pinot.common.assignment.InstancePartitions;
import org.apache.pinot.controller.helix.core.assignment.instance.InstancePartitionSelector;
import org.apache.pinot.spi.config.table.assignment.InstanceReplicaGroupPartitionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MirrorServerSetInstancePartitionSelector
extends InstancePartitionSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(MirrorServerSetInstancePartitionSelector.class);
    private final InstancePartitions _preConfiguredInstancePartitions;
    private final int _numTargetInstancesPerReplicaGroup;
    private final int _numTargetReplicaGroups;
    private final int _numTargetTotalInstances;
    private final List<List<String>> _preConfiguredMirroredServerLists = new ArrayList<List<String>>();
    private final Map<String, Integer> _preConfiguredInstanceNameToOffsetMap = new HashMap<String, Integer>();
    private final List<List<String>> _existingMirroredServerLists = new ArrayList<List<String>>();
    private int _numPreConfiguredReplicaGroups;
    private int _numPreConfiguredInstancesPerReplicaGroup;
    private int _numExistingReplicaGroups;
    private int _numExistingInstancesPerReplicaGroup;

    public MirrorServerSetInstancePartitionSelector(InstanceReplicaGroupPartitionConfig replicaGroupPartitionConfig, String tableNameWithType, @Nullable InstancePartitions existingInstancePartitions, InstancePartitions preConfiguredInstancePartitions, boolean minimizeDataMovement) {
        super(replicaGroupPartitionConfig, tableNameWithType, existingInstancePartitions, minimizeDataMovement);
        this._preConfiguredInstancePartitions = preConfiguredInstancePartitions;
        this._numTargetInstancesPerReplicaGroup = this._replicaGroupPartitionConfig.getNumInstancesPerReplicaGroup();
        this._numTargetReplicaGroups = this._replicaGroupPartitionConfig.getNumReplicaGroups();
        this._numTargetTotalInstances = this._numTargetInstancesPerReplicaGroup * this._numTargetReplicaGroups;
    }

    private void validatePoolDiversePreconditions(Map<Integer, List<InstanceConfig>> poolToInstanceConfigsMap) {
        LOGGER.info("Validating pre-configured instance partitions for pre-configuration based replica-group selection");
        LOGGER.info("Number of instances per replica: {}", (Object)this._numTargetInstancesPerReplicaGroup);
        Preconditions.checkState((this._numTargetInstancesPerReplicaGroup > 0 ? 1 : 0) != 0, (Object)"Number of instances per replica must be positive");
        LOGGER.info("Number of replica-groups: {}", (Object)this._numTargetReplicaGroups);
        Preconditions.checkState((this._numTargetReplicaGroups > 0 ? 1 : 0) != 0, (Object)"Number of replica-groups must be positive");
        LOGGER.info("Number of partitions: {}", (Object)this._replicaGroupPartitionConfig.getNumPartitions());
        Preconditions.checkState((this._replicaGroupPartitionConfig.getNumPartitions() <= 1 ? 1 : 0) != 0, (Object)"This algorithm does not support table level partitioning for target assignment");
        LOGGER.info("Number of partitions in existing instance partitions: {}", (Object)(this._existingInstancePartitions == null ? 0 : this._existingInstancePartitions.getNumPartitions()));
        Preconditions.checkState((this._existingInstancePartitions == null || this._existingInstancePartitions.getNumPartitions() == 1 ? 1 : 0) != 0, (Object)"This algorithm does not support replica group level partitioning for existing assignment");
        this._numExistingReplicaGroups = this._existingInstancePartitions == null ? 0 : this._existingInstancePartitions.getNumReplicaGroups();
        this._numExistingInstancesPerReplicaGroup = this._existingInstancePartitions == null ? 0 : this._existingInstancePartitions.getInstances(0, 0).size();
        Preconditions.checkState((this._preConfiguredInstancePartitions != null ? 1 : 0) != 0, (Object)"Pre-configured instance partitions must be provided for pre-configuration based selection");
        LOGGER.info("Number of partitions in pre-configured instance partitions: {}", (Object)this._preConfiguredInstancePartitions.getNumPartitions());
        Preconditions.checkState((this._preConfiguredInstancePartitions.getNumPartitions() == 1 ? 1 : 0) != 0, (Object)"This algorithm does not support table level partitioning for pre-configured assignment");
        this._numPreConfiguredReplicaGroups = this._preConfiguredInstancePartitions.getNumReplicaGroups();
        LOGGER.info("Number of replica-groups in pre-configured instance partitions: {}", (Object)this._numPreConfiguredReplicaGroups);
        Preconditions.checkState((this._numPreConfiguredReplicaGroups == this._numTargetReplicaGroups ? 1 : 0) != 0, (String)"The number of replica-groups %s in the pre-configured instance partitions is not equal to the target number of replica-groups %s", (int)this._numPreConfiguredReplicaGroups, (int)this._numTargetReplicaGroups);
        this._numPreConfiguredInstancesPerReplicaGroup = this._preConfiguredInstancePartitions.getInstances(0, 0).size();
        LOGGER.info("Number of instances per replica-group in pre-configured instance partitions: {}, target number of instances per replica-group: {}", (Object)this._numPreConfiguredInstancesPerReplicaGroup, (Object)this._numTargetInstancesPerReplicaGroup);
        Preconditions.checkState((this._numPreConfiguredInstancesPerReplicaGroup >= this._numTargetInstancesPerReplicaGroup ? 1 : 0) != 0, (String)"The number of instances per replica-group in the pre-configured instance partitions is less than the target number of instances per replica-group %s", (int)this._numTargetInstancesPerReplicaGroup);
        Preconditions.checkNotNull(poolToInstanceConfigsMap, (Object)"poolToInstanceConfigsMap is null");
        int numPools = poolToInstanceConfigsMap.size();
        Preconditions.checkState((numPools > 0 ? 1 : 0) != 0, (Object)"No pool qualified for selection");
        Integer totalInstanceCount = poolToInstanceConfigsMap.values().stream().map(List::size).reduce(Integer::sum).orElse(0);
        LOGGER.info("Total number of instances in all pools: {}, target number of instances: {}", (Object)totalInstanceCount, (Object)this._numTargetTotalInstances);
        Preconditions.checkState((totalInstanceCount >= this._numTargetTotalInstances ? 1 : 0) != 0, (Object)"The total number of instances in all pools is less than the target number of target instances");
        HashSet availableInstanceSet = new HashSet();
        poolToInstanceConfigsMap.values().forEach(list -> list.forEach(i -> availableInstanceSet.add(i.getInstanceName())));
        LOGGER.info("Number of pools: {}", (Object)numPools);
        LOGGER.info("Number of instances in all pools: {}", (Object)availableInstanceSet.size());
        LOGGER.info("availableInstanceSet: {}", availableInstanceSet);
        for (int i = 0; i < this._numPreConfiguredReplicaGroups; ++i) {
            List instances = this._preConfiguredInstancePartitions.getInstances(0, i);
            for (String instance : instances) {
                Preconditions.checkState((boolean)availableInstanceSet.contains(instance), (String)"Instance %s in pre-configured instance partitions is not in the pool to instance configs map", (Object)instance);
            }
        }
        LOGGER.info("Validation passed. The instances provided can satisfy the pool diverse requirement.");
        LOGGER.info("Trying to assign total {} instances to {} replica groups, with {} instance per replica group", new Object[]{this._numTargetTotalInstances, this._numTargetReplicaGroups, this._numTargetInstancesPerReplicaGroup});
    }

    private void createMirrorServerListFromPreconfiguredInstancePartition() {
        ArrayList<List> preConfiguredReplicaGroups = new ArrayList<List>(this._numPreConfiguredReplicaGroups);
        for (int i = 0; i < this._numPreConfiguredReplicaGroups; ++i) {
            preConfiguredReplicaGroups.add(this._preConfiguredInstancePartitions.getInstances(0, i));
        }
        for (int j = 0; j < this._numPreConfiguredInstancesPerReplicaGroup; ++j) {
            ArrayList<String> mirroredServerList = new ArrayList<String>();
            for (int i = 0; i < this._numPreConfiguredReplicaGroups; ++i) {
                mirroredServerList.add((String)((List)preConfiguredReplicaGroups.get(i)).get(j));
            }
            this._preConfiguredMirroredServerLists.add(mirroredServerList);
        }
    }

    private void createMirrorServerListLookupTablesFromPreconfiguredInstancePartition() {
        int i;
        ArrayList<List> preConfiguredReplicaGroups = new ArrayList<List>(this._numPreConfiguredReplicaGroups);
        for (i = 0; i < this._numPreConfiguredReplicaGroups; ++i) {
            preConfiguredReplicaGroups.add(this._preConfiguredInstancePartitions.getInstances(0, i));
        }
        for (i = 0; i < this._numPreConfiguredReplicaGroups; ++i) {
            for (int j = 0; j < this._numPreConfiguredInstancesPerReplicaGroup; ++j) {
                String instance = (String)((List)preConfiguredReplicaGroups.get(i)).get(j);
                this._preConfiguredInstanceNameToOffsetMap.put(instance, j);
            }
        }
    }

    @Override
    public void selectInstances(Map<Integer, List<InstanceConfig>> poolToInstanceConfigsMap, InstancePartitions instancePartitions) {
        if (!this._replicaGroupPartitionConfig.isReplicaGroupBased()) {
            throw new IllegalStateException("Does not support Non-replica-group based selection");
        }
        this.validatePoolDiversePreconditions(poolToInstanceConfigsMap);
        if (this._existingInstancePartitions == null) {
            this.initialAssignment(instancePartitions);
        } else {
            this.scale(instancePartitions);
        }
    }

    private void initialAssignment(InstancePartitions instancePartitions) {
        int i;
        LOGGER.info("No existing instance partitions found. Will build new on top of the pre-configured instance partitions");
        this.createMirrorServerListFromPreconfiguredInstancePartition();
        int tableNameHash = Math.abs(this._tableNameWithType.hashCode());
        List shuffledIndex = new ArrayList<Integer>(this._numPreConfiguredInstancesPerReplicaGroup);
        for (int i2 = 0; i2 < this._numPreConfiguredInstancesPerReplicaGroup; ++i2) {
            shuffledIndex.add(i2);
        }
        Collections.shuffle(shuffledIndex, new Random(tableNameHash));
        shuffledIndex = shuffledIndex.subList(0, this._numTargetInstancesPerReplicaGroup);
        shuffledIndex.sort(Comparator.naturalOrder());
        ArrayList resultReplicaGroups = new ArrayList(this._numTargetReplicaGroups);
        for (i = 0; i < this._numTargetReplicaGroups; ++i) {
            resultReplicaGroups.add(new ArrayList(this._numTargetInstancesPerReplicaGroup));
        }
        for (int j = 0; j < this._numTargetInstancesPerReplicaGroup; ++j) {
            for (int i3 = 0; i3 < this._numTargetReplicaGroups; ++i3) {
                ((List)resultReplicaGroups.get(i3)).add(this._preConfiguredMirroredServerLists.get((Integer)shuffledIndex.get(j)).get(i3));
            }
        }
        for (i = 0; i < this._numTargetReplicaGroups; ++i) {
            instancePartitions.setInstances(0, i, (List)resultReplicaGroups.get(i));
        }
    }

    private void scale(InstancePartitions instancePartitions) {
        int i;
        int j;
        LOGGER.info("Existing instance partitions found. Will adjust the existing instance partitions based on the pre-configured instance partitions");
        this.createMirrorServerListFromPreconfiguredInstancePartition();
        this.createMirrorServerListLookupTablesFromPreconfiguredInstancePartition();
        this.createListAndLookupTablesFromExistingInstancePartitions();
        HashSet<Integer> usedPreconfiguredInstanceOffsets = new HashSet<Integer>();
        HashMap<Integer, Map.Entry> existingOffsetToResultTuple = new HashMap<Integer, Map.Entry>();
        int j2 = 0;
        while (j2 < this._numExistingInstancesPerReplicaGroup) {
            List<String> existingMirroredServers = this._existingMirroredServerLists.get(j2);
            int finalJ = j2++;
            existingMirroredServers.stream().map(this._preConfiguredInstanceNameToOffsetMap::get).filter(Objects::nonNull).filter(offset -> !usedPreconfiguredInstanceOffsets.contains(offset)).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().max(Map.Entry.comparingByValue()).ifPresent(e -> {
                existingOffsetToResultTuple.put(finalJ, (Map.Entry)e);
                usedPreconfiguredInstanceOffsets.add((Integer)e.getKey());
            });
        }
        if (this._numExistingInstancesPerReplicaGroup > this._numTargetInstancesPerReplicaGroup) {
            List collect = existingOffsetToResultTuple.values().stream().sorted((a, b) -> ((Long)b.getValue()).compareTo((Long)a.getValue())).limit(this._numTargetInstancesPerReplicaGroup).collect(Collectors.toList());
            int size = collect.size();
            existingOffsetToResultTuple.clear();
            usedPreconfiguredInstanceOffsets.clear();
            for (j = 0; j < size; ++j) {
                existingOffsetToResultTuple.put(j, (Map.Entry)collect.get(j));
                usedPreconfiguredInstanceOffsets.add((Integer)((Map.Entry)collect.get(j)).getKey());
            }
        }
        if (existingOffsetToResultTuple.size() < this._numTargetInstancesPerReplicaGroup) {
            List shuffledOffsets = new ArrayList<Integer>(this._numPreConfiguredInstancesPerReplicaGroup);
            for (int j3 = 0; j3 < this._numPreConfiguredInstancesPerReplicaGroup; ++j3) {
                shuffledOffsets.add(j3);
            }
            for (Map.Entry entry : existingOffsetToResultTuple.entrySet()) {
                shuffledOffsets.remove(((Map.Entry)entry.getValue()).getKey());
            }
            Collections.shuffle(shuffledOffsets, new Random(Math.abs(this._tableNameWithType.hashCode())));
            shuffledOffsets = shuffledOffsets.subList(0, this._numTargetInstancesPerReplicaGroup - existingOffsetToResultTuple.size());
            shuffledOffsets.sort(Comparator.naturalOrder());
            int k = 0;
            for (j = 0; j < this._numTargetInstancesPerReplicaGroup; ++j) {
                if (existingOffsetToResultTuple.containsKey(j)) continue;
                Integer offset2 = (Integer)shuffledOffsets.get(k++);
                existingOffsetToResultTuple.put(j, new AbstractMap.SimpleEntry<Integer, Long>(offset2, 0L));
                usedPreconfiguredInstanceOffsets.add(offset2);
            }
        }
        ArrayList resultReplicaGroups = new ArrayList(this._numTargetReplicaGroups);
        for (i = 0; i < this._numTargetReplicaGroups; ++i) {
            resultReplicaGroups.add(new ArrayList(this._numTargetInstancesPerReplicaGroup));
        }
        for (int j4 = 0; j4 < this._numTargetInstancesPerReplicaGroup; ++j4) {
            List<String> mirrorServers = this._preConfiguredMirroredServerLists.get((Integer)((Map.Entry)existingOffsetToResultTuple.get(j4)).getKey());
            for (int i2 = 0; i2 < this._numTargetReplicaGroups; ++i2) {
                ((List)resultReplicaGroups.get(i2)).add(mirrorServers.get(i2));
            }
        }
        for (i = 0; i < this._numTargetReplicaGroups; ++i) {
            instancePartitions.setInstances(0, i, (List)resultReplicaGroups.get(i));
        }
    }

    private void createListAndLookupTablesFromExistingInstancePartitions() {
        ArrayList<List> existingReplicaGroups = new ArrayList<List>(this._numExistingReplicaGroups);
        for (int i = 0; i < this._numExistingReplicaGroups; ++i) {
            existingReplicaGroups.add(this._existingInstancePartitions.getInstances(0, i));
        }
        for (int j = 0; j < this._numExistingInstancesPerReplicaGroup; ++j) {
            ArrayList<String> existingMirroredServerList = new ArrayList<String>();
            for (int i = 0; i < this._numExistingReplicaGroups; ++i) {
                existingMirroredServerList.add((String)((List)existingReplicaGroups.get(i)).get(j));
            }
            this._existingMirroredServerLists.add(existingMirroredServerList);
        }
    }
}

