/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.assignment.segment;

import javax.annotation.Nullable;
import org.apache.helix.HelixManager;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.controller.helix.core.assignment.segment.BaseSegmentAssignment;
import org.apache.pinot.controller.helix.core.assignment.segment.OfflineSegmentAssignment;
import org.apache.pinot.controller.helix.core.assignment.segment.RealtimeSegmentAssignment;
import org.apache.pinot.controller.helix.core.assignment.segment.SegmentAssignment;
import org.apache.pinot.controller.helix.core.assignment.segment.StrictRealtimeSegmentAssignment;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.config.table.UpsertConfig;

public class SegmentAssignmentFactory {
    private SegmentAssignmentFactory() {
    }

    public static SegmentAssignment getSegmentAssignment(HelixManager helixManager, TableConfig tableConfig, @Nullable ControllerMetrics controllerMetrics) {
        UpsertConfig upsertConfig;
        BaseSegmentAssignment segmentAssignment = tableConfig.getTableType() == TableType.OFFLINE ? new OfflineSegmentAssignment() : ((upsertConfig = tableConfig.getUpsertConfig()) != null && upsertConfig.getMode() != UpsertConfig.Mode.NONE ? new StrictRealtimeSegmentAssignment() : new RealtimeSegmentAssignment());
        segmentAssignment.init(helixManager, tableConfig, controllerMetrics);
        return segmentAssignment;
    }
}

