/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.assignment.segment;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.helix.HelixManager;
import org.apache.pinot.common.assignment.InstancePartitions;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ControllerMeter;
import org.apache.pinot.common.tier.Tier;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.common.utils.SegmentUtils;
import org.apache.pinot.controller.helix.core.assignment.segment.RealtimeSegmentAssignment;
import org.apache.pinot.controller.helix.core.assignment.segment.SegmentAssignmentUtils;
import org.apache.pinot.controller.helix.core.rebalance.RebalanceConfig;
import org.apache.pinot.spi.config.table.assignment.InstancePartitionsType;

public class StrictRealtimeSegmentAssignment
extends RealtimeSegmentAssignment {
    private final Object2IntOpenHashMap<String> _segmentPartitionIdMap = new Object2IntOpenHashMap();

    @Override
    public List<String> assignSegment(String segmentName, Map<String, Map<String, String>> currentAssignment, Map<InstancePartitionsType, InstancePartitions> instancePartitionsMap) {
        Preconditions.checkState((instancePartitionsMap.size() == 1 ? 1 : 0) != 0, (Object)"One instance partition type should be provided");
        InstancePartitions instancePartitions = instancePartitionsMap.get(InstancePartitionsType.CONSUMING);
        Preconditions.checkState((instancePartitions != null ? 1 : 0) != 0, (String)"Failed to find CONSUMING instance partitions for table: %s", (Object)this._tableNameWithType);
        this._logger.info("Assigning segment: {} with instance partitions: {} for table: {}", new Object[]{segmentName, instancePartitions, this._tableNameWithType});
        int partitionId = this.getPartitionId(segmentName);
        List<String> instancesAssigned = this.assignConsumingSegment(partitionId, instancePartitions);
        Set<String> existingAssignment = this.getExistingAssignment(partitionId, currentAssignment);
        if (existingAssignment == null) {
            this._logger.info("No existing assignment from idealState, using the one decided by instancePartitions");
        } else if (!this.isSameAssignment(existingAssignment, instancesAssigned)) {
            this._logger.warn("Assignment: {} is inconsistent with idealState: {}, using the one from idealState", instancesAssigned, existingAssignment);
            instancesAssigned = new ArrayList<String>(existingAssignment);
            if (this._controllerMetrics != null) {
                this._controllerMetrics.addMeteredTableValue(this._tableNameWithType, (AbstractMetrics.Meter)ControllerMeter.CONTROLLER_REALTIME_TABLE_SEGMENT_ASSIGNMENT_MISMATCH, 1L);
            }
        }
        this._logger.info("Assigned segment: {} to instances: {} for table: {}", new Object[]{segmentName, instancesAssigned, this._tableNameWithType});
        return instancesAssigned;
    }

    @Nullable
    private Set<String> getExistingAssignment(int partitionId, Map<String, Map<String, String>> currentAssignment) {
        ArrayList<String> uploadedSegments = new ArrayList<String>();
        for (Map.Entry<String, Map<String, String>> entry : currentAssignment.entrySet()) {
            if (this.isOfflineSegment(entry.getValue())) continue;
            LLCSegmentName llcSegmentName = LLCSegmentName.of((String)entry.getKey());
            if (llcSegmentName == null) {
                uploadedSegments.add(entry.getKey());
                continue;
            }
            if (llcSegmentName.getPartitionGroupId() != partitionId) continue;
            return entry.getValue().keySet();
        }
        for (String uploadedSegment : uploadedSegments) {
            if (this.getPartitionId(uploadedSegment) != partitionId) continue;
            return currentAssignment.get(uploadedSegment).keySet();
        }
        return null;
    }

    private boolean isOfflineSegment(Map<String, String> instanceStateMap) {
        return !instanceStateMap.containsValue("ONLINE") && !instanceStateMap.containsValue("CONSUMING");
    }

    private int getPartitionId(String segmentName) {
        Integer partitionId = SegmentUtils.getRealtimeSegmentPartitionId((String)segmentName, (String)this._tableNameWithType, (HelixManager)this._helixManager, (String)this._partitionColumn);
        Preconditions.checkState((partitionId != null ? 1 : 0) != 0, (String)"Failed to find partition id for segment: %s of table: %s", (Object)segmentName, (Object)this._tableNameWithType);
        return partitionId;
    }

    private boolean isSameAssignment(Set<String> idealAssignment, List<String> instancesAssigned) {
        return idealAssignment.size() == instancesAssigned.size() && idealAssignment.containsAll(instancesAssigned);
    }

    @Override
    public Map<String, Map<String, String>> rebalanceTable(Map<String, Map<String, String>> currentAssignment, Map<InstancePartitionsType, InstancePartitions> instancePartitionsMap, @Nullable List<Tier> sortedTiers, @Nullable Map<String, InstancePartitions> tierInstancePartitionsMap, RebalanceConfig config) {
        Preconditions.checkState((instancePartitionsMap.size() == 1 ? 1 : 0) != 0, (Object)"One instance partition type should be provided");
        InstancePartitions instancePartitions = instancePartitionsMap.get(InstancePartitionsType.CONSUMING);
        Preconditions.checkState((instancePartitions != null ? 1 : 0) != 0, (String)"Failed to find CONSUMING instance partitions for table: %s", (Object)this._tableNameWithType);
        Preconditions.checkArgument((boolean)config.isIncludeConsuming(), (String)"Consuming segment must be included when rebalancing upsert table: %s", (Object)this._tableNameWithType);
        Preconditions.checkState((sortedTiers == null ? 1 : 0) != 0, (String)"Tiers must not be specified for upsert table: %s", (Object)this._tableNameWithType);
        this._logger.info("Rebalancing table: {} with instance partitions: {}", (Object)this._tableNameWithType, (Object)instancePartitions);
        TreeMap<String, Map<String, String>> newAssignment = new TreeMap<String, Map<String, String>>();
        for (Map.Entry<String, Map<String, String>> entry : currentAssignment.entrySet()) {
            String segmentName = entry.getKey();
            Map<String, String> instanceStateMap = entry.getValue();
            if (this.isOfflineSegment(instanceStateMap)) {
                newAssignment.put(segmentName, instanceStateMap);
                continue;
            }
            List<String> instancesAssigned = this.assignConsumingSegment(this.getPartitionIdUsingCache(segmentName), instancePartitions);
            String state = instanceStateMap.containsValue("CONSUMING") ? "CONSUMING" : "ONLINE";
            newAssignment.put(segmentName, SegmentAssignmentUtils.getInstanceStateMap(instancesAssigned, state));
        }
        return newAssignment;
    }

    private int getPartitionIdUsingCache(String segmentName) {
        return this._segmentPartitionIdMap.computeIntIfAbsent((Object)segmentName, this::getPartitionId);
    }
}

