/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.lineage;

import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.helix.core.lineage.LineageManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineageManagerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(LineageManagerFactory.class);

    private LineageManagerFactory() {
    }

    public static LineageManager create(ControllerConf controllerConf) {
        String lineageManagerClassName = controllerConf.getLineageManagerClass();
        try {
            return (LineageManager)Class.forName(lineageManagerClassName).getConstructor(ControllerConf.class).newInstance(new Object[]{controllerConf});
        }
        catch (Exception e) {
            LOGGER.error("LineageManager not found: {}", (Object)lineageManagerClassName);
            throw new RuntimeException(e);
        }
    }
}

