/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.minion;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ControllerGauge;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.LeadControllerManager;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.minion.PinotHelixTaskResourceManager;
import org.apache.pinot.core.periodictask.BasePeriodicTask;
import org.apache.pinot.spi.utils.InstanceTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskMetricsEmitter
extends BasePeriodicTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskMetricsEmitter.class);
    private static final String TASK_NAME = "TaskMetricsEmitter";
    private final PinotHelixResourceManager _pinotHelixResourceManager;
    private final PinotHelixTaskResourceManager _helixTaskResourceManager;
    private final ControllerMetrics _controllerMetrics;
    private final LeadControllerManager _leadControllerManager;
    private final Set<String> _preReportedTaskTypes;
    private final Map<String, Set<String>> _preReportedTables;

    public TaskMetricsEmitter(PinotHelixResourceManager pinotHelixResourceManager, PinotHelixTaskResourceManager helixTaskResourceManager, LeadControllerManager leadControllerManager, ControllerConf controllerConf, ControllerMetrics controllerMetrics) {
        super(TASK_NAME, (long)controllerConf.getTaskMetricsEmitterFrequencyInSeconds(), controllerConf.getPeriodicTaskInitialDelayInSeconds());
        this._pinotHelixResourceManager = pinotHelixResourceManager;
        this._helixTaskResourceManager = helixTaskResourceManager;
        this._controllerMetrics = controllerMetrics;
        this._leadControllerManager = leadControllerManager;
        this._preReportedTaskTypes = new HashSet<String>();
        this._preReportedTables = new HashMap<String, Set<String>>();
    }

    protected final void runTask(Properties periodicTaskProperties) {
        if (!this._leadControllerManager.isLeaderForTable(TASK_NAME)) {
            return;
        }
        Map<String, Map<String, Long>> taskMetadataLastUpdateTime = this._helixTaskResourceManager.getTaskMetadataLastUpdateTimeMs();
        taskMetadataLastUpdateTime.forEach((tableNameWithType, taskTypeLastUpdateTime) -> taskTypeLastUpdateTime.forEach((taskType, lastUpdateTimeMs) -> this._controllerMetrics.setOrUpdateTableGauge(tableNameWithType, taskType, (AbstractMetrics.Gauge)ControllerGauge.TIME_MS_SINCE_LAST_MINION_TASK_METADATA_UPDATE, () -> System.currentTimeMillis() - lastUpdateTimeMs)));
        Set<String> taskTypes = this._helixTaskResourceManager.getTaskTypes();
        for (String taskType : taskTypes) {
            PinotHelixTaskResourceManager.TaskCount taskTypeAccumulatedCount = new PinotHelixTaskResourceManager.TaskCount();
            HashMap<String, PinotHelixTaskResourceManager.TaskCount> tableAccumulatedCount = new HashMap<String, PinotHelixTaskResourceManager.TaskCount>();
            try {
                Set<String> tableNameWithTypeSet;
                Set<String> tasksInProgress = this._helixTaskResourceManager.getTasksInProgress(taskType);
                int numRunningTasks = tasksInProgress.size();
                for (String task : tasksInProgress) {
                    Map<String, PinotHelixTaskResourceManager.TaskCount> tableTaskCount = this._helixTaskResourceManager.getTableTaskCount(task);
                    tableTaskCount.forEach((tableNameWithType, taskCount) -> {
                        taskTypeAccumulatedCount.accumulate((PinotHelixTaskResourceManager.TaskCount)taskCount);
                        tableAccumulatedCount.compute((String)tableNameWithType, (name, count) -> {
                            if (count == null) {
                                count = new PinotHelixTaskResourceManager.TaskCount();
                            }
                            count.accumulate((PinotHelixTaskResourceManager.TaskCount)taskCount);
                            return count;
                        });
                    });
                }
                this._controllerMetrics.setValueOfGlobalGauge((AbstractMetrics.Gauge)ControllerGauge.NUM_MINION_TASKS_IN_PROGRESS, taskType, (long)numRunningTasks);
                this._controllerMetrics.setValueOfGlobalGauge((AbstractMetrics.Gauge)ControllerGauge.NUM_MINION_SUBTASKS_RUNNING, taskType, (long)taskTypeAccumulatedCount.getRunning());
                this._controllerMetrics.setValueOfGlobalGauge((AbstractMetrics.Gauge)ControllerGauge.NUM_MINION_SUBTASKS_WAITING, taskType, (long)taskTypeAccumulatedCount.getWaiting());
                this._controllerMetrics.setValueOfGlobalGauge((AbstractMetrics.Gauge)ControllerGauge.NUM_MINION_SUBTASKS_ERROR, taskType, (long)taskTypeAccumulatedCount.getError());
                int total = taskTypeAccumulatedCount.getTotal();
                int percent = total != 0 ? (taskTypeAccumulatedCount.getWaiting() + taskTypeAccumulatedCount.getRunning()) * 100 / total : 0;
                this._controllerMetrics.setValueOfGlobalGauge((AbstractMetrics.Gauge)ControllerGauge.PERCENT_MINION_SUBTASKS_IN_QUEUE, taskType, (long)percent);
                percent = total != 0 ? taskTypeAccumulatedCount.getError() * 100 / total : 0;
                this._controllerMetrics.setValueOfGlobalGauge((AbstractMetrics.Gauge)ControllerGauge.PERCENT_MINION_SUBTASKS_IN_ERROR, taskType, (long)percent);
                tableAccumulatedCount.forEach((tableNameWithType, taskCount) -> {
                    this._controllerMetrics.setOrUpdateTableGauge(tableNameWithType, taskType, (AbstractMetrics.Gauge)ControllerGauge.NUM_MINION_SUBTASKS_RUNNING, () -> taskCount.getRunning());
                    this._controllerMetrics.setOrUpdateTableGauge(tableNameWithType, taskType, (AbstractMetrics.Gauge)ControllerGauge.NUM_MINION_SUBTASKS_WAITING, (long)taskCount.getWaiting());
                    this._controllerMetrics.setOrUpdateTableGauge(tableNameWithType, taskType, (AbstractMetrics.Gauge)ControllerGauge.NUM_MINION_SUBTASKS_ERROR, (long)taskCount.getError());
                    int tableTotal = taskCount.getTotal();
                    int tablePercent = tableTotal != 0 ? (taskCount.getWaiting() + taskCount.getRunning()) * 100 / tableTotal : 0;
                    this._controllerMetrics.setOrUpdateTableGauge(tableNameWithType, taskType, (AbstractMetrics.Gauge)ControllerGauge.PERCENT_MINION_SUBTASKS_IN_QUEUE, (long)tablePercent);
                    tablePercent = tableTotal != 0 ? taskCount.getError() * 100 / tableTotal : 0;
                    this._controllerMetrics.setOrUpdateTableGauge(tableNameWithType, taskType, (AbstractMetrics.Gauge)ControllerGauge.PERCENT_MINION_SUBTASKS_IN_ERROR, (long)tablePercent);
                });
                if (this._preReportedTables.containsKey(taskType)) {
                    tableNameWithTypeSet = this._preReportedTables.get(taskType);
                    tableNameWithTypeSet.removeAll(tableAccumulatedCount.keySet());
                    this.removeTableTaskTypeMetrics(tableNameWithTypeSet, taskType);
                }
                if (!tableAccumulatedCount.isEmpty()) {
                    tableNameWithTypeSet = new HashSet(tableAccumulatedCount.keySet());
                    this._preReportedTables.put(taskType, tableNameWithTypeSet);
                    continue;
                }
                this._preReportedTables.remove(taskType);
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while getting metrics for task type {}", (Object)taskType, (Object)e);
            }
        }
        this._preReportedTaskTypes.removeAll(taskTypes);
        for (String taskType : this._preReportedTaskTypes) {
            this._controllerMetrics.removeGlobalGauge(taskType, (AbstractMetrics.Gauge)ControllerGauge.NUM_MINION_TASKS_IN_PROGRESS);
            this._controllerMetrics.removeGlobalGauge(taskType, (AbstractMetrics.Gauge)ControllerGauge.NUM_MINION_SUBTASKS_RUNNING);
            this._controllerMetrics.removeGlobalGauge(taskType, (AbstractMetrics.Gauge)ControllerGauge.NUM_MINION_SUBTASKS_WAITING);
            this._controllerMetrics.removeGlobalGauge(taskType, (AbstractMetrics.Gauge)ControllerGauge.NUM_MINION_SUBTASKS_ERROR);
            this._controllerMetrics.removeGlobalGauge(taskType, (AbstractMetrics.Gauge)ControllerGauge.PERCENT_MINION_SUBTASKS_IN_QUEUE);
            this._controllerMetrics.removeGlobalGauge(taskType, (AbstractMetrics.Gauge)ControllerGauge.PERCENT_MINION_SUBTASKS_IN_ERROR);
            if (!this._preReportedTables.containsKey(taskType)) continue;
            this.removeTableTaskTypeMetrics(this._preReportedTables.get(taskType), taskType);
            this._preReportedTables.remove(taskType);
        }
        this._preReportedTaskTypes.clear();
        this._preReportedTaskTypes.addAll(taskTypes);
        List<String> onlineInstances = this._pinotHelixResourceManager.getOnlineInstanceList();
        int onlineMinionInstanceCount = 0;
        for (String onlineInstance : onlineInstances) {
            if (!InstanceTypeUtils.isMinion((String)onlineInstance)) continue;
            ++onlineMinionInstanceCount;
        }
        this._controllerMetrics.setValueOfGlobalGauge((AbstractMetrics.Gauge)ControllerGauge.ONLINE_MINION_INSTANCES, (long)onlineMinionInstanceCount);
    }

    private void removeTableTaskTypeMetrics(Set<String> tableNameWithTypeSet, String taskType) {
        tableNameWithTypeSet.forEach(tableNameWithType -> {
            this._controllerMetrics.removeTableGauge(tableNameWithType, taskType, (AbstractMetrics.Gauge)ControllerGauge.NUM_MINION_SUBTASKS_RUNNING);
            this._controllerMetrics.removeTableGauge(tableNameWithType, taskType, (AbstractMetrics.Gauge)ControllerGauge.NUM_MINION_SUBTASKS_WAITING);
            this._controllerMetrics.removeTableGauge(tableNameWithType, taskType, (AbstractMetrics.Gauge)ControllerGauge.NUM_MINION_SUBTASKS_ERROR);
            this._controllerMetrics.removeTableGauge(tableNameWithType, taskType, (AbstractMetrics.Gauge)ControllerGauge.PERCENT_MINION_SUBTASKS_IN_QUEUE);
            this._controllerMetrics.removeTableGauge(tableNameWithType, taskType, (AbstractMetrics.Gauge)ControllerGauge.PERCENT_MINION_SUBTASKS_IN_ERROR);
        });
    }
}

