/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.minion.generator;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.controller.helix.core.minion.ClusterInfoAccessor;
import org.apache.pinot.controller.helix.core.minion.generator.PinotTaskGenerator;
import org.apache.pinot.spi.annotations.minion.TaskGenerator;
import org.apache.pinot.spi.utils.PinotReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskGeneratorRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskGeneratorRegistry.class);
    private final Map<String, PinotTaskGenerator> _taskGeneratorRegistry = new HashMap<String, PinotTaskGenerator>();
    public static final String TASK_GENERATOR_PACKAGE_REGEX_PATTERN = ".*\\.plugin\\.minion\\.tasks\\..*";

    public TaskGeneratorRegistry(ClusterInfoAccessor clusterInfoAccessor) {
        long startTimeMs = System.currentTimeMillis();
        Set<Class<?>> classes = TaskGeneratorRegistry.getTaskGeneratorClasses();
        for (Class<?> clazz : classes) {
            TaskGenerator annotation = clazz.getAnnotation(TaskGenerator.class);
            if (!annotation.enabled()) continue;
            try {
                PinotTaskGenerator taskGenerator = (PinotTaskGenerator)clazz.newInstance();
                taskGenerator.init(clusterInfoAccessor);
                this.registerTaskGenerator(taskGenerator);
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while initializing and registering task generator: {}, skipping it", clazz, (Object)e);
            }
        }
        LOGGER.info("Initialized TaskGeneratorRegistry with {} task generators: {} in {}ms", new Object[]{this._taskGeneratorRegistry.size(), this._taskGeneratorRegistry.keySet(), System.currentTimeMillis() - startTimeMs});
    }

    public static Set<Class<?>> getTaskGeneratorClasses() {
        return PinotReflectionUtils.getClassesThroughReflection((String)TASK_GENERATOR_PACKAGE_REGEX_PATTERN, TaskGenerator.class);
    }

    public void registerTaskGenerator(PinotTaskGenerator pinotTaskGenerator) {
        String taskType = pinotTaskGenerator.getTaskType();
        Preconditions.checkArgument((!taskType.contains("_") ? 1 : 0) != 0, (String)"Task type: %s cannot contain underscore character", (Object)taskType);
        this._taskGeneratorRegistry.put(taskType, pinotTaskGenerator);
    }

    public Set<String> getAllTaskTypes() {
        return this._taskGeneratorRegistry.keySet();
    }

    @Nullable
    public PinotTaskGenerator getTaskGenerator(String taskType) {
        return this._taskGeneratorRegistry.get(taskType);
    }
}

