/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.periodictask;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ControllerGauge;
import org.apache.pinot.common.metrics.ControllerMeter;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.controller.LeadControllerManager;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.core.periodictask.BasePeriodicTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class ControllerPeriodicTask<C>
extends BasePeriodicTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerPeriodicTask.class);
    protected final PinotHelixResourceManager _pinotHelixResourceManager;
    protected final LeadControllerManager _leadControllerManager;
    protected final ControllerMetrics _controllerMetrics;
    protected Set<String> _prevLeaderOfTables = new HashSet<String>();

    public ControllerPeriodicTask(String taskName, long runFrequencyInSeconds, long initialDelayInSeconds, PinotHelixResourceManager pinotHelixResourceManager, LeadControllerManager leadControllerManager, ControllerMetrics controllerMetrics) {
        super(taskName, runFrequencyInSeconds, initialDelayInSeconds);
        this._pinotHelixResourceManager = pinotHelixResourceManager;
        this._leadControllerManager = leadControllerManager;
        this._controllerMetrics = controllerMetrics;
    }

    protected final void runTask(Properties periodicTaskProperties) {
        this._controllerMetrics.addMeteredTableValue(this._taskName, (AbstractMetrics.Meter)ControllerMeter.CONTROLLER_PERIODIC_TASK_RUN, 1L);
        try {
            Sets.SetView nonLeaderForTables;
            String propTableNameWithType = (String)periodicTaskProperties.get("tableNameWithType");
            List<String> allTables = propTableNameWithType == null ? this._pinotHelixResourceManager.getAllTables() : Collections.singletonList(propTableNameWithType);
            Set currentLeaderOfTables = allTables.stream().filter(this._leadControllerManager::isLeaderForTable).collect(Collectors.toSet());
            if (!currentLeaderOfTables.isEmpty()) {
                this.processTables(new ArrayList<String>(currentLeaderOfTables), periodicTaskProperties);
            }
            if (!(nonLeaderForTables = Sets.difference(this._prevLeaderOfTables, currentLeaderOfTables)).isEmpty()) {
                this.nonLeaderCleanup(new ArrayList<String>((Collection<String>)nonLeaderForTables));
            }
            this._prevLeaderOfTables = currentLeaderOfTables;
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while running task: {}", (Object)this._taskName, (Object)e);
            this._controllerMetrics.addMeteredTableValue(this._taskName, (AbstractMetrics.Meter)ControllerMeter.CONTROLLER_PERIODIC_TASK_ERROR, 1L);
        }
    }

    public final ControllerMetrics getControllerMetrics() {
        return this._controllerMetrics;
    }

    protected void processTables(List<String> tableNamesWithType, Properties periodicTaskProperties) {
        int numTables = tableNamesWithType.size();
        LOGGER.info("Processing {} tables in task: {}", (Object)numTables, (Object)this._taskName);
        C context = this.preprocess(periodicTaskProperties);
        int numTablesProcessed = 0;
        for (String tableNameWithType : tableNamesWithType) {
            if (!this.isStarted()) {
                LOGGER.info("Task: {} is stopped, early terminate the task", (Object)this._taskName);
                break;
            }
            try {
                this.processTable(tableNameWithType, context);
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while processing table: {} in task: {}", new Object[]{tableNameWithType, this._taskName, e});
                this._controllerMetrics.addMeteredTableValue(tableNameWithType + "." + this._taskName, (AbstractMetrics.Meter)ControllerMeter.PERIODIC_TASK_ERROR, 1L);
            }
            ++numTablesProcessed;
        }
        this.postprocess(context);
        this._controllerMetrics.setValueOfGlobalGauge((AbstractMetrics.Gauge)ControllerGauge.PERIODIC_TASK_NUM_TABLES_PROCESSED, this._taskName, (long)numTablesProcessed);
        LOGGER.info("Finish processing {}/{} tables in task: {}", new Object[]{numTablesProcessed, numTables, this._taskName});
    }

    protected C preprocess(Properties periodicTaskProperties) {
        return null;
    }

    protected void processTable(String tableNameWithType, C context) {
        this.processTable(tableNameWithType);
    }

    protected void processTable(String tableNameWithType) {
    }

    protected void postprocess(C context) {
        this.postprocess();
    }

    protected void postprocess() {
    }

    protected void nonLeaderCleanup(List<String> tableNamesWithType) {
    }
}

