/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.realtime.segment;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.pinot.controller.helix.core.realtime.segment.DefaultFlushThresholdUpdater;
import org.apache.pinot.controller.helix.core.realtime.segment.FlushThresholdUpdater;
import org.apache.pinot.controller.helix.core.realtime.segment.SegmentSizeBasedFlushThresholdUpdater;
import org.apache.pinot.spi.stream.StreamConfig;

public class FlushThresholdUpdateManager {
    private final ConcurrentMap<String, FlushThresholdUpdater> _flushThresholdUpdaterMap = new ConcurrentHashMap<String, FlushThresholdUpdater>();

    public FlushThresholdUpdater getFlushThresholdUpdater(StreamConfig streamConfig) {
        String realtimeTableName = streamConfig.getTableNameWithType();
        int flushThresholdRows = streamConfig.getFlushThresholdRows();
        if (flushThresholdRows > 0) {
            this._flushThresholdUpdaterMap.remove(realtimeTableName);
            return new DefaultFlushThresholdUpdater(flushThresholdRows);
        }
        return this._flushThresholdUpdaterMap.computeIfAbsent(realtimeTableName, k -> new SegmentSizeBasedFlushThresholdUpdater());
    }

    public void clearFlushThresholdUpdater(String realtimeTableName) {
        this._flushThresholdUpdaterMap.remove(realtimeTableName);
    }
}

