/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.rebalance;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel
public class RebalanceConfig {
    public static final int DEFAULT_MIN_REPLICAS_TO_KEEP_UP_FOR_NO_DOWNTIME = 1;
    public static final long DEFAULT_EXTERNAL_VIEW_CHECK_INTERVAL_IN_MS = 1000L;
    public static final long DEFAULT_EXTERNAL_VIEW_STABILIZATION_TIMEOUT_IN_MS = 3600000L;
    @JsonProperty(value="dryRun")
    @ApiModelProperty(example="false")
    private boolean _dryRun = false;
    @JsonProperty(value="reassignInstances")
    @ApiModelProperty(example="false")
    private boolean _reassignInstances = false;
    @JsonProperty(value="includeConsuming")
    @ApiModelProperty(example="false")
    private boolean _includeConsuming = false;
    @JsonProperty(value="bootstrap")
    @ApiModelProperty(example="false")
    private boolean _bootstrap = false;
    @JsonProperty(value="downtime")
    @ApiModelProperty(example="false")
    private boolean _downtime = false;
    @JsonProperty(value="minAvailableReplicas")
    @ApiModelProperty(example="1")
    private int _minAvailableReplicas = 1;
    @JsonProperty(value="lowDiskMode")
    @ApiModelProperty(example="false")
    private boolean _lowDiskMode = false;
    @JsonProperty(value="bestEfforts")
    @ApiModelProperty(example="false")
    private boolean _bestEfforts = false;
    @JsonProperty(value="externalViewCheckIntervalInMs")
    @ApiModelProperty(example="1000")
    private long _externalViewCheckIntervalInMs = 1000L;
    @JsonProperty(value="externalViewStabilizationTimeoutInMs")
    @ApiModelProperty(example="3600000")
    private long _externalViewStabilizationTimeoutInMs = 3600000L;
    @JsonProperty(value="updateTargetTier")
    @ApiModelProperty(example="false")
    private boolean _updateTargetTier = false;
    @JsonProperty(value="heartbeatIntervalInMs")
    @ApiModelProperty(example="300000")
    private long _heartbeatIntervalInMs = 300000L;
    @JsonProperty(value="heartbeatTimeoutInMs")
    @ApiModelProperty(example="3600000")
    private long _heartbeatTimeoutInMs = 3600000L;
    @JsonProperty(value="maxAttempts")
    @ApiModelProperty(example="3")
    private int _maxAttempts = 3;
    @JsonProperty(value="retryInitialDelayInMs")
    @ApiModelProperty(example="300000")
    private long _retryInitialDelayInMs = 300000L;

    public boolean isDryRun() {
        return this._dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this._dryRun = dryRun;
    }

    public boolean isReassignInstances() {
        return this._reassignInstances;
    }

    public void setReassignInstances(boolean reassignInstances) {
        this._reassignInstances = reassignInstances;
    }

    public boolean isIncludeConsuming() {
        return this._includeConsuming;
    }

    public void setIncludeConsuming(boolean includeConsuming) {
        this._includeConsuming = includeConsuming;
    }

    public boolean isBootstrap() {
        return this._bootstrap;
    }

    public void setBootstrap(boolean bootstrap) {
        this._bootstrap = bootstrap;
    }

    public boolean isDowntime() {
        return this._downtime;
    }

    public void setDowntime(boolean downtime) {
        this._downtime = downtime;
    }

    public int getMinAvailableReplicas() {
        return this._minAvailableReplicas;
    }

    public void setMinAvailableReplicas(int minAvailableReplicas) {
        this._minAvailableReplicas = minAvailableReplicas;
    }

    public boolean isLowDiskMode() {
        return this._lowDiskMode;
    }

    public void setLowDiskMode(boolean lowDiskMode) {
        this._lowDiskMode = lowDiskMode;
    }

    public boolean isBestEfforts() {
        return this._bestEfforts;
    }

    public void setBestEfforts(boolean bestEfforts) {
        this._bestEfforts = bestEfforts;
    }

    public long getExternalViewCheckIntervalInMs() {
        return this._externalViewCheckIntervalInMs;
    }

    public void setExternalViewCheckIntervalInMs(long externalViewCheckIntervalInMs) {
        this._externalViewCheckIntervalInMs = externalViewCheckIntervalInMs;
    }

    public long getExternalViewStabilizationTimeoutInMs() {
        return this._externalViewStabilizationTimeoutInMs;
    }

    public void setExternalViewStabilizationTimeoutInMs(long externalViewStabilizationTimeoutInMs) {
        this._externalViewStabilizationTimeoutInMs = externalViewStabilizationTimeoutInMs;
    }

    public boolean isUpdateTargetTier() {
        return this._updateTargetTier;
    }

    public void setUpdateTargetTier(boolean updateTargetTier) {
        this._updateTargetTier = updateTargetTier;
    }

    public long getHeartbeatIntervalInMs() {
        return this._heartbeatIntervalInMs;
    }

    public void setHeartbeatIntervalInMs(long heartbeatIntervalInMs) {
        this._heartbeatIntervalInMs = heartbeatIntervalInMs;
    }

    public long getHeartbeatTimeoutInMs() {
        return this._heartbeatTimeoutInMs;
    }

    public void setHeartbeatTimeoutInMs(long heartbeatTimeoutInMs) {
        this._heartbeatTimeoutInMs = heartbeatTimeoutInMs;
    }

    public int getMaxAttempts() {
        return this._maxAttempts;
    }

    public void setMaxAttempts(int maxAttempts) {
        this._maxAttempts = maxAttempts;
    }

    public long getRetryInitialDelayInMs() {
        return this._retryInitialDelayInMs;
    }

    public void setRetryInitialDelayInMs(long retryInitialDelayInMs) {
        this._retryInitialDelayInMs = retryInitialDelayInMs;
    }

    public String toString() {
        return "RebalanceConfig{_dryRun=" + this._dryRun + ", _reassignInstances=" + this._reassignInstances + ", _includeConsuming=" + this._includeConsuming + ", _bootstrap=" + this._bootstrap + ", _downtime=" + this._downtime + ", _minAvailableReplicas=" + this._minAvailableReplicas + ", _bestEfforts=" + this._bestEfforts + ", _externalViewCheckIntervalInMs=" + this._externalViewCheckIntervalInMs + ", _externalViewStabilizationTimeoutInMs=" + this._externalViewStabilizationTimeoutInMs + ", _updateTargetTier=" + this._updateTargetTier + ", _heartbeatIntervalInMs=" + this._heartbeatIntervalInMs + ", _heartbeatTimeoutInMs=" + this._heartbeatTimeoutInMs + ", _maxAttempts=" + this._maxAttempts + ", _retryInitialDelayInMs=" + this._retryInitialDelayInMs + "}";
    }

    public static RebalanceConfig copy(RebalanceConfig cfg) {
        RebalanceConfig rc = new RebalanceConfig();
        rc._dryRun = cfg._dryRun;
        rc._reassignInstances = cfg._reassignInstances;
        rc._includeConsuming = cfg._includeConsuming;
        rc._bootstrap = cfg._bootstrap;
        rc._downtime = cfg._downtime;
        rc._minAvailableReplicas = cfg._minAvailableReplicas;
        rc._bestEfforts = cfg._bestEfforts;
        rc._externalViewCheckIntervalInMs = cfg._externalViewCheckIntervalInMs;
        rc._externalViewStabilizationTimeoutInMs = cfg._externalViewStabilizationTimeoutInMs;
        rc._updateTargetTier = cfg._updateTargetTier;
        rc._heartbeatIntervalInMs = cfg._heartbeatIntervalInMs;
        rc._heartbeatTimeoutInMs = cfg._heartbeatTimeoutInMs;
        rc._maxAttempts = cfg._maxAttempts;
        rc._retryInitialDelayInMs = cfg._retryInitialDelayInMs;
        return rc;
    }
}

