/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.rebalance;

import org.apache.pinot.controller.helix.core.rebalance.RebalanceConfig;

public class TableRebalanceContext {
    private static final int INITIAL_ATTEMPT_ID = 1;
    private String _jobId;
    private String _originalJobId;
    private RebalanceConfig _config;
    private int _attemptId;

    public static TableRebalanceContext forInitialAttempt(String originalJobId, RebalanceConfig config) {
        return new TableRebalanceContext(originalJobId, config, 1);
    }

    public static TableRebalanceContext forRetry(String originalJobId, RebalanceConfig config, int attemptId) {
        return new TableRebalanceContext(originalJobId, config, attemptId);
    }

    public TableRebalanceContext() {
    }

    private TableRebalanceContext(String originalJobId, RebalanceConfig config, int attemptId) {
        this._jobId = TableRebalanceContext.createAttemptJobId(originalJobId, attemptId);
        this._originalJobId = originalJobId;
        this._config = config;
        this._attemptId = attemptId;
    }

    public int getAttemptId() {
        return this._attemptId;
    }

    public void setAttemptId(int attemptId) {
        this._attemptId = attemptId;
    }

    public String getOriginalJobId() {
        return this._originalJobId;
    }

    public void setOriginalJobId(String originalJobId) {
        this._originalJobId = originalJobId;
    }

    public String getJobId() {
        return this._jobId;
    }

    public void setJobId(String jobId) {
        this._jobId = jobId;
    }

    public RebalanceConfig getConfig() {
        return this._config;
    }

    public void setConfig(RebalanceConfig config) {
        this._config = config;
    }

    public String toString() {
        return "TableRebalanceContext{_jobId='" + this._jobId + "', _originalJobId='" + this._originalJobId + "', _config=" + this._config + ", _attemptId=" + this._attemptId + "}";
    }

    private static String createAttemptJobId(String originalJobId, int attemptId) {
        if (attemptId == 1) {
            return originalJobId;
        }
        return originalJobId + "_" + attemptId;
    }
}

