/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.rebalance;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.pinot.controller.helix.core.rebalance.RebalanceResult;

public class TableRebalanceProgressStats {
    private RebalanceResult.Status _status;
    private long _startTimeMs;
    private long _timeToFinishInSeconds;
    private String _completionStatusMsg;
    @JsonProperty(value="initialToTargetStateConvergence")
    private RebalanceStateStats _initialToTargetStateConvergence;
    @JsonProperty(value="currentToTargetConvergence")
    private RebalanceStateStats _currentToTargetConvergence = new RebalanceStateStats();
    @JsonProperty(value="externalViewToIdealStateConvergence")
    private RebalanceStateStats _externalViewToIdealStateConvergence = new RebalanceStateStats();

    public TableRebalanceProgressStats() {
        this._initialToTargetStateConvergence = new RebalanceStateStats();
    }

    public void setStatus(RebalanceResult.Status status) {
        this._status = status;
    }

    public void setInitialToTargetStateConvergence(RebalanceStateStats initialToTargetStateConvergence) {
        this._initialToTargetStateConvergence = initialToTargetStateConvergence;
    }

    public void setStartTimeMs(long startTimeMs) {
        this._startTimeMs = startTimeMs;
    }

    public void setTimeToFinishInSeconds(Long timeToFinishInSeconds) {
        this._timeToFinishInSeconds = timeToFinishInSeconds;
    }

    public void setExternalViewToIdealStateConvergence(RebalanceStateStats externalViewToIdealStateConvergence) {
        this._externalViewToIdealStateConvergence = externalViewToIdealStateConvergence;
    }

    public void setCurrentToTargetConvergence(RebalanceStateStats currentToTargetConvergence) {
        this._currentToTargetConvergence = currentToTargetConvergence;
    }

    public void setCompletionStatusMsg(String completionStatusMsg) {
        this._completionStatusMsg = completionStatusMsg;
    }

    public RebalanceResult.Status getStatus() {
        return this._status;
    }

    public String getCompletionStatusMsg() {
        return this._completionStatusMsg;
    }

    public RebalanceStateStats getInitialToTargetStateConvergence() {
        return this._initialToTargetStateConvergence;
    }

    public long getStartTimeMs() {
        return this._startTimeMs;
    }

    public long getTimeToFinishInSeconds() {
        return this._timeToFinishInSeconds;
    }

    public RebalanceStateStats getExternalViewToIdealStateConvergence() {
        return this._externalViewToIdealStateConvergence;
    }

    public RebalanceStateStats getCurrentToTargetConvergence() {
        return this._currentToTargetConvergence;
    }

    public static boolean statsDiffer(RebalanceStateStats base, RebalanceStateStats compare) {
        return base._replicasToRebalance != compare._replicasToRebalance || base._segmentsToRebalance != compare._segmentsToRebalance || base._segmentsMissing != compare._segmentsMissing || base._percentSegmentsToRebalance != compare._percentSegmentsToRebalance;
    }

    public static class RebalanceStateStats {
        public int _segmentsMissing = 0;
        public int _segmentsToRebalance = 0;
        public double _percentSegmentsToRebalance = 0.0;
        public int _replicasToRebalance = 0;

        RebalanceStateStats() {
        }
    }
}

