/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.rebalance.tenant;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.pinot.common.metadata.controllerjob.ControllerJobType;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.rebalance.tenant.TenantRebalanceObserver;
import org.apache.pinot.controller.helix.core.rebalance.tenant.TenantRebalanceProgressStats;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkBasedTenantRebalanceObserver
implements TenantRebalanceObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZkBasedTenantRebalanceObserver.class);
    private final PinotHelixResourceManager _pinotHelixResourceManager;
    private final String _jobId;
    private final String _tenantName;
    private final List<String> _unprocessedTables;
    private final TenantRebalanceProgressStats _progressStats;
    private int _numUpdatesToZk;

    public ZkBasedTenantRebalanceObserver(String jobId, String tenantName, Set<String> tables, PinotHelixResourceManager pinotHelixResourceManager) {
        Preconditions.checkState((tables != null && !tables.isEmpty() ? 1 : 0) != 0, (Object)"List of tables to observe is empty.");
        this._jobId = jobId;
        this._tenantName = tenantName;
        this._unprocessedTables = new ArrayList<String>(tables);
        this._pinotHelixResourceManager = pinotHelixResourceManager;
        this._progressStats = new TenantRebalanceProgressStats(tables);
        this._numUpdatesToZk = 0;
    }

    @Override
    public void onTrigger(TenantRebalanceObserver.Trigger trigger, String tableName, String description) {
        switch (trigger) {
            case START_TRIGGER: {
                this._progressStats.setStartTimeMs(System.currentTimeMillis());
                break;
            }
            case REBALANCE_STARTED_TRIGGER: {
                this._progressStats.updateTableStatus(tableName, TenantRebalanceProgressStats.TableStatus.PROCESSING.name());
                this._progressStats.putTableRebalanceJobId(tableName, description);
                break;
            }
            case REBALANCE_COMPLETED_TRIGGER: {
                this._progressStats.updateTableStatus(tableName, TenantRebalanceProgressStats.TableStatus.PROCESSED.name());
                this._unprocessedTables.remove(tableName);
                this._progressStats.setRemainingTables(this._unprocessedTables.size());
                break;
            }
            case REBALANCE_ERRORED_TRIGGER: {
                this._progressStats.updateTableStatus(tableName, description);
                this._unprocessedTables.remove(tableName);
                this._progressStats.setRemainingTables(this._unprocessedTables.size());
                break;
            }
        }
        this.trackStatsInZk();
    }

    @Override
    public void onSuccess(String msg) {
        this._progressStats.setCompletionStatusMsg(msg);
        this._progressStats.setTimeToFinishInSeconds((System.currentTimeMillis() - this._progressStats.getStartTimeMs()) / 1000L);
        this.trackStatsInZk();
    }

    @Override
    public void onError(String errorMsg) {
        this._progressStats.setCompletionStatusMsg(errorMsg);
        this._progressStats.setTimeToFinishInSeconds(System.currentTimeMillis() - this._progressStats.getStartTimeMs());
        this.trackStatsInZk();
    }

    private void trackStatsInZk() {
        HashMap<String, String> jobMetadata = new HashMap<String, String>();
        jobMetadata.put("tenantName", this._tenantName);
        jobMetadata.put("jobId", this._jobId);
        jobMetadata.put("submissionTimeMs", Long.toString(System.currentTimeMillis()));
        jobMetadata.put("jobType", ControllerJobType.TENANT_REBALANCE.name());
        try {
            jobMetadata.put("REBALANCE_PROGRESS_STATS", JsonUtils.objectToString((Object)this._progressStats));
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Error serialising rebalance stats to JSON for persisting to ZK {}", (Object)this._jobId, (Object)e);
        }
        this._pinotHelixResourceManager.addControllerJobToZK(this._jobId, jobMetadata, ControllerJobType.TENANT_REBALANCE);
        ++this._numUpdatesToZk;
        LOGGER.debug("Number of updates to Zk: {} for rebalanceJob: {}  ", (Object)this._numUpdatesToZk, (Object)this._jobId);
    }
}

