/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.data;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.math.IntRange;
import org.apache.pinot.controller.recommender.data.generator.DataGenerator;
import org.apache.pinot.controller.recommender.data.generator.DataGeneratorSpec;
import org.apache.pinot.controller.recommender.data.writer.AvroWriter;
import org.apache.pinot.controller.recommender.data.writer.AvroWriterSpec;
import org.apache.pinot.controller.recommender.data.writer.CsvWriter;
import org.apache.pinot.controller.recommender.data.writer.FileWriterSpec;
import org.apache.pinot.controller.recommender.data.writer.JsonWriter;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.TimeFieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataGenerationHelpers {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataGenerationHelpers.class);

    private DataGenerationHelpers() {
    }

    public static void generateAvro(DataGenerator generator, long totalDocs, int numFiles, String outDir, boolean isOverrideOutDir) throws Exception {
        AvroWriter avroWriter = new AvroWriter();
        avroWriter.init(new AvroWriterSpec(generator, DataGenerationHelpers.handleOutDir(outDir, isOverrideOutDir), totalDocs, numFiles));
        avroWriter.write();
    }

    public static void generateCsv(DataGenerator generator, long totalDocs, int numFiles, String outDir, boolean isOverrideOutDir) throws Exception {
        CsvWriter csvWriter = new CsvWriter();
        csvWriter.init(new FileWriterSpec(generator, DataGenerationHelpers.handleOutDir(outDir, isOverrideOutDir), totalDocs, numFiles));
        csvWriter.write();
    }

    public static void generateJson(DataGenerator generator, long totalDocs, int numFiles, String outDir, boolean isOverrideOutDir) throws Exception {
        JsonWriter jsonWriter = new JsonWriter();
        jsonWriter.init(new FileWriterSpec(generator, DataGenerationHelpers.handleOutDir(outDir, isOverrideOutDir), totalDocs, numFiles));
        jsonWriter.write();
    }

    private static File handleOutDir(String outDir, boolean isOverrideOutDir) throws IOException {
        File dir = new File(outDir);
        if (dir.exists() && !isOverrideOutDir) {
            LOGGER.error("output directory already exists, and override is set to false");
            throw new RuntimeException("output directory exists");
        }
        if (dir.exists()) {
            FileUtils.deleteDirectory((File)dir);
        }
        dir.mkdir();
        return dir;
    }

    public static DataGeneratorSpec buildDataGeneratorSpec(Schema schema) {
        LinkedList<String> columns = new LinkedList<String>();
        HashMap<String, FieldSpec.DataType> dataTypes = new HashMap<String, FieldSpec.DataType>();
        HashMap<String, FieldSpec.FieldType> fieldTypes = new HashMap<String, FieldSpec.FieldType>();
        HashMap<String, TimeUnit> timeUnits = new HashMap<String, TimeUnit>();
        HashMap<String, Integer> cardinality = new HashMap<String, Integer>();
        HashMap<String, IntRange> range = new HashMap<String, IntRange>();
        HashMap<String, String> granularityMap = new HashMap<String, String>();
        HashMap<String, String> formatMap = new HashMap<String, String>();
        block7: for (FieldSpec fs : schema.getAllFieldSpecs()) {
            String col = fs.getName();
            columns.add(col);
            dataTypes.put(col, fs.getDataType());
            fieldTypes.put(col, fs.getFieldType());
            switch (fs.getFieldType()) {
                case DIMENSION: {
                    cardinality.putIfAbsent(col, 1000);
                    continue block7;
                }
                case METRIC: {
                    range.putIfAbsent(col, new IntRange(1, 1000));
                    continue block7;
                }
                case TIME: {
                    range.putIfAbsent(col, new IntRange(1, 1000));
                    TimeFieldSpec tfs = (TimeFieldSpec)fs;
                    timeUnits.put(col, tfs.getIncomingGranularitySpec().getTimeType());
                    continue block7;
                }
                case DATE_TIME: {
                    DateTimeFieldSpec dtfs = (DateTimeFieldSpec)fs;
                    granularityMap.put(col, dtfs.getGranularity());
                    formatMap.put(col, dtfs.getFormat());
                    continue block7;
                }
                case COMPLEX: {
                    continue block7;
                }
            }
            throw new RuntimeException("Invalid field type.");
        }
        return new DataGeneratorSpec.Builder().setColumns(columns).setDataTypeMap(dataTypes).setFieldTypeMap(fieldTypes).setTimeUnitMap(timeUnits).setCardinalityMap(cardinality).setRangeMap(range).setDateTimeGranularityMap(granularityMap).setDateTimeFormatMap(formatMap).build();
    }
}

