/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.data.generator;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.math.IntRange;
import org.apache.pinot.controller.recommender.data.DataGenerationHelpers;
import org.apache.pinot.controller.recommender.data.generator.DataGeneratorSpec;
import org.apache.pinot.controller.recommender.data.generator.DateTimeGenerator;
import org.apache.pinot.controller.recommender.data.generator.Generator;
import org.apache.pinot.controller.recommender.data.generator.GeneratorFactory;
import org.apache.pinot.controller.recommender.data.generator.PatternType;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DimensionFieldSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.MetricFieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.TimeFieldSpec;
import org.apache.pinot.spi.data.TimeGranularitySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataGenerator.class);
    DataGeneratorSpec _genSpec;
    private final Map<String, Generator> _generators = new HashMap<String, Generator>();

    public void init(DataGeneratorSpec spec) throws IOException {
        this._genSpec = spec;
        for (String column : this._genSpec.getColumns()) {
            Generator generator;
            FieldSpec.DataType dataType = this._genSpec.getDataTypeMap().get(column);
            if (this._genSpec.getDateTimeFormatMap().containsKey(column) && this._genSpec.getDateTimeGranularityMap().containsKey(column)) {
                generator = new DateTimeGenerator(this._genSpec.getDateTimeFormatMap().get(column), this._genSpec.getDateTimeGranularityMap().get(column));
            } else if (this._genSpec.getPatternMap().containsKey(column)) {
                generator = GeneratorFactory.getGeneratorFor(PatternType.valueOf(this._genSpec.getPatternMap().get(column).get("type").toString()), this._genSpec.getPatternMap().get(column));
            } else if (this._genSpec.getCardinalityMap().containsKey(column)) {
                generator = GeneratorFactory.getGeneratorFor(dataType, this._genSpec.getCardinalityMap().get(column), this._genSpec.getMvCountMap().get(column), this._genSpec.getLengthMap().get(column), this._genSpec.getTimeUnitMap().get(column));
            } else if (this._genSpec.getRangeMap().containsKey(column)) {
                IntRange range = this._genSpec.getRangeMap().get(column);
                generator = GeneratorFactory.getGeneratorFor(dataType, range.getMinimumInteger(), range.getMaximumInteger());
            } else {
                LOGGER.error("cardinality for this column does not exist : " + column);
                throw new RuntimeException("cardinality for this column does not exist");
            }
            generator.init();
            this._generators.put(column, generator);
        }
    }

    public Map<String, Object> nextRow() {
        LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
        for (String key : this._genSpec.getColumns()) {
            row.put(key, this._generators.get(key).next());
        }
        return row;
    }

    public Schema fetchSchema() {
        Schema schema = new Schema();
        for (String column : this._genSpec.getColumns()) {
            FieldSpec spec = this.buildSpec(this._genSpec, column);
            schema.addField(spec);
        }
        return schema;
    }

    private FieldSpec buildSpec(DataGeneratorSpec genSpec, String column) {
        DimensionFieldSpec spec;
        FieldSpec.DataType dataType = genSpec.getDataTypeMap().get(column);
        FieldSpec.FieldType fieldType = genSpec.getFieldTypeMap().get(column);
        switch (fieldType) {
            case DIMENSION: {
                spec = new DimensionFieldSpec();
                break;
            }
            case METRIC: {
                spec = new MetricFieldSpec();
                break;
            }
            case TIME: {
                spec = new TimeFieldSpec(new TimeGranularitySpec(dataType, genSpec.getTimeUnitMap().get(column), column));
                break;
            }
            case DATE_TIME: {
                String format = genSpec.getDateTimeFormatMap().get(column);
                String granularity = genSpec.getDateTimeGranularityMap().get(column);
                spec = new DateTimeFieldSpec(column, dataType, format, granularity);
                break;
            }
            default: {
                throw new RuntimeException("Invalid Field type.");
            }
        }
        spec.setName(column);
        spec.setDataType(dataType);
        spec.setSingleValueField(true);
        return spec;
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, FieldSpec.DataType> dataTypes = new HashMap<String, FieldSpec.DataType>();
        HashMap<String, FieldSpec.FieldType> fieldTypes = new HashMap<String, FieldSpec.FieldType>();
        HashMap<String, TimeUnit> timeUnits = new HashMap<String, TimeUnit>();
        HashMap<String, Integer> cardinality = new HashMap<String, Integer>();
        HashMap<String, IntRange> range = new HashMap<String, IntRange>();
        HashMap<String, Map<String, Object>> template = new HashMap<String, Map<String, Object>>();
        HashMap<String, Double> mvCountMap = new HashMap<String, Double>();
        HashMap<String, Integer> lengthMap = new HashMap<String, Integer>();
        ArrayList<String> columnNames = new ArrayList<String>();
        HashMap<String, String> dateTimeFormatMap = new HashMap<String, String>();
        HashMap<String, String> dateTimeGranularityMap = new HashMap<String, String>();
        int cardinalityValue = 5;
        int strLength = 5;
        Object colName = "colInt";
        dataTypes.put((String)colName, FieldSpec.DataType.INT);
        fieldTypes.put((String)colName, FieldSpec.FieldType.DIMENSION);
        cardinality.put((String)colName, cardinalityValue);
        columnNames.add((String)colName);
        mvCountMap.put((String)colName, 3.7);
        String colName2 = "colFloat";
        dataTypes.put(colName2, FieldSpec.DataType.FLOAT);
        fieldTypes.put(colName2, FieldSpec.FieldType.DIMENSION);
        cardinality.put(colName2, cardinalityValue);
        columnNames.add(colName2);
        mvCountMap.put(colName2, 3.7);
        String colName3 = "colString";
        dataTypes.put(colName3, FieldSpec.DataType.STRING);
        fieldTypes.put(colName3, FieldSpec.FieldType.DIMENSION);
        cardinality.put(colName3, cardinalityValue);
        columnNames.add(colName3);
        mvCountMap.put(colName3, 3.7);
        lengthMap.put(colName3, strLength);
        String colName4 = "metric";
        dataTypes.put(colName4, FieldSpec.DataType.DOUBLE);
        fieldTypes.put(colName4, FieldSpec.FieldType.METRIC);
        cardinality.put(colName4, cardinalityValue);
        columnNames.add(colName4);
        String colName5 = "colBytes";
        dataTypes.put(colName5, FieldSpec.DataType.BYTES);
        fieldTypes.put(colName5, FieldSpec.FieldType.DIMENSION);
        cardinality.put(colName5, cardinalityValue);
        columnNames.add(colName5);
        mvCountMap.put(colName5, 3.7);
        lengthMap.put(colName5, strLength + 1);
        for (int i = 0; i < 2; ++i) {
            colName = "colString" + (i + 2);
            dataTypes.put((String)colName, FieldSpec.DataType.STRING);
            fieldTypes.put((String)colName, FieldSpec.FieldType.DIMENSION);
            cardinality.put((String)colName, cardinalityValue);
            columnNames.add((String)colName);
            lengthMap.put((String)colName, strLength + i + 2);
        }
        String outputDir = Paths.get(System.getProperty("java.io.tmpdir"), "csv-data").toString();
        DataGeneratorSpec spec = new DataGeneratorSpec(columnNames, cardinality, range, template, mvCountMap, lengthMap, dataTypes, fieldTypes, timeUnits, dateTimeFormatMap, dateTimeGranularityMap);
        DataGenerator gen = new DataGenerator();
        gen.init(spec);
        DataGenerationHelpers.generateCsv(gen, 100L, 1, outputDir, true);
        System.out.println("CSV data is generated under: " + outputDir);
    }
}

