/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.data.generator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.math.IntRange;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.readers.FileFormat;

public class DataGeneratorSpec {
    private final List<String> _columns;
    private final Map<String, Integer> _cardinalityMap;
    private final Map<String, IntRange> _rangeMap;
    private final Map<String, Map<String, Object>> _patternMap;
    private final Map<String, Double> _mvCountMap;
    private final Map<String, Integer> _lengthMap;
    private final Map<String, FieldSpec.DataType> _dataTypeMap;
    private final Map<String, FieldSpec.FieldType> _fieldTypeMap;
    private final Map<String, TimeUnit> _timeUnitMap;
    private final Map<String, String> _dateTimeFormatMap;
    private final Map<String, String> _dateTimeGranularityMap;
    @Deprecated
    private FileFormat _outputFileFormat;
    @Deprecated
    private String _outputDir;
    @Deprecated
    private boolean _overrideOutDir;

    @Deprecated
    public DataGeneratorSpec() {
        this(new ArrayList<String>(), new HashMap<String, Integer>(), new HashMap<String, IntRange>(), new HashMap<String, Map<String, Object>>(), new HashMap<String, Double>(), new HashMap<String, Integer>(), new HashMap<String, FieldSpec.DataType>(), new HashMap<String, FieldSpec.FieldType>(), new HashMap<String, TimeUnit>(), FileFormat.AVRO, "/tmp/dataGen", true);
    }

    @Deprecated
    public DataGeneratorSpec(List<String> columns, Map<String, Integer> cardinalityMap, Map<String, IntRange> rangeMap, Map<String, Map<String, Object>> patternMap, Map<String, Double> mvCountMap, Map<String, Integer> lengthMap, Map<String, FieldSpec.DataType> dataTypesMap, Map<String, FieldSpec.FieldType> fieldTypesMap, Map<String, TimeUnit> timeUnitMap, FileFormat format, String outputDir, boolean override) {
        this._columns = columns;
        this._cardinalityMap = cardinalityMap;
        this._rangeMap = rangeMap;
        this._patternMap = patternMap;
        this._mvCountMap = mvCountMap;
        this._lengthMap = lengthMap;
        this._outputFileFormat = format;
        this._outputDir = outputDir;
        this._overrideOutDir = override;
        this._dataTypeMap = dataTypesMap;
        this._fieldTypeMap = fieldTypesMap;
        this._timeUnitMap = timeUnitMap;
        this._dateTimeFormatMap = new HashMap<String, String>();
        this._dateTimeGranularityMap = new HashMap<String, String>();
    }

    public DataGeneratorSpec(List<String> columns, Map<String, Integer> cardinalityMap, Map<String, IntRange> rangeMap, Map<String, Map<String, Object>> patternMap, Map<String, Double> mvCountMap, Map<String, Integer> lengthMap, Map<String, FieldSpec.DataType> dataTypesMap, Map<String, FieldSpec.FieldType> fieldTypesMap, Map<String, TimeUnit> timeUnitMap, Map<String, String> dateTimeFormatMap, Map<String, String> dateTimeGranularityMap) {
        this._columns = columns;
        this._cardinalityMap = cardinalityMap;
        this._rangeMap = rangeMap;
        this._patternMap = patternMap;
        this._mvCountMap = mvCountMap;
        this._lengthMap = lengthMap;
        this._dataTypeMap = dataTypesMap;
        this._fieldTypeMap = fieldTypesMap;
        this._timeUnitMap = timeUnitMap;
        this._dateTimeGranularityMap = dateTimeGranularityMap;
        this._dateTimeFormatMap = dateTimeFormatMap;
    }

    public Map<String, FieldSpec.DataType> getDataTypeMap() {
        return this._dataTypeMap;
    }

    public Map<String, FieldSpec.FieldType> getFieldTypeMap() {
        return this._fieldTypeMap;
    }

    public Map<String, TimeUnit> getTimeUnitMap() {
        return this._timeUnitMap;
    }

    public boolean isOverrideOutDir() {
        return this._overrideOutDir;
    }

    public List<String> getColumns() {
        return this._columns;
    }

    public Map<String, Integer> getCardinalityMap() {
        return this._cardinalityMap;
    }

    public Map<String, IntRange> getRangeMap() {
        return this._rangeMap;
    }

    public Map<String, Map<String, Object>> getPatternMap() {
        return this._patternMap;
    }

    public Map<String, Double> getMvCountMap() {
        return this._mvCountMap;
    }

    public Map<String, Integer> getLengthMap() {
        return this._lengthMap;
    }

    public FileFormat getOutputFileFormat() {
        return this._outputFileFormat;
    }

    public String getOutputDir() {
        return this._outputDir;
    }

    public Map<String, String> getDateTimeFormatMap() {
        return this._dateTimeFormatMap;
    }

    public Map<String, String> getDateTimeGranularityMap() {
        return this._dateTimeGranularityMap;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String column : this._columns) {
            if (this._cardinalityMap.get(column) != null) {
                builder.append(column + " : " + this._cardinalityMap.get(column) + " : " + this._dataTypeMap.get(column));
            } else if (this._rangeMap.get(column) != null) {
                builder.append(column + " : " + this._rangeMap.get(column) + " : " + this._dataTypeMap.get(column));
            } else {
                builder.append(column + " : " + this._patternMap.get(column));
            }
            builder.append(", ");
        }
        builder.append("output file format : " + this._outputFileFormat);
        builder.append(", output dir : " + this._outputDir);
        return builder.toString();
    }

    public static class Builder {
        private List<String> _columns = new ArrayList<String>();
        private Map<String, Integer> _cardinalityMap = new HashMap<String, Integer>();
        private Map<String, IntRange> _rangeMap = new HashMap<String, IntRange>();
        private Map<String, Map<String, Object>> _patternMap = new HashMap<String, Map<String, Object>>();
        private Map<String, Double> _mvCountMap = new HashMap<String, Double>();
        private Map<String, Integer> _lengthMap = new HashMap<String, Integer>();
        private Map<String, FieldSpec.DataType> _dataTypeMap = new HashMap<String, FieldSpec.DataType>();
        private Map<String, FieldSpec.FieldType> _fieldTypeMap = new HashMap<String, FieldSpec.FieldType>();
        private Map<String, TimeUnit> _timeUnitMap = new HashMap<String, TimeUnit>();
        private Map<String, String> _dateTimeFormatMap = new HashMap<String, String>();
        private Map<String, String> _dateTimeGranularityMap = new HashMap<String, String>();

        public DataGeneratorSpec build() {
            return new DataGeneratorSpec(this._columns, this._cardinalityMap, this._rangeMap, this._patternMap, this._mvCountMap, this._lengthMap, this._dataTypeMap, this._fieldTypeMap, this._timeUnitMap, this._dateTimeFormatMap, this._dateTimeGranularityMap);
        }

        public Builder setColumns(List<String> columns) {
            this._columns = columns;
            return this;
        }

        public Builder setCardinalityMap(Map<String, Integer> cardinalityMap) {
            this._cardinalityMap = cardinalityMap;
            return this;
        }

        public Builder setRangeMap(Map<String, IntRange> rangeMap) {
            this._rangeMap = rangeMap;
            return this;
        }

        public Builder setPatternMap(Map<String, Map<String, Object>> patternMap) {
            this._patternMap = patternMap;
            return this;
        }

        public Builder setMvCountMap(Map<String, Double> mvCountMap) {
            this._mvCountMap = mvCountMap;
            return this;
        }

        public Builder setLengthMap(Map<String, Integer> lengthMap) {
            this._lengthMap = lengthMap;
            return this;
        }

        public Builder setDataTypeMap(Map<String, FieldSpec.DataType> dataTypeMap) {
            this._dataTypeMap = dataTypeMap;
            return this;
        }

        public Builder setFieldTypeMap(Map<String, FieldSpec.FieldType> fieldTypeMap) {
            this._fieldTypeMap = fieldTypeMap;
            return this;
        }

        public Builder setTimeUnitMap(Map<String, TimeUnit> timeUnitMap) {
            this._timeUnitMap = timeUnitMap;
            return this;
        }

        public Builder setDateTimeFormatMap(Map<String, String> dateTimeFormatMap) {
            this._dateTimeFormatMap = dateTimeFormatMap;
            return this;
        }

        public Builder setDateTimeGranularityMap(Map<String, String> dateTimeGranularityMap) {
            this._dateTimeGranularityMap = dateTimeGranularityMap;
            return this;
        }
    }
}

