/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.data.generator;

import java.util.Date;
import java.util.Random;
import org.apache.pinot.controller.recommender.data.generator.Generator;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.DateTimeGranularitySpec;

public class DateTimeGenerator
implements Generator {
    private static final int MULTIPLIER_CARDINALITY = 5;
    private final DateTimeFormatSpec _formatSpec;
    private final DateTimeGranularitySpec _granularitySpec;
    private long _currentValue;
    private Random _multiplier = new Random();

    public DateTimeGenerator(String format, String granularity) {
        this._formatSpec = new DateTimeFormatSpec(format);
        this._granularitySpec = new DateTimeGranularitySpec(granularity);
    }

    @Override
    public void init() {
        this._currentValue = new Date().getTime();
    }

    @Override
    public Object next() {
        this._currentValue += this._granularitySpec.granularityToMillis() * (long)this._multiplier.nextInt(5);
        return this._formatSpec.fromMillisToFormat(this._currentValue);
    }
}

