/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.data.generator;

import java.util.Map;
import org.apache.commons.configuration2.convert.PropertyConverter;
import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.distribution.ExponentialDistribution;
import org.apache.commons.math3.distribution.LogNormalDistribution;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.pinot.controller.recommender.data.generator.Generator;

public class PatternSpikeGenerator
implements Generator {
    private final double _baseline;
    private final double _smoothing;
    private final AbstractRealDistribution _arrivalGenerator;
    private final AbstractRealDistribution _magnitudeGenerator;
    private long _step = -1L;
    private long _nextArrival;
    private double _lastValue;

    public PatternSpikeGenerator(Map<String, Object> templateConfig) {
        this(PropertyConverter.toDouble((Object)templateConfig.getOrDefault("baseline", 0)), DistributionType.valueOf(templateConfig.getOrDefault("arrivalType", "lognormal").toString().toUpperCase()), PropertyConverter.toDouble((Object)templateConfig.getOrDefault("arrivalMean", 2)), PropertyConverter.toDouble((Object)templateConfig.getOrDefault("arrivalSigma", 1)), DistributionType.valueOf(templateConfig.getOrDefault("magnitudeType", "lognormal").toString().toUpperCase()), PropertyConverter.toDouble((Object)templateConfig.getOrDefault("magnitudeMean", 2)), PropertyConverter.toDouble((Object)templateConfig.getOrDefault("magnitudeSigma", 1)), PropertyConverter.toDouble((Object)templateConfig.getOrDefault("smoothing", 0)), PropertyConverter.toInteger((Object)templateConfig.getOrDefault("seed", 0)));
    }

    public PatternSpikeGenerator(double baseline, DistributionType arrivalType, double arrivalMean, double arrivalSigma, DistributionType magnitudeType, double magnitudeMean, double magnitudeSigma, double smoothing, int seed) {
        this._baseline = baseline;
        this._smoothing = smoothing;
        this._arrivalGenerator = PatternSpikeGenerator.makeDist(arrivalType, arrivalMean, arrivalSigma, seed);
        this._magnitudeGenerator = PatternSpikeGenerator.makeDist(magnitudeType, magnitudeMean, magnitudeSigma, seed);
        this._nextArrival = (long)this._arrivalGenerator.sample();
        this._lastValue = baseline;
    }

    private static AbstractRealDistribution makeDist(DistributionType type, double mean, double sigma, int seed) {
        switch (type) {
            case LOGNORMAL: {
                return new LogNormalDistribution((RandomGenerator)new Well19937c(seed), mean, sigma, 1.0E-9);
            }
            case EXPONENTIAL: {
                return new ExponentialDistribution((RandomGenerator)new Well19937c(seed), mean, 1.0E-9);
            }
            case UNIFORM: {
                return new UniformRealDistribution((RandomGenerator)new Well19937c(seed), mean - sigma, mean + sigma);
            }
            case FIXED: {
                return new UniformRealDistribution((RandomGenerator)new Well19937c(seed), mean, mean + 1.0E-9);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported distribution type '%s", new Object[]{type}));
    }

    @Override
    public void init() {
    }

    @Override
    public Object next() {
        ++this._step;
        if (this._step < this._nextArrival) {
            this._lastValue = (1.0 - this._smoothing) * this._baseline + this._smoothing * this._lastValue;
            return (long)this._lastValue;
        }
        this._nextArrival += (long)this._arrivalGenerator.sample();
        this._lastValue = this._baseline + this._magnitudeGenerator.sample();
        return (long)this._lastValue;
    }

    static enum DistributionType {
        LOGNORMAL,
        EXPONENTIAL,
        UNIFORM,
        FIXED;

    }
}

