/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.data.writer;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;

class AvroRecordAppender
implements Closeable {
    private final DataFileWriter<GenericData.Record> _recordWriter;
    private final Schema _avroSchema;

    public AvroRecordAppender(File file, Schema avroSchema) throws IOException {
        this._avroSchema = avroSchema;
        this._recordWriter = new DataFileWriter((DatumWriter)new GenericDatumWriter(this._avroSchema));
        this._recordWriter.create(this._avroSchema, file);
    }

    public void append(Map<String, Object> record) throws IOException {
        GenericData.Record nextRecord = new GenericData.Record(this._avroSchema);
        record.forEach((column, value) -> nextRecord.put(column, record.get(column)));
        this._recordWriter.append((Object)nextRecord);
    }

    @Override
    public void close() throws IOException {
        this._recordWriter.close();
    }
}

