/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.data.writer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.pinot.controller.recommender.data.writer.AvroRecordAppender;
import org.apache.pinot.controller.recommender.data.writer.AvroWriterSpec;
import org.apache.pinot.controller.recommender.data.writer.Writer;
import org.apache.pinot.controller.recommender.data.writer.WriterSpec;
import org.apache.pinot.plugin.inputformat.avro.AvroSchemaUtil;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroWriter
implements Writer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AvroWriter.class);
    private AvroWriterSpec _spec;

    public static Schema getAvroSchema(org.apache.pinot.spi.data.Schema schema) {
        ObjectNode avroSchema = JsonUtils.newObjectNode();
        avroSchema.put("name", "data_gen_record");
        avroSchema.put("type", "record");
        ArrayNode fields = JsonUtils.newArrayNode();
        for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
            ObjectNode jsonObject = AvroSchemaUtil.toAvroSchemaJsonObject((FieldSpec)fieldSpec);
            fields.add((JsonNode)jsonObject);
        }
        avroSchema.set("fields", (JsonNode)fields);
        return new Schema.Parser().parse(avroSchema.toString());
    }

    @Override
    public void init(WriterSpec spec) {
        this._spec = (AvroWriterSpec)spec;
    }

    @Override
    public void write() throws IOException {
        int numPerFiles = (int)(this._spec.getTotalDocs() / (long)this._spec.getNumFiles());
        for (int i = 0; i < this._spec.getNumFiles(); ++i) {
            try (AvroRecordAppender appender = new AvroRecordAppender(new File(this._spec.getBaseDir(), "part-" + i + ".avro"), AvroWriter.getAvroSchema(this._spec.getSchema()));){
                for (int j = 0; j < numPerFiles; ++j) {
                    appender.append(this._spec.getGenerator().nextRow());
                }
                continue;
            }
        }
    }

    @Override
    public void cleanup() {
        File baseDir = new File(this._spec.getBaseDir().toURI());
        for (File file : Objects.requireNonNull(baseDir.listFiles())) {
            if (file.delete()) continue;
            LOGGER.error("Unable to delete file {}", (Object)file.getAbsolutePath());
        }
        if (!baseDir.delete()) {
            LOGGER.error("Unable to delete directory {}", (Object)baseDir.getAbsolutePath());
        }
    }
}

