/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.data.writer;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.pinot.controller.recommender.data.generator.DataGenerator;
import org.apache.pinot.controller.recommender.data.writer.FileWriter;
import org.apache.pinot.controller.recommender.data.writer.WriterSpec;

public class CsvWriter
extends FileWriter {
    private String _headers;

    @Override
    public void init(WriterSpec spec) {
        super.init(spec);
        this._headers = StringUtils.join(this._spec.getGenerator().nextRow().keySet(), (String)",");
    }

    @Override
    protected String generateRow(DataGenerator generator) {
        Map<String, Object> row = generator.nextRow();
        int colCount = row.size();
        Object[] values = new Object[colCount];
        int index = 0;
        for (String key : row.keySet()) {
            values[index] = this.serializeIfMultiValue(row.get(key));
            ++index;
        }
        return StringUtils.join((Object[])values, (String)",");
    }

    @Override
    protected void preprocess(java.io.FileWriter writer) throws Exception {
        writer.append(this._headers).append('\n');
    }

    private Object serializeIfMultiValue(Object obj) {
        if (obj instanceof List) {
            return StringUtils.join((Collection)((List)obj), (String)";");
        }
        return obj;
    }

    @Override
    protected String getExtension() {
        return "csv";
    }
}

