/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.data.writer;

import java.io.File;
import java.util.Objects;
import org.apache.pinot.controller.recommender.data.generator.DataGenerator;
import org.apache.pinot.controller.recommender.data.writer.FileWriterSpec;
import org.apache.pinot.controller.recommender.data.writer.Writer;
import org.apache.pinot.controller.recommender.data.writer.WriterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileWriter
implements Writer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileWriter.class);
    protected FileWriterSpec _spec;

    @Override
    public void init(WriterSpec spec) {
        this._spec = (FileWriterSpec)spec;
    }

    @Override
    public void write() throws Exception {
        long totalDocs = this._spec.getTotalDocs();
        long docsPerFile = (long)Math.ceil((double)totalDocs / (double)this._spec.getNumFiles());
        String extension = this.getExtension() == null ? "" : String.format(".%s", this.getExtension());
        long ingestedDocs = 0L;
        int fileIndex = 0;
        while (ingestedDocs < totalDocs) {
            try (java.io.FileWriter writer = new java.io.FileWriter(new File(this._spec.getBaseDir(), String.format("output_%d%s", fileIndex, extension)));){
                this.preprocess(writer);
                int j = 0;
                while ((long)j < docsPerFile && ingestedDocs < totalDocs) {
                    String appendString = this.generateRow(this._spec.getGenerator());
                    writer.append(appendString).append('\n');
                    ++ingestedDocs;
                    ++j;
                }
            }
            ++fileIndex;
        }
    }

    protected void preprocess(java.io.FileWriter writer) throws Exception {
    }

    protected String getExtension() {
        return null;
    }

    @Override
    public void cleanup() {
        File baseDir = new File(this._spec.getBaseDir().toURI());
        for (File file : Objects.requireNonNull(baseDir.listFiles())) {
            if (file.delete()) continue;
            LOGGER.error("Unable to delete file {}", (Object)file.getAbsolutePath());
        }
        if (!baseDir.delete()) {
            LOGGER.error("Unable to delete directory {}", (Object)baseDir.getAbsolutePath());
        }
    }

    protected abstract String generateRow(DataGenerator var1);
}

