/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.rules.impl;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.controller.recommender.exceptions.InvalidInputException;
import org.apache.pinot.controller.recommender.io.ConfigManager;
import org.apache.pinot.controller.recommender.io.InputManager;
import org.apache.pinot.controller.recommender.rules.AbstractRule;
import org.apache.pinot.controller.recommender.rules.io.params.NoDictionaryOnHeapDictionaryJointRuleParams;
import org.apache.pinot.controller.recommender.rules.utils.FixedLenBitset;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoDictionaryOnHeapDictionaryJointRule
extends AbstractRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(NoDictionaryOnHeapDictionaryJointRule.class);
    private final NoDictionaryOnHeapDictionaryJointRuleParams _params;

    public NoDictionaryOnHeapDictionaryJointRule(InputManager input, ConfigManager output) {
        super(input, output);
        this._params = input.getNoDictionaryOnHeapDictionaryJointRuleParams();
    }

    @Override
    public void run() {
        LOGGER.info("Recommending no dictionary and on-heap dictionaries");
        int numCols = this._input.getNumCols();
        HashMap filterGroupByWeights = new HashMap();
        HashMap selectionWeights = new HashMap();
        AtomicDouble totalWeight = new AtomicDouble(0.0);
        this._input.getParsedQueries().forEach(query -> {
            Double weight = this._input.getQueryWeight((String)query);
            this.parseQuery(this._input.getQueryContext((String)query), weight, filterGroupByWeights, selectionWeights);
            totalWeight.addAndGet(weight.doubleValue());
        });
        HashSet<String> noDictCols = new HashSet<String>(this._input.getColNameToIntMap().keySet());
        noDictCols.removeAll(this._output.getIndexConfig().getInvertedIndexColumns());
        noDictCols.remove(this._output.getIndexConfig().getSortedColumn());
        noDictCols.removeAll(this._output.getIndexConfig().getRangeIndexColumns());
        LOGGER.debug("noDictCols {}", noDictCols);
        noDictCols.removeIf(colName -> !this._input.isSingleValueColumn((String)colName));
        noDictCols.removeIf(colName -> {
            double filterGroupByFreq = filterGroupByWeights.getOrDefault(colName, 0.0) / totalWeight.get();
            return filterGroupByFreq > this._params._thresholdMinFilterFreqDictionary;
        });
        LOGGER.debug("filterGroupByWeights {}, selectionWeights{}, totalWeight{} ", new Object[]{filterGroupByWeights, selectionWeights, totalWeight});
        LOGGER.debug("noDictCols {}", noDictCols);
        noDictCols.removeIf(colName -> {
            double selectionFreq = selectionWeights.getOrDefault(colName, 0.0) / totalWeight.get();
            if (selectionFreq > this._params._thresholdMinSelectionFreqNoDictionary) {
                return false;
            }
            long svColRawSizePerDoc = 0L;
            try {
                svColRawSizePerDoc = this._input.getColRawSizePerDoc((String)colName);
            }
            catch (InvalidInputException e) {
                return true;
            }
            double numValuesPerEntry = this._input.getNumValuesPerEntry((String)colName);
            int dictionaryEncodedForwardIndexSize = this._input.getDictionaryEncodedForwardIndexSize((String)colName);
            long dictionarySize = this._input.getDictionarySize((String)colName);
            LOGGER.debug("svColRawSizePerDoc {}", (Object)svColRawSizePerDoc);
            LOGGER.debug("dictionaryEncodedForwardIndexSize {}", (Object)dictionaryEncodedForwardIndexSize);
            LOGGER.debug("dictionarySize {}", (Object)dictionarySize);
            LOGGER.debug("numValuesPerEntry {}", (Object)numValuesPerEntry);
            long numRecordsPerPush = this._input.getTableType().equalsIgnoreCase("realtime") ? this._input.getNumMessagesPerSecInKafkaTopic() * (long)this._input.getSegmentFlushTime().intValue() : this._input.getNumRecordsPerPush();
            double noDictSize = numRecordsPerPush * svColRawSizePerDoc;
            double withDictSize = (double)(numRecordsPerPush * (long)dictionaryEncodedForwardIndexSize) + (double)dictionarySize * this._params._dictionaryCoefficient;
            double storageSaved = (noDictSize - withDictSize) / noDictSize;
            LOGGER.debug("colName {}, noDictSize {}, withDictSize{}, storageSaved{}", new Object[]{colName, noDictSize, withDictSize, storageSaved});
            return storageSaved > this._params._thresholdMinPercentDictionaryStorageSave;
        });
        this._output.getIndexConfig().getNoDictionaryColumns().addAll(noDictCols);
        if (this._input.getQps() > this._params._thresholdMinQpsOnHeap) {
            for (String colName2 : this._input.getColNameToIntMap().keySet()) {
                if (this._output.getIndexConfig().getNoDictionaryColumns().contains(colName2)) continue;
                long dictionarySize = this._input.getDictionarySize(colName2);
                double filterGroupByFreq = filterGroupByWeights.getOrDefault(colName2, 0.0) / totalWeight.get();
                if (!(filterGroupByFreq > this._params._thresholdMinFilterFreqOnHeap) || dictionarySize >= this._params._thresholdMaxDictionarySizeOnHeap) continue;
                this._output.getIndexConfig().getOnHeapDictionaryColumns().add(colName2);
            }
        }
    }

    public void parseQuery(QueryContext queryContext, double weight, Map<String, Double> filterGroupByWeights, Map<String, Double> selectionWeights) {
        FilterContext filter;
        if (queryContext.getSelectExpressions() != null) {
            queryContext.getSelectExpressions().forEach(selectExpression -> {
                HashSet colNames = new HashSet();
                selectExpression.getColumns(colNames);
                colNames.forEach(colName -> selectionWeights.merge((String)colName, weight, Double::sum));
            });
        }
        FixedLenBitset fixedLenBitsetFilterGroupBy = this.mutableEmptySet();
        if (queryContext.getGroupByExpressions() != null) {
            queryContext.getGroupByExpressions().forEach(groupByExpression -> {
                HashSet colNames = new HashSet();
                groupByExpression.getColumns(colNames);
                colNames.forEach(colName -> fixedLenBitsetFilterGroupBy.add(this._input.colNameToInt((String)colName)));
            });
        }
        if ((filter = queryContext.getFilter()) != null && !filter.isConstant()) {
            fixedLenBitsetFilterGroupBy.union(this.parsePredicateList(filter));
        }
        for (Integer colId : fixedLenBitsetFilterGroupBy.getOffsets()) {
            filterGroupByWeights.merge(this._input.intToColName(colId), weight, Double::sum);
        }
    }

    public FixedLenBitset parsePredicateList(FilterContext filterContext) {
        FixedLenBitset ret = this.mutableEmptySet();
        List children = filterContext.getChildren();
        if (children != null) {
            for (FilterContext child : children) {
                FixedLenBitset childResult = this.parsePredicateList(child);
                ret.union(childResult);
            }
        } else {
            ExpressionContext lhs = filterContext.getPredicate().getLhs();
            String colName = lhs.toString();
            if (lhs.getType() == ExpressionContext.Type.FUNCTION || this._input.isTimeOrDateTimeColumn(colName)) {
                LOGGER.trace("Skipping this column {}", (Object)colName);
            } else if (!this._input.isDim(colName)) {
                LOGGER.error("Error: Column {} should not appear in filter", (Object)colName);
            } else {
                ret.add(this._input.colNameToInt(colName));
            }
        }
        return ret;
    }

    private FixedLenBitset mutableEmptySet() {
        return new FixedLenBitset(this._input.getNumCols());
    }
}

