/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.util;

import com.google.common.collect.BiMap;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HttpEntity;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.apache.pinot.common.http.MultiHttpRequest;
import org.apache.pinot.common.http.MultiHttpRequestResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletionServiceHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompletionServiceHelper.class);
    private final Executor _executor;
    private final HttpClientConnectionManager _httpConnectionManager;
    private final BiMap<String, String> _endpointsToServers;

    public CompletionServiceHelper(Executor executor, HttpClientConnectionManager httpConnectionManager, BiMap<String, String> endpointsToServers) {
        this._executor = executor;
        this._httpConnectionManager = httpConnectionManager;
        this._endpointsToServers = endpointsToServers;
    }

    public CompletionServiceResponse doMultiGetRequest(List<String> serverURLs, String tableNameWithType, boolean multiRequestPerServer, int timeoutMs) {
        return this.doMultiGetRequest(serverURLs, tableNameWithType, multiRequestPerServer, null, timeoutMs, null);
    }

    public CompletionServiceResponse doMultiGetRequest(List<String> serverURLs, String tableNameWithType, boolean multiRequestPerServer, @Nullable Map<String, String> requestHeaders, int timeoutMs, @Nullable String useCase) {
        CompletionService completionService = new MultiHttpRequest(this._executor, this._httpConnectionManager).executeGet(serverURLs, requestHeaders, timeoutMs);
        return this.collectResponse(tableNameWithType, serverURLs.size(), completionService, multiRequestPerServer, useCase);
    }

    public CompletionServiceResponse doMultiPostRequest(List<Pair<String, String>> serverURLsAndRequestBodies, String tableNameWithType, boolean multiRequestPerServer, @Nullable Map<String, String> requestHeaders, int timeoutMs, @Nullable String useCase) {
        CompletionService completionService = new MultiHttpRequest(this._executor, this._httpConnectionManager).executePost(serverURLsAndRequestBodies, requestHeaders, timeoutMs);
        return this.collectResponse(tableNameWithType, serverURLsAndRequestBodies.size(), completionService, multiRequestPerServer, useCase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionServiceResponse collectResponse(String tableNameWithType, int size, CompletionService<MultiHttpRequestResponse> completionService, boolean multiRequestPerServer, @Nullable String useCase) {
        CompletionServiceResponse completionServiceResponse = new CompletionServiceResponse();
        for (int i = 0; i < size; ++i) {
            MultiHttpRequestResponse multiHttpRequestResponse = null;
            try {
                multiHttpRequestResponse = completionService.take().get();
                URI uri = multiHttpRequestResponse.getURI();
                String instance = (String)this._endpointsToServers.get((Object)String.format("%s://%s:%d", uri.getScheme(), uri.getHost(), uri.getPort()));
                int statusCode = multiHttpRequestResponse.getResponse().getStatusLine().getStatusCode();
                if (statusCode >= 300) {
                    String reason = multiHttpRequestResponse.getResponse().getStatusLine().getReasonPhrase();
                    LOGGER.error("Server: {} returned error: {}, reason: {}", new Object[]{instance, statusCode, reason});
                    ++completionServiceResponse._failedResponseCount;
                    continue;
                }
                String responseString = EntityUtils.toString((HttpEntity)multiHttpRequestResponse.getResponse().getEntity());
                completionServiceResponse._httpResponses.put(multiRequestPerServer ? uri.toString() : instance, responseString);
                continue;
            }
            catch (Exception e) {
                String reason = useCase == null ? "" : String.format(" in '%s'", useCase);
                LOGGER.error("Connection error {}. Details: {}", (Object)reason, (Object)e.getMessage());
                ++completionServiceResponse._failedResponseCount;
                continue;
            }
            finally {
                if (multiHttpRequestResponse != null) {
                    try {
                        multiHttpRequestResponse.close();
                    }
                    catch (Exception e) {
                        LOGGER.error("Connection close error. Details: {}", (Object)e.getMessage());
                    }
                }
            }
        }
        int numServersResponded = completionServiceResponse._httpResponses.size();
        if (numServersResponded != size) {
            LOGGER.warn("Finished reading information for table: {} with {}/{} server responses", new Object[]{tableNameWithType, numServersResponded, size});
        } else {
            LOGGER.info("Finished reading information for table: {}", (Object)tableNameWithType);
        }
        return completionServiceResponse;
    }

    public CompletionServiceResponse doMultiGetRequest(List<String> serverURLs, String tableNameWithType, boolean multiRequestPerServer, int timeoutMs, @Nullable String useCase) {
        return this.doMultiGetRequest(serverURLs, tableNameWithType, multiRequestPerServer, null, timeoutMs, useCase);
    }

    public CompletionServiceResponse doMultiGetRequest(List<String> serverURLs, String tableNameWithType, boolean multiRequestPerServer, @Nullable Map<String, String> requestHeaders, int timeoutMs) {
        return this.doMultiGetRequest(serverURLs, tableNameWithType, multiRequestPerServer, requestHeaders, timeoutMs, null);
    }

    public static class CompletionServiceResponse {
        public Map<String, String> _httpResponses = new HashMap<String, String>();
        public int _failedResponseCount = 0;
    }
}

