/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.pinot.common.restlet.resources.TableMetadataInfo;
import org.apache.pinot.common.restlet.resources.TableSegments;
import org.apache.pinot.common.restlet.resources.ValidDocIdsBitmapResponse;
import org.apache.pinot.common.restlet.resources.ValidDocIdsMetadataInfo;
import org.apache.pinot.common.utils.RoaringBitmapUtils;
import org.apache.pinot.controller.util.CompletionServiceHelper;
import org.apache.pinot.spi.utils.JsonUtils;
import org.glassfish.jersey.client.ClientConfig;
import org.roaringbitmap.RoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSegmentMetadataReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerSegmentMetadataReader.class);
    private final Executor _executor;
    private final HttpClientConnectionManager _connectionManager;

    public ServerSegmentMetadataReader() {
        this._executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        this._connectionManager = new PoolingHttpClientConnectionManager();
    }

    public ServerSegmentMetadataReader(Executor executor, HttpClientConnectionManager connectionManager) {
        this._executor = executor;
        this._connectionManager = connectionManager;
    }

    public TableMetadataInfo getAggregatedTableMetadataFromServer(String tableNameWithType, BiMap<String, String> serverEndPoints, List<String> columns, int numReplica, int timeoutMs) {
        int numServers = serverEndPoints.size();
        LOGGER.info("Reading aggregated segment metadata from {} servers for table: {} with timeout: {}ms", new Object[]{numServers, tableNameWithType, timeoutMs});
        ArrayList<String> serverUrls = new ArrayList<String>(numServers);
        BiMap endpointsToServers = serverEndPoints.inverse();
        for (String endpoint : endpointsToServers.keySet()) {
            String serverUrl = this.generateAggregateSegmentMetadataServerURL(tableNameWithType, columns, endpoint);
            serverUrls.add(serverUrl);
        }
        CompletionServiceHelper completionServiceHelper = new CompletionServiceHelper(this._executor, this._connectionManager, (BiMap<String, String>)endpointsToServers);
        CompletionServiceHelper.CompletionServiceResponse serviceResponse = completionServiceHelper.doMultiGetRequest(serverUrls, tableNameWithType, false, timeoutMs);
        long totalDiskSizeInBytes = 0L;
        int totalNumSegments = 0;
        long totalNumRows = 0L;
        int failedParses = 0;
        HashMap<String, Double> columnLengthMap = new HashMap<String, Double>();
        HashMap<String, Double> columnCardinalityMap = new HashMap<String, Double>();
        HashMap<String, Double> maxNumMultiValuesMap = new HashMap<String, Double>();
        HashMap<String, Map> columnIndexSizeMap = new HashMap<String, Map>();
        HashMap upsertPartitionToServerPrimaryKeyCountMap = new HashMap();
        for (Map.Entry<String, String> streamResponse : serviceResponse._httpResponses.entrySet()) {
            try {
                TableMetadataInfo tableMetadataInfo = (TableMetadataInfo)JsonUtils.stringToObject((String)streamResponse.getValue(), TableMetadataInfo.class);
                totalDiskSizeInBytes += tableMetadataInfo.getDiskSizeInBytes();
                totalNumRows += tableMetadataInfo.getNumRows();
                totalNumSegments = (int)((long)totalNumSegments + tableMetadataInfo.getNumSegments());
                tableMetadataInfo.getColumnLengthMap().forEach((k, v) -> columnLengthMap.merge((String)k, (Double)v, Double::sum));
                tableMetadataInfo.getColumnCardinalityMap().forEach((k, v) -> columnCardinalityMap.merge((String)k, (Double)v, Double::sum));
                tableMetadataInfo.getMaxNumMultiValuesMap().forEach((k, v) -> maxNumMultiValuesMap.merge((String)k, (Double)v, Double::sum));
                tableMetadataInfo.getColumnIndexSizeMap().forEach((k, v) -> columnIndexSizeMap.merge((String)k, (Map)v, (l, r) -> {
                    for (Map.Entry e : r.entrySet()) {
                        l.put((String)e.getKey(), l.getOrDefault(e.getKey(), 0.0) + (Double)e.getValue());
                    }
                    return l;
                }));
                tableMetadataInfo.getUpsertPartitionToServerPrimaryKeyCountMap().forEach((partition, serverToPrimaryKeyCount) -> upsertPartitionToServerPrimaryKeyCountMap.merge(partition, new HashMap(serverToPrimaryKeyCount), (l, r) -> {
                    for (Map.Entry serverToPKCount : r.entrySet()) {
                        l.merge((String)serverToPKCount.getKey(), (Long)serverToPKCount.getValue(), Long::sum);
                    }
                    return l;
                }));
            }
            catch (IOException e) {
                ++failedParses;
                LOGGER.error("Unable to parse server {} response due to an error: ", (Object)streamResponse.getKey(), (Object)e);
            }
        }
        int finalTotalNumSegments = totalNumSegments;
        columnLengthMap.replaceAll((k, v) -> v / (double)finalTotalNumSegments);
        columnCardinalityMap.replaceAll((k, v) -> v / (double)finalTotalNumSegments);
        maxNumMultiValuesMap.replaceAll((k, v) -> v / (double)finalTotalNumSegments);
        columnIndexSizeMap.replaceAll((k, v) -> {
            v.replaceAll((key, value) -> (Double)v.get(key) / (double)finalTotalNumSegments);
            return v;
        });
        TableMetadataInfo aggregateTableMetadataInfo = new TableMetadataInfo(tableNameWithType, totalDiskSizeInBytes /= (long)numReplica, (long)(totalNumSegments /= numReplica), totalNumRows /= (long)numReplica, columnLengthMap, columnCardinalityMap, maxNumMultiValuesMap, columnIndexSizeMap, upsertPartitionToServerPrimaryKeyCountMap);
        if (failedParses != 0) {
            LOGGER.warn("Failed to parse {} / {} aggregated segment metadata responses from servers.", (Object)failedParses, (Object)serverUrls.size());
        }
        return aggregateTableMetadataInfo;
    }

    public List<String> getSegmentMetadataFromServer(String tableNameWithType, Map<String, List<String>> serversToSegmentsMap, BiMap<String, String> endpoints, List<String> columns, int timeoutMs) {
        LOGGER.debug("Reading segment metadata from servers for table {}.", (Object)tableNameWithType);
        ArrayList<String> serverURLs = new ArrayList<String>();
        for (Map.Entry<String, List<String>> serverToSegments : serversToSegmentsMap.entrySet()) {
            List<String> segments = serverToSegments.getValue();
            for (String segment : segments) {
                serverURLs.add(this.generateSegmentMetadataServerURL(tableNameWithType, segment, columns, (String)endpoints.get((Object)serverToSegments.getKey())));
            }
        }
        BiMap endpointsToServers = endpoints.inverse();
        CompletionServiceHelper completionServiceHelper = new CompletionServiceHelper(this._executor, this._connectionManager, (BiMap<String, String>)endpointsToServers);
        CompletionServiceHelper.CompletionServiceResponse serviceResponse = completionServiceHelper.doMultiGetRequest(serverURLs, tableNameWithType, true, timeoutMs);
        ArrayList<String> segmentsMetadata = new ArrayList<String>();
        int failedParses = 0;
        for (Map.Entry<String, String> streamResponse : serviceResponse._httpResponses.entrySet()) {
            try {
                String segmentMetadata = streamResponse.getValue();
                segmentsMetadata.add(segmentMetadata);
            }
            catch (Exception e) {
                ++failedParses;
                LOGGER.error("Unable to parse server {} response due to an error: ", (Object)streamResponse.getKey(), (Object)e);
            }
        }
        if (failedParses != 0) {
            LOGGER.error("Unable to parse server {} / {} response due to an error: ", (Object)failedParses, (Object)serverURLs.size());
        }
        LOGGER.debug("Retrieved segment metadata from servers.");
        return segmentsMetadata;
    }

    public List<ValidDocIdsMetadataInfo> getValidDocIdsMetadataFromServer(String tableNameWithType, Map<String, List<String>> serverToSegmentsMap, BiMap<String, String> serverToEndpoints, @Nullable List<String> segmentNames, int timeoutMs, String validDocIdsType) {
        ArrayList<Pair<String, String>> serverURLsAndBodies = new ArrayList<Pair<String, String>>();
        for (Map.Entry<String, List<String>> serverToSegments : serverToSegmentsMap.entrySet()) {
            List<String> segmentsForServer = serverToSegments.getValue();
            ArrayList<String> segmentsToQuery = new ArrayList<String>();
            if (segmentNames == null || segmentNames.isEmpty()) {
                segmentsToQuery.addAll(segmentsForServer);
            } else {
                HashSet<String> segmentNamesLookUpTable = new HashSet<String>(segmentNames);
                for (String segment : segmentsForServer) {
                    if (!segmentNamesLookUpTable.contains(segment)) continue;
                    segmentsToQuery.add(segment);
                }
            }
            serverURLsAndBodies.add(this.generateValidDocIdsMetadataURL(tableNameWithType, segmentsToQuery, validDocIdsType, (String)serverToEndpoints.get((Object)serverToSegments.getKey())));
        }
        CompletionServiceHelper completionServiceHelper = new CompletionServiceHelper(this._executor, this._connectionManager, serverToEndpoints);
        Map<String, String> requestHeaders = Map.of("Content-Type", "application/json");
        CompletionServiceHelper.CompletionServiceResponse serviceResponse = completionServiceHelper.doMultiPostRequest(serverURLsAndBodies, tableNameWithType, false, requestHeaders, timeoutMs, null);
        ArrayList<ValidDocIdsMetadataInfo> validDocIdsMetadataInfos = new ArrayList<ValidDocIdsMetadataInfo>();
        int failedParses = 0;
        int returnedSegmentsCount = 0;
        for (Map.Entry<String, String> streamResponse : serviceResponse._httpResponses.entrySet()) {
            try {
                String validDocIdsMetadataList = streamResponse.getValue();
                List validDocIdsMetadataInfo = (List)JsonUtils.stringToObject((String)validDocIdsMetadataList, (TypeReference)new TypeReference<ArrayList<ValidDocIdsMetadataInfo>>(){});
                validDocIdsMetadataInfos.addAll(validDocIdsMetadataInfo);
                ++returnedSegmentsCount;
            }
            catch (Exception e) {
                ++failedParses;
                LOGGER.error("Unable to parse server {} response due to an error: ", (Object)streamResponse.getKey(), (Object)e);
            }
        }
        if (failedParses != 0) {
            LOGGER.error("Unable to parse server {} / {} response due to an error: ", (Object)failedParses, (Object)serverURLsAndBodies.size());
        }
        if (segmentNames != null && returnedSegmentsCount != segmentNames.size()) {
            LOGGER.error("Unable to get validDocIdsMetadata from all servers. Expected: {}, Actual: {}", (Object)segmentNames.size(), (Object)returnedSegmentsCount);
        }
        LOGGER.info("Retrieved valid doc id metadata for {} segments from {} servers.", (Object)returnedSegmentsCount, (Object)serverURLsAndBodies.size());
        return validDocIdsMetadataInfos;
    }

    @Deprecated
    public RoaringBitmap getValidDocIdsFromServer(String tableNameWithType, String segmentName, String validDocIdsType, String endpoint, int timeoutMs) {
        String url = this.generateValidDocIdsURL(tableNameWithType, segmentName, validDocIdsType, endpoint);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.property("jersey.config.client.connectTimeout", (Object)timeoutMs);
        clientConfig.property("jersey.config.client.readTimeout", (Object)timeoutMs);
        Response response = (Response)ClientBuilder.newClient((Configuration)clientConfig).target(url).request().get(Response.class);
        Preconditions.checkState((response.getStatus() == Response.Status.OK.getStatusCode() ? 1 : 0) != 0, (String)"Unable to retrieve validDocIds from %s", (Object)url);
        byte[] validDocIds = (byte[])response.readEntity(byte[].class);
        return RoaringBitmapUtils.deserialize((byte[])validDocIds);
    }

    public ValidDocIdsBitmapResponse getValidDocIdsBitmapFromServer(String tableNameWithType, String segmentName, String endpoint, String validDocIdsType, int timeoutMs) {
        String url = this.generateValidDocIdsBitmapURL(tableNameWithType, segmentName, validDocIdsType, endpoint);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.property("jersey.config.client.connectTimeout", (Object)timeoutMs);
        clientConfig.property("jersey.config.client.readTimeout", (Object)timeoutMs);
        ValidDocIdsBitmapResponse response = (ValidDocIdsBitmapResponse)ClientBuilder.newClient((Configuration)clientConfig).target(url).request(new String[]{"application/json"}).get(ValidDocIdsBitmapResponse.class);
        Preconditions.checkNotNull((Object)response, (String)"Unable to retrieve validDocIdsBitmap from %s", (Object)url);
        return response;
    }

    private String generateAggregateSegmentMetadataServerURL(String tableNameWithType, List<String> columns, String endpoint) {
        tableNameWithType = URLEncoder.encode(tableNameWithType, StandardCharsets.UTF_8);
        String paramsStr = this.generateColumnsParam(columns);
        return String.format("%s/tables/%s/metadata?%s", endpoint, tableNameWithType, paramsStr);
    }

    private String generateSegmentMetadataServerURL(String tableNameWithType, String segmentName, List<String> columns, String endpoint) {
        tableNameWithType = URLEncoder.encode(tableNameWithType, StandardCharsets.UTF_8);
        segmentName = URLEncoder.encode(segmentName, StandardCharsets.UTF_8);
        String paramsStr = this.generateColumnsParam(columns);
        return String.format("%s/tables/%s/segments/%s/metadata?%s", endpoint, tableNameWithType, segmentName, paramsStr);
    }

    @Deprecated
    private String generateValidDocIdsURL(String tableNameWithType, String segmentName, String validDocIdsType, String endpoint) {
        tableNameWithType = URLEncoder.encode(tableNameWithType, StandardCharsets.UTF_8);
        segmentName = URLEncoder.encode(segmentName, StandardCharsets.UTF_8);
        Object url = String.format("%s/segments/%s/%s/validDocIds", endpoint, tableNameWithType, segmentName);
        if (validDocIdsType != null) {
            url = (String)url + "?validDocIdsType=" + validDocIdsType;
        }
        return url;
    }

    private String generateValidDocIdsBitmapURL(String tableNameWithType, String segmentName, String validDocIdsType, String endpoint) {
        tableNameWithType = URLEncoder.encode(tableNameWithType, StandardCharsets.UTF_8);
        segmentName = URLEncoder.encode(segmentName, StandardCharsets.UTF_8);
        Object url = String.format("%s/segments/%s/%s/validDocIdsBitmap", endpoint, tableNameWithType, segmentName);
        if (validDocIdsType != null) {
            url = (String)url + "?validDocIdsType=" + validDocIdsType;
        }
        return url;
    }

    private Pair<String, String> generateValidDocIdsMetadataURL(String tableNameWithType, List<String> segmentNames, String validDocIdsType, String endpoint) {
        String jsonTableSegments;
        tableNameWithType = URLEncoder.encode(tableNameWithType, StandardCharsets.UTF_8);
        TableSegments tableSegments = new TableSegments(segmentNames);
        try {
            jsonTableSegments = JsonUtils.objectToString((Object)tableSegments);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Failed to convert segment names to json request body: segmentNames={}", segmentNames);
            throw new RuntimeException(e);
        }
        Object url = String.format("%s/tables/%s/validDocIdsMetadata", endpoint, tableNameWithType);
        if (validDocIdsType != null) {
            url = (String)url + "?validDocIdsType=" + validDocIdsType;
        }
        return Pair.of((Object)url, (Object)jsonTableSegments);
    }

    private String generateColumnsParam(List<String> columns) {
        String paramsStr = "";
        if (columns == null || columns.isEmpty()) {
            return paramsStr;
        }
        ArrayList<String> params = new ArrayList<String>(columns.size());
        for (String column : columns) {
            params.add(String.format("columns=%s", column));
        }
        paramsStr = String.join((CharSequence)"&", params);
        return paramsStr;
    }
}

