/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./app/index.tsx");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./app/App.tsx":
/*!*********************!*\
  !*** ./app/App.tsx ***!
  \*********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const react_router_dom_1 = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router-dom/esm/react-router-dom.js");
const Layout_1 = __importDefault(__webpack_require__(/*! ./components/Layout */ "./app/components/Layout.tsx"));
const router_1 = __importDefault(__webpack_require__(/*! ./router */ "./app/router.tsx"));
const PinotMethodUtils_1 = __importDefault(__webpack_require__(/*! ./utils/PinotMethodUtils */ "./app/utils/PinotMethodUtils.ts"));
const app_state_1 = __importDefault(__webpack_require__(/*! ./app_state */ "./app/app_state.ts"));
const AuthProvider_1 = __webpack_require__(/*! ./components/auth/AuthProvider */ "./app/components/auth/AuthProvider.tsx");
const AppLoadingIndicator_1 = __webpack_require__(/*! ./components/AppLoadingIndicator */ "./app/components/AppLoadingIndicator.tsx");
exports.App = () => {
    const [clusterName, setClusterName] = react_1.useState('');
    const [loading, setLoading] = react_1.useState(true);
    const [isAuthenticated, setIsAuthenticated] = react_1.useState(null);
    const [role, setRole] = react_1.useState('');
    const { authUserName, authUserEmail, authenticated, authWorkflow } = AuthProvider_1.useAuthProvider();
    const history = react_router_dom_1.useHistory();
    react_1.useEffect(() => {
        // authentication already handled by authProvider
        if (authUserEmail && authenticated) {
            // Authenticated with an auth method that supports user identity
            // Any code that needs user identity can go here
        }
        if (authenticated) {
            setIsAuthenticated(true);
        }
    }, [authUserName, authUserEmail, authenticated]);
    react_1.useEffect(() => {
        if (authWorkflow === "BASIC" /* BASIC */) {
            setLoading(false);
        }
    }, [authWorkflow]);
    const fetchUserRole = () => __awaiter(void 0, void 0, void 0, function* () {
        const userListResponse = yield PinotMethodUtils_1.default.getUserList();
        let userObj = userListResponse.users;
        let userData = [];
        for (let key in userObj) {
            if (userObj.hasOwnProperty(key)) {
                userData.push(userObj[key]);
            }
        }
        let role = "";
        for (let item of userData) {
            if (item.username === app_state_1.default.username && item.component === 'CONTROLLER') {
                role = item.role;
            }
        }
        if (role === 'ADMIN') {
            app_state_1.default.role = "ADMIN";
            setRole('ADMIN');
        }
    });
    const fetchClusterName = () => __awaiter(void 0, void 0, void 0, function* () {
        const clusterNameResponse = yield PinotMethodUtils_1.default.getClusterName();
        localStorage.setItem('pinot_ui:clusterName', clusterNameResponse);
        setClusterName(clusterNameResponse);
    });
    const fetchClusterConfig = () => __awaiter(void 0, void 0, void 0, function* () {
        const clusterConfig = yield PinotMethodUtils_1.default.getClusterConfigJSON();
        app_state_1.default.queryConsoleOnlyView = (clusterConfig === null || clusterConfig === void 0 ? void 0 : clusterConfig.queryConsoleOnlyView) === 'true';
        app_state_1.default.hideQueryConsoleTab = (clusterConfig === null || clusterConfig === void 0 ? void 0 : clusterConfig.hideQueryConsoleTab) === 'true';
        setLoading(false);
    });
    const getRouterData = () => {
        if (app_state_1.default.queryConsoleOnlyView) {
            return router_1.default.filter((routeObj) => { return routeObj.path === '/query'; });
        }
        if (app_state_1.default.hideQueryConsoleTab) {
            return router_1.default.filter((routeObj) => routeObj.path !== '/query');
        }
        return router_1.default;
    };
    react_1.useEffect(() => {
        if (isAuthenticated) {
            fetchClusterConfig();
            fetchClusterName();
            fetchUserRole();
        }
    }, [isAuthenticated]);
    const loginRender = (Component, props) => {
        if (isAuthenticated) {
            history.push("/");
            return;
        }
        return (react_1.default.createElement("div", { className: "p-8" },
            react_1.default.createElement(Component, Object.assign({}, props, { setIsAuthenticated: setIsAuthenticated }))));
    };
    const componentRender = (Component, props, role) => {
        return (react_1.default.createElement("div", { className: "p-8" },
            react_1.default.createElement(Layout_1.default, Object.assign({ clusterName: clusterName }, props, { role: role }),
                react_1.default.createElement(Component, Object.assign({}, props)))));
    };
    if (loading) {
        return react_1.default.createElement(AppLoadingIndicator_1.AppLoadingIndicator, null);
    }
    return (react_1.default.createElement(react_router_dom_1.Switch, null,
        getRouterData().map(({ path, Component }, key) => (react_1.default.createElement(react_router_dom_1.Route, { exact: true, path: path, key: key, render: (props) => {
                if (path === '/login') {
                    return loginRender(Component, props);
                }
                else if (isAuthenticated) {
                    // default render
                    return componentRender(Component, props, role);
                }
                else {
                    return react_1.default.createElement(react_router_dom_1.Redirect, { to: "/login" });
                }
            } }))),
        react_1.default.createElement(react_router_dom_1.Route, { path: "*" },
            react_1.default.createElement(react_router_dom_1.Redirect, { to: PinotMethodUtils_1.default.getURLWithoutAccessToken(app_state_1.default.queryConsoleOnlyView ? '/query' : '/') }))));
};


/***/ }),

/***/ "./app/app_state.ts":
/*!**************************!*\
  !*** ./app/app_state.ts ***!
  \**************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
class app_state {
    constructor() {
        this.columnNameSeparator = '#$%';
    }
}
exports.default = new app_state();


/***/ }),

/***/ "./app/components/AppLoader.tsx":
/*!**************************************!*\
  !*** ./app/components/AppLoader.tsx ***!
  \**************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const React = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const CircularProgress_1 = __importDefault(__webpack_require__(/*! @material-ui/core/CircularProgress */ "./node_modules/@material-ui/core/esm/CircularProgress/index.js"));
const styles_1 = __webpack_require__(/*! @material-ui/core/styles */ "./node_modules/@material-ui/core/esm/styles/index.js");
const useStyles = styles_1.makeStyles((theme) => styles_1.createStyles({
    root: {
        position: 'fixed',
        right: '200px',
        top: '15px',
        zIndex: 1200,
        '& svg > circle': {
            stroke: 'white'
        }
    },
}));
const AppLoader = () => {
    const classes = useStyles();
    return (React.createElement(CircularProgress_1.default, { className: classes.root }));
};
exports.default = AppLoader;


/***/ }),

/***/ "./app/components/AppLoadingIndicator.tsx":
/*!************************************************!*\
  !*** ./app/components/AppLoadingIndicator.tsx ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
exports.useAppLoadingIndicatorStyles = core_1.makeStyles({
    appLoadingIndicator: {
        height: "100vh",
        width: "100%",
        display: "flex",
        flex: 1,
        alignItems: "center",
        justifyContent: "center",
    },
});
exports.AppLoadingIndicator = () => {
    const classes = exports.useAppLoadingIndicatorStyles();
    return (react_1.default.createElement("div", { className: classes.appLoadingIndicator },
        react_1.default.createElement(core_1.CircularProgress, { size: 80, color: "primary" })));
};


/***/ }),

/***/ "./app/components/AsyncInstanceTable.tsx":
/*!***********************************************!*\
  !*** ./app/components/AsyncInstanceTable.tsx ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const Table_1 = __importDefault(__webpack_require__(/*! ./Table */ "./app/components/Table.tsx"));
const PinotMethodUtils_1 = __importDefault(__webpack_require__(/*! ../utils/PinotMethodUtils */ "./app/utils/PinotMethodUtils.ts"));
const Utils_1 = __importDefault(__webpack_require__(/*! ../utils/Utils */ "./app/utils/Utils.tsx"));
exports.AsyncInstanceTable = ({ instanceType, cluster, tenant, showInstanceDetails = false, }) => {
    const instanceColumns = showInstanceDetails
        ? ['Instance Name', 'Enabled', 'Hostname', 'Port', 'Status']
        : ['Instance Name'];
    const [instanceData, setInstanceData] = react_1.useState(Utils_1.default.getLoadingTableData(instanceColumns));
    const fetchInstances = (instanceType, tenant) => __awaiter(void 0, void 0, void 0, function* () {
        if (tenant) {
            if (instanceType === "broker" /* BROKER */) {
                return PinotMethodUtils_1.default.getBrokerOfTenant(tenant).then((brokersData) => {
                    return Array.isArray(brokersData) ? brokersData : [];
                });
            }
            else if (instanceType === "server" /* SERVER */) {
                return PinotMethodUtils_1.default.getServerOfTenant(tenant).then((serversData) => {
                    return Array.isArray(serversData) ? serversData : [];
                });
            }
        }
        else {
            return fetchInstancesOfType(instanceType);
        }
    });
    const fetchInstancesOfType = (instanceType) => __awaiter(void 0, void 0, void 0, function* () {
        return PinotMethodUtils_1.default.getAllInstances().then((instancesData) => {
            const lowercaseInstanceData = lodash_1.mapKeys(instancesData, (value, key) => lodash_1.lowerCase(key));
            return lodash_1.get(lowercaseInstanceData, lodash_1.lowerCase(instanceType));
        });
    });
    react_1.useEffect(() => {
        const instances = fetchInstances(instanceType, tenant);
        if (showInstanceDetails) {
            const instanceDetails = instances.then((instancesData) => __awaiter(void 0, void 0, void 0, function* () {
                const liveInstanceArr = yield PinotMethodUtils_1.default.getLiveInstance(cluster);
                return PinotMethodUtils_1.default.getInstanceData(instancesData, liveInstanceArr.data);
            }));
            instanceDetails.then((instanceDetailsData) => {
                setInstanceData(instanceDetailsData);
            });
        }
        else {
            instances.then((instancesData) => {
                setInstanceData({
                    columns: instanceColumns,
                    records: instancesData.map((instance) => [instance]),
                });
            });
        }
    }, [instanceType, cluster, tenant, showInstanceDetails]);
    return (react_1.default.createElement(Table_1.default, { title: lodash_1.startCase(instanceType), data: instanceData, addLinks: true, baseURL: "/instance/", showSearchBox: true, inAccordionFormat: true }));
};


/***/ }),

/***/ "./app/components/AsyncPinotSchemas.tsx":
/*!**********************************************!*\
  !*** ./app/components/AsyncPinotSchemas.tsx ***!
  \**********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const PinotMethodUtils_1 = __importDefault(__webpack_require__(/*! ../utils/PinotMethodUtils */ "./app/utils/PinotMethodUtils.ts"));
const Loading_1 = __importDefault(__webpack_require__(/*! ./Loading */ "./app/components/Loading.tsx"));
const Table_1 = __importDefault(__webpack_require__(/*! ./Table */ "./app/components/Table.tsx"));
const requests_1 = __webpack_require__(/*! ../requests */ "./app/requests/index.ts");
const Utils_1 = __importDefault(__webpack_require__(/*! ../utils/Utils */ "./app/utils/Utils.tsx"));
exports.AsyncPinotSchemas = ({ onSchemaNamesLoaded }) => {
    const [schemaDetails, setSchemaDetails] = react_1.useState(Utils_1.default.getLoadingTableData(PinotMethodUtils_1.default.allSchemaDetailsColumnHeader));
    const fetchSchemas = () => __awaiter(void 0, void 0, void 0, function* () {
        requests_1.getSchemaList().then((result) => {
            if (onSchemaNamesLoaded) {
                onSchemaNamesLoaded(result.data);
            }
            const schemas = result.data;
            const records = schemas.map((schema) => [
                ...[schema],
                ...Array(PinotMethodUtils_1.default.allSchemaDetailsColumnHeader.length - 1)
                    .fill(null)
                    .map((_) => Loading_1.default),
            ]);
            setSchemaDetails({
                columns: PinotMethodUtils_1.default.allSchemaDetailsColumnHeader,
                records: records,
            });
            // Schema details are typically fast to fetch, so we fetch them all at once.
            PinotMethodUtils_1.default.getAllSchemaDetails(schemas).then((result) => {
                setSchemaDetails(result);
            });
        });
    });
    react_1.useEffect(() => {
        fetchSchemas();
    }, []);
    return (react_1.default.createElement(Table_1.default, { title: "Schemas", data: schemaDetails, showSearchBox: true, inAccordionFormat: true, addLinks: true, baseURL: "/tenants/schema/" }));
};


/***/ }),

/***/ "./app/components/AsyncPinotTables.tsx":
/*!*********************************************!*\
  !*** ./app/components/AsyncPinotTables.tsx ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const Table_1 = __importDefault(__webpack_require__(/*! ./Table */ "./app/components/Table.tsx"));
const requests_1 = __webpack_require__(/*! ../requests */ "./app/requests/index.ts");
const Utils_1 = __importDefault(__webpack_require__(/*! ../utils/Utils */ "./app/utils/Utils.tsx"));
const PinotMethodUtils_1 = __importDefault(__webpack_require__(/*! ../utils/PinotMethodUtils */ "./app/utils/PinotMethodUtils.ts"));
const TableTooltipData = [
    null,
    'Uncompressed size of all data segments with replication',
    'Estimated size of all data segments with replication, in case any servers are not reachable for actual size',
    null,
    'GOOD if all replicas of all segments are up',
];
exports.AsyncPinotTables = ({ title, instance, tenants, baseUrl, onTableNamesLoaded, }) => {
    const columnHeaders = [
        'Table Name',
        'Reported Size',
        'Estimated Size',
        'Number of Segments',
        'Status',
    ];
    const [tableData, setTableData] = react_1.useState(Utils_1.default.getLoadingTableData(columnHeaders));
    const fetchTenantData = (tenants) => __awaiter(void 0, void 0, void 0, function* () {
        Promise.all(tenants.map((tenant) => {
            return requests_1.getTenantTable(tenant);
        })).then((results) => {
            let allTableDetails = results.map((result) => {
                return result.data.tables.map((tableName) => {
                    const tableDetails = {
                        name: tableName,
                        estimated_size: null,
                        reported_size: null,
                        segment_status: null,
                        number_of_segments: null,
                    };
                    return tableDetails;
                });
            });
            const allTableDetailsFlattened = lodash_1.flatten(allTableDetails);
            const loadingTableData = {
                columns: columnHeaders,
                records: allTableDetailsFlattened.map((td) => Utils_1.default.pinotTableDetailsFormat(td)),
            };
            setTableData(loadingTableData);
            if (onTableNamesLoaded) {
                onTableNamesLoaded();
            }
            results.forEach((result) => {
                fetchAllTableDetails(result.data.tables);
            });
        });
    });
    const fetchInstanceTenants = (instance) => __awaiter(void 0, void 0, void 0, function* () {
        return PinotMethodUtils_1.default.getInstanceDetails(instance).then((instanceDetails) => {
            const tenants = instanceDetails.tags
                .filter((tag) => {
                return (tag.search('_BROKER') !== -1 ||
                    tag.search('_REALTIME') !== -1 ||
                    tag.search('_OFFLINE') !== -1);
            })
                .map((tag) => {
                return Utils_1.default.splitStringByLastUnderscore(tag)[0];
            });
            return lodash_1.uniq(tenants);
        });
    });
    const fetchAllTablesData = () => __awaiter(void 0, void 0, void 0, function* () {
        Promise.all([requests_1.getQueryTables('realtime'), requests_1.getQueryTables('offline')]).then((results) => {
            const realtimeTables = results[0].data.tables;
            const offlineTables = results[1].data.tables;
            const allTables = realtimeTables.concat(offlineTables);
            setTableData({
                columns: columnHeaders,
                records: allTables.map((tableName) => {
                    const tableDetails = {
                        name: tableName,
                        estimated_size: null,
                        reported_size: null,
                        segment_status: null,
                        number_of_segments: null,
                    };
                    return Utils_1.default.pinotTableDetailsFormat(tableDetails);
                }),
            });
            if (onTableNamesLoaded) {
                onTableNamesLoaded();
            }
            fetchAllTableDetails(allTables);
        });
    });
    const fetchAllTableDetails = (tables) => __awaiter(void 0, void 0, void 0, function* () {
        return tables.forEach((tableName) => {
            PinotMethodUtils_1.default.getSegmentCountAndStatus(tableName).then(({ segment_count, segment_status }) => {
                setTableData((prevState) => {
                    const newRecords = [...prevState.records];
                    const index = newRecords.findIndex((record) => record[0] === tableName);
                    newRecords[index] = Utils_1.default.pinotTableDetailsFormat(Object.assign(Object.assign({}, Utils_1.default.pinotTableDetailsFromArray(newRecords[index])), { number_of_segments: segment_count, segment_status: segment_status }));
                    return Object.assign(Object.assign({}, prevState), { records: newRecords });
                });
            });
            PinotMethodUtils_1.default.getTableSizes(tableName).then(({ reported_size, estimated_size }) => {
                setTableData((prevState) => {
                    const newRecords = [...prevState.records];
                    const index = newRecords.findIndex((record) => record[0] === tableName);
                    newRecords[index] = Utils_1.default.pinotTableDetailsFormat(Object.assign(Object.assign({}, Utils_1.default.pinotTableDetailsFromArray(newRecords[index])), { estimated_size: estimated_size, reported_size: reported_size }));
                    return Object.assign(Object.assign({}, prevState), { records: newRecords });
                });
            });
        });
    });
    react_1.useEffect(() => {
        if (instance) {
            fetchInstanceTenants(instance).then((tenants) => {
                fetchTenantData(tenants);
            });
        }
        else if (tenants) {
            fetchTenantData(tenants);
        }
        else {
            fetchAllTablesData();
        }
    }, [instance, tenants]);
    return (react_1.default.createElement(Table_1.default, { title: title, data: tableData, tooltipData: TableTooltipData, addLinks: true, baseURL: baseUrl, showSearchBox: true, inAccordionFormat: true }));
};
exports.default = exports.AsyncPinotTables;


/***/ }),

/***/ "./app/components/Breadcrumbs.tsx":
/*!****************************************!*\
  !*** ./app/components/Breadcrumbs.tsx ***!
  \****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const react_router_dom_1 = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router-dom/esm/react-router-dom.js");
const Breadcrumbs_1 = __importDefault(__webpack_require__(/*! @material-ui/core/Breadcrumbs */ "./node_modules/@material-ui/core/esm/Breadcrumbs/index.js"));
const Typography_1 = __importDefault(__webpack_require__(/*! @material-ui/core/Typography */ "./node_modules/@material-ui/core/esm/Typography/index.js"));
const Link_1 = __importDefault(__webpack_require__(/*! @material-ui/core/Link */ "./node_modules/@material-ui/core/esm/Link/index.js"));
const NavigateNext_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/NavigateNext */ "./node_modules/@material-ui/icons/NavigateNext.js"));
const Box_1 = __importDefault(__webpack_require__(/*! @material-ui/core/Box */ "./node_modules/@material-ui/core/esm/Box/index.js"));
const styles_1 = __webpack_require__(/*! @material-ui/core/styles */ "./node_modules/@material-ui/core/esm/styles/index.js");
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const useStyles = styles_1.makeStyles((theme) => styles_1.createStyles({
    root: {
        color: '#fff'
    }
}));
const LinkRouter = (props) => (
// We ignore this for now as there is a more complex setup required
// to make component={RouterLink} work correctly with typescript.
// See https://mui.com/guides/routing/
// @ts-ignore
react_1.default.createElement(Link_1.default, Object.assign({}, props, { component: react_router_dom_1.Link })));
const breadcrumbNameMap = {
    '/': 'Home',
    '/tenants': 'Tenants',
    '/controllers': 'Controllers',
    '/brokers': 'Brokers',
    '/servers': 'Servers',
    '/minions': 'Minions',
    '/minion-task-manager': 'Minion Task Manager',
    '/tables': 'Tables',
    '/query': 'Query Console',
    '/cluster': 'Cluster Manager',
    '/zookeeper': 'Zookeeper Browser',
    '/user': 'User Console'
};
const BreadcrumbsComponent = (_a) => {
    var props = __rest(_a, []);
    const location = react_router_dom_1.useLocation();
    const pathNames = location.pathname.split('/').filter((x) => x);
    const classes = useStyles();
    const getLabel = (name) => {
        return (react_1.default.createElement(Typography_1.default, { variant: "subtitle2", key: name, className: classes.root }, name));
    };
    const getClickableLabel = (name, link) => {
        return (react_1.default.createElement(LinkRouter, { underline: "none", variant: "subtitle2", to: link, key: name, className: classes.root }, name));
    };
    const generateBreadcrumb = () => {
        if (!pathNames.length) {
            return getLabel(breadcrumbNameMap['/']);
        }
        const breadcrumbs = [getClickableLabel(breadcrumbNameMap['/'], '/')];
        const paramsKeys = lodash_1.keys(props.match.params);
        if (paramsKeys.length) {
            const { tenantName, tableName, segmentName, instanceName, schemaName, query, taskType, queueTableName, taskID, subTaskID } = props.match.params;
            if ((tenantName || instanceName) && tableName) {
                breadcrumbs.push(getClickableLabel(tenantName || instanceName, (tenantName ? `/tenants/${tenantName}` : `/instance/${instanceName}`)));
            }
            if ((tenantName || instanceName) && tableName && segmentName) {
                breadcrumbs.push(getClickableLabel(tableName || instanceName, (tenantName ? `/tenants/${tenantName}/table/${tableName}` : `/instance/${instanceName}/table/${tableName}`)));
            }
            if ((tableName && segmentName && !tenantName && !instanceName)) {
                breadcrumbs.push(getClickableLabel('Tables', '/tables'), getClickableLabel(tableName, `/tenants/table/${tableName}`));
            }
            if (paramsKeys.length === 1 && tableName) {
                breadcrumbs.push(getClickableLabel('Tables', '/tables'));
            }
            if (schemaName) {
                breadcrumbs.push(getClickableLabel('Schemas', '/tables'));
            }
            if (taskType) {
                breadcrumbs.push(getClickableLabel('Minion Task Manager', `/minion-task-manager`));
            }
            if (queueTableName) {
                breadcrumbs.push(getClickableLabel(taskType, `/task-queue/${taskType}`));
            }
            if (taskID) {
                breadcrumbs.push(getClickableLabel('Tasks', `/task-queue/${taskType}/tables/${queueTableName}`));
            }
            if (subTaskID) {
                breadcrumbs.push(getClickableLabel('Sub Tasks', `/task-queue/${taskType}/tables/${queueTableName}/task/${taskID}`));
            }
            breadcrumbs.push(getLabel(segmentName || tableName || tenantName || instanceName || schemaName || subTaskID || taskID || queueTableName || taskType || 'Query Console'));
        }
        else {
            breadcrumbs.push(getLabel(breadcrumbNameMap[location.pathname]));
        }
        return breadcrumbs;
    };
    return (react_1.default.createElement(Box_1.default, { marginY: "auto", padding: "0.25rem 1.5rem", display: "flex" },
        react_1.default.createElement(Breadcrumbs_1.default, { separator: react_1.default.createElement(NavigateNext_1.default, { style: { fill: '#fff' } }), "aria-label": "breadcrumb" }, generateBreadcrumb())));
};
exports.default = BreadcrumbsComponent;


/***/ }),

/***/ "./app/components/ComponentLoader.tsx":
/*!********************************************!*\
  !*** ./app/components/ComponentLoader.tsx ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const React = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const CircularProgress_1 = __importDefault(__webpack_require__(/*! @material-ui/core/CircularProgress */ "./node_modules/@material-ui/core/esm/CircularProgress/index.js"));
const styles_1 = __webpack_require__(/*! @material-ui/core/styles */ "./node_modules/@material-ui/core/esm/styles/index.js");
const useStyles = styles_1.makeStyles((theme) => styles_1.createStyles({
    root: {
        display: 'flex',
        justifyContent: 'center',
        alignItems: 'center',
        padding: '10px',
        '& svg > circle': {
            stroke: 'primary',
        },
    },
}));
const ComponentLoader = () => {
    const classes = useStyles();
    return React.createElement(CircularProgress_1.default, { className: classes.root });
};
exports.default = ComponentLoader;


/***/ }),

/***/ "./app/components/Confirm.tsx":
/*!************************************!*\
  !*** ./app/components/Confirm.tsx ***!
  \************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/* eslint-disable no-nested-ternary */
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const colors_1 = __webpack_require__(/*! @material-ui/core/colors */ "./node_modules/@material-ui/core/esm/colors/index.js");
const useStyles = core_1.makeStyles((theme) => ({
    dialogContent: {
        minWidth: 900
    },
    dialogTextContent: {
        fontWeight: 600
    },
    dialogActions: {
        justifyContent: 'center'
    },
    green: {
        fontWeight: 600,
        color: colors_1.green[500],
        borderColor: colors_1.green[500],
        '&:hover': {
            backgroundColor: colors_1.green[50],
            borderColor: colors_1.green[500]
        }
    },
    red: {
        fontWeight: 600,
        color: colors_1.red[500],
        borderColor: colors_1.red[500],
        '&:hover': {
            backgroundColor: colors_1.red[50],
            borderColor: colors_1.red[500]
        }
    }
}));
const Confirm = ({ openDialog, dialogTitle, dialogContent, successCallback, closeDialog, dialogYesLabel = 'Yes', dialogNoLabel = 'No' }) => {
    const classes = useStyles();
    const [open, setOpen] = react_1.default.useState(openDialog);
    react_1.useEffect(() => {
        setOpen(openDialog);
    }, [openDialog]);
    const isStringDialog = typeof dialogContent === 'string';
    return (react_1.default.createElement("div", null,
        react_1.default.createElement(core_1.Dialog, { open: open, onClose: closeDialog, "aria-labelledby": "alert-dialog-title", "aria-describedby": "alert-dialog-description", maxWidth: false },
            dialogTitle && react_1.default.createElement(core_1.DialogTitle, { id: "alert-dialog-title" }, dialogTitle),
            react_1.default.createElement(core_1.DialogContent, { className: `${!isStringDialog ? classes.dialogContent : ''}` }, isStringDialog ?
                react_1.default.createElement(core_1.DialogContentText, { id: "alert-dialog-description", className: classes.dialogTextContent }, dialogContent)
                : dialogContent),
            react_1.default.createElement(core_1.DialogActions, { style: { paddingBottom: 20 }, className: `${isStringDialog ? classes.dialogActions : ''}` },
                react_1.default.createElement(core_1.Button, { variant: "outlined", onClick: closeDialog, color: "secondary", className: classes.red }, dialogNoLabel || 'No'),
                react_1.default.createElement(core_1.Button, { variant: "outlined", onClick: successCallback, color: "primary", autoFocus: true, className: classes.green }, dialogYesLabel || 'Yes')))));
};
exports.default = Confirm;
function useConfirm({ dialogTitle, dialogContent, successCallback, closeDialog, dialogYesLabel, dialogNoLabel }) {
    const [confirmDialog, setConfirmDialog] = react_1.default.useState(false);
    return {
        confirmDialog,
        setConfirmDialog,
        confirmComponent: (react_1.default.createElement(Confirm, { openDialog: confirmDialog, dialogTitle: dialogTitle, dialogContent: dialogContent, successCallback: successCallback, closeDialog: () => setConfirmDialog(false), dialogYesLabel: dialogYesLabel, dialogNoLabel: dialogNoLabel }))
    };
}
exports.useConfirm = useConfirm;


/***/ }),

/***/ "./app/components/CustomButton.tsx":
/*!*****************************************!*\
  !*** ./app/components/CustomButton.tsx ***!
  \*****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const useStyles = core_1.makeStyles((theme) => ({
    button: {
        margin: theme.spacing(1),
        textTransform: 'none'
    }
}));
function CustomButton({ children, isDisabled, onClick, tooltipTitle = '', enableTooltip = false }) {
    const classes = useStyles();
    return (react_1.default.createElement(core_1.Tooltip, { title: tooltipTitle, disableHoverListener: !enableTooltip, placement: "top", arrow: true },
        react_1.default.createElement(core_1.Button, { variant: "contained", color: "primary", className: classes.button, size: "small", onClick: onClick, disabled: isDisabled }, children)));
}
exports.default = CustomButton;


/***/ }),

/***/ "./app/components/CustomCodemirror.tsx":
/*!*********************************************!*\
  !*** ./app/components/CustomCodemirror.tsx ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/* eslint-disable no-nested-ternary */
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const react_codemirror2_1 = __webpack_require__(/*! react-codemirror2 */ "./node_modules/react-codemirror2/index.js");
__webpack_require__(/*! codemirror/lib/codemirror.css */ "./node_modules/codemirror/lib/codemirror.css");
__webpack_require__(/*! codemirror/theme/material.css */ "./node_modules/codemirror/theme/material.css");
__webpack_require__(/*! codemirror/addon/lint/lint.css */ "./node_modules/codemirror/addon/lint/lint.css");
__webpack_require__(/*! codemirror/mode/javascript/javascript */ "./node_modules/codemirror/mode/javascript/javascript.js");
__webpack_require__(/*! codemirror/addon/lint/lint */ "./node_modules/codemirror/addon/lint/lint.js");
__webpack_require__(/*! codemirror/addon/lint/json-lint */ "./node_modules/codemirror/addon/lint/json-lint.js");
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const clsx_1 = __importDefault(__webpack_require__(/*! clsx */ "./node_modules/clsx/dist/clsx.m.js"));
window.jsonlint = __webpack_require__(/*! jsonlint */ "./node_modules/jsonlint/lib/jsonlint.js");
const useStyles = core_1.makeStyles((theme) => ({
    codeMirror: {
        '& .CodeMirror': { height: 600, border: '1px solid #BDCCD9', fontSize: '13px' },
    },
    switch: {
        '& .MuiFormControlLabel-root': { marginLeft: '0px' },
    },
}));
const CustomCodemirror = ({ data, isEditable, returnCodemirrorValue, customClass = '', showLineWrapToggle = false }) => {
    const classes = useStyles();
    const [isWrappedToggled, setWrappedToggled] = react_1.useState(false);
    const wrapToggle = (react_1.default.createElement(core_1.Switch, { color: "primary" }));
    const wrapToggleGroup = (react_1.default.createElement(core_1.FormGroup, { className: clsx_1.default(classes.switch) },
        react_1.default.createElement(core_1.FormControlLabel, { control: wrapToggle, label: "Wrap lines", checked: isWrappedToggled, onChange: (event, checked) => setWrappedToggled(checked) })));
    const jsonoptions = {
        lineNumbers: true,
        mode: 'application/json',
        styleActiveLine: true,
        gutters: ['CodeMirror-lint-markers'],
        lint: isEditable || false,
        theme: 'default',
        readOnly: !isEditable,
        lineWrapping: isWrappedToggled,
    };
    return (react_1.default.createElement(react_1.default.Fragment, null,
        showLineWrapToggle && wrapToggleGroup,
        react_1.default.createElement(react_codemirror2_1.UnControlled, { options: jsonoptions, value: typeof data === 'string' ? data : JSON.stringify(data, null, 2), className: clsx_1.default(classes.codeMirror, customClass), autoCursor: false, onChange: (editor, d, value) => {
                returnCodemirrorValue && returnCodemirrorValue(value);
            } })));
};
exports.default = CustomCodemirror;


/***/ }),

/***/ "./app/components/CustomDialog.tsx":
/*!*****************************************!*\
  !*** ./app/components/CustomDialog.tsx ***!
  \*****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const colors_1 = __webpack_require__(/*! @material-ui/core/colors */ "./node_modules/@material-ui/core/esm/colors/index.js");
const useStyles = core_1.makeStyles((theme) => ({
    root: {
        '& .MuiDialog-container > .MuiPaper-root': {
            minWidth: '600px'
        },
        "& .MuiDialogContent-root": {
            padding: 8
        }
    },
    dialogTitle: {
        padding: '10px 24px',
    }
}));
const CancelButton = core_1.withStyles(() => ({
    root: {
        color: colors_1.red[500],
        borderColor: colors_1.red[500],
        '&:hover': {
            borderColor: colors_1.red[700],
        },
    },
}))(core_1.Button);
function CustomDialog({ open, handleClose, handleSave, title, children, btnCancelText, btnOkText, showCancelBtn = true, showOkBtn = true, size, disableBackdropClick = false, disableEscapeKeyDown = false }) {
    const classes = useStyles();
    return (react_1.default.createElement(core_1.Dialog, { open: open, onClose: handleClose, "aria-labelledby": "form-dialog-title", className: classes.root, maxWidth: size, fullWidth: size ? true : false, disableBackdropClick: disableBackdropClick, disableEscapeKeyDown: disableEscapeKeyDown },
        react_1.default.createElement(core_1.DialogTitle, { className: classes.dialogTitle }, title),
        react_1.default.createElement(core_1.DialogContent, null, children),
        react_1.default.createElement(core_1.DialogActions, null,
            showCancelBtn &&
                react_1.default.createElement(CancelButton, { onClick: handleClose, variant: "outlined" }, btnCancelText || 'Cancel'),
            showOkBtn &&
                react_1.default.createElement(core_1.Button, { onClick: handleSave, variant: "outlined", color: "primary" }, btnOkText || 'Save'))));
}
exports.default = CustomDialog;


/***/ }),

/***/ "./app/components/CustomMultiSelect.tsx":
/*!**********************************************!*\
  !*** ./app/components/CustomMultiSelect.tsx ***!
  \**********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const Chip_1 = __importDefault(__webpack_require__(/*! @material-ui/core/Chip */ "./node_modules/@material-ui/core/esm/Chip/index.js"));
const Autocomplete_1 = __importDefault(__webpack_require__(/*! @material-ui/lab/Autocomplete */ "./node_modules/@material-ui/lab/esm/Autocomplete/index.js"));
const TextField_1 = __importDefault(__webpack_require__(/*! @material-ui/core/TextField */ "./node_modules/@material-ui/core/esm/TextField/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const StyledAutoComplete = core_1.withStyles(() => ({
    tag: {
        margin: '10px 5px 5px 0',
        border: '1px solid #4285F4',
        color: '#4285F4',
        '& .MuiChip-deleteIcon': {
            color: 'rgba(66, 133, 244, 0.6)',
            '&:hover': {
                color: 'rgb(66, 133, 244)'
            }
        }
    },
    option: {
        '&[data-focus="true"]': {
            backgroundColor: 'rgba(143, 182, 249, 0.3)',
            color: '#4285F4',
        },
        '&[aria-selected="true"]': {
            backgroundColor: '#4285F4',
            color: 'white'
        },
    },
    inputRoot: {
        paddingTop: '0 !important',
        backgroundColor: 'white !important',
        '&:hover': {
            backgroundColor: 'white !important'
        }
    },
}))(Autocomplete_1.default);
const CustomMultiSelect = react_1.forwardRef(({ options, value, handleChange, error }, ref) => {
    const [currentValue, setCurrentValue] = react_1.useState(value);
    react_1.useEffect(() => {
        setCurrentValue(value);
    }, [value]);
    const handleKeyDown = event => {
        switch (event.key) {
            case ",":
            case " ": {
                event.preventDefault();
                event.stopPropagation();
                if (event.target.value.length > 0) {
                    handleChange(event, [...value, event.target.value]);
                }
                break;
            }
            default:
        }
    };
    return (react_1.default.createElement(StyledAutoComplete, { multiple: true, options: options || [], value: currentValue, freeSolo: true, onChange: handleChange, renderTags: (values, getTagProps) => values.map((option, index) => (react_1.default.createElement(Chip_1.default, Object.assign({ key: index, variant: "outlined", label: option }, getTagProps({ index }))))), renderInput: (params) => {
            {
                params.inputProps.onKeyDown = handleKeyDown;
                return (react_1.default.createElement(TextField_1.default, Object.assign({ inputRef: ref, error: error && error.isError, helperText: error && error.errorMessage }, params, { variant: "filled", placeholder: "Enter Tags ..." })));
            }
        } }));
});
exports.default = CustomMultiSelect;


/***/ }),

/***/ "./app/components/CustomNotification.tsx":
/*!***********************************************!*\
  !*** ./app/components/CustomNotification.tsx ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const Alert_1 = __importDefault(__webpack_require__(/*! @material-ui/lab/Alert */ "./node_modules/@material-ui/lab/esm/Alert/index.js"));
const NotificationContext_1 = __webpack_require__(/*! ./Notification/NotificationContext */ "./app/components/Notification/NotificationContext.tsx");
const Alert = (props) => {
    return react_1.default.createElement(Alert_1.default, Object.assign({ elevation: 6, variant: "filled" }, props));
};
const CustomNotification = () => {
    return (react_1.default.createElement(NotificationContext_1.NotificationContext.Consumer, null, context => react_1.default.createElement(core_1.Snackbar, { anchorOrigin: { vertical: 'top', horizontal: 'right' }, open: context && context.show, onClose: () => {
            context.dispatch({ type: '', message: "", show: false });
            context.hide && context.hide();
        }, autoHideDuration: 10000 },
        react_1.default.createElement(Alert, { onClose: context.hide && context.hide(), severity: (context && context.type) || 'warning' }, context && context.message))));
};
exports.default = CustomNotification;


/***/ }),

/***/ "./app/components/Header.tsx":
/*!***********************************!*\
  !*** ./app/components/Header.tsx ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const react_router_dom_1 = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router-dom/esm/react-router-dom.js");
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const Menu_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/Menu */ "./node_modules/@material-ui/icons/Menu.js"));
const Logo_1 = __importDefault(__webpack_require__(/*! ./SvgIcons/Logo */ "./app/components/SvgIcons/Logo.tsx"));
const Breadcrumbs_1 = __importDefault(__webpack_require__(/*! ./Breadcrumbs */ "./app/components/Breadcrumbs.tsx"));
const useStyles = core_1.makeStyles((theme) => ({
    breadcrumbRoot: {
        flexGrow: 1
    },
    paper: {
        padding: '0 0.5rem',
        color: '#fff',
        textAlign: 'center',
        backgroundColor: 'rgba(66, 133, 244, 0.1)',
        boxShadow: 'none',
        fontSize: 'smaller',
        '& h2, h4': {
            margin: 0,
        },
        '& h2': {
            fontWeight: 600
        },
        '& h4': {
            textTransform: 'uppercase',
            letterSpacing: 1,
            fontWeight: 500
        }
    }
}));
const Header = (_a) => {
    var { highlightSidebarLink, showHideSideBarHandler, openSidebar, clusterName } = _a, props = __rest(_a, ["highlightSidebarLink", "showHideSideBarHandler", "openSidebar", "clusterName"]);
    const classes = useStyles();
    return (react_1.default.createElement(core_1.AppBar, { position: "static" },
        react_1.default.createElement(core_1.Box, { display: "flex" },
            react_1.default.createElement(core_1.Box, { textAlign: "center", marginY: "12.5px", width: openSidebar ? 250 : 90, borderRight: "1px solid rgba(255,255,255,0.5)" },
                react_1.default.createElement(react_router_dom_1.Link, { to: "/", style: { color: '#ffffff' } },
                    react_1.default.createElement(Logo_1.default, { onClick: () => highlightSidebarLink(1), fulllogo: openSidebar.toString() }))),
            react_1.default.createElement(core_1.Box, { display: "flex", alignItems: "center", className: classes.breadcrumbRoot },
                react_1.default.createElement(core_1.Box, { marginY: "auto", padding: "0.25rem 0 0.25rem 1.5rem", display: "flex", style: { cursor: 'pointer' } },
                    react_1.default.createElement(Menu_1.default, { onClick: () => showHideSideBarHandler() })),
                react_1.default.createElement(Breadcrumbs_1.default, Object.assign({}, props))),
            react_1.default.createElement(core_1.Box, { textAlign: "center", marginY: "11.5px", borderLeft: "1px solid rgba(255,255,255,0.5)" },
                react_1.default.createElement(core_1.Paper, { className: classes.paper },
                    react_1.default.createElement("h4", null, "Cluster Name"),
                    react_1.default.createElement("h2", null, clusterName))))));
};
exports.default = Header;


/***/ }),

/***/ "./app/components/Homepage/ClusterConfig.tsx":
/*!***************************************************!*\
  !*** ./app/components/Homepage/ClusterConfig.tsx ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const AppLoader_1 = __importDefault(__webpack_require__(/*! ../AppLoader */ "./app/components/AppLoader.tsx"));
const Table_1 = __importDefault(__webpack_require__(/*! ../Table */ "./app/components/Table.tsx"));
const PinotMethodUtils_1 = __importDefault(__webpack_require__(/*! ../../utils/PinotMethodUtils */ "./app/utils/PinotMethodUtils.ts"));
const ClusterConfig = () => {
    const [fetching, setFetching] = react_1.useState(true);
    const [tableData, setTableData] = react_1.useState({
        columns: [],
        records: []
    });
    const fetchData = () => __awaiter(void 0, void 0, void 0, function* () {
        const result = yield PinotMethodUtils_1.default.getClusterConfigData();
        setTableData(result);
        setFetching(false);
    });
    react_1.useEffect(() => {
        fetchData();
    }, []);
    return (fetching ? react_1.default.createElement(AppLoader_1.default, null) :
        react_1.default.createElement(Table_1.default, { title: "Cluster configuration", data: tableData, showSearchBox: true, inAccordionFormat: true }));
};
exports.default = ClusterConfig;


/***/ }),

/***/ "./app/components/Homepage/InstancesTables.tsx":
/*!*****************************************************!*\
  !*** ./app/components/Homepage/InstancesTables.tsx ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const AsyncInstanceTable_1 = __webpack_require__(/*! ../AsyncInstanceTable */ "./app/components/AsyncInstanceTable.tsx");
const Instances = ({ clusterName, instanceType }) => {
    const order = [
        "controller" /* CONTROLLER */,
        "broker" /* BROKER */,
        "server" /* SERVER */,
        "minion" /* MINION */,
    ];
    return (react_1.default.createElement(react_1.default.Fragment, null, order
        .filter((key) => !instanceType || instanceType === key)
        .map((key) => {
        return (react_1.default.createElement(AsyncInstanceTable_1.AsyncInstanceTable, { key: lodash_1.startCase(key), cluster: clusterName, instanceType: key, showInstanceDetails: true }));
    })));
};
exports.default = Instances;


/***/ }),

/***/ "./app/components/Homepage/Operations/AddDeleteComponent.tsx":
/*!*******************************************************************!*\
  !*** ./app/components/Homepage/Operations/AddDeleteComponent.tsx ***!
  \*******************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const AddCircle_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/AddCircle */ "./node_modules/@material-ui/icons/AddCircle.js"));
const Clear_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/Clear */ "./node_modules/@material-ui/icons/Clear.js"));
const useStyles = core_1.makeStyles((theme) => core_1.createStyles({
    formControl: {
        margin: theme.spacing(1),
        width: '100%'
    },
    deleteIcon: {
        marginTop: 15,
        marginLeft: -15,
        color: theme.palette.error.main
    },
    selectFormControl: {
        margin: theme.spacing(1),
        width: 170
    },
    autoCompleteControl: {
        '& .MuiFormControl-marginNormal': {
            marginTop: 0
        }
    },
    redColor: {
        color: theme.palette.error.main
    }
}));
const compulsoryKeys = ["stream.kafka.broker.list", "stream.kafka.topic.name", "stream.kafka.consumer.type", "stream.kafka.decoder.class.name"];
function AddDeleteComponent({ changeHandler, streamConfigsObj }) {
    const classes = useStyles();
    const [streamConfigObj, setStreamConfigObj] = react_1.useState(streamConfigsObj);
    const [keys, setKeys] = react_1.useState(Object.keys(streamConfigObj));
    const [value, setValue] = react_1.useState(Object.values(streamConfigObj));
    const addButtonClick = () => {
        let data = "";
        let tempStreamConfigObj = Object.assign(Object.assign({}, streamConfigObj), { [data]: data });
        setStreamConfigObj(tempStreamConfigObj);
        changeHandler('streamConfigs', tempStreamConfigObj);
    };
    const keyChange = (input, index, value) => {
        input[index] = value;
        setKeys([...input]);
    };
    const valueChange = (input, index, value) => {
        input[index] = value;
        setValue([...input]);
    };
    const updateJson = () => {
        let configObj = {};
        keys.map((k, i) => {
            configObj[k] = value[i];
        });
        changeHandler('streamConfigs', configObj);
    };
    const deleteClick = (val) => {
        let tempStreamConfigObj = Object.assign({}, streamConfigObj);
        delete tempStreamConfigObj[val];
        setStreamConfigObj(tempStreamConfigObj);
        setKeys([]);
        setValue([]);
        changeHandler('streamConfigs', tempStreamConfigObj);
    };
    react_1.useEffect(() => {
        setStreamConfigObj(streamConfigsObj);
        setKeys(Object.keys(streamConfigObj));
        setValue(Object.values(streamConfigObj));
    }, [streamConfigsObj]);
    const requiredAstrix = react_1.default.createElement("span", { className: classes.redColor }, "*");
    return (react_1.default.createElement(core_1.Grid, { container: true },
        react_1.default.createElement(core_1.Tooltip, { title: "Configure the properties of your stream.", arrow: true, placement: "top" },
            react_1.default.createElement("h3", { className: "accordion-subtitle" }, "Stream Config")),
        keys.map((o, i) => {
            return (react_1.default.createElement(core_1.Grid, { item: true, xs: 6 },
                react_1.default.createElement("div", { className: "box-border" },
                    react_1.default.createElement(core_1.Grid, { container: true, spacing: 2 },
                        react_1.default.createElement(core_1.Grid, { item: true, xs: 6 },
                            react_1.default.createElement(core_1.FormControl, { className: classes.formControl },
                                react_1.default.createElement(core_1.InputLabel, { htmlFor: o },
                                    "Key ",
                                    compulsoryKeys.includes(o) && requiredAstrix),
                                react_1.default.createElement(core_1.Input, { id: o, value: o, key: i + "key", onChange: (e) => keyChange(keys, i, e.target.value), onBlur: updateJson }))),
                        react_1.default.createElement(core_1.Grid, { item: true, xs: 5 },
                            react_1.default.createElement(core_1.FormControl, { className: classes.formControl },
                                react_1.default.createElement(core_1.InputLabel, { htmlFor: value[i] }, "Value"),
                                react_1.default.createElement(core_1.Input, { id: value[i], value: value[i], key: i + "value", onChange: (e) => valueChange(value, i, e.target.value), onBlur: updateJson }))),
                        react_1.default.createElement(core_1.Grid, { item: true, xs: 1 },
                            react_1.default.createElement(core_1.FormControl, null,
                                react_1.default.createElement(core_1.IconButton, { "aria-label": "delete", key: "delete" + i, className: classes.deleteIcon, onClick: () => {
                                        deleteClick(o);
                                    } },
                                    react_1.default.createElement(Clear_1.default, null))))))));
        }),
        react_1.default.createElement(core_1.Grid, { item: true, xs: 3 },
            react_1.default.createElement(core_1.FormControl, { className: classes.formControl },
                react_1.default.createElement(core_1.Button, { "aria-label": "plus", variant: "outlined", color: "primary", onClick: addButtonClick, startIcon: (react_1.default.createElement(AddCircle_1.default, null)) }, "Add new Field")))));
}
exports.default = AddDeleteComponent;


/***/ }),

/***/ "./app/components/Homepage/Operations/AddIndexingComponent.tsx":
/*!*********************************************************************!*\
  !*** ./app/components/Homepage/Operations/AddIndexingComponent.tsx ***!
  \*********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const MultiIndexingComponent_1 = __importDefault(__webpack_require__(/*! ./MultiIndexingComponent */ "./app/components/Homepage/Operations/MultiIndexingComponent.tsx"));
const useStyles = core_1.makeStyles((theme) => core_1.createStyles({
    formControl: {
        margin: theme.spacing(1),
        minWidth: 120,
    },
    selectFormControl: {
        margin: theme.spacing(1),
        width: 220
    }
}));
function AddIndexingComponent({ tableObj, setTableObj, columnName }) {
    const classes = useStyles();
    const [tableDataObj, setTableDataObj] = react_1.useState(tableObj);
    const [showTree, setShowTree] = react_1.useState(0);
    const ITEM_HEIGHT = 48;
    const ITEM_PADDING_TOP = 8;
    const MenuProps = {
        PaperProps: {
            style: {
                maxHeight: ITEM_HEIGHT * 4.5 + ITEM_PADDING_TOP,
                width: 250,
            },
        },
    };
    const changeHandler = (fieldName, value) => {
        let newTableObj = Object.assign({}, tableDataObj);
        switch (fieldName) {
            case 'maxLeafRecords':
                newTableObj.tableIndexConfig.starTreeIndexConfigs[0].maxLeafRecords = value;
                // newTableObj.segmentsConfig.schemaName = value;
                break;
            case 'enableStarTree':
                setShowTree(value);
                break;
            case 'dimensionsSplitOrder':
                if (!newTableObj.tableIndexConfig.starTreeIndexConfigs) {
                    newTableObj.tableIndexConfig.starTreeIndexConfigs = [];
                    newTableObj.tableIndexConfig.starTreeIndexConfigs[0] = {};
                }
                newTableObj.tableIndexConfig.starTreeIndexConfigs[0].dimensionsSplitOrder = value;
                break;
            case 'maxLeafRecords':
                if (!newTableObj.tableIndexConfig.starTreeIndexConfigs) {
                    newTableObj.tableIndexConfig.starTreeIndexConfigs = [];
                    newTableObj.tableIndexConfig.starTreeIndexConfigs[0] = {};
                }
                newTableObj.tableIndexConfig.starTreeIndexConfigs[0].maxLeafRecords = value;
                break;
            case 'tableIndexConfig':
                newTableObj.tableIndexConfig = Object.assign(Object.assign({}, newTableObj.tableIndexConfig), value.tableIndexConfig);
                newTableObj.fieldConfigList = [...value.fieldConfigList];
                break;
        }
        ;
        setTableDataObj(newTableObj);
        setTableObj(newTableObj);
    };
    react_1.useEffect(() => {
        setTableDataObj(tableObj);
    }, [tableObj]);
    return (react_1.default.createElement(core_1.Grid, { container: true, spacing: 2 },
        react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
            react_1.default.createElement(MultiIndexingComponent_1.default, { key: "multiIndex", streamConfigsObj: Object.assign({}, tableDataObj.tableIndexConfig), textDataObj: tableDataObj.fieldConfigList ? [...tableDataObj.fieldConfigList] : [], changeHandler: changeHandler, tableDataObj: tableDataObj, columnName: columnName }))));
}
exports.default = AddIndexingComponent;


/***/ }),

/***/ "./app/components/Homepage/Operations/AddIngestionComponent.tsx":
/*!**********************************************************************!*\
  !*** ./app/components/Homepage/Operations/AddIngestionComponent.tsx ***!
  \**********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const AddDeleteComponent_1 = __importDefault(__webpack_require__(/*! ./AddDeleteComponent */ "./app/components/Homepage/Operations/AddDeleteComponent.tsx"));
const MultipleSelectComponent_1 = __importDefault(__webpack_require__(/*! ./MultipleSelectComponent */ "./app/components/Homepage/Operations/MultipleSelectComponent.tsx"));
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const useStyles = core_1.makeStyles((theme) => core_1.createStyles({
    formControl: {
        margin: theme.spacing(1),
        minWidth: 120,
    },
    selectFormControl: {
        margin: theme.spacing(1),
        width: 220
    },
}));
function AddIngestionComponent({ tableObj, setTableObj, columnName }) {
    const classes = useStyles();
    const [newSize, setNewSize] = react_1.useState([0, 1]);
    const [tableDataObj, setTableDataObj] = react_1.useState(tableObj);
    const changeHandler = (fieldName, value) => {
        let newTableObj = Object.assign({}, tableDataObj);
        switch (fieldName) {
            case 'filterConfig':
                newTableObj.ingestionConfig.filterConfig[fieldName] = value;
                break;
            case 'segmentPushFrequency':
                newTableObj.segmentsConfig[fieldName] = value;
                break;
            case 'segmentPushType':
                newTableObj.segmentsConfig[fieldName] = value;
                break;
            case 'streamConfigs':
                newTableObj.tableIndexConfig.streamConfigs = Object.assign({}, value);
                break;
            case 'filterFunction':
                if (!newTableObj.ingestionConfig.filterConfig) {
                    newTableObj.ingestionConfig.filterConfig = {};
                }
                newTableObj.ingestionConfig.filterConfig.filterFunction = value;
                break;
            case 'transformConfigs':
                tableDataObj.ingestionConfig.transformConfigs = value;
        }
        ;
        setTableDataObj(newTableObj);
        setTableObj(newTableObj);
    };
    react_1.useEffect(() => {
        let newTableObj = Object.assign({}, tableObj);
        if (newTableObj.tableType === "REALTIME" && !newTableObj.streamConfigs && lodash_1.isEmpty(newTableObj.streamConfigs)) {
            newTableObj.tableIndexConfig.streamConfigs =
                {
                    "streamType": "kafka",
                    "stream.kafka.topic.name": "",
                    "stream.kafka.broker.list": "",
                    "stream.kafka.consumer.type": "lowlevel",
                    "stream.kafka.consumer.prop.auto.offset.reset": "smallest",
                    "stream.kafka.consumer.factory.class.name": "org.apache.pinot.plugin.stream.kafka20.KafkaConsumerFactory",
                    "stream.kafka.decoder.class.name": "org.apache.pinot.plugin.stream.kafka.KafkaJSONMessageDecoder",
                    "realtime.segment.flush.threshold.rows": "0",
                    "realtime.segment.flush.threshold.time": "24h",
                    "realtime.segment.flush.threshold.segment.size": "100M"
                };
            setTableObj(newTableObj);
        }
        else if (newTableObj.tableType !== "REALTIME" && newTableObj.streamConfigs) {
            newTableObj.streamConfigs = null;
            setTableObj(newTableObj);
        }
        setTableDataObj(newTableObj);
    }, [tableObj]);
    react_1.useEffect(() => {
        setNewSize(newSize);
    }, [newSize]);
    return (react_1.default.createElement(core_1.Grid, { container: true, spacing: 2 },
        react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
            tableDataObj.tableType === "OFFLINE" ?
                react_1.default.createElement(core_1.FormControl, { className: classes.selectFormControl },
                    react_1.default.createElement(core_1.InputLabel, { htmlFor: "segmentPushFrequency" }, "Offline push frequency"),
                    react_1.default.createElement(core_1.Select, { labelId: "segmentPushFrequency", id: "segmentPushFrequency", value: tableDataObj.segmentsConfig.segmentPushFrequency !== "" ? tableDataObj.segmentsConfig.segmentPushFrequency : "", onChange: (e) => changeHandler('segmentPushFrequency', e.target.value) },
                        react_1.default.createElement(core_1.MenuItem, { value: "HOURLY" }, "HOURLY"),
                        react_1.default.createElement(core_1.MenuItem, { value: "DAILY" }, "DAILY"))) : null,
            tableDataObj.tableType === "OFFLINE" ?
                react_1.default.createElement(core_1.FormControl, { className: classes.selectFormControl },
                    react_1.default.createElement(core_1.InputLabel, { htmlFor: "segmentPushType" }, "Offline push type"),
                    react_1.default.createElement(core_1.Select, { labelId: "segmentPushType", id: "segmentPushType", value: tableDataObj.segmentsConfig.segmentPushType !== "" ? tableDataObj.segmentsConfig.segmentPushType : "", onChange: (e) => changeHandler('segmentPushType', e.target.value) },
                        react_1.default.createElement(core_1.MenuItem, { value: "APPEND" }, "APPEND"),
                        react_1.default.createElement(core_1.MenuItem, { value: "REFRESH" }, "REFRESH"))) : null),
        react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
            react_1.default.createElement(core_1.Tooltip, { interactive: true, title: (react_1.default.createElement(react_1.default.Fragment, null,
                    "Filter out rows which match condition.",
                    react_1.default.createElement("a", { target: "_blank", href: "https://docs.pinot.apache.org/developers/advanced/ingestion-level-transformations#filtering", className: "tooltip-link" }, "(Click here for more details)"))), arrow: true, placement: "top-start" },
                react_1.default.createElement(core_1.FormControl, { className: classes.formControl },
                    react_1.default.createElement(core_1.InputLabel, { htmlFor: "filterFunction" }, "Filter function"),
                    react_1.default.createElement(core_1.Input, { id: "filterFunction", value: tableObj.ingestionConfig.filterConfig && tableObj.ingestionConfig.filterConfig.filterFunction || "", onChange: (e) => changeHandler('filterFunction', e.target.value) }))),
            tableDataObj.tableIndexConfig.streamConfigs ?
                react_1.default.createElement(AddDeleteComponent_1.default, { key: "streamConfigs", streamConfigsObj: Object.assign({}, tableDataObj.tableIndexConfig.streamConfigs), changeHandler: changeHandler })
                : null,
            react_1.default.createElement(core_1.Tooltip, { interactive: true, title: (react_1.default.createElement(react_1.default.Fragment, null,
                    "Transform the data values using Groovy or other inbuilt functions.",
                    react_1.default.createElement("a", { target: "_blank", href: "https://docs.pinot.apache.org/developers/advanced/ingestion-level-transformations#column-transformation", className: "tooltip-link" }, "(Click here for more details)"))), arrow: true, placement: "top-start" },
                react_1.default.createElement(MultipleSelectComponent_1.default, { key: "transformConfigs", streamConfigsObj: tableDataObj.ingestionConfig.transformConfigs || [], changeHandler: changeHandler, columnName: columnName })))));
}
exports.default = AddIngestionComponent;


/***/ }),

/***/ "./app/components/Homepage/Operations/AddOfflineTableOp.tsx":
/*!******************************************************************!*\
  !*** ./app/components/Homepage/Operations/AddOfflineTableOp.tsx ***!
  \******************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const CustomDialog_1 = __importDefault(__webpack_require__(/*! ../../CustomDialog */ "./app/components/CustomDialog.tsx"));
const SimpleAccordion_1 = __importDefault(__webpack_require__(/*! ../../SimpleAccordion */ "./app/components/SimpleAccordion.tsx"));
const AddTableComponent_1 = __importDefault(__webpack_require__(/*! ./AddTableComponent */ "./app/components/Homepage/Operations/AddTableComponent.tsx"));
const CustomCodemirror_1 = __importDefault(__webpack_require__(/*! ../../CustomCodemirror */ "./app/components/CustomCodemirror.tsx"));
const PinotMethodUtils_1 = __importDefault(__webpack_require__(/*! ../../../utils/PinotMethodUtils */ "./app/utils/PinotMethodUtils.ts"));
const NotificationContext_1 = __webpack_require__(/*! ../../Notification/NotificationContext */ "./app/components/Notification/NotificationContext.tsx");
const AddIngestionComponent_1 = __importDefault(__webpack_require__(/*! ./AddIngestionComponent */ "./app/components/Homepage/Operations/AddIngestionComponent.tsx"));
const AddIndexingComponent_1 = __importDefault(__webpack_require__(/*! ./AddIndexingComponent */ "./app/components/Homepage/Operations/AddIndexingComponent.tsx"));
const AddPartionComponent_1 = __importDefault(__webpack_require__(/*! ./AddPartionComponent */ "./app/components/Homepage/Operations/AddPartionComponent.tsx"));
const AddStorageComponent_1 = __importDefault(__webpack_require__(/*! ./AddStorageComponent */ "./app/components/Homepage/Operations/AddStorageComponent.tsx"));
const AddQueryComponent_1 = __importDefault(__webpack_require__(/*! ./AddQueryComponent */ "./app/components/Homepage/Operations/AddQueryComponent.tsx"));
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const AddOfflineTenantComponent_1 = __importDefault(__webpack_require__(/*! ./AddOfflineTenantComponent */ "./app/components/Homepage/Operations/AddOfflineTenantComponent.tsx"));
const useStyles = core_1.makeStyles((theme) => core_1.createStyles({
    sqlDiv: {
        border: '1px #BDCCD9 solid',
        borderRadius: 4,
        marginBottom: '20px',
    },
    queryOutput: {
        '& .CodeMirror': { height: '532px !important' },
    },
}));
const defaultTableObj = {
    "tableName": "",
    "tableType": "",
    "tenants": {
        "broker": "DefaultTenant",
        "server": "DefaultTenant"
    },
    "segmentsConfig": {
        "schemaName": "",
        "timeColumnName": null,
        "replication": "1",
        "replicasPerPartition": "1",
        "retentionTimeUnit": null,
        "retentionTimeValue": null,
        "segmentPushType": "APPEND",
        "segmentPushFrequency": "HOURLY",
        "crypterClassName": null,
        "peerSegmentDownloadScheme": null
    },
    "tableIndexConfig": {
        "loadMode": "MMAP",
        "invertedIndexColumns": [],
        "createInvertedIndexDuringSegmentGeneration": false,
        "rangeIndexColumns": [],
        "sortedColumn": [],
        "bloomFilterColumns": [],
        "bloomFilterConfigs": null,
        "noDictionaryColumns": [],
        "onHeapDictionaryColumns": [],
        "varLengthDictionaryColumns": [],
        "enableDefaultStarTree": false,
        "starTreeIndexConfigs": null,
        "enableDynamicStarTreeCreation": false,
        "segmentPartitionConfig": null,
        "columnMinMaxValueGeneratorMode": null,
        "nullHandlingEnabled": false
    },
    "metadata": {},
    "ingestionConfig": {
        "filterConfig": null,
        "transformConfigs": null
    },
    "quota": {
        "storage": null,
        "maxQueriesPerSecond": null
    },
    "task": null,
    "routing": {
        "segmentPrunerTypes": null,
        "instanceSelectorType": null
    },
    "instanceAssignmentConfigMap": null,
    "query": {
        "timeoutMs": null
    },
    "fieldConfigList": null,
    "upsertConfig": null,
    "tierConfigs": null
};
const defaultSchemaObj = {
    schemaName: '',
    dimensionFieldSpecs: [],
    metricFieldSpecs: [],
    dateTimeFieldSpecs: []
};
let timerId = null;
const tableNamekey = ["dimensionFieldSpecs", "metricFieldSpecs", "dateTimeFieldSpecs"];
function AddOfflineTableOp({ hideModal, fetchData, tableType }) {
    const classes = useStyles();
    const [tableObj, setTableObj] = react_1.useState(JSON.parse(JSON.stringify(defaultTableObj)));
    const [schemaObj, setSchemaObj] = react_1.useState(JSON.parse(JSON.stringify(defaultSchemaObj)));
    const [tableName, setTableName] = react_1.useState('');
    const [columnName, setColumnName] = react_1.useState([]);
    const { dispatch } = react_1.default.useContext(NotificationContext_1.NotificationContext);
    let isError = false;
    react_1.useEffect(() => {
        if (tableName !== tableObj.tableName) {
            setTableName(tableObj.tableName);
            clearTimeout(timerId);
            timerId = setTimeout(() => {
                updateSchemaObj(tableObj.tableName);
            }, 1000);
        }
    }, [tableObj]);
    react_1.useEffect(() => {
        setTableObj(Object.assign(Object.assign({}, tableObj), { "tableType": tableType }));
    }, []);
    const updateSchemaObj = (tableName) => __awaiter(this, void 0, void 0, function* () {
        //table name is same as schema name
        const schemaObj = yield PinotMethodUtils_1.default.getSchemaData(tableName);
        if (schemaObj.error || typeof schemaObj === 'string') {
            dispatch({
                type: 'error',
                message: schemaObj.error || schemaObj,
                show: true
            });
            setSchemaObj(defaultSchemaObj);
        }
        else {
            setSchemaObj(Object.assign(Object.assign({}, defaultSchemaObj), schemaObj));
        }
    });
    const returnValue = (data, key) => {
        Object.keys(data).map((o) => __awaiter(this, void 0, void 0, function* () {
            if (!lodash_1.isEmpty(data[o]) && typeof data[o] === "object") {
                yield returnValue(data[o], key);
            }
            else if (!lodash_1.isEmpty(data[o]) && lodash_1.isArray(data[o])) {
                data[o].map((obj) => __awaiter(this, void 0, void 0, function* () {
                    yield returnValue(obj, key);
                }));
            }
            else {
                if (o === key && (data[key] === null || data[key] === "")) {
                    dispatch({
                        type: 'error',
                        message: `${key} cannot be empty`,
                        show: true
                    });
                    isError = true;
                }
            }
        }));
    };
    const checkFields = (tableObj, fields) => {
        fields.forEach((o) => __awaiter(this, void 0, void 0, function* () {
            if (tableObj[o.key] === undefined) {
                yield returnValue(tableObj, o.key);
            }
            else {
                if ((tableObj[o.key] === null || tableObj[o.key] === "")) {
                    dispatch({
                        type: 'error',
                        message: `${o.label} cannot be empty`,
                        show: true
                    });
                    isError = true;
                }
            }
        }));
    };
    const validateTableConfig = () => __awaiter(this, void 0, void 0, function* () {
        const fields = [{ key: "tableName", label: "Table Name" }];
        yield checkFields(tableObj, fields);
        if (isError) {
            isError = false;
            return false;
        }
        const validTable = yield PinotMethodUtils_1.default.validateTableAction(tableObj);
        if (validTable.error || typeof validTable === 'string') {
            dispatch({
                type: 'error',
                message: validTable.error || validTable,
                show: true
            });
            return false;
        }
        return true;
    });
    const handleSave = () => __awaiter(this, void 0, void 0, function* () {
        if (yield validateTableConfig()) {
            const tableCreationResp = yield PinotMethodUtils_1.default.saveTableAction(tableObj);
            dispatch({
                type: (tableCreationResp.error || typeof tableCreationResp === 'string') ? 'error' : 'success',
                message: tableCreationResp.error || tableCreationResp.status || tableCreationResp,
                show: true
            });
            tableCreationResp.status && fetchData();
            tableCreationResp.status && hideModal(null);
        }
    });
    react_1.useEffect(() => {
        let columnName = [];
        if (!lodash_1.isEmpty(schemaObj)) {
            tableNamekey.map((o) => {
                schemaObj[o] && schemaObj[o].map((obj) => {
                    columnName.push(obj.name);
                });
            });
        }
        setColumnName(columnName);
    }, [schemaObj]);
    return (react_1.default.createElement(CustomDialog_1.default, { open: true, handleClose: hideModal, handleSave: handleSave, title: `Add ${tableType} Table`, size: "xl", disableBackdropClick: true, disableEscapeKeyDown: true },
        react_1.default.createElement(core_1.DialogContent, null,
            react_1.default.createElement(core_1.Grid, { container: true, spacing: 2 },
                react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                    react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Add Table", showSearchBox: false },
                        react_1.default.createElement(AddTableComponent_1.default, { tableObj: tableObj, setTableObj: setTableObj, dateTimeFieldSpecs: schemaObj.dateTimeFieldSpecs, disable: tableType !== "" }))),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                    react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Tenants", showSearchBox: false },
                        react_1.default.createElement(AddOfflineTenantComponent_1.default, { tableObj: Object.assign({}, tableObj), setTableObj: setTableObj }))),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                    react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Ingestion", showSearchBox: false },
                        react_1.default.createElement(AddIngestionComponent_1.default, { tableObj: Object.assign({}, tableObj), setTableObj: setTableObj, columnName: columnName }))),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                    react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Indexing & encoding", tooltipContent: react_1.default.createElement("a", { className: "tooltip-link", target: "_blank", href: "https://docs.pinot.apache.org/basics/indexing" }, "Click here for more details"), showSearchBox: false },
                        react_1.default.createElement(AddIndexingComponent_1.default, { tableObj: tableObj, setTableObj: setTableObj, columnName: columnName }))),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                    react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Partitioning & Routing", showSearchBox: false },
                        react_1.default.createElement(AddPartionComponent_1.default, { tableObj: tableObj, setTableObj: setTableObj, columnName: columnName }))),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                    react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Storage & Data retention", showSearchBox: false },
                        react_1.default.createElement(AddStorageComponent_1.default, { tableObj: tableObj, setTableObj: setTableObj }))),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                    react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Query", showSearchBox: false },
                        react_1.default.createElement(AddQueryComponent_1.default, { tableObj: tableObj, setTableObj: setTableObj }))),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 6 },
                    react_1.default.createElement("div", { className: classes.sqlDiv },
                        react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Table Config", showSearchBox: false },
                            react_1.default.createElement(CustomCodemirror_1.default, { customClass: classes.queryOutput, data: tableObj, isEditable: true, returnCodemirrorValue: (newValue) => {
                                    try {
                                        const jsonObj = JSON.parse(newValue);
                                        if (jsonObj) {
                                            jsonObj.segmentsConfig.replicasPerPartition = jsonObj.segmentsConfig.replication;
                                            setTableObj(jsonObj);
                                        }
                                    }
                                    catch (e) { }
                                } })))),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 6 },
                    react_1.default.createElement("div", { className: classes.sqlDiv },
                        react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Schema Config (Read only)", showSearchBox: false },
                            react_1.default.createElement(CustomCodemirror_1.default, { customClass: classes.queryOutput, data: schemaObj, isEditable: false }))))))));
}
exports.default = AddOfflineTableOp;


/***/ }),

/***/ "./app/components/Homepage/Operations/AddOfflineTenantComponent.tsx":
/*!**************************************************************************!*\
  !*** ./app/components/Homepage/Operations/AddOfflineTenantComponent.tsx ***!
  \**************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const lab_1 = __webpack_require__(/*! @material-ui/lab */ "./node_modules/@material-ui/lab/esm/index.js");
const useStyles = core_1.makeStyles((theme) => core_1.createStyles({
    formControl: {
        margin: theme.spacing(1),
        minWidth: 120,
    },
    selectFormControl: {
        margin: theme.spacing(1),
        width: 305
    },
    autoCompleteControl: {
        '& .MuiFormControl-marginNormal': {
            marginTop: 0
        }
    },
    redColor: {
        color: theme.palette.error.main
    }
}));
function AddOfflineTenantComponent({ tableObj, setTableObj }) {
    const classes = useStyles();
    const [tableDataObj, setTableDataObj] = react_1.useState(tableObj);
    const [tenantServer, setTenantServer] = react_1.useState('');
    const [tenantBroker, setTenantBroker] = react_1.useState('');
    const [serverOptions, setServerOptions] = react_1.useState([]);
    const [brokerOptions, setBrokerOptions] = react_1.useState([]);
    const [showRealtimeCompleted, setShowRealtimeCompleted] = react_1.useState(0);
    const changeHandler = (fieldName, value) => {
        let newTableObj = Object.assign({}, tableDataObj);
        switch (fieldName) {
            case 'broker':
                setTenantBroker(value);
                newTableObj.tenants.broker = value;
                break;
            case 'server':
                setTenantServer(value);
                newTableObj.tenants.server = value;
                break;
            case 'tagOverrideConfig':
                setShowRealtimeCompleted(value);
                if (value) {
                    newTableObj.tenants.tagOverrideConfig = {};
                    newTableObj.tenants.tagOverrideConfig.realtimeCompleted = `${tenantServer}_OFFLINE`;
                }
                else {
                    delete newTableObj.tenants.tagOverrideConfig;
                }
                break;
            case 'showRealtimeCompleted':
                newTableObj.tenants.tagOverrideConfig.realtimeCompleted = value;
                break;
        }
        setTableDataObj(newTableObj);
        setTableObj(newTableObj);
    };
    react_1.useEffect(() => {
        if (!(tableDataObj.tenants.tagOverrideConfig && tableDataObj.tenants.tagOverrideConfig.realtimeCompleted)) {
            setShowRealtimeCompleted(0);
        }
        setTableDataObj(tableObj);
    }, [tableObj]);
    react_1.useEffect(() => {
        let serverOptions = [], brokerOptions = [];
        setServerOptions(serverOptions);
        setBrokerOptions(brokerOptions);
        setTenantServer(tableDataObj.tenants.server);
        setTenantBroker(tableDataObj.tenants.broker);
    }, []);
    const requiredAstrix = react_1.default.createElement("span", { className: classes.redColor }, "*");
    return (react_1.default.createElement(core_1.Grid, { container: true, spacing: 2 },
        react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
            react_1.default.createElement(core_1.FormControl, { className: classes.selectFormControl },
                react_1.default.createElement(lab_1.Autocomplete, { key: 'server', className: classes.autoCompleteControl, value: tenantServer, options: serverOptions, onChange: (e, value) => changeHandler('server', value ? value : ''), disableClearable: true, autoHighlight: true, renderInput: (params) => (react_1.default.createElement(core_1.TextField, Object.assign({}, params, { label: react_1.default.createElement(react_1.default.Fragment, null, "Server Tenant"), margin: "normal" }))) })),
            react_1.default.createElement(core_1.FormControl, { className: classes.selectFormControl },
                react_1.default.createElement(lab_1.Autocomplete, { key: 'broker', className: classes.autoCompleteControl, value: tenantBroker, options: brokerOptions, onChange: (e, value) => changeHandler('broker', value ? value : ''), disableClearable: true, autoHighlight: true, renderInput: (params) => (react_1.default.createElement(core_1.TextField, Object.assign({}, params, { label: react_1.default.createElement(react_1.default.Fragment, null, "Broker Tenant"), margin: "normal" }))) })))));
}
exports.default = AddOfflineTenantComponent;


/***/ }),

/***/ "./app/components/Homepage/Operations/AddPartionComponent.tsx":
/*!********************************************************************!*\
  !*** ./app/components/Homepage/Operations/AddPartionComponent.tsx ***!
  \********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const useStyles = core_1.makeStyles((theme) => core_1.createStyles({
    formControl: {
        margin: theme.spacing(1),
        minWidth: 120,
        width: 320
    },
    selectFormControl: {
        margin: theme.spacing(1),
        width: 320
    },
    redColor: {
        color: theme.palette.error.main
    }
}));
function AddPartionComponent({ tableObj, setTableObj, columnName }) {
    const classes = useStyles();
    const [tableDataObj, setTableDataObj] = react_1.useState(tableObj);
    const [showPartition, setShowPartition] = react_1.useState(0);
    const [showReplica, setShowReplica] = react_1.useState(0);
    const ITEM_HEIGHT = 48;
    const ITEM_PADDING_TOP = 8;
    const MenuProps = {
        PaperProps: {
            style: {
                maxHeight: ITEM_HEIGHT * 4.5 + ITEM_PADDING_TOP,
                width: 250,
            },
        },
    };
    const [columnNameTemp, setColumnNameTemp] = react_1.useState("");
    const changeHandler = (fieldName, value) => {
        let newTableObj = Object.assign({}, tableDataObj);
        switch (fieldName) {
            case 'segmentPrunerTypes':
                // newTableObj[fieldName] = value;
                setShowPartition(value);
                if (value) {
                    newTableObj.routing.segmentPrunerTypes = ["partition"];
                    newTableObj.tableIndexConfig.segmentPartitionConfig = {
                        columnPartitionMap: {
                            "": {
                                functionName: "Murmur"
                            }
                        }
                    };
                }
                else {
                    newTableObj.tableIndexConfig.segmentPartitionConfig = null;
                }
                break;
            case 'functionName':
                newTableObj.tableIndexConfig.segmentPartitionConfig.columnPartitionMap[columnNameTemp].functionName = value;
                break;
            case 'numPartitions':
                newTableObj.tableIndexConfig.segmentPartitionConfig.columnPartitionMap[columnNameTemp].numPartitions = value;
                break;
            case 'instanceSelectorType':
                if (value) {
                    newTableObj.routing.instanceSelectorType = "replicaGroup";
                }
                else {
                    delete newTableObj.routing.instanceSelectorType;
                }
                setShowReplica(value);
                break;
            case 'numReplicaGroups':
                if (!(newTableObj.instanceAssignmentConfigMap && newTableObj.instanceAssignmentConfigMap["OFFLINE"])) {
                    newTableObj.instanceAssignmentConfigMap = {
                        ["OFFLINE"]: {
                            tagPoolConfig: {
                                tag: "DefaultTenant_OFFLINE"
                            },
                            replicaGroupPartitionConfig: {
                                replicaGroupBased: true,
                                numReplicaGroups: null,
                                numInstancesPerReplicaGroup: null
                            }
                        }
                    };
                }
                newTableObj.instanceAssignmentConfigMap["OFFLINE"].replicaGroupPartitionConfig.numReplicaGroups = value;
                break;
            case 'numInstancesPerReplicaGroup':
                if (!(newTableObj.instanceAssignmentConfigMap && newTableObj.instanceAssignmentConfigMap["OFFLINE"])) {
                    newTableObj.instanceAssignmentConfigMap = {
                        ["OFFLINE"]: {
                            tagPoolConfig: {
                                tag: "DefaultTenant_OFFLINE"
                            },
                            replicaGroupPartitionConfig: {
                                replicaGroupBased: true,
                                numReplicaGroups: null,
                                numInstancesPerReplicaGroup: null
                            }
                        }
                    };
                }
                newTableObj.instanceAssignmentConfigMap["OFFLINE"].replicaGroupPartitionConfig.numInstancesPerReplicaGroup = value;
                break;
            case 'columnName':
                newTableObj.tableIndexConfig.segmentPartitionConfig.columnPartitionMap[value] = newTableObj.tableIndexConfig.segmentPartitionConfig.columnPartitionMap[columnNameTemp];
                delete newTableObj.tableIndexConfig.segmentPartitionConfig.columnPartitionMap[columnNameTemp];
                setColumnNameTemp(value);
                break;
        }
        ;
        setTableDataObj(newTableObj);
        setTableObj(newTableObj);
    };
    react_1.useEffect(() => {
        setTableDataObj(tableObj);
    }, [tableObj]);
    const requiredAstrix = react_1.default.createElement("span", { className: classes.redColor }, "*");
    return (react_1.default.createElement(core_1.Grid, { container: true, spacing: 2 },
        react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
            react_1.default.createElement(core_1.Tooltip, { interactive: true, title: (react_1.default.createElement(react_1.default.Fragment, null,
                    "Data has to be pre-partitioned using the same logic, when creating segments.",
                    react_1.default.createElement("a", { href: "https://docs.pinot.apache.org/operators/operating-pinot/tuning/routing#partitioning", target: "_blank", className: "tooltip-link" }, "(Click here for more details)"))), arrow: true, placement: "top-start", disableHoverListener: tableDataObj.tableType === "REALTIME" },
                react_1.default.createElement(core_1.FormControl, { className: classes.selectFormControl },
                    react_1.default.createElement(core_1.InputLabel, { htmlFor: "segmentPrunerTypes" }, "Enable partitioning"),
                    react_1.default.createElement(core_1.Select, { labelId: "segmentPrunerTypes", id: "segmentPrunerTypes", value: showPartition, onChange: (e) => changeHandler('segmentPrunerTypes', e.target.value) },
                        react_1.default.createElement(core_1.MenuItem, { value: 1 }, "True"),
                        react_1.default.createElement(core_1.MenuItem, { value: 0 }, "False")))),
            showPartition ?
                react_1.default.createElement(core_1.FormControl, { className: classes.selectFormControl },
                    react_1.default.createElement(core_1.InputLabel, { htmlFor: "columnName" },
                        "Column Name ",
                        requiredAstrix),
                    react_1.default.createElement(core_1.Select, { labelId: "columnName", id: "columnName", key: "columnName", value: columnNameTemp, onChange: (e) => changeHandler('columnName', e.target.value) }, columnName.map((val) => {
                        return react_1.default.createElement(core_1.MenuItem, { value: val }, val);
                    }))) : null,
            showPartition ?
                react_1.default.createElement(core_1.FormControl, { className: classes.selectFormControl },
                    react_1.default.createElement(core_1.InputLabel, { htmlFor: "functionName" },
                        "Function Name ",
                        requiredAstrix),
                    react_1.default.createElement(core_1.Select, { labelId: "functionNamePartition", id: "functionNamePartition", key: "functionName", value: tableDataObj.tableIndexConfig.segmentPartitionConfig.columnPartitionMap[columnNameTemp].functionName, onChange: (e) => changeHandler('functionName', e.target.value) },
                        react_1.default.createElement(core_1.MenuItem, { value: "Modulo" }, "Modulo"),
                        react_1.default.createElement(core_1.MenuItem, { value: "Murmur" }, "Murmur"),
                        react_1.default.createElement(core_1.MenuItem, { value: "ByteArray" }, "ByteArray"),
                        react_1.default.createElement(core_1.MenuItem, { value: "HashCode" }, "HashCode"))) : null,
            showPartition ?
                react_1.default.createElement(core_1.FormControl, { className: classes.formControl },
                    react_1.default.createElement(core_1.InputLabel, { htmlFor: "numPartitions" },
                        "Number of partitions\u200B ",
                        requiredAstrix),
                    react_1.default.createElement(core_1.Input, { id: "numPartitions", value: tableDataObj.tableIndexConfig.segmentPartitionConfig.columnPartitionMap[columnNameTemp].numPartitions, onChange: (e) => changeHandler('numPartitions', e.target.value), type: "number" })) : null),
        react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
            react_1.default.createElement(core_1.Tooltip, { title: (react_1.default.createElement(react_1.default.Fragment, null,
                    "Creates sets of servers that contain a complete set of segments.",
                    react_1.default.createElement("a", { href: "https://docs.pinot.apache.org/operators/operating-pinot/tuning/routing#replica-group-segment-assignment-and-query-routing", target: "_blank", className: "tooltip-link" }, "(Click here for more details)"))), arrow: true, placement: "top-start", interactive: true, disableHoverListener: tableDataObj.tableType === "REALTIME" },
                react_1.default.createElement(core_1.FormControl, { className: classes.selectFormControl },
                    react_1.default.createElement(core_1.InputLabel, { htmlFor: "instanceSelectorType" }, "Enable replica groups"),
                    react_1.default.createElement(core_1.Select, { labelId: "instanceSelectorType", id: "instanceSelectorType", value: showReplica, onChange: (e) => changeHandler('instanceSelectorType', e.target.value) },
                        react_1.default.createElement(core_1.MenuItem, { value: 1 }, "True"),
                        react_1.default.createElement(core_1.MenuItem, { value: 0 }, "False")))),
            tableDataObj.routing.instanceSelectorType ?
                react_1.default.createElement(core_1.FormControl, { className: classes.formControl },
                    react_1.default.createElement(core_1.InputLabel, { htmlFor: "numReplicaGroups" },
                        "Number of replica groups ",
                        requiredAstrix),
                    react_1.default.createElement(core_1.Input, { id: "numReplicaGroups", value: tableDataObj.instanceAssignmentConfigMap ? Number(tableDataObj.instanceAssignmentConfigMap["OFFLINE"].replicaGroupPartitionConfig.numReplicaGroups) : null, onChange: (e) => changeHandler('numReplicaGroups', e.target.value), type: "number" }))
                : null,
            tableDataObj.routing.instanceSelectorType ?
                react_1.default.createElement(core_1.FormControl, { className: classes.formControl },
                    react_1.default.createElement(core_1.InputLabel, { htmlFor: "numInstancesPerReplicaGroup" },
                        "Number of instances per replica group\u200B ",
                        requiredAstrix),
                    react_1.default.createElement(core_1.Input, { id: "numInstancesPerReplicaGroup", value: tableDataObj.instanceAssignmentConfigMap ? Number(tableDataObj.instanceAssignmentConfigMap["OFFLINE"].replicaGroupPartitionConfig.numInstancesPerReplicaGroup) : null, onChange: (e) => changeHandler('numInstancesPerReplicaGroup', e.target.value), type: "number" }))
                : null)));
}
exports.default = AddPartionComponent;


/***/ }),

/***/ "./app/components/Homepage/Operations/AddQueryComponent.tsx":
/*!******************************************************************!*\
  !*** ./app/components/Homepage/Operations/AddQueryComponent.tsx ***!
  \******************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const useStyles = core_1.makeStyles((theme) => core_1.createStyles({
    formControl: {
        margin: theme.spacing(1),
        minWidth: 120,
    }
}));
function AddQueryComponent({ tableObj, setTableObj }) {
    const classes = useStyles();
    const [tableDataObj, setTableDataObj] = react_1.useState(tableObj);
    const changeHandler = (fieldName, value) => {
        let newTableObj = Object.assign({}, tableDataObj);
        switch (fieldName) {
            case 'timeoutMs':
                newTableObj.query[fieldName] = value;
                break;
            case 'maxQueriesPerSecond':
                newTableObj.quota[fieldName] = value;
                break;
        }
        setTableDataObj(newTableObj);
        setTableObj(newTableObj);
    };
    react_1.useEffect(() => {
        setTableDataObj(tableObj);
    }, [tableObj]);
    return (react_1.default.createElement(core_1.Grid, { container: true, spacing: 2 },
        react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
            react_1.default.createElement(core_1.FormControl, { className: classes.formControl },
                react_1.default.createElement(core_1.InputLabel, { htmlFor: "timeoutMs" }, "Query Timeout Ms"),
                react_1.default.createElement(core_1.Input, { id: "timeoutMs", key: "timeoutMs", value: tableDataObj.query.timeoutMs || "", onChange: (e) => changeHandler('timeoutMs', e.target.value), type: "number" })),
            react_1.default.createElement(core_1.Tooltip, { title: "Queries exceeding this QPS will be rejected.", arrow: true, placement: "top-start" },
                react_1.default.createElement(core_1.FormControl, { className: classes.formControl },
                    react_1.default.createElement(core_1.InputLabel, { htmlFor: "maxQueriesPerSecond" }, "Queries Per Second"),
                    react_1.default.createElement(core_1.Input, { id: "maxQueriesPerSecond", key: "maxQueriesPerSecond", value: tableDataObj.quota.maxQueriesPerSecond || "", onChange: (e) => changeHandler('maxQueriesPerSecond', e.target.value), type: "number" }))))));
}
exports.default = AddQueryComponent;


/***/ }),

/***/ "./app/components/Homepage/Operations/AddRealTimeIngestionComponent.tsx":
/*!******************************************************************************!*\
  !*** ./app/components/Homepage/Operations/AddRealTimeIngestionComponent.tsx ***!
  \******************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const AddDeleteComponent_1 = __importDefault(__webpack_require__(/*! ./AddDeleteComponent */ "./app/components/Homepage/Operations/AddDeleteComponent.tsx"));
const MultipleSelectComponent_1 = __importDefault(__webpack_require__(/*! ./MultipleSelectComponent */ "./app/components/Homepage/Operations/MultipleSelectComponent.tsx"));
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const useStyles = core_1.makeStyles((theme) => core_1.createStyles({
    formControl: {
        margin: theme.spacing(1),
        minWidth: 120,
    },
    selectFormControl: {
        margin: theme.spacing(1),
        width: 220
    },
}));
function AddRealTimeIngestionComponent({ tableObj, setTableObj, columnName }) {
    const classes = useStyles();
    const [newSize, setNewSize] = react_1.useState([0, 1]);
    const [tableDataObj, setTableDataObj] = react_1.useState(tableObj);
    const changeHandler = (fieldName, value) => {
        let newTableObj = Object.assign({}, tableDataObj);
        switch (fieldName) {
            case 'filterConfig':
                newTableObj.ingestionConfig.filterConfig[fieldName] = value;
                break;
            case 'segmentPushFrequency':
                newTableObj.segmentsConfig[fieldName] = value;
                break;
            case 'segmentPushType':
                newTableObj.segmentsConfig[fieldName] = value;
                break;
            case 'streamConfigs':
                newTableObj.tableIndexConfig.streamConfigs = Object.assign({}, value);
                break;
            case 'filterFunction':
                if (!newTableObj.ingestionConfig.filterConfig) {
                    newTableObj.ingestionConfig.filterConfig = {};
                }
                newTableObj.ingestionConfig.filterConfig.filterFunction = value;
                break;
            case 'transformConfigs':
                tableDataObj.ingestionConfig.transformConfigs = value;
        }
        ;
        setTableDataObj(newTableObj);
        setTableObj(newTableObj);
    };
    react_1.useEffect(() => {
        let newTableObj = Object.assign({}, tableObj);
        if (newTableObj.tableType === "REALTIME" && !newTableObj.tableIndexConfig.streamConfigs && lodash_1.isEmpty(newTableObj.tableIndexConfig.streamConfigs)) {
            newTableObj.tableIndexConfig.streamConfigs =
                {
                    "streamType": "kafka",
                    "stream.kafka.topic.name": "",
                    "stream.kafka.broker.list": "",
                    "stream.kafka.consumer.type": "lowlevel",
                    "stream.kafka.consumer.prop.auto.offset.reset": "smallest",
                    "stream.kafka.consumer.factory.class.name": "org.apache.pinot.plugin.stream.kafka20.KafkaConsumerFactory",
                    "stream.kafka.decoder.class.name": "org.apache.pinot.plugin.stream.kafka.KafkaJSONMessageDecoder",
                    "realtime.segment.flush.threshold.rows": "0",
                    "realtime.segment.flush.threshold.time": "24h",
                    "realtime.segment.flush.threshold.segment.size": "100M"
                };
            setTableObj(newTableObj);
        }
        else if (newTableObj.tableType !== "REALTIME" && newTableObj.tableIndexConfig.streamConfigs) {
            newTableObj.tableIndexConfig.streamConfigs = null;
            setTableObj(newTableObj);
        }
        setTableDataObj(newTableObj);
    }, [tableObj]);
    react_1.useEffect(() => {
        setNewSize(newSize);
    }, [newSize]);
    return (react_1.default.createElement(core_1.Grid, { container: true, spacing: 2 },
        react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
            tableDataObj.tableType === "OFFLINE" ?
                react_1.default.createElement(core_1.FormControl, { className: classes.selectFormControl },
                    react_1.default.createElement(core_1.InputLabel, { htmlFor: "segmentPushFrequency" }, "Offline push frequency"),
                    react_1.default.createElement(core_1.Select, { labelId: "segmentPushFrequency", id: "segmentPushFrequency", value: tableDataObj.segmentsConfig.segmentPushFrequency !== "" ? tableDataObj.segmentsConfig.segmentPushFrequency : "", onChange: (e) => changeHandler('segmentPushFrequency', e.target.value) },
                        react_1.default.createElement(core_1.MenuItem, { value: "HOURLY" }, "HOURLY"),
                        react_1.default.createElement(core_1.MenuItem, { value: "DAILY" }, "DAILY"))) : null,
            tableDataObj.tableType === "OFFLINE" ?
                react_1.default.createElement(core_1.FormControl, { className: classes.selectFormControl },
                    react_1.default.createElement(core_1.InputLabel, { htmlFor: "segmentPushType" }, "Offline push type"),
                    react_1.default.createElement(core_1.Select, { labelId: "segmentPushType", id: "segmentPushType", value: tableDataObj.segmentsConfig.segmentPushType !== "" ? tableDataObj.segmentsConfig.segmentPushType : "", onChange: (e) => changeHandler('segmentPushType', e.target.value) },
                        react_1.default.createElement(core_1.MenuItem, { value: "APPEND" }, "APPEND"),
                        react_1.default.createElement(core_1.MenuItem, { value: "REFRESH" }, "REFRESH"))) : null,
            react_1.default.createElement(core_1.Tooltip, { interactive: true, title: (react_1.default.createElement(react_1.default.Fragment, null,
                    "Filter out rows which match condition.",
                    react_1.default.createElement("a", { target: "_blank", href: "https://docs.pinot.apache.org/developers/advanced/ingestion-level-transformations#filtering", className: "tooltip-link" }, "(Click here for more details)"))), arrow: true, placement: "top-start" },
                react_1.default.createElement(core_1.FormControl, { className: classes.formControl },
                    react_1.default.createElement(core_1.InputLabel, { htmlFor: "filterFunction" }, "Filter function"),
                    react_1.default.createElement(core_1.Input, { id: "filterFunction", value: tableObj.ingestionConfig.filterConfig && tableObj.ingestionConfig.filterConfig.filterFunction || "", onChange: (e) => changeHandler('filterFunction', e.target.value) }))),
            react_1.default.createElement(core_1.Tooltip, { interactive: true, title: (react_1.default.createElement(react_1.default.Fragment, null,
                    "Transform the data values using Groovy or other inbuilt functions.",
                    react_1.default.createElement("a", { target: "_blank", href: "https://docs.pinot.apache.org/developers/advanced/ingestion-level-transformations#column-transformation", className: "tooltip-link" }, "(Click here for more details)"))), arrow: true, placement: "top-start" },
                react_1.default.createElement(MultipleSelectComponent_1.default, { key: "transformConfigs", streamConfigsObj: tableDataObj.ingestionConfig.transformConfigs || [], changeHandler: changeHandler, columnName: columnName })),
            tableDataObj.tableIndexConfig.streamConfigs ?
                react_1.default.createElement(AddDeleteComponent_1.default, { key: "streamConfigs", streamConfigsObj: Object.assign({}, tableDataObj.tableIndexConfig.streamConfigs), changeHandler: changeHandler })
                : null)));
}
exports.default = AddRealTimeIngestionComponent;


/***/ }),

/***/ "./app/components/Homepage/Operations/AddRealTimePartionComponent.tsx":
/*!****************************************************************************!*\
  !*** ./app/components/Homepage/Operations/AddRealTimePartionComponent.tsx ***!
  \****************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const useStyles = core_1.makeStyles((theme) => core_1.createStyles({
    formControl: {
        margin: theme.spacing(1),
        minWidth: 120,
        width: 300
    },
    selectFormControl: {
        margin: theme.spacing(1),
        width: 300
    },
    redColor: {
        color: theme.palette.error.main
    }
}));
function AddRealTimePartionComponent({ tableObj, setTableObj, columnName }) {
    const classes = useStyles();
    const [tableDataObj, setTableDataObj] = react_1.useState(tableObj);
    const [showPartition, setShowPartition] = react_1.useState(0);
    const [showReplica, setShowReplica] = react_1.useState(0);
    const ITEM_HEIGHT = 48;
    const ITEM_PADDING_TOP = 8;
    const MenuProps = {
        PaperProps: {
            style: {
                maxHeight: ITEM_HEIGHT * 4.5 + ITEM_PADDING_TOP,
                width: 250,
            },
        },
    };
    const [columnNameTemp, setColumnNameTemp] = react_1.useState("");
    const changeHandler = (fieldName, value) => {
        let newTableObj = Object.assign({}, tableDataObj);
        switch (fieldName) {
            case 'segmentPrunerTypes':
                // newTableObj[fieldName] = value;
                setShowPartition(value);
                if (value) {
                    newTableObj.routing.segmentPrunerTypes = ["partition"];
                    newTableObj.tableIndexConfig.segmentPartitionConfig = {
                        columnPartitionMap: {
                            "": {
                                functionName: "Murmur"
                            }
                        }
                    };
                }
                else {
                    newTableObj.tableIndexConfig.segmentPartitionConfig = null;
                }
                break;
            case 'functionName':
                newTableObj.tableIndexConfig.segmentPartitionConfig.columnPartitionMap[columnNameTemp].functionName = value;
                break;
            case 'numPartitions':
                newTableObj.tableIndexConfig.segmentPartitionConfig.columnPartitionMap[columnNameTemp].numPartitions = value;
                break;
            case 'instanceSelectorType':
                if (value) {
                    newTableObj.routing.instanceSelectorType = "replicaGroup";
                }
                else {
                    delete newTableObj.routing.instanceSelectorType;
                }
                setShowReplica(value);
                break;
            case 'numReplicaGroups':
                if (!(newTableObj.instanceAssignmentConfigMap && newTableObj.instanceAssignmentConfigMap["OFFLINE"])) {
                    newTableObj.instanceAssignmentConfigMap = {
                        ["OFFLINE"]: {
                            tagPoolConfig: {
                                tag: "DefaultTenant_OFFLINE"
                            },
                            replicaGroupPartitionConfig: {
                                replicaGroupBased: true,
                                numReplicaGroups: null,
                                numInstancesPerReplicaGroup: null
                            }
                        }
                    };
                }
                newTableObj.instanceAssignmentConfigMap["OFFLINE"].replicaGroupPartitionConfig.numReplicaGroups = value;
                break;
            case 'numInstancesPerReplicaGroup':
                if (!(newTableObj.instanceAssignmentConfigMap && newTableObj.instanceAssignmentConfigMap["OFFLINE"])) {
                    newTableObj.instanceAssignmentConfigMap = {
                        ["OFFLINE"]: {
                            tagPoolConfig: {
                                tag: "DefaultTenant_OFFLINE"
                            },
                            replicaGroupPartitionConfig: {
                                replicaGroupBased: true,
                                numReplicaGroups: null,
                                numInstancesPerReplicaGroup: null
                            }
                        }
                    };
                }
                newTableObj.instanceAssignmentConfigMap["OFFLINE"].replicaGroupPartitionConfig.numInstancesPerReplicaGroup = value;
                break;
            case 'columnName':
                newTableObj.tableIndexConfig.segmentPartitionConfig.columnPartitionMap[value] = newTableObj.tableIndexConfig.segmentPartitionConfig.columnPartitionMap[columnNameTemp];
                delete newTableObj.tableIndexConfig.segmentPartitionConfig.columnPartitionMap[columnNameTemp];
                setColumnNameTemp(value);
                break;
        }
        ;
        setTableDataObj(newTableObj);
        setTableObj(newTableObj);
    };
    react_1.useEffect(() => {
        setTableDataObj(tableObj);
    }, [tableObj]);
    const requiredAstrix = react_1.default.createElement("span", { className: classes.redColor }, "*");
    return (react_1.default.createElement(core_1.Grid, { container: true, spacing: 2 },
        react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
            react_1.default.createElement(core_1.Tooltip, { interactive: true, title: "The partitioning logic in the stream should match the partitioning config in Pinot.", arrow: true, placement: "top-start" },
                react_1.default.createElement(core_1.FormControl, { className: classes.selectFormControl },
                    react_1.default.createElement(core_1.InputLabel, { htmlFor: "segmentPrunerTypes" }, "Enable partitioning"),
                    react_1.default.createElement(core_1.Select, { labelId: "segmentPrunerTypes", id: "segmentPrunerTypes", value: showPartition, onChange: (e) => changeHandler('segmentPrunerTypes', e.target.value) },
                        react_1.default.createElement(core_1.MenuItem, { value: 1 }, "True"),
                        react_1.default.createElement(core_1.MenuItem, { value: 0 }, "False")))),
            showPartition ?
                react_1.default.createElement(core_1.FormControl, { className: classes.selectFormControl },
                    react_1.default.createElement(core_1.InputLabel, { htmlFor: "columnName" },
                        "Column Name ",
                        requiredAstrix),
                    react_1.default.createElement(core_1.Select, { labelId: "columnName", id: "columnName", key: "columnName", value: columnNameTemp, onChange: (e) => changeHandler('columnName', e.target.value) }, columnName.map((val) => {
                        return react_1.default.createElement(core_1.MenuItem, { value: val }, val);
                    }))) : null,
            showPartition ?
                react_1.default.createElement(core_1.FormControl, { className: classes.selectFormControl },
                    react_1.default.createElement(core_1.InputLabel, { htmlFor: "functionName" },
                        "Function Name ",
                        requiredAstrix),
                    react_1.default.createElement(core_1.Select, { labelId: "functionNamePartition", id: "functionNamePartition", key: "functionName", value: tableDataObj.tableIndexConfig.segmentPartitionConfig.columnPartitionMap[columnNameTemp].functionName, onChange: (e) => changeHandler('functionName', e.target.value) },
                        react_1.default.createElement(core_1.MenuItem, { value: "Modulo" }, "Modulo"),
                        react_1.default.createElement(core_1.MenuItem, { value: "Murmur" }, "Murmur"),
                        react_1.default.createElement(core_1.MenuItem, { value: "ByteArray" }, "ByteArray"),
                        react_1.default.createElement(core_1.MenuItem, { value: "HashCode" }, "HashCode"))) : null,
            showPartition ?
                react_1.default.createElement(core_1.FormControl, { className: classes.formControl },
                    react_1.default.createElement(core_1.InputLabel, { htmlFor: "numPartitions" },
                        "Number of partitions\u200B ",
                        requiredAstrix),
                    react_1.default.createElement(core_1.Input, { id: "numPartitions", value: tableDataObj.tableIndexConfig.segmentPartitionConfig.columnPartitionMap[columnNameTemp].numPartitions, onChange: (e) => changeHandler('numPartitions', e.target.value), type: "number" })) : null),
        react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
            react_1.default.createElement(core_1.Tooltip, { interactive: true, title: (react_1.default.createElement(react_1.default.Fragment, null,
                    "Number of servers should be a multiple of number of replicas.",
                    react_1.default.createElement("a", { target: "_blank", href: "https://docs.pinot.apache.org/basics/getting-started/frequent-questions/operations-faq#docs-internal-guid-3eddb872-7fff-0e2a-b4e3-b1b43454add3", className: "tooltip-link" }, "(Click here for more details)"))), arrow: true, placement: "top-start" },
                react_1.default.createElement(core_1.FormControl, { className: classes.selectFormControl },
                    react_1.default.createElement(core_1.InputLabel, { htmlFor: "instanceSelectorType" }, "Enable replica groups"),
                    react_1.default.createElement(core_1.Select, { labelId: "instanceSelectorType", id: "instanceSelectorType", value: showReplica, onChange: (e) => changeHandler('instanceSelectorType', e.target.value) },
                        react_1.default.createElement(core_1.MenuItem, { value: 1 }, "True"),
                        react_1.default.createElement(core_1.MenuItem, { value: 0 }, "False")))))));
}
exports.default = AddRealTimePartionComponent;


/***/ }),

/***/ "./app/components/Homepage/Operations/AddRealtimeTableOp.tsx":
/*!*******************************************************************!*\
  !*** ./app/components/Homepage/Operations/AddRealtimeTableOp.tsx ***!
  \*******************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const CustomDialog_1 = __importDefault(__webpack_require__(/*! ../../CustomDialog */ "./app/components/CustomDialog.tsx"));
const SimpleAccordion_1 = __importDefault(__webpack_require__(/*! ../../SimpleAccordion */ "./app/components/SimpleAccordion.tsx"));
const AddTableComponent_1 = __importDefault(__webpack_require__(/*! ./AddTableComponent */ "./app/components/Homepage/Operations/AddTableComponent.tsx"));
const CustomCodemirror_1 = __importDefault(__webpack_require__(/*! ../../CustomCodemirror */ "./app/components/CustomCodemirror.tsx"));
const PinotMethodUtils_1 = __importDefault(__webpack_require__(/*! ../../../utils/PinotMethodUtils */ "./app/utils/PinotMethodUtils.ts"));
const NotificationContext_1 = __webpack_require__(/*! ../../Notification/NotificationContext */ "./app/components/Notification/NotificationContext.tsx");
const AddTenantComponent_1 = __importDefault(__webpack_require__(/*! ./AddTenantComponent */ "./app/components/Homepage/Operations/AddTenantComponent.tsx"));
const AddIndexingComponent_1 = __importDefault(__webpack_require__(/*! ./AddIndexingComponent */ "./app/components/Homepage/Operations/AddIndexingComponent.tsx"));
const AddStorageComponent_1 = __importDefault(__webpack_require__(/*! ./AddStorageComponent */ "./app/components/Homepage/Operations/AddStorageComponent.tsx"));
const AddQueryComponent_1 = __importDefault(__webpack_require__(/*! ./AddQueryComponent */ "./app/components/Homepage/Operations/AddQueryComponent.tsx"));
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const AddRealTimeIngestionComponent_1 = __importDefault(__webpack_require__(/*! ./AddRealTimeIngestionComponent */ "./app/components/Homepage/Operations/AddRealTimeIngestionComponent.tsx"));
const AddRealTimePartionComponent_1 = __importDefault(__webpack_require__(/*! ./AddRealTimePartionComponent */ "./app/components/Homepage/Operations/AddRealTimePartionComponent.tsx"));
const useStyles = core_1.makeStyles((theme) => core_1.createStyles({
    sqlDiv: {
        border: '1px #BDCCD9 solid',
        borderRadius: 4,
        marginBottom: '20px',
    },
    queryOutput: {
        '& .CodeMirror': { height: '532px !important' },
    },
}));
const defaultTableObj = {
    "tableName": "",
    "tableType": "",
    "tenants": {
        "broker": "DefaultTenant",
        "server": "DefaultTenant",
        "tagOverrideConfig": {}
    },
    "segmentsConfig": {
        "schemaName": "",
        "timeColumnName": null,
        "replication": "1",
        "replicasPerPartition": "1",
        "retentionTimeUnit": null,
        "retentionTimeValue": null,
        "completionConfig": null,
        "crypterClassName": null,
        "peerSegmentDownloadScheme": null
    },
    "tableIndexConfig": {
        "loadMode": "MMAP",
        "invertedIndexColumns": [],
        "createInvertedIndexDuringSegmentGeneration": false,
        "rangeIndexColumns": [],
        "sortedColumn": [],
        "bloomFilterColumns": [],
        "bloomFilterConfigs": null,
        "noDictionaryColumns": [],
        "onHeapDictionaryColumns": [],
        "varLengthDictionaryColumns": [],
        "enableDefaultStarTree": false,
        "starTreeIndexConfigs": null,
        "enableDynamicStarTreeCreation": false,
        "segmentPartitionConfig": null,
        "columnMinMaxValueGeneratorMode": null,
        "aggregateMetrics": false,
        "nullHandlingEnabled": false,
        "streamConfigs": {
            "streamType": "kafka",
            "stream.kafka.topic.name": "",
            "stream.kafka.broker.list": "",
            "stream.kafka.consumer.type": "lowlevel",
            "stream.kafka.consumer.prop.auto.offset.reset": "smallest",
            "stream.kafka.consumer.factory.class.name": "org.apache.pinot.plugin.stream.kafka20.KafkaConsumerFactory",
            "stream.kafka.decoder.class.name": "org.apache.pinot.plugin.stream.kafka.KafkaJSONMessageDecoder",
            "realtime.segment.flush.threshold.rows": "0",
            "realtime.segment.flush.threshold.time": "24h",
            "realtime.segment.flush.threshold.segment.size": "100M"
        }
    },
    "metadata": {},
    "ingestionConfig": {
        "filterConfig": null,
        "transformConfigs": null
    },
    "quota": {
        "storage": null,
        "maxQueriesPerSecond": null
    },
    "task": null,
    "routing": {
        "segmentPrunerTypes": null,
        "instanceSelectorType": null
    },
    "query": {
        "timeoutMs": null
    },
    "fieldConfigList": null,
    "upsertConfig": null,
    "tierConfigs": null
};
const defaultSchemaObj = {
    schemaName: '',
    dimensionFieldSpecs: [],
    metricFieldSpecs: [],
    dateTimeFieldSpecs: []
};
let timerId = null;
const tableNamekey = ["dimensionFieldSpecs", "metricFieldSpecs", "dateTimeFieldSpecs"];
function AddRealtimeTableOp({ hideModal, fetchData, tableType }) {
    const classes = useStyles();
    const [tableObj, setTableObj] = react_1.useState(JSON.parse(JSON.stringify(defaultTableObj)));
    const [schemaObj, setSchemaObj] = react_1.useState(JSON.parse(JSON.stringify(defaultSchemaObj)));
    const [tableName, setTableName] = react_1.useState('');
    const [columnName, setColumnName] = react_1.useState([]);
    const { dispatch } = react_1.default.useContext(NotificationContext_1.NotificationContext);
    let isError = false;
    react_1.useEffect(() => {
        if (tableName !== tableObj.tableName) {
            setTableName(tableObj.tableName);
            clearTimeout(timerId);
            timerId = setTimeout(() => {
                updateSchemaObj(tableObj.tableName);
            }, 1000);
        }
    }, [tableObj]);
    react_1.useEffect(() => {
        setTableObj(Object.assign(Object.assign({}, tableObj), { "tableType": tableType }));
    }, []);
    const updateSchemaObj = (tableName) => __awaiter(this, void 0, void 0, function* () {
        //table name is same as schema name
        const schemaObj = yield PinotMethodUtils_1.default.getSchemaData(tableName);
        if (schemaObj.error || typeof schemaObj === 'string') {
            dispatch({
                type: 'error',
                message: schemaObj.error || schemaObj,
                show: true
            });
            setSchemaObj(defaultSchemaObj);
        }
        else {
            setSchemaObj(Object.assign(Object.assign({}, defaultSchemaObj), schemaObj));
        }
    });
    const returnValue = (data, key) => {
        Object.keys(data).map((o) => __awaiter(this, void 0, void 0, function* () {
            if (!lodash_1.isEmpty(data[o]) && typeof data[o] === "object") {
                yield returnValue(data[o], key);
            }
            else if (!lodash_1.isEmpty(data[o]) && lodash_1.isArray(data[o])) {
                data[o].map((obj) => __awaiter(this, void 0, void 0, function* () {
                    yield returnValue(obj, key);
                }));
            }
            else {
                if (o === key && (data[key] === null || data[key] === "")) {
                    dispatch({
                        type: 'error',
                        message: `${key} cannot be empty`,
                        show: true
                    });
                    isError = true;
                }
            }
        }));
    };
    const checkFields = (tableObj, fields) => {
        fields.forEach((o) => __awaiter(this, void 0, void 0, function* () {
            if (tableObj[o.key] === undefined) {
                yield returnValue(tableObj, o.key);
            }
            else {
                if ((tableObj[o.key] === null || tableObj[o.key] === "")) {
                    dispatch({
                        type: 'error',
                        message: `${o.label} cannot be empty`,
                        show: true
                    });
                    isError = true;
                }
            }
        }));
    };
    const validateTableConfig = () => __awaiter(this, void 0, void 0, function* () {
        const fields = [{ key: "tableName", label: "Table Name" }, { key: "tableType", label: "Table Type" }, { key: "stream.kafka.broker.list", label: "stream.kafka.broker.list" }, { key: "stream.kafka.topic.name", label: "stream.kafka.topic.name" }, { key: "stream.kafka.consumer.type", label: "stream.kafka.consumer.type" }, { key: "stream.kafka.decoder.class.name", label: "stream.kafka.decoder.class.name" }];
        yield checkFields(tableObj, fields);
        if (isError) {
            isError = false;
            return false;
        }
        const validTable = yield PinotMethodUtils_1.default.validateTableAction(tableObj);
        if (validTable.error || typeof validTable === 'string') {
            dispatch({
                type: 'error',
                message: validTable.error || validTable,
                show: true
            });
            return false;
        }
        return true;
    });
    const handleSave = () => __awaiter(this, void 0, void 0, function* () {
        if (yield validateTableConfig()) {
            const tableCreationResp = yield PinotMethodUtils_1.default.saveTableAction(tableObj);
            dispatch({
                type: (tableCreationResp.error || typeof tableCreationResp === 'string') ? 'error' : 'success',
                message: tableCreationResp.error || tableCreationResp.status || tableCreationResp,
                show: true
            });
            tableCreationResp.status && fetchData();
            tableCreationResp.status && hideModal(null);
        }
    });
    react_1.useEffect(() => {
        let columnName = [];
        if (!lodash_1.isEmpty(schemaObj)) {
            tableNamekey.map((o) => {
                schemaObj[o] && schemaObj[o].map((obj) => {
                    columnName.push(obj.name);
                });
            });
        }
        setColumnName(columnName);
    }, [schemaObj]);
    return (react_1.default.createElement(CustomDialog_1.default, { open: true, handleClose: hideModal, handleSave: handleSave, title: `Add ${tableType} Table`, size: "xl", disableBackdropClick: true, disableEscapeKeyDown: true },
        react_1.default.createElement(core_1.DialogContent, null,
            react_1.default.createElement(core_1.Grid, { container: true, spacing: 2 },
                react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                    react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Add Table", showSearchBox: false },
                        react_1.default.createElement(AddTableComponent_1.default, { tableObj: tableObj, setTableObj: setTableObj, dateTimeFieldSpecs: schemaObj.dateTimeFieldSpecs, disable: tableType !== "" }))),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                    react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Tenants", showSearchBox: false },
                        react_1.default.createElement(AddTenantComponent_1.default, { tableObj: Object.assign({}, tableObj), setTableObj: setTableObj }))),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                    react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Ingestion", showSearchBox: false },
                        react_1.default.createElement(AddRealTimeIngestionComponent_1.default, { tableObj: Object.assign({}, tableObj), setTableObj: setTableObj, columnName: columnName }))),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                    react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Indexing & encoding", tooltipContent: react_1.default.createElement("a", { className: "tooltip-link", target: "_blank", href: "https://docs.pinot.apache.org/basics/indexing" }, "Click here for more details"), showSearchBox: false },
                        react_1.default.createElement(AddIndexingComponent_1.default, { tableObj: tableObj, setTableObj: setTableObj, columnName: columnName }))),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                    react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Partitioning & Routing", showSearchBox: false },
                        react_1.default.createElement(AddRealTimePartionComponent_1.default, { tableObj: tableObj, setTableObj: setTableObj, columnName: columnName }))),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                    react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Storage & Data retention", showSearchBox: false },
                        react_1.default.createElement(AddStorageComponent_1.default, { tableObj: tableObj, setTableObj: setTableObj }))),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                    react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Query", showSearchBox: false },
                        react_1.default.createElement(AddQueryComponent_1.default, { tableObj: tableObj, setTableObj: setTableObj }))),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 6 },
                    react_1.default.createElement("div", { className: classes.sqlDiv },
                        react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Table Config", showSearchBox: false },
                            react_1.default.createElement(CustomCodemirror_1.default, { customClass: classes.queryOutput, data: tableObj, isEditable: true, returnCodemirrorValue: (newValue) => {
                                    try {
                                        const jsonObj = JSON.parse(newValue);
                                        if (jsonObj) {
                                            jsonObj.segmentsConfig.replicasPerPartition = jsonObj.segmentsConfig.replication;
                                            setTableObj(jsonObj);
                                        }
                                    }
                                    catch (e) { }
                                } })))),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 6 },
                    react_1.default.createElement("div", { className: classes.sqlDiv },
                        react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Schema Config (Read only)", showSearchBox: false },
                            react_1.default.createElement(CustomCodemirror_1.default, { customClass: classes.queryOutput, data: schemaObj, isEditable: false }))))))));
}
exports.default = AddRealtimeTableOp;


/***/ }),

/***/ "./app/components/Homepage/Operations/AddSchemaOp.tsx":
/*!************************************************************!*\
  !*** ./app/components/Homepage/Operations/AddSchemaOp.tsx ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const CustomDialog_1 = __importDefault(__webpack_require__(/*! ../../CustomDialog */ "./app/components/CustomDialog.tsx"));
const SimpleAccordion_1 = __importDefault(__webpack_require__(/*! ../../SimpleAccordion */ "./app/components/SimpleAccordion.tsx"));
const SchemaComponent_1 = __importDefault(__webpack_require__(/*! ./SchemaComponent */ "./app/components/Homepage/Operations/SchemaComponent.tsx"));
const CustomCodemirror_1 = __importDefault(__webpack_require__(/*! ../../CustomCodemirror */ "./app/components/CustomCodemirror.tsx"));
const PinotMethodUtils_1 = __importDefault(__webpack_require__(/*! ../../../utils/PinotMethodUtils */ "./app/utils/PinotMethodUtils.ts"));
const NotificationContext_1 = __webpack_require__(/*! ../../Notification/NotificationContext */ "./app/components/Notification/NotificationContext.tsx");
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const InfoOutlined_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/InfoOutlined */ "./node_modules/@material-ui/icons/InfoOutlined.js"));
const useStyles = core_1.makeStyles((theme) => core_1.createStyles({
    sqlDiv: {
        border: '1px #BDCCD9 solid',
        borderRadius: 4,
        marginBottom: '20px',
    },
    queryOutput: {
        '& .CodeMirror': { height: '532px !important' },
    },
}));
const defaultSchemaConfig = {
    schemaName: '',
    dimensionFieldSpecs: [],
    metricFieldSpecs: [],
    dateTimeFieldSpecs: []
};
var EditView;
(function (EditView) {
    EditView["SIMPLE"] = "SIMPLE";
    EditView["JSON"] = "JSON";
})(EditView || (EditView = {}));
const DialogTitle = ({ editView, setEditView }) => (react_1.default.createElement("div", { style: { display: "flex", alignItems: "center", gap: "5px" } },
    "Add Schema",
    " ",
    react_1.default.createElement(core_1.Tooltip, { arrow: true, interactive: true, placement: "top", title: react_1.default.createElement("a", { className: "tooltip-link", href: "https://docs.pinot.apache.org/configuration-reference/schema", rel: "noreferrer", target: "_blank" }, "Click here for more details") },
        react_1.default.createElement(InfoOutlined_1.default, null)),
    react_1.default.createElement(core_1.ButtonGroup, { style: { marginLeft: "16px" }, size: "small", color: "primary" },
        react_1.default.createElement(core_1.Button, { variant: editView === EditView.SIMPLE ? "contained" : "outlined", onClick: () => setEditView(EditView.SIMPLE) }, "Simple"),
        react_1.default.createElement(core_1.Button, { variant: editView === EditView.JSON ? "contained" : "outlined", onClick: () => setEditView(EditView.JSON) }, "Json"))));
function AddSchemaOp({ hideModal, fetchData }) {
    const [editView, setEditView] = react_1.useState(EditView.SIMPLE);
    const classes = useStyles();
    const [schemaObj, setSchemaObj] = react_1.useState(Object.assign({}, defaultSchemaConfig));
    const [jsonSchema, setJsonSchema] = react_1.useState(Object.assign({}, defaultSchemaConfig));
    const { dispatch } = react_1.default.useContext(NotificationContext_1.NotificationContext);
    const schemaConfig = editView === EditView.SIMPLE ? schemaObj : jsonSchema;
    let isError = false;
    react_1.useEffect(() => {
        // reset schema config when view changes
        setSchemaObj(Object.assign({}, defaultSchemaConfig));
        setJsonSchema(Object.assign({}, defaultSchemaConfig));
    }, [editView]);
    const returnValue = (data, key) => {
        Object.keys(data).map((o) => __awaiter(this, void 0, void 0, function* () {
            if (!lodash_1.isEmpty(data[o]) && typeof data[o] === "object") {
                yield returnValue(data[o], key);
            }
            else if (!lodash_1.isEmpty(data[o]) && lodash_1.isArray(data[o])) {
                data[o].map((obj) => __awaiter(this, void 0, void 0, function* () {
                    yield returnValue(obj, key);
                }));
            }
            else {
                if (o === key && (data[key] === null || data[key] === "")) {
                    dispatch({
                        type: 'error',
                        message: `${key} cannot be empty`,
                        show: true
                    });
                    isError = true;
                }
            }
        }));
    };
    const checkFields = (tableObj, fields) => {
        fields.forEach((o) => __awaiter(this, void 0, void 0, function* () {
            if (tableObj[o.key] === undefined) {
                yield returnValue(tableObj, o.key);
            }
            else {
                if ((tableObj[o.key] === null || tableObj[o.key] === "")) {
                    dispatch({
                        type: 'error',
                        message: `${o.label} cannot be empty`,
                        show: true
                    });
                    isError = true;
                }
            }
        }));
    };
    const isObjEmpty = () => {
        const types = ["dimensionFieldSpecs", "metricFieldSpecs", "dateTimeFieldSpecs"];
        let notEmpty = true;
        types.map((t) => {
            if (schemaConfig[t].length) {
                notEmpty = false;
            }
        });
        return notEmpty;
    };
    const validateSchema = () => __awaiter(this, void 0, void 0, function* () {
        const validSchema = yield PinotMethodUtils_1.default.validateSchemaAction(schemaConfig);
        if (validSchema.error || typeof validSchema === 'string') {
            dispatch({
                type: 'error',
                message: validSchema.error || validSchema,
                show: true
            });
            return false;
        }
        return true;
    });
    const handleSave = () => __awaiter(this, void 0, void 0, function* () {
        const fields = [{ key: "schemaName", label: "schema Name" }, { key: "name", label: "Column Name" }, { key: "dataType", label: "Data Type" }];
        yield checkFields(schemaConfig, fields);
        if (isError) {
            isError = false;
            return false;
        }
        if (!isObjEmpty()) {
            if (yield validateSchema()) {
                const schemaCreationResp = yield PinotMethodUtils_1.default.saveSchemaAction(schemaConfig);
                dispatch({
                    type: (schemaCreationResp.error || typeof schemaCreationResp === 'string') ? 'error' : 'success',
                    message: schemaCreationResp.error || schemaCreationResp.status || schemaCreationResp,
                    show: true
                });
                if (!schemaCreationResp.error && typeof schemaCreationResp !== 'string') {
                    fetchData();
                    hideModal(null);
                }
            }
        }
        else {
            dispatch({
                type: 'error',
                message: "Please Enter atleast one Type",
                show: true
            });
        }
    });
    return (react_1.default.createElement(CustomDialog_1.default, { open: true, handleClose: hideModal, handleSave: handleSave, title: react_1.default.createElement(DialogTitle, { editView: editView, setEditView: setEditView }), size: "xl", disableBackdropClick: true, disableEscapeKeyDown: true },
        react_1.default.createElement(core_1.DialogContent, null,
            editView === EditView.SIMPLE && (react_1.default.createElement(core_1.Grid, { container: true, spacing: 2 },
                react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                    react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Add Schema", showSearchBox: false },
                        react_1.default.createElement(SchemaComponent_1.default, { schemaObj: schemaObj, schemaName: schemaObj.schemaName, setSchemaObj: (o) => { setSchemaObj(o); } }))),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 6 },
                    react_1.default.createElement("div", { className: classes.sqlDiv },
                        react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Schema Config (Read Only)", showSearchBox: false },
                            react_1.default.createElement(CustomCodemirror_1.default, { customClass: classes.queryOutput, data: schemaObj, isEditable: false, returnCodemirrorValue: (newValue) => {
                                    try {
                                        const jsonObj = JSON.parse(newValue);
                                        if (jsonObj) {
                                            jsonObj.segmentsConfig.replicasPerPartition = jsonObj.segmentsConfig.replication;
                                            setSchemaObj(jsonObj);
                                        }
                                    }
                                    catch (e) { }
                                } })))))),
            editView === EditView.JSON && (react_1.default.createElement(CustomCodemirror_1.default, { data: jsonSchema, isEditable: true, returnCodemirrorValue: (newValue) => {
                    try {
                        const jsonSchema = JSON.parse(newValue);
                        if (jsonSchema) {
                            setJsonSchema(jsonSchema);
                        }
                    }
                    catch (e) { }
                } })))));
}
exports.default = AddSchemaOp;


/***/ }),

/***/ "./app/components/Homepage/Operations/AddStorageComponent.tsx":
/*!********************************************************************!*\
  !*** ./app/components/Homepage/Operations/AddStorageComponent.tsx ***!
  \********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const useStyles = core_1.makeStyles((theme) => core_1.createStyles({
    formControl: {
        margin: theme.spacing(1),
        minWidth: 120,
    },
    selectFormControl: {
        margin: theme.spacing(1),
        width: 170
    }
}));
function AddStorageComponent({ tableObj, setTableObj }) {
    const classes = useStyles();
    const [tableDataObj, setTableDataObj] = react_1.useState(tableObj);
    const changeHandler = (fieldName, value) => {
        let newTableObj = Object.assign({}, tableDataObj);
        switch (fieldName) {
            case 'retentionTimeUnit':
                newTableObj.segmentsConfig.retentionTimeUnit = value;
                break;
            case 'retentionTimeValue':
                newTableObj.segmentsConfig.retentionTimeValue = value;
                break;
            case 'maxQueriesPerSecond':
                newTableObj.quota.storage = value;
                break;
        }
        ;
        setTableDataObj(newTableObj);
        setTableObj(newTableObj);
    };
    react_1.useEffect(() => {
        setTableDataObj(tableObj);
    }, [tableObj]);
    return (react_1.default.createElement(core_1.Grid, { container: true, spacing: 2 },
        react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
            react_1.default.createElement(core_1.Tooltip, { title: "Data will be deleted after this time period.", arrow: true, placement: "top-start" },
                react_1.default.createElement(core_1.FormControl, { className: classes.formControl },
                    react_1.default.createElement(core_1.InputLabel, { htmlFor: "retentionTimeValue" }, "Retention Value"),
                    react_1.default.createElement(core_1.Input, { id: "retentionTimeValue", key: "retentionTimeValue", value: tableDataObj.segmentsConfig.retentionTimeValue || "", onChange: (e) => changeHandler('retentionTimeValue', e.target.value), type: "number" }))),
            react_1.default.createElement(core_1.FormControl, { className: classes.selectFormControl },
                react_1.default.createElement(core_1.InputLabel, { htmlFor: "retentionTimeUnit" }, "Retention unit"),
                react_1.default.createElement(core_1.Select, { labelId: "retentionTimeUnit", id: "retentionTimeUnit", key: "retentionTimeUnit", value: tableDataObj.segmentsConfig.retentionTimeUnit && tableDataObj.segmentsConfig.retentionTimeUnit !== "" ? tableDataObj.segmentsConfig.retentionTimeUnit : '', onChange: (e) => changeHandler('retentionTimeUnit', e.target.value) },
                    react_1.default.createElement(core_1.MenuItem, { value: "HOURS" }, "HOURS"),
                    react_1.default.createElement(core_1.MenuItem, { value: "DAYS" }, "DAYS"))),
            react_1.default.createElement(core_1.Tooltip, { title: "Data pushes which exceed this size will fail.", arrow: true, placement: "top-start" },
                react_1.default.createElement(core_1.FormControl, { className: classes.formControl },
                    react_1.default.createElement(core_1.InputLabel, { htmlFor: "maxQueriesPerSecond" }, "Storage Quota"),
                    react_1.default.createElement(core_1.Input, { id: "maxQueriesPerSecond", key: "maxQueriesPerSecond", value: tableDataObj.quota.storage || "", onChange: (e) => changeHandler('maxQueriesPerSecond', e.target.value) }))))));
}
exports.default = AddStorageComponent;


/***/ }),

/***/ "./app/components/Homepage/Operations/AddTableComponent.tsx":
/*!******************************************************************!*\
  !*** ./app/components/Homepage/Operations/AddTableComponent.tsx ***!
  \******************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const lab_1 = __webpack_require__(/*! @material-ui/lab */ "./node_modules/@material-ui/lab/esm/index.js");
const useStyles = core_1.makeStyles((theme) => core_1.createStyles({
    formControl: {
        margin: theme.spacing(1),
        minWidth: 120,
    },
    selectFormControl: {
        margin: theme.spacing(1),
        width: 170
    },
    autoCompleteControl: {
        '& .MuiFormControl-marginNormal': {
            marginTop: 0
        }
    },
    redColor: {
        color: theme.palette.error.main
    }
}));
function AddTableComponent({ tableObj, setTableObj, dateTimeFieldSpecs, disable }) {
    const classes = useStyles();
    const [tableDataObj, setTableDataObj] = react_1.useState(tableObj);
    const [dateFields, setDateFields] = react_1.useState([]);
    const [timeColumn, setTimeColumn] = react_1.useState('');
    const changeHandler = (fieldName, value) => {
        let newTableObj = Object.assign({}, tableDataObj);
        switch (fieldName) {
            case 'tableName':
                newTableObj[fieldName] = value;
                newTableObj.segmentsConfig.schemaName = value;
                break;
            case 'tableType':
                newTableObj[fieldName] = value;
                break;
            case 'timeColumnName':
                setTimeColumn(value);
                newTableObj.segmentsConfig[fieldName] = value || null;
                break;
            case 'replication':
                newTableObj.segmentsConfig[fieldName] = value;
                newTableObj.segmentsConfig['replicasPerPartition'] = value;
                break;
        }
        ;
        setTableDataObj(newTableObj);
        setTableObj(newTableObj);
    };
    react_1.useEffect(() => {
        setTableDataObj(tableObj);
    }, [tableObj]);
    react_1.useEffect(() => {
        let newTableObj = Object.assign({}, tableDataObj);
        let colName = dateTimeFieldSpecs.length ? dateTimeFieldSpecs[0].name : '';
        let dateOptions = [];
        dateTimeFieldSpecs.map((field) => {
            dateOptions.push(field.name);
        });
        setDateFields(dateOptions);
        if (!timeColumn) {
            setTimeColumn(colName);
            newTableObj.segmentsConfig.timeColumnName = colName || null;
            setTableDataObj(newTableObj);
            setTableObj(newTableObj);
        }
        else {
            const isDatetimeColAvailable = dateTimeFieldSpecs.find((field) => { return field.name === timeColumn; });
            if (!isDatetimeColAvailable) {
                setTimeColumn(colName);
                newTableObj.segmentsConfig.timeColumnName = colName || null;
                setTableDataObj(newTableObj);
                setTableObj(newTableObj);
            }
        }
    }, [dateTimeFieldSpecs]);
    const requiredAstrix = react_1.default.createElement("span", { className: classes.redColor }, "*");
    return (react_1.default.createElement(core_1.Grid, { container: true, spacing: 2 },
        react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
            react_1.default.createElement(core_1.FormControl, { className: classes.formControl },
                react_1.default.createElement(core_1.InputLabel, { htmlFor: "tableName" },
                    "Table Name ",
                    requiredAstrix),
                react_1.default.createElement(core_1.Input, { id: "tableName", value: tableDataObj.tableName, onChange: (e) => changeHandler('tableName', e.target.value) })),
            react_1.default.createElement(core_1.FormControl, { className: classes.selectFormControl },
                react_1.default.createElement(core_1.InputLabel, { htmlFor: "tableType" },
                    "Table Type ",
                    requiredAstrix),
                react_1.default.createElement(core_1.Select, { labelId: "tableType", id: "tableType", value: tableDataObj.tableType, onChange: (e) => changeHandler('tableType', e.target.value), disabled: disable },
                    react_1.default.createElement(core_1.MenuItem, { value: "OFFLINE" }, "OFFLINE"),
                    react_1.default.createElement(core_1.MenuItem, { value: "REALTIME" }, "REALTIME"))),
            react_1.default.createElement(core_1.Tooltip, { title: "Pick a primary time column from all the DateTime columns", arrow: true, placement: "top-start" },
                react_1.default.createElement(core_1.FormControl, { className: classes.selectFormControl },
                    react_1.default.createElement(lab_1.Autocomplete, { className: classes.autoCompleteControl, value: timeColumn, options: dateFields, onChange: (e, value) => changeHandler('timeColumnName', value ? value : ''), disableClearable: true, autoHighlight: true, renderInput: (params) => (react_1.default.createElement(core_1.TextField, Object.assign({}, params, { label: react_1.default.createElement(react_1.default.Fragment, null,
                                "Time Column Name",
                                tableDataObj.tableType === 'REALTIME' && requiredAstrix), margin: "normal" }))) }))),
            react_1.default.createElement(core_1.Tooltip, { title: "Number of copies to create per segment", arrow: true, placement: "top-start" },
                react_1.default.createElement(core_1.FormControl, { className: classes.selectFormControl },
                    react_1.default.createElement(core_1.InputLabel, { htmlFor: "replication" }, "Replication"),
                    react_1.default.createElement(core_1.Select, { labelId: "replication", id: "replication", value: tableDataObj.segmentsConfig.replication, onChange: (e) => changeHandler('replication', e.target.value) }, [...Array(20).keys()].map((num, index) => (react_1.default.createElement(core_1.MenuItem, { key: index, value: `${num + 1}` }, `${num + 1}`)))))))));
}
exports.default = AddTableComponent;


/***/ }),

/***/ "./app/components/Homepage/Operations/AddTenantComponent.tsx":
/*!*******************************************************************!*\
  !*** ./app/components/Homepage/Operations/AddTenantComponent.tsx ***!
  \*******************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const lab_1 = __webpack_require__(/*! @material-ui/lab */ "./node_modules/@material-ui/lab/esm/index.js");
const useStyles = core_1.makeStyles((theme) => core_1.createStyles({
    formControl: {
        margin: theme.spacing(1),
        minWidth: 120,
    },
    selectFormControl: {
        margin: theme.spacing(1),
        width: 305
    },
    autoCompleteControl: {
        '& .MuiFormControl-marginNormal': {
            marginTop: 0
        }
    },
    redColor: {
        color: theme.palette.error.main
    }
}));
function AddTenantComponent({ tableObj, setTableObj }) {
    const classes = useStyles();
    const [tableDataObj, setTableDataObj] = react_1.useState(tableObj);
    const [tenantServer, setTenantServer] = react_1.useState('');
    const [tenantBroker, setTenantBroker] = react_1.useState('');
    const [serverOptions, setServerOptions] = react_1.useState([]);
    const [brokerOptions, setBrokerOptions] = react_1.useState([]);
    const [showRealtimeCompleted, setShowRealtimeCompleted] = react_1.useState(0);
    const changeHandler = (fieldName, value) => {
        let newTableObj = Object.assign({}, tableDataObj);
        switch (fieldName) {
            case 'broker':
                setTenantBroker(value);
                newTableObj.tenants.broker = value;
                break;
            case 'server':
                setTenantServer(value);
                newTableObj.tenants.server = value;
                break;
            case 'tagOverrideConfig':
                setShowRealtimeCompleted(value);
                if (value) {
                    newTableObj.tenants.tagOverrideConfig = {};
                    newTableObj.tenants.tagOverrideConfig.realtimeCompleted = `${tenantServer}_OFFLINE`;
                }
                else {
                    delete newTableObj.tenants.tagOverrideConfig;
                }
                break;
            case 'showRealtimeCompleted':
                newTableObj.tenants.tagOverrideConfig.realtimeCompleted = value;
                break;
        }
        setTableDataObj(newTableObj);
        setTableObj(newTableObj);
    };
    react_1.useEffect(() => {
        if (!(tableDataObj.tenants.tagOverrideConfig && tableDataObj.tenants.tagOverrideConfig.realtimeCompleted)) {
            setShowRealtimeCompleted(0);
        }
        setTableDataObj(tableObj);
    }, [tableObj]);
    react_1.useEffect(() => {
        let serverOptions = [], brokerOptions = [];
        setServerOptions(serverOptions);
        setBrokerOptions(brokerOptions);
        setTenantServer(tableDataObj.tenants.server);
        setTenantBroker(tableDataObj.tenants.broker);
    }, []);
    const requiredAstrix = react_1.default.createElement("span", { className: classes.redColor }, "*");
    return (react_1.default.createElement(core_1.Grid, { container: true, spacing: 2 },
        react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
            react_1.default.createElement(core_1.FormControl, { className: classes.selectFormControl },
                react_1.default.createElement(lab_1.Autocomplete, { key: 'server', className: classes.autoCompleteControl, value: tenantServer, options: serverOptions, onChange: (e, value) => changeHandler('server', value ? value : ''), disableClearable: true, autoHighlight: true, renderInput: (params) => (react_1.default.createElement(core_1.TextField, Object.assign({}, params, { label: react_1.default.createElement(react_1.default.Fragment, null, "Server Tenant"), margin: "normal" }))) })),
            react_1.default.createElement(core_1.FormControl, { className: classes.selectFormControl },
                react_1.default.createElement(lab_1.Autocomplete, { key: 'broker', className: classes.autoCompleteControl, value: tenantBroker, options: brokerOptions, onChange: (e, value) => changeHandler('broker', value ? value : ''), disableClearable: true, autoHighlight: true, renderInput: (params) => (react_1.default.createElement(core_1.TextField, Object.assign({}, params, { label: react_1.default.createElement(react_1.default.Fragment, null, "Broker Tenant"), margin: "normal" }))) })),
            react_1.default.createElement(core_1.FormControl, { className: classes.selectFormControl },
                react_1.default.createElement(core_1.InputLabel, { htmlFor: "tagOverrideConfig" }, "Relocate realtime completed segments?"),
                react_1.default.createElement(core_1.Select, { labelId: "tagOverrideConfig", id: "tagOverrideConfig", value: showRealtimeCompleted, onChange: (e) => changeHandler('tagOverrideConfig', e.target.value) },
                    react_1.default.createElement(core_1.MenuItem, { value: 1 }, "True"),
                    react_1.default.createElement(core_1.MenuItem, { value: 0 }, "False"))),
            showRealtimeCompleted ?
                react_1.default.createElement(core_1.Tooltip, { interactive: true, title: (react_1.default.createElement(react_1.default.Fragment, null,
                        react_1.default.createElement("a", { href: "https://docs.pinot.apache.org/operators/operating-pinot/tuning/realtime#moving-completed-segments-to-different-hosts", target: "_blank", className: "tooltip-link" }, "Click here for more details"))), arrow: true, placement: "top-start" },
                    react_1.default.createElement(core_1.FormControl, { className: classes.formControl },
                        react_1.default.createElement(core_1.InputLabel, { htmlFor: "realtimeCompleted" }, "Relocate to tag"),
                        react_1.default.createElement(core_1.Input, { id: "realtimeCompleted", value: tableDataObj.tenants.tagOverrideConfig.realtimeCompleted, onChange: (e) => changeHandler('showRealtimeCompleted', e.target.value) }))) : null)));
}
exports.default = AddTenantComponent;


/***/ }),

/***/ "./app/components/Homepage/Operations/EditConfigOp.tsx":
/*!*************************************************************!*\
  !*** ./app/components/Homepage/Operations/EditConfigOp.tsx ***!
  \*************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const CustomDialog_1 = __importDefault(__webpack_require__(/*! ../../CustomDialog */ "./app/components/CustomDialog.tsx"));
const CustomCodemirror_1 = __importDefault(__webpack_require__(/*! ../../CustomCodemirror */ "./app/components/CustomCodemirror.tsx"));
function EditConfigOp({ showModal, hideModal, saveConfig, handleConfigChange, config }) {
    return (react_1.default.createElement(CustomDialog_1.default, { open: showModal, handleClose: hideModal, title: "Edit Config", handleSave: saveConfig },
        react_1.default.createElement(core_1.DialogContent, null,
            react_1.default.createElement(CustomCodemirror_1.default, { data: config, isEditable: true, returnCodemirrorValue: (newValue) => {
                    handleConfigChange(newValue);
                } }))));
}
exports.default = EditConfigOp;


/***/ }),

/***/ "./app/components/Homepage/Operations/EditTagsOp.tsx":
/*!***********************************************************!*\
  !*** ./app/components/Homepage/Operations/EditTagsOp.tsx ***!
  \***********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const CustomDialog_1 = __importDefault(__webpack_require__(/*! ../../CustomDialog */ "./app/components/CustomDialog.tsx"));
const CustomMultiSelect_1 = __importDefault(__webpack_require__(/*! ../../CustomMultiSelect */ "./app/components/CustomMultiSelect.tsx"));
function CustomModal({ showModal, hideModal, saveTags, handleTagsChange, tags, error }) {
    const tagsRef = react_1.default.createRef();
    return (react_1.default.createElement(CustomDialog_1.default, { open: showModal, handleClose: hideModal, title: "Edit Tags", handleSave: (event) => {
            saveTags(event, tagsRef.current.value);
        } },
        react_1.default.createElement(core_1.DialogContent, null,
            react_1.default.createElement(CustomMultiSelect_1.default, { ref: tagsRef, handleChange: handleTagsChange, value: tags, error: error }))));
}
exports.default = CustomModal;


/***/ }),

/***/ "./app/components/Homepage/Operations/MultiIndexingComponent.tsx":
/*!***********************************************************************!*\
  !*** ./app/components/Homepage/Operations/MultiIndexingComponent.tsx ***!
  \***********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const AddCircle_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/AddCircle */ "./node_modules/@material-ui/icons/AddCircle.js"));
const Clear_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/Clear */ "./node_modules/@material-ui/icons/Clear.js"));
const useStyles = core_1.makeStyles((theme) => core_1.createStyles({
    formControl: {
        margin: theme.spacing(1),
        width: '100%'
    },
    selectFormControl: {
        margin: theme.spacing(1),
        width: 170
    },
    deleteIcon: {
        marginTop: 15,
        color: theme.palette.error.main
    },
    autoCompleteControl: {
        '& .MuiFormControl-marginNormal': {
            marginTop: 0
        }
    },
    redColor: {
        color: theme.palette.error.main
    }
}));
function MultiIndexingComponent({ changeHandler, streamConfigsObj, columnName, tableDataObj, textDataObj }) {
    const classes = useStyles();
    const ITEM_HEIGHT = 48;
    const ITEM_PADDING_TOP = 8;
    const MenuProps = {
        PaperProps: {
            style: {
                maxHeight: ITEM_HEIGHT * 4.5 + ITEM_PADDING_TOP,
                width: 250,
            },
        },
    };
    const [jsonUpdated, setJsonUpdated] = react_1.useState(false);
    const updateFieldForColumnName = (tempStreamConfigObj, values, Field, majorField) => {
        values.map((v) => {
            let valChanged = false;
            tempStreamConfigObj.map((o) => {
                if (v === o.columnName) {
                    if ("Encoding" === majorField) {
                        o[majorField] = Field;
                    }
                    else {
                        o[majorField].push(Field);
                    }
                    valChanged = true;
                }
            });
            if (!valChanged) {
                tempStreamConfigObj.push({
                    columnName: v,
                    Indexing: [],
                    Encoding: "",
                    [majorField]: "Encoding" === majorField ? Field : [Field]
                });
            }
        });
        return tempStreamConfigObj;
    };
    const convertInputToData = (input, isJsonUpdated) => {
        let tempStreamConfigObj = [];
        Object.keys(input).map((o) => {
            switch (o) {
                case "invertedIndexColumns":
                    tempStreamConfigObj = updateFieldForColumnName(tempStreamConfigObj, input[o], "Inverted", "Indexing");
                    break;
                case "rangeIndexColumns":
                    tempStreamConfigObj = updateFieldForColumnName(tempStreamConfigObj, input[o], "Range", "Indexing");
                    break;
                case "sortedColumn":
                    tempStreamConfigObj = updateFieldForColumnName(tempStreamConfigObj, input[o], "Sorted", "Indexing");
                    break;
                case "bloomFilterColumns":
                    tempStreamConfigObj = updateFieldForColumnName(tempStreamConfigObj, input[o], "bloomFilter", "Indexing");
                    break;
                case "noDictionaryColumns":
                    tempStreamConfigObj = updateFieldForColumnName(tempStreamConfigObj, input[o], "None", "Encoding");
                    break;
                case "DictionaryColumns":
                    tempStreamConfigObj = updateFieldForColumnName(tempStreamConfigObj, input[o], "Dictionary", "Encoding");
                    break;
                case "onHeapDictionaryColumns":
                    tempStreamConfigObj = updateFieldForColumnName(tempStreamConfigObj, input[o], "heapDictionary", "Encoding");
                    break;
                case "varLengthDictionaryColumns":
                    tempStreamConfigObj = updateFieldForColumnName(tempStreamConfigObj, input[o], "varDictionary", "Encoding");
                    break;
            }
        });
        if (textDataObj && textDataObj.length) {
            textDataObj.map((o) => {
                tempStreamConfigObj = updateFieldForColumnName(tempStreamConfigObj, [o.name], "Text", "Indexing");
            });
        }
        return tempStreamConfigObj;
    };
    const [streamConfigObj, setStreamConfigObj] = react_1.useState(convertInputToData(streamConfigsObj, false));
    const addButtonClick = () => {
        let data = {
            columnName: "",
            Indexing: [],
            Encoding: ""
        };
        let tempStreamConfigObj = [...streamConfigObj, data];
        setStreamConfigObj(tempStreamConfigObj);
        // changeHandler('tableIndexConfig',convertDataToInput(tempStreamConfigObj));
    };
    const convertDataToInput = (input) => __awaiter(this, void 0, void 0, function* () {
        let outputData = {
            invertedIndexColumns: [],
            rangeIndexColumns: [],
            sortedColumn: [],
            noDictionaryColumns: [],
            DictionaryColumns: [],
            onHeapDictionaryColumns: [],
            varLengthDictionaryColumns: [],
            bloomFilterColumns: []
        };
        let fieldConfigList = [];
        input.map((i) => {
            i.Indexing.map((o) => {
                switch (o) {
                    case "Sorted":
                        outputData.sortedColumn.push(i.columnName);
                        break;
                    case "Inverted":
                        outputData.invertedIndexColumns.push(i.columnName);
                        break;
                    case "Range":
                        outputData.rangeIndexColumns.push(i.columnName);
                        break;
                    case "bloomFilter":
                        outputData.bloomFilterColumns.push(i.columnName);
                        break;
                    case "Text":
                        fieldConfigList.push({ "name": i.columnName, "encodingType": "RAW", "indexType": "TEXT" });
                        break;
                }
            });
            switch (i.Encoding) {
                case "None":
                    outputData.noDictionaryColumns.push(i.columnName);
                    break;
                case "Dictionary":
                    outputData.DictionaryColumns.push(i.columnName);
                    break;
                case "heapDictionary":
                    outputData.onHeapDictionaryColumns.push(i.columnName);
                    break;
                case "varDictionary":
                    outputData.varLengthDictionaryColumns.push(i.columnName);
                    break;
            }
        });
        return {
            tableIndexConfig: outputData,
            fieldConfigList
        };
    });
    const keyChange = (input, index, value) => {
        let tempStreamConfigObj = [...streamConfigObj];
        tempStreamConfigObj[index][input] = value;
        setStreamConfigObj(tempStreamConfigObj);
    };
    const updateJson = () => __awaiter(this, void 0, void 0, function* () {
        changeHandler('tableIndexConfig', yield convertDataToInput(streamConfigObj));
    });
    const deleteClick = (ind) => __awaiter(this, void 0, void 0, function* () {
        let tempStreamConfigObj = [...streamConfigObj];
        tempStreamConfigObj.splice(ind, 1);
        setStreamConfigObj(tempStreamConfigObj);
        changeHandler('tableIndexConfig', yield convertDataToInput(tempStreamConfigObj));
    });
    react_1.useEffect(() => {
        if (jsonUpdated) {
            setJsonUpdated(false);
        }
        else {
            let value = convertInputToData(streamConfigsObj, true);
            if (value.length >= streamConfigObj.length) {
                setStreamConfigObj(value);
            }
            setJsonUpdated(true);
        }
    }, [streamConfigsObj]);
    return (react_1.default.createElement(core_1.Grid, { container: true, spacing: 2 },
        streamConfigObj && streamConfigObj.map((o, i) => {
            return (react_1.default.createElement(core_1.Grid, { item: true, xs: 6 },
                react_1.default.createElement("div", { className: "box-border" },
                    react_1.default.createElement(core_1.Grid, { container: true, spacing: 2 },
                        react_1.default.createElement(core_1.Grid, { item: true, xs: 3 },
                            react_1.default.createElement(core_1.FormControl, { className: classes.formControl },
                                react_1.default.createElement(core_1.InputLabel, { htmlFor: o.columnName }, "Column Name"),
                                react_1.default.createElement(core_1.Select, { labelId: o.columnName, id: o.columnName, value: o.columnName, key: i + "columnName", onChange: (e) => keyChange("columnName", i, e.target.value), onBlur: updateJson }, columnName.map((val) => {
                                    return react_1.default.createElement(core_1.MenuItem, { value: val }, val);
                                })))),
                        react_1.default.createElement(core_1.Grid, { item: true, xs: 4 },
                            react_1.default.createElement(core_1.Tooltip, { title: "Select a column encoding. By default, all columns are dictionary encoded.", arrow: true, placement: "top-start" },
                                react_1.default.createElement(core_1.FormControl, { className: classes.formControl },
                                    react_1.default.createElement(core_1.InputLabel, { htmlFor: o.Encoding }, "Encoding"),
                                    react_1.default.createElement(core_1.Select, { labelId: o.Encoding, id: o.Encoding, key: i + "Encoding", value: o.Encoding, onChange: (e) => keyChange("Encoding", i, e.target.value), onBlur: updateJson },
                                        react_1.default.createElement(core_1.MenuItem, { value: "None" }, "None"),
                                        react_1.default.createElement(core_1.MenuItem, { value: "Dictionary" }, "Dictionary"),
                                        react_1.default.createElement(core_1.MenuItem, { value: "varDictionary" }, "Variable Length Dictionary"),
                                        react_1.default.createElement(core_1.MenuItem, { value: "heapDictionary" }, "On Heap Dictionary"))))),
                        react_1.default.createElement(core_1.Grid, { item: true, xs: 4 },
                            react_1.default.createElement(core_1.Tooltip, { title: "Select indexes to apply. By default, no indexing is applied.", arrow: true, placement: "top-start" },
                                react_1.default.createElement(core_1.FormControl, { className: classes.formControl },
                                    react_1.default.createElement(core_1.InputLabel, { htmlFor: i + "keymulti" }, "Indexing"),
                                    react_1.default.createElement(core_1.Select, { labelId: i + "keymulti", id: i + "keymulti", key: i + "Indexing", multiple: true, value: o.Indexing || [], onChange: (e) => keyChange("Indexing", i, e.target.value), input: react_1.default.createElement(core_1.Input, { id: "select-multiple-chip" }), renderValue: (selected) => (react_1.default.createElement("div", { className: "chips" }, selected.map((value) => (react_1.default.createElement(core_1.Chip, { key: value, label: value, className: "chip" }))))), MenuProps: MenuProps, onBlur: updateJson },
                                        react_1.default.createElement(core_1.MenuItem, { value: "None" }, "None"),
                                        react_1.default.createElement(core_1.MenuItem, { value: "Sorted" }, "Sorted"),
                                        react_1.default.createElement(core_1.MenuItem, { value: "Inverted" }, "Inverted"),
                                        react_1.default.createElement(core_1.MenuItem, { value: "Range" }, "Range"),
                                        react_1.default.createElement(core_1.MenuItem, { value: "Text" }, "Text"),
                                        react_1.default.createElement(core_1.MenuItem, { value: "bloomFilter" }, "Bloom filter"))))),
                        react_1.default.createElement(core_1.Grid, { item: true, xs: 1 },
                            react_1.default.createElement(core_1.FormControl, null,
                                react_1.default.createElement(core_1.IconButton, { "aria-label": "delete", className: classes.deleteIcon, onClick: () => {
                                        deleteClick(i);
                                    } },
                                    react_1.default.createElement(Clear_1.default, null))))))));
        }),
        react_1.default.createElement(core_1.Grid, { item: true, xs: 3 },
            react_1.default.createElement(core_1.FormControl, { className: classes.formControl },
                react_1.default.createElement(core_1.Button, { "aria-label": "plus", variant: "outlined", color: "primary", onClick: addButtonClick, startIcon: (react_1.default.createElement(AddCircle_1.default, null)) }, "Add new Field")))));
}
exports.default = MultiIndexingComponent;


/***/ }),

/***/ "./app/components/Homepage/Operations/MultipleSelectComponent.tsx":
/*!************************************************************************!*\
  !*** ./app/components/Homepage/Operations/MultipleSelectComponent.tsx ***!
  \************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const AddCircle_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/AddCircle */ "./node_modules/@material-ui/icons/AddCircle.js"));
const Clear_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/Clear */ "./node_modules/@material-ui/icons/Clear.js"));
const useStyles = core_1.makeStyles((theme) => core_1.createStyles({
    formControl: {
        margin: theme.spacing(1),
        width: '100%'
    },
    deleteIcon: {
        marginTop: 15,
        color: theme.palette.error.main
    },
    selectFormControl: {
        margin: theme.spacing(1),
        width: 170
    },
    autoCompleteControl: {
        '& .MuiFormControl-marginNormal': {
            marginTop: 0
        }
    }
}));
function AddDeleteComponent({ changeHandler, streamConfigsObj, columnName }) {
    const classes = useStyles();
    const [streamConfigObj, setStreamConfigObj] = react_1.useState(streamConfigsObj);
    const ITEM_HEIGHT = 48;
    const ITEM_PADDING_TOP = 8;
    const MenuProps = {
        PaperProps: {
            style: {
                maxHeight: ITEM_HEIGHT * 4.5 + ITEM_PADDING_TOP,
                width: 250,
            },
        },
    };
    const addButtonClick = () => {
        let data = { columnName: "", transformFunction: "" };
        let tempStreamConfigObj = [...streamConfigObj, data];
        setStreamConfigObj(tempStreamConfigObj);
        changeHandler('transformConfigs', tempStreamConfigObj);
    };
    const inputChange = (input, index, value) => {
        let tempStreamConfigObj = [...streamConfigObj];
        tempStreamConfigObj[index][input] = value;
        setStreamConfigObj(tempStreamConfigObj);
    };
    const updateJson = () => {
        changeHandler('transformConfigs', streamConfigObj);
    };
    const deleteClick = (index) => {
        let tempStreamConfigObj = [...streamConfigObj];
        tempStreamConfigObj.splice(index, 1);
        changeHandler('transformConfigs', tempStreamConfigObj);
    };
    react_1.useEffect(() => {
        setStreamConfigObj(streamConfigsObj);
    }, [streamConfigsObj]);
    return (react_1.default.createElement(core_1.Grid, { container: true, spacing: 2 },
        react_1.default.createElement(core_1.Tooltip, { interactive: true, title: (react_1.default.createElement(react_1.default.Fragment, null,
                "Transform the data values using Groovy or other inbuilt functions.",
                react_1.default.createElement("a", { className: "tooltip-link", target: "_blank", href: "https://docs.pinot.apache.org/developers/advanced/ingestion-level-transformations#column-transformation" }, "(Click here for more details)"))), arrow: true, placement: "top" },
            react_1.default.createElement("h3", { className: "accordion-subtitle" }, "Transform functions")),
        streamConfigObj.map((o, i) => {
            return (react_1.default.createElement(core_1.Grid, { item: true, xs: 4 },
                react_1.default.createElement("div", { className: "box-border" },
                    react_1.default.createElement(core_1.Grid, { container: true, spacing: 2 },
                        react_1.default.createElement(core_1.Grid, { item: true, xs: 5 },
                            react_1.default.createElement(core_1.FormControl, { className: classes.formControl },
                                react_1.default.createElement(core_1.InputLabel, { htmlFor: o.columnName }, "Column Name"),
                                react_1.default.createElement(core_1.Select, { labelId: o.columnName, id: o.columnName, value: o.columnName, key: i + "valuemulti", onChange: (e) => inputChange("columnName", i, e.target.value), onBlur: updateJson }, columnName.map((val) => {
                                    return react_1.default.createElement(core_1.MenuItem, { value: val }, val);
                                })))),
                        react_1.default.createElement(core_1.Grid, { item: true, xs: 5 },
                            react_1.default.createElement(core_1.FormControl, { className: classes.formControl },
                                react_1.default.createElement(core_1.InputLabel, { htmlFor: o.transformFunction }, "Transform Function"),
                                react_1.default.createElement(core_1.Input, { id: o.transformFunction, value: o.transformFunction, key: i + "keyval", onChange: (e) => inputChange("transformFunction", i, e.target.value), onBlur: updateJson }))),
                        react_1.default.createElement(core_1.Grid, { item: true, xs: 2 },
                            react_1.default.createElement(core_1.FormControl, null,
                                react_1.default.createElement(core_1.IconButton, { "aria-label": "delete", className: classes.deleteIcon, onClick: () => {
                                        deleteClick(i);
                                    } },
                                    react_1.default.createElement(Clear_1.default, null))))))));
        }),
        react_1.default.createElement(core_1.Grid, { item: true, xs: 3 },
            react_1.default.createElement(core_1.FormControl, { className: classes.formControl },
                react_1.default.createElement(core_1.Button, { "aria-label": "plus", variant: "outlined", color: "primary", onClick: addButtonClick, startIcon: (react_1.default.createElement(AddCircle_1.default, null)) }, "Add new Field")))));
}
exports.default = AddDeleteComponent;


/***/ }),

/***/ "./app/components/Homepage/Operations/RebalanceServerTableOp.tsx":
/*!***********************************************************************!*\
  !*** ./app/components/Homepage/Operations/RebalanceServerTableOp.tsx ***!
  \***********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const CustomDialog_1 = __importDefault(__webpack_require__(/*! ../../CustomDialog */ "./app/components/CustomDialog.tsx"));
const PinotMethodUtils_1 = __importDefault(__webpack_require__(/*! ../../../utils/PinotMethodUtils */ "./app/utils/PinotMethodUtils.ts"));
const CustomCodemirror_1 = __importDefault(__webpack_require__(/*! ../../CustomCodemirror */ "./app/components/CustomCodemirror.tsx"));
const InfoOutlined_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/InfoOutlined */ "./node_modules/@material-ui/icons/InfoOutlined.js"));
function RebalanceServerTableOp({ hideModal, tableName, tableType }) {
    const [rebalanceResponse, setRebalanceResponse] = react_1.default.useState(null);
    const [dryRun, setDryRun] = react_1.default.useState(false);
    const [reassignInstances, setReassignInstances] = react_1.default.useState(false);
    const [includeConsuming, setIncludeConsuming] = react_1.default.useState(false);
    const [bootstrap, setBootstrap] = react_1.default.useState(false);
    const [downtime, setDowntime] = react_1.default.useState(false);
    const [minAvailableReplicas, setMinAvailableReplicas] = react_1.default.useState("1");
    const [bestEfforts, setBestEfforts] = react_1.default.useState(false);
    const [lowDiskMode, setLowDiskMode] = react_1.default.useState(false);
    const getData = () => {
        return {
            type: tableType,
            dryRun, reassignInstances, includeConsuming, bootstrap, downtime, bestEfforts, lowDiskMode,
            minAvailableReplicas: parseInt(minAvailableReplicas, 10)
        };
    };
    const handleSave = (event) => __awaiter(this, void 0, void 0, function* () {
        const data = getData();
        const response = yield PinotMethodUtils_1.default.rebalanceServersForTableOp(tableName, data);
        setRebalanceResponse(response);
    });
    return (react_1.default.createElement(CustomDialog_1.default, { open: true, handleClose: hideModal, title: (react_1.default.createElement(react_1.default.Fragment, null,
            "Rebalance Server ",
            react_1.default.createElement(core_1.Tooltip, { interactive: true, title: (react_1.default.createElement("a", { className: "tooltip-link", target: "_blank", href: "https://docs.pinot.apache.org/operators/operating-pinot/rebalance/rebalance-servers" }, "Click here for more details")), arrow: true, placement: "top" },
                react_1.default.createElement(InfoOutlined_1.default, null)))), handleSave: handleSave, showOkBtn: !rebalanceResponse },
        react_1.default.createElement(core_1.DialogContent, null, !rebalanceResponse ?
            react_1.default.createElement(core_1.Grid, { container: true, spacing: 2 },
                react_1.default.createElement(core_1.Grid, { item: true, xs: 6 },
                    react_1.default.createElement(core_1.FormControlLabel, { control: react_1.default.createElement(core_1.Switch, { checked: dryRun, onChange: () => setDryRun(!dryRun), name: "dryRun", color: "primary" }), label: "Dry Run" }),
                    react_1.default.createElement("br", null),
                    react_1.default.createElement(core_1.FormControlLabel, { control: react_1.default.createElement(core_1.Switch, { checked: includeConsuming, onChange: () => setIncludeConsuming(!includeConsuming), name: "includeConsuming", color: "primary" }), label: "Include Consuming" }),
                    react_1.default.createElement("br", null),
                    react_1.default.createElement(core_1.FormControlLabel, { control: react_1.default.createElement(core_1.Switch, { checked: downtime, onChange: () => setDowntime(!downtime), name: "downtime", color: "primary" }), label: "Downtime" }),
                    react_1.default.createElement("br", null),
                    react_1.default.createElement(core_1.FormControlLabel, { control: react_1.default.createElement(core_1.Switch, { checked: lowDiskMode, onChange: () => setLowDiskMode(!lowDiskMode), name: "lowDiskMode", color: "primary" }), label: "Low Disk Mode" })),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 6 },
                    react_1.default.createElement(core_1.FormControlLabel, { control: react_1.default.createElement(core_1.Switch, { checked: reassignInstances, onChange: () => setReassignInstances(!reassignInstances), name: "reassignInstances", color: "primary" }), label: "Reassign Instances" }),
                    react_1.default.createElement("br", null),
                    react_1.default.createElement(core_1.FormControlLabel, { control: react_1.default.createElement(core_1.Switch, { checked: bootstrap, onChange: () => setBootstrap(!bootstrap), name: "bootstrap", color: "primary" }), label: "Bootstrap" }),
                    react_1.default.createElement("br", null),
                    react_1.default.createElement(core_1.FormControlLabel, { control: react_1.default.createElement(core_1.Switch, { checked: bestEfforts, onChange: () => setBestEfforts(!bestEfforts), name: "bestEfforts", color: "primary" }), label: "Best Efforts" })),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 6 },
                    react_1.default.createElement(core_1.FormControl, { fullWidth: true },
                        react_1.default.createElement(core_1.InputLabel, { htmlFor: "my-input" }, "Minimum Available Replicas"),
                        react_1.default.createElement(core_1.Input, { id: "my-input", type: "number", value: minAvailableReplicas, onChange: (e) => setMinAvailableReplicas(e.target.value) }))))
            :
                react_1.default.createElement(react_1.default.Fragment, null,
                    react_1.default.createElement(core_1.DialogContentText, null, "Operation Status:"),
                    react_1.default.createElement(CustomCodemirror_1.default, { data: rebalanceResponse, isEditable: false })))));
}
exports.default = RebalanceServerTableOp;


/***/ }),

/***/ "./app/components/Homepage/Operations/ReloadStatusOp.tsx":
/*!***************************************************************!*\
  !*** ./app/components/Homepage/Operations/ReloadStatusOp.tsx ***!
  \***************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const CustomDialog_1 = __importDefault(__webpack_require__(/*! ../../CustomDialog */ "./app/components/CustomDialog.tsx"));
const Close_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/Close */ "./node_modules/@material-ui/icons/Close.js"));
const Check_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/Check */ "./node_modules/@material-ui/icons/Check.js"));
const TabPanel_1 = __importDefault(__webpack_require__(/*! ../../TabPanel */ "./app/components/TabPanel.tsx"));
const moment_1 = __importDefault(__webpack_require__(/*! moment */ "./node_modules/moment/moment.js"));
const CustomDialog_2 = __importDefault(__webpack_require__(/*! ../../CustomDialog */ "./app/components/CustomDialog.tsx"));
const PinotMethodUtils_1 = __importDefault(__webpack_require__(/*! ../../../utils/PinotMethodUtils */ "./app/utils/PinotMethodUtils.ts"));
const CustomCodemirror_1 = __importDefault(__webpack_require__(/*! ../../CustomCodemirror */ "./app/components/CustomCodemirror.tsx"));
const SearchBar_1 = __importDefault(__webpack_require__(/*! ../../SearchBar */ "./app/components/SearchBar.tsx"));
const RemoveCircle_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/RemoveCircle */ "./node_modules/@material-ui/icons/RemoveCircle.js"));
const useStyles = core_1.makeStyles((theme) => core_1.createStyles({
    root: {
        textAlign: 'center'
    },
    container: {
        height: 540,
    },
    greenColor: {
        color: theme.palette.success.main
    },
    redColor: {
        color: theme.palette.error.main
    },
    jobDetailsCodeMirror: {
        '& .CodeMirror': { maxHeight: 400, fontSize: '1rem' },
    },
    jobDetailsLoading: {
        alignSelf: "center"
    },
    yellowColor: {
        color: theme.palette.warning.main
    }
}));
const StyledTableCell = core_1.withStyles((theme) => core_1.createStyles({
    head: {
        backgroundColor: '#ecf3fe',
        color: theme.palette.primary.main,
        fontWeight: 600
    }
}))(core_1.TableCell);
function ReloadStatusOp({ reloadStatusData, tableJobsData, hideModal }) {
    const classes = useStyles();
    const reloadStatusKey = "columnToIndexesCount";
    const indexes = reloadStatusData && reloadStatusData[reloadStatusKey];
    const indexesKeys = indexes && Object.keys(indexes);
    const indexObjKeys = indexes && indexes[indexesKeys[0]] && Object.keys(indexes[indexesKeys[0]]) || [];
    const [activeTab, setActiveTab] = react_1.useState(0);
    const [segmentJobsTableData, setSegmentJobsTableData] = react_1.useState({ records: [], columns: [] });
    const [filteredSegmentJobsTableData, setFilteredSegmentJobsTableData] = react_1.useState({ records: [], columns: [] });
    const [jobDetailsDialogOpen, setJobDetailsDialogOpen] = react_1.useState(false);
    const [selectedJobId, setSelectedSegmentJobId] = react_1.useState(null);
    const [segmentJobDetails, setSegmentJobDetails] = react_1.useState(null);
    react_1.useEffect(() => {
        if (!tableJobsData) {
            return;
        }
        const segmentJobsTableData = {
            columns: ["Job Id", "Message Count", "Job Type", "Submitted On"],
            records: Object.values(tableJobsData)
                .sort((a, b) => b.submissionTimeMs - a.submissionTimeMs)
                .map((job) => [
                job.jobId,
                job.messageCount,
                job.jobType,
                moment_1.default(+job.submissionTimeMs).format("MMMM Do YYYY, HH:mm:ss"),
            ]),
        };
        setSegmentJobsTableData(segmentJobsTableData);
        setFilteredSegmentJobsTableData(segmentJobsTableData);
    }, [tableJobsData]);
    react_1.useEffect(() => {
        if (!selectedJobId) {
            return;
        }
        fetchSegmentReloadStatusData(selectedJobId);
    }, [selectedJobId]);
    const fetchSegmentReloadStatusData = (jobId) => __awaiter(this, void 0, void 0, function* () {
        const segmentJobDetails = yield PinotMethodUtils_1.default.fetchSegmentReloadStatus(jobId);
        setSegmentJobDetails(segmentJobDetails);
    });
    const handleSegmentJobIdClick = (id) => {
        if (!id) {
            return;
        }
        setJobDetailsDialogOpen(true);
        setSegmentJobDetails(null);
        setSelectedSegmentJobId(id);
    };
    const handleJobDetailsDialogClose = () => {
        setJobDetailsDialogOpen(false);
        setSelectedSegmentJobId(null);
    };
    const handleActiveTabChange = (_, newIndex) => {
        setActiveTab(newIndex);
    };
    const handleJobIdSearchChange = (e) => {
        const searchText = e.target.value;
        const filteredRecords = segmentJobsTableData.records.filter((record) => {
            return record[0].toLowerCase().includes(searchText.toLowerCase());
        });
        setFilteredSegmentJobsTableData((data) => (Object.assign(Object.assign({}, data), { records: filteredRecords })));
    };
    return (react_1.default.createElement(CustomDialog_1.default, { open: true, handleClose: hideModal, title: "Reload Status", showOkBtn: false, size: 'lg' }, !(reloadStatusData && tableJobsData) ?
        react_1.default.createElement("div", { className: classes.root },
            react_1.default.createElement(core_1.CircularProgress, null))
        :
            react_1.default.createElement(core_1.DialogContent, null,
                react_1.default.createElement(core_1.Paper, { variant: 'outlined' },
                    react_1.default.createElement(core_1.Tabs, { value: activeTab, onChange: handleActiveTabChange, indicatorColor: "primary", textColor: "primary", centered: true },
                        react_1.default.createElement(core_1.Tab, { label: "Jobs" }),
                        react_1.default.createElement(core_1.Tab, { label: "Status" }))),
                react_1.default.createElement(TabPanel_1.default, { value: activeTab, index: 0 },
                    react_1.default.createElement(core_1.TableContainer, { component: core_1.Paper, className: classes.container },
                        react_1.default.createElement(SearchBar_1.default, { placeholder: "Search by job id", onChange: handleJobIdSearchChange }),
                        react_1.default.createElement(core_1.Table, { stickyHeader: true, "aria-label": "sticky table", size: "small" },
                            react_1.default.createElement(core_1.TableHead, null,
                                react_1.default.createElement(core_1.TableRow, null, filteredSegmentJobsTableData.columns.map((o, i) => {
                                    return (react_1.default.createElement(StyledTableCell, { key: i, align: "left" }, o));
                                }))),
                            react_1.default.createElement(core_1.TableBody, null, filteredSegmentJobsTableData.records.map((segmentJob, index) => (react_1.default.createElement(core_1.TableRow, { key: index }, segmentJob.map((data, idx) => {
                                if (idx === 0) {
                                    return (react_1.default.createElement(StyledTableCell, { align: "left", key: idx },
                                        react_1.default.createElement(core_1.Link, { underline: 'always', component: "button", variant: "body2", onClick: () => handleSegmentJobIdClick(data) }, data)));
                                }
                                return (react_1.default.createElement(StyledTableCell, { align: "left", key: idx }, data));
                            })))))))),
                react_1.default.createElement(TabPanel_1.default, { value: activeTab, index: 1 }, indexes && indexesKeys && indexObjKeys ?
                    react_1.default.createElement(core_1.TableContainer, { component: core_1.Paper, className: classes.container },
                        react_1.default.createElement(core_1.Table, { stickyHeader: true, "aria-label": "sticky table", size: "small" },
                            react_1.default.createElement(core_1.TableHead, null,
                                react_1.default.createElement(core_1.TableRow, null,
                                    react_1.default.createElement(StyledTableCell, null),
                                    indexObjKeys.map((o, i) => {
                                        return (react_1.default.createElement(StyledTableCell, { key: i, align: "right" }, o));
                                    }))),
                            react_1.default.createElement(core_1.TableBody, null, indexesKeys.map((indexName, i) => {
                                const indexObj = indexes[indexName];
                                return (react_1.default.createElement(core_1.TableRow, { key: i },
                                    react_1.default.createElement(StyledTableCell, { component: "th", scope: "row" }, indexName),
                                    indexObjKeys.map((o, i) => {
                                        let iconElement = null;
                                        if (indexObj[o] === 0) {
                                            iconElement = react_1.default.createElement(Close_1.default, { className: classes.redColor });
                                        }
                                        else if (indexObj[o] === (reloadStatusData === null || reloadStatusData === void 0 ? void 0 : reloadStatusData["totalOnlineSegments"])) {
                                            iconElement = react_1.default.createElement(Check_1.default, { className: classes.greenColor });
                                        }
                                        else {
                                            const tooltipText = `Index present in ${indexObj[o]} / ${reloadStatusData === null || reloadStatusData === void 0 ? void 0 : reloadStatusData["totalOnlineSegments"]} segments`;
                                            iconElement = react_1.default.createElement(core_1.Tooltip, { placement: 'top', title: tooltipText },
                                                react_1.default.createElement(RemoveCircle_1.default, { className: classes.yellowColor }));
                                        }
                                        return (react_1.default.createElement(StyledTableCell, { align: "center", key: i }, iconElement));
                                    })));
                            }))))
                    :
                        react_1.default.createElement(core_1.DialogContentText, null, "No reload status found in table.")),
                react_1.default.createElement(CustomDialog_2.default, { showOkBtn: false, title: "Segment Job Details", open: jobDetailsDialogOpen, handleClose: handleJobDetailsDialogClose }, segmentJobDetails ? (react_1.default.createElement(CustomCodemirror_1.default, { customClass: classes.jobDetailsCodeMirror, data: segmentJobDetails, isEditable: false })) : (react_1.default.createElement(core_1.CircularProgress, { className: classes.jobDetailsLoading }))))));
}
exports.default = ReloadStatusOp;


/***/ }),

/***/ "./app/components/Homepage/Operations/SchemaComponent.tsx":
/*!****************************************************************!*\
  !*** ./app/components/Homepage/Operations/SchemaComponent.tsx ***!
  \****************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const Add_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/Add */ "./node_modules/@material-ui/icons/Add.js"));
const Clear_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/Clear */ "./node_modules/@material-ui/icons/Clear.js"));
const lab_1 = __webpack_require__(/*! @material-ui/lab */ "./node_modules/@material-ui/lab/esm/index.js");
const useStyles = core_1.makeStyles((theme) => core_1.createStyles({
    rootContainer: {
        padding: '0 15px 15px'
    },
    iconDiv: {
        marginLeft: 'auto'
    },
    dateTimeDiv: {
        marginLeft: '20px',
        paddingLeft: '20px',
        borderLeft: '1px #ccc solid'
    },
    gridItem: {
        display: 'flex',
        alignItems: 'center',
        marginTop: '15px',
        padding: '5px',
        border: '1px #ccc solid',
        borderRadius: 5
    },
    formControl: {
        margin: theme.spacing(1),
        minWidth: 120,
    },
    selectFormControl: {
        margin: theme.spacing(1),
        width: 220
    },
    MVFFormControl: {
        margin: theme.spacing(1),
        width: 126
    },
    autoCompleteControl: {
        '& .MuiFormControl-marginNormal': {
            marginTop: 0
        }
    },
    greenColor: {
        color: theme.palette.success.main
    },
    redColor: {
        color: theme.palette.error.main
    },
}));
function SchemaComponent({ schemaName = '', setSchemaObj, schemaObj, }) {
    const classes = useStyles();
    const defaultOptionalColumnObj = {
        multiValue: 'false',
        maxLength: '',
        virtualColumnProvider: '',
        defaultNullValue: '',
        timeUnit: '',
        timeFormat: '',
        timePattern: '',
        granularityUnit: '',
        granularityInterval: ''
    };
    const defaultColumnObj = Object.assign({ columnName: '', type: '', dataType: '' }, defaultOptionalColumnObj);
    const defaultSchemaObj = {
        schemaName,
        dimensionFieldSpecs: [],
        metricFieldSpecs: [],
        dateTimeFieldSpecs: []
    };
    const defaultDataTypeOptions = {
        dimension: ["INT", "LONG", "STRING", "FLOAT", "DOUBLE", "BYTES", "BOOLEAN", "JSON"],
        metric: ["INT", "LONG", "DOUBLE", "FLOAT", "BYTES"],
        datetime: ["STRING", "INT", "LONG", "TIMESTAMP"]
    };
    const preFilledData = {
        dimension: {
            dataType: "STRING",
            multiValue: "false"
        },
        metric: {
            dataType: "LONG"
        },
        datetime: {
            dataType: "LONG",
            timeUnit: "MILLISECONDS",
            timeFormat: "EPOCH",
            granularityInterval: "1",
            granularityUnit: "MILLISECONDS"
        },
    };
    const [columnList, setColumnList] = react_1.useState([Object.assign({}, defaultColumnObj)]);
    const setPreFilledData = (index, fieldName, value, colList) => {
        switch (fieldName) {
            case "type": {
                colList[index] = Object.assign(Object.assign(Object.assign({}, colList[index]), defaultOptionalColumnObj), preFilledData[value]);
                break;
            }
        }
    };
    const changeHandler = (index, fieldName, value) => {
        let newColumnList = [...columnList];
        newColumnList[index][fieldName] = value;
        setPreFilledData(index, fieldName, value, newColumnList);
        setColumnList(newColumnList);
    };
    react_1.useEffect(() => {
        let newSchemaObj = Object.assign({}, defaultSchemaObj);
        newSchemaObj.schemaName = schemaName;
        columnList.map((columnObj) => {
            const { columnName, dataType, defaultNullValue, multiValue, maxLength, virtualColumnProvider, timeUnit, timeFormat, timePattern, granularityUnit, granularityInterval } = columnObj;
            let schemaColumnnObj = {
                name: columnName,
                dataType: dataType,
                format: undefined,
                granularity: undefined,
                defaultNullValue: defaultNullValue !== '' ? defaultNullValue : undefined,
                maxLength: maxLength !== '' ? parseInt(maxLength, 10) : undefined,
                virtualColumnProvider: virtualColumnProvider !== '' ? (virtualColumnProvider === 'true') : undefined,
                singleValueField: undefined
            };
            switch (columnObj.type) {
                case 'dimension':
                    schemaColumnnObj.singleValueField = multiValue === 'true' ? false : undefined;
                    newSchemaObj.dimensionFieldSpecs.push(schemaColumnnObj);
                    break;
                case 'metric':
                    newSchemaObj.metricFieldSpecs.push(schemaColumnnObj);
                    break;
                case 'datetime':
                    if (timeUnit && timeFormat) {
                        schemaColumnnObj.format = `1:${timeUnit}:${timeFormat}${timeFormat !== 'EPOCH' ? `:${timePattern}` : ''}`;
                    }
                    if (granularityUnit && granularityInterval) {
                        schemaColumnnObj.granularity = `${granularityInterval}:${granularityUnit}`;
                    }
                    newSchemaObj.dateTimeFieldSpecs.push(schemaColumnnObj);
                    break;
            }
            ;
        });
        setTimeout(() => { setSchemaObj(newSchemaObj); }, 0);
    }, [columnList]);
    const addNewColumn = () => {
        let newColumnList = [...columnList];
        newColumnList.push(Object.assign({}, defaultColumnObj));
        setColumnList(newColumnList);
    };
    const deleteColumn = (index) => {
        let newColumnList = [...columnList];
        newColumnList.splice(index, 1);
        setColumnList(newColumnList);
    };
    const schemaNameChange = (schemaName) => {
        let newSchemaObj = Object.assign({}, schemaObj);
        newSchemaObj.schemaName = schemaName;
        setSchemaObj(newSchemaObj);
    };
    const requiredAstrix = react_1.default.createElement("span", { className: classes.redColor }, "*");
    return (react_1.default.createElement(core_1.Grid, { container: true, className: classes.rootContainer },
        react_1.default.createElement(core_1.Grid, { item: true, xs: 12, key: "schemaName" },
            react_1.default.createElement(core_1.FormControl, { className: classes.formControl },
                react_1.default.createElement(core_1.InputLabel, { htmlFor: "schemaName" },
                    "Schema Name ",
                    requiredAstrix),
                react_1.default.createElement(core_1.Input, { id: "schemaName", value: schemaName, onChange: (e) => schemaNameChange(e.target.value) }))),
        columnList.map((columnObj, index) => {
            return (react_1.default.createElement(core_1.Grid, { item: true, xs: 12, key: index, className: classes.gridItem },
                react_1.default.createElement("div", null,
                    react_1.default.createElement(core_1.FormControl, { className: classes.formControl },
                        react_1.default.createElement(core_1.InputLabel, { htmlFor: "columnName" },
                            "Column Name ",
                            requiredAstrix),
                        react_1.default.createElement(core_1.Input, { id: "columnName", value: columnObj.columnName, onChange: (e) => changeHandler(index, 'columnName', e.target.value) })),
                    react_1.default.createElement(core_1.FormControl, { className: classes.formControl },
                        react_1.default.createElement(core_1.InputLabel, { htmlFor: "type" },
                            "Type ",
                            requiredAstrix),
                        react_1.default.createElement(core_1.Select, { labelId: "type", id: "type", value: columnObj.type, onChange: (e) => changeHandler(index, 'type', e.target.value) },
                            react_1.default.createElement(core_1.MenuItem, { value: "dimension" }, "Dimension"),
                            react_1.default.createElement(core_1.MenuItem, { value: "metric" }, "Metric"),
                            react_1.default.createElement(core_1.MenuItem, { value: "datetime" }, "DateTime"))),
                    react_1.default.createElement(core_1.FormControl, { className: classes.formControl, disabled: !columnObj.type },
                        react_1.default.createElement(core_1.InputLabel, { htmlFor: "dataType" },
                            "Data Type ",
                            requiredAstrix),
                        react_1.default.createElement(core_1.Select, { labelId: "dataType", id: "dataType", value: columnObj.dataType, onChange: (e) => changeHandler(index, 'dataType', e.target.value) }, defaultDataTypeOptions[columnObj.type || 'dimension'].map((dataType, i) => (react_1.default.createElement(core_1.MenuItem, { key: i, value: dataType }, dataType))))),
                    columnObj.type === 'dimension' &&
                        react_1.default.createElement(core_1.FormControl, { className: classes.MVFFormControl },
                            react_1.default.createElement(core_1.InputLabel, { htmlFor: "multiValue" }, "Multi Value Field"),
                            react_1.default.createElement(core_1.Select, { labelId: "multiValue", id: "multiValue", value: columnObj.multiValue, onChange: (e) => changeHandler(index, 'multiValue', e.target.value) },
                                react_1.default.createElement(core_1.MenuItem, { value: "true" }, "True"),
                                react_1.default.createElement(core_1.MenuItem, { value: "false" }, "False"))),
                    columnObj.type !== 'datetime' &&
                        react_1.default.createElement(react_1.default.Fragment, null,
                            react_1.default.createElement(core_1.FormControl, { className: classes.formControl },
                                react_1.default.createElement(core_1.InputLabel, { htmlFor: "maxLength" }, "Max Value Length"),
                                react_1.default.createElement(core_1.Input, { id: "maxLength", type: "number", value: columnObj.maxLength, onChange: (e) => changeHandler(index, 'maxLength', e.target.value) })),
                            react_1.default.createElement(core_1.FormControl, { className: classes.selectFormControl },
                                react_1.default.createElement(lab_1.Autocomplete, { className: classes.autoCompleteControl, options: ["True", "False"], onChange: (e, value) => changeHandler(index, 'virtualColumnProvider', value ? value.toLowerCase() : ""), renderInput: (params) => (react_1.default.createElement(core_1.TextField, Object.assign({}, params, { label: "Virtual Column", margin: "normal" }))) }))),
                    react_1.default.createElement("br", null),
                    columnObj.type === 'datetime' &&
                        react_1.default.createElement("div", null,
                            react_1.default.createElement(core_1.FormControl, { className: classes.formControl },
                                react_1.default.createElement(core_1.InputLabel, { htmlFor: "timeUnit" },
                                    "Time Unit ",
                                    requiredAstrix),
                                react_1.default.createElement(core_1.Select, { labelId: "timeUnit", id: "timeUnit", value: columnObj.timeUnit, onChange: (e) => changeHandler(index, 'timeUnit', e.target.value) },
                                    react_1.default.createElement(core_1.MenuItem, { value: "MILLISECONDS" }, "MILLISECONDS"),
                                    react_1.default.createElement(core_1.MenuItem, { value: "SECONDS" }, "SECONDS"),
                                    react_1.default.createElement(core_1.MenuItem, { value: "MINUTES" }, "MINUTES"),
                                    react_1.default.createElement(core_1.MenuItem, { value: "HOURS" }, "HOURS"),
                                    react_1.default.createElement(core_1.MenuItem, { value: "DAYS" }, "DAYS"))),
                            react_1.default.createElement(core_1.FormControl, { className: classes.formControl },
                                react_1.default.createElement(core_1.InputLabel, { htmlFor: "timeFormat" },
                                    "Time Format ",
                                    requiredAstrix),
                                react_1.default.createElement(core_1.Select, { labelId: "timeFormat", id: "timeFormat", value: columnObj.timeFormat, onChange: (e) => changeHandler(index, 'timeFormat', e.target.value) },
                                    react_1.default.createElement(core_1.MenuItem, { value: "EPOCH" }, "EPOCH"),
                                    react_1.default.createElement(core_1.MenuItem, { value: "SIMPLE_DATE_FORMAT" }, "SIMPLE_DATE_FORMAT"))),
                            columnObj.timeFormat === 'SIMPLE_DATE_FORMAT' &&
                                react_1.default.createElement(core_1.FormControl, { className: classes.formControl },
                                    react_1.default.createElement(core_1.InputLabel, { htmlFor: "timePattern" },
                                        "Time Pattern ",
                                        requiredAstrix),
                                    react_1.default.createElement(core_1.Input, { id: "timePattern", value: columnObj.timePattern, onChange: (e) => changeHandler(index, 'timePattern', e.target.value) })),
                            react_1.default.createElement(core_1.FormControl, { className: classes.formControl },
                                react_1.default.createElement(core_1.InputLabel, { htmlFor: "granularityInterval" },
                                    "Granularity Interval ",
                                    requiredAstrix),
                                react_1.default.createElement(core_1.Input, { id: "granularityInterval", value: columnObj.granularityInterval, onChange: (e) => changeHandler(index, 'granularityInterval', e.target.value) })),
                            react_1.default.createElement(core_1.FormControl, { className: classes.selectFormControl },
                                react_1.default.createElement(core_1.InputLabel, { htmlFor: "granularityUnit" },
                                    "Granularity Unit ",
                                    requiredAstrix),
                                react_1.default.createElement(core_1.Select, { labelId: "granularityUnit", id: "granularityUnit", value: columnObj.granularityUnit, onChange: (e) => changeHandler(index, 'granularityUnit', e.target.value) },
                                    react_1.default.createElement(core_1.MenuItem, { value: "MILLISECONDS" }, "MILLISECONDS"),
                                    react_1.default.createElement(core_1.MenuItem, { value: "SECONDS" }, "SECONDS"),
                                    react_1.default.createElement(core_1.MenuItem, { value: "MINUTES" }, "MINUTES"),
                                    react_1.default.createElement(core_1.MenuItem, { value: "HOURS" }, "HOURS"),
                                    react_1.default.createElement(core_1.MenuItem, { value: "DAYS" }, "DAYS"))))),
                react_1.default.createElement("div", { className: classes.iconDiv },
                    react_1.default.createElement(core_1.FormControl, null,
                        react_1.default.createElement(core_1.IconButton, { "aria-label": "plus", onClick: addNewColumn },
                            react_1.default.createElement(Add_1.default, { className: classes.greenColor }))),
                    columnList.length >= 2 && react_1.default.createElement(core_1.FormControl, null,
                        react_1.default.createElement(core_1.IconButton, { "aria-label": "clear", onClick: () => deleteColumn(index) },
                            react_1.default.createElement(Clear_1.default, { className: classes.redColor }))))));
        })));
}
exports.default = SchemaComponent;


/***/ }),

/***/ "./app/components/Homepage/TenantsListing.tsx":
/*!****************************************************!*\
  !*** ./app/components/Homepage/TenantsListing.tsx ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const Table_1 = __importDefault(__webpack_require__(/*! ../Table */ "./app/components/Table.tsx"));
const Loading_1 = __importDefault(__webpack_require__(/*! ../Loading */ "./app/components/Loading.tsx"));
const requests_1 = __webpack_require__(/*! ../../requests */ "./app/requests/index.ts");
const PinotMethodUtils_1 = __importDefault(__webpack_require__(/*! ../../utils/PinotMethodUtils */ "./app/utils/PinotMethodUtils.ts"));
const TenantsTable = () => {
    const columns = ['Tenant Name', 'Server', 'Broker', 'Tables'];
    const [tenantsData, setTenantsData] = react_1.useState({
        records: [columns.map((_) => Loading_1.default)],
        columns: columns,
    });
    const fetchData = () => __awaiter(void 0, void 0, void 0, function* () {
        requests_1.getTenants().then((res) => {
            const tenantNames = lodash_1.union(res.data.SERVER_TENANTS, res.data.BROKER_TENANTS);
            setTenantsData({
                columns: columns,
                records: tenantNames.map((tenantName) => {
                    return [tenantName, Loading_1.default, Loading_1.default, Loading_1.default];
                }),
            });
            tenantNames.forEach((tenantName) => {
                Promise.all([
                    PinotMethodUtils_1.default.getServerOfTenant(tenantName).then((res) => {
                        return (res === null || res === void 0 ? void 0 : res.length) || 0;
                    }),
                    PinotMethodUtils_1.default.getBrokerOfTenant(tenantName).then((res) => {
                        return Array.isArray(res) ? (res === null || res === void 0 ? void 0 : res.length) || 0 : 0;
                    }),
                    requests_1.getTenantTable(tenantName).then((res) => {
                        var _a, _b;
                        return ((_b = (_a = res === null || res === void 0 ? void 0 : res.data) === null || _a === void 0 ? void 0 : _a.tables) === null || _b === void 0 ? void 0 : _b.length) || 0;
                    }),
                ]).then((res) => {
                    const numServers = res[0];
                    const numBrokers = res[1];
                    const numTables = res[2];
                    setTenantsData((prev) => {
                        const newRecords = prev.records.map((record) => {
                            if (record[0] === tenantName) {
                                return [tenantName, numServers, numBrokers, numTables];
                            }
                            return record;
                        });
                        return {
                            columns: prev.columns,
                            records: newRecords,
                        };
                    });
                });
            });
        });
    });
    react_1.useEffect(() => {
        fetchData();
    }, []);
    return (react_1.default.createElement(Table_1.default, { title: "Tenants", data: tenantsData, addLinks: true, baseURL: "/tenants/", showSearchBox: true, inAccordionFormat: true }));
};
exports.default = TenantsTable;


/***/ }),

/***/ "./app/components/Homepage/useTaskTypesTable.tsx":
/*!*******************************************************!*\
  !*** ./app/components/Homepage/useTaskTypesTable.tsx ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const Table_1 = __importDefault(__webpack_require__(/*! ../Table */ "./app/components/Table.tsx"));
const PinotMethodUtils_1 = __importDefault(__webpack_require__(/*! ../../utils/PinotMethodUtils */ "./app/utils/PinotMethodUtils.ts"));
const useTaskTypesTable = () => {
    const [fetching, setFetching] = react_1.useState(true);
    const [taskTypes, setTaskTypes] = react_1.useState({ records: [], columns: [] });
    const fetchData = () => __awaiter(void 0, void 0, void 0, function* () {
        setFetching(true);
        const taskTypesRes = yield PinotMethodUtils_1.default.getAllTaskTypes();
        setTaskTypes(taskTypesRes);
        setFetching(false);
    });
    react_1.useEffect(() => {
        fetchData();
    }, []);
    return {
        taskTypes,
        taskTypesTable: !fetching && (react_1.default.createElement(Table_1.default, { title: "Task Queues", data: taskTypes, showSearchBox: true, inAccordionFormat: true, addLinks: true, baseURL: '/task-queue/' }))
    };
};
exports.default = useTaskTypesTable;


/***/ }),

/***/ "./app/components/Layout.tsx":
/*!***********************************!*\
  !*** ./app/components/Layout.tsx ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const React = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const SideBar_1 = __importDefault(__webpack_require__(/*! ./SideBar */ "./app/components/SideBar.tsx"));
const Header_1 = __importDefault(__webpack_require__(/*! ./Header */ "./app/components/Header.tsx"));
const QueryConsoleIcon_1 = __importDefault(__webpack_require__(/*! ./SvgIcons/QueryConsoleIcon */ "./app/components/SvgIcons/QueryConsoleIcon.tsx"));
const SwaggerIcon_1 = __importDefault(__webpack_require__(/*! ./SvgIcons/SwaggerIcon */ "./app/components/SvgIcons/SwaggerIcon.tsx"));
const ClusterManagerIcon_1 = __importDefault(__webpack_require__(/*! ./SvgIcons/ClusterManagerIcon */ "./app/components/SvgIcons/ClusterManagerIcon.tsx"));
const ZookeeperIcon_1 = __importDefault(__webpack_require__(/*! ./SvgIcons/ZookeeperIcon */ "./app/components/SvgIcons/ZookeeperIcon.tsx"));
const app_state_1 = __importDefault(__webpack_require__(/*! ../app_state */ "./app/app_state.ts"));
const AccountCircleOutlined_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/AccountCircleOutlined */ "./node_modules/@material-ui/icons/AccountCircleOutlined.js"));
let navigationItems = [
    { id: 1, name: 'Cluster Manager', link: '/', icon: React.createElement(ClusterManagerIcon_1.default, null) },
    { id: 2, name: 'Query Console', link: '/query', icon: React.createElement(QueryConsoleIcon_1.default, null) },
    { id: 3, name: 'Zookeeper Browser', link: '/zookeeper', icon: React.createElement(ZookeeperIcon_1.default, null) },
    { id: 4, name: 'Swagger REST API', link: 'help', target: '_blank', icon: React.createElement(SwaggerIcon_1.default, null) }
];
const Layout = (props) => {
    const role = props.role;
    if (role === 'ADMIN') {
        if (navigationItems.length < 5) {
            navigationItems = [
                ...navigationItems,
                { id: 5, name: "User Console", link: '/user', icon: React.createElement(AccountCircleOutlined_1.default, { style: { width: 24, height: 24, verticalAlign: 'sub' } }) }
            ];
        }
    }
    const hash = `/${window.location.hash.split('/')[1]}`;
    const routeObj = navigationItems.find((obj) => { return obj.link === hash; });
    const [selectedId, setSelectedId] = React.useState((routeObj === null || routeObj === void 0 ? void 0 : routeObj.id) || 1);
    const sidebarOpenState = !(localStorage.getItem('pinot_ui:sidebarState') === 'false');
    const [openSidebar, setOpenSidebar] = React.useState(sidebarOpenState);
    const appNavigationItems = React.useMemo(() => {
        if (app_state_1.default.queryConsoleOnlyView) {
            return navigationItems.filter((navItem) => navItem.link === '/query');
        }
        if (app_state_1.default.hideQueryConsoleTab) {
            return navigationItems.filter((navItem) => navItem.link !== '/query');
        }
        return navigationItems;
    }, [navigationItems, app_state_1.default.queryConsoleOnlyView, app_state_1.default.hideQueryConsoleTab]);
    const highlightSidebarLink = (id) => {
        setSelectedId(id);
    };
    const showHideSideBarHandler = () => {
        const newSidebarState = !openSidebar;
        localStorage.setItem('pinot_ui:sidebarState', newSidebarState.toString());
        setOpenSidebar(newSidebarState);
    };
    return (React.createElement(core_1.Grid, { container: true, direction: "column" },
        React.createElement(Header_1.default, Object.assign({ highlightSidebarLink: highlightSidebarLink, showHideSideBarHandler: showHideSideBarHandler, openSidebar: openSidebar }, props)),
        React.createElement(core_1.Grid, { item: true, xs: 12 },
            React.createElement(core_1.Grid, { container: true },
                React.createElement(core_1.Grid, { item: true },
                    React.createElement(SideBar_1.default, { list: appNavigationItems, showMenu: openSidebar, selectedId: selectedId, highlightSidebarLink: highlightSidebarLink })),
                props.children))));
};
exports.default = Layout;


/***/ }),

/***/ "./app/components/Loading.tsx":
/*!************************************!*\
  !*** ./app/components/Loading.tsx ***!
  \************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const Skeleton_1 = __importDefault(__webpack_require__(/*! @material-ui/lab/Skeleton */ "./node_modules/@material-ui/lab/esm/Skeleton/index.js"));
const Loading = { customRenderer: react_1.default.createElement(Skeleton_1.default, { animation: 'wave' }) };
exports.default = Loading;


/***/ }),

/***/ "./app/components/MaterialTree.tsx":
/*!*****************************************!*\
  !*** ./app/components/MaterialTree.tsx ***!
  \*****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const styles_1 = __webpack_require__(/*! @material-ui/core/styles */ "./node_modules/@material-ui/core/esm/styles/index.js");
const TreeView_1 = __importDefault(__webpack_require__(/*! @material-ui/lab/TreeView */ "./node_modules/@material-ui/lab/esm/TreeView/index.js"));
const TreeItem_1 = __importDefault(__webpack_require__(/*! @material-ui/lab/TreeItem */ "./node_modules/@material-ui/lab/esm/TreeItem/index.js"));
const Collapse_1 = __importDefault(__webpack_require__(/*! @material-ui/core/Collapse */ "./node_modules/@material-ui/core/esm/Collapse/index.js"));
const web_cjs_1 = __webpack_require__(/*! react-spring/web.cjs */ "./node_modules/react-spring/web.cjs.js"); // web.cjs is required for IE 11 support
const AddCircleOutlineOutlined_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/AddCircleOutlineOutlined */ "./node_modules/@material-ui/icons/AddCircleOutlineOutlined.js"));
const RemoveCircleOutlineOutlined_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/RemoveCircleOutlineOutlined */ "./node_modules/@material-ui/icons/RemoveCircleOutlineOutlined.js"));
const DescriptionOutlined_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/DescriptionOutlined */ "./node_modules/@material-ui/icons/DescriptionOutlined.js"));
function TransitionComponent(props) {
    const style = web_cjs_1.useSpring({
        from: { opacity: 0, transform: 'translate3d(20px,0,0)' },
        to: { opacity: props.in ? 1 : 0, transform: `translate3d(${props.in ? 0 : 20}px,0,0)` },
    });
    return (react_1.default.createElement(web_cjs_1.animated.div, { style: style },
        react_1.default.createElement(Collapse_1.default, Object.assign({}, props))));
}
const StyledTreeItem = styles_1.withStyles((theme) => styles_1.createStyles({
    iconContainer: {
        '& .close': {
            opacity: 0.3,
        },
    },
    group: {
        marginLeft: 7,
        paddingLeft: 18,
        borderLeft: `1px dashed ${styles_1.fade(theme.palette.text.primary, 0.4)}`,
    },
}))((props) => react_1.default.createElement(TreeItem_1.default, Object.assign({}, props, { TransitionComponent: TransitionComponent })));
const useStyles = styles_1.makeStyles(styles_1.createStyles({
    root: {
        flexGrow: 1,
    },
}));
const CustomTreeItem = ({ itemObj, showChildEvent }) => {
    const nestedComments = (itemObj.child || []).map(item => {
        return react_1.default.createElement(CustomTreeItem, { key: item.nodeId, itemObj: item, showChildEvent: showChildEvent });
    });
    return (react_1.default.createElement(StyledTreeItem, { nodeId: itemObj.nodeId, label: itemObj.label, endIcon: itemObj.isLeafNode ? react_1.default.createElement(DescriptionOutlined_1.default, null) : react_1.default.createElement(AddCircleOutlineOutlined_1.default, null), onClick: (e) => {
            showChildEvent(itemObj);
        } }, nestedComments));
};
function CustomizedTreeView({ treeData, showChildEvent, expanded, selected, handleToggle, handleSelect }) {
    const classes = useStyles();
    return (react_1.default.createElement(TreeView_1.default, { className: classes.root, defaultExpanded: ['1'], expanded: expanded, selected: selected, onNodeToggle: handleToggle, onNodeSelect: handleSelect, defaultCollapseIcon: react_1.default.createElement(RemoveCircleOutlineOutlined_1.default, null), defaultExpandIcon: react_1.default.createElement(AddCircleOutlineOutlined_1.default, null), defaultEndIcon: react_1.default.createElement(DescriptionOutlined_1.default, null) }, treeData.map((itemObj) => {
        return (react_1.default.createElement(CustomTreeItem, { key: `parent_${itemObj.nodeId}`, itemObj: itemObj, showChildEvent: showChildEvent }));
    })));
}
exports.default = CustomizedTreeView;


/***/ }),

/***/ "./app/components/NotFound.tsx":
/*!*************************************!*\
  !*** ./app/components/NotFound.tsx ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const TableToolbar_1 = __importDefault(__webpack_require__(/*! ./TableToolbar */ "./app/components/TableToolbar.tsx"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const styles_1 = __webpack_require__(/*! @material-ui/core/styles */ "./node_modules/@material-ui/core/esm/styles/index.js");
const useStyles = styles_1.makeStyles((theme) => ({
    root: {
        border: '1px #BDCCD9 solid',
        borderRadius: 4,
        marginBottom: '20px',
    },
    background: {
        padding: 20,
        backgroundColor: 'white',
        maxHeight: 'calc(100vh - 70px)',
        overflowY: 'auto',
    },
    highlightBackground: {
        border: '1px #4285f4 solid',
        backgroundColor: 'rgba(66, 133, 244, 0.05)',
        borderRadius: 4,
        marginBottom: '20px',
    },
    body: {
        borderTop: '1px solid #BDCCD9',
        fontSize: '16px',
        lineHeight: '3rem',
        paddingLeft: '15px',
    },
}));
function NotFound(props) {
    const classes = useStyles();
    return (react_1.default.createElement(core_1.Grid, { item: true, xs: true, className: classes.background },
        react_1.default.createElement("div", { className: classes.highlightBackground },
            react_1.default.createElement(TableToolbar_1.default, { name: "Not found", showSearchBox: false }),
            react_1.default.createElement(core_1.Grid, { container: true, className: classes.body },
                react_1.default.createElement(core_1.Grid, { item: true },
                    react_1.default.createElement("p", null, props.message))))));
}
exports.default = NotFound;


/***/ }),

/***/ "./app/components/Notification/NotificationContext.tsx":
/*!*************************************************************!*\
  !*** ./app/components/Notification/NotificationContext.tsx ***!
  \*************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const React = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
exports.NotificationContext = React.createContext(null);


/***/ }),

/***/ "./app/components/Notification/NotificationContextProvider.tsx":
/*!*********************************************************************!*\
  !*** ./app/components/Notification/NotificationContextProvider.tsx ***!
  \*********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const React = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const NotificationContext_1 = __webpack_require__(/*! ./NotificationContext */ "./app/components/Notification/NotificationContext.tsx");
const react_1 = __webpack_require__(/*! react */ "./node_modules/react/index.js");
const NotificationContextValue = {
    type: "",
    message: "",
    show: false,
    hide: () => { }
};
const notificationReducer = (state) => {
    return state;
};
const mainReducer = ({ type, message, show, hide }, action) => ({
    type: notificationReducer(action.type),
    message: notificationReducer(action.message),
    show: notificationReducer(action.show),
    hide: notificationReducer(action.hide)
});
const NotificationContextProvider = (props) => {
    const [state, dispatch] = react_1.useReducer(mainReducer, NotificationContextValue);
    return (React.createElement(NotificationContext_1.NotificationContext.Provider, { value: Object.assign(Object.assign({}, state), { dispatch }) }, props.children));
};
exports.NotificationContextProvider = NotificationContextProvider;


/***/ }),

/***/ "./app/components/Query/QuerySideBar.tsx":
/*!***********************************************!*\
  !*** ./app/components/Query/QuerySideBar.tsx ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const React = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const styles_1 = __webpack_require__(/*! @material-ui/core/styles */ "./node_modules/@material-ui/core/esm/styles/index.js");
const Drawer_1 = __importDefault(__webpack_require__(/*! @material-ui/core/Drawer */ "./node_modules/@material-ui/core/esm/Drawer/index.js"));
const CssBaseline_1 = __importDefault(__webpack_require__(/*! @material-ui/core/CssBaseline */ "./node_modules/@material-ui/core/esm/CssBaseline/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const Table_1 = __importDefault(__webpack_require__(/*! ../Table */ "./app/components/Table.tsx"));
const drawerWidth = 300;
const useStyles = styles_1.makeStyles((theme) => styles_1.createStyles({
    root: {
        display: 'flex',
    },
    appBar: {
        zIndex: theme.zIndex.drawer + 1,
    },
    drawer: {
        width: drawerWidth,
        height: 'calc(100vh - 70px)',
        flexShrink: 0,
        backgroundColor: '#333333',
    },
    drawerPaper: {
        position: 'unset',
        width: drawerWidth,
    },
    drawerContainer: {
        overflow: 'auto',
        paddingTop: '20px'
    },
    content: {
        flexGrow: 1,
        padding: theme.spacing(3),
    },
    itemContainer: {
        color: '#3B454E',
        borderRadius: '4px'
    },
    selectedItem: {
        background: '#D8E1E8!important'
    },
    link: {
        textDecoration: 'none'
    },
    leftPanel: {
        width: 300,
        padding: '0 20px',
        wordBreak: 'break-all',
    },
}));
const Sidebar = ({ tableList, fetchSQLData, tableSchema, selectedTable, queryLoader }) => {
    const classes = useStyles();
    return (React.createElement(React.Fragment, null,
        React.createElement(CssBaseline_1.default, null),
        React.createElement(Drawer_1.default, { open: false, className: classes.drawer, variant: "permanent", classes: {
                paper: classes.drawerPaper,
            } },
            React.createElement("div", { className: classes.drawerContainer },
                React.createElement(core_1.Grid, { item: true, xs: true, className: classes.leftPanel },
                    React.createElement(Table_1.default, { title: "Tables", data: tableList, cellClickCallback: fetchSQLData, isCellClickable: true, showSearchBox: true, inAccordionFormat: true }),
                    !queryLoader && tableSchema.records.length ? (React.createElement(Table_1.default, { title: `${selectedTable} schema`, data: tableSchema, highlightBackground: true, showSearchBox: true, inAccordionFormat: true })) : null)))));
};
exports.default = Sidebar;


/***/ }),

/***/ "./app/components/SearchBar.tsx":
/*!**************************************!*\
  !*** ./app/components/SearchBar.tsx ***!
  \**************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const makeStyles_1 = __importDefault(__webpack_require__(/*! @material-ui/core/styles/makeStyles */ "./node_modules/@material-ui/core/styles/makeStyles.js"));
const Search_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/Search */ "./node_modules/@material-ui/icons/Search.js"));
const InputBase_1 = __importDefault(__webpack_require__(/*! @material-ui/core/InputBase */ "./node_modules/@material-ui/core/esm/InputBase/index.js"));
// TODO: Remove unneccessary styles, This styles are from demo of material-ui doc
const useStyles = makeStyles_1.default((theme) => ({
    search: {
        position: 'relative',
        borderRadius: theme.shape.borderRadius,
        width: '100%',
        [theme.breakpoints.up('sm')]: {
            // marginLeft: theme.spacing(3),
            width: 'auto',
        },
    },
    searchOnRight: {
        position: 'relative',
        borderRadius: theme.shape.borderRadius,
        width: '150px',
        marginLeft: 'auto',
    },
    searchIcon: {
        padding: theme.spacing(0, 2),
        height: '100%',
        position: 'absolute',
        pointerEvents: 'none',
        color: '#9DAAB6',
        display: 'flex',
        alignItems: 'center',
        justifyContent: 'center',
    },
    inputRoot: {
        color: 'inherit',
    },
    inputInput: {
        padding: theme.spacing(1, 1, 1, 0),
        // vertical padding + font size from searchIcon
        paddingLeft: `calc(1em + ${theme.spacing(4)}px)`,
        transition: theme.transitions.create('width'),
        width: '100%',
        fontSize: '0.875rem'
    },
}));
const SearchBar = (props) => {
    const classes = useStyles();
    return (react_1.default.createElement("div", { className: props.searchOnRight ? classes.searchOnRight : classes.search },
        react_1.default.createElement("div", { className: classes.searchIcon },
            react_1.default.createElement(Search_1.default, null)),
        react_1.default.createElement(InputBase_1.default, { placeholder: props.placeholder || "Search…", value: props.value, onChange: props.onChange, classes: {
                root: classes.inputRoot,
                input: classes.inputInput,
            }, inputProps: { 'aria-label': 'search' }, fullWidth: true })));
};
exports.default = SearchBar;


/***/ }),

/***/ "./app/components/SegmentStatusRenderer.tsx":
/*!**************************************************!*\
  !*** ./app/components/SegmentStatusRenderer.tsx ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const icons_1 = __webpack_require__(/*! @material-ui/icons */ "./node_modules/@material-ui/icons/esm/index.js");
const requests_1 = __webpack_require__(/*! ../requests */ "./app/requests/index.ts");
const CustomCodemirror_1 = __importDefault(__webpack_require__(/*! ./CustomCodemirror */ "./app/components/CustomCodemirror.tsx"));
const CustomDialog_1 = __importDefault(__webpack_require__(/*! ./CustomDialog */ "./app/components/CustomDialog.tsx"));
const NotificationContext_1 = __webpack_require__(/*! ./Notification/NotificationContext */ "./app/components/Notification/NotificationContext.tsx");
const clsx_1 = __importDefault(__webpack_require__(/*! clsx */ "./node_modules/clsx/dist/clsx.m.js"));
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const useStyles = core_1.makeStyles((theme) => ({
    error: {
        color: theme.palette.error.main,
        border: `1px solid ${theme.palette.error.main}`,
    },
    success: {
        color: theme.palette.success.main,
        border: `1px solid ${theme.palette.success.main}`,
    },
    warning: {
        color: theme.palette.warning.main,
        border: `1px solid ${theme.palette.warning.main}`,
    },
    segmentDebugDetails: {
        "& .CodeMirror": { fontSize: 14, height: "100%" },
        maxHeight: 500,
    },
}));
var StatusColor;
(function (StatusColor) {
    StatusColor["Error"] = "error";
    StatusColor["Warning"] = "warning";
    StatusColor["Success"] = "success";
})(StatusColor = exports.StatusColor || (exports.StatusColor = {}));
exports.SegmentStatusRenderer = ({ status, segmentName, tableName, }) => {
    const { dispatch: notify } = react_1.useContext(NotificationContext_1.NotificationContext);
    const [statusTooltipTitle, setStatusTooltipTitle] = react_1.useState("");
    const [statusColor, setStatusColor] = react_1.useState(null);
    const [errorDetailsVisible, setErrorDetailsVisible] = react_1.useState(false);
    const [segmentDebugDetails, setSegmentDebugDetails] = react_1.useState(null);
    const segmentStatusRendererClasses = useStyles();
    react_1.useEffect(() => {
        initializeValues();
    }, [status]);
    const initializeValues = () => {
        switch (status) {
            case "GOOD" /* GOOD */: {
                setStatusColor(StatusColor.Success);
                setStatusTooltipTitle("All the servers of this segment are ONLINE/CONSUMING");
                break;
            }
            case "BAD" /* BAD */: {
                setStatusColor(StatusColor.Error);
                setStatusTooltipTitle("One or more servers of this segment are in ERROR state");
                break;
            }
            case "UPDATING" /* UPDATING */: {
                setStatusColor(StatusColor.Warning);
                setStatusTooltipTitle("External view is OFFLINE or missing for one or more servers of this segment");
                break;
            }
        }
    };
    const fetchSegmentErrorDetails = () => __awaiter(void 0, void 0, void 0, function* () {
        setSegmentDebugDetails(null);
        try {
            const segmentDebugDetails = yield requests_1.getSegmentLevelDebugDetails(tableName, segmentName);
            setSegmentDebugDetails(segmentDebugDetails);
        }
        catch (error) {
            notify({
                type: "error",
                message: "Error occurred while fetching segment debug details.",
                show: true,
            });
            setSegmentDebugDetails({});
        }
    });
    const handleShowErrorDetailsClick = () => {
        setErrorDetailsVisible(true);
        fetchSegmentErrorDetails();
    };
    const handleHideErrorDetails = () => {
        setErrorDetailsVisible(false);
    };
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(core_1.Tooltip, { arrow: true, title: statusTooltipTitle, placement: "top" },
            react_1.default.createElement(core_1.Chip, { className: clsx_1.default([segmentStatusRendererClasses[statusColor]]), label: status, variant: "outlined" })),
        status === "BAD" /* BAD */ && (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement(core_1.Tooltip, { title: "Click to show segment error details", arrow: true, placement: "top" },
                react_1.default.createElement(core_1.IconButton, { onClick: handleShowErrorDetailsClick },
                    react_1.default.createElement(icons_1.HelpOutlineOutlined, { fontSize: "small" }))),
            react_1.default.createElement(CustomDialog_1.default, { title: "Segment Debug Details", open: errorDetailsVisible, handleClose: handleHideErrorDetails, showOkBtn: false },
                !segmentDebugDetails && (react_1.default.createElement(core_1.Box, { display: "flex", justifyContent: "center" },
                    react_1.default.createElement(core_1.CircularProgress, null))),
                segmentDebugDetails && (react_1.default.createElement(CustomCodemirror_1.default, { showLineWrapToggle: true, customClass: segmentStatusRendererClasses.segmentDebugDetails, data: segmentDebugDetails })))))));
};


/***/ }),

/***/ "./app/components/SideBar.tsx":
/*!************************************!*\
  !*** ./app/components/SideBar.tsx ***!
  \************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const React = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const clsx_1 = __importDefault(__webpack_require__(/*! clsx */ "./node_modules/clsx/dist/clsx.m.js"));
const styles_1 = __webpack_require__(/*! @material-ui/core/styles */ "./node_modules/@material-ui/core/esm/styles/index.js");
const Drawer_1 = __importDefault(__webpack_require__(/*! @material-ui/core/Drawer */ "./node_modules/@material-ui/core/esm/Drawer/index.js"));
const List_1 = __importDefault(__webpack_require__(/*! @material-ui/core/List */ "./node_modules/@material-ui/core/esm/List/index.js"));
const ListItem_1 = __importDefault(__webpack_require__(/*! @material-ui/core/ListItem */ "./node_modules/@material-ui/core/esm/ListItem/index.js"));
const CssBaseline_1 = __importDefault(__webpack_require__(/*! @material-ui/core/CssBaseline */ "./node_modules/@material-ui/core/esm/CssBaseline/index.js"));
const Box_1 = __importDefault(__webpack_require__(/*! @material-ui/core/Box */ "./node_modules/@material-ui/core/esm/Box/index.js"));
const Typography_1 = __importDefault(__webpack_require__(/*! @material-ui/core/Typography */ "./node_modules/@material-ui/core/esm/Typography/index.js"));
const react_router_dom_1 = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router-dom/esm/react-router-dom.js");
const drawerWidth = 260;
const useStyles = styles_1.makeStyles((theme) => styles_1.createStyles({
    root: {
        display: 'flex',
    },
    appBar: {
        zIndex: theme.zIndex.drawer + 1,
    },
    drawer: {
        width: drawerWidth,
        height: 'calc(100vh - 70px)',
        flexShrink: 0,
        backgroundColor: '#333333',
    },
    drawerOpen: {
        width: drawerWidth,
        transition: theme.transitions.create('width', {
            easing: theme.transitions.easing.sharp,
            duration: theme.transitions.duration.enteringScreen,
        }),
    },
    drawerClose: {
        transition: theme.transitions.create('width', {
            easing: theme.transitions.easing.sharp,
            duration: theme.transitions.duration.leavingScreen,
        }),
        width: '90px',
    },
    drawerPaper: {
        position: 'unset',
        backgroundColor: '#F5F7F9',
        overflowY: 'visible'
    },
    drawerContainer: {
        padding: '20px 15px'
    },
    content: {
        flexGrow: 1,
        padding: theme.spacing(3),
    },
    itemContainer: {
        width: 'auto',
        display: 'block',
        color: '#3B454E',
        borderRadius: '4px',
        '&:hover': {
            backgroundColor: '#ecedef'
        }
    },
    selectedItem: {
        background: '#D8E1E8!important'
    },
    link: {
        textDecoration: 'none',
        '&:hover .menu-item': {
            display: 'inline-block'
        }
    },
    sidebarLabel: {
        marginLeft: '10px'
    },
    sidebarLabelClose: {
        display: 'none',
        marginLeft: '10px',
        top: 0,
        position: 'absolute',
        whiteSpace: 'nowrap',
        backgroundColor: 'inherit',
        padding: '7px 8px 7px 0',
        borderRadius: '0 4px 4px 0',
        zIndex: 9
    },
    popover: {
        pointerEvents: 'none',
    },
    paper: {
        padding: theme.spacing(1),
    },
}));
const Sidebar = ({ showMenu, list, selectedId, highlightSidebarLink }) => {
    const classes = useStyles();
    return (React.createElement(React.Fragment, null,
        React.createElement(CssBaseline_1.default, null),
        React.createElement(Drawer_1.default, { className: clsx_1.default(classes.drawer, {
                [classes.drawerOpen]: showMenu,
                [classes.drawerClose]: !showMenu,
            }), classes: {
                paper: clsx_1.default(classes.drawerPaper, {
                    [classes.drawerOpen]: showMenu,
                    [classes.drawerClose]: !showMenu,
                }),
            }, transitionDuration: 1000, variant: "permanent" },
            React.createElement("div", { className: classes.drawerContainer },
                React.createElement(List_1.default, { disablePadding: true }, list.map(({ id, name, link, target, icon }) => (React.createElement(Box_1.default, { marginX: "auto", marginBottom: "5px", key: name }, link !== 'help' ?
                    React.createElement(react_router_dom_1.NavLink, { to: link, className: classes.link, target: target },
                        React.createElement(ListItem_1.default, { color: "white", button: true, className: `${classes.itemContainer} ${selectedId === id ? classes.selectedItem : ''}`, selected: selectedId === id, onClick: (event) => highlightSidebarLink(id) },
                            icon,
                            React.createElement(Typography_1.default, { className: clsx_1.default('menu-item', {
                                    [classes.sidebarLabel]: showMenu,
                                    [classes.sidebarLabelClose]: !showMenu,
                                }), component: "span" },
                                name,
                                " \u2002")))
                    :
                        React.createElement("a", { href: `${window.location.origin}/${link}`, className: classes.link, target: target },
                            React.createElement(ListItem_1.default, { color: "white", button: true, className: `${classes.itemContainer}` },
                                icon,
                                React.createElement(Typography_1.default, { className: clsx_1.default('menu-item', {
                                        [classes.sidebarLabel]: showMenu,
                                        [classes.sidebarLabelClose]: !showMenu,
                                    }), component: "span" },
                                    name,
                                    " \u2002")))))))))));
};
exports.default = Sidebar;


/***/ }),

/***/ "./app/components/SimpleAccordion.tsx":
/*!********************************************!*\
  !*** ./app/components/SimpleAccordion.tsx ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const styles_1 = __webpack_require__(/*! @material-ui/core/styles */ "./node_modules/@material-ui/core/esm/styles/index.js");
const Accordion_1 = __importDefault(__webpack_require__(/*! @material-ui/core/Accordion */ "./node_modules/@material-ui/core/esm/Accordion/index.js"));
const AccordionSummary_1 = __importDefault(__webpack_require__(/*! @material-ui/core/AccordionSummary */ "./node_modules/@material-ui/core/esm/AccordionSummary/index.js"));
const AccordionDetails_1 = __importDefault(__webpack_require__(/*! @material-ui/core/AccordionDetails */ "./node_modules/@material-ui/core/esm/AccordionDetails/index.js"));
const Typography_1 = __importDefault(__webpack_require__(/*! @material-ui/core/Typography */ "./node_modules/@material-ui/core/esm/Typography/index.js"));
const ExpandMore_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/ExpandMore */ "./node_modules/@material-ui/icons/ExpandMore.js"));
const SearchBar_1 = __importDefault(__webpack_require__(/*! ./SearchBar */ "./app/components/SearchBar.tsx"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const clsx_1 = __importDefault(__webpack_require__(/*! clsx */ "./node_modules/clsx/dist/clsx.m.js"));
const useStyles = styles_1.makeStyles((theme) => styles_1.createStyles({
    root: {
        backgroundColor: 'rgba(66, 133, 244, 0.1)',
        borderBottom: '1px #BDCCD9 solid',
        minHeight: '0 !important',
        '& .MuiAccordionSummary-content.Mui-expanded': {
            margin: 0,
            alignItems: 'center',
        }
    },
    heading: {
        fontWeight: 600,
        letterSpacing: '1px',
        fontSize: '1rem',
        color: '#4285f4'
    },
    details: {
        flexDirection: 'column',
        padding: '0',
        overflow: "auto"
    },
    formControl: {
        marginRight: 0,
        marginLeft: 'auto',
        zoom: 0.85
    }
}));
function SimpleAccordion({ headerTitle, tooltipContent, showSearchBox, searchValue, handleSearch, recordCount, children, accordionToggleObject, detailsContainerClass }) {
    const classes = useStyles();
    return (react_1.default.createElement(Accordion_1.default, { defaultExpanded: true },
        react_1.default.createElement(AccordionSummary_1.default, { expandIcon: react_1.default.createElement(ExpandMore_1.default, null), "aria-controls": `panel1a-content-${headerTitle}`, id: `panel1a-header-${headerTitle}`, className: classes.root },
            tooltipContent ?
                react_1.default.createElement(core_1.Tooltip, { interactive: true, title: tooltipContent, arrow: true, placement: "top" },
                    react_1.default.createElement(Typography_1.default, { className: classes.heading }, `${headerTitle.toUpperCase()} ${recordCount !== undefined ? ` - (${recordCount})` : ''}`))
                :
                    react_1.default.createElement(Typography_1.default, { className: classes.heading }, `${headerTitle.toUpperCase()} ${recordCount !== undefined ? ` - (${recordCount})` : ''}`),
            accordionToggleObject &&
                react_1.default.createElement(core_1.FormControlLabel, { className: classes.formControl, control: react_1.default.createElement(core_1.Switch, { checked: accordionToggleObject.toggleValue, onChange: accordionToggleObject.toggleChangeHandler, name: accordionToggleObject.toggleName, color: "primary" }), label: accordionToggleObject.toggleName })),
        react_1.default.createElement(AccordionDetails_1.default, { className: clsx_1.default(classes.details, detailsContainerClass) },
            showSearchBox ?
                react_1.default.createElement(SearchBar_1.default
                // searchOnRight={true}
                , { 
                    // searchOnRight={true}
                    value: searchValue, onChange: (e) => handleSearch(e.target.value) })
                : null,
            children)));
}
exports.default = SimpleAccordion;


/***/ }),

/***/ "./app/components/SvgIcons/ClusterManagerIcon.tsx":
/*!********************************************************!*\
  !*** ./app/components/SvgIcons/ClusterManagerIcon.tsx ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const React = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const SvgIcon_1 = __importDefault(__webpack_require__(/*! @material-ui/core/SvgIcon */ "./node_modules/@material-ui/core/esm/SvgIcon/index.js"));
exports.default = (props) => (React.createElement(SvgIcon_1.default, Object.assign({ style: { width: 24, height: 24, verticalAlign: 'middle' }, viewBox: "0 0 512 512", fill: "none" }, props),
    React.createElement("g", null,
        React.createElement("path", { d: "m63.623 367.312h-62.815v144.688h148.689v-116.926h-68.752zm55.971 114.786h-88.884v-84.883h16.222l17.123 27.761h55.539z" }),
        React.createElement("path", { d: "m244.47 367.312h-62.815v144.688h148.689v-116.926h-68.751zm55.972 114.786h-88.884v-84.883h16.222l17.123 27.761h55.539z" }),
        React.createElement("path", { d: "m442.44 395.074-17.122-27.761h-62.815v144.687h148.689v-116.926zm38.85 87.024h-88.884v-84.883h16.222l17.122 27.761h55.54z" }),
        React.createElement("path", { d: "m90.104 292.958h150.945v42.267h29.902v-42.267h150.945v42.267h29.902v-72.169h-180.847v-64.555h80.049c31.767 0 57.612-25.926 57.612-57.793 0-26.955-18.608-49.646-43.653-55.903-4.476-22.152-24.093-38.882-47.545-38.882-1.967 0-3.917.116-5.842.347-4.829-26.287-27.911-46.27-55.572-46.27s-50.744 19.983-55.572 46.269c-1.925-.23-3.876-.347-5.843-.347-23.452 0-43.069 16.73-47.544 38.882-25.044 6.256-43.653 28.948-43.653 55.903 0 31.867 25.844 57.793 57.612 57.793h80.049v64.555h-180.848v72.169h29.902v-42.266zm70.896-124.36c-15.279 0-27.709-12.511-27.709-27.891 0-15.279 12.43-27.71 27.709-27.71h15.971c-1.22-3.119-1.897-6.511-1.897-10.063 0-15.266 12.375-27.641 27.641-27.641 12.773 0 23.517 8.666 26.687 20.438v-39.232c0-14.665 11.932-26.596 26.597-26.596s26.597 11.931 26.597 26.596v39.233c3.17-11.772 13.914-20.438 26.687-20.438 15.266 0 27.642 12.375 27.642 27.641 0 3.552-.677 6.943-1.897 10.063h15.972c15.279 0 27.709 12.431 27.709 27.71 0 15.379-12.43 27.891-27.709 27.891h-190z" }))));


/***/ }),

/***/ "./app/components/SvgIcons/Logo.tsx":
/*!******************************************!*\
  !*** ./app/components/SvgIcons/Logo.tsx ***!
  \******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const React = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const SvgIcon_1 = __importDefault(__webpack_require__(/*! @material-ui/core/SvgIcon */ "./node_modules/@material-ui/core/esm/SvgIcon/index.js"));
exports.default = (props) => {
    if (props.fulllogo === 'true') {
        return (React.createElement(SvgIcon_1.default, Object.assign({ style: { width: 105, height: 40 }, width: "105", height: "40", viewBox: "0 0 105 40" }, props),
            React.createElement("path", { d: "M12.4159 0.305775C12.049 0.672747 12.0245 1.08865 12.367 1.51678C12.8685 2.1651 13.7003 1.79813 13.7003 0.94186C13.7003 0.0855913 12.9786 -0.269149 12.4159 0.305775Z", fill: "white" }),
            React.createElement("path", { d: "M6.18959 2.51987C5.71252 2.99693 5.84708 3.8165 6.44647 4.04892C7.16818 4.31803 7.8165 3.15595 7.26604 2.55656C7.00916 2.27522 6.44647 2.25075 6.18959 2.51987Z", fill: "white" }),
            React.createElement("path", { d: "M12.3792 3.62078C12.1101 3.80426 12.1101 3.82873 12.1101 7.37613C12.1101 11.3394 12.0856 11.4985 11.3762 11.4985C10.7034 11.4985 10.6422 11.3027 10.6422 9.22322C10.6422 7.35167 10.6422 7.3272 10.3242 7.02139C10.0917 6.77674 9.94496 6.72781 9.68808 6.78897C9.03976 6.94799 9.05199 6.85014 9.05199 10.948V14.7645L9.73701 14.4098C10.3119 14.1284 10.5933 14.0673 11.3272 14.0673C13.052 14.0673 14.3364 15.0826 14.7523 16.7829C14.9358 17.5046 14.9358 17.6391 14.7523 18.3486C14.422 19.6208 13.4924 20.6116 12.3058 20.9296C11.5229 21.1376 10.3976 21.0153 9.67585 20.6483L9.05199 20.318V22.0917C9.05199 23.8165 9.03976 23.8777 8.74618 24.159C8.58716 24.3303 8.36698 24.4648 8.25689 24.4648C8.1468 24.4648 7.92661 24.3303 7.76759 24.159L7.46178 23.8654L7.46178 14.8257L7.46178 5.78591L7.15597 5.65136C6.82569 5.50457 6.54435 5.5535 6.21407 5.84707C6.04282 5.98163 5.99389 6.22628 5.99389 6.81343L5.99389 7.58408H4.58716H3.1682L2.94802 8.09784C2.72783 8.63606 0.83181 15.3517 0.342513 17.3088C0.134562 18.1774 0.0856323 18.7645 0.0856323 20.1223C0.0856323 22.1162 0.318048 23.1804 1.08869 24.7706C2.18961 27.0581 3.74312 28.5382 6.55658 29.9449C8.08563 30.7156 8.42814 30.9969 8.85628 31.8654C9.30888 32.7951 9.50459 33.7981 9.67585 36.1223C9.79817 37.7492 9.78594 38.0917 9.65138 38.214C9.55352 38.2997 8.37921 38.7156 7.03364 39.1315C5.68808 39.5596 4.5627 39.9266 4.53823 39.951C4.51377 39.9755 7.09481 40 10.2875 39.9877C13.7125 39.9877 15.9633 39.9388 15.7798 39.8777C15.6086 39.8165 14.4098 39.4251 13.1009 39.0214L10.7278 38.263L10.8012 36.526C10.8869 34.4954 11.0336 33.4923 11.4006 32.4403C11.8165 31.2538 12.2569 30.8379 14.0184 29.9449C17.3211 28.2813 19.2049 26.2997 20.0612 23.5474C20.4526 22.3241 20.526 20.0734 20.2447 18.2874C19.8532 15.7553 17.6881 8.02444 17.2844 7.7431C17.1499 7.63301 16.5505 7.58408 15.3884 7.58408H13.7003V5.74922C13.7003 4.07338 13.6758 3.88989 13.4557 3.6697C13.1621 3.37613 12.7584 3.35167 12.3792 3.62078Z", fill: "white" }),
            React.createElement("path", { d: "M9.25998 3.7676C8.97864 4.07341 8.99087 4.80736 9.27222 5.052C9.50463 5.27219 9.99393 5.32112 10.2263 5.1621C10.471 5.00308 10.6667 4.50155 10.5933 4.2202C10.4343 3.57188 9.66365 3.315 9.25998 3.7676Z", fill: "white" }),
            React.createElement("path", { d: "M10.3976 15.9266C9.72481 16.3914 9.48016 16.8196 9.48016 17.5535C9.48016 18.5933 10.1652 19.3272 11.2172 19.4128C12.3303 19.4985 13.211 18.6544 13.211 17.4924C13.211 16.0734 11.5352 15.156 10.3976 15.9266Z", fill: "white" }),
            React.createElement("path", { d: "M50.1228 7.47518C49.301 7.90702 48.8902 8.57711 48.8141 9.54503C48.7532 10.5129 49.1032 11.1681 49.9858 11.7489C50.7162 12.2403 52.0097 12.2254 52.7554 11.734C54.201 10.781 54.1706 8.63668 52.7097 7.57942C52.1162 7.14758 50.838 7.08802 50.1228 7.47518Z", fill: "white" }),
            React.createElement("path", { d: "M98.2563 13.5352V16.5505H97.5073H96.7584V18.3597V20.1689H97.5073H98.2563L98.2862 26.6066L98.3312 33.0594L100.248 33.1046L102.151 33.1498V26.6518V20.1689H103.124H104.098V18.3597V16.5505H103.124H102.151V13.5352V10.5199H100.203H98.2563V13.5352Z", fill: "white" }),
            React.createElement("path", { d: "M64.596 16.4721C63.8441 16.7413 62.8465 17.3097 62.3248 17.7734L61.9718 18.0726V17.3845V16.6815H59.9767H57.9817V24.9082V33.1349H59.9614H61.9411L62.0025 27.8548C62.0792 21.9615 62.1559 21.453 63.1228 20.5107C63.7366 19.9123 64.8723 19.5982 65.9926 19.7179C67.4659 19.8974 68.1411 20.6004 68.4174 22.3056C68.5094 22.7992 68.5708 25.4317 68.5708 28.169V33.1498L70.5352 33.105L72.4842 33.0601L72.5302 27.8249C72.5609 24.624 72.4995 22.0962 72.4075 21.3184C72.1005 18.9999 71.1184 17.564 69.2614 16.7264C68.4787 16.3824 68.0951 16.3076 66.806 16.2776C65.6857 16.2477 65.0871 16.2926 64.596 16.4721Z", fill: "white" }),
            React.createElement("path", { d: "M82.8772 16.4602C81.3955 16.8233 80.1103 17.5799 78.9007 18.8055C77.0863 20.6364 76.3303 22.4219 76.3303 24.9488C76.3303 30.169 80.5185 34.088 85.7046 33.74C87.2317 33.6341 88.3506 33.3314 89.4846 32.7111C91.3746 31.6519 92.8261 29.9723 93.5367 28.0053C93.8845 27.052 93.945 26.6889 93.945 25.0244C93.945 23.4357 93.8845 22.9666 93.5972 22.1192C92.6447 19.3805 90.2708 17.2016 87.4434 16.4753C86.3699 16.203 83.981 16.203 82.8772 16.4602ZM86.5839 19.9168C87.6189 20.2242 88.5321 20.8543 89.0648 21.6227C90.526 23.7435 90.2977 27.2013 88.593 28.984C87.7255 29.8907 86.5839 30.3364 85.138 30.3364C83.8443 30.321 83.1441 30.1059 82.1396 29.3989C80.511 28.2617 79.7652 25.2035 80.5719 22.8982C81.4394 20.424 84.0269 19.1484 86.5839 19.9168Z", fill: "white" }),
            React.createElement("path", { d: "M49.4189 24.8855V33.1498L51.4062 33.1048L53.378 33.0598L53.4246 24.8405L53.4556 16.6361H51.4373H49.4189V24.8855Z", fill: "white" }),
            React.createElement("path", { d: "M34.932 16.9102C34.0837 17.0461 32.7508 17.5293 32.251 17.8766C31.7966 18.1938 31.7057 18.1636 31.7057 17.6501V17.1971H29.7366H27.7676L27.7676 28.5985V40H29.7366H31.7057V36.4663V32.9175L32.5842 33.3705C33.8111 33.9897 35.038 34.2615 36.6284 34.2615C39.2639 34.2615 41.3087 33.4461 43.0506 31.6943C44.7925 29.9577 45.5044 28.1908 45.5044 25.5481C45.5195 22.9356 44.7925 21.1536 42.99 19.3566C40.8695 17.2424 38.0673 16.3816 34.932 16.9102ZM38.1743 20.4091C40.297 20.9406 41.6067 23.112 41.4562 25.8453C41.3508 27.5613 40.9443 28.5179 39.9055 29.4898C38.8668 30.4312 37.8129 30.7805 36.2924 30.6894C34.4407 30.5679 33.0858 29.6416 32.318 28.0016C31.9718 27.2424 31.9266 26.969 31.9266 25.4809C31.9266 23.9928 31.9718 23.7194 32.318 22.9754C32.8449 21.8517 33.3267 21.2898 34.2601 20.7887C35.4494 20.1357 36.6387 20.0143 38.1743 20.4091Z", fill: "white" })));
    }
    return (React.createElement(SvgIcon_1.default, Object.assign({ style: { width: 40, height: 40, fill: '#ffffff' }, viewBox: "0 0 166.2 326.7" }, props),
        React.createElement("path", { id: "Path", d: "M100.8,2.3c-3,3-3.2,6.4-0.4,9.9c4.1,5.3,10.9,2.3,10.9-4.7S105.4-2.4,100.8,2.3z" }),
        React.createElement("path", { d: "M49.9,20.4C46,24.3,47.1,31,52,32.9c5.9,2.2,11.2-7.3,6.7-12.2C56.6,18.4,52,18.2,49.9,20.4z" }),
        React.createElement("path", { d: "M100.5,29.4c-2.2,1.5-2.2,1.7-2.2,30.7c0,32.4-0.2,33.7-6,33.7c-5.5,0-6-1.6-6-18.6c0-15.3,0-15.5-2.6-18\n          c-1.9-2-3.1-2.4-5.2-1.9c-5.3,1.3-5.2,0.5-5.2,34v31.2l5.6-2.9c4.7-2.3,7-2.8,13-2.8c14.1,0,24.6,8.3,28,22.2c1.5,5.9,1.5,7,0,12.8\n          c-2.7,10.4-10.3,18.5-20,21.1c-6.4,1.7-15.6,0.7-21.5-2.3l-5.1-2.7v14.5c0,14.1-0.1,14.6-2.5,16.9c-1.3,1.4-3.1,2.5-4,2.5\n          s-2.7-1.1-4-2.5l-2.5-2.4V121V47.1L57.8,46c-2.7-1.2-5-0.8-7.7,1.6c-1.4,1.1-1.8,3.1-1.8,7.9v6.3H36.8H25.2L23.4,66\n          c-1.8,4.4-17.3,59.3-21.3,75.3c-1.7,7.1-2.1,11.9-2.1,23c0,16.3,1.9,25,8.2,38c9,18.7,21.7,30.8,44.7,42.3\n          c12.5,6.3,15.3,8.6,18.8,15.7c3.7,7.6,5.3,15.8,6.7,34.8c1,13.3,0.9,16.1-0.2,17.1c-0.8,0.7-10.4,4.1-21.4,7.5\n          c-11,3.5-20.2,6.5-20.4,6.7c-0.2,0.2,20.9,0.4,47,0.3c28,0,46.4-0.4,44.9-0.9c-1.4-0.5-11.2-3.7-21.9-7L87,312.6l0.6-14.2\n          c0.7-16.6,1.9-24.8,4.9-33.4c3.4-9.7,7-13.1,21.4-20.4c27-13.6,42.4-29.8,49.4-52.3c3.2-10,3.8-28.4,1.5-43\n          c-3.2-20.7-20.9-83.9-24.2-86.2c-1.1-0.9-6-1.3-15.5-1.3h-13.8v-15c0-13.7-0.2-15.2-2-17C106.9,27.4,103.6,27.2,100.5,29.4z" }),
        React.createElement("path", { d: "M75,30.6c-2.3,2.5-2.2,8.5,0.1,10.5c1.9,1.8,5.9,2.2,7.8,0.9c2-1.3,3.6-5.4,3-7.7C84.6,29,78.3,26.9,75,30.6z" }),
        React.createElement("path", { d: "M84.3,130c-5.5,3.8-7.5,7.3-7.5,13.3c0,8.5,5.6,14.5,14.2,15.2c9.1,0.7,16.3-6.2,16.3-15.7C107.3,131.2,93.6,123.7,84.3,130\n          z" })));
};


/***/ }),

/***/ "./app/components/SvgIcons/QueryConsoleIcon.tsx":
/*!******************************************************!*\
  !*** ./app/components/SvgIcons/QueryConsoleIcon.tsx ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const React = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const SvgIcon_1 = __importDefault(__webpack_require__(/*! @material-ui/core/SvgIcon */ "./node_modules/@material-ui/core/esm/SvgIcon/index.js"));
exports.default = (props) => (React.createElement(SvgIcon_1.default, Object.assign({ style: { width: 24, height: 24, verticalAlign: 'middle' }, viewBox: "0 0 512 512", fill: "none" }, props),
    React.createElement("path", { d: "M401.6,246.5c17.3-24.9,27.5-55.1,27.5-87.7C429.1,74,360.1,5,275.3,5S121.5,74,121.5,158.8c0,20.4,4,39.9,11.2,57.7\n\tc-32.8,0.3-63.7,5.1-87.3,13.6C7.9,243.5,0,261.8,0,274.8v86.8c0,0,0,0.1,0,0.1s0,0.1,0,0.1v86.8c0,13,7.9,31.4,45.5,44.8\n\tc24.5,8.8,56.7,13.6,90.8,13.6s66.3-4.8,90.8-13.6c37.6-13.4,45.5-31.8,45.5-44.8v-86.8c0,0,0-0.1,0-0.1s0-0.1,0-0.1v-49.1\n\tc0.9,0,1.8,0,2.7,0c18.1,0,35.4-3.1,51.5-8.9l109.3,148.8l75.8-55.7L401.6,246.5z M55.6,258.3c21.3-7.6,50-11.8,80.7-11.8\n\tc4.4,0,8.7,0.1,12.9,0.3c14.2,20.3,33.2,37,55.3,48.5c-19.5,5.2-43.1,8-68.2,8c-30.7,0-59.4-4.2-80.7-11.8\n\tc-21-7.5-25.6-15.1-25.6-16.5S34.6,265.8,55.6,258.3z M242.6,448.6c0,1.5-4.5,9-25.6,16.5c-21.3,7.6-50,11.8-80.7,11.8\n\tc-30.7,0-59.4-4.2-80.7-11.8c-21-7.5-25.6-15.1-25.6-16.5v-48.7c4.5,2.3,9.6,4.5,15.5,6.6c24.5,8.8,56.7,13.6,90.8,13.6\n\ts66.3-4.8,90.8-13.6c5.8-2.1,11-4.3,15.5-6.6V448.6z M217,378.2c-21.3,7.6-50,11.8-80.7,11.8c-30.7,0-59.4-4.2-80.7-11.8\n\tc-21-7.5-25.6-15.1-25.6-16.5v-48.5c4.5,2.3,9.6,4.5,15.5,6.6c24.5,8.8,56.7,13.6,90.8,13.6s66.3-4.8,90.8-13.6\n\tc5.8-2.1,11-4.3,15.5-6.6v48.5h0C242.6,363.1,238,370.6,217,378.2z M275.3,282.5c-68.2,0-123.8-55.5-123.8-123.8S207.1,35,275.3,35\n\ts123.8,55.5,123.8,123.8C399.1,227,343.5,282.5,275.3,282.5z M354.5,290.6c9.8-5.9,18.8-12.8,27-20.7L470,390.3l-27.4,20.2\n        L354.5,290.6z M200.3,143.8h30v30h-30V143.8z M260.3,143.8h30v30h-30V143.8z M320.3,143.8h30v30h-30V143.8z" })));


/***/ }),

/***/ "./app/components/SvgIcons/SwaggerIcon.tsx":
/*!*************************************************!*\
  !*** ./app/components/SvgIcons/SwaggerIcon.tsx ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const React = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const SvgIcon_1 = __importDefault(__webpack_require__(/*! @material-ui/core/SvgIcon */ "./node_modules/@material-ui/core/esm/SvgIcon/index.js"));
exports.default = (props) => (React.createElement(SvgIcon_1.default, Object.assign({ style: { width: 24, height: 24, verticalAlign: 'middle' }, viewBox: "0 0 100 100", fill: "none" }, props),
    React.createElement("path", { d: "M50,4.8C75,4.8,95.3,25,95.3,50C95.3,75,75,95.3,50,95.3C25,95.3,4.8,75,4.8,50C4.8,25,25,4.8,50,4.8 M50,0\n      C22.4,0,0,22.4,0,50s22.4,50,50,50s50-22.4,50-50S77.6,0,50,0L50,0z" }),
    React.createElement("path", { d: "M31.5,33.9c-0.2,1.7,0.1,3.5-0.1,5.2c-0.1,1.7-0.3,3.4-0.7,5.2c-0.5,2.4-2,4.3-4.1,5.8c4.1,2.7,4.5,6.8,4.8,10.9\n      c0.1,2.3,0.1,4.5,0.3,6.8c0.2,1.7,0.8,2.2,2.6,2.2c0.7,0,1.5,0,2.3,0v5.3c-5.3,0.9-9.7-0.6-10.7-5.1c-0.3-1.6-0.6-3.3-0.7-5\n      c-0.1-1.8,0.1-3.6-0.1-5.4c-0.4-4.9-1-6.6-5.7-6.8V47c0.3-0.1,0.7-0.1,1-0.2c2.6-0.1,3.7-0.9,4.2-3.5c0.3-1.4,0.4-2.9,0.5-4.3\n      c0.2-2.8,0.1-5.6,0.6-8.4c0.7-4,3.1-5.9,7.2-6.1c1.2-0.1,2.3,0,3.7,0V30c-0.6,0-1,0.1-1.5,0.1C31.9,29.9,31.8,31.1,31.5,33.9z\n      M37.9,46.5L37.9,46.5c-2-0.1-3.7,1.4-3.8,3.3c-0.1,1.9,1.4,3.6,3.3,3.7h0.2c1.9,0.1,3.5-1.3,3.7-3.3v-0.2\n      C41.4,48.1,39.9,46.6,37.9,46.5z M50,46.5c-1.9-0.1-3.4,1.4-3.5,3.3c0,0.1,0,0.2,0,0.3c0,2.1,1.4,3.4,3.6,3.4\n      c2.1,0,3.4-1.4,3.4-3.6C53.5,47.9,52.1,46.5,50,46.5z M62.3,46.5c-2,0-3.6,1.5-3.7,3.5c0,2,1.6,3.5,3.5,3.5h0\n      c1.8,0.3,3.6-1.4,3.7-3.5C66,48.2,64.3,46.5,62.3,46.5z M79.3,46.8c-2.2-0.1-3.3-0.8-3.9-3c-0.3-1.3-0.6-2.8-0.6-4.1\n      c-0.2-2.6-0.1-5.2-0.3-7.8c-0.4-6.1-4.8-8.3-11.3-7.2v5.3c1,0,1.8,0,2.6,0c1.4,0,2.4,0.5,2.5,2.1c0.1,1.4,0.1,2.8,0.3,4.2\n      c0.3,2.8,0.4,5.6,0.9,8.4c0.4,2.3,2,4,3.9,5.3c-3.4,2.3-4.4,5.6-4.6,9.2c-0.1,2.5-0.2,5.1-0.3,7.6c-0.1,2.3-0.9,3.1-3.3,3.1\n      c-0.7,0-1.3,0.1-2,0.1v5.4c1.4,0,2.6,0.1,3.9,0c3.9-0.2,6.2-2.1,7-5.9c0.3-2.1,0.5-4.2,0.6-6.3c0.1-1.9,0.1-3.9,0.3-5.8\n      c0.3-3,1.7-4.2,4.6-4.4c0.3,0,0.6-0.1,0.8-0.2v-6.1C80,46.9,79.6,46.8,79.3,46.8z" })));


/***/ }),

/***/ "./app/components/SvgIcons/ZookeeperIcon.tsx":
/*!***************************************************!*\
  !*** ./app/components/SvgIcons/ZookeeperIcon.tsx ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const React = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const SvgIcon_1 = __importDefault(__webpack_require__(/*! @material-ui/core/SvgIcon */ "./node_modules/@material-ui/core/esm/SvgIcon/index.js"));
exports.default = (props) => (React.createElement(SvgIcon_1.default, Object.assign({ style: { width: 24, height: 24, verticalAlign: 'middle', transform: 'scale(1.5)' }, viewBox: "0 0 980.2 980.2", fill: "none" }, props),
    React.createElement("g", null,
        React.createElement("path", { d: "M207.5,594.4c0,0,338.6,37.9,471.6,108.1s250.9,79.3,129.7-12.7C687.5,597.8,403.4,494.9,207.5,594.4z" }),
        React.createElement("path", { d: "M730.8,269.1C572.7,203.8,381.1,220.6,290,244C198.8,267.3,9.8,345.1,0.5,443.8c-5.2,55.3,28.3,94.7,77.7,122.5\n        c-1-3.1-1.8-6.1-2.8-9.1l-5.7-18.1l16-10.5c29.2-19.1,78.2-46.2,145.8-67.3c65.9-20.6,135.1-31.1,205.6-31.1c1.6,0,3.2,0,4.9,0.1\n        l14.6-12.6l-77.7-6.9l3.5-21.5l134.4,15.6l-31.7,27c16.8,1.1,33.8,2.9,50.6,5.2c7.8-7,18.3-13.3,32.7-18.2\n        c29.5-10.1,71,3.8,89.5,38.2c1.7,3.2,3.2,6.5,4.4,9.8c11.4,4,22.7,8.4,33.7,13.2c6.8-7.3,19.5-16.6,35.6-16.4\n        c18,0.2,38,13.1,46.9,22.8c8.2,9.1,22.5,30.6,24.7,55.5c2.8,2.2,5.6,4.2,8.3,6.4c49.7,39.6,72.4,74.4,73.3,76l6.2,9.6l-3.1,10.9\n        c-0.8,2.5-1.7,5.4-3.6,9c35.5-20.3,79.5-55.1,92.8-107.9C1000.2,453,889,334.2,730.8,269.1z" }),
        React.createElement("path", { d: "M799.9,571.4c-5.6,16.5-18.2,28.4-40.6,29c-31.9,0.9-58-28.5-70.1-52.3c-7.7-15-8-31.8-4.6-45.5c-5.7-2.4-11.5-4.7-17.5-7\n        c-0.8,23.3-13.2,44.3-37.5,50.9c-37.7,10.1-76.9-6.7-97.3-31.6c-9.9-12.1-18.2-33.7-11.8-54.4c-21.6-2.6-42.7-4.1-63.2-4.7\n        l-48.1,40.8l85.8,9.3l-4.6,22l-143.9-14.5l66.2-57.5c-137.2,5-246.6,50.4-313.2,93.9c0,0,21.8,68.7,20.1,82.9c0,0,6-4.2,38.3-14.7\n        l-5.7-23.4l44.1-22.4c56.7-28.8,123.4-43.5,198.1-43.5c167.3,0,340,73.1,429.6,141.2c3.5,2.6,6.7,5.2,9.9,7.8\n        c12.9-13.2,26.6-29,29.8-39.7C863.4,637.8,844,607.3,799.9,571.4z" }),
        React.createElement("path", { d: "M635.6,503.2c-7.6,16.9-28.9,29.1-56.5,17.4c-27.6-11.8-31.7-39.4-26.8-53c4.5-12.4,16.5-21.9,26.5-25.2\n        c10-3.3,34.3-1.7,46.5,12S643.2,486.2,635.6,503.2z" }),
        React.createElement("path", { d: "M768.8,569c-15,14.1-40.2,1.9-50.6-14.6c-10.5-16.5-9.8-36-5.4-47.6c0,0,10.7-21.3,31.3-17.4s31.1,24.2,33.9,35.7\n        C780.8,536.8,783.8,555,768.8,569z" }))));


/***/ }),

/***/ "./app/components/TabPanel.tsx":
/*!*************************************!*\
  !*** ./app/components/TabPanel.tsx ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
function TabPanel(props) {
    const { children, value, index } = props, other = __rest(props, ["children", "value", "index"]);
    return (react_1.default.createElement("div", Object.assign({ role: "tabpanel", hidden: value !== index, id: `full-width-tabpanel-${index}`, "aria-labelledby": `full-width-tab-${index}` }, other), value === index && (react_1.default.createElement(core_1.Box, { style: { padding: '24px 0' } }, children))));
}
exports.default = TabPanel;


/***/ }),

/***/ "./app/components/Table.tsx":
/*!**********************************!*\
  !*** ./app/components/Table.tsx ***!
  \**********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
/* eslint-disable no-nested-ternary */
const React = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const prop_types_1 = __importDefault(__webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js"));
const styles_1 = __webpack_require__(/*! @material-ui/core/styles */ "./node_modules/@material-ui/core/esm/styles/index.js");
const ComponentLoader_1 = __importDefault(__webpack_require__(/*! ./ComponentLoader */ "./app/components/ComponentLoader.tsx"));
const Dialog_1 = __importDefault(__webpack_require__(/*! @material-ui/core/Dialog */ "./node_modules/@material-ui/core/esm/Dialog/index.js"));
const Table_1 = __importDefault(__webpack_require__(/*! @material-ui/core/Table */ "./node_modules/@material-ui/core/esm/Table/index.js"));
const TableBody_1 = __importDefault(__webpack_require__(/*! @material-ui/core/TableBody */ "./node_modules/@material-ui/core/esm/TableBody/index.js"));
const TableCell_1 = __importDefault(__webpack_require__(/*! @material-ui/core/TableCell */ "./node_modules/@material-ui/core/esm/TableCell/index.js"));
const TableContainer_1 = __importDefault(__webpack_require__(/*! @material-ui/core/TableContainer */ "./node_modules/@material-ui/core/esm/TableContainer/index.js"));
const TableHead_1 = __importDefault(__webpack_require__(/*! @material-ui/core/TableHead */ "./node_modules/@material-ui/core/esm/TableHead/index.js"));
const TableRow_1 = __importDefault(__webpack_require__(/*! @material-ui/core/TableRow */ "./node_modules/@material-ui/core/esm/TableRow/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const IconButton_1 = __importDefault(__webpack_require__(/*! @material-ui/core/IconButton */ "./node_modules/@material-ui/core/esm/IconButton/index.js"));
const FirstPage_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/FirstPage */ "./node_modules/@material-ui/icons/FirstPage.js"));
const KeyboardArrowLeft_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/KeyboardArrowLeft */ "./node_modules/@material-ui/icons/KeyboardArrowLeft.js"));
const KeyboardArrowRight_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/KeyboardArrowRight */ "./node_modules/@material-ui/icons/KeyboardArrowRight.js"));
const LastPage_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/LastPage */ "./node_modules/@material-ui/icons/LastPage.js"));
const ArrowDropDown_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/ArrowDropDown */ "./node_modules/@material-ui/icons/ArrowDropDown.js"));
const ArrowDropUp_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/ArrowDropUp */ "./node_modules/@material-ui/icons/ArrowDropUp.js"));
const react_router_dom_1 = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router-dom/esm/react-router-dom.js");
const Chip_1 = __importDefault(__webpack_require__(/*! @material-ui/core/Chip */ "./node_modules/@material-ui/core/esm/Chip/index.js"));
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const app_state_1 = __importDefault(__webpack_require__(/*! ../app_state */ "./app/app_state.ts"));
const SortFunctions_1 = __webpack_require__(/*! ../utils/SortFunctions */ "./app/utils/SortFunctions.tsx");
const Utils_1 = __importDefault(__webpack_require__(/*! ../utils/Utils */ "./app/utils/Utils.tsx"));
const TableToolbar_1 = __importDefault(__webpack_require__(/*! ./TableToolbar */ "./app/components/TableToolbar.tsx"));
const SimpleAccordion_1 = __importDefault(__webpack_require__(/*! ./SimpleAccordion */ "./app/components/SimpleAccordion.tsx"));
// These sort functions are applied to any columns with these names. Otherwise, we just
// sort on the raw data. Ideally users of this class would pass in custom sort functions
// for their columns, but this pattern already existed, so we're at least making the
// improvement to pull this out to a common variable.
let staticSortFunctions = new Map();
staticSortFunctions.set("Number of Segments", SortFunctions_1.sortNumberOfSegments);
staticSortFunctions.set("Estimated Size", SortFunctions_1.sortBytes);
staticSortFunctions.set("Reported Size", SortFunctions_1.sortBytes);
const StyledTableRow = styles_1.withStyles((theme) => styles_1.createStyles({
    root: {
        '&:nth-of-type(even)': {
            backgroundColor: theme.palette.action.hover,
        },
    },
}))(TableRow_1.default);
const StyledTableCell = styles_1.withStyles((theme) => styles_1.createStyles({
    root: {
        padding: '10px 15px',
    }
}))(TableCell_1.default);
const StyledChip = styles_1.withStyles((theme) => styles_1.createStyles({
    root: {
        height: '28px',
        '& span': {
            paddingLeft: '8px',
            paddingRight: '8px',
            fontWeight: '600'
        }
    }
}))(Chip_1.default);
const useStyles = styles_1.makeStyles((theme) => ({
    root: {
        border: '1px #BDCCD9 solid',
        borderRadius: 4,
        marginBottom: '20px',
    },
    highlightBackground: {
        border: '1px #4285f4 solid',
        backgroundColor: 'rgba(66, 133, 244, 0.05)',
        borderRadius: 4,
        marginBottom: '20px',
    },
    table: {
        borderTop: '1px solid #BDCCD9',
    },
    isCellClickable: {
        color: theme.palette.primary.main,
        cursor: 'pointer',
        textDecoration: 'underline',
        borderTop: '1px #BDCCD9 solid'
    },
    isSticky: {
        whiteSpace: 'nowrap'
    },
    head: {
        fontWeight: 600,
        borderBottom: '2px solid #BDCCD9',
        lineHeight: '1rem',
        cursor: 'pointer',
        whiteSpace: 'nowrap'
    },
    body: {
        fontSize: 14,
        color: '#3B454E',
        padding: '0.5rem 0.6rem',
    },
    nodata: {
        textAlign: 'center',
    },
    link: {
        color: '#4285f4',
    },
    spacer: {
        flex: '0 1 auto',
    },
    cellStatusGood: {
        color: '#4CAF50',
        border: '1px solid #4CAF50',
    },
    cellStatusBad: {
        color: '#f44336',
        border: '1px solid #f44336',
    },
    cellStatusConsuming: {
        color: '#ff9800',
        border: '1px solid #ff9800',
    },
    cellStatusError: {
        color: '#a11',
        border: '1px solid #a11',
    },
    clickable: {
        cursor: 'pointer',
        color: '#4285f4',
        textDecoration: 'underline',
    }
}));
const usePaginationStyles = styles_1.makeStyles({
    root: {
        flexShrink: 0,
        marginLeft: 'auto',
    },
});
function TablePaginationActions(props) {
    const classes = usePaginationStyles();
    const theme = styles_1.useTheme();
    const { count, page, rowsPerPage, onChangePage } = props;
    const handleFirstPageButtonClick = (event) => {
        onChangePage(event, 0);
    };
    const handleBackButtonClick = (event) => {
        onChangePage(event, page - 1);
    };
    const handleNextButtonClick = (event) => {
        onChangePage(event, page + 1);
    };
    const handleLastPageButtonClick = (event) => {
        onChangePage(event, Math.max(0, Math.ceil(count / rowsPerPage) - 1));
    };
    return (React.createElement("div", { className: classes.root },
        React.createElement(IconButton_1.default, { onClick: handleFirstPageButtonClick, disabled: page === 0, "aria-label": "first page" }, theme.direction === 'rtl' ? React.createElement(LastPage_1.default, null) : React.createElement(FirstPage_1.default, null)),
        React.createElement(IconButton_1.default, { onClick: handleBackButtonClick, disabled: page === 0, "aria-label": "previous page" }, theme.direction === 'rtl' ? (React.createElement(KeyboardArrowRight_1.default, null)) : (React.createElement(KeyboardArrowLeft_1.default, null))),
        React.createElement(IconButton_1.default, { onClick: handleNextButtonClick, disabled: page >= Math.ceil(count / rowsPerPage) - 1, "aria-label": "next page" }, theme.direction === 'rtl' ? (React.createElement(KeyboardArrowLeft_1.default, null)) : (React.createElement(KeyboardArrowRight_1.default, null))),
        React.createElement(IconButton_1.default, { onClick: handleLastPageButtonClick, disabled: page >= Math.ceil(count / rowsPerPage) - 1, "aria-label": "last page" }, theme.direction === 'rtl' ? React.createElement(FirstPage_1.default, null) : React.createElement(LastPage_1.default, null))));
}
TablePaginationActions.propTypes = {
    count: prop_types_1.default.number.isRequired,
    onChangePage: prop_types_1.default.func.isRequired,
    page: prop_types_1.default.number.isRequired,
    rowsPerPage: prop_types_1.default.number.isRequired,
};
function CustomizedTables({ title, data, defaultRowsPerPage, addLinks, cellClickCallback, isCellClickable, highlightBackground, isSticky, baseURL, recordsCount, showSearchBox, inAccordionFormat, regexReplace, accordionToggleObject, tooltipData }) {
    // Separate the initial and final data into two separated state variables.
    // This way we can filter and sort the data without affecting the original data.
    // If the component receives new data, we can simply set the new data to the initial data,
    // and the filters and sorts will be applied to the new data.
    const [initialData, setInitialData] = React.useState(data);
    const [finalData, setFinalData] = React.useState(Utils_1.default.tableFormat(data));
    React.useEffect(() => {
        setInitialData(data);
    }, [data]);
    // We do not use data.isLoading directly in the renderer because there's a gap between data
    // changing and finalData being set. Without this, there's a flicker where we go from
    // loading -> no records found -> not loading + data.
    const [isLoading, setIsLoading] = React.useState(false);
    React.useEffect(() => {
        setIsLoading(data.isLoading || false);
    }, [finalData]);
    const [order, setOrder] = React.useState(false);
    const [columnClicked, setColumnClicked] = React.useState('');
    const classes = useStyles();
    const [rowsPerPage, setRowsPerPage] = React.useState(defaultRowsPerPage || 10);
    const [page, setPage] = React.useState(0);
    const handleChangeRowsPerPage = (event) => {
        setRowsPerPage(parseInt(event.target.value, 10));
        setPage(0);
    };
    const handleChangePage = (event, newPage) => {
        setPage(newPage);
    };
    const [search, setSearch] = React.useState('');
    const timeoutId = React.useRef();
    const filterSearchResults = React.useCallback((str) => {
        if (str === '') {
            setFinalData(Utils_1.default.tableFormat(data));
        }
        else {
            const filteredRescords = initialData.records.filter((record) => {
                const searchFound = record.find((cell) => cell.toString().toLowerCase().indexOf(str) > -1);
                if (searchFound) {
                    return true;
                }
                return false;
            });
            let filteredData = Object.assign(Object.assign({}, initialData), { records: filteredRescords });
            setFinalData(Utils_1.default.tableFormat(filteredData));
        }
    }, [initialData, setFinalData]);
    React.useEffect(() => {
        clearTimeout(timeoutId.current);
        timeoutId.current = setTimeout(() => {
            filterSearchResults(search.toLowerCase());
            // Table.tsx currently doesn't support sorting after filtering. So for now, we just
            // remove the visual indicator of the sorted column until users sort again.
            setColumnClicked('');
        }, 200);
        return () => {
            clearTimeout(timeoutId.current);
        };
    }, [search, timeoutId, filterSearchResults]);
    const styleCell = (str) => {
        var _a;
        if (str.toLowerCase() === 'good' || str.toLowerCase() === 'online' || str.toLowerCase() === 'alive' || str.toLowerCase() === 'true') {
            return (React.createElement(StyledChip, { label: str, className: classes.cellStatusGood, variant: "outlined" }));
        }
        if (str.toLocaleLowerCase() === 'bad' || str.toLowerCase() === 'offline' || str.toLowerCase() === 'dead' || str.toLowerCase() === 'false') {
            return (React.createElement(StyledChip, { label: str, className: classes.cellStatusBad, variant: "outlined" }));
        }
        if (str.toLowerCase() === 'consuming' || str.toLocaleLowerCase() === "partial" || str.toLocaleLowerCase() === "updating") {
            return (React.createElement(StyledChip, { label: str, className: classes.cellStatusConsuming, variant: "outlined" }));
        }
        if (str.toLowerCase() === 'error') {
            return (React.createElement(StyledChip, { label: str, className: classes.cellStatusError, variant: "outlined" }));
        }
        if (((_a = str === null || str === void 0 ? void 0 : str.toLowerCase()) === null || _a === void 0 ? void 0 : _a.search('partial-')) !== -1) {
            return (React.createElement(StyledChip, { label: str === null || str === void 0 ? void 0 : str.replace('Partial-', ''), className: classes.cellStatusConsuming, variant: "outlined" }));
        }
        if (str.search('\n') !== -1) {
            return (React.createElement("pre", null, str.toString()));
        }
        return (React.createElement("span", null, str.toString()));
    };
    const [modalStatus, setModalOpen] = React.useState({});
    const handleModalOpen = (rowIndex) => () => setModalOpen(Object.assign(Object.assign({}, modalStatus), { [rowIndex]: true }));
    const handleModalClose = (rowIndex) => () => setModalOpen(Object.assign(Object.assign({}, modalStatus), { [rowIndex]: false }));
    const makeCell = (cellData, rowIndex) => {
        if (Object.prototype.toString.call(cellData) === '[object Object]') {
            // render custom table cell
            if (cellData && cellData.customRenderer) {
                return React.createElement(React.Fragment, null, cellData.customRenderer);
            }
            if (lodash_1.has(cellData, 'component') && cellData.component) {
                let cell = (styleCell(cellData.value));
                let statusModal = (React.createElement(Dialog_1.default, { onClose: handleModalClose(rowIndex), open: lodash_1.get(modalStatus, rowIndex, false), fullWidth: true, maxWidth: 'xl' }, cellData.component));
                cell = (React.cloneElement(cell, { onClick: handleModalOpen(rowIndex) }));
                if (lodash_1.has(cellData, 'tooltip') && cellData.tooltip) {
                    cell = (React.createElement(core_1.Tooltip, { title: cellData.tooltip, placement: "top", arrow: true }, cell));
                }
                ;
                return (React.createElement(React.Fragment, null,
                    cell,
                    statusModal));
            }
            else if (lodash_1.has(cellData, 'tooltip') && cellData.tooltip) {
                return (React.createElement(core_1.Tooltip, { title: cellData.tooltip, placement: "top", arrow: true }, styleCell(cellData.value)));
            }
            else {
                return styleCell(cellData.value);
            }
        }
        return styleCell(cellData.toString());
    };
    const renderTableComponent = () => {
        return (React.createElement(React.Fragment, null,
            React.createElement(TableContainer_1.default, { style: { maxHeight: isSticky ? 400 : 500 } },
                React.createElement(Table_1.default, { className: classes.table, size: "small", stickyHeader: isSticky },
                    React.createElement(TableHead_1.default, null,
                        React.createElement(TableRow_1.default, null, data.columns && data.columns.map((column, index) => (React.createElement(StyledTableCell, { className: classes.head, key: index, onClick: () => {
                                if (staticSortFunctions.has(column)) {
                                    finalData.sort((a, b) => staticSortFunctions.get(column)(a, b, column, index, order));
                                    setFinalData(finalData);
                                }
                                else {
                                    setFinalData(lodash_1.orderBy(finalData, column + app_state_1.default.columnNameSeparator + index, order ? 'asc' : 'desc'));
                                }
                                setOrder(!order);
                                setColumnClicked(column);
                            } },
                            React.createElement(React.Fragment, null,
                                tooltipData && tooltipData[index] ?
                                    (React.createElement(core_1.Tooltip, { title: tooltipData[index], placement: "top", arrow: true },
                                        React.createElement("span", null, column)))
                                    :
                                        column,
                                column === columnClicked ? order ? (React.createElement(ArrowDropDown_1.default, { color: "primary", style: { verticalAlign: 'middle' } })) : (React.createElement(ArrowDropUp_1.default, { color: "primary", style: { verticalAlign: 'middle' } })) : null)))))),
                    React.createElement(TableBody_1.default, { className: classes.body }, isLoading ? React.createElement(ComponentLoader_1.default, null) : (finalData.length === 0 ? (React.createElement(TableRow_1.default, null,
                        React.createElement(StyledTableCell, { className: classes.nodata, colSpan: 2 }, "No Record(s) found"))) : (finalData
                        .slice(page * rowsPerPage, page * rowsPerPage + rowsPerPage)
                        .map((row, index) => (React.createElement(StyledTableRow, { key: index, hover: true }, Object.values(row).map((cell, idx) => {
                        let url = baseURL;
                        if (regexReplace) {
                            const regex = /\:.*?:/;
                            const matches = baseURL.match(regex);
                            url = baseURL.replace(matches[0], row[matches[0].replace(/:/g, '')]);
                        }
                        return addLinks && typeof cell === 'string' && !idx ? (React.createElement(StyledTableCell, { key: idx },
                            React.createElement(react_router_dom_1.Link, { to: `${encodeURI(`${url}${encodeURIComponent(cell)}`)}` }, cell))) : (React.createElement(StyledTableCell, { key: idx, className: isCellClickable ? classes.isCellClickable : (isSticky ? classes.isSticky : ''), onClick: () => { cellClickCallback && cellClickCallback(cell); } }, makeCell(cell !== null && cell !== void 0 ? cell : '--', index)));
                    }))))))))),
            finalData.length > 10 ? (React.createElement(core_1.TablePagination, { rowsPerPageOptions: [5, 10, 25], component: "div", count: finalData.length, rowsPerPage: rowsPerPage, page: page, onChangePage: handleChangePage, onChangeRowsPerPage: handleChangeRowsPerPage, ActionsComponent: TablePaginationActions, classes: { spacer: classes.spacer } })) : null));
    };
    const renderTable = () => {
        return (React.createElement(React.Fragment, null,
            React.createElement(TableToolbar_1.default, { name: title, showSearchBox: showSearchBox, searchValue: search, handleSearch: (val) => setSearch(val), recordCount: recordsCount }),
            renderTableComponent()));
    };
    const renderTableInAccordion = () => {
        return (React.createElement(React.Fragment, null,
            React.createElement(SimpleAccordion_1.default, { headerTitle: title, showSearchBox: showSearchBox, searchValue: search, handleSearch: (val) => setSearch(val), recordCount: recordsCount, accordionToggleObject: accordionToggleObject }, renderTableComponent())));
    };
    return (React.createElement("div", { className: highlightBackground ? classes.highlightBackground : classes.root }, inAccordionFormat ?
        renderTableInAccordion()
        :
            renderTable()));
}
exports.default = CustomizedTables;


/***/ }),

/***/ "./app/components/TableToolbar.tsx":
/*!*****************************************!*\
  !*** ./app/components/TableToolbar.tsx ***!
  \*****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const React = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const styles_1 = __webpack_require__(/*! @material-ui/core/styles */ "./node_modules/@material-ui/core/esm/styles/index.js");
const SearchBar_1 = __importDefault(__webpack_require__(/*! ./SearchBar */ "./app/components/SearchBar.tsx"));
const HelpOutline_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/HelpOutline */ "./node_modules/@material-ui/icons/HelpOutline.js"));
const useToolbarStyles = styles_1.makeStyles((theme) => ({
    root: {
        paddingLeft: '15px',
        paddingRight: '15px',
        minHeight: 48,
        backgroundColor: 'rgba(66, 133, 244, 0.1)'
    },
    title: {
        flex: '1 1 auto',
        fontWeight: 600,
        letterSpacing: '1px',
        fontSize: '1rem',
        color: '#4285f4'
    },
}));
function TableToolbar({ name, showSearchBox, searchValue, handleSearch, recordCount, showTooltip, tooltipText }) {
    const classes = useToolbarStyles();
    return (React.createElement(core_1.Toolbar, { className: classes.root },
        React.createElement(core_1.Typography, { className: classes.title, variant: "h6", id: "tableTitle", component: "div" }, name.toUpperCase()),
        showSearchBox ? React.createElement(SearchBar_1.default, { value: searchValue, onChange: (e) => handleSearch(e.target.value) }) : React.createElement("strong", null, (recordCount)),
        showTooltip &&
            React.createElement(core_1.Tooltip, { title: tooltipText },
                React.createElement(HelpOutline_1.default, null))));
}
exports.default = TableToolbar;


/***/ }),

/***/ "./app/components/User/AddUser.tsx":
/*!*****************************************!*\
  !*** ./app/components/User/AddUser.tsx ***!
  \*****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const Visibility_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/Visibility */ "./node_modules/@material-ui/icons/Visibility.js"));
const VisibilityOff_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/VisibilityOff */ "./node_modules/@material-ui/icons/VisibilityOff.js"));
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
function AddUser({ tableList, setUserInfo, userProp }) {
    const PERMISSIONS = ["READ", "CREATE", "UPDATE", "DELETE"];
    const [user, setUser] = react_1.useState(Object.assign(Object.assign({}, userProp), { tables: ["DUAL"] }));
    const [tables, setTables] = react_1.useState(tableList);
    const [showPassword, setShowPassword] = react_1.useState(false);
    const handleClickShowPassword = () => {
        setShowPassword(!showPassword);
    };
    const handleMouseDownPassword = (event) => {
        event.preventDefault();
    };
    const changeHandler = (field, e) => {
        let val = e.target.value;
        let userCopy = lodash_1.cloneDeep(user);
        switch (field) {
            case 'username':
                userCopy.username = val;
                break;
            case 'password':
                userCopy.password = val;
                break;
            case 'component':
                userCopy.component = val;
                break;
            case 'role':
                userCopy.role = val;
                break;
            case 'permissions':
                userCopy.permissions = val;
                break;
        }
        setUser(userCopy);
        setUserInfo(userCopy);
    };
    const tableCheckChange = (event) => {
        let name = event.target.name;
        let checked = event.target.checked;
        if (name) {
            let table = lodash_1.cloneDeep(tables);
            if (name === 'ALL' && checked === true) {
                table = table.map(item => {
                    return Object.assign(Object.assign({}, item), { checked: item.name === 'ALL', disabled: item.name !== 'ALL' });
                });
            }
            else if (name === 'ALL' && checked === false) {
                table = table.map(item => {
                    return Object.assign(Object.assign({}, item), { checked: item.name === 'ALL' ? false : item.checked, disabled: false });
                });
            }
            else {
                table = table.map(item => {
                    return Object.assign(Object.assign({}, item), { checked: item.name === name ? checked : item.checked });
                });
            }
            setTables(table);
            let checkedCollection = [];
            for (let item of table) {
                if (item.checked) {
                    checkedCollection.push(item.name);
                }
            }
            let newUser = Object.assign(Object.assign({}, user), { tables: checkedCollection });
            setUser(newUser);
            setUserInfo(newUser);
        }
    };
    const menuItemStyle = {
        fontSize: '16px',
    };
    return (react_1.default.createElement(core_1.DialogContent, { style: { fontSize: '14px' } },
        react_1.default.createElement(core_1.TextField, { autoFocus: true, margin: "dense", id: "name", label: "User Name", fullWidth: true, value: user.username, onChange: (e) => changeHandler('username', e) }),
        react_1.default.createElement(core_1.InputLabel, { htmlFor: "standard-adornment-password", style: { marginTop: '10px' } }, "Password"),
        react_1.default.createElement(core_1.Input, { id: "standard-adornment-password", type: showPassword ? 'text' : 'password', autoComplete: 'new-password', value: user.password, onChange: (e) => changeHandler('password', e), endAdornment: react_1.default.createElement(core_1.InputAdornment, { position: "end" },
                react_1.default.createElement(core_1.IconButton, { "aria-label": "toggle password visibility", onClick: handleClickShowPassword, onMouseDown: handleMouseDownPassword }, showPassword ? react_1.default.createElement(Visibility_1.default, null) : react_1.default.createElement(VisibilityOff_1.default, null))) }),
        react_1.default.createElement(core_1.FormControl, { fullWidth: true, style: { margin: '10px 0' } },
            react_1.default.createElement(core_1.InputLabel, { id: "component" }, "Component"),
            react_1.default.createElement(core_1.Select, { autoWidth: true, labelId: "component", id: "component", value: user.component, label: "Component", required: true, onChange: (e) => changeHandler('component', e) },
                react_1.default.createElement(core_1.MenuItem, { value: 'CONTROLLER', style: menuItemStyle }, "CONTROLLER"),
                react_1.default.createElement(core_1.MenuItem, { value: 'BROKER', style: menuItemStyle }, "BROKER"),
                react_1.default.createElement(core_1.MenuItem, { value: 'SERVER', style: menuItemStyle }, "SERVER"))),
        react_1.default.createElement(core_1.FormControl, { fullWidth: true, style: { margin: '10px 0' } },
            react_1.default.createElement(core_1.InputLabel, { id: "role" }, "Role"),
            react_1.default.createElement(core_1.Select, { labelId: "role", id: "role", value: user.role, required: true, onChange: (e) => changeHandler('role', e) },
                react_1.default.createElement(core_1.MenuItem, { value: 'ADMIN', style: menuItemStyle }, "ADMIN"),
                react_1.default.createElement(core_1.MenuItem, { value: 'USER', style: menuItemStyle }, "USER"))),
        react_1.default.createElement(core_1.FormControl, { fullWidth: true, style: { margin: '10px 0' } },
            react_1.default.createElement(core_1.InputLabel, { id: "permission" }, "Permissions"),
            react_1.default.createElement(core_1.Select, { autoWidth: true, labelId: "permission", id: "permission", value: user.permissions, label: "Permissions", multiple: true, required: true, renderValue: (selected) => selected.join(', '), onChange: (e) => changeHandler('permissions', e) }, PERMISSIONS.map((name) => (react_1.default.createElement(core_1.MenuItem, { key: name, value: name, style: menuItemStyle },
                react_1.default.createElement(core_1.Checkbox, { size: "small", checked: user.permissions.indexOf(name) > -1, color: "primary" }),
                react_1.default.createElement("span", { style: { fontSize: '16px' } }, name)))))),
        react_1.default.createElement(core_1.FormControl, { fullWidth: true, style: { margin: '10px 0' } },
            react_1.default.createElement(core_1.InputLabel, { id: "tables" }, "Tables"),
            react_1.default.createElement(core_1.Select, { labelId: "tables", id: "tables", value: user.tables, multiple: true, required: true, renderValue: (selected) => selected.join(', '), onChange: (e) => changeHandler('tables', e) }, tables.map(table => (react_1.default.createElement(core_1.MenuItem, { key: table.name, value: table.name, style: menuItemStyle },
                react_1.default.createElement(core_1.Checkbox, { checked: table.checked, name: table.name, disabled: table.disabled, size: "small", color: "primary", onChange: tableCheckChange }),
                react_1.default.createElement(core_1.ListItemText, { primary: table.name, style: { fontSize: '14px' } }))))))));
}
exports.default = AddUser;


/***/ }),

/***/ "./app/components/User/UpdateUser.tsx":
/*!********************************************!*\
  !*** ./app/components/User/UpdateUser.tsx ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const Visibility_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/Visibility */ "./node_modules/@material-ui/icons/Visibility.js"));
const VisibilityOff_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/VisibilityOff */ "./node_modules/@material-ui/icons/VisibilityOff.js"));
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
function UpdateUser({ tableList, setUserInfo, userProp }) {
    const PERMISSIONS = ["READ", "CREATE", "UPDATE", "DELETE"];
    const [user, setUser] = react_1.useState(userProp);
    const transferTable = tableList.map(item => {
        return Object.assign(Object.assign({}, item), { checked: !!userProp.tables.includes(item.name) });
    });
    const [tables, setTables] = react_1.useState(transferTable);
    const [showPassword, setShowPassword] = react_1.useState(false);
    const handleClickShowPassword = () => {
        setShowPassword(!showPassword);
    };
    const handleMouseDownPassword = (event) => {
        event.preventDefault();
    };
    const changeHandler = (field, e) => {
        let val = e.target.value;
        let userCopy = lodash_1.cloneDeep(user);
        switch (field) {
            case 'username':
                userCopy.username = val;
                break;
            case 'password':
                userCopy.password = val;
                break;
            case 'component':
                userCopy.component = val;
                break;
            case 'role':
                userCopy.role = val;
                break;
            case 'permissions':
                userCopy.permissions = val;
                break;
        }
        setUser(userCopy);
        setUserInfo(userCopy);
    };
    const tableCheckChange = (event) => {
        let name = event.target.name;
        let checked = event.target.checked;
        if (name) {
            let table = lodash_1.cloneDeep(tables);
            console.log("table: ", table);
            if (name === 'ALL' && checked === true) {
                table = table.map(item => {
                    return Object.assign(Object.assign({}, item), { checked: item.name === 'ALL', disabled: item.name !== 'ALL' });
                });
            }
            else if (name === 'ALL' && checked === false) {
                table = table.map(item => {
                    return Object.assign(Object.assign({}, item), { checked: item.name === 'ALL' ? false : item.checked, disabled: false });
                });
            }
            else {
                table = table.map(item => {
                    return Object.assign(Object.assign({}, item), { checked: item.name === name ? checked : item.checked });
                });
            }
            setTables(table);
            let checkedCollection = [];
            for (let item of table) {
                if (item.checked) {
                    checkedCollection.push(item.name);
                }
            }
            let newUser = Object.assign(Object.assign({}, user), { tables: checkedCollection });
            setUser(newUser);
            setUserInfo(newUser);
        }
    };
    const menuItemStyle = {
        fontSize: '16px',
    };
    const useStyles = core_1.makeStyles({
        text: {
            fontSize: '18px',
            color: 'rgba(0, 0, 0, 0.87)'
        },
        field: {
            marginRight: '10px',
            color: 'rgba(0, 0, 0, 0.57)'
        }
    });
    const classes = useStyles();
    return (react_1.default.createElement(core_1.DialogContent, { style: { fontSize: '14px' } },
        react_1.default.createElement("div", { className: classes.text, style: { marginBottom: '10px' } },
            react_1.default.createElement("span", { className: classes.field }, "User Name:"),
            " ",
            user.username),
        react_1.default.createElement("div", { className: classes.text },
            react_1.default.createElement("span", { className: classes.field }, "Component:"),
            " ",
            user.component),
        react_1.default.createElement(core_1.InputLabel, { htmlFor: "standard-adornment-password", style: { marginTop: '10px' } }, "Password"),
        react_1.default.createElement(core_1.Input, { id: "standard-adornment-password", type: showPassword ? 'text' : 'password', autoComplete: 'new-password', value: user.password, onChange: (e) => changeHandler('password', e), endAdornment: react_1.default.createElement(core_1.InputAdornment, { position: "end" },
                react_1.default.createElement(core_1.IconButton, { "aria-label": "toggle password visibility", onClick: handleClickShowPassword, onMouseDown: handleMouseDownPassword }, showPassword ? react_1.default.createElement(Visibility_1.default, null) : react_1.default.createElement(VisibilityOff_1.default, null))) }),
        react_1.default.createElement(core_1.FormControl, { fullWidth: true, style: { margin: '10px 0' } },
            react_1.default.createElement(core_1.InputLabel, { id: "role" }, "Role"),
            react_1.default.createElement(core_1.Select, { labelId: "role", id: "role", value: user.role, onChange: (e) => changeHandler('role', e) },
                react_1.default.createElement(core_1.MenuItem, { value: 'ADMIN', style: menuItemStyle }, "ADMIN"),
                react_1.default.createElement(core_1.MenuItem, { value: 'USER', style: menuItemStyle }, "USER"))),
        react_1.default.createElement(core_1.FormControl, { fullWidth: true, style: { margin: '10px 0' } },
            react_1.default.createElement(core_1.InputLabel, { id: "permission" }, "Permissions"),
            react_1.default.createElement(core_1.Select, { autoWidth: true, labelId: "permission", id: "permission", value: user.permissions, label: "Permissions", multiple: true, renderValue: (selected) => selected.join(', '), onChange: (e) => changeHandler('permissions', e) }, PERMISSIONS.map((name) => (react_1.default.createElement(core_1.MenuItem, { key: name, value: name, style: menuItemStyle },
                react_1.default.createElement(core_1.Checkbox, { size: "small", checked: user.permissions.indexOf(name) > -1, color: "primary" }),
                react_1.default.createElement("span", { style: { fontSize: '16px' } }, name)))))),
        react_1.default.createElement(core_1.FormControl, { fullWidth: true, style: { margin: '10px 0' } },
            react_1.default.createElement(core_1.InputLabel, { id: "tables" }, "Tables"),
            react_1.default.createElement(core_1.Select, { labelId: "tables", id: "tables", value: user.tables, multiple: true, renderValue: (selected) => selected.join(', '), onChange: (e) => changeHandler('tables', e) }, tables.map(table => (react_1.default.createElement(core_1.MenuItem, { key: table.name, value: table.name, style: menuItemStyle },
                react_1.default.createElement(core_1.Checkbox, { checked: table.checked, name: table.name, disabled: table.disabled, size: "small", color: "primary", onChange: tableCheckChange }),
                react_1.default.createElement(core_1.ListItemText, { primary: table.name, style: { fontSize: '14px' } }))))))));
}
exports.default = UpdateUser;


/***/ }),

/***/ "./app/components/Zookeeper/TreeDirectory.tsx":
/*!****************************************************!*\
  !*** ./app/components/Zookeeper/TreeDirectory.tsx ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/* eslint-disable no-nested-ternary */
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const styles_1 = __webpack_require__(/*! @material-ui/core/styles */ "./node_modules/@material-ui/core/esm/styles/index.js");
const Drawer_1 = __importDefault(__webpack_require__(/*! @material-ui/core/Drawer */ "./node_modules/@material-ui/core/esm/Drawer/index.js"));
const CssBaseline_1 = __importDefault(__webpack_require__(/*! @material-ui/core/CssBaseline */ "./node_modules/@material-ui/core/esm/CssBaseline/index.js"));
const RefreshOutlined_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/RefreshOutlined */ "./node_modules/@material-ui/icons/RefreshOutlined.js"));
const NoteAddOutlined_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/NoteAddOutlined */ "./node_modules/@material-ui/icons/NoteAddOutlined.js"));
const DeleteOutlineOutlined_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/DeleteOutlineOutlined */ "./node_modules/@material-ui/icons/DeleteOutlineOutlined.js"));
const EditOutlined_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/EditOutlined */ "./node_modules/@material-ui/icons/EditOutlined.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const MaterialTree_1 = __importDefault(__webpack_require__(/*! ../MaterialTree */ "./app/components/MaterialTree.tsx"));
const Confirm_1 = __importDefault(__webpack_require__(/*! ../Confirm */ "./app/components/Confirm.tsx"));
const CustomCodemirror_1 = __importDefault(__webpack_require__(/*! ../CustomCodemirror */ "./app/components/CustomCodemirror.tsx"));
const PinotMethodUtils_1 = __importDefault(__webpack_require__(/*! ../../utils/PinotMethodUtils */ "./app/utils/PinotMethodUtils.ts"));
const Utils_1 = __importDefault(__webpack_require__(/*! ../../utils/Utils */ "./app/utils/Utils.tsx"));
const NotificationContext_1 = __webpack_require__(/*! ../Notification/NotificationContext */ "./app/components/Notification/NotificationContext.tsx");
const drawerWidth = 400;
const useStyles = styles_1.makeStyles((theme) => styles_1.createStyles({
    drawer: {
        width: drawerWidth,
        height: 'calc(100vh - 70px)',
        flexShrink: 0,
        backgroundColor: '#333333',
    },
    drawerPaper: {
        position: 'unset',
        width: drawerWidth,
    },
    drawerContainer: {
        overflow: 'auto',
        paddingTop: '20px'
    },
    leftPanel: {
        width: drawerWidth,
        padding: '0 20px'
    },
    buttonGrpDiv: {
        textAlign: 'center'
    },
    btnGroup: {
        marginBottom: '20px'
    },
    typography: {
        padding: theme.spacing(1),
    },
    popover: {
        '& .MuiPopover-paper': {
            backgroundColor: '#4285f4',
            color: 'white',
            overflow: 'visible',
            '&:after': {
                bottom: '100%',
                left: '50%',
                border: 'solid transparent',
                content: '" "',
                height: '0',
                width: '0',
                position: 'absolute',
                pointerEvents: 'none',
                borderBottomColor: '#4285f4',
                borderWidth: '8px',
                marginLeft: '-8px',
                zIndex: '9',
            }
        },
    }
}));
const TreeDirectory = ({ treeData, showChildEvent, selectedNode, expanded, selected, handleToggle, fetchInnerPath, handleSelect, isLeafNodeSelected, currentNodeData, currentNodeMetadata, showInfoEvent }) => {
    const classes = useStyles();
    let newCodeMirrorData = null;
    const [confirmDialog, setConfirmDialog] = react_1.default.useState(false);
    const [dialogTitle, setDialogTitle] = react_1.default.useState(null);
    const [dialogContent, setDialogContent] = react_1.default.useState(null);
    const [dialogSuccessCb, setDialogSuccessCb] = react_1.default.useState(null);
    const [dialogYesLabel, setDialogYesLabel] = react_1.default.useState(null);
    const [dialogNoLabel, setDialogNoLabel] = react_1.default.useState(null);
    const [anchorEl, setAnchorEl] = react_1.default.useState(null);
    const { dispatch } = react_1.default.useContext(NotificationContext_1.NotificationContext);
    const handleClick = (event) => {
        setAnchorEl(event.currentTarget);
    };
    const handleClose = () => {
        setAnchorEl(null);
    };
    const handleEditClick = (event) => {
        if (!isLeafNodeSelected) {
            return;
        }
        newCodeMirrorData = JSON.stringify(currentNodeData);
        setDialogTitle('Update Node Data');
        setDialogContent(react_1.default.createElement(CustomCodemirror_1.default, { data: currentNodeData, isEditable: true, returnCodemirrorValue: (val) => { newCodeMirrorData = val; } }));
        setDialogYesLabel('Update');
        setDialogNoLabel('Cancel');
        setDialogSuccessCb(() => confirmUpdate);
        setConfirmDialog(true);
    };
    const handleDeleteClick = (event) => {
        if (!isLeafNodeSelected) {
            return;
        }
        setDialogContent('Delete this node?');
        setDialogSuccessCb(() => deleteNode);
        setConfirmDialog(true);
    };
    const confirmUpdate = () => {
        setDialogYesLabel('Yes');
        setDialogNoLabel('No');
        setDialogContent('Are you sure want to update this node?');
        setDialogSuccessCb(() => updateNode);
    };
    const updateNode = () => __awaiter(void 0, void 0, void 0, function* () {
        const nodeData = {
            path: selectedNode,
            data: newCodeMirrorData.trim(),
            expectedVersion: currentNodeMetadata.version,
            accessOption: currentNodeMetadata.ephemeralOwner === 0 ? 1 : 10
        };
        const result = yield PinotMethodUtils_1.default.putNodeData(nodeData);
        if (result.data.status) {
            dispatch({
                type: 'success',
                message: result.data.status,
                show: true
            });
            showInfoEvent(selectedNode);
        }
        else {
            dispatch({
                type: 'error',
                message: result.data.error,
                show: true
            });
        }
        closeDialog();
    });
    const deleteNode = () => __awaiter(void 0, void 0, void 0, function* () {
        const parentPath = selectedNode.split('/').slice(0, selectedNode.split('/').length - 1).join('/');
        const treeObj = Utils_1.default.findNestedObj(treeData, 'fullPath', parentPath);
        const result = yield PinotMethodUtils_1.default.deleteNode(selectedNode);
        if (result.data.status) {
            dispatch({
                type: 'success',
                message: result.data.status,
                show: true
            });
            showInfoEvent(selectedNode);
            fetchInnerPath(treeObj);
        }
        else {
            dispatch({
                type: 'error',
                message: result.data.error,
                show: true
            });
        }
        closeDialog();
    });
    const closeDialog = () => {
        setConfirmDialog(false);
        setDialogContent(null);
        setDialogTitle(null);
        setDialogYesLabel(null);
        setDialogNoLabel(null);
    };
    const open = Boolean(anchorEl);
    const id = open ? 'simple-popover' : undefined;
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(CssBaseline_1.default, null),
        react_1.default.createElement(Drawer_1.default, { open: false, className: classes.drawer, variant: "permanent", classes: {
                paper: classes.drawerPaper,
            } },
            react_1.default.createElement("div", { className: classes.drawerContainer },
                react_1.default.createElement(core_1.Grid, { item: true, xs: true, className: classes.leftPanel },
                    react_1.default.createElement("div", { className: classes.buttonGrpDiv },
                        react_1.default.createElement(core_1.ButtonGroup, { color: "primary", "aria-label": "outlined primary button group", className: classes.btnGroup },
                            react_1.default.createElement(core_1.Tooltip, { title: "Refresh" },
                                react_1.default.createElement(core_1.Button, { onClick: (e) => { showInfoEvent(selectedNode); } },
                                    react_1.default.createElement(RefreshOutlined_1.default, null))),
                            react_1.default.createElement(core_1.Tooltip, { title: "Add" },
                                react_1.default.createElement(core_1.Button, { onClick: handleClick },
                                    react_1.default.createElement(NoteAddOutlined_1.default, null))),
                            react_1.default.createElement(core_1.Tooltip, { title: "Delete", open: false },
                                react_1.default.createElement(core_1.Button, { onClick: handleDeleteClick, disabled: !isLeafNodeSelected },
                                    react_1.default.createElement(DeleteOutlineOutlined_1.default, null))),
                            react_1.default.createElement(core_1.Tooltip, { title: "Edit", open: false },
                                react_1.default.createElement(core_1.Button, { onClick: handleEditClick, disabled: !isLeafNodeSelected },
                                    react_1.default.createElement(EditOutlined_1.default, null))))),
                    react_1.default.createElement(core_1.Popover, { id: id, open: open, anchorEl: anchorEl, onClose: handleClose, anchorOrigin: {
                            vertical: 'bottom',
                            horizontal: 'center',
                        }, transformOrigin: {
                            vertical: 'top',
                            horizontal: 'center',
                        }, className: classes.popover },
                        react_1.default.createElement(core_1.Typography, { className: classes.typography }, "Functionality Coming Soon.")),
                    react_1.default.createElement(MaterialTree_1.default, { treeData: treeData, showChildEvent: showChildEvent, expanded: expanded, selected: selected, handleToggle: handleToggle, handleSelect: handleSelect })))),
        react_1.default.createElement(Confirm_1.default, { openDialog: confirmDialog, dialogTitle: dialogTitle, dialogContent: dialogContent, successCallback: dialogSuccessCb, closeDialog: closeDialog, dialogYesLabel: dialogYesLabel, dialogNoLabel: dialogNoLabel })));
};
exports.default = TreeDirectory;


/***/ }),

/***/ "./app/components/auth/AuthProvider.tsx":
/*!**********************************************!*\
  !*** ./app/components/auth/AuthProvider.tsx ***!
  \**********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const react_router_1 = __webpack_require__(/*! react-router */ "./node_modules/react-router/esm/react-router.js");
const axios_config_1 = __webpack_require__(/*! ../../utils/axios-config */ "./app/utils/axios-config.ts");
const PinotMethodUtils_1 = __importDefault(__webpack_require__(/*! ../../utils/PinotMethodUtils */ "./app/utils/PinotMethodUtils.ts"));
const AppLoadingIndicator_1 = __webpack_require__(/*! ../AppLoadingIndicator */ "./app/components/AppLoadingIndicator.tsx");
exports.AuthProvider = ({ children }) => {
    const [loading, setLoading] = react_1.useState(true);
    const [redirectUri, setRedirectUri] = react_1.useState(null);
    const [clientId, setClientId] = react_1.useState(null);
    const [authWorkflow, setAuthWorkflow] = react_1.useState(null);
    const [accessToken, setAccessToken] = react_1.useState("");
    const [authUserName, setAuthUserName] = react_1.useState("");
    const [authUserEmail, setAuthUserEmail] = react_1.useState("");
    const [authenticated, setAuthenticated] = react_1.useState(false);
    const [authorizationEndpoint, setAuthorizationEndpoint] = react_1.useState(null);
    const [autoLogout, setAutoLogout] = react_1.useState(false);
    const history = react_router_1.useHistory();
    const location = react_router_1.useLocation();
    const [axiosRequestInterceptorIds, setAxiosRequestInterceptorIds] = react_1.useState([0, 1]);
    const [axiosResponseInterceptorIds, setAxiosResponseInterceptorIds] = react_1.useState([0, 1]);
    const oidcSignInFormRef = react_1.default.useRef(null);
    react_1.useEffect(() => {
        initAuthDetails();
    }, []);
    react_1.useEffect(() => {
        if (loading || authenticated) {
            return;
        }
        initOidcAuth();
    }, [loading, authenticated]);
    react_1.useEffect(() => {
        if (!autoLogout) {
            return;
        }
        submitLoginForm();
    }, [autoLogout]);
    const initAuthDetails = () => __awaiter(void 0, void 0, void 0, function* () {
        // fetch auth info details
        const authInfoResponse = yield PinotMethodUtils_1.default.getAuthInfo();
        const authWorkFlowInternal = authInfoResponse && authInfoResponse.workflow
            ? authInfoResponse.workflow
            : "NONE" /* NONE */;
        // set auth workflow
        setAuthWorkflow(authWorkFlowInternal);
        if (authWorkFlowInternal === "NONE" /* NONE */) {
            // No authentication required
            setAuthenticated(true);
        }
        if (authWorkFlowInternal === "BASIC" /* BASIC */) {
            // basic auth is handled by login page
        }
        // set OIDC auth details 
        if (authWorkFlowInternal === "OIDC" /* OIDC */) {
            const issuer = authInfoResponse && authInfoResponse.issuer ? authInfoResponse.issuer : '';
            setAuthorizationEndpoint(`${issuer}/auth`);
            setRedirectUri(authInfoResponse && authInfoResponse.redirectUri
                ? authInfoResponse.redirectUri
                : '');
            setClientId(authInfoResponse && authInfoResponse.clientId
                ? authInfoResponse.clientId
                : '');
        }
        // auth loading complete
        setLoading(false);
    });
    const initOidcAuth = () => {
        // access token already available in the localStorage
        const accessToken = getAuthLocalStorageValue("AccessToken" /* AccessToken */);
        if (accessToken) {
            setAccessToken(accessToken);
            setAuthUserName(PinotMethodUtils_1.default.getAuthUserNameFromAccessToken(accessToken.replace("Bearer ", "")));
            setAuthUserEmail(PinotMethodUtils_1.default.getAuthUserEmailFromAccessToken(accessToken.replace("Bearer ", "")));
            initAxios(accessToken);
            setAuthenticated(true);
            return;
        }
        // access token available in hash params
        const accessTokenFromHashParam = PinotMethodUtils_1.default.getAccessTokenFromHashParams();
        if (accessTokenFromHashParam) {
            const accessToken = `Bearer ${accessTokenFromHashParam}`;
            setAccessToken(accessToken);
            setAuthUserName(PinotMethodUtils_1.default.getAuthUserNameFromAccessToken(accessTokenFromHashParam));
            setAuthUserEmail(PinotMethodUtils_1.default.getAuthUserEmailFromAccessToken(accessTokenFromHashParam));
            setAuthLocalStorageValue("AccessToken" /* AccessToken */, accessToken);
            initAxios(accessToken);
            setAuthenticated(true);
            redirectToApp();
            return;
        }
        // no access token available
        const redirectPathAfterLogin = location.pathname;
        // save current path to redirect after login
        setAuthLocalStorageValue("redirectLocation" /* RedirectLocation */, redirectPathAfterLogin);
        // login
        submitLoginForm();
    };
    const submitLoginForm = () => {
        // submit auth login form
        if (clientId && authorizationEndpoint && redirectUri && oidcSignInFormRef && oidcSignInFormRef.current) {
            oidcSignInFormRef.current.submit();
        }
    };
    const handleUnauthenticatedAccess = () => {
        setAuthLocalStorageValue("AccessToken" /* AccessToken */, "");
        setAuthLocalStorageValue("redirectLocation" /* RedirectLocation */, "");
        setAutoLogout(true);
    };
    // initialize axios instance with authToken
    const initAxios = (accessToken) => {
        // Clear existing interceptors
        axios_config_1.baseApi.interceptors.request.eject(axiosRequestInterceptorIds[0]);
        axios_config_1.baseApi.interceptors.response.eject(axiosResponseInterceptorIds[0]);
        axios_config_1.transformApi.interceptors.request.eject(axiosRequestInterceptorIds[1]);
        axios_config_1.transformApi.interceptors.response.eject(axiosResponseInterceptorIds[1]);
        const requestInterceptorId1 = axios_config_1.baseApi.interceptors.request.use(axios_config_1.getAxiosRequestInterceptor(accessToken), axios_config_1.getAxiosErrorInterceptor(handleUnauthenticatedAccess));
        const requestInterceptorId2 = axios_config_1.transformApi.interceptors.request.use(axios_config_1.getAxiosRequestInterceptor(accessToken), axios_config_1.getAxiosErrorInterceptor(handleUnauthenticatedAccess));
        const responseInterceptor1 = axios_config_1.baseApi.interceptors.response.use(axios_config_1.getAxiosResponseInterceptor(), axios_config_1.getAxiosErrorInterceptor(handleUnauthenticatedAccess));
        const responseInterceptor2 = axios_config_1.transformApi.interceptors.response.use(axios_config_1.getAxiosResponseInterceptor(), axios_config_1.getAxiosErrorInterceptor(handleUnauthenticatedAccess));
        // Set new interceptors
        setAxiosRequestInterceptorIds([requestInterceptorId1, requestInterceptorId2]);
        setAxiosResponseInterceptorIds([responseInterceptor1, responseInterceptor2]);
    };
    // redirect to app with appropriate location after login
    const redirectToApp = () => {
        const redirectLocation = getAuthLocalStorageValue("redirectLocation" /* RedirectLocation */);
        if (redirectLocation && redirectLocation !== "/login" && redirectLocation !== "/logout") {
            setAuthLocalStorageValue("redirectLocation" /* RedirectLocation */, "");
            history.push(redirectLocation);
        }
    };
    const getAuthLocalStorageValue = (key) => {
        return (localStorage.getItem(key) || "");
    };
    const setAuthLocalStorageValue = (key, value) => {
        localStorage.setItem(key, value);
    };
    const authProvider = {
        authWorkflow: authWorkflow,
        accessToken: accessToken,
        authUserName: authUserName,
        authUserEmail: authUserEmail,
        authenticated: authenticated
    };
    if (loading) {
        return react_1.default.createElement(AppLoadingIndicator_1.AppLoadingIndicator, null);
    }
    return (react_1.default.createElement(AuthProviderContext.Provider, { value: authProvider },
        children,
        authWorkflow === "OIDC" /* OIDC */ && (react_1.default.createElement("div", null,
            react_1.default.createElement("form", { hidden: true, 
                // When the user is automatically logged out, attaching automatic-logout=true
                // query parameter displays appropriate message to the user (dex only)
                action: `${authorizationEndpoint && authorizationEndpoint}?automatic-logout=${autoLogout}`, method: "post", ref: oidcSignInFormRef },
                react_1.default.createElement("input", { readOnly: true, name: "response_type", value: "token id_token" }),
                react_1.default.createElement("input", { readOnly: true, name: "client_id", value: clientId }),
                react_1.default.createElement("input", { readOnly: true, name: "redirect_uri", value: redirectUri }),
                react_1.default.createElement("input", { readOnly: true, name: "scope", value: "openid email profile groups" }),
                react_1.default.createElement("input", { readOnly: true, name: "state", value: "true-redirect-uri" }),
                react_1.default.createElement("input", { readOnly: true, name: "nonce", value: "random_string" }),
                react_1.default.createElement("input", { type: "submit", value: "" }))))));
};
const AuthProviderContext = react_1.createContext({});
exports.useAuthProvider = () => {
    return react_1.useContext(AuthProviderContext);
};


/***/ }),

/***/ "./app/components/useMinionMetaData.tsx":
/*!**********************************************!*\
  !*** ./app/components/useMinionMetaData.tsx ***!
  \**********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const react_codemirror2_1 = __webpack_require__(/*! react-codemirror2 */ "./node_modules/react-codemirror2/index.js");
const SimpleAccordion_1 = __importDefault(__webpack_require__(/*! ./SimpleAccordion */ "./app/components/SimpleAccordion.tsx"));
const PinotMethodUtils_1 = __importDefault(__webpack_require__(/*! ../utils/PinotMethodUtils */ "./app/utils/PinotMethodUtils.ts"));
const jsonoptions = {
    lineNumbers: true,
    mode: 'application/json',
    styleActiveLine: true,
    gutters: ['CodeMirror-lint-markers'],
    theme: 'default',
    readOnly: true
};
const useStyles = core_1.makeStyles(() => ({
    queryOutput: {
        border: '1px solid #BDCCD9',
        '& .CodeMirror': { height: 532 },
    },
}));
function useMinionMetadata(props) {
    const classes = useStyles();
    const { taskType, tableName } = props;
    const [metadata, setMetadata] = react_1.useState({});
    const fetchData = () => __awaiter(this, void 0, void 0, function* () {
        const metadataRes = yield PinotMethodUtils_1.default.getMinionMetaData(tableName, taskType);
        setMetadata(metadataRes);
    });
    react_1.useEffect(() => {
        fetchData();
    }, []);
    return {
        metadata,
        setMetadata,
        content: (react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Minion Metadata", showSearchBox: false },
            react_1.default.createElement(react_codemirror2_1.UnControlled, { options: jsonoptions, value: JSON.stringify(metadata || {}, null, '  '), className: classes.queryOutput, autoCursor: false })))
    };
}
exports.default = useMinionMetadata;


/***/ }),

/***/ "./app/components/useScheduleAdhocModal.tsx":
/*!**************************************************!*\
  !*** ./app/components/useScheduleAdhocModal.tsx ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const react_codemirror2_1 = __webpack_require__(/*! react-codemirror2 */ "./node_modules/react-codemirror2/index.js");
const CustomDialog_1 = __importDefault(__webpack_require__(/*! ./CustomDialog */ "./app/components/CustomDialog.tsx"));
const PinotMethodUtils_1 = __importDefault(__webpack_require__(/*! ../utils/PinotMethodUtils */ "./app/utils/PinotMethodUtils.ts"));
const jsonoptions = {
    lineNumbers: true,
    mode: 'application/json',
    styleActiveLine: true,
    gutters: ['CodeMirror-lint-markers'],
    theme: 'default',
};
const useStyles = core_1.makeStyles(() => ({
    queryOutput: {
        border: '1px solid #BDCCD9',
        '& .CodeMirror': { height: 532 },
    },
}));
function useScheduleAdhocModal() {
    const classes = useStyles();
    const [open, setOpen] = react_1.useState(false);
    const [value, setValue] = react_1.useState(`{}`);
    const handleClose = () => setOpen(false);
    const handleOpen = () => setOpen(true);
    const handleSheduleAdhoc = () => __awaiter(this, void 0, void 0, function* () {
        const res = yield PinotMethodUtils_1.default.executeTaskAction(value);
        handleClose();
    });
    const dialog = (react_1.default.createElement(CustomDialog_1.default, { open: open, handleClose: handleClose, handleSave: handleSheduleAdhoc, title: `Schedule Adhoc`, size: "md", disableBackdropClick: true, disableEscapeKeyDown: true },
        react_1.default.createElement(core_1.DialogContent, null,
            react_1.default.createElement(react_codemirror2_1.UnControlled, { options: jsonoptions, value: value, className: classes.queryOutput, autoCursor: false, onChange: (editor, d, value) => {
                    setValue(value);
                } }))));
    return {
        handleOpen,
        handleClose,
        handleSheduleAdhoc,
        dialog
    };
}
exports.default = useScheduleAdhocModal;


/***/ }),

/***/ "./app/components/useTaskListing.tsx":
/*!*******************************************!*\
  !*** ./app/components/useTaskListing.tsx ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const Table_1 = __importDefault(__webpack_require__(/*! ./Table */ "./app/components/Table.tsx"));
const PinotMethodUtils_1 = __importDefault(__webpack_require__(/*! ../utils/PinotMethodUtils */ "./app/utils/PinotMethodUtils.ts"));
function useTaskListing(props) {
    const { taskType, tableName } = props;
    const [fetching, setFetching] = react_1.useState(true);
    const [tasks, setTasks] = react_1.useState({ records: [], columns: [] });
    const fetchData = () => __awaiter(this, void 0, void 0, function* () {
        setFetching(true);
        const tasksRes = yield PinotMethodUtils_1.default.getTasksList(tableName, taskType);
        setTasks(tasksRes);
        setFetching(false);
    });
    react_1.useEffect(() => {
        fetchData();
    }, []);
    return {
        tasks,
        setTasks,
        content: !fetching && (react_1.default.createElement(Table_1.default, { title: "Tasks", data: tasks, showSearchBox: true, inAccordionFormat: true, addLinks: true, baseURL: `/task-queue/${taskType}/tables/${tableName}/task/` }))
    };
}
exports.default = useTaskListing;


/***/ }),

/***/ "./app/index.tsx":
/*!***********************!*\
  !*** ./app/index.tsx ***!
  \***********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const AuthProvider_1 = __webpack_require__(/*! ./components/auth/AuthProvider */ "./app/components/auth/AuthProvider.tsx");
const CustomNotification_1 = __importDefault(__webpack_require__(/*! ./components/CustomNotification */ "./app/components/CustomNotification.tsx"));
const NotificationContextProvider_1 = __webpack_require__(/*! ./components/Notification/NotificationContextProvider */ "./app/components/Notification/NotificationContextProvider.tsx");
const theme_1 = __importDefault(__webpack_require__(/*! ./theme */ "./app/theme/index.ts"));
const react_1 = __importDefault(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const react_dom_1 = __importDefault(__webpack_require__(/*! react-dom */ "./node_modules/react-dom/index.js"));
const App_1 = __webpack_require__(/*! ./App */ "./app/App.tsx");
const react_router_dom_1 = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router-dom/esm/react-router-dom.js");
react_dom_1.default.render(react_1.default.createElement(react_router_dom_1.HashRouter, null,
    react_1.default.createElement(core_1.MuiThemeProvider, { theme: theme_1.default },
        react_1.default.createElement(NotificationContextProvider_1.NotificationContextProvider, null,
            react_1.default.createElement(CustomNotification_1.default, null),
            react_1.default.createElement(AuthProvider_1.AuthProvider, null,
                react_1.default.createElement(App_1.App, null))))), document.getElementById('app'));


/***/ }),

/***/ "./app/pages/HomePage.tsx":
/*!********************************!*\
  !*** ./app/pages/HomePage.tsx ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const react_router_dom_1 = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router-dom/esm/react-router-dom.js");
const PinotMethodUtils_1 = __importDefault(__webpack_require__(/*! ../utils/PinotMethodUtils */ "./app/utils/PinotMethodUtils.ts"));
const TenantsListing_1 = __importDefault(__webpack_require__(/*! ../components/Homepage/TenantsListing */ "./app/components/Homepage/TenantsListing.tsx"));
const InstancesTables_1 = __importDefault(__webpack_require__(/*! ../components/Homepage/InstancesTables */ "./app/components/Homepage/InstancesTables.tsx"));
const ClusterConfig_1 = __importDefault(__webpack_require__(/*! ../components/Homepage/ClusterConfig */ "./app/components/Homepage/ClusterConfig.tsx"));
const useTaskTypesTable_1 = __importDefault(__webpack_require__(/*! ../components/Homepage/useTaskTypesTable */ "./app/components/Homepage/useTaskTypesTable.tsx"));
const Skeleton_1 = __importDefault(__webpack_require__(/*! @material-ui/lab/Skeleton */ "./node_modules/@material-ui/lab/esm/Skeleton/index.js"));
const requests_1 = __webpack_require__(/*! ../requests */ "./app/requests/index.ts");
const useStyles = core_1.makeStyles((theme) => ({
    paper: {
        display: 'flex',
        flexDirection: 'column',
        justifyContent: 'center',
        alignItems: 'center',
        padding: '10px 0',
        height: '100%',
        color: '#4285f4',
        borderRadius: 4,
        marginBottom: 15,
        textAlign: 'center',
        backgroundColor: 'rgba(66, 133, 244, 0.1)',
        borderColor: 'rgba(66, 133, 244, 0.5)',
        borderStyle: 'solid',
        borderWidth: '1px',
        '& h2, h4': {
            margin: 0,
        },
        '& h4': {
            textTransform: 'uppercase',
            letterSpacing: 1,
            fontWeight: 600,
        },
        '&:hover': {
            borderColor: '#4285f4',
        },
    },
    gridContainer: {
        padding: 20,
        backgroundColor: 'white',
        maxHeight: 'calc(100vh - 70px)',
        overflowY: 'auto',
    },
    paperLinks: {
        textDecoration: 'none',
        height: '100%',
    },
}));
const HomePage = () => {
    var _a;
    const classes = useStyles();
    const [clusterName, setClusterName] = react_1.useState('');
    const [fetchingTenants, setFetchingTenants] = react_1.useState(true);
    const [tenantsCount, setTenantscount] = react_1.useState(0);
    const [fetchingInstances, setFetchingInstances] = react_1.useState(true);
    const [controllerCount, setControllerCount] = react_1.useState(0);
    const [brokerCount, setBrokerCount] = react_1.useState(0);
    const [serverCount, setServerCount] = react_1.useState(0);
    const [minionCount, setMinionCount] = react_1.useState(0);
    // const [instances, setInstances] = useState<DataTable>();
    const [fetchingTables, setFetchingTables] = react_1.useState(true);
    const [tablesCount, setTablesCount] = react_1.useState(0);
    const { taskTypes, taskTypesTable } = useTaskTypesTable_1.default();
    const fetchData = () => __awaiter(void 0, void 0, void 0, function* () {
        PinotMethodUtils_1.default.getAllInstances().then((res) => {
            setControllerCount(lodash_1.get(res, 'Controller', []).length);
            setBrokerCount(lodash_1.get(res, 'Broker', []).length);
            setServerCount(lodash_1.get(res, 'Server', []).length);
            setMinionCount(lodash_1.get(res, 'Minion', []).length);
            setFetchingInstances(false);
        });
        PinotMethodUtils_1.default.getQueryTablesList({ bothType: true }).then((res) => {
            setTablesCount(res.records.length);
            setFetchingTables(false);
        });
        requests_1.getTenants().then((res) => {
            const tenantNames = lodash_1.union(res.data.SERVER_TENANTS, res.data.BROKER_TENANTS);
            setTenantscount(tenantNames.length);
            setFetchingTenants(false);
        });
        fetchClusterName().then((clusterNameRes) => {
            setClusterName(clusterNameRes);
        });
    });
    const fetchClusterName = () => {
        let clusterNameRes = localStorage.getItem('pinot_ui:clusterName');
        if (!clusterNameRes) {
            return PinotMethodUtils_1.default.getClusterName();
        }
        else {
            return Promise.resolve(clusterNameRes);
        }
    };
    react_1.useEffect(() => {
        fetchData();
    }, []);
    const loading = react_1.default.createElement(Skeleton_1.default, { animation: 'wave', width: 50 });
    return (react_1.default.createElement(core_1.Grid, { item: true, xs: true, className: classes.gridContainer },
        react_1.default.createElement(core_1.Grid, { container: true, spacing: 3 },
            react_1.default.createElement(core_1.Grid, { item: true, xs: 3 },
                react_1.default.createElement(react_router_dom_1.Link, { to: "/controllers", className: classes.paperLinks },
                    react_1.default.createElement(core_1.Paper, { className: classes.paper },
                        react_1.default.createElement("h4", null, "Controllers"),
                        react_1.default.createElement("h2", null, fetchingInstances ? loading : controllerCount)))),
            react_1.default.createElement(core_1.Grid, { item: true, xs: 3 },
                react_1.default.createElement(react_router_dom_1.Link, { to: "/brokers", className: classes.paperLinks },
                    react_1.default.createElement(core_1.Paper, { className: classes.paper },
                        react_1.default.createElement("h4", null, "Brokers"),
                        react_1.default.createElement("h2", null, fetchingInstances ? loading : brokerCount)))),
            react_1.default.createElement(core_1.Grid, { item: true, xs: 3 },
                react_1.default.createElement(react_router_dom_1.Link, { to: "/servers", className: classes.paperLinks },
                    react_1.default.createElement(core_1.Paper, { className: classes.paper },
                        react_1.default.createElement("h4", null, "Servers"),
                        react_1.default.createElement("h2", null, fetchingInstances ? loading : serverCount)))),
            react_1.default.createElement(core_1.Grid, { item: true, xs: 3 },
                react_1.default.createElement(react_router_dom_1.Link, { to: "/minions", className: classes.paperLinks },
                    react_1.default.createElement(core_1.Paper, { className: classes.paper },
                        react_1.default.createElement("h4", null, "Minions"),
                        react_1.default.createElement("h2", null, fetchingInstances ? loading : minionCount)))),
            react_1.default.createElement(core_1.Grid, { item: true, xs: 3 },
                react_1.default.createElement(react_router_dom_1.Link, { to: "/tenants", className: classes.paperLinks },
                    react_1.default.createElement(core_1.Paper, { className: classes.paper },
                        react_1.default.createElement("h4", null, "Tenants"),
                        react_1.default.createElement("h2", null, fetchingTenants ? loading : tenantsCount)))),
            react_1.default.createElement(core_1.Grid, { item: true, xs: 3 },
                react_1.default.createElement(react_router_dom_1.Link, { to: "/tables", className: classes.paperLinks },
                    react_1.default.createElement(core_1.Paper, { className: classes.paper },
                        react_1.default.createElement("h4", null, "Tables"),
                        react_1.default.createElement("h2", null, fetchingTables ? loading : tablesCount)))),
            react_1.default.createElement(core_1.Grid, { item: true, xs: 3 },
                react_1.default.createElement(react_router_dom_1.Link, { to: "/minion-task-manager", className: classes.paperLinks },
                    react_1.default.createElement(core_1.Paper, { className: classes.paper },
                        react_1.default.createElement("h4", null, "Minion Task Manager"),
                        react_1.default.createElement("h2", null, Array.isArray(taskTypes.records)
                            ? (_a = taskTypes === null || taskTypes === void 0 ? void 0 : taskTypes.records) === null || _a === void 0 ? void 0 : _a.length : 0))))),
        react_1.default.createElement(core_1.Box, { mb: 3 }),
        react_1.default.createElement(TenantsListing_1.default, null),
        react_1.default.createElement(InstancesTables_1.default, { clusterName: clusterName }),
        taskTypesTable,
        react_1.default.createElement(ClusterConfig_1.default, null)));
};
exports.default = HomePage;


/***/ }),

/***/ "./app/pages/InstanceDetails.tsx":
/*!***************************************!*\
  !*** ./app/pages/InstanceDetails.tsx ***!
  \***************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const react_codemirror2_1 = __webpack_require__(/*! react-codemirror2 */ "./node_modules/react-codemirror2/index.js");
__webpack_require__(/*! codemirror/lib/codemirror.css */ "./node_modules/codemirror/lib/codemirror.css");
__webpack_require__(/*! codemirror/theme/material.css */ "./node_modules/codemirror/theme/material.css");
__webpack_require__(/*! codemirror/mode/javascript/javascript */ "./node_modules/codemirror/mode/javascript/javascript.js");
const PinotMethodUtils_1 = __importDefault(__webpack_require__(/*! ../utils/PinotMethodUtils */ "./app/utils/PinotMethodUtils.ts"));
const AppLoader_1 = __importDefault(__webpack_require__(/*! ../components/AppLoader */ "./app/components/AppLoader.tsx"));
const SimpleAccordion_1 = __importDefault(__webpack_require__(/*! ../components/SimpleAccordion */ "./app/components/SimpleAccordion.tsx"));
const CustomButton_1 = __importDefault(__webpack_require__(/*! ../components/CustomButton */ "./app/components/CustomButton.tsx"));
const EditTagsOp_1 = __importDefault(__webpack_require__(/*! ../components/Homepage/Operations/EditTagsOp */ "./app/components/Homepage/Operations/EditTagsOp.tsx"));
const EditConfigOp_1 = __importDefault(__webpack_require__(/*! ../components/Homepage/Operations/EditConfigOp */ "./app/components/Homepage/Operations/EditConfigOp.tsx"));
const NotificationContext_1 = __webpack_require__(/*! ../components/Notification/NotificationContext */ "./app/components/Notification/NotificationContext.tsx");
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const Confirm_1 = __importDefault(__webpack_require__(/*! ../components/Confirm */ "./app/components/Confirm.tsx"));
const Utils_1 = __webpack_require__(/*! ../utils/Utils */ "./app/utils/Utils.tsx");
const AsyncPinotTables_1 = __importDefault(__webpack_require__(/*! ../components/AsyncPinotTables */ "./app/components/AsyncPinotTables.tsx"));
const NotFound_1 = __importDefault(__webpack_require__(/*! ../components/NotFound */ "./app/components/NotFound.tsx"));
const useStyles = core_1.makeStyles((theme) => ({
    codeMirrorDiv: {
        border: '1px #BDCCD9 solid',
        borderRadius: 4,
        marginBottom: '20px',
    },
    codeMirror: {
        '& .CodeMirror': { maxHeight: 430, border: '1px solid #BDCCD9' },
    },
    operationDiv: {
        border: '1px #BDCCD9 solid',
        borderRadius: 4,
        marginBottom: 20,
    },
}));
const jsonoptions = {
    lineNumbers: true,
    mode: 'application/json',
    styleActiveLine: true,
    gutters: ['CodeMirror-lint-markers'],
    theme: 'default',
    readOnly: true,
};
const InstanceDetails = ({ match }) => {
    const classes = useStyles();
    const { instanceName } = match.params;
    const instanceType = Utils_1.getInstanceTypeFromInstanceName(instanceName);
    const clusterName = localStorage.getItem('pinot_ui:clusterName');
    const [fetching, setFetching] = react_1.useState(true);
    const [instanceNotFound, setInstanceNotFound] = react_1.useState(false);
    const [confirmDialog, setConfirmDialog] = react_1.default.useState(false);
    const [dialogDetails, setDialogDetails] = react_1.default.useState(null);
    const [instanceConfig, setInstanceConfig] = react_1.useState(null);
    const [liveConfig, setLiveConfig] = react_1.useState(null);
    const [instanceDetails, setInstanceDetails] = react_1.useState(null);
    const [tagsList, setTagsList] = react_1.useState([]);
    const [tagsErrorObj, setTagsErrorObj] = react_1.useState({
        isError: false,
        errorMessage: null,
    });
    const [config, setConfig] = react_1.useState('{}');
    const [state, setState] = react_1.default.useState({
        enabled: true,
    });
    const [showEditTag, setShowEditTag] = react_1.useState(false);
    const [showEditConfig, setShowEditConfig] = react_1.useState(false);
    const { dispatch } = react_1.default.useContext(NotificationContext_1.NotificationContext);
    const fetchData = () => __awaiter(void 0, void 0, void 0, function* () {
        const configResponse = yield PinotMethodUtils_1.default.getInstanceConfig(clusterName, instanceName);
        if ((configResponse === null || configResponse === void 0 ? void 0 : configResponse.code) === 404) {
            setInstanceNotFound(true);
        }
        else {
            const liveConfigResponse = yield PinotMethodUtils_1.default.getLiveInstanceConfig(clusterName, instanceName);
            const instanceDetails = yield PinotMethodUtils_1.default.getInstanceDetails(instanceName);
            setInstanceConfig(JSON.stringify(configResponse, null, 2));
            const instanceHost = instanceDetails.hostName.replace(`${lodash_1.startCase(instanceType.toLowerCase())}_`, '');
            const instancePutObj = {
                host: instanceHost,
                port: instanceDetails.port,
                type: instanceType,
                tags: instanceDetails.tags,
                pools: instanceDetails.pools,
                grpcPort: instanceDetails.grpcPort,
                adminPort: instanceDetails.adminPort,
                queryServicePort: instanceDetails.queryServicePort,
                queryMailboxPort: instanceDetails.queryMailboxPort,
                queriesDisabled: instanceDetails.queriesDisabled,
            };
            setState({ enabled: instanceDetails.enabled });
            setInstanceDetails(JSON.stringify(instancePutObj, null, 2));
            setLiveConfig(JSON.stringify(liveConfigResponse, null, 2));
        }
        setFetching(false);
    });
    react_1.useEffect(() => {
        fetchData();
    }, []);
    const handleTagsChange = (e, tags) => {
        isTagsValid(tags);
        setTagsList(tags);
    };
    const isTagsValid = (_tagsList) => {
        let isValid = true;
        setTagsErrorObj({ isError: false, errorMessage: null });
        _tagsList.map((tag) => {
            if (!isValid) {
                return;
            }
            if (instanceType === "broker" /* BROKER */) {
                if (!tag.endsWith('_BROKER')) {
                    isValid = false;
                    setTagsErrorObj({
                        isError: true,
                        errorMessage: 'Tags should end with _BROKER.',
                    });
                }
            }
            else if (instanceType === "server" /* SERVER */) {
                if (!tag.endsWith('_REALTIME') && !tag.endsWith('_OFFLINE')) {
                    isValid = false;
                    setTagsErrorObj({
                        isError: true,
                        errorMessage: 'Tags should end with _OFFLINE or _REALTIME.',
                    });
                }
            }
        });
        return isValid;
    };
    const saveTagsAction = (event, typedTag) => __awaiter(void 0, void 0, void 0, function* () {
        let newTagsList = [...tagsList];
        if (typedTag.length > 0) {
            newTagsList.push(typedTag);
        }
        if (!isTagsValid(newTagsList)) {
            return;
        }
        const result = yield PinotMethodUtils_1.default.updateTags(instanceName, newTagsList);
        if (result.status) {
            dispatch({ type: 'success', message: result.status, show: true });
            fetchData();
        }
        else {
            dispatch({ type: 'error', message: result.error, show: true });
        }
        setShowEditTag(false);
    });
    const handleDropAction = () => {
        setDialogDetails({
            title: 'Drop Instance',
            content: 'Are you sure want to drop this instance?',
            successCb: () => dropInstance(),
        });
        setConfirmDialog(true);
    };
    const dropInstance = () => __awaiter(void 0, void 0, void 0, function* () {
        const result = yield PinotMethodUtils_1.default.deleteInstance(instanceName);
        if (result.status) {
            dispatch({ type: 'success', message: result.status, show: true });
            fetchData();
        }
        else {
            dispatch({ type: 'error', message: result.error, show: true });
        }
        closeDialog();
    });
    const handleSwitchChange = (event) => {
        setDialogDetails({
            title: state.enabled ? 'Disable Instance' : 'Enable Instance',
            content: `Are you sure want to ${state.enabled ? 'disable' : 'enable'} this instance?`,
            successCb: () => toggleInstanceState(),
        });
        setConfirmDialog(true);
    };
    const toggleInstanceState = () => __awaiter(void 0, void 0, void 0, function* () {
        const result = yield PinotMethodUtils_1.default.toggleInstanceState(instanceName, state.enabled ? "disable" /* DISABLE */ : "enable" /* ENABLE */);
        if (result.status) {
            dispatch({ type: 'success', message: result.status, show: true });
            fetchData();
        }
        else {
            dispatch({ type: 'error', message: result.error, show: true });
        }
        setState({ enabled: !state.enabled });
        closeDialog();
    });
    const handleConfigChange = (value) => {
        setConfig(value);
    };
    const saveConfigAction = () => __awaiter(void 0, void 0, void 0, function* () {
        if (JSON.parse(config)) {
            const result = yield PinotMethodUtils_1.default.updateInstanceDetails(instanceName, config);
            if (result.status) {
                dispatch({ type: 'success', message: result.status, show: true });
                fetchData();
            }
            else {
                dispatch({ type: 'error', message: result.error, show: true });
            }
            setShowEditConfig(false);
        }
    });
    const closeDialog = () => {
        setConfirmDialog(false);
        setDialogDetails(null);
    };
    if (fetching) {
        return react_1.default.createElement(AppLoader_1.default, null);
    }
    else if (instanceNotFound) {
        return react_1.default.createElement(NotFound_1.default, { message: `Instance ${instanceName} not found` });
    }
    else {
        return (react_1.default.createElement(core_1.Grid, { item: true, xs: true, style: {
                padding: 20,
                backgroundColor: 'white',
                maxHeight: 'calc(100vh - 70px)',
                overflowY: 'auto',
            } },
            !instanceName.toLowerCase().startsWith('controller') && (react_1.default.createElement("div", { className: classes.operationDiv },
                react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Operations", showSearchBox: false },
                    react_1.default.createElement("div", null,
                        react_1.default.createElement(CustomButton_1.default, { onClick: () => {
                                var _a, _b;
                                setTagsList(((_b = (_a = JSON.parse(instanceConfig)) === null || _a === void 0 ? void 0 : _a.listFields) === null || _b === void 0 ? void 0 : _b.TAG_LIST) || []);
                                setShowEditTag(true);
                            }, tooltipTitle: "Add/remove tags from this node", enableTooltip: true }, "Edit Tags"),
                        react_1.default.createElement(CustomButton_1.default, { onClick: () => {
                                setConfig(instanceDetails);
                                setShowEditConfig(true);
                            }, enableTooltip: true }, "Edit Config"),
                        react_1.default.createElement(CustomButton_1.default, { onClick: handleDropAction, tooltipTitle: instanceType !== "minion" /* MINION */
                                ? 'Removes the node from the cluster. Untag and rebalance (to ensure the node is not being used by any table) and shutdown the instance before dropping.'
                                : '', enableTooltip: true }, "Drop"),
                        react_1.default.createElement(core_1.Tooltip, { title: "Disabling will disable the node for queries.", arrow: true, placement: "top-start" },
                            react_1.default.createElement(core_1.FormControlLabel, { control: react_1.default.createElement(core_1.Switch, { checked: state.enabled, onChange: handleSwitchChange, name: "enabled", color: "primary" }), label: "Enable" })))))),
            react_1.default.createElement(core_1.Grid, { container: true, spacing: 2 },
                react_1.default.createElement(core_1.Grid, { item: true, xs: liveConfig ? 6 : 12 },
                    react_1.default.createElement("div", { className: classes.codeMirrorDiv },
                        react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Instance Config", showSearchBox: false },
                            react_1.default.createElement(react_codemirror2_1.UnControlled, { options: jsonoptions, value: instanceConfig, className: classes.codeMirror, autoCursor: false })))),
                liveConfig ? (react_1.default.createElement(core_1.Grid, { item: true, xs: 6 },
                    react_1.default.createElement("div", { className: classes.codeMirrorDiv },
                        react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "LiveInstance Config", showSearchBox: false },
                            react_1.default.createElement(react_codemirror2_1.UnControlled, { options: jsonoptions, value: liveConfig, className: classes.codeMirror, autoCursor: false }))))) : null),
            instanceType == "broker" /* BROKER */ ||
                instanceType == "server" /* SERVER */ ? (react_1.default.createElement(AsyncPinotTables_1.default, { title: "Tables", baseUrl: `/instance/${instanceName}/table/`, instance: instanceName })) : null,
            react_1.default.createElement(EditTagsOp_1.default, { showModal: showEditTag, hideModal: () => {
                    setShowEditTag(false);
                }, saveTags: saveTagsAction, tags: tagsList, handleTagsChange: handleTagsChange, error: tagsErrorObj }),
            react_1.default.createElement(EditConfigOp_1.default, { showModal: showEditConfig, hideModal: () => {
                    setShowEditConfig(false);
                }, saveConfig: saveConfigAction, config: config, handleConfigChange: handleConfigChange }),
            confirmDialog && dialogDetails && (react_1.default.createElement(Confirm_1.default, { openDialog: confirmDialog, dialogTitle: dialogDetails.title, dialogContent: dialogDetails.content, successCallback: dialogDetails.successCb, closeDialog: closeDialog, dialogYesLabel: "Yes", dialogNoLabel: "No" }))));
    }
};
exports.default = InstanceDetails;


/***/ }),

/***/ "./app/pages/InstanceListingPage.tsx":
/*!*******************************************!*\
  !*** ./app/pages/InstanceListingPage.tsx ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const AppLoader_1 = __importDefault(__webpack_require__(/*! ../components/AppLoader */ "./app/components/AppLoader.tsx"));
const PinotMethodUtils_1 = __importDefault(__webpack_require__(/*! ../utils/PinotMethodUtils */ "./app/utils/PinotMethodUtils.ts"));
const InstancesTables_1 = __importDefault(__webpack_require__(/*! ../components/Homepage/InstancesTables */ "./app/components/Homepage/InstancesTables.tsx"));
const Utils_1 = __webpack_require__(/*! ../utils/Utils */ "./app/utils/Utils.tsx");
const useStyles = core_1.makeStyles(() => ({
    gridContainer: {
        padding: 20,
        backgroundColor: 'white',
        maxHeight: 'calc(100vh - 70px)',
        overflowY: 'auto'
    },
}));
const InstanceListingPage = () => {
    const classes = useStyles();
    const [fetching, setFetching] = react_1.useState(true);
    const [clusterName, setClusterName] = react_1.useState('');
    const fetchData = () => __awaiter(void 0, void 0, void 0, function* () {
        let clusterNameRes = localStorage.getItem('pinot_ui:clusterName');
        if (!clusterNameRes) {
            clusterNameRes = yield PinotMethodUtils_1.default.getClusterName();
        }
        setClusterName(clusterNameRes);
        setFetching(false);
    });
    react_1.useEffect(() => {
        fetchData();
    }, []);
    const instanceType = Utils_1.getInstanceTypeFromString(window.location.hash.split('/')[1].slice(0, -1));
    return fetching ? (react_1.default.createElement(AppLoader_1.default, null)) : (react_1.default.createElement(core_1.Grid, { item: true, xs: true, className: classes.gridContainer },
        react_1.default.createElement(InstancesTables_1.default, { clusterName: clusterName, instanceType: instanceType })));
};
exports.default = InstanceListingPage;


/***/ }),

/***/ "./app/pages/LoginPage.tsx":
/*!*********************************!*\
  !*** ./app/pages/LoginPage.tsx ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const Logo_1 = __importDefault(__webpack_require__(/*! ../components/SvgIcons/Logo */ "./app/components/SvgIcons/Logo.tsx"));
const react_hook_form_1 = __webpack_require__(/*! react-hook-form */ "./node_modules/react-hook-form/dist/index.esm.js");
const PinotMethodUtils_1 = __importDefault(__webpack_require__(/*! ../utils/PinotMethodUtils */ "./app/utils/PinotMethodUtils.ts"));
const app_state_1 = __importDefault(__webpack_require__(/*! ../app_state */ "./app/app_state.ts"));
const useStyles = core_1.makeStyles((theme) => {
    return core_1.createStyles({
        container: {
            height: "100vh",
            width: "100vw",
            backgroundColor: "#ebebeb",
            boxSizing: "border-box",
            paddingTop: "5%",
            margin: -8,
        },
        loginForm: {
            width: 420,
            margin: "0 auto",
            zIndex: 99,
            display: "block",
            background: "#fff",
            borderRadius: ".25rem",
            textAlign: "center",
            boxShadow: "0 0 20px rgba(0, 0, 0, 0.2)",
            color: theme.palette.common.white,
        },
        logoContainer: {
            textAlign: "center",
            opacity: 0.7,
            padding: "30px",
            backgroundColor: theme.palette.primary.main,
            color: theme.palette.common.white,
            borderRadius: "0.25rem 0.25rem 0 0",
        },
        marginTop1: {
            marginTop: theme.spacing(1),
        },
        paddingBottom3: {
            paddingBottom: theme.spacing(3),
        },
    });
});
const LoginPage = (props) => {
    const { handleSubmit, register } = react_hook_form_1.useForm();
    const [invalidToken, setInvalidToken] = react_1.default.useState(null);
    const onSubmit = handleSubmit((data) => __awaiter(void 0, void 0, void 0, function* () {
        const authToken = "Basic " + btoa(data.username + ":" + data.password);
        const isUserAuthenticated = yield PinotMethodUtils_1.default.verifyAuth(authToken);
        if (isUserAuthenticated) {
            setInvalidToken(false);
            props.setIsAuthenticated(true);
            app_state_1.default.authWorkflow = "BASIC" /* BASIC */;
            app_state_1.default.authToken = authToken;
            props.history.push(app_state_1.default.queryConsoleOnlyView ? '/query' : '/');
            app_state_1.default.username = data.username;
        }
        else {
            setInvalidToken(true);
        }
    }));
    const classes = useStyles();
    return (react_1.default.createElement("div", { className: classes.container },
        react_1.default.createElement("div", { className: classes.loginForm },
            react_1.default.createElement("div", { className: classes.logoContainer },
                react_1.default.createElement(Logo_1.default, { fulllogo: "true" })),
            react_1.default.createElement("form", { onSubmit: onSubmit },
                react_1.default.createElement(core_1.TextField, { inputRef: register, className: classes.marginTop1, label: "Username", name: "username", required: true }),
                react_1.default.createElement(core_1.TextField, { inputRef: register, className: classes.marginTop1, name: "password", label: "Password", type: "password", required: true }),
                invalidToken &&
                    react_1.default.createElement(core_1.Box, { mt: 3 },
                        react_1.default.createElement("span", { style: { color: "red" } }, "Invalid Username/Password")),
                react_1.default.createElement(core_1.Box, { paddingY: 3 },
                    react_1.default.createElement(core_1.Button, { type: "submit", variant: "contained", color: "primary" }, "Login"))))));
};
exports.default = LoginPage;


/***/ }),

/***/ "./app/pages/MinionTaskManager.tsx":
/*!*****************************************!*\
  !*** ./app/pages/MinionTaskManager.tsx ***!
  \*****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const useTaskTypesTable_1 = __importDefault(__webpack_require__(/*! ../components/Homepage/useTaskTypesTable */ "./app/components/Homepage/useTaskTypesTable.tsx"));
const useStyles = core_1.makeStyles(() => ({
    gridContainer: {
        padding: 20,
        backgroundColor: 'white',
        maxHeight: 'calc(100vh - 70px)',
        overflowY: 'auto'
    }
}));
const MinionTaskManager = () => {
    const classes = useStyles();
    const { taskTypesTable } = useTaskTypesTable_1.default();
    return (react_1.default.createElement(core_1.Grid, { item: true, xs: true, className: classes.gridContainer },
        react_1.default.createElement(core_1.Box, { mb: 3 },
            react_1.default.createElement(core_1.Typography, { variant: 'h5' }, "Minion Task Manager"),
            react_1.default.createElement(core_1.Typography, { variant: 'caption' }, "Manage the minion tasks queues and tasks")),
        taskTypesTable));
};
exports.default = MinionTaskManager;


/***/ }),

/***/ "./app/pages/Query.tsx":
/*!*****************************!*\
  !*** ./app/pages/Query.tsx ***!
  \*****************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/* eslint-disable no-nested-ternary */
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const styles_1 = __webpack_require__(/*! @material-ui/core/styles */ "./node_modules/@material-ui/core/esm/styles/index.js");
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const Alert_1 = __importDefault(__webpack_require__(/*! @material-ui/lab/Alert */ "./node_modules/@material-ui/lab/esm/Alert/index.js"));
const FileCopy_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/FileCopy */ "./node_modules/@material-ui/icons/FileCopy.js"));
const react_codemirror2_1 = __webpack_require__(/*! react-codemirror2 */ "./node_modules/react-codemirror2/index.js");
__webpack_require__(/*! codemirror/lib/codemirror.css */ "./node_modules/codemirror/lib/codemirror.css");
__webpack_require__(/*! codemirror/theme/material.css */ "./node_modules/codemirror/theme/material.css");
__webpack_require__(/*! codemirror/mode/javascript/javascript */ "./node_modules/codemirror/mode/javascript/javascript.js");
__webpack_require__(/*! codemirror/mode/sql/sql */ "./node_modules/codemirror/mode/sql/sql.js");
__webpack_require__(/*! codemirror/addon/hint/show-hint */ "./node_modules/codemirror/addon/hint/show-hint.js");
__webpack_require__(/*! codemirror/addon/hint/sql-hint */ "./node_modules/codemirror/addon/hint/sql-hint.js");
__webpack_require__(/*! codemirror/addon/hint/show-hint.css */ "./node_modules/codemirror/addon/hint/show-hint.css");
const codemirror_1 = __importDefault(__webpack_require__(/*! codemirror */ "./node_modules/codemirror/lib/codemirror.js"));
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const FormControlLabel_1 = __importDefault(__webpack_require__(/*! @material-ui/core/FormControlLabel */ "./node_modules/@material-ui/core/esm/FormControlLabel/index.js"));
const Switch_1 = __importDefault(__webpack_require__(/*! @material-ui/core/Switch */ "./node_modules/@material-ui/core/esm/Switch/index.js"));
const export_from_json_1 = __importDefault(__webpack_require__(/*! export-from-json */ "./node_modules/export-from-json/dist/esm/index.js"));
const Utils_1 = __importDefault(__webpack_require__(/*! ../utils/Utils */ "./app/utils/Utils.tsx"));
const AppLoader_1 = __importDefault(__webpack_require__(/*! ../components/AppLoader */ "./app/components/AppLoader.tsx"));
const Table_1 = __importDefault(__webpack_require__(/*! ../components/Table */ "./app/components/Table.tsx"));
const QuerySideBar_1 = __importDefault(__webpack_require__(/*! ../components/Query/QuerySideBar */ "./app/components/Query/QuerySideBar.tsx"));
const TableToolbar_1 = __importDefault(__webpack_require__(/*! ../components/TableToolbar */ "./app/components/TableToolbar.tsx"));
const SimpleAccordion_1 = __importDefault(__webpack_require__(/*! ../components/SimpleAccordion */ "./app/components/SimpleAccordion.tsx"));
const PinotMethodUtils_1 = __importDefault(__webpack_require__(/*! ../utils/PinotMethodUtils */ "./app/utils/PinotMethodUtils.ts"));
__webpack_require__(/*! ../styles/styles.css */ "./app/styles/styles.css");
const re_resizable_1 = __webpack_require__(/*! re-resizable */ "./node_modules/re-resizable/lib/index.js");
const react_router_1 = __webpack_require__(/*! react-router */ "./node_modules/react-router/esm/react-router.js");
const useStyles = styles_1.makeStyles((theme) => ({
    title: {
        flexGrow: 1,
        paddingLeft: '20px',
    },
    rightPanel: {},
    codeMirror: {
        height: '100%',
        '& .CodeMirror': {
            height: '100%',
            border: '1px solid #BDCCD9',
            fontSize: '13px',
        },
    },
    queryOutput: {
        '& .CodeMirror': { height: 430, border: '1px solid #BDCCD9' },
    },
    btn: {
        margin: '10px 10px 0 0',
        height: 30,
    },
    checkBox: {
        margin: '20px 0',
    },
    actionBtns: {
        margin: '20px 0',
        height: 50,
    },
    runNowBtn: {
        marginLeft: 'auto',
        paddingLeft: '74px',
    },
    sqlDiv: {
        height: '100%',
        border: '1px #BDCCD9 solid',
        borderRadius: 4,
        marginBottom: '20px',
        paddingBottom: '48px',
    },
    sqlError: {
        whiteSpace: 'pre',
        overflow: "auto"
    },
    timeoutControl: {
        bottom: 10
    }
}));
const jsonoptions = {
    lineNumbers: true,
    mode: 'application/json',
    styleActiveLine: true,
    gutters: ['CodeMirror-lint-markers'],
    theme: 'default',
    readOnly: true,
};
const sqloptions = {
    lineNumbers: true,
    mode: 'text/x-sql',
    styleActiveLine: true,
    lint: true,
    theme: 'default',
    indentWithTabs: true,
    smartIndent: true,
    lineWrapping: true,
    extraKeys: { "'@'": 'autocomplete' },
};
const sqlFuntionsList = [
    'COUNT', 'MIN', 'MAX', 'SUM', 'AVG', 'MINMAXRANGE', 'DISTINCTCOUNT', 'DISTINCTCOUNTBITMAP',
    'SEGMENTPARTITIONEDDISTINCTCOUNT', 'DISTINCTCOUNTHLL', 'DISTINCTCOUNTRAWHLL', 'FASTHLL',
    'DISTINCTCOUNTTHETASKETCH', 'DISTINCTCOUNTRAWTHETASKETCH', 'COUNTMV', 'MINMV', 'MAXMV',
    'SUMMV', 'AVGMV', 'MINMAXRANGEMV', 'DISTINCTCOUNTMV', 'DISTINCTCOUNTBITMAPMV', 'DISTINCTCOUNTHLLMV',
    'DISTINCTCOUNTRAWHLLMV', 'DISTINCT', 'ST_UNION'
];
const responseStatCols = [
    'timeUsedMs',
    'numDocsScanned',
    'totalDocs',
    'numServersQueried',
    'numServersResponded',
    'numSegmentsQueried',
    'numSegmentsProcessed',
    'numSegmentsMatched',
    'numConsumingSegmentsQueried',
    'numEntriesScannedInFilter',
    'numEntriesScannedPostFilter',
    'numGroupsLimitReached',
    'partialResponse',
    'minConsumingFreshnessTimeMs',
    'offlineThreadCpuTimeNs',
    'realtimeThreadCpuTimeNs',
    'offlineSystemActivitiesCpuTimeNs',
    'realtimeSystemActivitiesCpuTimeNs',
    'offlineResponseSerializationCpuTimeNs',
    'realtimeResponseSerializationCpuTimeNs',
    'offlineTotalCpuTimeNs',
    'realtimeTotalCpuTimeNs'
];
// A custom hook that builds on useLocation to parse the query string
function useQuery() {
    const { search } = react_router_1.useLocation();
    return react_1.default.useMemo(() => new URLSearchParams(search), [search]);
}
const QueryPage = () => {
    const classes = useStyles();
    const history = react_router_1.useHistory();
    let queryParam = useQuery();
    const [fetching, setFetching] = react_1.useState(true);
    const [queryLoader, setQueryLoader] = react_1.useState(false);
    const [tableList, setTableList] = react_1.useState({
        columns: [],
        records: [],
    });
    const [showException, setShowException] = react_1.useState(false);
    const [tableSchema, setTableSchema] = react_1.useState({
        columns: [],
        records: [],
    });
    const [resultData, setResultData] = react_1.useState({
        columns: [],
        records: [],
    });
    const [selectedTable, setSelectedTable] = react_1.useState('');
    const [inputQuery, setInputQuery] = react_1.useState(queryParam.get('query') || '');
    const [queryTimeout, setQueryTimeout] = react_1.useState(Number(queryParam.get('timeout') || '') || '');
    const [outputResult, setOutputResult] = react_1.useState('');
    const [resultError, setResultError] = react_1.useState([]);
    const [queryStats, setQueryStats] = react_1.useState({
        columns: [],
        records: [],
    });
    const [warnings, setWarnings] = react_1.useState([]);
    const [checked, setChecked] = react_1.default.useState({
        tracing: queryParam.get('tracing') === 'true',
        useMSE: queryParam.get('useMSE') === 'true',
        showResultJSON: false,
    });
    const queryExecuted = react_1.default.useRef(false);
    const [boolFlag, setBoolFlag] = react_1.useState(false);
    const [copyMsg, showCopyMsg] = react_1.default.useState(false);
    const handleChange = (event) => {
        setChecked(Object.assign(Object.assign({}, checked), { [event.target.name]: event.target.checked }));
    };
    const handleOutputDataChange = (editor, data, value) => {
        setInputQuery(value);
    };
    const handleQueryInterfaceKeyDown = (editor, event) => {
        const modifiedEnabled = event.metaKey == true || event.ctrlKey == true;
        // Map (Cmd/Ctrl) + Enter KeyPress to executing the query
        if (modifiedEnabled && event.keyCode == 13) {
            handleRunNow(editor.getValue());
        }
        // Map (Cmd/Ctrl) + / KeyPress to toggle commenting the query
        if (modifiedEnabled && event.keyCode == 191) {
            handleComment(editor);
        }
    };
    const handleComment = (cm) => {
        const selections = cm.listSelections();
        if (!selections) {
            return;
        }
        const query = cm.getValue();
        const querySplit = query.split(/\r?\n/);
        lodash_1.forEach(selections, (range) => {
            // anchor and head are based on where the selection starts/ends, but for the purpose
            // of determining the line number range of the selection, we need start/end in order.
            const start = Math.min(range.anchor.line, range.head.line);
            let end = Math.max(range.anchor.line, range.head.line);
            const isSingleLineSelection = start === end;
            const isLastLineFirstChar = (range.anchor.line === end && range.anchor.ch === 0) ||
                (range.head.line === end && range.head.ch === 0);
            // If the selection is on the last line and the first character, we do not comment that line.
            // This happens if you are using shift + down to select lines.
            if (isLastLineFirstChar && !isSingleLineSelection) {
                end = end - 1;
            }
            const isEntireSelectionCommented = lodash_1.range(start, end + 1).every((line) => {
                return querySplit[line].startsWith("--") || querySplit[line].trim().length === 0;
            });
            for (let line = start; line <= end; line++) {
                const lineIsCommented = querySplit[line].startsWith("--");
                const lineIsEmpty = querySplit[line].trim().length === 0;
                if (isEntireSelectionCommented) {
                    // If the entire range is commented, then we uncomment all the lines
                    if (lineIsCommented) {
                        querySplit[line] = querySplit[line].replace(/^--\s*/, '');
                    }
                }
                else {
                    // If the range is not commented, then we comment all the uncommented lines
                    if (!lineIsEmpty && !lineIsCommented) {
                        querySplit[line] = `-- ${querySplit[line]}`;
                    }
                }
            }
        });
        setInputQuery(querySplit.join("\n"));
    };
    const handleRunNow = (query) => __awaiter(void 0, void 0, void 0, function* () {
        setQueryLoader(true);
        queryExecuted.current = true;
        let params;
        let queryOptions = [];
        if (queryTimeout) {
            queryOptions.push(`timeoutMs=${queryTimeout}`);
        }
        if (checked.useMSE) {
            queryOptions.push(`useMultistageEngine=true`);
        }
        const finalQuery = `${query || inputQuery.trim()}`;
        params = JSON.stringify({
            sql: `${finalQuery}`,
            trace: checked.tracing,
            queryOptions: `${queryOptions.join(";")}`,
        });
        if (finalQuery !== '') {
            queryParam.set('query', finalQuery);
            queryParam.set('tracing', checked.tracing.toString());
            queryParam.set('useMSE', checked.useMSE.toString());
            if (queryTimeout !== undefined && queryTimeout !== '') {
                queryParam.set('timeout', queryTimeout.toString());
            }
            history.push({
                pathname: '/query',
                search: `?${queryParam.toString()}`
            });
        }
        const results = yield PinotMethodUtils_1.default.getQueryResults(params);
        setResultError(results.exceptions || []);
        setResultData(results.result || { columns: [], records: [] });
        setQueryStats(results.queryStats || { columns: responseStatCols, records: [] });
        setOutputResult(JSON.stringify(results.data, null, 2) || '');
        setWarnings(extractWarnings(results));
        setQueryLoader(false);
        queryExecuted.current = false;
    });
    const extractWarnings = (result) => {
        const warnings = [];
        const numSegmentsPrunedInvalid = result.data.numSegmentsPrunedInvalid;
        if (numSegmentsPrunedInvalid) {
            warnings.push(`There are ${numSegmentsPrunedInvalid} invalid segment/s. This usually means that they were `
                + `created with an older schema. `
                + `Please reload the table in order to refresh these segments to the new schema.`);
        }
        return warnings;
    };
    const fetchSQLData = (tableName) => __awaiter(void 0, void 0, void 0, function* () {
        setQueryLoader(true);
        const result = yield PinotMethodUtils_1.default.getTableSchemaData(tableName);
        const tableSchema = Utils_1.default.syncTableSchemaData(result, false);
        setTableSchema(tableSchema);
        const query = `select * from ${tableName} limit 10`;
        setInputQuery(query);
        setSelectedTable(tableName);
        handleRunNow(query);
    });
    const downloadData = (exportType) => {
        const data = Utils_1.default.tableFormat(resultData);
        const fileName = 'Pinot Data Explorer';
        export_from_json_1.default({ data, fileName, exportType });
    };
    const copyToClipboard = () => {
        // Create an auxiliary hidden input
        const aux = document.createElement('input');
        // Get the text from the element passed into the input
        aux.setAttribute('value', JSON.stringify(resultData));
        // Append the aux input to the body
        document.body.appendChild(aux);
        // Highlight the content
        aux.select();
        // Execute the copy command
        document.execCommand('copy');
        // Remove the input from the body
        document.body.removeChild(aux);
        showCopyMsg(true);
        setTimeout(() => {
            showCopyMsg(false);
        }, 3000);
    };
    const fetchData = () => __awaiter(void 0, void 0, void 0, function* () {
        const result = yield PinotMethodUtils_1.default.getQueryTablesList({ bothType: false });
        setTableList(result);
        setFetching(false);
    });
    react_1.useEffect(() => {
        fetchData();
        if (inputQuery) {
            handleRunNow(inputQuery);
        }
    }, []);
    react_1.useEffect(() => {
        const query = queryParam.get('query');
        if (!queryExecuted.current && query) {
            setInputQuery(query);
            setChecked({
                tracing: queryParam.get('tracing') === 'true',
                useMSE: queryParam.get('useMse') === 'true',
                showResultJSON: checked.showResultJSON,
            });
            setQueryTimeout(Number(queryParam.get('timeout') || '') || '');
            setBoolFlag(!boolFlag);
        }
    }, [queryParam]);
    react_1.useEffect(() => {
        const query = queryParam.get('query');
        if (!queryExecuted.current && query) {
            handleRunNow();
        }
    }, [boolFlag]);
    const handleSqlHints = (cm) => {
        const tableNames = [];
        tableList.records.forEach((obj, i) => {
            tableNames.push(obj[i]);
        });
        const columnNames = tableSchema.records.map((obj) => {
            return obj[0];
        });
        const hintOptions = [];
        const defaultHint = codemirror_1.default.hint.sql(cm);
        Array.prototype.push.apply(hintOptions, Utils_1.default.generateCodeMirrorOptions(tableNames, 'TABLE'));
        Array.prototype.push.apply(hintOptions, Utils_1.default.generateCodeMirrorOptions(columnNames, 'COLUMNS'));
        Array.prototype.push.apply(hintOptions, Utils_1.default.generateCodeMirrorOptions(sqlFuntionsList, 'FUNCTION'));
        const cur = cm.getCursor();
        const curLine = cm.getLine(cur.line);
        let start = cur.ch;
        let end = start;
        // eslint-disable-next-line no-plusplus
        while (end < curLine.length && /[\w$]/.test(curLine.charAt(end)))
            ++end;
        // eslint-disable-next-line no-plusplus
        while (start && /[\w$]/.test(curLine.charAt(start - 1)))
            --start;
        const curWord = start !== end && curLine.slice(start, end);
        const regex = new RegExp(`^${curWord}`, 'i');
        const finalList = (!curWord ? hintOptions : hintOptions.filter(function (item) {
            return item.displayText.match(regex);
        })).sort();
        Array.prototype.push.apply(defaultHint.list, finalList);
        defaultHint.list = lodash_1.uniqBy(defaultHint.list, 'text');
        return defaultHint;
    };
    const sqlEditorTooltip = "This editor supports auto-completion feature. Type @ in the editor to see the list of SQL keywords, functions, table name and column names.";
    return fetching ? (react_1.default.createElement(AppLoader_1.default, null)) : (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(core_1.Grid, { item: true },
            react_1.default.createElement(QuerySideBar_1.default, { tableList: tableList, fetchSQLData: fetchSQLData, tableSchema: tableSchema, selectedTable: selectedTable, queryLoader: queryLoader })),
        react_1.default.createElement(core_1.Grid, { item: true, xs: true, style: {
                padding: 20,
                backgroundColor: 'white',
                maxHeight: 'calc(100vh - 70px)',
                overflowY: 'auto',
            } },
            react_1.default.createElement(core_1.Grid, { container: true },
                react_1.default.createElement(core_1.Grid, { item: true, xs: 12, className: classes.rightPanel },
                    react_1.default.createElement(re_resizable_1.Resizable, { defaultSize: {
                            width: '100%',
                            height: 148,
                        }, minHeight: 148, maxWidth: '100%', maxHeight: '50vh', enable: { bottom: true } },
                        react_1.default.createElement("div", { className: classes.sqlDiv },
                            react_1.default.createElement(TableToolbar_1.default, { name: "SQL Editor", showSearchBox: false, showTooltip: true, tooltipText: sqlEditorTooltip }),
                            react_1.default.createElement(react_codemirror2_1.UnControlled, { options: Object.assign(Object.assign({}, sqloptions), { hintOptions: {
                                        hint: handleSqlHints,
                                    } }), value: inputQuery, onChange: handleOutputDataChange, onKeyDown: handleQueryInterfaceKeyDown, className: classes.codeMirror, autoCursor: false }))),
                    react_1.default.createElement(core_1.Grid, { container: true, className: classes.checkBox },
                        react_1.default.createElement(core_1.Grid, { item: true, xs: 2 },
                            react_1.default.createElement(core_1.Checkbox, { name: "tracing", color: "primary", onChange: handleChange, checked: checked.tracing }),
                            "Tracing"),
                        react_1.default.createElement(core_1.Grid, { item: true, xs: 3 },
                            react_1.default.createElement(core_1.Checkbox, { name: "useMSE", color: "primary", onChange: handleChange, checked: checked.useMSE }),
                            "Use Multi-Stage Engine"),
                        react_1.default.createElement(core_1.Grid, { item: true, xs: 3 },
                            react_1.default.createElement(core_1.FormControl, { fullWidth: true, className: classes.timeoutControl },
                                react_1.default.createElement(core_1.InputLabel, { htmlFor: "my-input" }, "Timeout (in Milliseconds)"),
                                react_1.default.createElement(core_1.Input, { id: "my-input", type: "number", value: queryTimeout, onChange: (e) => setQueryTimeout(Number(e.target.value) || '') }))),
                        react_1.default.createElement(core_1.Grid, { item: true, xs: 3, className: classes.runNowBtn },
                            react_1.default.createElement(core_1.Button, { variant: "contained", color: "primary", onClick: () => handleRunNow() }, "Run Query"))),
                    queryLoader ? (react_1.default.createElement(AppLoader_1.default, null)) : (react_1.default.createElement(react_1.default.Fragment, null,
                        queryStats.columns.length ? (react_1.default.createElement(core_1.Grid, { item: true, xs: true, style: { backgroundColor: 'white' } },
                            react_1.default.createElement(Table_1.default, { title: "Query Response Stats", data: queryStats, showSearchBox: true, inAccordionFormat: true }))) : null,
                        warnings.map(warn => react_1.default.createElement(Alert_1.default, { severity: "warning", className: classes.sqlError }, warn)),
                        resultError && resultError.length > 0 && (react_1.default.createElement(react_1.default.Fragment, null,
                            react_1.default.createElement(Alert_1.default, { className: classes.sqlError, severity: "error", action: react_1.default.createElement(FormControlLabel_1.default, { control: react_1.default.createElement(Switch_1.default, { color: "primary", checked: showException, onChange: (e) => setShowException(e.target.checked), name: "checkedA" }), label: react_1.default.createElement(core_1.Typography, { variant: 'body2' }, "Show Exceptions") }) }, resultData.columns.length > 0 ? (react_1.default.createElement(core_1.Typography, { variant: 'body2' }, "Partial results due to exceptions. Please toggle the switch to view details.")) : (react_1.default.createElement(core_1.Typography, { variant: 'body2' }, "Query failed with exceptions. Please toggle the switch to view details."))),
                            react_1.default.createElement(core_1.Box, { m: "16px" }),
                            showException && resultError.map((error) => (react_1.default.createElement(core_1.Box, { style: { paddingBottom: "10px" } },
                                react_1.default.createElement(Alert_1.default, { className: classes.sqlError, severity: "error" },
                                    error.errorCode && react_1.default.createElement(core_1.Typography, { variant: "body2" },
                                        "Error Code: ",
                                        error.errorCode),
                                    error.message)))))),
                        react_1.default.createElement(core_1.Grid, { item: true, xs: true, style: { backgroundColor: 'white' } }, resultData.columns.length ? (react_1.default.createElement(react_1.default.Fragment, null,
                            react_1.default.createElement(core_1.Grid, { container: true, className: classes.actionBtns },
                                react_1.default.createElement(core_1.Button, { variant: "contained", color: "primary", size: "small", className: classes.btn, onClick: () => downloadData('xls') }, "Excel"),
                                react_1.default.createElement(core_1.Button, { variant: "contained", color: "primary", size: "small", className: classes.btn, onClick: () => downloadData('csv') }, "CSV"),
                                react_1.default.createElement(core_1.Button, { variant: "contained", color: "primary", size: "small", className: classes.btn, onClick: () => copyToClipboard() }, "Copy"),
                                copyMsg ? (react_1.default.createElement(Alert_1.default, { icon: react_1.default.createElement(FileCopy_1.default, { fontSize: "inherit" }), severity: "info" },
                                    "Copied ",
                                    resultData.records.length,
                                    " rows to Clipboard")) : null,
                                react_1.default.createElement(FormControlLabel_1.default, { control: react_1.default.createElement(Switch_1.default, { checked: checked.showResultJSON, onChange: handleChange, name: "showResultJSON", color: "primary" }), label: "Show JSON format", className: classes.runNowBtn })),
                            !checked.showResultJSON ? (react_1.default.createElement(Table_1.default, { title: "Query Result", data: resultData, isSticky: true, showSearchBox: true, inAccordionFormat: true })) : resultData.columns.length ? (react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Query Result (JSON Format)", showSearchBox: false },
                                react_1.default.createElement(react_codemirror2_1.UnControlled, { options: jsonoptions, value: outputResult, className: classes.queryOutput, autoCursor: false }))) : null)) : null))))))));
};
exports.default = QueryPage;


/***/ }),

/***/ "./app/pages/SchemaPageDetails.tsx":
/*!*****************************************!*\
  !*** ./app/pages/SchemaPageDetails.tsx ***!
  \*****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const styles_1 = __webpack_require__(/*! @material-ui/core/styles */ "./node_modules/@material-ui/core/esm/styles/index.js");
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const react_router_dom_1 = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router-dom/esm/react-router-dom.js");
const react_codemirror2_1 = __webpack_require__(/*! react-codemirror2 */ "./node_modules/react-codemirror2/index.js");
const AppLoader_1 = __importDefault(__webpack_require__(/*! ../components/AppLoader */ "./app/components/AppLoader.tsx"));
const Table_1 = __importDefault(__webpack_require__(/*! ../components/Table */ "./app/components/Table.tsx"));
__webpack_require__(/*! codemirror/lib/codemirror.css */ "./node_modules/codemirror/lib/codemirror.css");
__webpack_require__(/*! codemirror/theme/material.css */ "./node_modules/codemirror/theme/material.css");
__webpack_require__(/*! codemirror/mode/javascript/javascript */ "./node_modules/codemirror/mode/javascript/javascript.js");
__webpack_require__(/*! codemirror/mode/sql/sql */ "./node_modules/codemirror/mode/sql/sql.js");
const SimpleAccordion_1 = __importDefault(__webpack_require__(/*! ../components/SimpleAccordion */ "./app/components/SimpleAccordion.tsx"));
const PinotMethodUtils_1 = __importDefault(__webpack_require__(/*! ../utils/PinotMethodUtils */ "./app/utils/PinotMethodUtils.ts"));
const NotificationContext_1 = __webpack_require__(/*! ../components/Notification/NotificationContext */ "./app/components/Notification/NotificationContext.tsx");
const Utils_1 = __importDefault(__webpack_require__(/*! ../utils/Utils */ "./app/utils/Utils.tsx"));
const CustomButton_1 = __importDefault(__webpack_require__(/*! ../components/CustomButton */ "./app/components/CustomButton.tsx"));
const Confirm_1 = __importDefault(__webpack_require__(/*! ../components/Confirm */ "./app/components/Confirm.tsx"));
const CustomCodemirror_1 = __importDefault(__webpack_require__(/*! ../components/CustomCodemirror */ "./app/components/CustomCodemirror.tsx"));
const CustomDialog_1 = __importDefault(__webpack_require__(/*! ../components/CustomDialog */ "./app/components/CustomDialog.tsx"));
const icons_1 = __webpack_require__(/*! @material-ui/icons */ "./node_modules/@material-ui/icons/esm/index.js");
const NotFound_1 = __importDefault(__webpack_require__(/*! ../components/NotFound */ "./app/components/NotFound.tsx"));
const useStyles = styles_1.makeStyles(() => ({
    root: {
        border: '1px #BDCCD9 solid',
        borderRadius: 4,
        marginBottom: '20px',
    },
    highlightBackground: {
        border: '1px #4285f4 solid',
        backgroundColor: 'rgba(66, 133, 244, 0.05)',
        borderRadius: 4,
        marginBottom: '20px',
    },
    body: {
        borderTop: '1px solid #BDCCD9',
        fontSize: '16px',
        lineHeight: '3rem',
        paddingLeft: '15px',
    },
    queryOutput: {
        border: '1px solid #BDCCD9',
        '& .CodeMirror': { height: 532 },
    },
    sqlDiv: {
        border: '1px #BDCCD9 solid',
        borderRadius: 4,
        marginBottom: '20px',
    },
    operationDiv: {
        border: '1px #BDCCD9 solid',
        borderRadius: 4,
        marginBottom: 20,
    },
}));
const jsonoptions = {
    lineNumbers: true,
    mode: 'application/json',
    styleActiveLine: true,
    gutters: ['CodeMirror-lint-markers'],
    theme: 'default',
    readOnly: true,
};
const SchemaPageDetails = ({ match }) => {
    const { schemaName } = match.params;
    const classes = useStyles();
    const history = react_router_dom_1.useHistory();
    const [fetching, setFetching] = react_1.useState(true);
    const [schemaNotFound, setSchemaNotFound] = react_1.useState(false);
    const [] = react_1.useState({
        schemaName: match.params.schemaName,
        reportedSize: '',
        estimatedSize: '',
    });
    const [] = react_1.default.useState({
        enabled: true,
    });
    const [confirmDialog, setConfirmDialog] = react_1.default.useState(false);
    const [dialogDetails, setDialogDetails] = react_1.default.useState(null);
    const { dispatch } = react_1.default.useContext(NotificationContext_1.NotificationContext);
    const [showEditConfig, setShowEditConfig] = react_1.useState(false);
    const [config, setConfig] = react_1.useState('{}');
    const [tableSchema, setTableSchema] = react_1.useState({
        columns: [],
        records: [],
    });
    const [tableConfig, setTableConfig] = react_1.useState('');
    const [schemaJSON, setSchemaJSON] = react_1.useState(null);
    const [actionType, setActionType] = react_1.useState(null);
    const [schemaJSONFormat, setSchemaJSONFormat] = react_1.useState(false);
    const [reloadSegmentsOnUpdate, setReloadSegmentsOnUpdate] = react_1.useState(false);
    const fetchTableSchema = () => __awaiter(void 0, void 0, void 0, function* () {
        const result = yield PinotMethodUtils_1.default.getTableSchemaData(schemaName);
        if ((result === null || result === void 0 ? void 0 : result.code) === 404) {
            setSchemaNotFound(true);
            setFetching(false);
        }
        else if (result.error) {
            setSchemaJSON(null);
            setTableSchema({
                columns: ['Column', 'Type', 'Field Type', 'Multi Value'],
                records: [],
            });
            setFetching(false);
        }
        else {
            setSchemaJSON(JSON.parse(JSON.stringify(result)));
            const tableSchema = Utils_1.default.syncTableSchemaData(result, true);
            setTableSchema(tableSchema);
            fetchTableJSON();
        }
    });
    const fetchTableJSON = () => __awaiter(void 0, void 0, void 0, function* () {
        const result = yield PinotMethodUtils_1.default.getSchemaData(schemaName);
        setTableConfig(JSON.stringify(result, null, 2));
        setFetching(false);
    });
    react_1.useEffect(() => {
        fetchTableSchema();
    }, []);
    const handleConfigChange = (value) => {
        setConfig(value);
    };
    const saveConfigAction = () => __awaiter(void 0, void 0, void 0, function* () {
        let configObj = JSON.parse(config);
        if (actionType === 'editTable') {
            if (configObj.OFFLINE || configObj.REALTIME) {
                configObj = configObj.OFFLINE || configObj.REALTIME;
            }
            const result = yield PinotMethodUtils_1.default.updateTable(schemaName, configObj);
            syncResponse(result);
        }
        else if (actionType === 'editSchema') {
            const result = yield PinotMethodUtils_1.default.updateSchema(schemaJSON.schemaName, configObj, reloadSegmentsOnUpdate);
            syncResponse(result);
        }
    });
    const syncResponse = (result) => {
        if (result.status) {
            dispatch({ type: 'success', message: result.status, show: true });
            setShowEditConfig(false);
            fetchTableJSON();
            setReloadSegmentsOnUpdate(false);
        }
        else {
            dispatch({ type: 'error', message: result.error, show: true });
        }
    };
    const handleDeleteSchemaAction = () => {
        setDialogDetails({
            title: 'Delete Schema',
            content: 'Are you sure want to delete this schema? Any tables using this schema might not function correctly.',
            successCb: () => deleteSchema(),
        });
        setConfirmDialog(true);
    };
    const deleteSchema = () => __awaiter(void 0, void 0, void 0, function* () {
        const result = yield PinotMethodUtils_1.default.deleteSchemaOp(schemaJSON.schemaName);
        syncResponse(result);
        history.push('/tables');
    });
    const closeDialog = () => {
        setConfirmDialog(false);
        setDialogDetails(null);
    };
    const handleSegmentDialogHide = () => {
        setShowEditConfig(false);
        setReloadSegmentsOnUpdate(false);
    };
    if (fetching) {
        return react_1.default.createElement(AppLoader_1.default, null);
    }
    else if (schemaNotFound) {
        return react_1.default.createElement(NotFound_1.default, { message: `Schema ${schemaName} not found` });
    }
    else {
        return (react_1.default.createElement(core_1.Grid, { item: true, xs: true, style: {
                padding: 20,
                backgroundColor: 'white',
                maxHeight: 'calc(100vh - 70px)',
                overflowY: 'auto',
            } },
            react_1.default.createElement("div", { className: classes.operationDiv },
                react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Operations", showSearchBox: false },
                    react_1.default.createElement("div", null,
                        react_1.default.createElement(CustomButton_1.default, { onClick: () => {
                                setActionType('editSchema');
                                setConfig(JSON.stringify(schemaJSON, null, 2));
                                setShowEditConfig(true);
                            }, tooltipTitle: "Edit Schema", enableTooltip: true }, "Edit Schema"),
                        react_1.default.createElement(CustomButton_1.default, { isDisabled: !schemaJSON, onClick: handleDeleteSchemaAction, tooltipTitle: "Delete Schema", enableTooltip: true }, "Delete Schema")))),
            react_1.default.createElement(core_1.Grid, { container: true, spacing: 2 },
                react_1.default.createElement(core_1.Grid, { item: true, xs: 6 },
                    react_1.default.createElement("div", { className: classes.sqlDiv },
                        react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Schema Json", showSearchBox: false },
                            react_1.default.createElement(react_codemirror2_1.UnControlled, { options: jsonoptions, value: tableConfig, className: classes.queryOutput, autoCursor: false })))),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 6 }, !schemaJSONFormat ? (react_1.default.createElement(Table_1.default, { title: "Table Schema", data: tableSchema, showSearchBox: true })) : (react_1.default.createElement("div", { className: classes.sqlDiv },
                    react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Table Schema", showSearchBox: false, accordionToggleObject: {
                            toggleName: 'JSON Format',
                            toggleValue: schemaJSONFormat,
                            toggleChangeHandler: () => {
                                setSchemaJSONFormat(!schemaJSONFormat);
                            },
                        } },
                        react_1.default.createElement(react_codemirror2_1.UnControlled, { options: jsonoptions, value: JSON.stringify(schemaJSON, null, 2), className: classes.queryOutput, autoCursor: false })))))),
            react_1.default.createElement(CustomDialog_1.default, { open: showEditConfig, handleClose: handleSegmentDialogHide, title: "Edit Schema", handleSave: saveConfigAction },
                react_1.default.createElement(core_1.DialogContent, null,
                    react_1.default.createElement(core_1.FormControlLabel, { control: react_1.default.createElement(core_1.Checkbox, { size: "small", color: "primary", checked: reloadSegmentsOnUpdate, onChange: (e) => setReloadSegmentsOnUpdate(e.target.checked), name: "reload" }), label: "Reload all segments" }),
                    react_1.default.createElement(core_1.IconButton, { size: "small" },
                        react_1.default.createElement(core_1.Tooltip, { title: "Reload all segments to make updated schema effective for already ingested data.", arrow: true, placement: "top" },
                            react_1.default.createElement(icons_1.HelpOutlineOutlined, { fontSize: "small" }))),
                    react_1.default.createElement(CustomCodemirror_1.default, { data: config, isEditable: true, returnCodemirrorValue: (newValue) => {
                            handleConfigChange(newValue);
                        } }))),
            confirmDialog && dialogDetails && (react_1.default.createElement(Confirm_1.default, { openDialog: confirmDialog, dialogTitle: dialogDetails.title, dialogContent: dialogDetails.content, successCallback: dialogDetails.successCb, closeDialog: closeDialog, dialogYesLabel: "Yes", dialogNoLabel: "No" }))));
    }
};
exports.default = SchemaPageDetails;


/***/ }),

/***/ "./app/pages/SegmentDetails.tsx":
/*!**************************************!*\
  !*** ./app/pages/SegmentDetails.tsx ***!
  \**************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const moment_1 = __importDefault(__webpack_require__(/*! moment */ "./node_modules/moment/moment.js"));
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const styles_1 = __webpack_require__(/*! @material-ui/core/styles */ "./node_modules/@material-ui/core/esm/styles/index.js");
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const react_router_dom_1 = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router-dom/esm/react-router-dom.js");
const react_codemirror2_1 = __webpack_require__(/*! react-codemirror2 */ "./node_modules/react-codemirror2/index.js");
const TableToolbar_1 = __importDefault(__webpack_require__(/*! ../components/TableToolbar */ "./app/components/TableToolbar.tsx"));
__webpack_require__(/*! codemirror/lib/codemirror.css */ "./node_modules/codemirror/lib/codemirror.css");
__webpack_require__(/*! codemirror/theme/material.css */ "./node_modules/codemirror/theme/material.css");
__webpack_require__(/*! codemirror/mode/javascript/javascript */ "./node_modules/codemirror/mode/javascript/javascript.js");
__webpack_require__(/*! codemirror/mode/sql/sql */ "./node_modules/codemirror/mode/sql/sql.js");
const SimpleAccordion_1 = __importDefault(__webpack_require__(/*! ../components/SimpleAccordion */ "./app/components/SimpleAccordion.tsx"));
const Table_1 = __importDefault(__webpack_require__(/*! ../components/Table */ "./app/components/Table.tsx"));
const PinotMethodUtils_1 = __importDefault(__webpack_require__(/*! ../utils/PinotMethodUtils */ "./app/utils/PinotMethodUtils.ts"));
const CustomButton_1 = __importDefault(__webpack_require__(/*! ../components/CustomButton */ "./app/components/CustomButton.tsx"));
const Confirm_1 = __importDefault(__webpack_require__(/*! ../components/Confirm */ "./app/components/Confirm.tsx"));
const NotificationContext_1 = __webpack_require__(/*! ../components/Notification/NotificationContext */ "./app/components/Notification/NotificationContext.tsx");
const Utils_1 = __importDefault(__webpack_require__(/*! ../utils/Utils */ "./app/utils/Utils.tsx"));
const requests_1 = __webpack_require__(/*! ../requests */ "./app/requests/index.ts");
const Skeleton_1 = __importDefault(__webpack_require__(/*! @material-ui/lab/Skeleton */ "./node_modules/@material-ui/lab/esm/Skeleton/index.js"));
const NotFound_1 = __importDefault(__webpack_require__(/*! ../components/NotFound */ "./app/components/NotFound.tsx"));
const AppLoader_1 = __importDefault(__webpack_require__(/*! ../components/AppLoader */ "./app/components/AppLoader.tsx"));
const useStyles = styles_1.makeStyles((theme) => ({
    root: {
        border: '1px #BDCCD9 solid',
        borderRadius: 4,
        marginBottom: '20px',
    },
    highlightBackground: {
        border: '1px #4285f4 solid',
        backgroundColor: 'rgba(66, 133, 244, 0.05)',
        borderRadius: 4,
        marginBottom: '20px',
    },
    body: {
        borderTop: '1px solid #BDCCD9',
        fontSize: '16px',
        lineHeight: '3rem',
        paddingLeft: '15px',
    },
    queryOutput: {
        border: '1px solid #BDCCD9',
        '& .CodeMirror': { height: 532 },
    },
    sqlDiv: {
        border: '1px #BDCCD9 solid',
        borderRadius: 4,
        marginBottom: '20px',
    },
    operationDiv: {
        border: '1px #BDCCD9 solid',
        borderRadius: 4,
        marginBottom: 20,
    },
}));
const jsonoptions = {
    lineNumbers: true,
    mode: 'application/json',
    styleActiveLine: true,
    gutters: ['CodeMirror-lint-markers'],
    theme: 'default',
    readOnly: true,
};
const SegmentDetails = ({ match }) => {
    const classes = useStyles();
    const history = react_router_dom_1.useHistory();
    const location = react_router_dom_1.useLocation();
    const { tableName, segmentName: encodedSegmentName } = match.params;
    const segmentName = Utils_1.default.encodeString(encodedSegmentName);
    const [confirmDialog, setConfirmDialog] = react_1.default.useState(false);
    const [dialogDetails, setDialogDetails] = react_1.default.useState(null);
    const { dispatch } = react_1.default.useContext(NotificationContext_1.NotificationContext);
    const [initialLoad, setInitialLoad] = react_1.useState(true);
    const [segmentNotFound, setSegmentNotFound] = react_1.useState(false);
    const initialSummary = {
        segmentName,
        totalDocs: null,
        createTime: null,
    };
    const [segmentSummary, setSegmentSummary] = react_1.useState(initialSummary);
    const replicaColumns = ['Server Name', 'Status'];
    const initialReplica = Utils_1.default.getLoadingTableData(replicaColumns);
    const [replica, setReplica] = react_1.useState(initialReplica);
    const indexColumns = [
        'Field Name',
        'Bloom Filter',
        'Dictionary',
        'Forward Index',
        'Sorted',
        'Inverted Index',
        'JSON Index',
        'Null Value Vector Reader',
        'Range Index',
    ];
    const initialIndexes = Utils_1.default.getLoadingTableData(indexColumns);
    const [indexes, setIndexes] = react_1.useState(initialIndexes);
    const initialSegmentMetadataJson = 'Loading...';
    const [segmentMetadataJson, setSegmentMetadataJson] = react_1.useState(initialSegmentMetadataJson);
    const fetchData = () => __awaiter(void 0, void 0, void 0, function* () {
        // reset all state in case the segment was reloaded or deleted.
        setInitialData();
        requests_1.getSegmentMetadata(tableName, segmentName).then((result) => {
            var _a;
            if (((_a = result.data) === null || _a === void 0 ? void 0 : _a.code) === 404) {
                setSegmentNotFound(true);
                setInitialLoad(false);
            }
            else {
                setInitialLoad(false);
                setSummary(result.data);
                setSegmentMetadata(result.data);
                setSegmentIndexes(result.data);
            }
        });
        setSegmentReplicas();
    });
    const setInitialData = () => {
        setInitialLoad(true);
        setSegmentSummary(initialSummary);
        setReplica(initialReplica);
        setIndexes(initialIndexes);
        setSegmentMetadataJson(initialSegmentMetadataJson);
    };
    const setSummary = (segmentMetadata) => {
        const segmentMetaDataJson = Object.assign({}, segmentMetadata);
        setSegmentSummary({
            segmentName,
            totalDocs: segmentMetaDataJson['segment.total.docs'] || 0,
            createTime: moment_1.default(+segmentMetaDataJson['segment.creation.time']).format('MMMM Do YYYY, h:mm:ss'),
        });
    };
    const setSegmentMetadata = (segmentMetadata) => {
        const segmentMetaDataJson = Object.assign({}, segmentMetadata);
        delete segmentMetaDataJson.indexes;
        delete segmentMetaDataJson.columns;
        setSegmentMetadataJson(JSON.stringify(segmentMetaDataJson, null, 2));
    };
    const setSegmentIndexes = (segmentMetadata) => {
        setIndexes({
            columns: indexColumns,
            records: Object.keys(segmentMetadata.indexes).map((fieldName) => {
                var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p;
                return [
                    fieldName,
                    ((_b = (_a = segmentMetadata.indexes) === null || _a === void 0 ? void 0 : _a[fieldName]) === null || _b === void 0 ? void 0 : _b['bloom-filter']) === 'YES',
                    ((_d = (_c = segmentMetadata.indexes) === null || _c === void 0 ? void 0 : _c[fieldName]) === null || _d === void 0 ? void 0 : _d['dictionary']) === 'YES',
                    ((_f = (_e = segmentMetadata.indexes) === null || _e === void 0 ? void 0 : _e[fieldName]) === null || _f === void 0 ? void 0 : _f['forward-index']) === 'YES',
                    ((segmentMetadata.columns || []).filter((row) => row.columnName === fieldName)[0] || { sorted: false }).sorted,
                    ((_h = (_g = segmentMetadata.indexes) === null || _g === void 0 ? void 0 : _g[fieldName]) === null || _h === void 0 ? void 0 : _h['inverted-index']) === 'YES',
                    ((_k = (_j = segmentMetadata.indexes) === null || _j === void 0 ? void 0 : _j[fieldName]) === null || _k === void 0 ? void 0 : _k['json-index']) === 'YES',
                    ((_m = (_l = segmentMetadata.indexes) === null || _l === void 0 ? void 0 : _l[fieldName]) === null || _m === void 0 ? void 0 : _m['null-value-vector-reader']) ===
                        'YES',
                    ((_p = (_o = segmentMetadata.indexes) === null || _o === void 0 ? void 0 : _o[fieldName]) === null || _p === void 0 ? void 0 : _p['range-index']) === 'YES',
                ];
            }),
        });
    };
    const setSegmentReplicas = () => {
        let [baseTableName, tableType] = Utils_1.default.splitStringByLastUnderscore(tableName);
        requests_1.getExternalView(tableName).then((results) => {
            const externalView = results.data.OFFLINE || results.data.REALTIME;
            const records = lodash_1.keys((externalView === null || externalView === void 0 ? void 0 : externalView[segmentName]) || {}).map((prop) => {
                var _a;
                const status = (_a = externalView === null || externalView === void 0 ? void 0 : externalView[segmentName]) === null || _a === void 0 ? void 0 : _a[prop];
                return [
                    prop,
                    { value: status, tooltip: `Segment is ${status.toLowerCase()}` },
                ];
            });
            setReplica({
                columns: replicaColumns,
                records: records,
            });
            requests_1.getSegmentDebugInfo(baseTableName, tableType.toLowerCase()).then((debugInfo) => {
                var _a;
                const segmentDebugInfo = debugInfo.data;
                let debugInfoObj = {};
                if (segmentDebugInfo && segmentDebugInfo[0]) {
                    const debugInfosObj = (_a = segmentDebugInfo[0].segmentDebugInfos) === null || _a === void 0 ? void 0 : _a.find((o) => {
                        return o.segmentName === segmentName;
                    });
                    if (debugInfosObj) {
                        const serverNames = lodash_1.keys((debugInfosObj === null || debugInfosObj === void 0 ? void 0 : debugInfosObj.serverState) || {});
                        serverNames === null || serverNames === void 0 ? void 0 : serverNames.map((serverName) => {
                            var _a, _b;
                            debugInfoObj[serverName] = (_b = (_a = debugInfosObj.serverState[serverName]) === null || _a === void 0 ? void 0 : _a.errorInfo) === null || _b === void 0 ? void 0 : _b.errorMessage;
                        });
                    }
                }
                const records = lodash_1.keys((externalView === null || externalView === void 0 ? void 0 : externalView[segmentName]) || {}).map((prop) => {
                    var _a;
                    const status = (_a = externalView === null || externalView === void 0 ? void 0 : externalView[segmentName]) === null || _a === void 0 ? void 0 : _a[prop];
                    return [
                        prop,
                        status === 'ERROR'
                            ? {
                                value: status,
                                tooltip: (debugInfoObj === null || debugInfoObj === void 0 ? void 0 : debugInfoObj[prop]) || 'testing',
                            }
                            : {
                                value: status,
                                tooltip: `Segment is ${status.toLowerCase()}`,
                            },
                    ];
                });
                setReplica({
                    columns: replicaColumns,
                    records: records,
                });
            });
        });
    };
    react_1.useEffect(() => {
        fetchData();
    }, []);
    const closeDialog = () => {
        setConfirmDialog(false);
        setDialogDetails(null);
    };
    const handleDeleteSegmentClick = () => {
        setDialogDetails({
            title: 'Delete Segment',
            content: 'Are you sure want to delete this instance? Data from this segment will be permanently deleted.',
            successCb: () => handleDeleteSegment(),
        });
        setConfirmDialog(true);
    };
    const handleDeleteSegment = () => __awaiter(void 0, void 0, void 0, function* () {
        const result = yield PinotMethodUtils_1.default.deleteSegmentOp(tableName, segmentName);
        if (result && result.status) {
            dispatch({ type: 'success', message: result.status, show: true });
            fetchData();
        }
        else {
            dispatch({ type: 'error', message: result.error, show: true });
        }
        closeDialog();
        setTimeout(() => {
            history.push(Utils_1.default.navigateToPreviousPage(location, false));
        }, 1000);
    });
    const handleReloadSegmentClick = () => {
        setDialogDetails({
            title: 'Reload Segment',
            content: 'Are you sure want to reload this segment?',
            successCb: () => handleReloadOp(),
        });
        setConfirmDialog(true);
    };
    const handleReloadOp = () => __awaiter(void 0, void 0, void 0, function* () {
        const result = yield PinotMethodUtils_1.default.reloadSegmentOp(tableName, segmentName);
        if (result.status) {
            dispatch({ type: 'success', message: result.status, show: true });
            fetchData();
        }
        else {
            dispatch({ type: 'error', message: result.error, show: true });
        }
        closeDialog();
    });
    if (initialLoad) {
        return react_1.default.createElement(AppLoader_1.default, null);
    }
    else if (segmentNotFound) {
        return react_1.default.createElement(NotFound_1.default, { message: `Segment ${segmentName} not found` });
    }
    else {
        return (react_1.default.createElement(core_1.Grid, { item: true, xs: true, style: {
                padding: 20,
                backgroundColor: 'white',
                maxHeight: 'calc(100vh - 70px)',
                overflowY: 'auto',
            } },
            react_1.default.createElement("div", { className: classes.operationDiv },
                react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Operations", showSearchBox: false },
                    react_1.default.createElement("div", null,
                        react_1.default.createElement(CustomButton_1.default, { onClick: () => {
                                handleDeleteSegmentClick();
                            }, tooltipTitle: "Delete Segment", enableTooltip: true }, "Delete Segment"),
                        react_1.default.createElement(CustomButton_1.default, { onClick: () => {
                                handleReloadSegmentClick();
                            }, tooltipTitle: "Reload the segment to apply changes such as indexing, column default values, etc", enableTooltip: true }, "Reload Segment")))),
            react_1.default.createElement("div", { className: classes.highlightBackground },
                react_1.default.createElement(TableToolbar_1.default, { name: "Summary", showSearchBox: false }),
                react_1.default.createElement(core_1.Grid, { container: true, className: classes.body },
                    react_1.default.createElement(core_1.Grid, { item: true, xs: 6 },
                        react_1.default.createElement("strong", null, "Segment Name:"),
                        ' ',
                        unescape(segmentSummary.segmentName)),
                    react_1.default.createElement(core_1.Grid, { item: true, container: true, xs: 2, wrap: "nowrap", spacing: 1 },
                        react_1.default.createElement(core_1.Grid, { item: true },
                            react_1.default.createElement("strong", null, "Total Docs:")),
                        react_1.default.createElement(core_1.Grid, { item: true }, segmentSummary.totalDocs ? (segmentSummary.totalDocs) : (react_1.default.createElement(Skeleton_1.default, { variant: "text", animation: "wave", width: 50 })))),
                    react_1.default.createElement(core_1.Grid, { item: true, container: true, xs: 4, wrap: "nowrap", spacing: 1 },
                        react_1.default.createElement(core_1.Grid, { item: true },
                            react_1.default.createElement("strong", null, "Create Time:")),
                        react_1.default.createElement(core_1.Grid, { item: true }, segmentSummary.createTime ? (segmentSummary.createTime) : (react_1.default.createElement(Skeleton_1.default, { variant: "text", animation: "wave", width: 200 })))))),
            react_1.default.createElement(core_1.Grid, { container: true, spacing: 2 },
                react_1.default.createElement(core_1.Grid, { item: true, xs: 6 },
                    react_1.default.createElement(Table_1.default, { title: "Replica Set", data: replica, showSearchBox: true, inAccordionFormat: true, addLinks: true, baseURL: "/instance/" })),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 6 },
                    react_1.default.createElement("div", { className: classes.sqlDiv },
                        react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Metadata", showSearchBox: false },
                            react_1.default.createElement(react_codemirror2_1.UnControlled, { options: jsonoptions, value: segmentMetadataJson, className: classes.queryOutput, autoCursor: false }))))),
            react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                react_1.default.createElement(Table_1.default, { title: "Indexes", data: indexes, showSearchBox: true, inAccordionFormat: true })),
            confirmDialog && dialogDetails && (react_1.default.createElement(Confirm_1.default, { openDialog: confirmDialog, dialogTitle: dialogDetails.title, dialogContent: dialogDetails.content, successCallback: dialogDetails.successCb, closeDialog: closeDialog, dialogYesLabel: "Yes", dialogNoLabel: "No" }))));
    }
};
exports.default = SegmentDetails;


/***/ }),

/***/ "./app/pages/SubTaskDetail.tsx":
/*!*************************************!*\
  !*** ./app/pages/SubTaskDetail.tsx ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const react_codemirror2_1 = __webpack_require__(/*! react-codemirror2 */ "./node_modules/react-codemirror2/index.js");
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const SimpleAccordion_1 = __importDefault(__webpack_require__(/*! ../components/SimpleAccordion */ "./app/components/SimpleAccordion.tsx"));
const PinotMethodUtils_1 = __importDefault(__webpack_require__(/*! ../utils/PinotMethodUtils */ "./app/utils/PinotMethodUtils.ts"));
const moment_1 = __importDefault(__webpack_require__(/*! moment */ "./node_modules/moment/moment.js"));
const jsonoptions = {
    lineNumbers: true,
    mode: 'application/json',
    styleActiveLine: true,
    gutters: ['CodeMirror-lint-markers'],
    theme: 'default',
    readOnly: true
};
const useStyles = core_1.makeStyles(() => ({
    gridContainer: {
        padding: 20,
        backgroundColor: 'white',
        maxHeight: 'calc(100vh - 70px)',
        overflowY: 'auto'
    },
    operationDiv: {
        border: '1px #BDCCD9 solid',
        borderRadius: 4,
        marginBottom: 20
    },
    body: {
        borderTop: '1px solid #BDCCD9',
        fontSize: '16px',
        lineHeight: '3rem',
        paddingLeft: '15px',
    },
    highlightBackground: {
        border: '1px #4285f4 solid',
        backgroundColor: 'rgba(66, 133, 244, 0.05)',
        borderRadius: 4,
        marginBottom: '20px',
    },
    sqlDiv: {
        border: '1px #BDCCD9 solid',
        borderRadius: 4,
        marginBottom: '20px',
    },
    queryOutput: {
        border: '1px solid #BDCCD9',
        '& .CodeMirror': { maxHeight: 400 },
    },
    taskDetailContainer: {
        overflow: "auto",
        whiteSpace: "pre",
        height: 600
    }
}));
const TaskDetail = (props) => {
    const classes = useStyles();
    const { subTaskID, taskID } = props.match.params;
    const [taskDebugData, setTaskDebugData] = react_1.useState({});
    const [taskProgressData, setTaskProgressData] = react_1.useState("");
    const fetchTaskDebugData = () => __awaiter(void 0, void 0, void 0, function* () {
        const debugRes = yield PinotMethodUtils_1.default.getTaskDebugData(taskID);
        const subTaskData = lodash_1.find(debugRes.data.subtaskInfos, (subTask) => lodash_1.get(subTask, 'taskId', '') === subTaskID);
        setTaskDebugData(subTaskData);
    });
    const fetchTaskProgressData = () => __awaiter(void 0, void 0, void 0, function* () {
        const taskProgressData = yield PinotMethodUtils_1.default.getTaskProgressData(taskID, subTaskID);
        setTaskProgressData(lodash_1.get(taskProgressData, subTaskID, "No Status"));
    });
    react_1.useEffect(() => {
        fetchTaskDebugData();
        fetchTaskProgressData();
    }, []);
    return (react_1.default.createElement(core_1.Grid, { item: true, xs: true, className: classes.gridContainer },
        react_1.default.createElement("div", { className: classes.highlightBackground },
            react_1.default.createElement(core_1.Grid, { container: true, className: classes.body },
                react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                    react_1.default.createElement("strong", null, "Name:"),
                    " ",
                    subTaskID),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                    react_1.default.createElement("strong", null, "Status:"),
                    " ",
                    lodash_1.get(taskDebugData, 'state', '')),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                    react_1.default.createElement("strong", null, "Start Time:"),
                    " ",
                    lodash_1.get(taskDebugData, 'startTime', '')),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                    react_1.default.createElement("strong", null, "Finish Time:"),
                    " ",
                    lodash_1.get(taskDebugData, 'finishTime', '')),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                    react_1.default.createElement("strong", null, "Minion Host Name:"),
                    " ",
                    lodash_1.get(taskDebugData, 'participant', '')))),
        react_1.default.createElement(core_1.Grid, { container: true, spacing: 2 },
            react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                react_1.default.createElement("div", { className: classes.sqlDiv },
                    react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Task Config", showSearchBox: false },
                        react_1.default.createElement(react_codemirror2_1.UnControlled, { options: jsonoptions, value: JSON.stringify(lodash_1.get(taskDebugData, `taskConfig`, {}), null, '  '), className: classes.queryOutput, autoCursor: false })))),
            react_1.default.createElement(core_1.Grid, { item: true, xs: 6 },
                react_1.default.createElement("div", { className: classes.sqlDiv },
                    react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Info", showSearchBox: false },
                        react_1.default.createElement(core_1.Box, { p: 3, className: classes.taskDetailContainer }, lodash_1.get(taskDebugData, `info`, ''))))),
            react_1.default.createElement(core_1.Grid, { item: true, xs: 6 },
                react_1.default.createElement("div", { className: classes.sqlDiv },
                    react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Progress", showSearchBox: false },
                        react_1.default.createElement("div", { style: { overflow: "auto" } },
                            react_1.default.createElement(core_1.List, { style: { width: "max-content" }, className: classes.taskDetailContainer },
                                typeof taskProgressData === "string" && (react_1.default.createElement(core_1.ListItem, null,
                                    react_1.default.createElement(core_1.ListItemText, null, taskProgressData))),
                                typeof taskProgressData !== "string" && taskProgressData.map((data, index) => (react_1.default.createElement("div", { key: index },
                                    react_1.default.createElement(core_1.ListItem, null,
                                        react_1.default.createElement(core_1.ListItemText, { primary: moment_1.default(+data.ts).format('YYYY-MM-DD HH:mm:ss'), secondary: react_1.default.createElement(core_1.Typography, { variant: 'body2' }, data.status) })),
                                    react_1.default.createElement(core_1.Divider, null))))))))))));
};
exports.default = TaskDetail;


/***/ }),

/***/ "./app/pages/TablesListingPage.tsx":
/*!*****************************************!*\
  !*** ./app/pages/TablesListingPage.tsx ***!
  \*****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const CustomButton_1 = __importDefault(__webpack_require__(/*! ../components/CustomButton */ "./app/components/CustomButton.tsx"));
const SimpleAccordion_1 = __importDefault(__webpack_require__(/*! ../components/SimpleAccordion */ "./app/components/SimpleAccordion.tsx"));
const AddSchemaOp_1 = __importDefault(__webpack_require__(/*! ../components/Homepage/Operations/AddSchemaOp */ "./app/components/Homepage/Operations/AddSchemaOp.tsx"));
const AddOfflineTableOp_1 = __importDefault(__webpack_require__(/*! ../components/Homepage/Operations/AddOfflineTableOp */ "./app/components/Homepage/Operations/AddOfflineTableOp.tsx"));
const AddRealtimeTableOp_1 = __importDefault(__webpack_require__(/*! ../components/Homepage/Operations/AddRealtimeTableOp */ "./app/components/Homepage/Operations/AddRealtimeTableOp.tsx"));
const AsyncPinotTables_1 = __importDefault(__webpack_require__(/*! ../components/AsyncPinotTables */ "./app/components/AsyncPinotTables.tsx"));
const AsyncPinotSchemas_1 = __webpack_require__(/*! ../components/AsyncPinotSchemas */ "./app/components/AsyncPinotSchemas.tsx");
const useStyles = core_1.makeStyles(() => ({
    gridContainer: {
        padding: 20,
        backgroundColor: 'white',
        maxHeight: 'calc(100vh - 70px)',
        overflowY: 'auto',
    },
    operationDiv: {
        border: '1px #BDCCD9 solid',
        borderRadius: 4,
        marginBottom: 20,
    },
}));
const TablesListingPage = () => {
    const classes = useStyles();
    const [showSchemaModal, setShowSchemaModal] = react_1.useState(false);
    const [showAddOfflineTableModal, setShowAddOfflineTableModal] = react_1.useState(false);
    const [showAddRealtimeTableModal, setShowAddRealtimeTableModal] = react_1.useState(false);
    // This is used to refresh the tables and schemas data after a new table or schema is added.
    // This is quite hacky, but it's simpler than trying to useRef or useContext to maintain
    // a link between this component and the child table and schema components.
    const [tablesKey, setTablesKey] = react_1.useState(0);
    const [schemasKey, setSchemasKey] = react_1.useState(0);
    return (react_1.default.createElement(core_1.Grid, { item: true, xs: true, className: classes.gridContainer },
        react_1.default.createElement("div", { className: classes.operationDiv },
            react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Operations", showSearchBox: false },
                react_1.default.createElement("div", null,
                    react_1.default.createElement(CustomButton_1.default, { onClick: () => {
                            setShowSchemaModal(true);
                        }, tooltipTitle: "Define the dimensions, metrics and date time columns of your data", enableTooltip: true }, "Add Schema"),
                    react_1.default.createElement(CustomButton_1.default, { onClick: () => {
                            setShowAddOfflineTableModal(true);
                        }, tooltipTitle: "Create a Pinot table to ingest from batch data sources, such as S3", enableTooltip: true }, "Add Offline Table"),
                    react_1.default.createElement(CustomButton_1.default, { onClick: () => {
                            setShowAddRealtimeTableModal(true);
                        }, tooltipTitle: "Create a Pinot table to ingest from stream data sources, such as Kafka", enableTooltip: true }, "Add Realtime Table")))),
        react_1.default.createElement(AsyncPinotTables_1.default, { key: `table-${tablesKey}`, title: "Tables", baseUrl: "/tenants/table/" }),
        react_1.default.createElement(AsyncPinotSchemas_1.AsyncPinotSchemas, { key: `schema-${schemasKey}` }),
        showSchemaModal && (react_1.default.createElement(AddSchemaOp_1.default, { hideModal: () => {
                setShowSchemaModal(false);
            }, fetchData: () => {
                setSchemasKey((prevKey) => prevKey + 1);
            } })),
        showAddOfflineTableModal && (react_1.default.createElement(AddOfflineTableOp_1.default, { hideModal: () => {
                setShowAddOfflineTableModal(false);
            }, fetchData: () => {
                setTablesKey((prevKey) => prevKey + 1);
            }, tableType: 'OFFLINE' })),
        showAddRealtimeTableModal && (react_1.default.createElement(AddRealtimeTableOp_1.default, { hideModal: () => {
                setShowAddRealtimeTableModal(false);
            }, fetchData: () => {
                setTablesKey((prevKey) => prevKey + 1);
            }, tableType: 'REALTIME' }))));
};
exports.default = TablesListingPage;


/***/ }),

/***/ "./app/pages/TaskDetail.tsx":
/*!**********************************!*\
  !*** ./app/pages/TaskDetail.tsx ***!
  \**********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const PinotMethodUtils_1 = __importDefault(__webpack_require__(/*! ../utils/PinotMethodUtils */ "./app/utils/PinotMethodUtils.ts"));
const Table_1 = __importDefault(__webpack_require__(/*! ../components/Table */ "./app/components/Table.tsx"));
const AppLoader_1 = __importDefault(__webpack_require__(/*! ../components/AppLoader */ "./app/components/AppLoader.tsx"));
const SimpleAccordion_1 = __importDefault(__webpack_require__(/*! ../components/SimpleAccordion */ "./app/components/SimpleAccordion.tsx"));
const CustomCodemirror_1 = __importDefault(__webpack_require__(/*! ../components/CustomCodemirror */ "./app/components/CustomCodemirror.tsx"));
const useStyles = core_1.makeStyles(() => ({
    gridContainer: {
        padding: 20,
        backgroundColor: 'white',
        maxHeight: 'calc(100vh - 70px)',
        overflowY: 'auto'
    },
    operationDiv: {
        border: '1px #BDCCD9 solid',
        borderRadius: 4,
        marginBottom: 20
    },
    body: {
        borderTop: '1px solid #BDCCD9',
        fontSize: '16px',
        lineHeight: '3rem',
        paddingLeft: '15px',
    },
    highlightBackground: {
        border: '1px #4285f4 solid',
        backgroundColor: 'rgba(66, 133, 244, 0.05)',
        borderRadius: 4,
        marginBottom: '20px',
    },
    sqlDiv: {
        border: '1px #BDCCD9 solid',
        borderRadius: 4,
        marginBottom: '20px',
    },
    queryOutput: {
        border: '1px solid #BDCCD9',
        '& .CodeMirror': { height: 532 },
    },
    runtimeConfigContainer: {
        '& .CodeMirror': { fontSize: "1rem", height: "100%" },
        maxHeight: 300
    }
}));
const TaskDetail = (props) => {
    const classes = useStyles();
    const { taskID, taskType, queueTableName } = props.match.params;
    const [fetching, setFetching] = react_1.useState(true);
    const [taskDebugData, setTaskDebugData] = react_1.useState({});
    const [subtaskTableData, setSubtaskTableData] = react_1.useState({ columns: ['Task ID', 'Status', 'Start Time', 'Finish Time', 'Minion Host Name'], records: [] });
    const [taskRuntimeConfig, setTaskRuntimeConfig] = react_1.useState(null);
    const fetchData = () => __awaiter(void 0, void 0, void 0, function* () {
        setFetching(true);
        const [debugRes, runtimeConfig] = yield Promise.all([
            PinotMethodUtils_1.default.getTaskDebugData(taskID),
            PinotMethodUtils_1.default.getTaskRuntimeConfigData(taskID)
        ]);
        const subtaskTableRecords = [];
        lodash_1.each(lodash_1.get(debugRes, 'data.subtaskInfos', {}), (subTask) => {
            subtaskTableRecords.push([
                lodash_1.get(subTask, 'taskId'),
                lodash_1.get(subTask, 'state'),
                lodash_1.get(subTask, 'startTime'),
                lodash_1.get(subTask, 'finishTime'),
                lodash_1.get(subTask, 'participant'),
            ]);
        });
        setSubtaskTableData(prevState => {
            return Object.assign(Object.assign({}, prevState), { records: subtaskTableRecords });
        });
        setTaskDebugData(debugRes.data);
        setTaskRuntimeConfig(runtimeConfig);
        setFetching(false);
    });
    react_1.useEffect(() => {
        fetchData();
    }, []);
    if (fetching) {
        return react_1.default.createElement(AppLoader_1.default, null);
    }
    return (react_1.default.createElement(core_1.Grid, { item: true, xs: true, className: classes.gridContainer },
        react_1.default.createElement("div", { className: classes.highlightBackground },
            react_1.default.createElement(core_1.Grid, { container: true, className: classes.body },
                react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                    react_1.default.createElement("strong", null, "Name:"),
                    " ",
                    taskID),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                    react_1.default.createElement("strong", null, "Status:"),
                    " ",
                    lodash_1.get(taskDebugData, 'taskState', '')),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                    react_1.default.createElement("strong", null, "Start Time:"),
                    " ",
                    lodash_1.get(taskDebugData, 'startTime', '')),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                    react_1.default.createElement("strong", null, "Finish Time:"),
                    " ",
                    lodash_1.get(taskDebugData, 'finishTime', '')),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                    react_1.default.createElement("strong", null, "Number of Sub Tasks:"),
                    " ",
                    lodash_1.get(taskDebugData, 'subtaskCount.total', '')))),
        react_1.default.createElement(core_1.Grid, { container: true, spacing: 2 },
            react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Runtime Config", showSearchBox: false, detailsContainerClass: classes.runtimeConfigContainer },
                    react_1.default.createElement(CustomCodemirror_1.default, { data: taskRuntimeConfig }))),
            react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                react_1.default.createElement(Table_1.default, { title: "Sub Tasks", data: subtaskTableData, showSearchBox: true, inAccordionFormat: true, addLinks: true, baseURL: `/task-queue/${taskType}/tables/${queueTableName}/task/${taskID}/sub-task/` })))));
};
exports.default = TaskDetail;


/***/ }),

/***/ "./app/pages/TaskQueue.tsx":
/*!*********************************!*\
  !*** ./app/pages/TaskQueue.tsx ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const SimpleAccordion_1 = __importDefault(__webpack_require__(/*! ../components/SimpleAccordion */ "./app/components/SimpleAccordion.tsx"));
const CustomButton_1 = __importDefault(__webpack_require__(/*! ../components/CustomButton */ "./app/components/CustomButton.tsx"));
const PinotMethodUtils_1 = __importDefault(__webpack_require__(/*! ../utils/PinotMethodUtils */ "./app/utils/PinotMethodUtils.ts"));
const Confirm_1 = __webpack_require__(/*! ../components/Confirm */ "./app/components/Confirm.tsx");
const Table_1 = __importDefault(__webpack_require__(/*! ../components/Table */ "./app/components/Table.tsx"));
const useStyles = core_1.makeStyles(() => ({
    gridContainer: {
        padding: 20,
        backgroundColor: 'white',
        maxHeight: 'calc(100vh - 70px)',
        overflowY: 'auto'
    },
    operationDiv: {
        border: '1px #BDCCD9 solid',
        borderRadius: 4,
        marginBottom: 20
    },
    body: {
        borderTop: '1px solid #BDCCD9',
        fontSize: '16px',
        lineHeight: '3rem',
        paddingLeft: '15px',
    },
    highlightBackground: {
        border: '1px #4285f4 solid',
        backgroundColor: 'rgba(66, 133, 244, 0.05)',
        borderRadius: 4,
        marginBottom: '20px',
    },
}));
const TaskQueue = (props) => {
    const classes = useStyles();
    const { taskType } = props.match.params;
    const [fetching, setFetching] = react_1.useState(true);
    const [taskInfo, setTaskInfo] = react_1.useState([]);
    const [tables, setTables] = react_1.useState({ records: [], columns: ['Name'] });
    const fetchData = () => __awaiter(void 0, void 0, void 0, function* () {
        setFetching(true);
        const taskInfoRes = yield PinotMethodUtils_1.default.getTaskInfo(taskType);
        const tablesResponse = yield PinotMethodUtils_1.default.getTableData({ taskType });
        setTaskInfo(taskInfoRes);
        setTables((prevState) => {
            const _records = lodash_1.map(lodash_1.get(tablesResponse, 'tables', []), table => [table]);
            return Object.assign(Object.assign({}, prevState), { records: _records });
        });
        setFetching(false);
    });
    react_1.useEffect(() => {
        fetchData();
    }, []);
    const handleStopAll = () => __awaiter(void 0, void 0, void 0, function* () {
        yield PinotMethodUtils_1.default.stopAllTasks(taskType);
        yield fetchData();
        stopAllConfirm.setConfirmDialog(false);
    });
    const stopAllConfirm = Confirm_1.useConfirm({
        dialogTitle: 'Stop all tasks',
        dialogContent: 'Are you sure want to stop all the tasks?',
        successCallback: handleStopAll
    });
    const handleResumeAll = () => __awaiter(void 0, void 0, void 0, function* () {
        yield PinotMethodUtils_1.default.resumeAllTasks(taskType);
        yield fetchData();
        resumeAllConfirm.setConfirmDialog(false);
    });
    const resumeAllConfirm = Confirm_1.useConfirm({
        dialogTitle: 'Resume all tasks',
        dialogContent: 'Are you sure want to resume all the tasks?',
        successCallback: handleResumeAll
    });
    const handleCleanupAll = () => __awaiter(void 0, void 0, void 0, function* () {
        yield PinotMethodUtils_1.default.cleanupAllTasks(taskType);
        cleanupAllConfirm.setConfirmDialog(false);
    });
    const cleanupAllConfirm = Confirm_1.useConfirm({
        dialogTitle: 'Cleanup all tasks',
        dialogContent: 'Are you sure want to cleanup all the tasks?',
        successCallback: handleCleanupAll
    });
    const handleDeleteAll = () => __awaiter(void 0, void 0, void 0, function* () {
        yield PinotMethodUtils_1.default.deleteAllTasks(taskType);
        deleteAllConfirm.setConfirmDialog(false);
    });
    const deleteAllConfirm = Confirm_1.useConfirm({
        dialogTitle: 'Delete all tasks',
        dialogContent: 'Are you sure want to delete all the tasks?',
        successCallback: handleDeleteAll
    });
    return (react_1.default.createElement(core_1.Grid, { item: true, xs: true, className: classes.gridContainer },
        react_1.default.createElement("div", { className: classes.operationDiv },
            react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Operations", showSearchBox: false },
                react_1.default.createElement("div", null,
                    react_1.default.createElement(CustomButton_1.default, { onClick: () => stopAllConfirm.setConfirmDialog(true), tooltipTitle: "Stop all running/pending tasks (as well as the task queue) for the given task type. Any new task added will not be picked up until Task Queue is resumed. This is not an instant operation, and the task may take some more time to actually stop.", enableTooltip: true }, "Stop All"),
                    react_1.default.createElement(CustomButton_1.default, { onClick: () => resumeAllConfirm.setConfirmDialog(true), tooltipTitle: "Resume all stopped tasks (as well as the task queue) for the given task type. Resumed tasks start from the beginning of the task.", enableTooltip: true }, "Resume All"),
                    react_1.default.createElement(CustomButton_1.default, { onClick: () => cleanupAllConfirm.setConfirmDialog(true), tooltipTitle: "Clean up finished tasks (COMPLETED, FAILED) for the given task type. This has no impact on the executing tasks. This happens periodically ", enableTooltip: true }, "Cleanup All"),
                    react_1.default.createElement(CustomButton_1.default, { onClick: () => deleteAllConfirm.setConfirmDialog(true), tooltipTitle: "Delete all tasks (as well as the task queue) for the given task type.", enableTooltip: true }, "Delete All")))),
        react_1.default.createElement("div", { className: classes.highlightBackground },
            react_1.default.createElement(core_1.Grid, { container: true, className: classes.body },
                react_1.default.createElement(core_1.Grid, { item: true, xs: 4 },
                    react_1.default.createElement("strong", null, "Task Type:"),
                    " ",
                    taskType),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 4 },
                    react_1.default.createElement("strong", null, "Task Queue Status:"),
                    " ",
                    lodash_1.get(taskInfo, '1', null)),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 4 },
                    react_1.default.createElement("strong", null, "Num Tasks: "),
                    lodash_1.get(taskInfo, '0', null)))),
        !fetching && (react_1.default.createElement(Table_1.default, { title: "Tables", data: tables, showSearchBox: true, inAccordionFormat: true, addLinks: true, baseURL: `/task-queue/${taskType}/tables/` })),
        stopAllConfirm.confirmComponent,
        resumeAllConfirm.confirmComponent,
        cleanupAllConfirm.confirmComponent,
        deleteAllConfirm.confirmComponent));
};
exports.default = TaskQueue;


/***/ }),

/***/ "./app/pages/TaskQueueTable.tsx":
/*!**************************************!*\
  !*** ./app/pages/TaskQueueTable.tsx ***!
  \**************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const moment_1 = __importDefault(__webpack_require__(/*! moment */ "./node_modules/moment/moment.js"));
const react_codemirror2_1 = __webpack_require__(/*! react-codemirror2 */ "./node_modules/react-codemirror2/index.js");
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const NotificationContext_1 = __webpack_require__(/*! ../components/Notification/NotificationContext */ "./app/components/Notification/NotificationContext.tsx");
const SimpleAccordion_1 = __importDefault(__webpack_require__(/*! ../components/SimpleAccordion */ "./app/components/SimpleAccordion.tsx"));
const CustomButton_1 = __importDefault(__webpack_require__(/*! ../components/CustomButton */ "./app/components/CustomButton.tsx"));
const Confirm_1 = __webpack_require__(/*! ../components/Confirm */ "./app/components/Confirm.tsx");
const PinotMethodUtils_1 = __importDefault(__webpack_require__(/*! ../utils/PinotMethodUtils */ "./app/utils/PinotMethodUtils.ts"));
const useScheduleAdhocModal_1 = __importDefault(__webpack_require__(/*! ../components/useScheduleAdhocModal */ "./app/components/useScheduleAdhocModal.tsx"));
const useMinionMetaData_1 = __importDefault(__webpack_require__(/*! ../components/useMinionMetaData */ "./app/components/useMinionMetaData.tsx"));
const useTaskListing_1 = __importDefault(__webpack_require__(/*! ../components/useTaskListing */ "./app/components/useTaskListing.tsx"));
const jsonoptions = {
    lineNumbers: true,
    mode: 'application/json',
    styleActiveLine: true,
    gutters: ['CodeMirror-lint-markers'],
    theme: 'default',
    readOnly: true
};
const useStyles = core_1.makeStyles(() => ({
    gridContainer: {
        padding: 20,
        backgroundColor: 'white',
        maxHeight: 'calc(100vh - 70px)',
        overflowY: 'auto'
    },
    operationDiv: {
        border: '1px #BDCCD9 solid',
        borderRadius: 4,
        marginBottom: 20
    },
    body: {
        borderTop: '1px solid #BDCCD9',
        fontSize: '16px',
        lineHeight: '3rem',
        paddingLeft: '15px',
    },
    highlightBackground: {
        border: '1px #4285f4 solid',
        backgroundColor: 'rgba(66, 133, 244, 0.05)',
        borderRadius: 4,
        marginBottom: '20px',
    },
    sqlDiv: {
        border: '1px #BDCCD9 solid',
        borderRadius: 4,
        marginBottom: '20px',
    },
    queryOutput: {
        border: '1px solid #BDCCD9',
        '& .CodeMirror': { height: 532 },
    },
}));
const TaskQueueTable = (props) => {
    const classes = useStyles();
    const { taskType, queueTableName: tableName } = props.match.params;
    const { dispatch } = react_1.useContext(NotificationContext_1.NotificationContext);
    const [fetching, setFetching] = react_1.useState(true);
    const [jobDetail, setJobDetail] = react_1.useState({});
    const [tableDetail, setTableDetail] = react_1.useState({});
    const [mostRecentErrorRunMessage, setMostRecentErrorRunMessage] = react_1.useState('');
    const scheduleAdhocModal = useScheduleAdhocModal_1.default();
    const minionMetadata = useMinionMetaData_1.default({ taskType, tableName });
    const taskListing = useTaskListing_1.default({ taskType, tableName });
    const fetchData = () => __awaiter(void 0, void 0, void 0, function* () {
        setFetching(true);
        const detail = yield PinotMethodUtils_1.default.getScheduleJobDetail(tableName, taskType);
        const tableDetailRes = yield PinotMethodUtils_1.default.getTableDetails(tableName);
        const taskGeneratorDebugData = yield PinotMethodUtils_1.default.getTaskGeneratorDebugData(tableName, taskType);
        const mostRecentErrorRunMessagesTS = lodash_1.get(taskGeneratorDebugData, 'data.0.mostRecentErrorRunMessages', {});
        const mostRecentErrorRunMessagesTSLastTime = lodash_1.last(lodash_1.keys(mostRecentErrorRunMessagesTS).sort());
        setMostRecentErrorRunMessage(lodash_1.get(mostRecentErrorRunMessagesTS, mostRecentErrorRunMessagesTSLastTime, ''));
        setTableDetail(tableDetailRes);
        setJobDetail(detail);
        setFetching(false);
    });
    react_1.useEffect(() => {
        fetchData();
    }, []);
    const handleScheduleNow = () => __awaiter(void 0, void 0, void 0, function* () {
        const res = yield PinotMethodUtils_1.default.scheduleTaskAction(tableName, taskType);
        if (lodash_1.get(res, `${taskType}`, null) === null) {
            dispatch({
                type: 'error',
                message: `Could not schedule task`,
                show: true
            });
        }
        else {
            dispatch({
                type: 'success',
                message: `${lodash_1.get(res, `${taskType}`, null)} scheduled successfully`,
                show: true
            });
        }
        yield fetchData();
        scheduleNowConfirm.setConfirmDialog(false);
    });
    const scheduleNowConfirm = Confirm_1.useConfirm({
        dialogTitle: 'Schedule now',
        dialogContent: 'Are you sure want to schedule now?',
        successCallback: handleScheduleNow
    });
    const cronExpression = lodash_1.get(jobDetail, 'Triggers.0.CronExpression', '');
    const previousFireTime = lodash_1.get(jobDetail, 'Triggers.0.PreviousFireTime', 0);
    const nextFireTime = lodash_1.get(jobDetail, 'Triggers.0.NextFireTime', 0);
    return (react_1.default.createElement(core_1.Grid, { item: true, xs: true, className: classes.gridContainer },
        react_1.default.createElement("div", { className: classes.operationDiv },
            react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Operations", showSearchBox: false },
                react_1.default.createElement("div", null,
                    react_1.default.createElement(CustomButton_1.default, { onClick: () => scheduleNowConfirm.setConfirmDialog(true), tooltipTitle: "Schedule now", enableTooltip: true }, "Schedule Now"),
                    react_1.default.createElement(CustomButton_1.default, { onClick: () => scheduleAdhocModal.handleOpen(), tooltipTitle: "Execute ADHOC", enableTooltip: true }, "Schedule ADHOC")))),
        react_1.default.createElement("div", { className: classes.highlightBackground },
            react_1.default.createElement(core_1.Grid, { container: true, className: classes.body },
                react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                    react_1.default.createElement("strong", null, "Table Name:"),
                    " ",
                    tableName),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                    react_1.default.createElement("strong", null, "Cron Schedule :"),
                    " ",
                    cronExpression),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                    react_1.default.createElement("strong", null, "Previous Fire Time: "),
                    " ",
                    previousFireTime ? moment_1.default(previousFireTime).toString() : '-'),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 12 },
                    react_1.default.createElement("strong", null, "Next Fire Time: "),
                    " ",
                    nextFireTime ? moment_1.default(nextFireTime).toString() : '-'))),
        react_1.default.createElement(core_1.Grid, { container: true, spacing: 2 },
            react_1.default.createElement(core_1.Grid, { item: true, xs: 6 },
                react_1.default.createElement("div", { className: classes.sqlDiv },
                    react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Task Config", showSearchBox: false },
                        react_1.default.createElement(react_codemirror2_1.UnControlled, { options: jsonoptions, value: JSON.stringify(lodash_1.get(tableDetail, `OFFLINE.task.taskTypeConfigsMap.${taskType}`, {}), null, '  '), className: classes.queryOutput, autoCursor: false })))),
            react_1.default.createElement(core_1.Grid, { item: true, xs: 6 },
                react_1.default.createElement("div", { className: classes.sqlDiv }, minionMetadata.content),
                react_1.default.createElement("div", { className: classes.sqlDiv },
                    react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Scheduling Errors", showSearchBox: false },
                        react_1.default.createElement(core_1.Box, { p: 3, style: { overflow: 'auto' } }, mostRecentErrorRunMessage)))),
            react_1.default.createElement(core_1.Grid, { item: true, xs: 12 }, taskListing.content)),
        scheduleAdhocModal.dialog,
        scheduleNowConfirm.confirmComponent));
};
exports.default = TaskQueueTable;


/***/ }),

/***/ "./app/pages/TenantDetails.tsx":
/*!*************************************!*\
  !*** ./app/pages/TenantDetails.tsx ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const styles_1 = __webpack_require__(/*! @material-ui/core/styles */ "./node_modules/@material-ui/core/esm/styles/index.js");
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const react_router_dom_1 = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router-dom/esm/react-router-dom.js");
const react_codemirror2_1 = __webpack_require__(/*! react-codemirror2 */ "./node_modules/react-codemirror2/index.js");
const AppLoader_1 = __importDefault(__webpack_require__(/*! ../components/AppLoader */ "./app/components/AppLoader.tsx"));
const Table_1 = __importDefault(__webpack_require__(/*! ../components/Table */ "./app/components/Table.tsx"));
const TableToolbar_1 = __importDefault(__webpack_require__(/*! ../components/TableToolbar */ "./app/components/TableToolbar.tsx"));
__webpack_require__(/*! codemirror/lib/codemirror.css */ "./node_modules/codemirror/lib/codemirror.css");
__webpack_require__(/*! codemirror/theme/material.css */ "./node_modules/codemirror/theme/material.css");
__webpack_require__(/*! codemirror/mode/javascript/javascript */ "./node_modules/codemirror/mode/javascript/javascript.js");
__webpack_require__(/*! codemirror/mode/sql/sql */ "./node_modules/codemirror/mode/sql/sql.js");
const SimpleAccordion_1 = __importDefault(__webpack_require__(/*! ../components/SimpleAccordion */ "./app/components/SimpleAccordion.tsx"));
const PinotMethodUtils_1 = __importDefault(__webpack_require__(/*! ../utils/PinotMethodUtils */ "./app/utils/PinotMethodUtils.ts"));
const CustomButton_1 = __importDefault(__webpack_require__(/*! ../components/CustomButton */ "./app/components/CustomButton.tsx"));
const EditConfigOp_1 = __importDefault(__webpack_require__(/*! ../components/Homepage/Operations/EditConfigOp */ "./app/components/Homepage/Operations/EditConfigOp.tsx"));
const ReloadStatusOp_1 = __importDefault(__webpack_require__(/*! ../components/Homepage/Operations/ReloadStatusOp */ "./app/components/Homepage/Operations/ReloadStatusOp.tsx"));
const RebalanceServerTableOp_1 = __importDefault(__webpack_require__(/*! ../components/Homepage/Operations/RebalanceServerTableOp */ "./app/components/Homepage/Operations/RebalanceServerTableOp.tsx"));
const Confirm_1 = __importDefault(__webpack_require__(/*! ../components/Confirm */ "./app/components/Confirm.tsx"));
const NotificationContext_1 = __webpack_require__(/*! ../components/Notification/NotificationContext */ "./app/components/Notification/NotificationContext.tsx");
const Utils_1 = __importDefault(__webpack_require__(/*! ../utils/Utils */ "./app/utils/Utils.tsx"));
const InfoOutlined_1 = __importDefault(__webpack_require__(/*! @material-ui/icons/InfoOutlined */ "./node_modules/@material-ui/icons/InfoOutlined.js"));
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const SegmentStatusRenderer_1 = __webpack_require__(/*! ../components/SegmentStatusRenderer */ "./app/components/SegmentStatusRenderer.tsx");
const Skeleton_1 = __importDefault(__webpack_require__(/*! @material-ui/lab/Skeleton */ "./node_modules/@material-ui/lab/esm/Skeleton/index.js"));
const NotFound_1 = __importDefault(__webpack_require__(/*! ../components/NotFound */ "./app/components/NotFound.tsx"));
const useStyles = styles_1.makeStyles((theme) => ({
    root: {
        border: '1px #BDCCD9 solid',
        borderRadius: 4,
        marginBottom: '20px',
    },
    highlightBackground: {
        border: '1px #4285f4 solid',
        backgroundColor: 'rgba(66, 133, 244, 0.05)',
        borderRadius: 4,
        marginBottom: '20px',
    },
    body: {
        borderTop: '1px solid #BDCCD9',
        fontSize: '16px',
        lineHeight: '3rem',
        paddingLeft: '15px',
    },
    queryOutput: {
        border: '1px solid #BDCCD9',
        '& .CodeMirror': { height: 532 },
    },
    sqlDiv: {
        border: '1px #BDCCD9 solid',
        borderRadius: 4,
        marginBottom: '20px',
    },
    operationDiv: {
        border: '1px #BDCCD9 solid',
        borderRadius: 4,
        marginBottom: 20
    },
    copyIdButton: {
        paddingBlock: 0,
        marginLeft: 10
    }
}));
const jsonoptions = {
    lineNumbers: true,
    mode: 'application/json',
    styleActiveLine: true,
    gutters: ['CodeMirror-lint-markers'],
    theme: 'default',
    readOnly: true
};
const TenantPageDetails = ({ match }) => {
    const { tenantName, tableName, instanceName } = match.params;
    const classes = useStyles();
    const history = react_router_dom_1.useHistory();
    const location = react_router_dom_1.useLocation();
    const [fetching, setFetching] = react_1.useState(true);
    const [tableNotFound, setTableNotFound] = react_1.useState(false);
    const initialTableSummary = {
        tableName: match.params.tableName,
        reportedSize: null,
        estimatedSize: null,
    };
    const [tableSummary, setTableSummary] = react_1.useState(initialTableSummary);
    const [tableState, setTableState] = react_1.default.useState({
        enabled: true,
    });
    const [confirmDialog, setConfirmDialog] = react_1.default.useState(false);
    const [dialogDetails, setDialogDetails] = react_1.default.useState(null);
    const { dispatch } = react_1.default.useContext(NotificationContext_1.NotificationContext);
    const [showEditConfig, setShowEditConfig] = react_1.useState(false);
    const [config, setConfig] = react_1.useState('{}');
    const instanceColumns = ["Instance Name", "# of segments"];
    const loadingInstanceData = Utils_1.default.getLoadingTableData(instanceColumns);
    const [instanceCountData, setInstanceCountData] = react_1.useState(loadingInstanceData);
    const segmentListColumns = ['Segment Name', 'Status'];
    const loadingSegmentList = Utils_1.default.getLoadingTableData(segmentListColumns);
    const [segmentList, setSegmentList] = react_1.useState(loadingSegmentList);
    const [tableSchema, setTableSchema] = react_1.useState({
        columns: [],
        records: [],
    });
    const [tableType, setTableType] = react_1.useState('');
    const [tableConfig, setTableConfig] = react_1.useState('');
    const [schemaJSON, setSchemaJSON] = react_1.useState(null);
    const [actionType, setActionType] = react_1.useState(null);
    const [showReloadStatusModal, setShowReloadStatusModal] = react_1.useState(false);
    const [reloadStatusData, setReloadStatusData] = react_1.useState(null);
    const [tableJobsData, setTableJobsData] = react_1.useState(null);
    const [showRebalanceServerModal, setShowRebalanceServerModal] = react_1.useState(false);
    const [schemaJSONFormat, setSchemaJSONFormat] = react_1.useState(false);
    const fetchTableData = () => __awaiter(void 0, void 0, void 0, function* () {
        // We keep all the fetching inside this component since we need to be able
        // to handle users making changes to the table and then reloading the json.
        setFetching(true);
        fetchSyncTableData().then(() => {
            setFetching(false);
            if (!tableNotFound) {
                fetchAsyncTableData();
            }
        });
    });
    const fetchSyncTableData = () => __awaiter(void 0, void 0, void 0, function* () {
        return Promise.all([
            fetchTableSchema(),
            fetchTableJSON(),
        ]);
    });
    const fetchAsyncTableData = () => __awaiter(void 0, void 0, void 0, function* () {
        // set async data back to loading
        setTableSummary(initialTableSummary);
        setInstanceCountData(loadingInstanceData);
        setSegmentList(loadingSegmentList);
        // load async data
        PinotMethodUtils_1.default.getTableSummaryData(tableName).then((result) => {
            setTableSummary(result);
        });
        fetchSegmentData();
    });
    const fetchSegmentData = () => __awaiter(void 0, void 0, void 0, function* () {
        const result = yield PinotMethodUtils_1.default.getSegmentList(tableName);
        const { columns, records, externalViewObj } = result;
        const instanceObj = {};
        externalViewObj && Object.keys(externalViewObj).map((segmentName) => {
            const instanceKeys = Object.keys(externalViewObj[segmentName]);
            instanceKeys.map((instanceName) => {
                if (!instanceObj[instanceName]) {
                    instanceObj[instanceName] = 0;
                }
                instanceObj[instanceName] += 1;
            });
        });
        const instanceRecords = [];
        Object.keys(instanceObj).map((instanceName) => {
            instanceRecords.push([instanceName, instanceObj[instanceName]]);
        });
        setInstanceCountData({
            columns: instanceColumns,
            records: instanceRecords
        });
        const segmentTableRows = [];
        records.forEach(([name, status]) => segmentTableRows.push([
            name,
            {
                customRenderer: (react_1.default.createElement(SegmentStatusRenderer_1.SegmentStatusRenderer, { segmentName: name, tableName: tableName, status: status })),
            },
        ]));
        setSegmentList({ columns, records: segmentTableRows });
    });
    const fetchTableSchema = () => __awaiter(void 0, void 0, void 0, function* () {
        const result = yield PinotMethodUtils_1.default.getTableSchemaData(tableName);
        if (result.error) {
            setSchemaJSON(null);
            setTableSchema({
                columns: ['Column', 'Type', 'Field Type', 'Multi Value'],
                records: []
            });
        }
        else {
            setSchemaJSON(JSON.parse(JSON.stringify(result)));
            const tableSchema = Utils_1.default.syncTableSchemaData(result, true);
            setTableSchema(tableSchema);
        }
    });
    const fetchTableJSON = () => __awaiter(void 0, void 0, void 0, function* () {
        return PinotMethodUtils_1.default.getTableDetails(tableName).then((result) => {
            if (result.error) {
                dispatch({ type: 'error', message: result.error, show: true });
            }
            else {
                if (lodash_1.isEmpty(result)) {
                    setTableNotFound(true);
                    return;
                }
                const tableObj = result.OFFLINE || result.REALTIME;
                setTableType(tableObj.tableType);
                setTableConfig(JSON.stringify(result, null, 2));
                return fetchTableState(tableObj.tableType);
            }
        });
    });
    const fetchTableState = (type) => __awaiter(void 0, void 0, void 0, function* () {
        return PinotMethodUtils_1.default.getTableState(tableName, type)
            .then((stateResponse) => {
            return setTableState({ enabled: stateResponse.state === 'enabled' });
        });
    });
    react_1.useEffect(() => {
        fetchTableData();
    }, []);
    const handleSwitchChange = (event) => {
        setDialogDetails({
            title: tableState.enabled ? 'Disable Table' : 'Enable Table',
            content: `Are you sure want to ${tableState.enabled ? 'disable' : 'enable'} this table?`,
            successCb: () => toggleTableState()
        });
        setConfirmDialog(true);
    };
    const toggleTableState = () => __awaiter(void 0, void 0, void 0, function* () {
        const result = yield PinotMethodUtils_1.default.toggleTableState(tableName, tableState.enabled ? "disable" /* DISABLE */ : "enable" /* ENABLE */, tableType.toLowerCase());
        syncResponse(result);
    });
    const handleConfigChange = (value) => {
        setConfig(value);
    };
    const saveConfigAction = () => __awaiter(void 0, void 0, void 0, function* () {
        let configObj = JSON.parse(config);
        if (actionType === 'editTable') {
            if (configObj.OFFLINE || configObj.REALTIME) {
                configObj = configObj.OFFLINE || configObj.REALTIME;
            }
            const result = yield PinotMethodUtils_1.default.updateTable(tableName, configObj);
            syncResponse(result);
        }
        else if (actionType === 'editSchema') {
            const result = yield PinotMethodUtils_1.default.updateSchema(schemaJSON.schemaName, configObj);
            syncResponse(result);
        }
    });
    const syncResponse = (result, customMessage) => {
        if (result.status) {
            dispatch({ type: 'success', message: customMessage || result.status, show: true });
            fetchTableData();
            setShowEditConfig(false);
        }
        else {
            dispatch({ type: 'error', message: result.error, show: true });
        }
        closeDialog();
    };
    const handleDeleteTableAction = () => {
        setDialogDetails({
            title: 'Delete Table',
            content: 'Are you sure want to delete this table? All data and configs will be deleted.',
            successCb: () => deleteTable()
        });
        setConfirmDialog(true);
    };
    const deleteTable = () => __awaiter(void 0, void 0, void 0, function* () {
        const result = yield PinotMethodUtils_1.default.deleteTableOp(tableName);
        if (result.status) {
            dispatch({ type: 'success', message: result.status, show: true });
        }
        else {
            dispatch({ type: 'error', message: result.error, show: true });
        }
        closeDialog();
        if (result.status) {
            setTimeout(() => {
                if (tenantName) {
                    history.push(Utils_1.default.navigateToPreviousPage(location, true));
                }
                else {
                    history.push('/tables');
                }
            }, 1000);
        }
    });
    const handleDeleteSchemaAction = () => {
        setDialogDetails({
            title: 'Delete Schema',
            content: 'Are you sure want to delete this schema? Any tables using this schema might not function correctly.',
            successCb: () => deleteSchema()
        });
        setConfirmDialog(true);
    };
    const deleteSchema = () => __awaiter(void 0, void 0, void 0, function* () {
        const result = yield PinotMethodUtils_1.default.deleteSchemaOp(schemaJSON.schemaName);
        syncResponse(result);
    });
    const handleReloadSegments = () => {
        setDialogDetails({
            title: 'Reload all segments',
            content: 'Are you sure want to reload all the segments?',
            successCb: () => reloadSegments()
        });
        setConfirmDialog(true);
    };
    const reloadSegments = () => __awaiter(void 0, void 0, void 0, function* () {
        const result = yield PinotMethodUtils_1.default.reloadAllSegmentsOp(tableName, tableType);
        let reloadJobId = null;
        try {
            // extract reloadJobId from response
            const statusResponseObj = JSON.parse(result.status);
            reloadJobId = lodash_1.get(statusResponseObj, `${tableName}.reloadJobId`, null);
        }
        catch (_a) {
            reloadJobId = null;
        }
        const handleCopyReloadJobId = () => {
            if (!reloadJobId) {
                return;
            }
            navigator.clipboard.writeText(reloadJobId);
        };
        const customMessage = (react_1.default.createElement(core_1.Box, null,
            react_1.default.createElement(core_1.Typography, { variant: 'inherit' }, result.status),
            react_1.default.createElement(core_1.Button, { className: classes.copyIdButton, variant: "outlined", color: "inherit", size: "small", onClick: handleCopyReloadJobId }, "Copy Id")));
        syncResponse(result, reloadJobId && customMessage);
    });
    const handleReloadStatus = () => __awaiter(void 0, void 0, void 0, function* () {
        try {
            setShowReloadStatusModal(true);
            const [reloadStatusData, tableJobsData] = yield Promise.all([
                PinotMethodUtils_1.default.reloadStatusOp(tableName, tableType),
                PinotMethodUtils_1.default.fetchTableJobs(tableName, "RELOAD_SEGMENT"),
            ]);
            if (reloadStatusData.error || tableJobsData.error) {
                dispatch({ type: 'error', message: reloadStatusData.error || tableJobsData.error, show: true });
                setShowReloadStatusModal(false);
                return;
            }
            setReloadStatusData(reloadStatusData);
            setTableJobsData(tableJobsData);
        }
        catch (error) {
            dispatch({ type: 'error', message: error, show: true });
            setShowReloadStatusModal(false);
        }
    });
    const handleRebalanceBrokers = () => {
        setDialogDetails({
            title: (react_1.default.createElement(react_1.default.Fragment, null,
                "Rebalance brokers ",
                react_1.default.createElement(core_1.Tooltip, { interactive: true, title: (react_1.default.createElement("a", { className: "tooltip-link", target: "_blank", href: "https://docs.pinot.apache.org/operators/operating-pinot/rebalance/rebalance-brokers" }, "Click here for more details")), arrow: true, placement: "top" },
                    react_1.default.createElement(InfoOutlined_1.default, null)))),
            content: 'Are you sure want to rebalance the brokers?',
            successCb: () => rebalanceBrokers()
        });
        setConfirmDialog(true);
    };
    const rebalanceBrokers = () => __awaiter(void 0, void 0, void 0, function* () {
        const result = yield PinotMethodUtils_1.default.rebalanceBrokersForTableOp(tableName);
        syncResponse(result);
    });
    const closeDialog = () => {
        setConfirmDialog(false);
        setDialogDetails(null);
    };
    if (fetching) {
        return react_1.default.createElement(AppLoader_1.default, null);
    }
    else if (tableNotFound) {
        return react_1.default.createElement(NotFound_1.default, { message: `Table ${tableName} not found` });
    }
    else {
        return (react_1.default.createElement(core_1.Grid, { item: true, xs: true, style: {
                padding: 20,
                backgroundColor: 'white',
                maxHeight: 'calc(100vh - 70px)',
                overflowY: 'auto',
            } },
            react_1.default.createElement("div", { className: classes.operationDiv },
                react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Operations", showSearchBox: false },
                    react_1.default.createElement("div", null,
                        react_1.default.createElement(CustomButton_1.default, { onClick: () => {
                                setActionType('editTable');
                                setConfig(tableConfig);
                                setShowEditConfig(true);
                            }, tooltipTitle: "Edit Table", enableTooltip: true }, "Edit Table"),
                        react_1.default.createElement(CustomButton_1.default, { onClick: handleDeleteTableAction, tooltipTitle: "Delete Table", enableTooltip: true }, "Delete Table"),
                        react_1.default.createElement(CustomButton_1.default, { onClick: () => {
                                setActionType('editSchema');
                                setConfig(JSON.stringify(schemaJSON, null, 2));
                                setShowEditConfig(true);
                            }, tooltipTitle: "Edit Schema", enableTooltip: true }, "Edit Schema"),
                        react_1.default.createElement(CustomButton_1.default, { isDisabled: !schemaJSON, onClick: handleDeleteSchemaAction, tooltipTitle: "Delete Schema", enableTooltip: true }, "Delete Schema"),
                        react_1.default.createElement(CustomButton_1.default, { isDisabled: true, onClick: () => { }, tooltipTitle: "Truncate Table", enableTooltip: true }, "Truncate Table"),
                        react_1.default.createElement(CustomButton_1.default, { onClick: handleReloadSegments, tooltipTitle: "Reloads all segments of the table to apply changes such as indexing, column default values, etc", enableTooltip: true }, "Reload All Segments"),
                        react_1.default.createElement(CustomButton_1.default, { onClick: handleReloadStatus, tooltipTitle: "The status of all indexes for each column", enableTooltip: true }, "Reload Status"),
                        react_1.default.createElement(CustomButton_1.default, { onClick: () => { setShowRebalanceServerModal(true); }, tooltipTitle: "Recalculates the segment to server mapping for this table", enableTooltip: true }, "Rebalance Servers"),
                        react_1.default.createElement(CustomButton_1.default, { onClick: handleRebalanceBrokers, tooltipTitle: "Rebuilds brokerResource mapping for this table", enableTooltip: true }, "Rebalance Brokers"),
                        react_1.default.createElement(core_1.Tooltip, { title: "Disabling will disable the table for queries, consumption and data push", arrow: true, placement: "top" },
                            react_1.default.createElement(core_1.FormControlLabel, { control: react_1.default.createElement(core_1.Switch, { checked: tableState.enabled, onChange: handleSwitchChange, name: "enabled", color: "primary" }), label: "Enable" }))))),
            react_1.default.createElement("div", { className: classes.highlightBackground },
                react_1.default.createElement(TableToolbar_1.default, { name: "Summary", showSearchBox: false }),
                react_1.default.createElement(core_1.Grid, { container: true, spacing: 2, alignItems: "center", className: classes.body },
                    react_1.default.createElement(core_1.Grid, { item: true, xs: 4 },
                        react_1.default.createElement("strong", null, "Table Name:"),
                        " ",
                        tableSummary.tableName),
                    react_1.default.createElement(core_1.Grid, { item: true, container: true, xs: 4, wrap: "nowrap", spacing: 1 },
                        react_1.default.createElement(core_1.Grid, { item: true },
                            react_1.default.createElement(core_1.Tooltip, { title: "Uncompressed size of all data segments with replication", arrow: true, placement: "top" },
                                react_1.default.createElement("strong", null, "Reported Size:"))),
                        react_1.default.createElement(core_1.Grid, { item: true }, tableSummary.reportedSize ?
                            Utils_1.default.formatBytes(tableSummary.reportedSize) :
                            react_1.default.createElement(Skeleton_1.default, { variant: "text", animation: "wave", width: 100 }))),
                    react_1.default.createElement(core_1.Grid, { item: true, container: true, xs: 4, wrap: "nowrap", spacing: 1 },
                        react_1.default.createElement(core_1.Grid, { item: true },
                            react_1.default.createElement(core_1.Tooltip, { title: "Estimated size of all data segments with replication, in case any servers are not reachable for actual size", arrow: true, placement: "top-start" },
                                react_1.default.createElement("strong", null, "Estimated Size: "))),
                        react_1.default.createElement(core_1.Grid, { item: true }, tableSummary.estimatedSize ?
                            Utils_1.default.formatBytes(tableSummary.estimatedSize) :
                            react_1.default.createElement(Skeleton_1.default, { variant: "text", animation: "wave", width: 100 }))))),
            react_1.default.createElement(core_1.Grid, { container: true, spacing: 2 },
                react_1.default.createElement(core_1.Grid, { item: true, xs: 6 },
                    react_1.default.createElement("div", { className: classes.sqlDiv },
                        react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Table Config", showSearchBox: false },
                            react_1.default.createElement(react_codemirror2_1.UnControlled, { options: jsonoptions, value: tableConfig, className: classes.queryOutput, autoCursor: false }))),
                    react_1.default.createElement(Table_1.default, { title: "Segments - " + segmentList.records.length, data: segmentList, baseURL: tenantName && `/tenants/${tenantName}/table/${tableName}/` ||
                            instanceName && `/instance/${instanceName}/table/${tableName}/` ||
                            `/tenants/table/${tableName}/`, addLinks: true, showSearchBox: true, inAccordionFormat: true })),
                react_1.default.createElement(core_1.Grid, { item: true, xs: 6 },
                    !schemaJSONFormat ?
                        react_1.default.createElement(Table_1.default, { title: "Table Schema", data: tableSchema, showSearchBox: true, inAccordionFormat: true, accordionToggleObject: {
                                toggleName: "JSON Format",
                                toggleValue: schemaJSONFormat,
                                toggleChangeHandler: () => { setSchemaJSONFormat(!schemaJSONFormat); }
                            } })
                        :
                            react_1.default.createElement("div", { className: classes.sqlDiv },
                                react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Table Schema", showSearchBox: false, accordionToggleObject: {
                                        toggleName: "JSON Format",
                                        toggleValue: schemaJSONFormat,
                                        toggleChangeHandler: () => { setSchemaJSONFormat(!schemaJSONFormat); }
                                    } },
                                    react_1.default.createElement(react_codemirror2_1.UnControlled, { options: jsonoptions, value: JSON.stringify(schemaJSON, null, 2), className: classes.queryOutput, autoCursor: false }))),
                    react_1.default.createElement(Table_1.default, { title: "Instance Count - " + instanceCountData.records.length, data: instanceCountData, addLinks: true, baseURL: "/instance/", showSearchBox: true, inAccordionFormat: true }))),
            react_1.default.createElement(EditConfigOp_1.default, { showModal: showEditConfig, hideModal: () => { setShowEditConfig(false); }, saveConfig: saveConfigAction, config: config, handleConfigChange: handleConfigChange }),
            showReloadStatusModal &&
                react_1.default.createElement(ReloadStatusOp_1.default, { hideModal: () => { setShowReloadStatusModal(false); setReloadStatusData(null); }, reloadStatusData: reloadStatusData, tableJobsData: tableJobsData }),
            showRebalanceServerModal &&
                react_1.default.createElement(RebalanceServerTableOp_1.default, { hideModal: () => { setShowRebalanceServerModal(false); }, tableType: tableType.toUpperCase(), tableName: tableName }),
            confirmDialog && dialogDetails && react_1.default.createElement(Confirm_1.default, { openDialog: confirmDialog, dialogTitle: dialogDetails.title, dialogContent: dialogDetails.content, successCallback: dialogDetails.successCb, closeDialog: closeDialog, dialogYesLabel: 'Yes', dialogNoLabel: 'No' })));
    }
};
exports.default = TenantPageDetails;


/***/ }),

/***/ "./app/pages/Tenants.tsx":
/*!*******************************!*\
  !*** ./app/pages/Tenants.tsx ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const SimpleAccordion_1 = __importDefault(__webpack_require__(/*! ../components/SimpleAccordion */ "./app/components/SimpleAccordion.tsx"));
const AsyncPinotTables_1 = __importDefault(__webpack_require__(/*! ../components/AsyncPinotTables */ "./app/components/AsyncPinotTables.tsx"));
const CustomButton_1 = __importDefault(__webpack_require__(/*! ../components/CustomButton */ "./app/components/CustomButton.tsx"));
const AsyncInstanceTable_1 = __webpack_require__(/*! ../components/AsyncInstanceTable */ "./app/components/AsyncInstanceTable.tsx");
const useStyles = core_1.makeStyles((theme) => ({
    operationDiv: {
        border: '1px #BDCCD9 solid',
        borderRadius: 4,
        marginBottom: 20,
    },
}));
const TenantPage = ({ match }) => {
    const { tenantName } = match.params;
    const classes = useStyles();
    return (react_1.default.createElement(core_1.Grid, { item: true, xs: true, style: {
            padding: 20,
            backgroundColor: 'white',
            maxHeight: 'calc(100vh - 70px)',
            overflowY: 'auto',
        } },
        react_1.default.createElement("div", { className: classes.operationDiv },
            react_1.default.createElement(SimpleAccordion_1.default, { headerTitle: "Operations", showSearchBox: false },
                react_1.default.createElement("div", null,
                    react_1.default.createElement(CustomButton_1.default, { onClick: () => { }, tooltipTitle: "Recalculates the segment to server mapping for all tables in this tenant", enableTooltip: true, isDisabled: true }, "Rebalance Server Tenant"),
                    react_1.default.createElement(CustomButton_1.default, { onClick: () => { }, tooltipTitle: "Rebuilds brokerResource mappings for all tables in this tenant", enableTooltip: true, isDisabled: true }, "Rebuild Broker Resource")))),
        react_1.default.createElement(AsyncPinotTables_1.default, { title: tenantName, tenants: [tenantName], baseUrl: `/tenants/${tenantName}/table/` }),
        react_1.default.createElement(core_1.Grid, { container: true, spacing: 2 },
            react_1.default.createElement(core_1.Grid, { item: true, xs: 6 },
                react_1.default.createElement(AsyncInstanceTable_1.AsyncInstanceTable, { instanceType: "broker" /* BROKER */, tenant: tenantName })),
            react_1.default.createElement(core_1.Grid, { item: true, xs: 6 },
                react_1.default.createElement(AsyncInstanceTable_1.AsyncInstanceTable, { instanceType: "server" /* SERVER */, tenant: tenantName })))));
};
exports.default = TenantPage;


/***/ }),

/***/ "./app/pages/TenantsListingPage.tsx":
/*!******************************************!*\
  !*** ./app/pages/TenantsListingPage.tsx ***!
  \******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const TenantsListing_1 = __importDefault(__webpack_require__(/*! ../components/Homepage/TenantsListing */ "./app/components/Homepage/TenantsListing.tsx"));
const useStyles = core_1.makeStyles(() => ({
    gridContainer: {
        padding: 20,
        backgroundColor: 'white',
        maxHeight: 'calc(100vh - 70px)',
        overflowY: 'auto',
    },
}));
const TenantsListingPage = () => {
    const classes = useStyles();
    return (react_1.default.createElement(core_1.Grid, { item: true, xs: true, className: classes.gridContainer },
        react_1.default.createElement(TenantsListing_1.default, null)));
};
exports.default = TenantsListingPage;


/***/ }),

/***/ "./app/pages/UserPage.tsx":
/*!********************************!*\
  !*** ./app/pages/UserPage.tsx ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/* eslint-disable no-nested-ternary */
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const Alert_1 = __importDefault(__webpack_require__(/*! @material-ui/lab/Alert */ "./node_modules/@material-ui/lab/esm/Alert/index.js"));
const styles_1 = __webpack_require__(/*! @material-ui/core/styles */ "./node_modules/@material-ui/core/esm/styles/index.js");
const PinotMethodUtils_1 = __importDefault(__webpack_require__(/*! ../utils/PinotMethodUtils */ "./app/utils/PinotMethodUtils.ts"));
__webpack_require__(/*! ../styles/styles.css */ "./app/styles/styles.css");
const AddUser_1 = __importDefault(__webpack_require__(/*! ../components/User/AddUser */ "./app/components/User/AddUser.tsx"));
const UpdateUser_1 = __importDefault(__webpack_require__(/*! ../components/User/UpdateUser */ "./app/components/User/UpdateUser.tsx"));
const _ = __importStar(__webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js"));
const AppLoader_1 = __importDefault(__webpack_require__(/*! ../components/AppLoader */ "./app/components/AppLoader.tsx"));
const initialUser = {
    username: "",
    password: "",
    component: "",
    role: "",
    tables: [],
    permissions: ['READ']
};
const PERMISSIONS = ["READ", "CREATE", "UPDATE", "DELETE"];
const columns = [
    { id: 'User', label: 'User' },
    { id: 'Component', label: 'Component' },
    { id: 'Role', label: 'Role' },
    { id: 'Permissions', label: 'Permissions' },
    { id: 'Tables', label: 'Tables' },
    { id: 'Actions', label: 'Actions' }
];
let oldPassword = "";
const UserPage = () => {
    const [userList, setUserList] = react_1.useState([]);
    const [addUserPanel, setAddUserPanel] = react_1.useState(false);
    const [deleteUserPanel, setDeleteUserPanel] = react_1.useState(false);
    const [updateUserPanel, setUpdateUserPanel] = react_1.useState(false);
    const [tableList, setTableList] = react_1.useState([]);
    const [userInfo, updateUserInfo] = react_1.useState(initialUser);
    const [errorTip, setErrorTip] = react_1.useState(null);
    const [showError, setShowError] = react_1.useState(false);
    const [successTip, setSuccessTip] = react_1.useState(null);
    const [showSuccess, setShowSuccess] = react_1.useState(false);
    const [checkedUser, setCheckedUser] = react_1.useState(initialUser);
    const [fetching, setFetching] = react_1.useState(false);
    const getUserList = () => __awaiter(void 0, void 0, void 0, function* () {
        setFetching(true);
        const tablesResponse = yield PinotMethodUtils_1.default.getTable();
        let tables = tablesResponse.tables;
        tables.unshift("DUAL", "ALL");
        let tableList = tables.map(item => {
            return {
                name: item,
                checked: item === 'DUAL',
                disabled: false
            };
        });
        setTableList(tableList);
        const userListResponse = yield PinotMethodUtils_1.default.getUserList();
        let userObj = userListResponse.users;
        let userData = [];
        for (let key in userObj) {
            if (userObj.hasOwnProperty(key)) {
                userData.push(userObj[key]);
            }
        }
        userData = userData.map(item => {
            return {
                component: item.component,
                role: item.role,
                username: item.username,
                usernameWithComponent: item.usernameWithComponent,
                tables: item.tables ? item.tables : ["ALL"],
                permissions: item.permissions ? item.permissions : PERMISSIONS,
                password: item.password
            };
        });
        userData.sort((prev, next) => {
            let prevUser = prev.username.toUpperCase();
            let nextUser = next.username.toUpperCase();
            if (prevUser < nextUser) {
                return -1;
            }
            if (prevUser > nextUser) {
                return 1;
            }
            return 0;
        });
        setUserList(userData);
        setFetching(false);
    });
    const toggleAddUserPanel = () => {
        updateUserInfo(initialUser);
        setAddUserPanel(true);
    };
    const closeAddUserPanel = () => {
        setAddUserPanel(false);
    };
    const submitAddUser = () => __awaiter(void 0, void 0, void 0, function* () {
        let addUserParam = _.cloneDeep(userInfo);
        if (addUserParam.tables.includes('ALL')) {
            delete addUserParam.tables;
        }
        const addUserResponse = yield PinotMethodUtils_1.default.addUser(addUserParam);
        if (addUserResponse.code && addUserResponse.code !== 200) {
            setShowError(true);
            setErrorTip(addUserResponse.error);
        }
        else {
            setAddUserPanel(false);
            setShowSuccess(true);
            setSuccessTip("Add user success");
            getUserList();
        }
    });
    const closeTip = (type) => {
        type === 'error' ? setShowError(false) : setShowSuccess(false);
    };
    const deleteUser = () => __awaiter(void 0, void 0, void 0, function* () {
        const deleteUserResponse = yield PinotMethodUtils_1.default.deleteUser(checkedUser);
        if (deleteUserResponse.code && deleteUserResponse.code !== 200) {
            setShowError(true);
            setErrorTip(deleteUserResponse.error);
        }
        else {
            setDeleteUserPanel(false);
            setShowSuccess(true);
            setSuccessTip("delete user success");
            getUserList();
        }
    });
    const clickDeleteUser = (row) => {
        setCheckedUser(row);
        setDeleteUserPanel(true);
    };
    const clickEditUser = (row) => {
        oldPassword = row.password;
        updateUserInfo(row);
        setUpdateUserPanel(true);
    };
    const closeUpdateUserPanel = () => {
        setUpdateUserPanel(false);
    };
    const submitUpdateUser = () => __awaiter(void 0, void 0, void 0, function* () {
        let updateUserParam = _.cloneDeep(userInfo);
        if (updateUserParam.tables.includes('ALL')) {
            delete updateUserParam.tables;
        }
        const passwordChanged = updateUserParam.password !== oldPassword ? true : false;
        const updateUserResponse = yield PinotMethodUtils_1.default.updateUser(updateUserParam, passwordChanged);
        if (updateUserResponse.code && updateUserResponse.code !== 200) {
            setShowError(true);
            setErrorTip(updateUserResponse.error);
        }
        else {
            setUpdateUserPanel(false);
            setShowSuccess(true);
            setSuccessTip("Update user success");
            getUserList();
        }
    });
    react_1.useEffect(() => {
        getUserList();
    }, []);
    const useStyles = styles_1.makeStyles({
        userContainer: {
            width: 'calc(100% - 260px)', padding: '32px', height: 'calc(100vh - 70px)', fontSize: '14px'
        },
        tableBody: {
            maxHeight: 'calc(100vh - 254px)', overflowY: 'auto'
        },
        tableColItemStyle: {
            background: "#1170CF", borderRadius: '4px', padding: '4px 8px', display: 'inline-block', color: '#fff',
            fontSize: '14px', marginRight: '18px', marginTop: '5px', marginBottom: '5px'
        },
        delButton: {
            borderRadius: '16px',
            color: 'rgb(220, 0, 78)',
            border: '1px solid rgba(220, 0, 78, 0.5)',
            "&:hover": {
                background: 'rgba(220, 0, 78, 0.2)'
            }
        },
    });
    const classes = useStyles();
    return (react_1.default.createElement("div", { className: classes.userContainer },
        react_1.default.createElement(core_1.Button, { variant: "contained", onClick: toggleAddUserPanel, color: "primary", style: { marginBottom: '20px', borderRadius: '16px' } }, "Add User"),
        fetching ? react_1.default.createElement(AppLoader_1.default, null) : react_1.default.createElement(core_1.TableContainer, { component: core_1.Paper, style: { height: 'calc(100% - 60px)' } },
            react_1.default.createElement(core_1.Table, { "aria-label": "simple table" },
                react_1.default.createElement(core_1.TableHead, null,
                    react_1.default.createElement(core_1.TableRow, null, columns.map((column) => (react_1.default.createElement(core_1.TableCell, { style: { fontWeight: 700 }, key: column.id }, column.label))))),
                react_1.default.createElement(core_1.TableBody, { className: classes.tableBody }, userList.map((row) => (react_1.default.createElement(core_1.TableRow, { key: row.usernameWithComponent },
                    react_1.default.createElement(core_1.TableCell, { component: "th", scope: "row" }, row.username),
                    react_1.default.createElement(core_1.TableCell, { align: "justify" }, row.component),
                    react_1.default.createElement(core_1.TableCell, { align: "justify" }, row.role),
                    react_1.default.createElement(core_1.TableCell, { align: "justify" }, row.permissions && row.permissions.length > 0 && row.permissions.map(permission => {
                        return react_1.default.createElement("span", { className: classes.tableColItemStyle, key: permission }, permission);
                    })),
                    react_1.default.createElement(core_1.TableCell, { align: "justify", style: { wordWrap: "break-word" } }, row.tables && row.tables.length > 0 && row.tables.map(table => {
                        return react_1.default.createElement("span", { className: classes.tableColItemStyle, key: table }, table);
                    })),
                    react_1.default.createElement(core_1.TableCell, { align: "justify", style: { minWidth: '200px' } },
                        react_1.default.createElement(core_1.Button, { variant: "outlined", size: "small", style: { marginRight: '10px', borderRadius: '16px' }, onClick: () => clickEditUser(row) }, "Edit"),
                        "\u00A0",
                        react_1.default.createElement(core_1.Button, { variant: "outlined", onClick: () => clickDeleteUser(row), size: "small", className: classes.delButton }, "Delete")))))))),
        react_1.default.createElement(core_1.Dialog, { open: addUserPanel, onClose: closeAddUserPanel },
            react_1.default.createElement(core_1.DialogTitle, null, "Add User"),
            react_1.default.createElement(AddUser_1.default, { tableList: tableList, userProp: userInfo, setUserInfo: (userInfo) => { updateUserInfo(userInfo); } }),
            react_1.default.createElement(core_1.DialogActions, null,
                react_1.default.createElement(core_1.Button, { onClick: closeAddUserPanel, size: "small" }, "Cancel"),
                react_1.default.createElement(core_1.Button, { onClick: submitAddUser, size: "small" }, "Submit"))),
        react_1.default.createElement(core_1.Dialog, { open: updateUserPanel, onClose: closeUpdateUserPanel },
            react_1.default.createElement(core_1.DialogTitle, null, "Edit User"),
            react_1.default.createElement(UpdateUser_1.default, { tableList: tableList, userProp: userInfo, setUserInfo: (userInfo) => { updateUserInfo(userInfo); } }),
            react_1.default.createElement(core_1.DialogActions, null,
                react_1.default.createElement(core_1.Button, { onClick: closeUpdateUserPanel, size: "small" }, "Cancel"),
                react_1.default.createElement(core_1.Button, { onClick: submitUpdateUser, size: "small" }, "Submit"))),
        react_1.default.createElement(core_1.Dialog, { open: deleteUserPanel, onClose: () => { setDeleteUserPanel(false); }, "aria-labelledby": "alert-dialog-title" },
            react_1.default.createElement(core_1.DialogTitle, { id: "alert-dialog-title" }, `Confirm Delete user ${checkedUser.username}_${checkedUser.component}?`),
            react_1.default.createElement(core_1.DialogActions, null,
                react_1.default.createElement(core_1.Button, { onClick: () => { setDeleteUserPanel(false); }, color: "primary" }, "Cancel"),
                react_1.default.createElement(core_1.Button, { onClick: deleteUser, color: "primary", autoFocus: true }, "Confirm"))),
        react_1.default.createElement(core_1.Snackbar, { open: showError, autoHideDuration: 6000, onClose: () => { closeTip('error'); } },
            react_1.default.createElement(Alert_1.default, { onClose: () => { closeTip('error'); }, severity: "error" }, errorTip)),
        react_1.default.createElement(core_1.Snackbar, { open: showSuccess, autoHideDuration: 1000, onClose: () => { closeTip('success'); } },
            react_1.default.createElement(Alert_1.default, { onClose: () => { closeTip('success'); }, severity: "success" }, successTip))));
};
exports.default = UserPage;


/***/ }),

/***/ "./app/pages/ZookeeperPage.tsx":
/*!*************************************!*\
  !*** ./app/pages/ZookeeperPage.tsx ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/* eslint-disable no-nested-ternary */
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const styles_1 = __webpack_require__(/*! @material-ui/core/styles */ "./node_modules/@material-ui/core/esm/styles/index.js");
const core_1 = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
const AppLoader_1 = __importDefault(__webpack_require__(/*! ../components/AppLoader */ "./app/components/AppLoader.tsx"));
const PinotMethodUtils_1 = __importDefault(__webpack_require__(/*! ../utils/PinotMethodUtils */ "./app/utils/PinotMethodUtils.ts"));
const TreeDirectory_1 = __importDefault(__webpack_require__(/*! ../components/Zookeeper/TreeDirectory */ "./app/components/Zookeeper/TreeDirectory.tsx"));
const TabPanel_1 = __importDefault(__webpack_require__(/*! ../components/TabPanel */ "./app/components/TabPanel.tsx"));
const Utils_1 = __importDefault(__webpack_require__(/*! ../utils/Utils */ "./app/utils/Utils.tsx"));
const CustomCodemirror_1 = __importDefault(__webpack_require__(/*! ../components/CustomCodemirror */ "./app/components/CustomCodemirror.tsx"));
const useStyles = styles_1.makeStyles((theme) => ({
    root: {
        flexGrow: 1,
    },
    rightPanel: {},
    tabLabel: {
        textTransform: 'capitalize',
        fontWeight: 600
    },
    codeMirrorDiv: {
        border: '1px #BDCCD9 solid',
        borderRadius: 4,
        marginBottom: '20px',
    },
    lastRefreshDiv: {
        direction: 'rtl',
        margin: '-15px 0'
    }
}));
const ZookeeperPage = () => {
    const classes = useStyles();
    const theme = styles_1.useTheme();
    const [fetching, setFetching] = react_1.useState(false);
    const [treeData, setTreeData] = react_1.useState([]);
    const [currentNodeData, setCurrentNodeData] = react_1.useState({});
    const [currentNodeMetadata, setCurrentNodeMetadata] = react_1.useState({});
    const [selectedNode, setSelectedNode] = react_1.useState(null);
    const [count, setCount] = react_1.useState(1);
    const [leafNode, setLeafNode] = react_1.useState(false);
    // states and handlers for toggle and select of tree
    const [expanded, setExpanded] = react_1.default.useState(['1']);
    const [selected, setSelected] = react_1.default.useState(['1']);
    const [lastRefresh, setLastRefresh] = react_1.default.useState(null);
    const handleToggle = (event, nodeIds) => {
        setExpanded(nodeIds);
    };
    const handleSelect = (event, nodeIds) => {
        if (selected !== nodeIds) {
            setSelected(nodeIds);
            const treeObj = Utils_1.default.findNestedObj(treeData, 'nodeId', nodeIds);
            if (treeObj) {
                setLeafNode(treeObj.isLeafNode);
                setSelectedNode(treeObj.fullPath || '/');
                showInfoEvent(treeObj.fullPath || '/');
            }
        }
    };
    // on select, show node data and node metadata
    const showInfoEvent = (fullPath) => __awaiter(void 0, void 0, void 0, function* () {
        const nodeDataObj = yield PinotMethodUtils_1.default.getNodeData(fullPath);
        setCurrentNodeData(nodeDataObj.currentNodeData);
        setCurrentNodeMetadata(nodeDataObj.currentNodeMetadata);
        setLastRefresh(new Date());
    });
    // handlers for Tabs
    const [value, setValue] = react_1.default.useState(0);
    const handleChange = (event, newValue) => {
        setValue(newValue);
    };
    // fetch and show children tree if not already fetched
    const showChildEvent = (pathObj) => {
        if (!pathObj.hasChildRendered) {
            fetchInnerPath(pathObj);
        }
    };
    const fetchInnerPath = (pathObj) => __awaiter(void 0, void 0, void 0, function* () {
        const ZKDataObj = yield PinotMethodUtils_1.default.getZookeeperData(pathObj.fullPath, count);
        pathObj.child = ZKDataObj.newTreeData[0].child;
        pathObj.isLeafNode = ZKDataObj.newTreeData[0].child.length === 0;
        pathObj.hasChildRendered = true;
        // setting the old treeData again here since pathObj has the reference of old treeData
        // and newTreeData is not useful here.
        setTreeData(treeData);
        setCurrentNodeData(ZKDataObj.currentNodeData);
        setCurrentNodeMetadata(ZKDataObj.currentNodeMetadata);
        setCount(ZKDataObj.counter);
        setExpanded([...expanded, pathObj.nodeId]);
    });
    const fetchData = () => __awaiter(void 0, void 0, void 0, function* () {
        setFetching(true);
        const path = '/';
        const ZKDataObj = yield PinotMethodUtils_1.default.getZookeeperData(path, 1);
        setTreeData(ZKDataObj.newTreeData);
        setSelectedNode(path);
        setCurrentNodeData(ZKDataObj.currentNodeData || {});
        setCurrentNodeMetadata(ZKDataObj.currentNodeMetadata);
        setCount(ZKDataObj.counter);
        setExpanded(['1']);
        setSelected(['1']);
        setLastRefresh(new Date());
        setFetching(false);
    });
    react_1.useEffect(() => {
        fetchData();
    }, []);
    const renderLastRefresh = () => (react_1.default.createElement("div", { className: classes.lastRefreshDiv },
        react_1.default.createElement("p", null, `Last Refreshed: ${lastRefresh.toLocaleTimeString('en-US', {
            hour12: true,
            hour: 'numeric',
            minute: '2-digit',
            second: '2-digit'
        })}
        `)));
    return fetching ? (react_1.default.createElement(AppLoader_1.default, null)) : (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(core_1.Grid, { item: true },
            react_1.default.createElement(TreeDirectory_1.default, { treeData: treeData, selectedNode: selectedNode, showChildEvent: showChildEvent, expanded: expanded, selected: selected, handleToggle: handleToggle, handleSelect: handleSelect, isLeafNodeSelected: leafNode, currentNodeData: currentNodeData, currentNodeMetadata: currentNodeMetadata, showInfoEvent: showInfoEvent, fetchInnerPath: fetchInnerPath })),
        react_1.default.createElement(core_1.Grid, { item: true, xs: true, style: { padding: 20, backgroundColor: 'white', maxHeight: 'calc(100vh - 70px)', overflowY: 'auto' } },
            react_1.default.createElement(core_1.Grid, { container: true },
                react_1.default.createElement(core_1.Grid, { item: true, xs: 12, className: classes.rightPanel },
                    react_1.default.createElement(core_1.Paper, { className: classes.root },
                        react_1.default.createElement(core_1.Tabs, { value: value, onChange: handleChange, indicatorColor: "primary", textColor: "primary", centered: true },
                            react_1.default.createElement(core_1.Tab, { label: "Node Data", className: classes.tabLabel }),
                            react_1.default.createElement(core_1.Tab, { label: "Node Metadata", className: classes.tabLabel }))),
                    react_1.default.createElement(TabPanel_1.default, { value: value, index: 0, dir: theme.direction },
                        lastRefresh && renderLastRefresh(),
                        react_1.default.createElement("div", { className: classes.codeMirrorDiv },
                            react_1.default.createElement(CustomCodemirror_1.default, { data: currentNodeData, showLineWrapToggle: true }))),
                    react_1.default.createElement(TabPanel_1.default, { value: value, index: 1, dir: theme.direction },
                        lastRefresh && renderLastRefresh(),
                        react_1.default.createElement("div", { className: classes.codeMirrorDiv },
                            react_1.default.createElement(CustomCodemirror_1.default, { data: currentNodeMetadata, showLineWrapToggle: true }))))))));
};
exports.default = ZookeeperPage;


/***/ }),

/***/ "./app/requests/index.ts":
/*!*******************************!*\
  !*** ./app/requests/index.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const headers = {
    'Content-Type': 'application/json; charset=UTF-8',
    'Accept': 'text/plain, */*; q=0.01'
};
const axios_config_1 = __webpack_require__(/*! ../utils/axios-config */ "./app/utils/axios-config.ts");
exports.getTenants = () => axios_config_1.baseApi.get('/tenants');
exports.getTenant = (name) => axios_config_1.baseApi.get(`/tenants/${name}`);
exports.getTenantTable = (name) => axios_config_1.baseApi.get(`/tenants/${name}/tables`);
exports.getTenantTableDetails = (tableName) => axios_config_1.baseApi.get(`/tables/${tableName}`);
exports.putTable = (name, params) => axios_config_1.baseApi.put(`/tables/${name}`, params, { headers });
exports.getSchemaList = () => axios_config_1.baseApi.get(`/schemas`);
exports.getSchema = (name) => axios_config_1.baseApi.get(`/schemas/${name}`);
exports.putSchema = (name, params, reload) => {
    let queryParams = {};
    if (reload) {
        queryParams["reload"] = reload;
    }
    return axios_config_1.baseApi.put(`/schemas/${name}`, params, { headers, params: queryParams });
};
exports.getSegmentMetadata = (tableName, segmentName) => axios_config_1.baseApi.get(`/segments/${tableName}/${segmentName}/metadata?columns=*`);
exports.getTableSize = (name) => axios_config_1.baseApi.get(`/tables/${name}/size`);
exports.getIdealState = (name) => axios_config_1.baseApi.get(`/tables/${name}/idealstate`);
exports.getExternalView = (name) => axios_config_1.baseApi.get(`/tables/${name}/externalview`);
exports.getInstances = () => axios_config_1.baseApi.get('/instances');
exports.getInstance = (name) => axios_config_1.baseApi.get(`/instances/${name}`);
exports.putInstance = (name, params) => axios_config_1.baseApi.put(`/instances/${name}`, params, { headers });
exports.updateInstanceTags = (name, params) => axios_config_1.baseApi.put(`/instances/${name}/updateTags?tags=${params}`, null, { headers });
exports.setInstanceState = (name, state) => axios_config_1.baseApi.put(`/instances/${name}/state?state=${state}`, { headers: { 'Content-Type': 'text/plain', 'Accept': 'application/json' } });
exports.setTableState = (tableName, state, tableType) => axios_config_1.baseApi.put(`/tables/${tableName}/state?state=${state}&type=${tableType}`);
exports.dropInstance = (name) => axios_config_1.baseApi.delete(`instances/${name}`, { headers });
exports.getPeriodicTaskNames = () => axios_config_1.baseApi.get(`/periodictask/names`, { headers });
exports.getTaskTypes = () => axios_config_1.baseApi.get(`/tasks/tasktypes`, { headers: Object.assign(Object.assign({}, headers), { Accept: 'application/json' }) });
exports.getTaskTypeTasks = (taskType) => axios_config_1.baseApi.get(`/tasks/${taskType}/tasks`, { headers: Object.assign(Object.assign({}, headers), { Accept: 'application/json' }) });
exports.getTaskTypeState = (taskType) => axios_config_1.baseApi.get(`/tasks/${taskType}/state`, { headers: Object.assign(Object.assign({}, headers), { Accept: 'application/json' }) });
exports.stopTasks = (taskType) => axios_config_1.baseApi.put(`/tasks/${taskType}/stop`, { headers: Object.assign(Object.assign({}, headers), { Accept: 'application/json' }) });
exports.resumeTasks = (taskType) => axios_config_1.baseApi.put(`/tasks/${taskType}/resume`, { headers: Object.assign(Object.assign({}, headers), { Accept: 'application/json' }) });
exports.cleanupTasks = (taskType) => axios_config_1.baseApi.put(`/tasks/${taskType}/cleanup`, { headers: Object.assign(Object.assign({}, headers), { Accept: 'application/json' }) });
exports.deleteTasks = (taskType) => axios_config_1.baseApi.delete(`/tasks/${taskType}`, { headers: Object.assign(Object.assign({}, headers), { Accept: 'application/json' }) });
exports.scheduleTask = (tableName, taskType) => axios_config_1.baseApi.post(`/tasks/schedule?tableName=${tableName}&taskType=${taskType}`, null, { headers: Object.assign(Object.assign({}, headers), { Accept: 'application/json' }) });
exports.executeTask = (data) => axios_config_1.baseApi.post(`/tasks/execute`, data, { headers: Object.assign(Object.assign({}, headers), { Accept: 'application/json' }) });
exports.getJobDetail = (tableName, taskType) => axios_config_1.baseApi.get(`/tasks/scheduler/jobDetails?tableName=${tableName}&taskType=${taskType}`, { headers: Object.assign(Object.assign({}, headers), { Accept: 'application/json' }) });
exports.getMinionMeta = (tableName, taskType) => axios_config_1.baseApi.get(`/tasks/${taskType}/${tableName}/metadata`, { headers: Object.assign(Object.assign({}, headers), { Accept: 'application/json' }) });
exports.getTasks = (tableName, taskType) => axios_config_1.baseApi.get(`/tasks/${taskType}/${tableName}/state`, { headers: Object.assign(Object.assign({}, headers), { Accept: 'application/json' }) });
exports.getTaskRuntimeConfig = (taskName) => axios_config_1.baseApi.get(`/tasks/task/${taskName}/runtime/config`, { headers: Object.assign(Object.assign({}, headers), { Accept: 'application/json' }) });
exports.getTaskDebug = (taskName) => axios_config_1.baseApi.get(`/tasks/task/${taskName}/debug?verbosity=1`, { headers: Object.assign(Object.assign({}, headers), { Accept: 'application/json' }) });
exports.getTaskProgress = (taskName, subTaskName) => axios_config_1.baseApi.get(`/tasks/subtask/${taskName}/progress`, { headers: Object.assign(Object.assign({}, headers), { Accept: 'application/json' }), params: { subtaskNames: subTaskName } });
exports.getTaskGeneratorDebug = (taskName, taskType) => axios_config_1.baseApi.get(`/tasks/generator/${taskName}/${taskType}/debug`, { headers: Object.assign(Object.assign({}, headers), { Accept: 'application/json' }) });
exports.getTaskTypeDebug = (taskType) => axios_config_1.baseApi.get(`/tasks/${taskType}/debug?verbosity=1`, { headers: Object.assign(Object.assign({}, headers), { Accept: 'application/json' }) });
exports.getTables = (params) => axios_config_1.baseApi.get(`/tables`, { params, headers: Object.assign(Object.assign({}, headers), { Accept: 'application/json' }) });
exports.getClusterConfig = () => axios_config_1.baseApi.get('/cluster/configs');
exports.getQueryTables = (type) => axios_config_1.baseApi.get(`/tables${type ? `?type=${type}` : ''}`);
exports.getTableSchema = (name) => axios_config_1.baseApi.get(`/tables/${name}/schema`);
exports.getQueryResult = (params) => axios_config_1.transformApi.post(`/sql`, params, { headers });
exports.getClusterInfo = () => axios_config_1.baseApi.get('/cluster/info');
exports.zookeeperGetList = (params) => axios_config_1.baseApi.get(`/zk/ls?path=${params}`);
exports.zookeeperGetData = (params) => axios_config_1.baseApi.get(`/zk/get?path=${params}`);
exports.zookeeperGetStat = (params) => axios_config_1.baseApi.get(`/zk/stat?path=${params}`);
exports.zookeeperGetListWithStat = (params) => axios_config_1.baseApi.get(`/zk/lsl?path=${params}`);
exports.zookeeperPutData = (params) => axios_config_1.baseApi.put(`/zk/put?${params}`, null, { headers });
exports.zookeeperDeleteNode = (params) => axios_config_1.baseApi.delete(`/zk/delete?path=${params}`);
exports.getBrokerListOfTenant = (name) => axios_config_1.baseApi.get(`/brokers/tenants/${name}`);
exports.getServerListOfTenant = (name) => axios_config_1.baseApi.get(`/tenants/${name}?type=server`);
exports.reloadSegment = (tableName, instanceName) => axios_config_1.baseApi.post(`/segments/${tableName}/${instanceName}/reload`, null, { headers });
exports.reloadAllSegments = (tableName, tableType) => axios_config_1.baseApi.post(`/segments/${tableName}/reload?type=${tableType}`, null, { headers });
exports.reloadStatus = (tableName, tableType) => axios_config_1.baseApi.get(`/tables/${tableName}/indexes?type=${tableType}`);
exports.deleteSegment = (tableName, instanceName) => axios_config_1.baseApi.delete(`/segments/${tableName}/${instanceName}`, { headers });
exports.getTableJobs = (tableName, jobTypes) => {
    let queryParams = {};
    if (jobTypes) {
        queryParams["jobTypes"] = jobTypes;
    }
    return axios_config_1.baseApi.get(`/table/${tableName}/jobs`, { params: queryParams });
};
exports.getSegmentReloadStatus = (jobId) => axios_config_1.baseApi.get(`/segments/segmentReloadStatus/${jobId}`, { headers });
exports.deleteTable = (tableName) => axios_config_1.baseApi.delete(`/tables/${tableName}`, { headers });
exports.deleteSchema = (schemaName) => axios_config_1.baseApi.delete(`/schemas/${schemaName}`, { headers });
exports.rebalanceServersForTable = (tableName, qParams) => axios_config_1.baseApi.post(`/tables/${tableName}/rebalance?${qParams}`, null, { headers });
exports.rebalanceBrokersForTable = (tableName) => axios_config_1.baseApi.post(`/tables/${tableName}/rebuildBrokerResourceFromHelixTags`, null, { headers });
exports.validateSchema = (schemaObject) => axios_config_1.baseApi.post(`/schemas/validate`, schemaObject, { headers });
exports.validateTable = (tableObject) => axios_config_1.baseApi.post(`/tables/validate`, JSON.stringify(tableObject), { headers });
exports.saveSchema = (schemaObject) => axios_config_1.baseApi.post(`/schemas`, schemaObject, { headers });
exports.saveTable = (tableObject) => axios_config_1.baseApi.post(`/tables`, JSON.stringify(tableObject), { headers });
exports.getState = (tableName, tableType) => axios_config_1.baseApi.get(`/tables/${tableName}/state?type=${tableType}`);
exports.getInfo = () => axios_config_1.baseApi.get(`/auth/info`);
exports.authenticateUser = (authToken) => axios_config_1.baseApi.get(`/auth/verify`, { headers: { "Authorization": authToken } });
exports.getSegmentDebugInfo = (tableName, tableType) => axios_config_1.baseApi.get(`debug/tables/${tableName}?type=${tableType}&verbosity=10`);
exports.getSegmentLevelDebugDetails = (tableName, segmentName) => __awaiter(void 0, void 0, void 0, function* () {
    const response = yield axios_config_1.baseApiWithErrors.get(`debug/segments/${tableName}/${segmentName}`);
    return response.data;
});
exports.requestTable = () => axios_config_1.baseApi.get(`/tables`);
exports.requestUserList = () => axios_config_1.baseApi.get(`/users`);
exports.requestAddUser = (userObject) => axios_config_1.baseApi.post('/users', JSON.stringify(userObject), { headers });
exports.requestDeleteUser = (userObject) => axios_config_1.baseApi.delete(`/users/${userObject.username}?component=${userObject.component}`);
exports.requestUpdateUser = (userObject, passwordChanged) => axios_config_1.baseApi.put(`/users/${userObject.username}?component=${userObject.component}&passwordChanged=${passwordChanged}`, JSON.stringify(userObject), { headers });


/***/ }),

/***/ "./app/router.tsx":
/*!************************!*\
  !*** ./app/router.tsx ***!
  \************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const HomePage_1 = __importDefault(__webpack_require__(/*! ./pages/HomePage */ "./app/pages/HomePage.tsx"));
const TenantsListingPage_1 = __importDefault(__webpack_require__(/*! ./pages/TenantsListingPage */ "./app/pages/TenantsListingPage.tsx"));
const InstanceListingPage_1 = __importDefault(__webpack_require__(/*! ./pages/InstanceListingPage */ "./app/pages/InstanceListingPage.tsx"));
const TablesListingPage_1 = __importDefault(__webpack_require__(/*! ./pages/TablesListingPage */ "./app/pages/TablesListingPage.tsx"));
const MinionTaskManager_1 = __importDefault(__webpack_require__(/*! ./pages/MinionTaskManager */ "./app/pages/MinionTaskManager.tsx"));
const TaskQueue_1 = __importDefault(__webpack_require__(/*! ./pages/TaskQueue */ "./app/pages/TaskQueue.tsx"));
const TaskQueueTable_1 = __importDefault(__webpack_require__(/*! ./pages/TaskQueueTable */ "./app/pages/TaskQueueTable.tsx"));
const TaskDetail_1 = __importDefault(__webpack_require__(/*! ./pages/TaskDetail */ "./app/pages/TaskDetail.tsx"));
const SubTaskDetail_1 = __importDefault(__webpack_require__(/*! ./pages/SubTaskDetail */ "./app/pages/SubTaskDetail.tsx"));
const Tenants_1 = __importDefault(__webpack_require__(/*! ./pages/Tenants */ "./app/pages/Tenants.tsx"));
const TenantDetails_1 = __importDefault(__webpack_require__(/*! ./pages/TenantDetails */ "./app/pages/TenantDetails.tsx"));
const Query_1 = __importDefault(__webpack_require__(/*! ./pages/Query */ "./app/pages/Query.tsx"));
const SegmentDetails_1 = __importDefault(__webpack_require__(/*! ./pages/SegmentDetails */ "./app/pages/SegmentDetails.tsx"));
const InstanceDetails_1 = __importDefault(__webpack_require__(/*! ./pages/InstanceDetails */ "./app/pages/InstanceDetails.tsx"));
const ZookeeperPage_1 = __importDefault(__webpack_require__(/*! ./pages/ZookeeperPage */ "./app/pages/ZookeeperPage.tsx"));
const SchemaPageDetails_1 = __importDefault(__webpack_require__(/*! ./pages/SchemaPageDetails */ "./app/pages/SchemaPageDetails.tsx"));
const LoginPage_1 = __importDefault(__webpack_require__(/*! ./pages/LoginPage */ "./app/pages/LoginPage.tsx"));
const UserPage_1 = __importDefault(__webpack_require__(/*! ./pages/UserPage */ "./app/pages/UserPage.tsx"));
exports.default = [
    // TODO: make async
    { path: '/', Component: HomePage_1.default },
    { path: '/query', Component: Query_1.default },
    { path: '/tenants', Component: TenantsListingPage_1.default },
    { path: '/controllers', Component: InstanceListingPage_1.default },
    { path: '/brokers', Component: InstanceListingPage_1.default },
    { path: '/servers', Component: InstanceListingPage_1.default },
    { path: '/minions', Component: InstanceListingPage_1.default },
    { path: '/tables', Component: TablesListingPage_1.default },
    { path: '/minion-task-manager', Component: MinionTaskManager_1.default },
    { path: '/task-queue/:taskType', Component: TaskQueue_1.default },
    { path: '/task-queue/:taskType/tables/:queueTableName', Component: TaskQueueTable_1.default },
    { path: '/task-queue/:taskType/tables/:queueTableName/task/:taskID', Component: TaskDetail_1.default },
    { path: '/task-queue/:taskType/tables/:queueTableName/task/:taskID/sub-task/:subTaskID', Component: SubTaskDetail_1.default },
    { path: '/tenants/:tenantName', Component: Tenants_1.default },
    { path: '/tenants/:tenantName/table/:tableName', Component: TenantDetails_1.default },
    { path: '/tenants/schema/:schemaName', Component: SchemaPageDetails_1.default },
    { path: '/tenants/table/:tableName', Component: TenantDetails_1.default },
    { path: '/tenants/table/:tableName/:segmentName', Component: SegmentDetails_1.default },
    { path: '/tenants/:tenantName/table/:tableName/:segmentName', Component: SegmentDetails_1.default },
    { path: '/instance/:instanceName', Component: InstanceDetails_1.default },
    { path: '/instance/:instanceName/table/:tableName', Component: TenantDetails_1.default },
    { path: '/instance/:instanceName/table/:tableName/:segmentName', Component: SegmentDetails_1.default },
    { path: '/zookeeper', Component: ZookeeperPage_1.default },
    { path: '/login', Component: LoginPage_1.default },
    { path: '/user', Component: UserPage_1.default }
];


/***/ }),

/***/ "./app/styles/styles.css":
/*!*******************************!*\
  !*** ./app/styles/styles.css ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var api = __webpack_require__(/*! ../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !../../node_modules/css-loader/dist/cjs.js!./styles.css */ "./node_modules/css-loader/dist/cjs.js!./app/styles/styles.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.i, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./app/theme/color/primary.ts":
/*!************************************!*\
  !*** ./app/theme/color/primary.ts ***!
  \************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const primary = {
    50: '#EAF7F9',
    100: '#CCEAEF',
    200: '#CCEAEF',
    300: '#AADDE4',
    400: '#6EC4D1',
    500: '#4285F4',
    600: '#4DB3C3',
    700: '#43ABBC',
    800: '#3AA3B5',
    900: '#115293',
    A100: '#ea80fc',
    A200: '#e040fb',
    A400: '#d500f9',
    A700: '#aa00ff',
};
exports.default = primary;


/***/ }),

/***/ "./app/theme/color/secondary.ts":
/*!**************************************!*\
  !*** ./app/theme/color/secondary.ts ***!
  \**************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const secondary = {
    50: '#D9FFF9',
    100: '#9BFDEE',
    200: '#18FDE2',
    300: '#00F7D3',
    400: '#00EDC5',
    500: '#F5F7F9',
    600: '#00B585',
    700: '#00A573',
    800: '#009766',
    900: '#008757',
    A100: '#ea80fc',
    A200: '#e040fb',
    A400: '#d500f9',
    A700: '#aa00ff',
};
exports.default = secondary;


/***/ }),

/***/ "./app/theme/index.ts":
/*!****************************!*\
  !*** ./app/theme/index.ts ***!
  \****************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const styles_1 = __webpack_require__(/*! @material-ui/core/styles */ "./node_modules/@material-ui/core/esm/styles/index.js");
const primary_1 = __importDefault(__webpack_require__(/*! ./color/primary */ "./app/theme/color/primary.ts"));
const secondary_1 = __importDefault(__webpack_require__(/*! ./color/secondary */ "./app/theme/color/secondary.ts"));
const typography_1 = __importDefault(__webpack_require__(/*! ./typography */ "./app/theme/typography.ts"));
const theme = styles_1.createMuiTheme({
    palette: {
        common: {
            black: '#000',
            white: '#fff',
        },
        primary: {
            light: primary_1.default[50],
            main: primary_1.default[500],
            dark: primary_1.default[900],
            contrastText: '#fff',
        },
        secondary: {
            light: secondary_1.default[50],
            main: secondary_1.default[500],
            dark: secondary_1.default[900],
            contrastText: '#fff',
        },
        text: {
            primary: 'rgba(0, 0, 0, 0.87)',
            disabled: 'rgba(0, 0, 0, 0.38)',
            hint: 'white',
        },
        background: {
            default: '#ffffff',
            paper: '#fff',
        },
    },
    typography: typography_1.default,
});
// TODO: remove all StyledButton usages
exports.default = theme;


/***/ }),

/***/ "./app/theme/typography.ts":
/*!*********************************!*\
  !*** ./app/theme/typography.ts ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const typography = {
    fontFamily: "'Source Sans Pro', sans-serif",
    fontSize: 16
};
exports.default = typography;


/***/ }),

/***/ "./app/utils/PinotMethodUtils.ts":
/*!***************************************!*\
  !*** ./app/utils/PinotMethodUtils.ts ***!
  \***************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const jwt_decode_1 = __importDefault(__webpack_require__(/*! jwt-decode */ "./node_modules/jwt-decode/build/jwt-decode.esm.js"));
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const moment_1 = __importDefault(__webpack_require__(/*! moment */ "./node_modules/moment/moment.js"));
const requests_1 = __webpack_require__(/*! ../requests */ "./app/requests/index.ts");
const axios_config_1 = __webpack_require__(/*! ./axios-config */ "./app/utils/axios-config.ts");
const Utils_1 = __importStar(__webpack_require__(/*! ./Utils */ "./app/utils/Utils.tsx"));
const react_router_1 = __webpack_require__(/*! react-router */ "./node_modules/react-router/esm/react-router.js");
const router_1 = __importDefault(__webpack_require__(/*! ../router */ "./app/router.tsx"));
const JSONbig = __webpack_require__(/*! json-bigint */ "./node_modules/json-bigint/index.js")({ 'storeAsString': true });
// This method is used to display tenants listing on cluster manager home page
// API: /tenants
// Expected Output: {columns: [], records: []}
const getTenantsData = () => {
    return requests_1.getTenants().then(({ data }) => {
        const records = lodash_1.union(data.SERVER_TENANTS, data.BROKER_TENANTS);
        const serverPromiseArr = [], brokerPromiseArr = [], tablePromiseArr = [];
        const finalResponse = {
            columns: ['Tenant Name', 'Server', 'Broker', 'Tables'],
            records: []
        };
        records.map((record) => {
            finalResponse.records.push([
                record
            ]);
            serverPromiseArr.push(getServerOfTenant(record));
            brokerPromiseArr.push(getBrokerOfTenant(record));
            tablePromiseArr.push(requests_1.getTenantTable(record));
        });
        return Promise.all([
            Promise.all(serverPromiseArr),
            Promise.all(brokerPromiseArr),
            Promise.all(tablePromiseArr)
        ]).then((results) => {
            const serversResponseData = results[0];
            const brokersResponseData = results[1];
            const tablesResponseData = results[2];
            tablesResponseData.map((tableResult, index) => {
                var _a, _b;
                const serverCount = ((_a = serversResponseData[index]) === null || _a === void 0 ? void 0 : _a.length) || 0;
                const brokerCount = ((_b = brokersResponseData[index]) === null || _b === void 0 ? void 0 : _b.length) || 0;
                const tablesCount = tableResult.data.tables.length;
                finalResponse.records[index].push(serverCount, brokerCount, tablesCount);
            });
            return finalResponse;
        });
    });
};
// This method is used to fetch all instances on cluster manager home page
// API: /instances
// Expected Output: {Controller: ['Controller1', 'Controller2'], Broker: ['Broker1', 'Broker2']}
const getAllInstances = () => {
    return requests_1.getInstances().then(({ data }) => {
        const initialVal = {};
        // It will create instances list array like
        // {Controller: ['Controller1', 'Controller2'], Broker: ['Broker1', 'Broker2']}
        const groupedData = data.instances.reduce((r, a) => {
            const y = a.split('_');
            const key = y[0].trim();
            r[key] = [...(r[key] || []), a];
            return r;
        }, initialVal);
        return Object.assign({ 'Controller': groupedData.Controller }, groupedData);
    });
};
// This method is used to display instance data on cluster manager home page
// API: /instances/:instanceName
// Expected Output: {columns: [], records: []}
const getInstanceData = (instances, liveInstanceArr) => {
    const promiseArr = [...instances.map((inst) => requests_1.getInstance(inst))];
    return Promise.all(promiseArr).then((result) => {
        return {
            columns: ['Instance Name', 'Enabled', 'Hostname', 'Port', 'Status'],
            records: [
                ...result.map(({ data }) => [
                    data.instanceName,
                    data.enabled,
                    data.hostName,
                    data.port,
                    liveInstanceArr.indexOf(data.instanceName) > -1 ? 'Alive' : 'Dead'
                ]),
            ],
        };
    });
};
// This method is used to fetch cluster name
// API: /cluster/info
// Expected Output: {clusterName: ''}
const getClusterName = () => {
    return requests_1.getClusterInfo().then(({ data }) => {
        return data.clusterName;
    });
};
// This method is used to fetch array of live instances name
// API: /zk/ls?path=:ClusterName/LIVEINSTANCES
// Expected Output: []
const getLiveInstance = (clusterName) => {
    const params = encodeURIComponent(`/${clusterName}/LIVEINSTANCES`);
    return requests_1.zookeeperGetList(params).then((data) => {
        return data;
    });
};
// This method is used to diaplay cluster congifuration on cluster manager home page
// API: /cluster/configs
// Expected Output: {columns: [], records: []}
const getClusterConfigData = () => {
    return requests_1.getClusterConfig().then(({ data }) => {
        return {
            columns: ['Property', 'Value'],
            records: [...Object.keys(data).map((key) => [key, data[key]])],
        };
    });
};
// This method is used to fetch cluster congifuration
// API: /cluster/configs
// Expected Output: {key: value}
const getClusterConfigJSON = () => {
    return requests_1.getClusterConfig().then(({ data }) => {
        return data;
    });
};
// This method is used to display table listing on query page
// API: /tables
// Expected Output: {columns: [], records: []}
const getQueryTablesList = ({ bothType = false }) => {
    const promiseArr = bothType ? [requests_1.getQueryTables('realtime'), requests_1.getQueryTables('offline')] : [requests_1.getQueryTables()];
    return Promise.all(promiseArr).then((results) => {
        const responseObj = {
            columns: ['Tables'],
            records: []
        };
        results.map((result) => {
            result.data.tables.map((table) => {
                responseObj.records.push([table]);
            });
        });
        return responseObj;
    });
};
// This method is used to display particular table schema on query page
// API: /tables/:tableName/schema
const getTableSchemaData = (tableName) => {
    return requests_1.getTableSchema(tableName).then(({ data }) => {
        return data;
    });
};
const getAsObject = (str) => {
    if (typeof str === 'string' || str instanceof String) {
        try {
            return JSONbig.parse(str);
        }
        catch (e) {
            return JSON.parse(JSON.stringify(str));
        }
    }
    return str;
};
// This method is used to display query output in tabular format as well as JSON format on query page
// API: /:urlName (Eg: sql or pql)
// Expected Output: {columns: [], records: []}
const getQueryResults = (params) => {
    return requests_1.getQueryResult(params).then(({ data }) => {
        var _a, _b, _c;
        let queryResponse = getAsObject(data);
        let exceptions = [];
        let dataArray = [];
        let columnList = [];
        // if sql api throws error, handle here
        if (typeof queryResponse === 'string') {
            exceptions.push({ errorCode: null, message: queryResponse });
        }
        // if sql api returns a structured error with a `code`, handle here
        if (queryResponse && queryResponse.code) {
            if (queryResponse.error) {
                exceptions.push({ errorCode: null, message: "Query failed with error code: " + queryResponse.code + " and error: " + queryResponse.error });
            }
            else {
                exceptions.push({ errorCode: null, message: "Query failed with error code: " + queryResponse.code + " but no logs. Please see controller logs for error." });
            }
        }
        if (queryResponse && queryResponse.exceptions && queryResponse.exceptions.length) {
            exceptions = queryResponse.exceptions;
        }
        if ((_c = (_b = (_a = queryResponse.resultTable) === null || _a === void 0 ? void 0 : _a.dataSchema) === null || _b === void 0 ? void 0 : _b.columnNames) === null || _c === void 0 ? void 0 : _c.length) {
            columnList = queryResponse.resultTable.dataSchema.columnNames;
            dataArray = queryResponse.resultTable.rows;
        }
        const columnStats = ['timeUsedMs',
            'numDocsScanned',
            'totalDocs',
            'numServersQueried',
            'numServersResponded',
            'numSegmentsQueried',
            'numSegmentsProcessed',
            'numSegmentsMatched',
            'numConsumingSegmentsQueried',
            'numEntriesScannedInFilter',
            'numEntriesScannedPostFilter',
            'numGroupsLimitReached',
            'partialResponse',
            'minConsumingFreshnessTimeMs',
            'offlineThreadCpuTimeNs',
            'realtimeThreadCpuTimeNs',
            'offlineSystemActivitiesCpuTimeNs',
            'realtimeSystemActivitiesCpuTimeNs',
            'offlineResponseSerializationCpuTimeNs',
            'realtimeResponseSerializationCpuTimeNs',
            'offlineTotalCpuTimeNs',
            'realtimeTotalCpuTimeNs'
        ];
        return {
            exceptions: exceptions,
            result: {
                columns: columnList,
                records: dataArray,
            },
            queryStats: {
                columns: columnStats,
                records: [[queryResponse.timeUsedMs, queryResponse.numDocsScanned, queryResponse.totalDocs, queryResponse.numServersQueried, queryResponse.numServersResponded,
                        queryResponse.numSegmentsQueried, queryResponse.numSegmentsProcessed, queryResponse.numSegmentsMatched, queryResponse.numConsumingSegmentsQueried,
                        queryResponse.numEntriesScannedInFilter, queryResponse.numEntriesScannedPostFilter, queryResponse.numGroupsLimitReached,
                        queryResponse.partialResponse ? queryResponse.partialResponse : '-', queryResponse.minConsumingFreshnessTimeMs,
                        queryResponse.offlineThreadCpuTimeNs, queryResponse.realtimeThreadCpuTimeNs,
                        queryResponse.offlineSystemActivitiesCpuTimeNs, queryResponse.realtimeSystemActivitiesCpuTimeNs,
                        queryResponse.offlineResponseSerializationCpuTimeNs, queryResponse.realtimeResponseSerializationCpuTimeNs,
                        queryResponse.offlineTotalCpuTimeNs, queryResponse.realtimeTotalCpuTimeNs]]
            },
            data: queryResponse,
        };
    });
};
// This method is used to display table data of a particular tenant
// API: /tenants/:tenantName/tables
//      /tables/:tableName/size
//      /tables/:tableName/idealstate
//      /tables/:tableName/externalview
// Expected Output: {columns: [], records: []}
const getTenantTableData = (tenantName) => {
    return requests_1.getTenantTable(tenantName).then(({ data }) => {
        const tableArr = data.tables.map((table) => table);
        return getAllTableDetails(tableArr);
    });
};
const getSchemaObject = (schemaName) => __awaiter(void 0, void 0, void 0, function* () {
    let schemaObj = [];
    let { data } = yield requests_1.getSchema(schemaName);
    schemaObj.push(data.schemaName);
    schemaObj.push(data.dimensionFieldSpecs ? data.dimensionFieldSpecs.length : 0);
    schemaObj.push(data.dateTimeFieldSpecs ? data.dateTimeFieldSpecs.length : 0);
    schemaObj.push(data.metricFieldSpecs ? data.metricFieldSpecs.length : 0);
    schemaObj.push(schemaObj[1] + schemaObj[2] + schemaObj[3]);
    return schemaObj;
});
// This method is used to display schema listing on the tables listing page
// API: /schemas
// Expected Output: {columns: [], records: []}
const getListingSchemaList = () => {
    return requests_1.getSchemaList().then((results) => {
        const responseObj = {
            columns: ['Schemas'],
            records: []
        };
        results.data.forEach((result) => {
            responseObj.records.push([result]);
        });
        return responseObj;
    });
};
const allSchemaDetailsColumnHeader = ["Schema Name", "Dimension Columns", "Date-Time Columns", "Metrics Columns", "Total Columns"];
const getAllSchemaDetails = (schemaList) => __awaiter(void 0, void 0, void 0, function* () {
    let schemaDetails = [];
    let promiseArr = [];
    promiseArr = schemaList.map((o) => __awaiter(void 0, void 0, void 0, function* () {
        return yield requests_1.getSchema(o);
    }));
    const results = yield Promise.all(promiseArr);
    schemaDetails = results.map((obj) => {
        let schemaObj = [];
        schemaObj.push(obj.data.schemaName);
        schemaObj.push(obj.data.dimensionFieldSpecs ? obj.data.dimensionFieldSpecs.length : 0);
        schemaObj.push(obj.data.dateTimeFieldSpecs ? obj.data.dateTimeFieldSpecs.length : 0);
        schemaObj.push(obj.data.metricFieldSpecs ? obj.data.metricFieldSpecs.length : 0);
        schemaObj.push(schemaObj[1] + schemaObj[2] + schemaObj[3]);
        return schemaObj;
    });
    return {
        columns: allSchemaDetailsColumnHeader,
        records: schemaDetails
    };
});
const allTableDetailsColumnHeader = [
    'Table Name',
    'Reported Size',
    'Estimated Size',
    'Number of Segments',
    'Status',
];
const getTableSizes = (tableName) => {
    return requests_1.getTableSize(tableName).then(result => {
        return {
            reported_size: Utils_1.default.formatBytes(result.data.reportedSizeInBytes),
            estimated_size: Utils_1.default.formatBytes(result.data.estimatedSizeInBytes),
        };
    });
};
const getSegmentCountAndStatus = (tableName) => {
    return requests_1.getIdealState(tableName).then(result => {
        const idealState = result.data.OFFLINE || result.data.REALTIME || {};
        return requests_1.getExternalView(tableName).then(result => {
            const externalView = result.data.OFFLINE || result.data.REALTIME || {};
            const externalSegmentCount = Object.keys(externalView).length;
            const idealSegmentCount = Object.keys(idealState).length;
            return {
                segment_count: `${externalSegmentCount} / ${idealSegmentCount}`,
                segment_status: Utils_1.default.getSegmentStatus(idealState, externalView)
            };
        });
    });
};
const getAllTableDetails = (tablesList) => {
    if (tablesList.length) {
        const promiseArr = [];
        tablesList.map((name) => {
            promiseArr.push(requests_1.getTableSize(name));
            promiseArr.push(requests_1.getIdealState(name));
            promiseArr.push(requests_1.getExternalView(name));
        });
        return Promise.all(promiseArr).then((results) => {
            const finalRecordsArr = [];
            let singleTableData = [];
            let idealStateObj = null;
            let externalViewObj = null;
            results.map((result, index) => {
                // since we have 3 promises, we are using mod 3 below
                if (index % 3 === 0) {
                    // response of getTableSize API
                    const { tableName, reportedSizeInBytes, estimatedSizeInBytes, } = result.data;
                    singleTableData.push(tableName, Utils_1.default.formatBytes(reportedSizeInBytes), Utils_1.default.formatBytes(estimatedSizeInBytes));
                }
                else if (index % 3 === 1) {
                    // response of getIdealState API
                    idealStateObj = result.data.OFFLINE || result.data.REALTIME || {};
                }
                else if (index % 3 === 2) {
                    // response of getExternalView API
                    externalViewObj = result.data.OFFLINE || result.data.REALTIME || {};
                    const externalSegmentCount = Object.keys(externalViewObj).length;
                    const idealSegmentCount = Object.keys(idealStateObj).length;
                    // Generating data for the record
                    singleTableData.push(`${externalSegmentCount} / ${idealSegmentCount}`, Utils_1.default.getSegmentStatus(idealStateObj, externalViewObj));
                    // saving into records array
                    finalRecordsArr.push(singleTableData);
                    // resetting the required variables
                    singleTableData = [];
                    idealStateObj = null;
                    externalViewObj = null;
                }
            });
            return {
                columns: allTableDetailsColumnHeader,
                records: finalRecordsArr,
            };
        });
    }
    return Promise.resolve({
        columns: allTableDetailsColumnHeader,
        records: []
    });
};
// This method is used to display summary of a particular tenant table
// API: /tables/:tableName/size
// Expected Output: {tableName: '', reportedSize: '', estimatedSize: ''}
const getTableSummaryData = (tableName) => {
    return requests_1.getTableSize(tableName).then(({ data }) => {
        return {
            tableName: data.tableName,
            reportedSize: data.reportedSizeInBytes,
            estimatedSize: data.estimatedSizeInBytes,
        };
    });
};
// This method is used to display segment list of a particular tenant table
// API: /tables/:tableName/idealstate
//      /tables/:tableName/externalview
// Expected Output: {columns: [], records: [], externalViewObject: {}}
const getSegmentList = (tableName) => {
    const promiseArr = [];
    promiseArr.push(requests_1.getIdealState(tableName));
    promiseArr.push(requests_1.getExternalView(tableName));
    return Promise.all(promiseArr).then((results) => {
        const idealStateObj = results[0].data.OFFLINE || results[0].data.REALTIME;
        const externalViewObj = results[1].data.OFFLINE || results[1].data.REALTIME;
        return {
            columns: ['Segment Name', 'Status'],
            records: Object.keys(idealStateObj).map((key) => {
                return [
                    key,
                    Utils_1.getDisplaySegmentStatus(idealStateObj[key], externalViewObj[key])
                ];
            }),
            externalViewObj
        };
    });
};
const getSegmentStatus = (idealSegment, externalViewSegment) => {
    if (lodash_1.isEqual(idealSegment, externalViewSegment)) {
        return 'Good';
    }
    let goodCount = 0;
    // There is a possibility that the segment is in ideal state but not in external view
    // making external view segment as null.
    const totalCount = externalViewSegment ? Object.keys(externalViewSegment).length : 0;
    Object.keys(idealSegment).map((replicaName) => {
        const idealReplicaState = idealSegment[replicaName];
        const externalReplicaState = externalViewSegment ? externalViewSegment[replicaName] : '';
        if (idealReplicaState === externalReplicaState || (externalReplicaState === 'CONSUMING')) {
            goodCount += 1;
        }
    });
    if (goodCount === 0 || totalCount === 0) {
        return 'Bad';
    }
    else if (goodCount === totalCount) {
        return 'Good';
    }
    else {
        return `Partial-${goodCount}/${totalCount}`;
    }
};
// This method is used to display JSON format of a particular tenant table
// API: /tables/:tableName/idealstate
//      /tables/:tableName/externalview
// Expected Output: {columns: [], records: []}
const getTableDetails = (tableName) => {
    return requests_1.getTenantTableDetails(tableName).then(({ data }) => {
        return data;
    });
};
// This method is used to display summary of a particular segment, replica set as well as JSON format of a tenant table
// API: /tables/tableName/externalview
//      /segments/:tableName/:segmentName/metadata
// Expected Output: {columns: [], records: []}
const getSegmentDetails = (tableName, segmentName) => {
    let [baseTableName, tableType] = Utils_1.default.splitStringByLastUnderscore(tableName);
    const promiseArr = [];
    promiseArr.push(requests_1.getExternalView(tableName));
    promiseArr.push(requests_1.getSegmentMetadata(tableName, segmentName));
    promiseArr.push(requests_1.getSegmentDebugInfo(baseTableName, tableType.toLowerCase()));
    return Promise.all(promiseArr).then((results) => {
        var _a;
        const obj = results[0].data.OFFLINE || results[0].data.REALTIME;
        const segmentMetaData = results[1].data;
        const debugObj = results[2].data;
        let debugInfoObj = {};
        if (debugObj && debugObj[0]) {
            const debugInfosObj = (_a = debugObj[0].segmentDebugInfos) === null || _a === void 0 ? void 0 : _a.find((o) => { return o.segmentName === segmentName; });
            if (debugInfosObj) {
                const serverNames = lodash_1.keys((debugInfosObj === null || debugInfosObj === void 0 ? void 0 : debugInfosObj.serverState) || {});
                serverNames === null || serverNames === void 0 ? void 0 : serverNames.map((serverName) => {
                    var _a, _b;
                    debugInfoObj[serverName] = (_b = (_a = debugInfosObj.serverState[serverName]) === null || _a === void 0 ? void 0 : _a.errorInfo) === null || _b === void 0 ? void 0 : _b.errorMessage;
                });
            }
        }
        const result = [];
        for (const prop in obj[segmentName]) {
            if (obj[segmentName]) {
                const status = obj[segmentName][prop];
                result.push([prop, status === 'ERROR' ? { value: status, tooltip: debugInfoObj[prop] } : status]);
            }
        }
        const segmentMetaDataJson = Object.assign({}, segmentMetaData);
        delete segmentMetaDataJson.indexes;
        delete segmentMetaDataJson.columns;
        const indexes = lodash_1.get(segmentMetaData, 'indexes', {});
        return {
            replicaSet: {
                columns: ['Server Name', 'Status'],
                records: [...result],
            },
            indexes: {
                columns: ['Field Name', 'Bloom Filter', 'Dictionary', 'Forward Index', 'Sorted', 'Inverted Index', 'JSON Index', 'Null Value Vector Reader', 'Range Index'],
                records: Object.keys(indexes).map(fieldName => [
                    fieldName,
                    segmentMetaData.indexes[fieldName]["bloom-filter"] === "YES",
                    segmentMetaData.indexes[fieldName]["dictionary"] === "YES",
                    segmentMetaData.indexes[fieldName]["forward-index"] === "YES",
                    ((segmentMetaData.columns || []).filter(row => row.columnName === fieldName)[0] || { sorted: false }).sorted,
                    segmentMetaData.indexes[fieldName]["inverted-index"] === "YES",
                    segmentMetaData.indexes[fieldName]["json-index"] === "YES",
                    segmentMetaData.indexes[fieldName]["null-value-vector-reader"] === "YES",
                    segmentMetaData.indexes[fieldName]["range-index"] === "YES",
                ])
            },
            summary: {
                segmentName,
                totalDocs: segmentMetaData['segment.total.docs'],
                createTime: moment_1.default(+segmentMetaData['segment.creation.time']).format('MMMM Do YYYY, h:mm:ss'),
            },
            JSON: segmentMetaDataJson
        };
    });
};
// This method is used to fetch the LIVEINSTANCE config
// API: /zk/get?path=:clusterName/LIVEINSTANCES/:instanceName
// Expected Output: configuration in JSON format
const getLiveInstanceConfig = (clusterName, instanceName) => {
    const params = encodeURIComponent(`/${clusterName}/LIVEINSTANCES/${instanceName}`);
    return requests_1.zookeeperGetData(params).then((res) => {
        return res.data;
    });
};
// This method is used to fetch the instance config
// API: /zk/get?path=:clusterName/CONFIGS/PARTICIPANT/:instanceName
// Expected Output: configuration in JSON format
const getInstanceConfig = (clusterName, instanceName) => {
    const params = encodeURIComponent(`/${clusterName}/CONFIGS/PARTICIPANT/${instanceName}`);
    return requests_1.zookeeperGetData(params).then((res) => {
        return res.data;
    });
};
// This method is used to get instance info
// API: /instances/:instanceName
const getInstanceDetails = (instanceName) => {
    return requests_1.getInstance(instanceName).then((res) => {
        return res.data;
    });
};
const updateInstanceDetails = (instanceName, instanceDetails) => {
    return requests_1.putInstance(instanceName, instanceDetails).then((res) => {
        return res.data;
    });
};
// This method is responsible to prepare the data for tree structure
// It internally calls getNodeData() which makes the required API calls.
const getZookeeperData = (path, count) => {
    let counter = count;
    const newTreeData = [{
            nodeId: `${counter++}`,
            label: path,
            child: [],
            isLeafNode: false,
            hasChildRendered: true
        }];
    return getNodeData(path).then((obj) => {
        const { currentNodeData, currentNodeMetadata, currentNodeListStat } = obj;
        const pathNames = Object.keys(currentNodeListStat);
        pathNames.map((pathName) => {
            newTreeData[0].child.push({
                nodeId: `${counter++}`,
                label: pathName,
                fullPath: path === '/' ? path + pathName : `${path}/${pathName}`,
                child: [],
                isLeafNode: currentNodeListStat[pathName].numChildren === 0,
                hasChildRendered: false
            });
        });
        return { newTreeData, currentNodeData, currentNodeMetadata, currentNodeListStat, counter };
    });
};
// This method is responsible to get data, get list with stats and get stats.
// API: /zk/get => Get node data
// API: /zk/lsl => Get node list with stats
// API: /zk/get => Get node stats
const getNodeData = (path) => {
    const params = encodeURIComponent(path);
    const promiseArr = [
        requests_1.zookeeperGetData(params),
        requests_1.zookeeperGetListWithStat(params),
        requests_1.zookeeperGetStat(params)
    ];
    return Promise.all(promiseArr).then((results) => {
        const currentNodeData = results[0].data || {};
        const currentNodeListStat = results[1].data;
        const currentNodeMetadata = results[2].data;
        if (currentNodeMetadata.ctime || currentNodeMetadata.mtime) {
            currentNodeMetadata.ctime = moment_1.default(+currentNodeMetadata.ctime).format('MMMM Do YYYY, h:mm:ss');
            currentNodeMetadata.mtime = moment_1.default(+currentNodeMetadata.mtime).format('MMMM Do YYYY, h:mm:ss');
        }
        return { currentNodeData, currentNodeMetadata, currentNodeListStat };
    });
};
const putNodeData = (data) => {
    const serializedData = Utils_1.default.serialize(data);
    return requests_1.zookeeperPutData(serializedData).then((obj) => {
        return obj;
    });
};
const deleteNode = (path) => {
    const params = encodeURIComponent(path);
    return requests_1.zookeeperDeleteNode(params).then((obj) => {
        return obj;
    });
};
const getBrokerOfTenant = (tenantName) => {
    return requests_1.getBrokerListOfTenant(tenantName).then((response) => {
        return !response.data.error ? response.data : [];
    });
};
const getServerOfTenant = (tenantName) => {
    return requests_1.getServerListOfTenant(tenantName).then((response) => {
        return !response.data.error ? response.data.ServerInstances : [];
    });
};
const updateTags = (instanceName, tagsList) => {
    return requests_1.updateInstanceTags(instanceName, tagsList.toString()).then((response) => {
        return response.data;
    });
};
const toggleInstanceState = (instanceName, state) => {
    return requests_1.setInstanceState(instanceName, state).then((response) => {
        return response.data;
    });
};
const toggleTableState = (tableName, state, tableType) => {
    return requests_1.setTableState(tableName, state, tableType).then((response) => {
        return response.data;
    });
};
const deleteInstance = (instanceName) => {
    return requests_1.dropInstance(instanceName).then((response) => {
        return response.data;
    });
};
const getAllPeriodicTaskNames = () => {
    return requests_1.getPeriodicTaskNames().then((response) => {
        return { columns: ['Task Name'], records: response.data.map(d => [d]) };
    });
};
const getAllTaskTypes = () => __awaiter(void 0, void 0, void 0, function* () {
    const finalResponse = {
        columns: ['Task Type', 'Num Tasks in Queue', 'Queue Status'],
        records: []
    };
    yield new Promise((resolve, reject) => {
        requests_1.getTaskTypes().then((response) => __awaiter(void 0, void 0, void 0, function* () {
            if (lodash_1.isArray(response.data)) {
                const promiseArr = [];
                const fetchInfo = (taskType) => __awaiter(void 0, void 0, void 0, function* () {
                    const [count, state] = yield getTaskInfo(taskType);
                    finalResponse.records.push([taskType, count, state]);
                });
                response.data.forEach((taskType) => promiseArr.push(fetchInfo(taskType)));
                yield Promise.all(promiseArr);
                resolve(finalResponse);
            }
        }));
    });
    return finalResponse;
});
const getTaskInfo = (taskType) => __awaiter(void 0, void 0, void 0, function* () {
    var _a;
    const tasksRes = yield requests_1.getTaskTypeTasks(taskType);
    const stateRes = yield requests_1.getTaskTypeState(taskType);
    let state = lodash_1.get(stateRes, 'data', '');
    // response contains error
    if (typeof state !== "string") {
        state = "";
    }
    return [((_a = tasksRes === null || tasksRes === void 0 ? void 0 : tasksRes.data) === null || _a === void 0 ? void 0 : _a.length) || 0, state];
});
const stopAllTasks = (taskType) => {
    return requests_1.stopTasks(taskType).then((response) => {
        return response.data;
    });
};
const resumeAllTasks = (taskType) => {
    return requests_1.resumeTasks(taskType).then((response) => {
        return response.data;
    });
};
const cleanupAllTasks = (taskType) => {
    return requests_1.cleanupTasks(taskType).then((response) => {
        return response.data;
    });
};
const deleteAllTasks = (taskType) => {
    return requests_1.deleteTasks(taskType).then((response) => {
        return response.data;
    });
};
const getMinionMetaData = (tableName, taskType) => {
    return requests_1.getMinionMeta(tableName, taskType).then((response) => {
        return response.data;
    });
};
const getElapsedTime = (startTime) => {
    const currentTime = moment_1.default();
    const diff = currentTime.diff(startTime);
    const elapsedTime = diff > (1000 * 60 * 60) ? `${currentTime.diff(startTime, 'hour')} hours` : `${currentTime.diff(startTime, 'minute')} minutes`;
    return elapsedTime;
};
const getTasksList = (tableName, taskType) => __awaiter(void 0, void 0, void 0, function* () {
    const finalResponse = {
        columns: ['Task ID', 'Status', 'Start Time', 'Finish Time', 'Num of Sub Tasks'],
        records: []
    };
    yield new Promise((resolve, reject) => {
        requests_1.getTasks(tableName, taskType).then((response) => __awaiter(void 0, void 0, void 0, function* () {
            const promiseArr = [];
            const fetchInfo = (taskID, status) => __awaiter(void 0, void 0, void 0, function* () {
                const debugData = yield getTaskDebugData(taskID);
                finalResponse.records.push([
                    taskID,
                    status,
                    lodash_1.get(debugData, 'data.startTime', ''),
                    lodash_1.get(debugData, 'data.finishTime', ''),
                    lodash_1.get(debugData, 'data.subtaskCount.total', 0)
                ]);
            });
            lodash_1.each(response.data, (val, key) => __awaiter(void 0, void 0, void 0, function* () {
                promiseArr.push(fetchInfo(key, val));
            }));
            yield Promise.all(promiseArr);
            resolve(finalResponse);
        }));
    });
    return finalResponse;
});
const getTaskRuntimeConfigData = (taskName) => __awaiter(void 0, void 0, void 0, function* () {
    const response = yield requests_1.getTaskRuntimeConfig(taskName);
    return response.data;
});
const getTaskDebugData = (taskName) => __awaiter(void 0, void 0, void 0, function* () {
    const debugRes = yield requests_1.getTaskDebug(taskName);
    return debugRes;
});
const getTaskProgressData = (taskName, subTaskName) => __awaiter(void 0, void 0, void 0, function* () {
    const progressData = yield requests_1.getTaskProgress(taskName, subTaskName);
    return progressData.data;
});
const getTaskGeneratorDebugData = (taskName, taskType) => __awaiter(void 0, void 0, void 0, function* () {
    const debugRes = yield requests_1.getTaskGeneratorDebug(taskName, taskType);
    return debugRes;
});
const reloadSegmentOp = (tableName, segmentName) => {
    return requests_1.reloadSegment(tableName, segmentName).then((response) => {
        return response.data;
    });
};
const reloadAllSegmentsOp = (tableName, tableType) => {
    return requests_1.reloadAllSegments(tableName, tableType).then((response) => {
        return response.data;
    });
};
const reloadStatusOp = (tableName, tableType) => {
    return requests_1.reloadStatus(tableName, tableType).then((response) => {
        return response.data;
    });
};
const deleteSegmentOp = (tableName, segmentName) => {
    return requests_1.deleteSegment(tableName, segmentName).then((response) => {
        return response.data;
    });
};
const fetchTableJobs = (tableName, jobTypes) => __awaiter(void 0, void 0, void 0, function* () {
    const response = yield requests_1.getTableJobs(tableName, jobTypes);
    return response.data;
});
const fetchSegmentReloadStatus = (jobId) => __awaiter(void 0, void 0, void 0, function* () {
    const response = yield requests_1.getSegmentReloadStatus(jobId);
    return response.data;
});
const updateTable = (tableName, table) => {
    return requests_1.putTable(tableName, table).then((res) => {
        return res.data;
    });
};
const updateSchema = (schemaName, schema, reload) => {
    return requests_1.putSchema(schemaName, schema, reload).then((res) => {
        return res.data;
    });
};
const deleteTableOp = (tableName) => {
    return requests_1.deleteTable(tableName).then((response) => {
        return response.data;
    });
};
const deleteSchemaOp = (tableName) => {
    return requests_1.deleteSchema(tableName).then((response) => {
        return response.data;
    });
};
const rebalanceServersForTableOp = (tableName, queryParams) => {
    const q_params = Utils_1.default.serialize(queryParams);
    return requests_1.rebalanceServersForTable(tableName, q_params).then((response) => {
        return response.data;
    });
};
const rebalanceBrokersForTableOp = (tableName) => {
    return requests_1.rebalanceBrokersForTable(tableName).then((response) => {
        return response.data;
    });
};
const validateSchemaAction = (schemaObj) => {
    return requests_1.validateSchema(schemaObj).then((response) => {
        return response.data;
    });
};
const validateTableAction = (tableObj) => {
    return requests_1.validateTable(tableObj).then((response) => {
        return response.data;
    });
};
const saveSchemaAction = (schemaObj) => {
    return requests_1.saveSchema(schemaObj).then((response) => {
        return response.data;
    });
};
const saveTableAction = (tableObj) => {
    return requests_1.saveTable(tableObj).then((response) => {
        return response.data;
    });
};
const getSchemaData = (schemaName) => {
    return requests_1.getSchema(schemaName).then((response) => {
        return response.data;
    });
};
const getTableState = (tableName, tableType) => {
    return requests_1.getState(tableName, tableType).then((response) => {
        return response.data;
    });
};
const getAuthInfo = () => {
    return requests_1.getInfo().then((response) => {
        return response.data;
    });
};
const getWellKnownOpenIdConfiguration = (issuer) => {
    return axios_config_1.baseApi
        .get(`${issuer}/.well-known/openid-configuration`)
        .then((response) => {
        return response.data;
    });
};
const verifyAuth = (authToken) => {
    return requests_1.authenticateUser(authToken).then((response) => {
        return response.data;
    });
};
const getAccessTokenFromHashParams = () => {
    let accessToken = '';
    const hashParam = removeAllLeadingForwardSlash(location.hash.substring(1));
    const urlSearchParams = new URLSearchParams(hashParam);
    if (urlSearchParams.has('access_token')) {
        accessToken = urlSearchParams.get('access_token');
    }
    return accessToken;
};
const removeAllLeadingForwardSlash = (string) => {
    if (!string) {
        return "";
    }
    return string.replace(new RegExp("^/+", "g"), "");
};
// validates app redirect path with known routes
const validateRedirectPath = (path) => {
    if (!path) {
        return false;
    }
    if (!path.startsWith("/")) {
        path = "/" + path;
    }
    let pathName = "";
    try {
        const appUrl = new URL(location.origin + path);
        pathName = appUrl.pathname;
    }
    catch (err) {
        console.error(err);
        return false;
    }
    const knownAppRoutes = router_1.default.map((data) => data.path);
    const routeMatches = react_router_1.matchPath(pathName, { path: knownAppRoutes, exact: true });
    if (!routeMatches) {
        return false;
    }
    return true;
};
const getURLWithoutAccessToken = (fallbackUrl = '/') => {
    let prefix = '';
    let url = location.hash.substring(1);
    if (url.includes('access_token=')) {
        if (url.startsWith('/')) {
            prefix = '/';
            url = url.substring(1);
        }
        const urlSearchParams = new URLSearchParams(url);
        urlSearchParams.delete('access_token');
        const urlParams = [];
        // Loop over to get all params with empty value
        for (const [key, value] of urlSearchParams.entries()) {
            if (!value) {
                urlParams.push(key);
            }
        }
        // Loop over to delete all params with empty value
        for (const key of urlParams) {
            urlSearchParams.delete(key);
        }
        // Check if any param remains, prepend it to urlParam as string
        if (urlSearchParams.toString()) {
            urlParams.unshift(urlSearchParams.toString());
        }
        url = urlParams.join('&');
        if (!validateRedirectPath(url)) {
            // constructed redirect url is not a valid app route
            // redirect to fallBackUrl
            url = fallbackUrl;
        }
    }
    else {
        url = fallbackUrl;
    }
    return `${prefix}${url}`;
};
const getTable = () => {
    return requests_1.requestTable().then(response => {
        return response.data;
    });
};
const getTaskTypeDebugData = (taskType) => {
    return requests_1.getTaskTypeDebug(taskType).then(response => {
        return response.data;
    });
};
const getTableData = (params) => {
    return requests_1.getTables(params).then(response => {
        return response.data;
    });
};
const scheduleTaskAction = (tableName, taskType) => {
    return requests_1.scheduleTask(tableName, taskType).then(response => {
        return response.data;
    });
};
const executeTaskAction = (data) => {
    return requests_1.executeTask(data).then(response => {
        return response.data;
    });
};
const getScheduleJobDetail = (tableName, taskType) => {
    return requests_1.getJobDetail(tableName, taskType).then(response => {
        return response.data;
    });
};
const getUserList = () => {
    return requests_1.requestUserList().then(response => {
        return response.data;
    });
};
const addUser = (userObject) => {
    return requests_1.requestAddUser(userObject).then(response => {
        return response.data;
    });
};
const deleteUser = (userObject) => {
    return requests_1.requestDeleteUser(userObject).then(response => {
        return response.data;
    });
};
const updateUser = (userObject, passwordChanged) => {
    return requests_1.requestUpdateUser(userObject, passwordChanged).then(response => {
        return response.data;
    });
};
const getAuthUserNameFromAccessToken = (accessToken) => {
    if (!accessToken) {
        return "";
    }
    let decoded;
    try {
        decoded = jwt_decode_1.default(accessToken);
    }
    catch (e) {
        return "";
    }
    if (!decoded) {
        return "";
    }
    const name = lodash_1.get(decoded, "name") || "";
    return name;
};
const getAuthUserEmailFromAccessToken = (accessToken) => {
    if (!accessToken) {
        return "";
    }
    let decoded;
    try {
        decoded = jwt_decode_1.default(accessToken);
    }
    catch (e) {
        return "";
    }
    if (!decoded) {
        return "";
    }
    const email = lodash_1.get(decoded, "email") || "";
    return email;
};
exports.default = {
    getTenantsData,
    getAllInstances,
    getInstanceData,
    getClusterConfigData,
    getClusterConfigJSON,
    getQueryTablesList,
    getTableSchemaData,
    getQueryResults,
    getTenantTableData,
    allTableDetailsColumnHeader,
    getAllTableDetails,
    getTableSummaryData,
    getSegmentList,
    getSegmentStatus,
    getTableDetails,
    getSegmentDetails,
    getSegmentCountAndStatus,
    getClusterName,
    getLiveInstance,
    getLiveInstanceConfig,
    getInstanceConfig,
    getInstanceDetails,
    updateInstanceDetails,
    getZookeeperData,
    getNodeData,
    putNodeData,
    deleteNode,
    getBrokerOfTenant,
    getServerOfTenant,
    updateTags,
    toggleInstanceState,
    toggleTableState,
    deleteInstance,
    getAllPeriodicTaskNames,
    getAllTaskTypes,
    fetchTableJobs,
    fetchSegmentReloadStatus,
    getTaskTypeDebugData,
    getTableData,
    getTableSizes,
    getTaskRuntimeConfigData,
    getTaskInfo,
    stopAllTasks,
    resumeAllTasks,
    cleanupAllTasks,
    deleteAllTasks,
    scheduleTaskAction,
    executeTaskAction,
    getScheduleJobDetail,
    getMinionMetaData,
    getElapsedTime,
    getTasksList,
    getTaskDebugData,
    getTaskProgressData,
    getTaskGeneratorDebugData,
    deleteSegmentOp,
    reloadSegmentOp,
    reloadStatusOp,
    reloadAllSegmentsOp,
    updateTable,
    updateSchema,
    deleteTableOp,
    deleteSchemaOp,
    rebalanceServersForTableOp,
    rebalanceBrokersForTableOp,
    validateSchemaAction,
    validateTableAction,
    saveSchemaAction,
    saveTableAction,
    getSchemaData,
    getQuerySchemaList: getListingSchemaList,
    allSchemaDetailsColumnHeader,
    getAllSchemaDetails,
    getTableState,
    getAuthInfo,
    getWellKnownOpenIdConfiguration,
    verifyAuth,
    getAccessTokenFromHashParams,
    getURLWithoutAccessToken,
    getTable,
    getUserList,
    addUser,
    deleteUser,
    updateUser,
    getAuthUserNameFromAccessToken,
    getAuthUserEmailFromAccessToken
};


/***/ }),

/***/ "./app/utils/SortFunctions.tsx":
/*!*************************************!*\
  !*** ./app/utils/SortFunctions.tsx ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const app_state_1 = __importDefault(__webpack_require__(/*! ../app_state */ "./app/app_state.ts"));
// table sorting requires a 1/-1 result. This helper function helps calculate this
// from any two results.
const valuesToResultNumber = (aRes, bRes, order) => {
    const result = order ? aRes > bRes : aRes < bRes;
    return result ? 1 : -1;
};
exports.sortNumberOfSegments = (a, b, column, index, order) => {
    const aSegmentInt = parseInt(a[column + app_state_1.default.columnNameSeparator + index]);
    const bSegmentInt = parseInt(b[column + app_state_1.default.columnNameSeparator + index]);
    return valuesToResultNumber(aSegmentInt, bSegmentInt, order);
};
exports.sortBytes = (a, b, column, index, order) => {
    const sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];
    const [aValue, aUnit] = a[column + app_state_1.default.columnNameSeparator + index].split(" ");
    const [bValue, bUnit] = b[column + app_state_1.default.columnNameSeparator + index].split(" ");
    const aUnitIndex = sizes.indexOf(aUnit);
    const bUnitIndex = sizes.indexOf(bUnit);
    if (sizes.indexOf(aUnit) === sizes.indexOf(bUnit)) {
        return valuesToResultNumber(parseFloat(aValue), parseFloat(bValue), order);
    }
    else {
        return valuesToResultNumber(aUnitIndex, bUnitIndex, order);
    }
};


/***/ }),

/***/ "./app/utils/Utils.tsx":
/*!*****************************!*\
  !*** ./app/utils/Utils.tsx ***!
  \*****************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/* eslint-disable no-nested-ternary */
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(__webpack_require__(/*! react */ "./node_modules/react/index.js"));
const react_diff_viewer_1 = __importStar(__webpack_require__(/*! react-diff-viewer */ "./node_modules/react-diff-viewer/lib/index.js"));
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const app_state_1 = __importDefault(__webpack_require__(/*! ../app_state */ "./app/app_state.ts"));
const Loading_1 = __importDefault(__webpack_require__(/*! ../components/Loading */ "./app/components/Loading.tsx"));
const sortArray = function (sortingArr, keyName, ascendingFlag) {
    if (ascendingFlag) {
        return sortingArr.sort(function (a, b) {
            if (a[keyName] < b[keyName]) {
                return -1;
            }
            if (a[keyName] > b[keyName]) {
                return 1;
            }
            return 0;
        });
    }
    return sortingArr.sort(function (a, b) {
        if (b[keyName] < a[keyName]) {
            return -1;
        }
        if (b[keyName] > a[keyName]) {
            return 1;
        }
        return 0;
    });
};
const pinotTableDetailsFormat = (tableDetails) => {
    return [
        tableDetails.name,
        tableDetails.estimated_size || Loading_1.default,
        tableDetails.reported_size || Loading_1.default,
        tableDetails.number_of_segments || Loading_1.default,
        tableDetails.segment_status || Loading_1.default
    ];
};
const pinotTableDetailsFromArray = (tableDetails) => {
    return {
        name: tableDetails[0],
        estimated_size: tableDetails[1],
        reported_size: tableDetails[2],
        number_of_segments: tableDetails[3],
        segment_status: tableDetails[4]
    };
};
const tableFormat = (data) => {
    const rows = data.records;
    const header = data.columns;
    const results = [];
    rows.forEach((singleRow) => {
        const obj = {};
        singleRow.forEach((val, index) => {
            obj[header[index] + app_state_1.default.columnNameSeparator + index] = val;
        });
        results.push(obj);
    });
    return results;
};
const getSegmentStatus = (idealStateObj, externalViewObj) => {
    const tableStatus = exports.getDisplayTableStatus(idealStateObj, externalViewObj);
    const statusMismatchDiffComponent = (react_1.default.createElement(react_diff_viewer_1.default, { oldValue: JSON.stringify(idealStateObj, null, 2), newValue: JSON.stringify(externalViewObj, null, 2), splitView: true, showDiffOnly: true, leftTitle: "Ideal State", rightTitle: "External View", compareMethod: react_diff_viewer_1.DiffMethod.WORDS }));
    if (tableStatus === "BAD" /* BAD */) {
        return ({
            value: tableStatus,
            tooltip: "One or more segments in this table are in bad state. Click the status to view more details.",
            component: statusMismatchDiffComponent,
        });
    }
    if (tableStatus === "UPDATING" /* UPDATING */) {
        return ({
            value: tableStatus,
            tooltip: "One or more segments in this table are in updating state. Click the status to view more details.",
            component: statusMismatchDiffComponent,
        });
    }
    return ({
        value: tableStatus,
        tooltip: "All segments in this table are in good state.",
    });
};
const findNestedObj = (entireObj, keyToFind, valToFind) => {
    let foundObj;
    JSON.stringify(entireObj, (a, nestedValue) => {
        if (nestedValue && nestedValue[keyToFind] === valToFind) {
            foundObj = nestedValue;
        }
        return nestedValue;
    });
    return foundObj;
};
const generateCodeMirrorOptions = (array, type, modeType) => {
    const arr = [];
    // eslint-disable-next-line no-shadow
    const nestedFields = (arrayList, type, level, oldObj) => {
        lodash_1.map(arrayList, (a) => {
            const obj = {
                text: a.displayName || a.name || a,
                displayText: a.displayName || a.name || a,
                filterText: oldObj
                    ? `${oldObj.filterText}.${a.displayName || a.name || a}`
                    : a.displayName || a.name || a,
                render: (el, cm, data) => { },
                className: type === 'FUNCTION'
                    ? 'codemirror-func'
                    : type === 'SQL'
                        ? 'codemirror-sql'
                        : type === 'BINARY-OPERATORS'
                            ? 'codemirror-Operators'
                            : type === 'TABLE'
                                ? 'codemirror-table'
                                : 'codemirror-column'
            };
            obj[type === 'FUNCTION' ? 'returnType' : 'type'] =
                type === 'FUNCTION'
                    ? a.returnType
                    : type === 'SQL'
                        ? 'SQL'
                        : type === 'BINARY-OPERATORS'
                            ? 'Binary Operators'
                            : a.type;
            obj.render = (el, cm, data) => {
                codeMirrorOptionsTemplate(el, data);
            };
            if (oldObj === undefined) {
                arr.push(obj);
            }
            else {
                const index = lodash_1.findIndex(arr, (n) => n.filterText === oldObj.filterText);
                if (index !== -1) {
                    const name = obj.displayText;
                    if (modeType === 'sql') {
                        obj.displayText = `${oldObj.displayText}.${name}`;
                        obj.text = `${oldObj.text}.${name}`;
                    }
                    else {
                        obj.displayText = name;
                        obj.text = name;
                    }
                    obj.filterText = `${oldObj.text}.${name}`;
                    if (arr[index].fields) {
                        arr[index].fields.push(obj);
                    }
                    else {
                        arr[index].fields = [];
                        arr[index].fields.push(obj);
                    }
                }
                else {
                    const indexPath = getNestedObjPathFromList(arr, oldObj);
                    if (indexPath && indexPath.length) {
                        pushNestedObjectInArray(indexPath, obj, arr, modeType);
                    }
                }
            }
            if (a.fields) {
                nestedFields(a.fields, type, level + 1, obj);
            }
        });
        return arr;
    };
    return nestedFields(array, type, 0);
};
const pushNestedObjectInArray = (pathArr, obj, targetList, modeType) => {
    const rollOverFields = (target) => {
        lodash_1.map(target, (list) => {
            if (pathArr === list.filterText) {
                if (modeType === 'sql') {
                    obj.displayText = `${pathArr}.${obj.displayText}`;
                    obj.text = `${pathArr}.${obj.text}`;
                }
                else {
                    obj.displayText = obj.displayText;
                    obj.text = obj.text;
                }
                obj.filterText = `${pathArr}.${obj.text}`;
                if (list.fields) {
                    list.fields.push(obj);
                }
                else {
                    list.fields = [];
                    list.fields.push(obj);
                }
            }
            else if (list.fields) {
                rollOverFields(list.fields);
            }
        });
    };
    rollOverFields(targetList);
};
const getNestedObjPathFromList = (list, obj) => {
    const str = [];
    const recursiveFunc = (arr, level) => {
        lodash_1.map(arr, (a) => {
            if (a.fields) {
                str.push(a.filterText);
                recursiveFunc(a.fields, level + 1);
            }
            else if (obj.filterText === a.filterText) {
                str.push(a.filterText);
            }
        });
        return lodash_1.findLast(str);
    };
    return recursiveFunc(list, 0);
};
const codeMirrorOptionsTemplate = (el, data) => {
    const text = document.createElement('div');
    const fNameSpan = document.createElement('span');
    fNameSpan.setAttribute('class', 'funcText');
    fNameSpan.innerHTML = data.displayText;
    text.appendChild(fNameSpan);
    el.appendChild(text);
    // data.returnType is for UDF Function ||  data.type is for Fields
    if (data.returnType || data.type) {
        const returnTypetxt = document.createElement('div');
        returnTypetxt.setAttribute('class', 'fieldText');
        const content = data.returnType
            ? `Return Type: ${data.returnType}`
            : `Type: ${data.type}`;
        returnTypetxt.innerHTML = content;
        el.appendChild(returnTypetxt);
    }
};
const serialize = (obj, prefix) => {
    let str = [], p;
    for (p in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, p)) {
            var k = prefix ? prefix + "[" + p + "]" : p, v = obj[p];
            str.push((v !== null && typeof v === "object") ?
                serialize(v, k) :
                encodeURIComponent(k) + "=" + encodeURIComponent(v));
        }
    }
    return str.join("&");
};
const navigateToPreviousPage = (location, popTwice) => {
    const hasharr = location.pathname.split('/');
    hasharr.pop();
    if (popTwice) {
        hasharr.pop();
    }
    return hasharr.join('/');
};
const syncTableSchemaData = (data, showFieldType) => {
    const dimensionFields = data.dimensionFieldSpecs || [];
    const metricFields = data.metricFieldSpecs || [];
    const dateTimeField = data.dateTimeFieldSpecs || [];
    dimensionFields.map((field) => {
        field.fieldType = 'Dimension';
    });
    metricFields.map((field) => {
        field.fieldType = 'Metric';
    });
    dateTimeField.map((field) => {
        field.fieldType = 'Date-Time';
    });
    const columnList = [...dimensionFields, ...metricFields, ...dateTimeField];
    if (showFieldType) {
        return {
            columns: ['Column', 'Type', 'Field Type', 'Multi Value'],
            records: columnList.map((field) => {
                return [field.name, field.dataType, field.fieldType, getMultiValueField(field)];
            }),
        };
    }
    return {
        columns: ['Column', 'Type'],
        records: columnList.map((field) => {
            return [field.name, field.dataType];
        }),
    };
};
const getMultiValueField = (field) => {
    if (!field) {
        return false;
    }
    if ("singleValueField" in field && field.singleValueField === false) {
        return true;
    }
    return false;
};
const encodeString = (str) => {
    if (str === unescape(str)) {
        return escape(str);
    }
    return str;
};
const formatBytes = (bytes, decimals = 2) => {
    if (bytes === 0)
        return '0 Bytes';
    const k = 1024;
    const dm = decimals < 0 ? 0 : decimals;
    const sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];
    const i = Math.floor(Math.log(bytes) / Math.log(k));
    return parseFloat((bytes / Math.pow(k, i)).toFixed(dm)) + ' ' + sizes[i];
};
const splitStringByLastUnderscore = (str) => {
    if (!str.includes('_')) {
        return [str, ''];
    }
    let beforeUnderscore = str.substring(0, str.lastIndexOf("_"));
    let afterUnderscore = str.substring(str.lastIndexOf("_") + 1, str.length);
    return [beforeUnderscore, afterUnderscore];
};
exports.getDisplayTableStatus = (idealStateObj, externalViewObj) => {
    const segmentStatusArr = [];
    Object.keys(idealStateObj).forEach((key) => {
        segmentStatusArr.push(exports.getDisplaySegmentStatus(idealStateObj[key], externalViewObj[key]));
    });
    if (segmentStatusArr.includes("BAD" /* BAD */)) {
        return "BAD" /* BAD */;
    }
    if (segmentStatusArr.includes("UPDATING" /* UPDATING */)) {
        return "UPDATING" /* UPDATING */;
    }
    return "GOOD" /* GOOD */;
};
exports.getDisplaySegmentStatus = (idealState, externalView) => {
    const externalViewStatesArray = Object.values(externalView || {});
    // if EV contains ERROR state then segment is in Bad state
    if (externalViewStatesArray.includes("ERROR" /* ERROR */)) {
        return "BAD" /* BAD */;
    }
    // if EV status is CONSUMING or ONLINE then segment is in Good state
    if (externalViewStatesArray.every((status) => status === "CONSUMING" /* CONSUMING */ || status === "ONLINE" /* ONLINE */) && lodash_1.isEqual(idealState, externalView)) {
        return "GOOD" /* GOOD */;
    }
    // If EV state is OFFLINE and EV matches IS then segment is in Good state.
    if (externalViewStatesArray.includes("OFFLINE" /* OFFLINE */) && lodash_1.isEqual(idealState, externalView)) {
        return "GOOD" /* GOOD */;
    }
    // If EV is empty or EV state is OFFLINE and does not matches IS then segment is in Partial state.
    // PARTIAL state can also be interpreted as we're waiting for segments to converge
    if (externalViewStatesArray.length === 0 || externalViewStatesArray.includes("OFFLINE" /* OFFLINE */) && !lodash_1.isEqual(idealState, externalView)) {
        return "UPDATING" /* UPDATING */;
    }
    // does not match any condition -> assume PARTIAL state as we are waiting for segments to converge 
    return "UPDATING" /* UPDATING */;
};
exports.getInstanceTypeFromInstanceName = (instanceName) => {
    if (instanceName.toLowerCase().startsWith("broker" /* BROKER */.toLowerCase())) {
        return "broker" /* BROKER */;
    }
    else if (instanceName.toLowerCase().startsWith("controller" /* CONTROLLER */.toLowerCase())) {
        return "controller" /* CONTROLLER */;
    }
    else if (instanceName.toLowerCase().startsWith("minion" /* MINION */.toLowerCase())) {
        return "minion" /* MINION */;
    }
    else if (instanceName.toLowerCase().startsWith("server" /* SERVER */.toLowerCase())) {
        return "server" /* SERVER */;
    }
    else {
        return null;
    }
};
exports.getInstanceTypeFromString = (instanceType) => {
    if (instanceType.toLowerCase() === "broker" /* BROKER */.toLowerCase()) {
        return "broker" /* BROKER */;
    }
    else if (instanceType.toLowerCase() === "controller" /* CONTROLLER */.toLowerCase()) {
        return "controller" /* CONTROLLER */;
    }
    else if (instanceType.toLowerCase() === "minion" /* MINION */.toLowerCase()) {
        return "minion" /* MINION */;
    }
    else if (instanceType.toLowerCase() === "server" /* SERVER */.toLowerCase()) {
        return "server" /* SERVER */;
    }
    else {
        return null;
    }
};
const getLoadingTableData = (columns) => {
    return {
        columns: columns,
        records: [
            columns.map((_) => Loading_1.default),
        ],
    };
};
exports.default = {
    sortArray,
    tableFormat,
    getSegmentStatus,
    findNestedObj,
    generateCodeMirrorOptions,
    serialize,
    navigateToPreviousPage,
    syncTableSchemaData,
    encodeString,
    formatBytes,
    splitStringByLastUnderscore,
    pinotTableDetailsFormat,
    pinotTableDetailsFromArray,
    getLoadingTableData
};


/***/ }),

/***/ "./app/utils/axios-config.ts":
/*!***********************************!*\
  !*** ./app/utils/axios-config.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const axios_1 = __importDefault(__webpack_require__(/*! axios */ "./node_modules/axios/index.js"));
const app_state_1 = __importDefault(__webpack_require__(/*! ../app_state */ "./app/app_state.ts"));
const isDev = "development" !== 'production';
// Returns axios request interceptor
exports.getAxiosRequestInterceptor = (accessToken) => {
    const requestInterceptor = (requestConfig) => {
        // If access token is available, attach it to the request
        // basic auth
        if (app_state_1.default.authWorkflow === "BASIC" /* BASIC */ && app_state_1.default.authToken) {
            requestConfig.headers = {
                Authorization: app_state_1.default.authToken,
            };
        }
        // OIDC auth
        if (accessToken) {
            requestConfig.headers = {
                Authorization: accessToken,
            };
        }
        return requestConfig;
    };
    return requestInterceptor;
};
// Returns axios rejected response interceptor
exports.getAxiosErrorInterceptor = (unauthenticatedAccessFn) => {
    const rejectedResponseInterceptor = (error) => {
        if (error && error.response && (error.response.status === 401 || error.response.status === 403)) {
            // Unauthenticated access
            unauthenticatedAccessFn && unauthenticatedAccessFn();
        }
        return error.response || error;
    };
    return rejectedResponseInterceptor;
};
// Returns axios fulfilled response interceptor
exports.getAxiosResponseInterceptor = () => {
    const fulfilledResponseInterceptor = (response) => {
        // Forward the fulfilled response
        return response;
    };
    return fulfilledResponseInterceptor;
};
exports.baseApi = axios_1.default.create({ baseURL: '/' });
exports.baseApi.interceptors.request.use(exports.getAxiosRequestInterceptor(), exports.getAxiosErrorInterceptor());
exports.baseApi.interceptors.response.use(exports.getAxiosResponseInterceptor(), exports.getAxiosErrorInterceptor());
exports.transformApi = axios_1.default.create({ baseURL: '/', transformResponse: [data => data] });
exports.transformApi.interceptors.request.use(exports.getAxiosRequestInterceptor(), exports.getAxiosErrorInterceptor());
exports.transformApi.interceptors.response.use(exports.getAxiosResponseInterceptor(), exports.getAxiosErrorInterceptor());
// baseApi axios instance does not throw an error when API fails hence the control will never go to catch block
// changing the handleError method of baseApi will cause current UI to break (as UI might have not handle error properly)
// creating a new axios instance baseApiWithErrors which can be used when adding new API's
// NOTE: It is an add-on utility and can be used in case you want to handle/show UI when API fails.
exports.baseApiWithErrors = axios_1.default.create({ baseURL: '/' });
exports.baseApiWithErrors.interceptors.request.use(exports.getAxiosRequestInterceptor());
exports.baseApiWithErrors.interceptors.response.use(exports.getAxiosResponseInterceptor());


/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/assertThisInitialized.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/assertThisInitialized.js ***!
  \**********************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

function _assertThisInitialized(self) {
  if (self === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return self;
}

module.exports = _assertThisInitialized, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/defineProperty.js":
/*!***************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/defineProperty.js ***!
  \***************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
}

module.exports = _defineProperty, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/arrayLikeToArray.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/arrayLikeToArray.js ***!
  \*********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _arrayLikeToArray; });
function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length) len = arr.length;

  for (var i = 0, arr2 = new Array(len); i < len; i++) {
    arr2[i] = arr[i];
  }

  return arr2;
}

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/arrayWithHoles.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/arrayWithHoles.js ***!
  \*******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _arrayWithHoles; });
function _arrayWithHoles(arr) {
  if (Array.isArray(arr)) return arr;
}

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/arrayWithoutHoles.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/arrayWithoutHoles.js ***!
  \**********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _arrayWithoutHoles; });
/* harmony import */ var _arrayLikeToArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./arrayLikeToArray.js */ "./node_modules/@babel/runtime/helpers/esm/arrayLikeToArray.js");

function _arrayWithoutHoles(arr) {
  if (Array.isArray(arr)) return Object(_arrayLikeToArray_js__WEBPACK_IMPORTED_MODULE_0__["default"])(arr);
}

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/assertThisInitialized.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/assertThisInitialized.js ***!
  \**************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _assertThisInitialized; });
function _assertThisInitialized(self) {
  if (self === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return self;
}

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/classCallCheck.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/classCallCheck.js ***!
  \*******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _classCallCheck; });
function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/createClass.js":
/*!****************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/createClass.js ***!
  \****************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _createClass; });
function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}

function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  Object.defineProperty(Constructor, "prototype", {
    writable: false
  });
  return Constructor;
}

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/defineProperty.js ***!
  \*******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _defineProperty; });
function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
}

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/extends.js":
/*!************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/extends.js ***!
  \************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _extends; });
function _extends() {
  _extends = Object.assign ? Object.assign.bind() : function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };
  return _extends.apply(this, arguments);
}

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/getPrototypeOf.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/getPrototypeOf.js ***!
  \*******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _getPrototypeOf; });
function _getPrototypeOf(o) {
  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) {
    return o.__proto__ || Object.getPrototypeOf(o);
  };
  return _getPrototypeOf(o);
}

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/inherits.js":
/*!*************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/inherits.js ***!
  \*************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _inherits; });
/* harmony import */ var _setPrototypeOf_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./setPrototypeOf.js */ "./node_modules/@babel/runtime/helpers/esm/setPrototypeOf.js");

function _inherits(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }

  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      writable: true,
      configurable: true
    }
  });
  Object.defineProperty(subClass, "prototype", {
    writable: false
  });
  if (superClass) Object(_setPrototypeOf_js__WEBPACK_IMPORTED_MODULE_0__["default"])(subClass, superClass);
}

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/inheritsLoose.js":
/*!******************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/inheritsLoose.js ***!
  \******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _inheritsLoose; });
/* harmony import */ var _setPrototypeOf_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./setPrototypeOf.js */ "./node_modules/@babel/runtime/helpers/esm/setPrototypeOf.js");

function _inheritsLoose(subClass, superClass) {
  subClass.prototype = Object.create(superClass.prototype);
  subClass.prototype.constructor = subClass;
  Object(_setPrototypeOf_js__WEBPACK_IMPORTED_MODULE_0__["default"])(subClass, superClass);
}

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/iterableToArray.js":
/*!********************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/iterableToArray.js ***!
  \********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _iterableToArray; });
function _iterableToArray(iter) {
  if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
}

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/iterableToArrayLimit.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/iterableToArrayLimit.js ***!
  \*************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _iterableToArrayLimit; });
function _iterableToArrayLimit(arr, i) {
  var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"];

  if (_i == null) return;
  var _arr = [];
  var _n = true;
  var _d = false;

  var _s, _e;

  try {
    for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) {
      _arr.push(_s.value);

      if (i && _arr.length === i) break;
    }
  } catch (err) {
    _d = true;
    _e = err;
  } finally {
    try {
      if (!_n && _i["return"] != null) _i["return"]();
    } finally {
      if (_d) throw _e;
    }
  }

  return _arr;
}

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/nonIterableRest.js":
/*!********************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/nonIterableRest.js ***!
  \********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _nonIterableRest; });
function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/nonIterableSpread.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/nonIterableSpread.js ***!
  \**********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _nonIterableSpread; });
function _nonIterableSpread() {
  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js ***!
  \****************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _objectWithoutProperties; });
/* harmony import */ var _objectWithoutPropertiesLoose_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./objectWithoutPropertiesLoose.js */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutPropertiesLoose.js");

function _objectWithoutProperties(source, excluded) {
  if (source == null) return {};
  var target = Object(_objectWithoutPropertiesLoose_js__WEBPACK_IMPORTED_MODULE_0__["default"])(source, excluded);
  var key, i;

  if (Object.getOwnPropertySymbols) {
    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

    for (i = 0; i < sourceSymbolKeys.length; i++) {
      key = sourceSymbolKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
      target[key] = source[key];
    }
  }

  return target;
}

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/objectWithoutPropertiesLoose.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/objectWithoutPropertiesLoose.js ***!
  \*********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _objectWithoutPropertiesLoose; });
function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;

  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }

  return target;
}

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/possibleConstructorReturn.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/possibleConstructorReturn.js ***!
  \******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _possibleConstructorReturn; });
/* harmony import */ var _typeof_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./typeof.js */ "./node_modules/@babel/runtime/helpers/esm/typeof.js");
/* harmony import */ var _assertThisInitialized_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./assertThisInitialized.js */ "./node_modules/@babel/runtime/helpers/esm/assertThisInitialized.js");


function _possibleConstructorReturn(self, call) {
  if (call && (Object(_typeof_js__WEBPACK_IMPORTED_MODULE_0__["default"])(call) === "object" || typeof call === "function")) {
    return call;
  } else if (call !== void 0) {
    throw new TypeError("Derived constructors may only return object or undefined");
  }

  return Object(_assertThisInitialized_js__WEBPACK_IMPORTED_MODULE_1__["default"])(self);
}

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/setPrototypeOf.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/setPrototypeOf.js ***!
  \*******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _setPrototypeOf; });
function _setPrototypeOf(o, p) {
  _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) {
    o.__proto__ = p;
    return o;
  };
  return _setPrototypeOf(o, p);
}

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/slicedToArray.js":
/*!******************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/slicedToArray.js ***!
  \******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _slicedToArray; });
/* harmony import */ var _arrayWithHoles_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./arrayWithHoles.js */ "./node_modules/@babel/runtime/helpers/esm/arrayWithHoles.js");
/* harmony import */ var _iterableToArrayLimit_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./iterableToArrayLimit.js */ "./node_modules/@babel/runtime/helpers/esm/iterableToArrayLimit.js");
/* harmony import */ var _unsupportedIterableToArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./unsupportedIterableToArray.js */ "./node_modules/@babel/runtime/helpers/esm/unsupportedIterableToArray.js");
/* harmony import */ var _nonIterableRest_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./nonIterableRest.js */ "./node_modules/@babel/runtime/helpers/esm/nonIterableRest.js");




function _slicedToArray(arr, i) {
  return Object(_arrayWithHoles_js__WEBPACK_IMPORTED_MODULE_0__["default"])(arr) || Object(_iterableToArrayLimit_js__WEBPACK_IMPORTED_MODULE_1__["default"])(arr, i) || Object(_unsupportedIterableToArray_js__WEBPACK_IMPORTED_MODULE_2__["default"])(arr, i) || Object(_nonIterableRest_js__WEBPACK_IMPORTED_MODULE_3__["default"])();
}

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/toArray.js":
/*!************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/toArray.js ***!
  \************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _toArray; });
/* harmony import */ var _arrayWithHoles_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./arrayWithHoles.js */ "./node_modules/@babel/runtime/helpers/esm/arrayWithHoles.js");
/* harmony import */ var _iterableToArray_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./iterableToArray.js */ "./node_modules/@babel/runtime/helpers/esm/iterableToArray.js");
/* harmony import */ var _unsupportedIterableToArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./unsupportedIterableToArray.js */ "./node_modules/@babel/runtime/helpers/esm/unsupportedIterableToArray.js");
/* harmony import */ var _nonIterableRest_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./nonIterableRest.js */ "./node_modules/@babel/runtime/helpers/esm/nonIterableRest.js");




function _toArray(arr) {
  return Object(_arrayWithHoles_js__WEBPACK_IMPORTED_MODULE_0__["default"])(arr) || Object(_iterableToArray_js__WEBPACK_IMPORTED_MODULE_1__["default"])(arr) || Object(_unsupportedIterableToArray_js__WEBPACK_IMPORTED_MODULE_2__["default"])(arr) || Object(_nonIterableRest_js__WEBPACK_IMPORTED_MODULE_3__["default"])();
}

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/toConsumableArray.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/toConsumableArray.js ***!
  \**********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _toConsumableArray; });
/* harmony import */ var _arrayWithoutHoles_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./arrayWithoutHoles.js */ "./node_modules/@babel/runtime/helpers/esm/arrayWithoutHoles.js");
/* harmony import */ var _iterableToArray_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./iterableToArray.js */ "./node_modules/@babel/runtime/helpers/esm/iterableToArray.js");
/* harmony import */ var _unsupportedIterableToArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./unsupportedIterableToArray.js */ "./node_modules/@babel/runtime/helpers/esm/unsupportedIterableToArray.js");
/* harmony import */ var _nonIterableSpread_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./nonIterableSpread.js */ "./node_modules/@babel/runtime/helpers/esm/nonIterableSpread.js");




function _toConsumableArray(arr) {
  return Object(_arrayWithoutHoles_js__WEBPACK_IMPORTED_MODULE_0__["default"])(arr) || Object(_iterableToArray_js__WEBPACK_IMPORTED_MODULE_1__["default"])(arr) || Object(_unsupportedIterableToArray_js__WEBPACK_IMPORTED_MODULE_2__["default"])(arr) || Object(_nonIterableSpread_js__WEBPACK_IMPORTED_MODULE_3__["default"])();
}

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/typeof.js":
/*!***********************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/typeof.js ***!
  \***********************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _typeof; });
function _typeof(obj) {
  "@babel/helpers - typeof";

  return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) {
    return typeof obj;
  } : function (obj) {
    return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
  }, _typeof(obj);
}

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/unsupportedIterableToArray.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/unsupportedIterableToArray.js ***!
  \*******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _unsupportedIterableToArray; });
/* harmony import */ var _arrayLikeToArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./arrayLikeToArray.js */ "./node_modules/@babel/runtime/helpers/esm/arrayLikeToArray.js");

function _unsupportedIterableToArray(o, minLen) {
  if (!o) return;
  if (typeof o === "string") return Object(_arrayLikeToArray_js__WEBPACK_IMPORTED_MODULE_0__["default"])(o, minLen);
  var n = Object.prototype.toString.call(o).slice(8, -1);
  if (n === "Object" && o.constructor) n = o.constructor.name;
  if (n === "Map" || n === "Set") return Array.from(o);
  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return Object(_arrayLikeToArray_js__WEBPACK_IMPORTED_MODULE_0__["default"])(o, minLen);
}

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/extends.js":
/*!********************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/extends.js ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

function _extends() {
  module.exports = _extends = Object.assign ? Object.assign.bind() : function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  }, module.exports.__esModule = true, module.exports["default"] = module.exports;
  return _extends.apply(this, arguments);
}

module.exports = _extends, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/inheritsLoose.js":
/*!**************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/inheritsLoose.js ***!
  \**************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var setPrototypeOf = __webpack_require__(/*! ./setPrototypeOf.js */ "./node_modules/@babel/runtime/helpers/setPrototypeOf.js");

function _inheritsLoose(subClass, superClass) {
  subClass.prototype = Object.create(superClass.prototype);
  subClass.prototype.constructor = subClass;
  setPrototypeOf(subClass, superClass);
}

module.exports = _inheritsLoose, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/interopRequireDefault.js ***!
  \**********************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : {
    "default": obj
  };
}

module.exports = _interopRequireDefault, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/interopRequireWildcard.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/interopRequireWildcard.js ***!
  \***********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var _typeof = __webpack_require__(/*! ./typeof.js */ "./node_modules/@babel/runtime/helpers/typeof.js")["default"];

function _getRequireWildcardCache(nodeInterop) {
  if (typeof WeakMap !== "function") return null;
  var cacheBabelInterop = new WeakMap();
  var cacheNodeInterop = new WeakMap();
  return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) {
    return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
  })(nodeInterop);
}

function _interopRequireWildcard(obj, nodeInterop) {
  if (!nodeInterop && obj && obj.__esModule) {
    return obj;
  }

  if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
    return {
      "default": obj
    };
  }

  var cache = _getRequireWildcardCache(nodeInterop);

  if (cache && cache.has(obj)) {
    return cache.get(obj);
  }

  var newObj = {};
  var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;

  for (var key in obj) {
    if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
      var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;

      if (desc && (desc.get || desc.set)) {
        Object.defineProperty(newObj, key, desc);
      } else {
        newObj[key] = obj[key];
      }
    }
  }

  newObj["default"] = obj;

  if (cache) {
    cache.set(obj, newObj);
  }

  return newObj;
}

module.exports = _interopRequireWildcard, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/objectWithoutProperties.js":
/*!************************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/objectWithoutProperties.js ***!
  \************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var objectWithoutPropertiesLoose = __webpack_require__(/*! ./objectWithoutPropertiesLoose.js */ "./node_modules/@babel/runtime/helpers/objectWithoutPropertiesLoose.js");

function _objectWithoutProperties(source, excluded) {
  if (source == null) return {};
  var target = objectWithoutPropertiesLoose(source, excluded);
  var key, i;

  if (Object.getOwnPropertySymbols) {
    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

    for (i = 0; i < sourceSymbolKeys.length; i++) {
      key = sourceSymbolKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
      target[key] = source[key];
    }
  }

  return target;
}

module.exports = _objectWithoutProperties, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/objectWithoutPropertiesLoose.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/objectWithoutPropertiesLoose.js ***!
  \*****************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;

  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }

  return target;
}

module.exports = _objectWithoutPropertiesLoose, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/setPrototypeOf.js":
/*!***************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/setPrototypeOf.js ***!
  \***************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

function _setPrototypeOf(o, p) {
  module.exports = _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) {
    o.__proto__ = p;
    return o;
  }, module.exports.__esModule = true, module.exports["default"] = module.exports;
  return _setPrototypeOf(o, p);
}

module.exports = _setPrototypeOf, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/typeof.js":
/*!*******************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/typeof.js ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

function _typeof(obj) {
  "@babel/helpers - typeof";

  return (module.exports = _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) {
    return typeof obj;
  } : function (obj) {
    return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
  }, module.exports.__esModule = true, module.exports["default"] = module.exports), _typeof(obj);
}

module.exports = _typeof, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ "./node_modules/@emotion/cache/dist/cache.browser.esm.js":
/*!***************************************************************!*\
  !*** ./node_modules/@emotion/cache/dist/cache.browser.esm.js ***!
  \***************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _emotion_sheet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @emotion/sheet */ "./node_modules/@emotion/sheet/dist/sheet.browser.esm.js");
/* harmony import */ var _emotion_stylis__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/stylis */ "./node_modules/@emotion/stylis/dist/stylis.browser.esm.js");
/* harmony import */ var _emotion_weak_memoize__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @emotion/weak-memoize */ "./node_modules/@emotion/weak-memoize/dist/weak-memoize.browser.esm.js");




// https://github.com/thysultan/stylis.js/tree/master/plugins/rule-sheet
// inlined to avoid umd wrapper and peerDep warnings/installing stylis
// since we use stylis after closure compiler
var delimiter = '/*|*/';
var needle = delimiter + '}';

function toSheet(block) {
  if (block) {
    Sheet.current.insert(block + '}');
  }
}

var Sheet = {
  current: null
};
var ruleSheet = function ruleSheet(context, content, selectors, parents, line, column, length, ns, depth, at) {
  switch (context) {
    // property
    case 1:
      {
        switch (content.charCodeAt(0)) {
          case 64:
            {
              // @import
              Sheet.current.insert(content + ';');
              return '';
            }
          // charcode for l

          case 108:
            {
              // charcode for b
              // this ignores label
              if (content.charCodeAt(2) === 98) {
                return '';
              }
            }
        }

        break;
      }
    // selector

    case 2:
      {
        if (ns === 0) return content + delimiter;
        break;
      }
    // at-rule

    case 3:
      {
        switch (ns) {
          // @font-face, @page
          case 102:
          case 112:
            {
              Sheet.current.insert(selectors[0] + content);
              return '';
            }

          default:
            {
              return content + (at === 0 ? delimiter : '');
            }
        }
      }

    case -2:
      {
        content.split(needle).forEach(toSheet);
      }
  }
};

var createCache = function createCache(options) {
  if (options === undefined) options = {};
  var key = options.key || 'css';
  var stylisOptions;

  if (options.prefix !== undefined) {
    stylisOptions = {
      prefix: options.prefix
    };
  }

  var stylis = new _emotion_stylis__WEBPACK_IMPORTED_MODULE_1__["default"](stylisOptions);

  if (true) {
    // $FlowFixMe
    if (/[^a-z-]/.test(key)) {
      throw new Error("Emotion key must only contain lower case alphabetical characters and - but \"" + key + "\" was passed");
    }
  }

  var inserted = {}; // $FlowFixMe

  var container;

  {
    container = options.container || document.head;
    var nodes = document.querySelectorAll("style[data-emotion-" + key + "]");
    Array.prototype.forEach.call(nodes, function (node) {
      var attrib = node.getAttribute("data-emotion-" + key); // $FlowFixMe

      attrib.split(' ').forEach(function (id) {
        inserted[id] = true;
      });

      if (node.parentNode !== container) {
        container.appendChild(node);
      }
    });
  }

  var _insert;

  {
    stylis.use(options.stylisPlugins)(ruleSheet);

    _insert = function insert(selector, serialized, sheet, shouldCache) {
      var name = serialized.name;
      Sheet.current = sheet;

      if ( true && serialized.map !== undefined) {
        var map = serialized.map;
        Sheet.current = {
          insert: function insert(rule) {
            sheet.insert(rule + map);
          }
        };
      }

      stylis(selector, serialized.styles);

      if (shouldCache) {
        cache.inserted[name] = true;
      }
    };
  }

  if (true) {
    // https://esbench.com/bench/5bf7371a4cd7e6009ef61d0a
    var commentStart = /\/\*/g;
    var commentEnd = /\*\//g;
    stylis.use(function (context, content) {
      switch (context) {
        case -1:
          {
            while (commentStart.test(content)) {
              commentEnd.lastIndex = commentStart.lastIndex;

              if (commentEnd.test(content)) {
                commentStart.lastIndex = commentEnd.lastIndex;
                continue;
              }

              throw new Error('Your styles have an unterminated comment ("/*" without corresponding "*/").');
            }

            commentStart.lastIndex = 0;
            break;
          }
      }
    });
    stylis.use(function (context, content, selectors) {
      switch (context) {
        case -1:
          {
            var flag = 'emotion-disable-server-rendering-unsafe-selector-warning-please-do-not-use-this-the-warning-exists-for-a-reason';
            var unsafePseudoClasses = content.match(/(:first|:nth|:nth-last)-child/g);

            if (unsafePseudoClasses && cache.compat !== true) {
              unsafePseudoClasses.forEach(function (unsafePseudoClass) {
                var ignoreRegExp = new RegExp(unsafePseudoClass + ".*\\/\\* " + flag + " \\*\\/");
                var ignore = ignoreRegExp.test(content);

                if (unsafePseudoClass && !ignore) {
                  console.error("The pseudo class \"" + unsafePseudoClass + "\" is potentially unsafe when doing server-side rendering. Try changing it to \"" + unsafePseudoClass.split('-child')[0] + "-of-type\".");
                }
              });
            }

            break;
          }
      }
    });
  }

  var cache = {
    key: key,
    sheet: new _emotion_sheet__WEBPACK_IMPORTED_MODULE_0__["StyleSheet"]({
      key: key,
      container: container,
      nonce: options.nonce,
      speedy: options.speedy
    }),
    nonce: options.nonce,
    inserted: inserted,
    registered: {},
    insert: _insert
  };
  return cache;
};

/* harmony default export */ __webpack_exports__["default"] = (createCache);


/***/ }),

/***/ "./node_modules/@emotion/hash/dist/hash.browser.esm.js":
/*!*************************************************************!*\
  !*** ./node_modules/@emotion/hash/dist/hash.browser.esm.js ***!
  \*************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* eslint-disable */
// Inspired by https://github.com/garycourt/murmurhash-js
// Ported from https://github.com/aappleby/smhasher/blob/61a0530f28277f2e850bfc39600ce61d02b518de/src/MurmurHash2.cpp#L37-L86
function murmur2(str) {
  // 'm' and 'r' are mixing constants generated offline.
  // They're not really 'magic', they just happen to work well.
  // const m = 0x5bd1e995;
  // const r = 24;
  // Initialize the hash
  var h = 0; // Mix 4 bytes at a time into the hash

  var k,
      i = 0,
      len = str.length;

  for (; len >= 4; ++i, len -= 4) {
    k = str.charCodeAt(i) & 0xff | (str.charCodeAt(++i) & 0xff) << 8 | (str.charCodeAt(++i) & 0xff) << 16 | (str.charCodeAt(++i) & 0xff) << 24;
    k =
    /* Math.imul(k, m): */
    (k & 0xffff) * 0x5bd1e995 + ((k >>> 16) * 0xe995 << 16);
    k ^=
    /* k >>> r: */
    k >>> 24;
    h =
    /* Math.imul(k, m): */
    (k & 0xffff) * 0x5bd1e995 + ((k >>> 16) * 0xe995 << 16) ^
    /* Math.imul(h, m): */
    (h & 0xffff) * 0x5bd1e995 + ((h >>> 16) * 0xe995 << 16);
  } // Handle the last few bytes of the input array


  switch (len) {
    case 3:
      h ^= (str.charCodeAt(i + 2) & 0xff) << 16;

    case 2:
      h ^= (str.charCodeAt(i + 1) & 0xff) << 8;

    case 1:
      h ^= str.charCodeAt(i) & 0xff;
      h =
      /* Math.imul(h, m): */
      (h & 0xffff) * 0x5bd1e995 + ((h >>> 16) * 0xe995 << 16);
  } // Do a few final mixes of the hash to ensure the last few
  // bytes are well-incorporated.


  h ^= h >>> 13;
  h =
  /* Math.imul(h, m): */
  (h & 0xffff) * 0x5bd1e995 + ((h >>> 16) * 0xe995 << 16);
  return ((h ^ h >>> 15) >>> 0).toString(36);
}

/* harmony default export */ __webpack_exports__["default"] = (murmur2);


/***/ }),

/***/ "./node_modules/@emotion/memoize/dist/memoize.browser.esm.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@emotion/memoize/dist/memoize.browser.esm.js ***!
  \*******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function memoize(fn) {
  var cache = {};
  return function (arg) {
    if (cache[arg] === undefined) cache[arg] = fn(arg);
    return cache[arg];
  };
}

/* harmony default export */ __webpack_exports__["default"] = (memoize);


/***/ }),

/***/ "./node_modules/@emotion/serialize/dist/serialize.browser.esm.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@emotion/serialize/dist/serialize.browser.esm.js ***!
  \***********************************************************************/
/*! exports provided: serializeStyles */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "serializeStyles", function() { return serializeStyles; });
/* harmony import */ var _emotion_hash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @emotion/hash */ "./node_modules/@emotion/hash/dist/hash.browser.esm.js");
/* harmony import */ var _emotion_unitless__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/unitless */ "./node_modules/@emotion/unitless/dist/unitless.browser.esm.js");
/* harmony import */ var _emotion_memoize__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @emotion/memoize */ "./node_modules/@emotion/memoize/dist/memoize.browser.esm.js");




var ILLEGAL_ESCAPE_SEQUENCE_ERROR = "You have illegal escape sequence in your template literal, most likely inside content's property value.\nBecause you write your CSS inside a JavaScript string you actually have to do double escaping, so for example \"content: '\\00d7';\" should become \"content: '\\\\00d7';\".\nYou can read more about this here:\nhttps://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Template_literals#ES2018_revision_of_illegal_escape_sequences";
var UNDEFINED_AS_OBJECT_KEY_ERROR = "You have passed in falsy value as style object's key (can happen when in example you pass unexported component as computed key).";
var hyphenateRegex = /[A-Z]|^ms/g;
var animationRegex = /_EMO_([^_]+?)_([^]*?)_EMO_/g;

var isCustomProperty = function isCustomProperty(property) {
  return property.charCodeAt(1) === 45;
};

var isProcessableValue = function isProcessableValue(value) {
  return value != null && typeof value !== 'boolean';
};

var processStyleName = Object(_emotion_memoize__WEBPACK_IMPORTED_MODULE_2__["default"])(function (styleName) {
  return isCustomProperty(styleName) ? styleName : styleName.replace(hyphenateRegex, '-$&').toLowerCase();
});

var processStyleValue = function processStyleValue(key, value) {
  switch (key) {
    case 'animation':
    case 'animationName':
      {
        if (typeof value === 'string') {
          return value.replace(animationRegex, function (match, p1, p2) {
            cursor = {
              name: p1,
              styles: p2,
              next: cursor
            };
            return p1;
          });
        }
      }
  }

  if (_emotion_unitless__WEBPACK_IMPORTED_MODULE_1__["default"][key] !== 1 && !isCustomProperty(key) && typeof value === 'number' && value !== 0) {
    return value + 'px';
  }

  return value;
};

if (true) {
  var contentValuePattern = /(attr|calc|counters?|url)\(/;
  var contentValues = ['normal', 'none', 'counter', 'open-quote', 'close-quote', 'no-open-quote', 'no-close-quote', 'initial', 'inherit', 'unset'];
  var oldProcessStyleValue = processStyleValue;
  var msPattern = /^-ms-/;
  var hyphenPattern = /-(.)/g;
  var hyphenatedCache = {};

  processStyleValue = function processStyleValue(key, value) {
    if (key === 'content') {
      if (typeof value !== 'string' || contentValues.indexOf(value) === -1 && !contentValuePattern.test(value) && (value.charAt(0) !== value.charAt(value.length - 1) || value.charAt(0) !== '"' && value.charAt(0) !== "'")) {
        console.error("You seem to be using a value for 'content' without quotes, try replacing it with `content: '\"" + value + "\"'`");
      }
    }

    var processed = oldProcessStyleValue(key, value);

    if (processed !== '' && !isCustomProperty(key) && key.indexOf('-') !== -1 && hyphenatedCache[key] === undefined) {
      hyphenatedCache[key] = true;
      console.error("Using kebab-case for css properties in objects is not supported. Did you mean " + key.replace(msPattern, 'ms-').replace(hyphenPattern, function (str, _char) {
        return _char.toUpperCase();
      }) + "?");
    }

    return processed;
  };
}

var shouldWarnAboutInterpolatingClassNameFromCss = true;

function handleInterpolation(mergedProps, registered, interpolation, couldBeSelectorInterpolation) {
  if (interpolation == null) {
    return '';
  }

  if (interpolation.__emotion_styles !== undefined) {
    if ( true && interpolation.toString() === 'NO_COMPONENT_SELECTOR') {
      throw new Error('Component selectors can only be used in conjunction with babel-plugin-emotion.');
    }

    return interpolation;
  }

  switch (typeof interpolation) {
    case 'boolean':
      {
        return '';
      }

    case 'object':
      {
        if (interpolation.anim === 1) {
          cursor = {
            name: interpolation.name,
            styles: interpolation.styles,
            next: cursor
          };
          return interpolation.name;
        }

        if (interpolation.styles !== undefined) {
          var next = interpolation.next;

          if (next !== undefined) {
            // not the most efficient thing ever but this is a pretty rare case
            // and there will be very few iterations of this generally
            while (next !== undefined) {
              cursor = {
                name: next.name,
                styles: next.styles,
                next: cursor
              };
              next = next.next;
            }
          }

          var styles = interpolation.styles + ";";

          if ( true && interpolation.map !== undefined) {
            styles += interpolation.map;
          }

          return styles;
        }

        return createStringFromObject(mergedProps, registered, interpolation);
      }

    case 'function':
      {
        if (mergedProps !== undefined) {
          var previousCursor = cursor;
          var result = interpolation(mergedProps);
          cursor = previousCursor;
          return handleInterpolation(mergedProps, registered, result, couldBeSelectorInterpolation);
        } else if (true) {
          console.error('Functions that are interpolated in css calls will be stringified.\n' + 'If you want to have a css call based on props, create a function that returns a css call like this\n' + 'let dynamicStyle = (props) => css`color: ${props.color}`\n' + 'It can be called directly with props or interpolated in a styled call like this\n' + "let SomeComponent = styled('div')`${dynamicStyle}`");
        }

        break;
      }

    case 'string':
      if (true) {
        var matched = [];
        var replaced = interpolation.replace(animationRegex, function (match, p1, p2) {
          var fakeVarName = "animation" + matched.length;
          matched.push("const " + fakeVarName + " = keyframes`" + p2.replace(/^@keyframes animation-\w+/, '') + "`");
          return "${" + fakeVarName + "}";
        });

        if (matched.length) {
          console.error('`keyframes` output got interpolated into plain string, please wrap it with `css`.\n\n' + 'Instead of doing this:\n\n' + [].concat(matched, ["`" + replaced + "`"]).join('\n') + '\n\nYou should wrap it with `css` like this:\n\n' + ("css`" + replaced + "`"));
        }
      }

      break;
  } // finalize string values (regular strings and functions interpolated into css calls)


  if (registered == null) {
    return interpolation;
  }

  var cached = registered[interpolation];

  if ( true && couldBeSelectorInterpolation && shouldWarnAboutInterpolatingClassNameFromCss && cached !== undefined) {
    console.error('Interpolating a className from css`` is not recommended and will cause problems with composition.\n' + 'Interpolating a className from css`` will be completely unsupported in a future major version of Emotion');
    shouldWarnAboutInterpolatingClassNameFromCss = false;
  }

  return cached !== undefined && !couldBeSelectorInterpolation ? cached : interpolation;
}

function createStringFromObject(mergedProps, registered, obj) {
  var string = '';

  if (Array.isArray(obj)) {
    for (var i = 0; i < obj.length; i++) {
      string += handleInterpolation(mergedProps, registered, obj[i], false);
    }
  } else {
    for (var _key in obj) {
      var value = obj[_key];

      if (typeof value !== 'object') {
        if (registered != null && registered[value] !== undefined) {
          string += _key + "{" + registered[value] + "}";
        } else if (isProcessableValue(value)) {
          string += processStyleName(_key) + ":" + processStyleValue(_key, value) + ";";
        }
      } else {
        if (_key === 'NO_COMPONENT_SELECTOR' && "development" !== 'production') {
          throw new Error('Component selectors can only be used in conjunction with babel-plugin-emotion.');
        }

        if (Array.isArray(value) && typeof value[0] === 'string' && (registered == null || registered[value[0]] === undefined)) {
          for (var _i = 0; _i < value.length; _i++) {
            if (isProcessableValue(value[_i])) {
              string += processStyleName(_key) + ":" + processStyleValue(_key, value[_i]) + ";";
            }
          }
        } else {
          var interpolated = handleInterpolation(mergedProps, registered, value, false);

          switch (_key) {
            case 'animation':
            case 'animationName':
              {
                string += processStyleName(_key) + ":" + interpolated + ";";
                break;
              }

            default:
              {
                if ( true && _key === 'undefined') {
                  console.error(UNDEFINED_AS_OBJECT_KEY_ERROR);
                }

                string += _key + "{" + interpolated + "}";
              }
          }
        }
      }
    }
  }

  return string;
}

var labelPattern = /label:\s*([^\s;\n{]+)\s*;/g;
var sourceMapPattern;

if (true) {
  sourceMapPattern = /\/\*#\ssourceMappingURL=data:application\/json;\S+\s+\*\//;
} // this is the cursor for keyframes
// keyframes are stored on the SerializedStyles object as a linked list


var cursor;
var serializeStyles = function serializeStyles(args, registered, mergedProps) {
  if (args.length === 1 && typeof args[0] === 'object' && args[0] !== null && args[0].styles !== undefined) {
    return args[0];
  }

  var stringMode = true;
  var styles = '';
  cursor = undefined;
  var strings = args[0];

  if (strings == null || strings.raw === undefined) {
    stringMode = false;
    styles += handleInterpolation(mergedProps, registered, strings, false);
  } else {
    if ( true && strings[0] === undefined) {
      console.error(ILLEGAL_ESCAPE_SEQUENCE_ERROR);
    }

    styles += strings[0];
  } // we start at 1 since we've already handled the first arg


  for (var i = 1; i < args.length; i++) {
    styles += handleInterpolation(mergedProps, registered, args[i], styles.charCodeAt(styles.length - 1) === 46);

    if (stringMode) {
      if ( true && strings[i] === undefined) {
        console.error(ILLEGAL_ESCAPE_SEQUENCE_ERROR);
      }

      styles += strings[i];
    }
  }

  var sourceMap;

  if (true) {
    styles = styles.replace(sourceMapPattern, function (match) {
      sourceMap = match;
      return '';
    });
  } // using a global regex with .exec is stateful so lastIndex has to be reset each time


  labelPattern.lastIndex = 0;
  var identifierName = '';
  var match; // https://esbench.com/bench/5b809c2cf2949800a0f61fb5

  while ((match = labelPattern.exec(styles)) !== null) {
    identifierName += '-' + // $FlowFixMe we know it's not null
    match[1];
  }

  var name = Object(_emotion_hash__WEBPACK_IMPORTED_MODULE_0__["default"])(styles) + identifierName;

  if (true) {
    // $FlowFixMe SerializedStyles type doesn't have toString property (and we don't want to add it)
    return {
      name: name,
      styles: styles,
      map: sourceMap,
      next: cursor,
      toString: function toString() {
        return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop).";
      }
    };
  }

  return {
    name: name,
    styles: styles,
    next: cursor
  };
};




/***/ }),

/***/ "./node_modules/@emotion/sheet/dist/sheet.browser.esm.js":
/*!***************************************************************!*\
  !*** ./node_modules/@emotion/sheet/dist/sheet.browser.esm.js ***!
  \***************************************************************/
/*! exports provided: StyleSheet */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "StyleSheet", function() { return StyleSheet; });
/*

Based off glamor's StyleSheet, thanks Sunil ❤️

high performance StyleSheet for css-in-js systems

- uses multiple style tags behind the scenes for millions of rules
- uses `insertRule` for appending in production for *much* faster performance

// usage

import { StyleSheet } from '@emotion/sheet'

let styleSheet = new StyleSheet({ key: '', container: document.head })

styleSheet.insert('#box { border: 1px solid red; }')
- appends a css rule into the stylesheet

styleSheet.flush()
- empties the stylesheet of all its contents

*/
// $FlowFixMe
function sheetForTag(tag) {
  if (tag.sheet) {
    // $FlowFixMe
    return tag.sheet;
  } // this weirdness brought to you by firefox

  /* istanbul ignore next */


  for (var i = 0; i < document.styleSheets.length; i++) {
    if (document.styleSheets[i].ownerNode === tag) {
      // $FlowFixMe
      return document.styleSheets[i];
    }
  }
}

function createStyleElement(options) {
  var tag = document.createElement('style');
  tag.setAttribute('data-emotion', options.key);

  if (options.nonce !== undefined) {
    tag.setAttribute('nonce', options.nonce);
  }

  tag.appendChild(document.createTextNode(''));
  return tag;
}

var StyleSheet =
/*#__PURE__*/
function () {
  function StyleSheet(options) {
    this.isSpeedy = options.speedy === undefined ? "development" === 'production' : options.speedy;
    this.tags = [];
    this.ctr = 0;
    this.nonce = options.nonce; // key is the value of the data-emotion attribute, it's used to identify different sheets

    this.key = options.key;
    this.container = options.container;
    this.before = null;
  }

  var _proto = StyleSheet.prototype;

  _proto.insert = function insert(rule) {
    // the max length is how many rules we have per style tag, it's 65000 in speedy mode
    // it's 1 in dev because we insert source maps that map a single rule to a location
    // and you can only have one source map per style tag
    if (this.ctr % (this.isSpeedy ? 65000 : 1) === 0) {
      var _tag = createStyleElement(this);

      var before;

      if (this.tags.length === 0) {
        before = this.before;
      } else {
        before = this.tags[this.tags.length - 1].nextSibling;
      }

      this.container.insertBefore(_tag, before);
      this.tags.push(_tag);
    }

    var tag = this.tags[this.tags.length - 1];

    if (this.isSpeedy) {
      var sheet = sheetForTag(tag);

      try {
        // this is a really hot path
        // we check the second character first because having "i"
        // as the second character will happen less often than
        // having "@" as the first character
        var isImportRule = rule.charCodeAt(1) === 105 && rule.charCodeAt(0) === 64; // this is the ultrafast version, works across browsers
        // the big drawback is that the css won't be editable in devtools

        sheet.insertRule(rule, // we need to insert @import rules before anything else
        // otherwise there will be an error
        // technically this means that the @import rules will
        // _usually_(not always since there could be multiple style tags)
        // be the first ones in prod and generally later in dev
        // this shouldn't really matter in the real world though
        // @import is generally only used for font faces from google fonts and etc.
        // so while this could be technically correct then it would be slower and larger
        // for a tiny bit of correctness that won't matter in the real world
        isImportRule ? 0 : sheet.cssRules.length);
      } catch (e) {
        if (true) {
          console.warn("There was a problem inserting the following rule: \"" + rule + "\"", e);
        }
      }
    } else {
      tag.appendChild(document.createTextNode(rule));
    }

    this.ctr++;
  };

  _proto.flush = function flush() {
    // $FlowFixMe
    this.tags.forEach(function (tag) {
      return tag.parentNode.removeChild(tag);
    });
    this.tags = [];
    this.ctr = 0;
  };

  return StyleSheet;
}();




/***/ }),

/***/ "./node_modules/@emotion/stylis/dist/stylis.browser.esm.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@emotion/stylis/dist/stylis.browser.esm.js ***!
  \*****************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function stylis_min (W) {
  function M(d, c, e, h, a) {
    for (var m = 0, b = 0, v = 0, n = 0, q, g, x = 0, K = 0, k, u = k = q = 0, l = 0, r = 0, I = 0, t = 0, B = e.length, J = B - 1, y, f = '', p = '', F = '', G = '', C; l < B;) {
      g = e.charCodeAt(l);
      l === J && 0 !== b + n + v + m && (0 !== b && (g = 47 === b ? 10 : 47), n = v = m = 0, B++, J++);

      if (0 === b + n + v + m) {
        if (l === J && (0 < r && (f = f.replace(N, '')), 0 < f.trim().length)) {
          switch (g) {
            case 32:
            case 9:
            case 59:
            case 13:
            case 10:
              break;

            default:
              f += e.charAt(l);
          }

          g = 59;
        }

        switch (g) {
          case 123:
            f = f.trim();
            q = f.charCodeAt(0);
            k = 1;

            for (t = ++l; l < B;) {
              switch (g = e.charCodeAt(l)) {
                case 123:
                  k++;
                  break;

                case 125:
                  k--;
                  break;

                case 47:
                  switch (g = e.charCodeAt(l + 1)) {
                    case 42:
                    case 47:
                      a: {
                        for (u = l + 1; u < J; ++u) {
                          switch (e.charCodeAt(u)) {
                            case 47:
                              if (42 === g && 42 === e.charCodeAt(u - 1) && l + 2 !== u) {
                                l = u + 1;
                                break a;
                              }

                              break;

                            case 10:
                              if (47 === g) {
                                l = u + 1;
                                break a;
                              }

                          }
                        }

                        l = u;
                      }

                  }

                  break;

                case 91:
                  g++;

                case 40:
                  g++;

                case 34:
                case 39:
                  for (; l++ < J && e.charCodeAt(l) !== g;) {
                  }

              }

              if (0 === k) break;
              l++;
            }

            k = e.substring(t, l);
            0 === q && (q = (f = f.replace(ca, '').trim()).charCodeAt(0));

            switch (q) {
              case 64:
                0 < r && (f = f.replace(N, ''));
                g = f.charCodeAt(1);

                switch (g) {
                  case 100:
                  case 109:
                  case 115:
                  case 45:
                    r = c;
                    break;

                  default:
                    r = O;
                }

                k = M(c, r, k, g, a + 1);
                t = k.length;
                0 < A && (r = X(O, f, I), C = H(3, k, r, c, D, z, t, g, a, h), f = r.join(''), void 0 !== C && 0 === (t = (k = C.trim()).length) && (g = 0, k = ''));
                if (0 < t) switch (g) {
                  case 115:
                    f = f.replace(da, ea);

                  case 100:
                  case 109:
                  case 45:
                    k = f + '{' + k + '}';
                    break;

                  case 107:
                    f = f.replace(fa, '$1 $2');
                    k = f + '{' + k + '}';
                    k = 1 === w || 2 === w && L('@' + k, 3) ? '@-webkit-' + k + '@' + k : '@' + k;
                    break;

                  default:
                    k = f + k, 112 === h && (k = (p += k, ''));
                } else k = '';
                break;

              default:
                k = M(c, X(c, f, I), k, h, a + 1);
            }

            F += k;
            k = I = r = u = q = 0;
            f = '';
            g = e.charCodeAt(++l);
            break;

          case 125:
          case 59:
            f = (0 < r ? f.replace(N, '') : f).trim();
            if (1 < (t = f.length)) switch (0 === u && (q = f.charCodeAt(0), 45 === q || 96 < q && 123 > q) && (t = (f = f.replace(' ', ':')).length), 0 < A && void 0 !== (C = H(1, f, c, d, D, z, p.length, h, a, h)) && 0 === (t = (f = C.trim()).length) && (f = '\x00\x00'), q = f.charCodeAt(0), g = f.charCodeAt(1), q) {
              case 0:
                break;

              case 64:
                if (105 === g || 99 === g) {
                  G += f + e.charAt(l);
                  break;
                }

              default:
                58 !== f.charCodeAt(t - 1) && (p += P(f, q, g, f.charCodeAt(2)));
            }
            I = r = u = q = 0;
            f = '';
            g = e.charCodeAt(++l);
        }
      }

      switch (g) {
        case 13:
        case 10:
          47 === b ? b = 0 : 0 === 1 + q && 107 !== h && 0 < f.length && (r = 1, f += '\x00');
          0 < A * Y && H(0, f, c, d, D, z, p.length, h, a, h);
          z = 1;
          D++;
          break;

        case 59:
        case 125:
          if (0 === b + n + v + m) {
            z++;
            break;
          }

        default:
          z++;
          y = e.charAt(l);

          switch (g) {
            case 9:
            case 32:
              if (0 === n + m + b) switch (x) {
                case 44:
                case 58:
                case 9:
                case 32:
                  y = '';
                  break;

                default:
                  32 !== g && (y = ' ');
              }
              break;

            case 0:
              y = '\\0';
              break;

            case 12:
              y = '\\f';
              break;

            case 11:
              y = '\\v';
              break;

            case 38:
              0 === n + b + m && (r = I = 1, y = '\f' + y);
              break;

            case 108:
              if (0 === n + b + m + E && 0 < u) switch (l - u) {
                case 2:
                  112 === x && 58 === e.charCodeAt(l - 3) && (E = x);

                case 8:
                  111 === K && (E = K);
              }
              break;

            case 58:
              0 === n + b + m && (u = l);
              break;

            case 44:
              0 === b + v + n + m && (r = 1, y += '\r');
              break;

            case 34:
            case 39:
              0 === b && (n = n === g ? 0 : 0 === n ? g : n);
              break;

            case 91:
              0 === n + b + v && m++;
              break;

            case 93:
              0 === n + b + v && m--;
              break;

            case 41:
              0 === n + b + m && v--;
              break;

            case 40:
              if (0 === n + b + m) {
                if (0 === q) switch (2 * x + 3 * K) {
                  case 533:
                    break;

                  default:
                    q = 1;
                }
                v++;
              }

              break;

            case 64:
              0 === b + v + n + m + u + k && (k = 1);
              break;

            case 42:
            case 47:
              if (!(0 < n + m + v)) switch (b) {
                case 0:
                  switch (2 * g + 3 * e.charCodeAt(l + 1)) {
                    case 235:
                      b = 47;
                      break;

                    case 220:
                      t = l, b = 42;
                  }

                  break;

                case 42:
                  47 === g && 42 === x && t + 2 !== l && (33 === e.charCodeAt(t + 2) && (p += e.substring(t, l + 1)), y = '', b = 0);
              }
          }

          0 === b && (f += y);
      }

      K = x;
      x = g;
      l++;
    }

    t = p.length;

    if (0 < t) {
      r = c;
      if (0 < A && (C = H(2, p, r, d, D, z, t, h, a, h), void 0 !== C && 0 === (p = C).length)) return G + p + F;
      p = r.join(',') + '{' + p + '}';

      if (0 !== w * E) {
        2 !== w || L(p, 2) || (E = 0);

        switch (E) {
          case 111:
            p = p.replace(ha, ':-moz-$1') + p;
            break;

          case 112:
            p = p.replace(Q, '::-webkit-input-$1') + p.replace(Q, '::-moz-$1') + p.replace(Q, ':-ms-input-$1') + p;
        }

        E = 0;
      }
    }

    return G + p + F;
  }

  function X(d, c, e) {
    var h = c.trim().split(ia);
    c = h;
    var a = h.length,
        m = d.length;

    switch (m) {
      case 0:
      case 1:
        var b = 0;

        for (d = 0 === m ? '' : d[0] + ' '; b < a; ++b) {
          c[b] = Z(d, c[b], e).trim();
        }

        break;

      default:
        var v = b = 0;

        for (c = []; b < a; ++b) {
          for (var n = 0; n < m; ++n) {
            c[v++] = Z(d[n] + ' ', h[b], e).trim();
          }
        }

    }

    return c;
  }

  function Z(d, c, e) {
    var h = c.charCodeAt(0);
    33 > h && (h = (c = c.trim()).charCodeAt(0));

    switch (h) {
      case 38:
        return c.replace(F, '$1' + d.trim());

      case 58:
        return d.trim() + c.replace(F, '$1' + d.trim());

      default:
        if (0 < 1 * e && 0 < c.indexOf('\f')) return c.replace(F, (58 === d.charCodeAt(0) ? '' : '$1') + d.trim());
    }

    return d + c;
  }

  function P(d, c, e, h) {
    var a = d + ';',
        m = 2 * c + 3 * e + 4 * h;

    if (944 === m) {
      d = a.indexOf(':', 9) + 1;
      var b = a.substring(d, a.length - 1).trim();
      b = a.substring(0, d).trim() + b + ';';
      return 1 === w || 2 === w && L(b, 1) ? '-webkit-' + b + b : b;
    }

    if (0 === w || 2 === w && !L(a, 1)) return a;

    switch (m) {
      case 1015:
        return 97 === a.charCodeAt(10) ? '-webkit-' + a + a : a;

      case 951:
        return 116 === a.charCodeAt(3) ? '-webkit-' + a + a : a;

      case 963:
        return 110 === a.charCodeAt(5) ? '-webkit-' + a + a : a;

      case 1009:
        if (100 !== a.charCodeAt(4)) break;

      case 969:
      case 942:
        return '-webkit-' + a + a;

      case 978:
        return '-webkit-' + a + '-moz-' + a + a;

      case 1019:
      case 983:
        return '-webkit-' + a + '-moz-' + a + '-ms-' + a + a;

      case 883:
        if (45 === a.charCodeAt(8)) return '-webkit-' + a + a;
        if (0 < a.indexOf('image-set(', 11)) return a.replace(ja, '$1-webkit-$2') + a;
        break;

      case 932:
        if (45 === a.charCodeAt(4)) switch (a.charCodeAt(5)) {
          case 103:
            return '-webkit-box-' + a.replace('-grow', '') + '-webkit-' + a + '-ms-' + a.replace('grow', 'positive') + a;

          case 115:
            return '-webkit-' + a + '-ms-' + a.replace('shrink', 'negative') + a;

          case 98:
            return '-webkit-' + a + '-ms-' + a.replace('basis', 'preferred-size') + a;
        }
        return '-webkit-' + a + '-ms-' + a + a;

      case 964:
        return '-webkit-' + a + '-ms-flex-' + a + a;

      case 1023:
        if (99 !== a.charCodeAt(8)) break;
        b = a.substring(a.indexOf(':', 15)).replace('flex-', '').replace('space-between', 'justify');
        return '-webkit-box-pack' + b + '-webkit-' + a + '-ms-flex-pack' + b + a;

      case 1005:
        return ka.test(a) ? a.replace(aa, ':-webkit-') + a.replace(aa, ':-moz-') + a : a;

      case 1e3:
        b = a.substring(13).trim();
        c = b.indexOf('-') + 1;

        switch (b.charCodeAt(0) + b.charCodeAt(c)) {
          case 226:
            b = a.replace(G, 'tb');
            break;

          case 232:
            b = a.replace(G, 'tb-rl');
            break;

          case 220:
            b = a.replace(G, 'lr');
            break;

          default:
            return a;
        }

        return '-webkit-' + a + '-ms-' + b + a;

      case 1017:
        if (-1 === a.indexOf('sticky', 9)) break;

      case 975:
        c = (a = d).length - 10;
        b = (33 === a.charCodeAt(c) ? a.substring(0, c) : a).substring(d.indexOf(':', 7) + 1).trim();

        switch (m = b.charCodeAt(0) + (b.charCodeAt(7) | 0)) {
          case 203:
            if (111 > b.charCodeAt(8)) break;

          case 115:
            a = a.replace(b, '-webkit-' + b) + ';' + a;
            break;

          case 207:
          case 102:
            a = a.replace(b, '-webkit-' + (102 < m ? 'inline-' : '') + 'box') + ';' + a.replace(b, '-webkit-' + b) + ';' + a.replace(b, '-ms-' + b + 'box') + ';' + a;
        }

        return a + ';';

      case 938:
        if (45 === a.charCodeAt(5)) switch (a.charCodeAt(6)) {
          case 105:
            return b = a.replace('-items', ''), '-webkit-' + a + '-webkit-box-' + b + '-ms-flex-' + b + a;

          case 115:
            return '-webkit-' + a + '-ms-flex-item-' + a.replace(ba, '') + a;

          default:
            return '-webkit-' + a + '-ms-flex-line-pack' + a.replace('align-content', '').replace(ba, '') + a;
        }
        break;

      case 973:
      case 989:
        if (45 !== a.charCodeAt(3) || 122 === a.charCodeAt(4)) break;

      case 931:
      case 953:
        if (!0 === la.test(d)) return 115 === (b = d.substring(d.indexOf(':') + 1)).charCodeAt(0) ? P(d.replace('stretch', 'fill-available'), c, e, h).replace(':fill-available', ':stretch') : a.replace(b, '-webkit-' + b) + a.replace(b, '-moz-' + b.replace('fill-', '')) + a;
        break;

      case 962:
        if (a = '-webkit-' + a + (102 === a.charCodeAt(5) ? '-ms-' + a : '') + a, 211 === e + h && 105 === a.charCodeAt(13) && 0 < a.indexOf('transform', 10)) return a.substring(0, a.indexOf(';', 27) + 1).replace(ma, '$1-webkit-$2') + a;
    }

    return a;
  }

  function L(d, c) {
    var e = d.indexOf(1 === c ? ':' : '{'),
        h = d.substring(0, 3 !== c ? e : 10);
    e = d.substring(e + 1, d.length - 1);
    return R(2 !== c ? h : h.replace(na, '$1'), e, c);
  }

  function ea(d, c) {
    var e = P(c, c.charCodeAt(0), c.charCodeAt(1), c.charCodeAt(2));
    return e !== c + ';' ? e.replace(oa, ' or ($1)').substring(4) : '(' + c + ')';
  }

  function H(d, c, e, h, a, m, b, v, n, q) {
    for (var g = 0, x = c, w; g < A; ++g) {
      switch (w = S[g].call(B, d, x, e, h, a, m, b, v, n, q)) {
        case void 0:
        case !1:
        case !0:
        case null:
          break;

        default:
          x = w;
      }
    }

    if (x !== c) return x;
  }

  function T(d) {
    switch (d) {
      case void 0:
      case null:
        A = S.length = 0;
        break;

      default:
        if ('function' === typeof d) S[A++] = d;else if ('object' === typeof d) for (var c = 0, e = d.length; c < e; ++c) {
          T(d[c]);
        } else Y = !!d | 0;
    }

    return T;
  }

  function U(d) {
    d = d.prefix;
    void 0 !== d && (R = null, d ? 'function' !== typeof d ? w = 1 : (w = 2, R = d) : w = 0);
    return U;
  }

  function B(d, c) {
    var e = d;
    33 > e.charCodeAt(0) && (e = e.trim());
    V = e;
    e = [V];

    if (0 < A) {
      var h = H(-1, c, e, e, D, z, 0, 0, 0, 0);
      void 0 !== h && 'string' === typeof h && (c = h);
    }

    var a = M(O, e, c, 0, 0);
    0 < A && (h = H(-2, a, e, e, D, z, a.length, 0, 0, 0), void 0 !== h && (a = h));
    V = '';
    E = 0;
    z = D = 1;
    return a;
  }

  var ca = /^\0+/g,
      N = /[\0\r\f]/g,
      aa = /: */g,
      ka = /zoo|gra/,
      ma = /([,: ])(transform)/g,
      ia = /,\r+?/g,
      F = /([\t\r\n ])*\f?&/g,
      fa = /@(k\w+)\s*(\S*)\s*/,
      Q = /::(place)/g,
      ha = /:(read-only)/g,
      G = /[svh]\w+-[tblr]{2}/,
      da = /\(\s*(.*)\s*\)/g,
      oa = /([\s\S]*?);/g,
      ba = /-self|flex-/g,
      na = /[^]*?(:[rp][el]a[\w-]+)[^]*/,
      la = /stretch|:\s*\w+\-(?:conte|avail)/,
      ja = /([^-])(image-set\()/,
      z = 1,
      D = 1,
      E = 0,
      w = 1,
      O = [],
      S = [],
      A = 0,
      R = null,
      Y = 0,
      V = '';
  B.use = T;
  B.set = U;
  void 0 !== W && U(W);
  return B;
}

/* harmony default export */ __webpack_exports__["default"] = (stylis_min);


/***/ }),

/***/ "./node_modules/@emotion/unitless/dist/unitless.browser.esm.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@emotion/unitless/dist/unitless.browser.esm.js ***!
  \*********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
var unitlessKeys = {
  animationIterationCount: 1,
  borderImageOutset: 1,
  borderImageSlice: 1,
  borderImageWidth: 1,
  boxFlex: 1,
  boxFlexGroup: 1,
  boxOrdinalGroup: 1,
  columnCount: 1,
  columns: 1,
  flex: 1,
  flexGrow: 1,
  flexPositive: 1,
  flexShrink: 1,
  flexNegative: 1,
  flexOrder: 1,
  gridRow: 1,
  gridRowEnd: 1,
  gridRowSpan: 1,
  gridRowStart: 1,
  gridColumn: 1,
  gridColumnEnd: 1,
  gridColumnSpan: 1,
  gridColumnStart: 1,
  msGridRow: 1,
  msGridRowSpan: 1,
  msGridColumn: 1,
  msGridColumnSpan: 1,
  fontWeight: 1,
  lineHeight: 1,
  opacity: 1,
  order: 1,
  orphans: 1,
  tabSize: 1,
  widows: 1,
  zIndex: 1,
  zoom: 1,
  WebkitLineClamp: 1,
  // SVG-related properties
  fillOpacity: 1,
  floodOpacity: 1,
  stopOpacity: 1,
  strokeDasharray: 1,
  strokeDashoffset: 1,
  strokeMiterlimit: 1,
  strokeOpacity: 1,
  strokeWidth: 1
};

/* harmony default export */ __webpack_exports__["default"] = (unitlessKeys);


/***/ }),

/***/ "./node_modules/@emotion/utils/dist/utils.browser.esm.js":
/*!***************************************************************!*\
  !*** ./node_modules/@emotion/utils/dist/utils.browser.esm.js ***!
  \***************************************************************/
/*! exports provided: getRegisteredStyles, insertStyles */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getRegisteredStyles", function() { return getRegisteredStyles; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "insertStyles", function() { return insertStyles; });
var isBrowser = "object" !== 'undefined';
function getRegisteredStyles(registered, registeredStyles, classNames) {
  var rawClassName = '';
  classNames.split(' ').forEach(function (className) {
    if (registered[className] !== undefined) {
      registeredStyles.push(registered[className]);
    } else {
      rawClassName += className + " ";
    }
  });
  return rawClassName;
}
var insertStyles = function insertStyles(cache, serialized, isStringTag) {
  var className = cache.key + "-" + serialized.name;

  if ( // we only need to add the styles to the registered cache if the
  // class name could be used further down
  // the tree but if it's a string tag, we know it won't
  // so we don't have to add it to registered cache.
  // this improves memory usage since we can avoid storing the whole style string
  (isStringTag === false || // we need to always store it if we're in compat mode and
  // in node since emotion-server relies on whether a style is in
  // the registered cache to know whether a style is global or not
  // also, note that this check will be dead code eliminated in the browser
  isBrowser === false && cache.compat !== undefined) && cache.registered[className] === undefined) {
    cache.registered[className] = serialized.styles;
  }

  if (cache.inserted[serialized.name] === undefined) {
    var current = serialized;

    do {
      var maybeStyles = cache.insert("." + className, current, cache.sheet, true);

      current = current.next;
    } while (current !== undefined);
  }
};




/***/ }),

/***/ "./node_modules/@emotion/weak-memoize/dist/weak-memoize.browser.esm.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@emotion/weak-memoize/dist/weak-memoize.browser.esm.js ***!
  \*****************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
var weakMemoize = function weakMemoize(func) {
  // $FlowFixMe flow doesn't include all non-primitive types as allowed for weakmaps
  var cache = new WeakMap();
  return function (arg) {
    if (cache.has(arg)) {
      // $FlowFixMe
      return cache.get(arg);
    }

    var ret = func(arg);
    cache.set(arg, ret);
    return ret;
  };
};

/* harmony default export */ __webpack_exports__["default"] = (weakMemoize);


/***/ }),

/***/ "./node_modules/@material-ui/core/colors/blue.js":
/*!*******************************************************!*\
  !*** ./node_modules/@material-ui/core/colors/blue.js ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var blue = {
  50: '#e3f2fd',
  100: '#bbdefb',
  200: '#90caf9',
  300: '#64b5f6',
  400: '#42a5f5',
  500: '#2196f3',
  600: '#1e88e5',
  700: '#1976d2',
  800: '#1565c0',
  900: '#0d47a1',
  A100: '#82b1ff',
  A200: '#448aff',
  A400: '#2979ff',
  A700: '#2962ff'
};
var _default = blue;
exports.default = _default;

/***/ }),

/***/ "./node_modules/@material-ui/core/colors/common.js":
/*!*********************************************************!*\
  !*** ./node_modules/@material-ui/core/colors/common.js ***!
  \*********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var common = {
  black: '#000',
  white: '#fff'
};
var _default = common;
exports.default = _default;

/***/ }),

/***/ "./node_modules/@material-ui/core/colors/green.js":
/*!********************************************************!*\
  !*** ./node_modules/@material-ui/core/colors/green.js ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var green = {
  50: '#e8f5e9',
  100: '#c8e6c9',
  200: '#a5d6a7',
  300: '#81c784',
  400: '#66bb6a',
  500: '#4caf50',
  600: '#43a047',
  700: '#388e3c',
  800: '#2e7d32',
  900: '#1b5e20',
  A100: '#b9f6ca',
  A200: '#69f0ae',
  A400: '#00e676',
  A700: '#00c853'
};
var _default = green;
exports.default = _default;

/***/ }),

/***/ "./node_modules/@material-ui/core/colors/grey.js":
/*!*******************************************************!*\
  !*** ./node_modules/@material-ui/core/colors/grey.js ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var grey = {
  50: '#fafafa',
  100: '#f5f5f5',
  200: '#eeeeee',
  300: '#e0e0e0',
  400: '#bdbdbd',
  500: '#9e9e9e',
  600: '#757575',
  700: '#616161',
  800: '#424242',
  900: '#212121',
  A100: '#d5d5d5',
  A200: '#aaaaaa',
  A400: '#303030',
  A700: '#616161'
};
var _default = grey;
exports.default = _default;

/***/ }),

/***/ "./node_modules/@material-ui/core/colors/indigo.js":
/*!*********************************************************!*\
  !*** ./node_modules/@material-ui/core/colors/indigo.js ***!
  \*********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var indigo = {
  50: '#e8eaf6',
  100: '#c5cae9',
  200: '#9fa8da',
  300: '#7986cb',
  400: '#5c6bc0',
  500: '#3f51b5',
  600: '#3949ab',
  700: '#303f9f',
  800: '#283593',
  900: '#1a237e',
  A100: '#8c9eff',
  A200: '#536dfe',
  A400: '#3d5afe',
  A700: '#304ffe'
};
var _default = indigo;
exports.default = _default;

/***/ }),

/***/ "./node_modules/@material-ui/core/colors/orange.js":
/*!*********************************************************!*\
  !*** ./node_modules/@material-ui/core/colors/orange.js ***!
  \*********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var orange = {
  50: '#fff3e0',
  100: '#ffe0b2',
  200: '#ffcc80',
  300: '#ffb74d',
  400: '#ffa726',
  500: '#ff9800',
  600: '#fb8c00',
  700: '#f57c00',
  800: '#ef6c00',
  900: '#e65100',
  A100: '#ffd180',
  A200: '#ffab40',
  A400: '#ff9100',
  A700: '#ff6d00'
};
var _default = orange;
exports.default = _default;

/***/ }),

/***/ "./node_modules/@material-ui/core/colors/pink.js":
/*!*******************************************************!*\
  !*** ./node_modules/@material-ui/core/colors/pink.js ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var pink = {
  50: '#fce4ec',
  100: '#f8bbd0',
  200: '#f48fb1',
  300: '#f06292',
  400: '#ec407a',
  500: '#e91e63',
  600: '#d81b60',
  700: '#c2185b',
  800: '#ad1457',
  900: '#880e4f',
  A100: '#ff80ab',
  A200: '#ff4081',
  A400: '#f50057',
  A700: '#c51162'
};
var _default = pink;
exports.default = _default;

/***/ }),

/***/ "./node_modules/@material-ui/core/colors/red.js":
/*!******************************************************!*\
  !*** ./node_modules/@material-ui/core/colors/red.js ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var red = {
  50: '#ffebee',
  100: '#ffcdd2',
  200: '#ef9a9a',
  300: '#e57373',
  400: '#ef5350',
  500: '#f44336',
  600: '#e53935',
  700: '#d32f2f',
  800: '#c62828',
  900: '#b71c1c',
  A100: '#ff8a80',
  A200: '#ff5252',
  A400: '#ff1744',
  A700: '#d50000'
};
var _default = red;
exports.default = _default;

/***/ }),

/***/ "./node_modules/@material-ui/core/esm/Accordion/Accordion.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/Accordion/Accordion.js ***!
  \*******************************************************************/
/*! exports provided: styles, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "styles", function() { return styles; });
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/esm/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_esm_toArray__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/esm/toArray */ "./node_modules/@babel/runtime/helpers/esm/toArray.js");
/* harmony import */ var _babel_runtime_helpers_esm_slicedToArray__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/esm/slicedToArray */ "./node_modules/@babel/runtime/helpers/esm/slicedToArray.js");
/* harmony import */ var _babel_runtime_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @babel/runtime/helpers/esm/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_is__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react-is */ "./node_modules/react-is/index.js");
/* harmony import */ var react_is__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_is__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var clsx__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! clsx */ "./node_modules/clsx/dist/clsx.m.js");
/* harmony import */ var _material_ui_utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @material-ui/utils */ "./node_modules/@material-ui/utils/esm/index.js");
/* harmony import */ var _Collapse__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../Collapse */ "./node_modules/@material-ui/core/esm/Collapse/index.js");
/* harmony import */ var _Paper__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../Paper */ "./node_modules/@material-ui/core/esm/Paper/index.js");
/* harmony import */ var _styles_withStyles__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../styles/withStyles */ "./node_modules/@material-ui/core/esm/styles/withStyles.js");
/* harmony import */ var _AccordionContext__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./AccordionContext */ "./node_modules/@material-ui/core/esm/Accordion/AccordionContext.js");
/* harmony import */ var _utils_useControlled__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../utils/useControlled */ "./node_modules/@material-ui/core/esm/utils/useControlled.js");














var styles = function styles(theme) {
  var transition = {
    duration: theme.transitions.duration.shortest
  };
  return {
    /* Styles applied to the root element. */
    root: {
      position: 'relative',
      transition: theme.transitions.create(['margin'], transition),
      '&:before': {
        position: 'absolute',
        left: 0,
        top: -1,
        right: 0,
        height: 1,
        content: '""',
        opacity: 1,
        backgroundColor: theme.palette.divider,
        transition: theme.transitions.create(['opacity', 'background-color'], transition)
      },
      '&:first-child': {
        '&:before': {
          display: 'none'
        }
      },
      '&$expanded': {
        margin: '16px 0',
        '&:first-child': {
          marginTop: 0
        },
        '&:last-child': {
          marginBottom: 0
        },
        '&:before': {
          opacity: 0
        }
      },
      '&$expanded + &': {
        '&:before': {
          display: 'none'
        }
      },
      '&$disabled': {
        backgroundColor: theme.palette.action.disabledBackground
      }
    },

    /* Styles applied to the root element if `square={false}`. */
    rounded: {
      borderRadius: 0,
      '&:first-child': {
        borderTopLeftRadius: theme.shape.borderRadius,
        borderTopRightRadius: theme.shape.borderRadius
      },
      '&:last-child': {
        borderBottomLeftRadius: theme.shape.borderRadius,
        borderBottomRightRadius: theme.shape.borderRadius,
        // Fix a rendering issue on Edge
        '@supports (-ms-ime-align: auto)': {
          borderBottomLeftRadius: 0,
          borderBottomRightRadius: 0
        }
      }
    },

    /* Styles applied to the root element if `expanded={true}`. */
    expanded: {},

    /* Styles applied to the root element if `disabled={true}`. */
    disabled: {}
  };
};
var Accordion = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4__["forwardRef"](function Accordion(props, ref) {
  var childrenProp = props.children,
      classes = props.classes,
      className = props.className,
      _props$defaultExpande = props.defaultExpanded,
      defaultExpanded = _props$defaultExpande === void 0 ? false : _props$defaultExpande,
      _props$disabled = props.disabled,
      disabled = _props$disabled === void 0 ? false : _props$disabled,
      expandedProp = props.expanded,
      onChange = props.onChange,
      _props$square = props.square,
      square = _props$square === void 0 ? false : _props$square,
      _props$TransitionComp = props.TransitionComponent,
      TransitionComponent = _props$TransitionComp === void 0 ? _Collapse__WEBPACK_IMPORTED_MODULE_9__["default"] : _props$TransitionComp,
      TransitionProps = props.TransitionProps,
      other = Object(_babel_runtime_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_3__["default"])(props, ["children", "classes", "className", "defaultExpanded", "disabled", "expanded", "onChange", "square", "TransitionComponent", "TransitionProps"]);

  var _useControlled = Object(_utils_useControlled__WEBPACK_IMPORTED_MODULE_13__["default"])({
    controlled: expandedProp,
    default: defaultExpanded,
    name: 'Accordion',
    state: 'expanded'
  }),
      _useControlled2 = Object(_babel_runtime_helpers_esm_slicedToArray__WEBPACK_IMPORTED_MODULE_2__["default"])(_useControlled, 2),
      expanded = _useControlled2[0],
      setExpandedState = _useControlled2[1];

  var handleChange = react__WEBPACK_IMPORTED_MODULE_4__["useCallback"](function (event) {
    setExpandedState(!expanded);

    if (onChange) {
      onChange(event, !expanded);
    }
  }, [expanded, onChange, setExpandedState]);

  var _React$Children$toArr = react__WEBPACK_IMPORTED_MODULE_4__["Children"].toArray(childrenProp),
      _React$Children$toArr2 = Object(_babel_runtime_helpers_esm_toArray__WEBPACK_IMPORTED_MODULE_1__["default"])(_React$Children$toArr),
      summary = _React$Children$toArr2[0],
      children = _React$Children$toArr2.slice(1);

  var contextValue = react__WEBPACK_IMPORTED_MODULE_4__["useMemo"](function () {
    return {
      expanded: expanded,
      disabled: disabled,
      toggle: handleChange
    };
  }, [expanded, disabled, handleChange]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4__["createElement"](_Paper__WEBPACK_IMPORTED_MODULE_10__["default"], Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    className: Object(clsx__WEBPACK_IMPORTED_MODULE_7__["default"])(classes.root, className, expanded && classes.expanded, disabled && classes.disabled, !square && classes.rounded),
    ref: ref,
    square: square
  }, other), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4__["createElement"](_AccordionContext__WEBPACK_IMPORTED_MODULE_12__["default"].Provider, {
    value: contextValue
  }, summary), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4__["createElement"](TransitionComponent, Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    in: expanded,
    timeout: "auto"
  }, TransitionProps), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4__["createElement"]("div", {
    "aria-labelledby": summary.props.id,
    id: summary.props['aria-controls'],
    role: "region"
  }, children)));
});
 true ? Accordion.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * The content of the accordion.
   */
  children: Object(_material_ui_utils__WEBPACK_IMPORTED_MODULE_8__["chainPropTypes"])(prop_types__WEBPACK_IMPORTED_MODULE_6___default.a.node.isRequired, function (props) {
    var summary = react__WEBPACK_IMPORTED_MODULE_4__["Children"].toArray(props.children)[0];

    if (Object(react_is__WEBPACK_IMPORTED_MODULE_5__["isFragment"])(summary)) {
      return new Error("Material-UI: The Accordion doesn't accept a Fragment as a child. " + 'Consider providing an array instead.');
    }

    if (! /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4__["isValidElement"](summary)) {
      return new Error('Material-UI: Expected the first child of Accordion to be a valid element.');
    }

    return null;
  }),

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: prop_types__WEBPACK_IMPORTED_MODULE_6___default.a.object,

  /**
   * @ignore
   */
  className: prop_types__WEBPACK_IMPORTED_MODULE_6___default.a.string,

  /**
   * If `true`, expands the accordion by default.
   */
  defaultExpanded: prop_types__WEBPACK_IMPORTED_MODULE_6___default.a.bool,

  /**
   * If `true`, the accordion will be displayed in a disabled state.
   */
  disabled: prop_types__WEBPACK_IMPORTED_MODULE_6___default.a.bool,

  /**
   * If `true`, expands the accordion, otherwise collapse it.
   * Setting this prop enables control over the accordion.
   */
  expanded: prop_types__WEBPACK_IMPORTED_MODULE_6___default.a.bool,

  /**
   * Callback fired when the expand/collapse state is changed.
   *
   * @param {object} event The event source of the callback.
   * @param {boolean} expanded The `expanded` state of the accordion.
   */
  onChange: prop_types__WEBPACK_IMPORTED_MODULE_6___default.a.func,

  /**
   * If `true`, rounded corners are disabled.
   */
  square: prop_types__WEBPACK_IMPORTED_MODULE_6___default.a.bool,

  /**
   * The component used for the collapse effect.
   * [Follow this guide](/components/transitions/#transitioncomponent-prop) to learn more about the requirements for this component.
   */
  TransitionComponent: prop_types__WEBPACK_IMPORTED_MODULE_6___default.a.elementType,

  /**
   * Props applied to the [`Transition`](http://reactcommunity.org/react-transition-group/transition#Transition-props) element.
   */
  TransitionProps: prop_types__WEBPACK_IMPORTED_MODULE_6___default.a.object
} : undefined;
/* harmony default export */ __webpack_exports__["default"] = (Object(_styles_withStyles__WEBPACK_IMPORTED_MODULE_11__["default"])(styles, {
  name: 'MuiAccordion'
})(Accordion));

/***/ }),

/***/ "./node_modules/@material-ui/core/esm/Accordion/AccordionContext.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/Accordion/AccordionContext.js ***!
  \**************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

/**
 * @ignore - internal component.
 * @type {React.Context<{} | {expanded: boolean, disabled: boolean, toggle: () => void}>}
 */

var AccordionContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__["createContext"]({});

if (true) {
  AccordionContext.displayName = 'AccordionContext';
}

/* harmony default export */ __webpack_exports__["default"] = (AccordionContext);

/***/ }),

/***/ "./node_modules/@material-ui/core/esm/Accordion/index.js":
/*!***************************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/Accordion/index.js ***!
  \***************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Accordion__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Accordion */ "./node_modules/@material-ui/core/esm/Accordion/Accordion.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _Accordion__WEBPACK_IMPORTED_MODULE_0__["default"]; });



/***/ }),

/***/ "./node_modules/@material-ui/core/esm/AccordionActions/AccordionActions.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/AccordionActions/AccordionActions.js ***!
  \*********************************************************************************/
/*! exports provided: styles, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "styles", function() { return styles; });
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/esm/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/esm/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var clsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! clsx */ "./node_modules/clsx/dist/clsx.m.js");
/* harmony import */ var _styles_withStyles__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../styles/withStyles */ "./node_modules/@material-ui/core/esm/styles/withStyles.js");






var styles = {
  /* Styles applied to the root element. */
  root: {
    display: 'flex',
    alignItems: 'center',
    padding: 8,
    justifyContent: 'flex-end'
  },

  /* Styles applied to the root element if `disableSpacing={false}`. */
  spacing: {
    '& > :not(:first-child)': {
      marginLeft: 8
    }
  }
};
var AccordionActions = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["forwardRef"](function AccordionActions(props, ref) {
  var classes = props.classes,
      className = props.className,
      _props$disableSpacing = props.disableSpacing,
      disableSpacing = _props$disableSpacing === void 0 ? false : _props$disableSpacing,
      other = Object(_babel_runtime_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(props, ["classes", "className", "disableSpacing"]);

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["createElement"]("div", Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    className: Object(clsx__WEBPACK_IMPORTED_MODULE_4__["default"])(classes.root, className, !disableSpacing && classes.spacing),
    ref: ref
  }, other));
});
 true ? AccordionActions.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * The content of the component.
   */
  children: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.node,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.object,

  /**
   * @ignore
   */
  className: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.string,

  /**
   * If `true`, the actions do not have additional margin.
   */
  disableSpacing: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.bool
} : undefined;
/* harmony default export */ __webpack_exports__["default"] = (Object(_styles_withStyles__WEBPACK_IMPORTED_MODULE_5__["default"])(styles, {
  name: 'MuiAccordionActions'
})(AccordionActions));

/***/ }),

/***/ "./node_modules/@material-ui/core/esm/AccordionActions/index.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/AccordionActions/index.js ***!
  \**********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _AccordionActions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AccordionActions */ "./node_modules/@material-ui/core/esm/AccordionActions/AccordionActions.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _AccordionActions__WEBPACK_IMPORTED_MODULE_0__["default"]; });



/***/ }),

/***/ "./node_modules/@material-ui/core/esm/AccordionDetails/AccordionDetails.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/AccordionDetails/AccordionDetails.js ***!
  \*********************************************************************************/
/*! exports provided: styles, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "styles", function() { return styles; });
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/esm/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/esm/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var clsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! clsx */ "./node_modules/clsx/dist/clsx.m.js");
/* harmony import */ var _styles_withStyles__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../styles/withStyles */ "./node_modules/@material-ui/core/esm/styles/withStyles.js");






var styles = function styles(theme) {
  return {
    /* Styles applied to the root element. */
    root: {
      display: 'flex',
      padding: theme.spacing(1, 2, 2)
    }
  };
};
var AccordionDetails = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["forwardRef"](function AccordionDetails(props, ref) {
  var classes = props.classes,
      className = props.className,
      other = Object(_babel_runtime_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(props, ["classes", "className"]);

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["createElement"]("div", Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    className: Object(clsx__WEBPACK_IMPORTED_MODULE_4__["default"])(classes.root, className),
    ref: ref
  }, other));
});
 true ? AccordionDetails.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * The content of the accordion details.
   */
  children: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.node,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.object,

  /**
   * @ignore
   */
  className: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.string
} : undefined;
/* harmony default export */ __webpack_exports__["default"] = (Object(_styles_withStyles__WEBPACK_IMPORTED_MODULE_5__["default"])(styles, {
  name: 'MuiAccordionDetails'
})(AccordionDetails));

/***/ }),

/***/ "./node_modules/@material-ui/core/esm/AccordionDetails/index.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/AccordionDetails/index.js ***!
  \**********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _AccordionDetails__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AccordionDetails */ "./node_modules/@material-ui/core/esm/AccordionDetails/AccordionDetails.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _AccordionDetails__WEBPACK_IMPORTED_MODULE_0__["default"]; });



/***/ }),

/***/ "./node_modules/@material-ui/core/esm/AccordionSummary/AccordionSummary.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/AccordionSummary/AccordionSummary.js ***!
  \*********************************************************************************/
/*! exports provided: styles, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "styles", function() { return styles; });
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/esm/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/esm/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var clsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! clsx */ "./node_modules/clsx/dist/clsx.m.js");
/* harmony import */ var _ButtonBase__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../ButtonBase */ "./node_modules/@material-ui/core/esm/ButtonBase/index.js");
/* harmony import */ var _IconButton__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../IconButton */ "./node_modules/@material-ui/core/esm/IconButton/index.js");
/* harmony import */ var _styles_withStyles__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../styles/withStyles */ "./node_modules/@material-ui/core/esm/styles/withStyles.js");
/* harmony import */ var _Accordion_AccordionContext__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../Accordion/AccordionContext */ "./node_modules/@material-ui/core/esm/Accordion/AccordionContext.js");



/* eslint-disable jsx-a11y/aria-role */







var styles = function styles(theme) {
  var transition = {
    duration: theme.transitions.duration.shortest
  };
  return {
    /* Styles applied to the root element. */
    root: {
      display: 'flex',
      minHeight: 8 * 6,
      transition: theme.transitions.create(['min-height', 'background-color'], transition),
      padding: theme.spacing(0, 2),
      '&:hover:not($disabled)': {
        cursor: 'pointer'
      },
      '&$expanded': {
        minHeight: 64
      },
      '&$focused': {
        backgroundColor: theme.palette.action.focus
      },
      '&$disabled': {
        opacity: theme.palette.action.disabledOpacity
      }
    },

    /* Pseudo-class applied to the root element, children wrapper element and `IconButton` component if `expanded={true}`. */
    expanded: {},

    /* Pseudo-class applied to the root element if `focused={true}`. */
    focused: {},

    /* Pseudo-class applied to the root element if `disabled={true}`. */
    disabled: {},

    /* Styles applied to the children wrapper element. */
    content: {
      display: 'flex',
      flexGrow: 1,
      transition: theme.transitions.create(['margin'], transition),
      margin: '12px 0',
      '&$expanded': {
        margin: '20px 0'
      }
    },

    /* Styles applied to the `IconButton` component when `expandIcon` is supplied. */
    expandIcon: {
      transform: 'rotate(0deg)',
      transition: theme.transitions.create('transform', transition),
      '&:hover': {
        // Disable the hover effect for the IconButton,
        // because a hover effect should apply to the entire Expand button and
        // not only to the IconButton.
        backgroundColor: 'transparent'
      },
      '&$expanded': {
        transform: 'rotate(180deg)'
      }
    }
  };
};
var AccordionSummary = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["forwardRef"](function AccordionSummary(props, ref) {
  var children = props.children,
      classes = props.classes,
      className = props.className,
      expandIcon = props.expandIcon,
      IconButtonProps = props.IconButtonProps,
      onBlur = props.onBlur,
      onClick = props.onClick,
      onFocusVisible = props.onFocusVisible,
      other = Object(_babel_runtime_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(props, ["children", "classes", "className", "expandIcon", "IconButtonProps", "onBlur", "onClick", "onFocusVisible"]);

  var _React$useState = react__WEBPACK_IMPORTED_MODULE_2__["useState"](false),
      focusedState = _React$useState[0],
      setFocusedState = _React$useState[1];

  var handleFocusVisible = function handleFocusVisible(event) {
    setFocusedState(true);

    if (onFocusVisible) {
      onFocusVisible(event);
    }
  };

  var handleBlur = function handleBlur(event) {
    setFocusedState(false);

    if (onBlur) {
      onBlur(event);
    }
  };

  var _React$useContext = react__WEBPACK_IMPORTED_MODULE_2__["useContext"](_Accordion_AccordionContext__WEBPACK_IMPORTED_MODULE_8__["default"]),
      _React$useContext$dis = _React$useContext.disabled,
      disabled = _React$useContext$dis === void 0 ? false : _React$useContext$dis,
      expanded = _React$useContext.expanded,
      toggle = _React$useContext.toggle;

  var handleChange = function handleChange(event) {
    if (toggle) {
      toggle(event);
    }

    if (onClick) {
      onClick(event);
    }
  };

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["createElement"](_ButtonBase__WEBPACK_IMPORTED_MODULE_5__["default"], Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    focusRipple: false,
    disableRipple: true,
    disabled: disabled,
    component: "div",
    "aria-expanded": expanded,
    className: Object(clsx__WEBPACK_IMPORTED_MODULE_4__["default"])(classes.root, className, disabled && classes.disabled, expanded && classes.expanded, focusedState && classes.focused),
    onFocusVisible: handleFocusVisible,
    onBlur: handleBlur,
    onClick: handleChange,
    ref: ref
  }, other), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["createElement"]("div", {
    className: Object(clsx__WEBPACK_IMPORTED_MODULE_4__["default"])(classes.content, expanded && classes.expanded)
  }, children), expandIcon && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["createElement"](_IconButton__WEBPACK_IMPORTED_MODULE_6__["default"], Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    className: Object(clsx__WEBPACK_IMPORTED_MODULE_4__["default"])(classes.expandIcon, expanded && classes.expanded),
    edge: "end",
    component: "div",
    tabIndex: null,
    role: null,
    "aria-hidden": true
  }, IconButtonProps), expandIcon));
});
 true ? AccordionSummary.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * The content of the accordion summary.
   */
  children: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.node,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.object,

  /**
   * @ignore
   */
  className: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.string,

  /**
   * The icon to display as the expand indicator.
   */
  expandIcon: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.node,

  /**
   * Props applied to the `IconButton` element wrapping the expand icon.
   */
  IconButtonProps: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.object,

  /**
   * @ignore
   */
  onBlur: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.func,

  /**
   * @ignore
   */
  onClick: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.func,

  /**
   * @ignore
   */
  onFocusVisible: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.func
} : undefined;
/* harmony default export */ __webpack_exports__["default"] = (Object(_styles_withStyles__WEBPACK_IMPORTED_MODULE_7__["default"])(styles, {
  name: 'MuiAccordionSummary'
})(AccordionSummary));

/***/ }),

/***/ "./node_modules/@material-ui/core/esm/AccordionSummary/index.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/AccordionSummary/index.js ***!
  \**********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _AccordionSummary__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AccordionSummary */ "./node_modules/@material-ui/core/esm/AccordionSummary/AccordionSummary.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _AccordionSummary__WEBPACK_IMPORTED_MODULE_0__["default"]; });



/***/ }),

/***/ "./node_modules/@material-ui/core/esm/AppBar/AppBar.js":
/*!*************************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/AppBar/AppBar.js ***!
  \*************************************************************/
/*! exports provided: styles, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "styles", function() { return styles; });
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/esm/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/esm/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var clsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! clsx */ "./node_modules/clsx/dist/clsx.m.js");
/* harmony import */ var _styles_withStyles__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../styles/withStyles */ "./node_modules/@material-ui/core/esm/styles/withStyles.js");
/* harmony import */ var _utils_capitalize__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/capitalize */ "./node_modules/@material-ui/core/esm/utils/capitalize.js");
/* harmony import */ var _Paper__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Paper */ "./node_modules/@material-ui/core/esm/Paper/index.js");








var styles = function styles(theme) {
  var backgroundColorDefault = theme.palette.type === 'light' ? theme.palette.grey[100] : theme.palette.grey[900];
  return {
    /* Styles applied to the root element. */
    root: {
      display: 'flex',
      flexDirection: 'column',
      width: '100%',
      boxSizing: 'border-box',
      // Prevent padding issue with the Modal and fixed positioned AppBar.
      zIndex: theme.zIndex.appBar,
      flexShrink: 0
    },

    /* Styles applied to the root element if `position="fixed"`. */
    positionFixed: {
      position: 'fixed',
      top: 0,
      left: 'auto',
      right: 0,
      '@media print': {
        // Prevent the app bar to be visible on each printed page.
        position: 'absolute'
      }
    },

    /* Styles applied to the root element if `position="absolute"`. */
    positionAbsolute: {
      position: 'absolute',
      top: 0,
      left: 'auto',
      right: 0
    },

    /* Styles applied to the root element if `position="sticky"`. */
    positionSticky: {
      // ⚠️ sticky is not supported by IE 11.
      position: 'sticky',
      top: 0,
      left: 'auto',
      right: 0
    },

    /* Styles applied to the root element if `position="static"`. */
    positionStatic: {
      position: 'static'
    },

    /* Styles applied to the root element if `position="relative"`. */
    positionRelative: {
      position: 'relative'
    },

    /* Styles applied to the root element if `color="default"`. */
    colorDefault: {
      backgroundColor: backgroundColorDefault,
      color: theme.palette.getContrastText(backgroundColorDefault)
    },

    /* Styles applied to the root element if `color="primary"`. */
    colorPrimary: {
      backgroundColor: theme.palette.primary.main,
      color: theme.palette.primary.contrastText
    },

    /* Styles applied to the root element if `color="secondary"`. */
    colorSecondary: {
      backgroundColor: theme.palette.secondary.main,
      color: theme.palette.secondary.contrastText
    },

    /* Styles applied to the root element if `color="inherit"`. */
    colorInherit: {
      color: 'inherit'
    },

    /* Styles applied to the root element if `color="transparent"`. */
    colorTransparent: {
      backgroundColor: 'transparent',
      color: 'inherit'
    }
  };
};
var AppBar = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["forwardRef"](function AppBar(props, ref) {
  var classes = props.classes,
      className = props.className,
      _props$color = props.color,
      color = _props$color === void 0 ? 'primary' : _props$color,
      _props$position = props.position,
      position = _props$position === void 0 ? 'fixed' : _props$position,
      other = Object(_babel_runtime_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(props, ["classes", "className", "color", "position"]);

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["createElement"](_Paper__WEBPACK_IMPORTED_MODULE_7__["default"], Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    square: true,
    component: "header",
    elevation: 4,
    className: Object(clsx__WEBPACK_IMPORTED_MODULE_4__["default"])(classes.root, classes["position".concat(Object(_utils_capitalize__WEBPACK_IMPORTED_MODULE_6__["default"])(position))], classes["color".concat(Object(_utils_capitalize__WEBPACK_IMPORTED_MODULE_6__["default"])(color))], className, position === 'fixed' && 'mui-fixed'),
    ref: ref
  }, other));
});
 true ? AppBar.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * The content of the component.
   */
  children: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.node,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.object,

  /**
   * @ignore
   */
  className: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.string,

  /**
   * The color of the component. It supports those theme colors that make sense for this component.
   */
  color: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.oneOf(['default', 'inherit', 'primary', 'secondary', 'transparent']),

  /**
   * The positioning type. The behavior of the different options is described
   * [in the MDN web docs](https://developer.mozilla.org/en-US/docs/Learn/CSS/CSS_layout/Positioning).
   * Note: `sticky` is not universally supported and will fall back to `static` when unavailable.
   */
  position: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.oneOf(['absolute', 'fixed', 'relative', 'static', 'sticky'])
} : undefined;
/* harmony default export */ __webpack_exports__["default"] = (Object(_styles_withStyles__WEBPACK_IMPORTED_MODULE_5__["default"])(styles, {
  name: 'MuiAppBar'
})(AppBar));

/***/ }),

/***/ "./node_modules/@material-ui/core/esm/AppBar/index.js":
/*!************************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/AppBar/index.js ***!
  \************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _AppBar__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AppBar */ "./node_modules/@material-ui/core/esm/AppBar/AppBar.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _AppBar__WEBPACK_IMPORTED_MODULE_0__["default"]; });



/***/ }),

/***/ "./node_modules/@material-ui/core/esm/Avatar/Avatar.js":
/*!*************************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/Avatar/Avatar.js ***!
  \*************************************************************/
/*! exports provided: styles, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "styles", function() { return styles; });
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/esm/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/esm/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var clsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! clsx */ "./node_modules/clsx/dist/clsx.m.js");
/* harmony import */ var _styles_withStyles__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../styles/withStyles */ "./node_modules/@material-ui/core/esm/styles/withStyles.js");
/* harmony import */ var _internal_svg_icons_Person__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../internal/svg-icons/Person */ "./node_modules/@material-ui/core/esm/internal/svg-icons/Person.js");







var styles = function styles(theme) {
  return {
    /* Styles applied to the root element. */
    root: {
      position: 'relative',
      display: 'flex',
      alignItems: 'center',
      justifyContent: 'center',
      flexShrink: 0,
      width: 40,
      height: 40,
      fontFamily: theme.typography.fontFamily,
      fontSize: theme.typography.pxToRem(20),
      lineHeight: 1,
      borderRadius: '50%',
      overflow: 'hidden',
      userSelect: 'none'
    },

    /* Styles applied to the root element if not `src` or `srcSet`. */
    colorDefault: {
      color: theme.palette.background.default,
      backgroundColor: theme.palette.type === 'light' ? theme.palette.grey[400] : theme.palette.grey[600]
    },

    /* Styles applied to the root element if `variant="circle"`. */
    circle: {},

    /* Styles applied to the root element if `variant="rounded"`. */
    rounded: {
      borderRadius: theme.shape.borderRadius
    },

    /* Styles applied to the root element if `variant="square"`. */
    square: {
      borderRadius: 0
    },

    /* Styles applied to the img element if either `src` or `srcSet` is defined. */
    img: {
      width: '100%',
      height: '100%',
      textAlign: 'center',
      // Handle non-square image. The property isn't supported by IE 11.
      objectFit: 'cover',
      // Hide alt text.
      color: 'transparent',
      // Hide the image broken icon, only works on Chrome.
      textIndent: 10000
    },

    /* Styles applied to the fallback icon */
    fallback: {
      width: '75%',
      height: '75%'
    }
  };
};

function useLoaded(_ref) {
  var src = _ref.src,
      srcSet = _ref.srcSet;

  var _React$useState = react__WEBPACK_IMPORTED_MODULE_2__["useState"](false),
      loaded = _React$useState[0],
      setLoaded = _React$useState[1];

  react__WEBPACK_IMPORTED_MODULE_2__["useEffect"](function () {
    if (!src && !srcSet) {
      return undefined;
    }

    setLoaded(false);
    var active = true;
    var image = new Image();
    image.src = src;
    image.srcSet = srcSet;

    image.onload = function () {
      if (!active) {
        return;
      }

      setLoaded('loaded');
    };

    image.onerror = function () {
      if (!active) {
        return;
      }

      setLoaded('error');
    };

    return function () {
      active = false;
    };
  }, [src, srcSet]);
  return loaded;
}

var Avatar = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["forwardRef"](function Avatar(props, ref) {
  var alt = props.alt,
      childrenProp = props.children,
      classes = props.classes,
      className = props.className,
      _props$component = props.component,
      Component = _props$component === void 0 ? 'div' : _props$component,
      imgProps = props.imgProps,
      sizes = props.sizes,
      src = props.src,
      srcSet = props.srcSet,
      _props$variant = props.variant,
      variant = _props$variant === void 0 ? 'circle' : _props$variant,
      other = Object(_babel_runtime_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(props, ["alt", "children", "classes", "className", "component", "imgProps", "sizes", "src", "srcSet", "variant"]);

  var children = null; // Use a hook instead of onError on the img element to support server-side rendering.

  var loaded = useLoaded({
    src: src,
    srcSet: srcSet
  });
  var hasImg = src || srcSet;
  var hasImgNotFailing = hasImg && loaded !== 'error';

  if (hasImgNotFailing) {
    children = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["createElement"]("img", Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
      alt: alt,
      src: src,
      srcSet: srcSet,
      sizes: sizes,
      className: classes.img
    }, imgProps));
  } else if (childrenProp != null) {
    children = childrenProp;
  } else if (hasImg && alt) {
    children = alt[0];
  } else {
    children = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["createElement"](_internal_svg_icons_Person__WEBPACK_IMPORTED_MODULE_6__["default"], {
      className: classes.fallback
    });
  }

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["createElement"](Component, Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    className: Object(clsx__WEBPACK_IMPORTED_MODULE_4__["default"])(classes.root, classes.system, classes[variant], className, !hasImgNotFailing && classes.colorDefault),
    ref: ref
  }, other), children);
});
 true ? Avatar.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * Used in combination with `src` or `srcSet` to
   * provide an alt attribute for the rendered `img` element.
   */
  alt: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.string,

  /**
   * Used to render icon or text elements inside the Avatar if `src` is not set.
   * This can be an element, or just a string.
   */
  children: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.node,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.object,

  /**
   * @ignore
   */
  className: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.string,

  /**
   * The component used for the root node.
   * Either a string to use a HTML element or a component.
   */
  component: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a
  /* @typescript-to-proptypes-ignore */
  .elementType,

  /**
   * Attributes applied to the `img` element if the component is used to display an image.
   * It can be used to listen for the loading error event.
   */
  imgProps: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.object,

  /**
   * The `sizes` attribute for the `img` element.
   */
  sizes: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.string,

  /**
   * The `src` attribute for the `img` element.
   */
  src: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.string,

  /**
   * The `srcSet` attribute for the `img` element.
   * Use this attribute for responsive image display.
   */
  srcSet: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.string,

  /**
   * The shape of the avatar.
   */
  variant: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.oneOf(['circle', 'rounded', 'square'])
} : undefined;
/* harmony default export */ __webpack_exports__["default"] = (Object(_styles_withStyles__WEBPACK_IMPORTED_MODULE_5__["default"])(styles, {
  name: 'MuiAvatar'
})(Avatar));

/***/ }),

/***/ "./node_modules/@material-ui/core/esm/Avatar/index.js":
/*!************************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/Avatar/index.js ***!
  \************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Avatar__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Avatar */ "./node_modules/@material-ui/core/esm/Avatar/Avatar.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _Avatar__WEBPACK_IMPORTED_MODULE_0__["default"]; });



/***/ }),

/***/ "./node_modules/@material-ui/core/esm/Backdrop/Backdrop.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/Backdrop/Backdrop.js ***!
  \*****************************************************************/
/*! exports provided: styles, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "styles", function() { return styles; });
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/esm/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/esm/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var clsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! clsx */ "./node_modules/clsx/dist/clsx.m.js");
/* harmony import */ var _styles_withStyles__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../styles/withStyles */ "./node_modules/@material-ui/core/esm/styles/withStyles.js");
/* harmony import */ var _Fade__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Fade */ "./node_modules/@material-ui/core/esm/Fade/index.js");







var styles = {
  /* Styles applied to the root element. */
  root: {
    // Improve scrollable dialog support.
    zIndex: -1,
    position: 'fixed',
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    right: 0,
    bottom: 0,
    top: 0,
    left: 0,
    backgroundColor: 'rgba(0, 0, 0, 0.5)',
    WebkitTapHighlightColor: 'transparent'
  },

  /* Styles applied to the root element if `invisible={true}`. */
  invisible: {
    backgroundColor: 'transparent'
  }
};
var Backdrop = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["forwardRef"](function Backdrop(props, ref) {
  var children = props.children,
      classes = props.classes,
      className = props.className,
      _props$invisible = props.invisible,
      invisible = _props$invisible === void 0 ? false : _props$invisible,
      open = props.open,
      transitionDuration = props.transitionDuration,
      _props$TransitionComp = props.TransitionComponent,
      TransitionComponent = _props$TransitionComp === void 0 ? _Fade__WEBPACK_IMPORTED_MODULE_6__["default"] : _props$TransitionComp,
      other = Object(_babel_runtime_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(props, ["children", "classes", "className", "invisible", "open", "transitionDuration", "TransitionComponent"]);

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["createElement"](TransitionComponent, Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    in: open,
    timeout: transitionDuration
  }, other), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["createElement"]("div", {
    className: Object(clsx__WEBPACK_IMPORTED_MODULE_4__["default"])(classes.root, className, invisible && classes.invisible),
    "aria-hidden": true,
    ref: ref
  }, children));
});
 true ? Backdrop.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * The content of the component.
   */
  children: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.node,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.object,

  /**
   * @ignore
   */
  className: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.string,

  /**
   * If `true`, the backdrop is invisible.
   * It can be used when rendering a popover or a custom select component.
   */
  invisible: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.bool,

  /**
   * If `true`, the backdrop is open.
   */
  open: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.bool.isRequired,

  /**
   * The duration for the transition, in milliseconds.
   * You may specify a single timeout for all transitions, or individually with an object.
   */
  transitionDuration: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.number, prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.shape({
    appear: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.number,
    enter: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.number,
    exit: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.number
  })])
} : undefined;
/* harmony default export */ __webpack_exports__["default"] = (Object(_styles_withStyles__WEBPACK_IMPORTED_MODULE_5__["default"])(styles, {
  name: 'MuiBackdrop'
})(Backdrop));

/***/ }),

/***/ "./node_modules/@material-ui/core/esm/Backdrop/index.js":
/*!**************************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/Backdrop/index.js ***!
  \**************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Backdrop__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Backdrop */ "./node_modules/@material-ui/core/esm/Backdrop/Backdrop.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _Backdrop__WEBPACK_IMPORTED_MODULE_0__["default"]; });



/***/ }),

/***/ "./node_modules/@material-ui/core/esm/Badge/Badge.js":
/*!***********************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/Badge/Badge.js ***!
  \***********************************************************/
/*! exports provided: styles, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "styles", function() { return styles; });
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/esm/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/esm/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var clsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! clsx */ "./node_modules/clsx/dist/clsx.m.js");
/* harmony import */ var _styles_withStyles__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../styles/withStyles */ "./node_modules/@material-ui/core/esm/styles/withStyles.js");
/* harmony import */ var _utils_capitalize__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/capitalize */ "./node_modules/@material-ui/core/esm/utils/capitalize.js");







var RADIUS_STANDARD = 10;
var RADIUS_DOT = 4;
var styles = function styles(theme) {
  return {
    /* Styles applied to the root element. */
    root: {
      position: 'relative',
      display: 'inline-flex',
      // For correct alignment with the text.
      verticalAlign: 'middle',
      flexShrink: 0
    },

    /* Styles applied to the badge `span` element. */
    badge: {
      display: 'flex',
      flexDirection: 'row',
      flexWrap: 'wrap',
      justifyContent: 'center',
      alignContent: 'center',
      alignItems: 'center',
      position: 'absolute',
      boxSizing: 'border-box',
      fontFamily: theme.typography.fontFamily,
      fontWeight: theme.typography.fontWeightMedium,
      fontSize: theme.typography.pxToRem(12),
      minWidth: RADIUS_STANDARD * 2,
      lineHeight: 1,
      padding: '0 6px',
      height: RADIUS_STANDARD * 2,
      borderRadius: RADIUS_STANDARD,
      zIndex: 1,
      // Render the badge on top of potential ripples.
      transition: theme.transitions.create('transform', {
        easing: theme.transitions.easing.easeInOut,
        duration: theme.transitions.duration.enteringScreen
      })
    },

    /* Styles applied to the root element if `color="primary"`. */
    colorPrimary: {
      backgroundColor: theme.palette.primary.main,
      color: theme.palette.primary.contrastText
    },

    /* Styles applied to the root element if `color="secondary"`. */
    colorSecondary: {
      backgroundColor: theme.palette.secondary.main,
      color: theme.palette.secondary.contrastText
    },

    /* Styles applied to the root element if `color="error"`. */
    colorError: {
      backgroundColor: theme.palette.error.main,
      color: theme.palette.error.contrastText
    },

    /* Styles applied to the root element if `variant="dot"`. */
    dot: {
      borderRadius: RADIUS_DOT,
      height: RADIUS_DOT * 2,
      minWidth: RADIUS_DOT * 2,
      padding: 0
    },

    /* Styles applied to the root element if `anchorOrigin={{ 'top', 'right' }} overlap="rectangle"`. */
    anchorOriginTopRightRectangle: {
      top: 0,
      right: 0,
      transform: 'scale(1) translate(50%, -50%)',
      transformOrigin: '100% 0%',
      '&$invisible': {
        transform: 'scale(0) translate(50%, -50%)'
      }
    },

    /* Styles applied to the root element if `anchorOrigin={{ 'bottom', 'right' }} overlap="rectangle"`. */
    anchorOriginBottomRightRectangle: {
      bottom: 0,
      right: 0,
      transform: 'scale(1) translate(50%, 50%)',
      transformOrigin: '100% 100%',
      '&$invisible': {
        transform: 'scale(0) translate(50%, 50%)'
      }
    },

    /* Styles applied to the root element if `anchorOrigin={{ 'top', 'left' }} overlap="rectangle"`. */
    anchorOriginTopLeftRectangle: {
      top: 0,
      left: 0,
      transform: 'scale(1) translate(-50%, -50%)',
      transformOrigin: '0% 0%',
      '&$invisible': {
        transform: 'scale(0) translate(-50%, -50%)'
      }
    },

    /* Styles applied to the root element if `anchorOrigin={{ 'bottom', 'left' }} overlap="rectangle"`. */
    anchorOriginBottomLeftRectangle: {
      bottom: 0,
      left: 0,
      transform: 'scale(1) translate(-50%, 50%)',
      transformOrigin: '0% 100%',
      '&$invisible': {
        transform: 'scale(0) translate(-50%, 50%)'
      }
    },

    /* Styles applied to the root element if `anchorOrigin={{ 'top', 'right' }} overlap="circle"`. */
    anchorOriginTopRightCircle: {
      top: '14%',
      right: '14%',
      transform: 'scale(1) translate(50%, -50%)',
      transformOrigin: '100% 0%',
      '&$invisible': {
        transform: 'scale(0) translate(50%, -50%)'
      }
    },

    /* Styles applied to the root element if `anchorOrigin={{ 'bottom', 'right' }} overlap="circle"`. */
    anchorOriginBottomRightCircle: {
      bottom: '14%',
      right: '14%',
      transform: 'scale(1) translate(50%, 50%)',
      transformOrigin: '100% 100%',
      '&$invisible': {
        transform: 'scale(0) translate(50%, 50%)'
      }
    },

    /* Styles applied to the root element if `anchorOrigin={{ 'top', 'left' }} overlap="circle"`. */
    anchorOriginTopLeftCircle: {
      top: '14%',
      left: '14%',
      transform: 'scale(1) translate(-50%, -50%)',
      transformOrigin: '0% 0%',
      '&$invisible': {
        transform: 'scale(0) translate(-50%, -50%)'
      }
    },

    /* Styles applied to the root element if `anchorOrigin={{ 'bottom', 'left' }} overlap="circle"`. */
    anchorOriginBottomLeftCircle: {
      bottom: '14%',
      left: '14%',
      transform: 'scale(1) translate(-50%, 50%)',
      transformOrigin: '0% 100%',
      '&$invisible': {
        transform: 'scale(0) translate(-50%, 50%)'
      }
    },

    /* Pseudo-class to the badge `span` element if `invisible={true}`. */
    invisible: {
      transition: theme.transitions.create('transform', {
        easing: theme.transitions.easing.easeInOut,
        duration: theme.transitions.duration.leavingScreen
      })
    }
  };
};
var Badge = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["forwardRef"](function Badge(props, ref) {
  var _props$anchorOrigin = props.anchorOrigin,
      anchorOrigin = _props$anchorOrigin === void 0 ? {
    vertical: 'top',
    horizontal: 'right'
  } : _props$anchorOrigin,
      badgeContent = props.badgeContent,
      children = props.children,
      classes = props.classes,
      className = props.className,
      _props$color = props.color,
      color = _props$color === void 0 ? 'default' : _props$color,
      _props$component = props.component,
      ComponentProp = _props$component === void 0 ? 'span' : _props$component,
      invisibleProp = props.invisible,
      _props$max = props.max,
      max = _props$max === void 0 ? 99 : _props$max,
      _props$overlap = props.overlap,
      overlap = _props$overlap === void 0 ? 'rectangle' : _props$overlap,
      _props$showZero = props.showZero,
      showZero = _props$showZero === void 0 ? false : _props$showZero,
      _props$variant = props.variant,
      variant = _props$variant === void 0 ? 'standard' : _props$variant,
      other = Object(_babel_runtime_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(props, ["anchorOrigin", "badgeContent", "children", "classes", "className", "color", "component", "invisible", "max", "overlap", "showZero", "variant"]);

  var invisible = invisibleProp;

  if (invisibleProp == null && (badgeContent === 0 && !showZero || badgeContent == null && variant !== 'dot')) {
    invisible = true;
  }

  var displayValue = '';

  if (variant !== 'dot') {
    displayValue = badgeContent > max ? "".concat(max, "+") : badgeContent;
  }

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["createElement"](ComponentProp, Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    className: Object(clsx__WEBPACK_IMPORTED_MODULE_4__["default"])(classes.root, className),
    ref: ref
  }, other), children, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["createElement"]("span", {
    className: Object(clsx__WEBPACK_IMPORTED_MODULE_4__["default"])(classes.badge, classes["".concat(anchorOrigin.horizontal).concat(Object(_utils_capitalize__WEBPACK_IMPORTED_MODULE_6__["default"])(anchorOrigin.vertical), "}")], classes["anchorOrigin".concat(Object(_utils_capitalize__WEBPACK_IMPORTED_MODULE_6__["default"])(anchorOrigin.vertical)).concat(Object(_utils_capitalize__WEBPACK_IMPORTED_MODULE_6__["default"])(anchorOrigin.horizontal)).concat(Object(_utils_capitalize__WEBPACK_IMPORTED_MODULE_6__["default"])(overlap))], color !== 'default' && classes["color".concat(Object(_utils_capitalize__WEBPACK_IMPORTED_MODULE_6__["default"])(color))], invisible && classes.invisible, variant === 'dot' && classes.dot)
  }, displayValue));
});
 true ? Badge.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * The anchor of the badge.
   */
  anchorOrigin: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.shape({
    horizontal: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.oneOf(['left', 'right']).isRequired,
    vertical: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.oneOf(['bottom', 'top']).isRequired
  }),

  /**
   * The content rendered within the badge.
   */
  badgeContent: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.node,

  /**
   * The badge will be added relative to this node.
   */
  children: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.node,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.object,

  /**
   * @ignore
   */
  className: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.string,

  /**
   * The color of the component. It supports those theme colors that make sense for this component.
   */
  color: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.oneOf(['default', 'error', 'primary', 'secondary']),

  /**
   * The component used for the root node.
   * Either a string to use a HTML element or a component.
   */
  component: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a
  /* @typescript-to-proptypes-ignore */
  .elementType,

  /**
   * If `true`, the badge will be invisible.
   */
  invisible: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.bool,

  /**
   * Max count to show.
   */
  max: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.number,

  /**
   * Wrapped shape the badge should overlap.
   */
  overlap: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.oneOf(['circle', 'rectangle']),

  /**
   * Controls whether the badge is hidden when `badgeContent` is zero.
   */
  showZero: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.bool,

  /**
   * The variant to use.
   */
  variant: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.oneOf(['dot', 'standard'])
} : undefined;
/* harmony default export */ __webpack_exports__["default"] = (Object(_styles_withStyles__WEBPACK_IMPORTED_MODULE_5__["default"])(styles, {
  name: 'MuiBadge'
})(Badge));

/***/ }),

/***/ "./node_modules/@material-ui/core/esm/Badge/index.js":
/*!***********************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/Badge/index.js ***!
  \***********************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Badge__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Badge */ "./node_modules/@material-ui/core/esm/Badge/Badge.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _Badge__WEBPACK_IMPORTED_MODULE_0__["default"]; });



/***/ }),

/***/ "./node_modules/@material-ui/core/esm/BottomNavigation/BottomNavigation.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/BottomNavigation/BottomNavigation.js ***!
  \*********************************************************************************/
/*! exports provided: styles, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "styles", function() { return styles; });
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/esm/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/esm/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_is__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-is */ "./node_modules/react-is/index.js");
/* harmony import */ var react_is__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_is__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var clsx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! clsx */ "./node_modules/clsx/dist/clsx.m.js");
/* harmony import */ var _styles_withStyles__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../styles/withStyles */ "./node_modules/@material-ui/core/esm/styles/withStyles.js");







var styles = function styles(theme) {
  return {
    /* Styles applied to the root element. */
    root: {
      display: 'flex',
      justifyContent: 'center',
      height: 56,
      backgroundColor: theme.palette.background.paper
    }
  };
};
var BottomNavigation = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["forwardRef"](function BottomNavigation(props, ref) {
  var children = props.children,
      classes = props.classes,
      className = props.className,
      _props$component = props.component,
      Component = _props$component === void 0 ? 'div' : _props$component,
      onChange = props.onChange,
      _props$showLabels = props.showLabels,
      showLabels = _props$showLabels === void 0 ? false : _props$showLabels,
      value = props.value,
      other = Object(_babel_runtime_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(props, ["children", "classes", "className", "component", "onChange", "showLabels", "value"]);

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["createElement"](Component, Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    className: Object(clsx__WEBPACK_IMPORTED_MODULE_5__["default"])(classes.root, className),
    ref: ref
  }, other), react__WEBPACK_IMPORTED_MODULE_2__["Children"].map(children, function (child, childIndex) {
    if (! /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["isValidElement"](child)) {
      return null;
    }

    if (true) {
      if (Object(react_is__WEBPACK_IMPORTED_MODULE_3__["isFragment"])(child)) {
        console.error(["Material-UI: The BottomNavigation component doesn't accept a Fragment as a child.", 'Consider providing an array instead.'].join('\n'));
      }
    }

    var childValue = child.props.value === undefined ? childIndex : child.props.value;
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["cloneElement"](child, {
      selected: childValue === value,
      showLabel: child.props.showLabel !== undefined ? child.props.showLabel : showLabels,
      value: childValue,
      onChange: onChange
    });
  }));
});
 true ? BottomNavigation.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * The content of the component.
   */
  children: prop_types__WEBPACK_IMPORTED_MODULE_4___default.a.node,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: prop_types__WEBPACK_IMPORTED_MODULE_4___default.a.object,

  /**
   * @ignore
   */
  className: prop_types__WEBPACK_IMPORTED_MODULE_4___default.a.string,

  /**
   * The component used for the root node.
   * Either a string to use a HTML element or a component.
   */
  component: prop_types__WEBPACK_IMPORTED_MODULE_4___default.a
  /* @typescript-to-proptypes-ignore */
  .elementType,

  /**
   * Callback fired when the value changes.
   *
   * @param {object} event The event source of the callback.
   * @param {any} value We default to the index of the child.
   */
  onChange: prop_types__WEBPACK_IMPORTED_MODULE_4___default.a.func,

  /**
   * If `true`, all `BottomNavigationAction`s will show their labels.
   * By default, only the selected `BottomNavigationAction` will show its label.
   */
  showLabels: prop_types__WEBPACK_IMPORTED_MODULE_4___default.a.bool,

  /**
   * The value of the currently selected `BottomNavigationAction`.
   */
  value: prop_types__WEBPACK_IMPORTED_MODULE_4___default.a.any
} : undefined;
/* harmony default export */ __webpack_exports__["default"] = (Object(_styles_withStyles__WEBPACK_IMPORTED_MODULE_6__["default"])(styles, {
  name: 'MuiBottomNavigation'
})(BottomNavigation));

/***/ }),

/***/ "./node_modules/@material-ui/core/esm/BottomNavigation/index.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/BottomNavigation/index.js ***!
  \**********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _BottomNavigation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BottomNavigation */ "./node_modules/@material-ui/core/esm/BottomNavigation/BottomNavigation.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _BottomNavigation__WEBPACK_IMPORTED_MODULE_0__["default"]; });



/***/ }),

/***/ "./node_modules/@material-ui/core/esm/BottomNavigationAction/BottomNavigationAction.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/BottomNavigationAction/BottomNavigationAction.js ***!
  \*********************************************************************************************/
/*! exports provided: styles, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "styles", function() { return styles; });
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/esm/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/esm/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var clsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! clsx */ "./node_modules/clsx/dist/clsx.m.js");
/* harmony import */ var _styles_withStyles__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../styles/withStyles */ "./node_modules/@material-ui/core/esm/styles/withStyles.js");
/* harmony import */ var _ButtonBase__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../ButtonBase */ "./node_modules/@material-ui/core/esm/ButtonBase/index.js");
/* harmony import */ var _utils_unsupportedProp__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/unsupportedProp */ "./node_modules/@material-ui/core/esm/utils/unsupportedProp.js");








var styles = function styles(theme) {
  return {
    /* Styles applied to the root element. */
    root: {
      transition: theme.transitions.create(['color', 'padding-top'], {
        duration: theme.transitions.duration.short
      }),
      padding: '6px 12px 8px',
      minWidth: 80,
      maxWidth: 168,
      color: theme.palette.text.secondary,
      flex: '1',
      '&$iconOnly': {
        paddingTop: 16
      },
      '&$selected': {
        paddingTop: 6,
        color: theme.palette.primary.main
      }
    },

    /* Pseudo-class applied to the root element if selected. */
    selected: {},

    /* Pseudo-class applied to the root element if `showLabel={false}` and not selected. */
    iconOnly: {},

    /* Styles applied to the span element that wraps the icon and label. */
    wrapper: {
      display: 'inline-flex',
      alignItems: 'center',
      justifyContent: 'center',
      width: '100%',
      flexDirection: 'column'
    },

    /* Styles applied to the label's span element. */
    label: {
      fontFamily: theme.typography.fontFamily,
      fontSize: theme.typography.pxToRem(12),
      opacity: 1,
      transition: 'font-size 0.2s, opacity 0.2s',
      transitionDelay: '0.1s',
      '&$iconOnly': {
        opacity: 0,
        transitionDelay: '0s'
      },
      '&$selected': {
        fontSize: theme.typography.pxToRem(14)
      }
    }
  };
};
var BottomNavigationAction = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["forwardRef"](function BottomNavigationAction(props, ref) {
  var classes = props.classes,
      className = props.className,
      icon = props.icon,
      label = props.label,
      onChange = props.onChange,
      onClick = props.onClick,
      selected = props.selected,
      showLabel = props.showLabel,
      value = props.value,
      other = Object(_babel_runtime_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(props, ["classes", "className", "icon", "label", "onChange", "onClick", "selected", "showLabel", "value"]);

  var handleChange = function handleChange(event) {
    if (onChange) {
      onChange(event, value);
    }

    if (onClick) {
      onClick(event);
    }
  };

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["createElement"](_ButtonBase__WEBPACK_IMPORTED_MODULE_6__["default"], Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    ref: ref,
    className: Object(clsx__WEBPACK_IMPORTED_MODULE_4__["default"])(classes.root, className, selected ? classes.selected : !showLabel && classes.iconOnly),
    focusRipple: true,
    onClick: handleChange
  }, other), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["createElement"]("span", {
    className: classes.wrapper
  }, icon, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["createElement"]("span", {
    className: Object(clsx__WEBPACK_IMPORTED_MODULE_4__["default"])(classes.label, selected ? classes.selected : !showLabel && classes.iconOnly)
  }, label)));
});
 true ? BottomNavigationAction.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * This prop isn't supported.
   * Use the `component` prop if you need to change the children structure.
   */
  children: _utils_unsupportedProp__WEBPACK_IMPORTED_MODULE_7__["default"],

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.object,

  /**
   * @ignore
   */
  className: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.string,

  /**
   * The icon element.
   */
  icon: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.node,

  /**
   * The label element.
   */
  label: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.node,

  /**
   * @ignore
   */
  onChange: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.func,

  /**
   * @ignore
   */
  onClick: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.func,

  /**
   * @ignore
   */
  selected: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.bool,

  /**
   * If `true`, the `BottomNavigationAction` will show its label.
   * By default, only the selected `BottomNavigationAction`
   * inside `BottomNavigation` will show its label.
   */
  showLabel: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.bool,

  /**
   * You can provide your own value. Otherwise, we fallback to the child position index.
   */
  value: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.any
} : undefined;
/* harmony default export */ __webpack_exports__["default"] = (Object(_styles_withStyles__WEBPACK_IMPORTED_MODULE_5__["default"])(styles, {
  name: 'MuiBottomNavigationAction'
})(BottomNavigationAction));

/***/ }),

/***/ "./node_modules/@material-ui/core/esm/BottomNavigationAction/index.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/BottomNavigationAction/index.js ***!
  \****************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _BottomNavigationAction__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BottomNavigationAction */ "./node_modules/@material-ui/core/esm/BottomNavigationAction/BottomNavigationAction.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _BottomNavigationAction__WEBPACK_IMPORTED_MODULE_0__["default"]; });



/***/ }),

/***/ "./node_modules/@material-ui/core/esm/Box/Box.js":
/*!*******************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/Box/Box.js ***!
  \*******************************************************/
/*! exports provided: styleFunction, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "styleFunction", function() { return styleFunction; });
/* harmony import */ var _material_ui_system__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material-ui/system */ "./node_modules/@material-ui/system/esm/index.js");
/* harmony import */ var _styles_styled__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../styles/styled */ "./node_modules/@material-ui/core/esm/styles/styled.js");


var styleFunction = Object(_material_ui_system__WEBPACK_IMPORTED_MODULE_0__["css"])(Object(_material_ui_system__WEBPACK_IMPORTED_MODULE_0__["compose"])(_material_ui_system__WEBPACK_IMPORTED_MODULE_0__["borders"], _material_ui_system__WEBPACK_IMPORTED_MODULE_0__["display"], _material_ui_system__WEBPACK_IMPORTED_MODULE_0__["flexbox"], _material_ui_system__WEBPACK_IMPORTED_MODULE_0__["grid"], _material_ui_system__WEBPACK_IMPORTED_MODULE_0__["positions"], _material_ui_system__WEBPACK_IMPORTED_MODULE_0__["palette"], _material_ui_system__WEBPACK_IMPORTED_MODULE_0__["shadows"], _material_ui_system__WEBPACK_IMPORTED_MODULE_0__["sizing"], _material_ui_system__WEBPACK_IMPORTED_MODULE_0__["spacing"], _material_ui_system__WEBPACK_IMPORTED_MODULE_0__["typography"]));
/**
 * @ignore - do not document.
 */

var Box = Object(_styles_styled__WEBPACK_IMPORTED_MODULE_1__["default"])('div')(styleFunction, {
  name: 'MuiBox'
});
/* harmony default export */ __webpack_exports__["default"] = (Box);

/***/ }),

/***/ "./node_modules/@material-ui/core/esm/Box/index.js":
/*!*********************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/Box/index.js ***!
  \*********************************************************/
/*! exports provided: default, styleFunction */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Box */ "./node_modules/@material-ui/core/esm/Box/Box.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _Box__WEBPACK_IMPORTED_MODULE_0__["default"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "styleFunction", function() { return _Box__WEBPACK_IMPORTED_MODULE_0__["styleFunction"]; });



/***/ }),

/***/ "./node_modules/@material-ui/core/esm/Breadcrumbs/BreadcrumbCollapsed.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/Breadcrumbs/BreadcrumbCollapsed.js ***!
  \*******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/esm/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/esm/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _styles_withStyles__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../styles/withStyles */ "./node_modules/@material-ui/core/esm/styles/withStyles.js");
/* harmony import */ var _styles_colorManipulator__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../styles/colorManipulator */ "./node_modules/@material-ui/core/esm/styles/colorManipulator.js");
/* harmony import */ var _internal_svg_icons_MoreHoriz__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../internal/svg-icons/MoreHoriz */ "./node_modules/@material-ui/core/esm/internal/svg-icons/MoreHoriz.js");
/* harmony import */ var _ButtonBase__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../ButtonBase */ "./node_modules/@material-ui/core/esm/ButtonBase/index.js");









var styles = function styles(theme) {
  return {
    root: {
      display: 'flex',
      marginLeft: theme.spacing(0.5),
      marginRight: theme.spacing(0.5),
      backgroundColor: theme.palette.grey[100],
      color: theme.palette.grey[700],
      borderRadius: 2,
      cursor: 'pointer',
      '&:hover, &:focus': {
        backgroundColor: theme.palette.grey[200]
      },
      '&:active': {
        boxShadow: theme.shadows[0],
        backgroundColor: Object(_styles_colorManipulator__WEBPACK_IMPORTED_MODULE_5__["emphasize"])(theme.palette.grey[200], 0.12)
      }
    },
    icon: {
      width: 24,
      height: 16
    }
  };
};
/**
 * @ignore - internal component.
 */


function BreadcrumbCollapsed(props) {
  var classes = props.classes,
      other = Object(_babel_runtime_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(props, ["classes"]);

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["createElement"](_ButtonBase__WEBPACK_IMPORTED_MODULE_7__["default"], Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    component: "li",
    className: classes.root,
    focusRipple: true
  }, other), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["createElement"](_internal_svg_icons_MoreHoriz__WEBPACK_IMPORTED_MODULE_6__["default"], {
    className: classes.icon
  }));
}

 true ? BreadcrumbCollapsed.propTypes = {
  /**
   * @ignore
   */
  classes: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.object.isRequired
} : undefined;
/* harmony default export */ __webpack_exports__["default"] = (Object(_styles_withStyles__WEBPACK_IMPORTED_MODULE_4__["default"])(styles, {
  name: 'PrivateBreadcrumbCollapsed'
})(BreadcrumbCollapsed));

/***/ }),

/***/ "./node_modules/@material-ui/core/esm/Breadcrumbs/Breadcrumbs.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/Breadcrumbs/Breadcrumbs.js ***!
  \***********************************************************************/
/*! exports provided: styles, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "styles", function() { return styles; });
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/esm/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_esm_toConsumableArray__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/esm/toConsumableArray */ "./node_modules/@babel/runtime/helpers/esm/toConsumableArray.js");
/* harmony import */ var _babel_runtime_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/esm/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_is__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-is */ "./node_modules/react-is/index.js");
/* harmony import */ var react_is__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_is__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var clsx__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! clsx */ "./node_modules/clsx/dist/clsx.m.js");
/* harmony import */ var _styles_withStyles__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../styles/withStyles */ "./node_modules/@material-ui/core/esm/styles/withStyles.js");
/* harmony import */ var _Typography__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../Typography */ "./node_modules/@material-ui/core/esm/Typography/index.js");
/* harmony import */ var _BreadcrumbCollapsed__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./BreadcrumbCollapsed */ "./node_modules/@material-ui/core/esm/Breadcrumbs/BreadcrumbCollapsed.js");










var styles = {
  /* Styles applied to the root element. */
  root: {},

  /* Styles applied to the ol element. */
  ol: {
    display: 'flex',
    flexWrap: 'wrap',
    alignItems: 'center',
    padding: 0,
    margin: 0,
    listStyle: 'none'
  },

  /* Styles applied to the li element. */
  li: {},

  /* Styles applied to the separator element. */
  separator: {
    display: 'flex',
    userSelect: 'none',
    marginLeft: 8,
    marginRight: 8
  }
};

function insertSeparators(items, className, separator) {
  return items.reduce(function (acc, current, index) {
    if (index < items.length - 1) {
      acc = acc.concat(current, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__["createElement"]("li", {
        "aria-hidden": true,
        key: "separator-".concat(index),
        className: className
      }, separator));
    } else {
      acc.push(current);
    }

    return acc;
  }, []);
}

var Breadcrumbs = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__["forwardRef"](function Breadcrumbs(props, ref) {
  var children = props.children,
      classes = props.classes,
      className = props.className,
      _props$component = props.component,
      Component = _props$component === void 0 ? 'nav' : _props$component,
      _props$expandText = props.expandText,
      expandText = _props$expandText === void 0 ? 'Show path' : _props$expandText,
      _props$itemsAfterColl = props.itemsAfterCollapse,
      itemsAfterCollapse = _props$itemsAfterColl === void 0 ? 1 : _props$itemsAfterColl,
      _props$itemsBeforeCol = props.itemsBeforeCollapse,
      itemsBeforeCollapse = _props$itemsBeforeCol === void 0 ? 1 : _props$itemsBeforeCol,
      _props$maxItems = props.maxItems,
      maxItems = _props$maxItems === void 0 ? 8 : _props$maxItems,
      _props$separator = props.separator,
      separator = _props$separator === void 0 ? '/' : _props$separator,
      other = Object(_babel_runtime_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__["default"])(props, ["children", "classes", "className", "component", "expandText", "itemsAfterCollapse", "itemsBeforeCollapse", "maxItems", "separator"]);

  var _React$useState = react__WEBPACK_IMPORTED_MODULE_3__["useState"](false),
      expanded = _React$useState[0],
      setExpanded = _React$useState[1];

  var renderItemsBeforeAndAfter = function renderItemsBeforeAndAfter(allItems) {
    var handleClickExpand = function handleClickExpand(event) {
      setExpanded(true); // The clicked element received the focus but gets removed from the DOM.
      // Let's keep the focus in the component after expanding.

      var focusable = event.currentTarget.parentNode.querySelector('a[href],button,[tabindex]');

      if (focusable) {
        focusable.focus();
      }
    }; // This defends against someone passing weird input, to ensure that if all
    // items would be shown anyway, we just show all items without the EllipsisItem


    if (itemsBeforeCollapse + itemsAfterCollapse >= allItems.length) {
      if (true) {
        console.error(['Material-UI: You have provided an invalid combination of props to the Breadcrumbs.', "itemsAfterCollapse={".concat(itemsAfterCollapse, "} + itemsBeforeCollapse={").concat(itemsBeforeCollapse, "} >= maxItems={").concat(maxItems, "}")].join('\n'));
      }

      return allItems;
    }

    return [].concat(Object(_babel_runtime_helpers_esm_toConsumableArray__WEBPACK_IMPORTED_MODULE_1__["default"])(allItems.slice(0, itemsBeforeCollapse)), [/*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__["createElement"](_BreadcrumbCollapsed__WEBPACK_IMPORTED_MODULE_9__["default"], {
      "aria-label": expandText,
      key: "ellipsis",
      onClick: handleClickExpand
    })], Object(_babel_runtime_helpers_esm_toConsumableArray__WEBPACK_IMPORTED_MODULE_1__["default"])(allItems.slice(allItems.length - itemsAfterCollapse, allItems.length)));
  };

  var allItems = react__WEBPACK_IMPORTED_MODULE_3__["Children"].toArray(children).filter(function (child) {
    if (true) {
      if (Object(react_is__WEBPACK_IMPORTED_MODULE_4__["isFragment"])(child)) {
        console.error(["Material-UI: The Breadcrumbs component doesn't accept a Fragment as a child.", 'Consider providing an array instead.'].join('\n'));
      }
    }

    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__["isValidElement"](child);
  }).map(function (child, index) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__["createElement"]("li", {
      className: classes.li,
      key: "child-".concat(index)
    }, child);
  });
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__["createElement"](_Typography__WEBPACK_IMPORTED_MODULE_8__["default"], Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    ref: ref,
    component: Component,
    color: "textSecondary",
    className: Object(clsx__WEBPACK_IMPORTED_MODULE_6__["default"])(classes.root, className)
  }, other), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__["createElement"]("ol", {
    className: classes.ol
  }, insertSeparators(expanded || maxItems && allItems.length <= maxItems ? allItems : renderItemsBeforeAndAfter(allItems), classes.separator, separator)));
});
 true ? Breadcrumbs.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * The breadcrumb children.
   */
  children: prop_types__WEBPACK_IMPORTED_MODULE_5___default.a.node,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: prop_types__WEBPACK_IMPORTED_MODULE_5___default.a.object,

  /**
   * @ignore
   */
  className: prop_types__WEBPACK_IMPORTED_MODULE_5___default.a.string,

  /**
   * The component used for the root node.
   * Either a string to use a HTML element or a component.
   */
  component: prop_types__WEBPACK_IMPORTED_MODULE_5___default.a
  /* @typescript-to-proptypes-ignore */
  .elementType,

  /**
   * Override the default label for the expand button.
   *
   * For localization purposes, you can use the provided [translations](/guides/localization/).
   */
  expandText: prop_types__WEBPACK_IMPORTED_MODULE_5___default.a.string,

  /**
   * If max items is exceeded, the number of items to show after the ellipsis.
   */
  itemsAfterCollapse: prop_types__WEBPACK_IMPORTED_MODULE_5___default.a.number,

  /**
   * If max items is exceeded, the number of items to show before the ellipsis.
   */
  itemsBeforeCollapse: prop_types__WEBPACK_IMPORTED_MODULE_5___default.a.number,

  /**
   * Specifies the maximum number of breadcrumbs to display. When there are more
   * than the maximum number, only the first `itemsBeforeCollapse` and last `itemsAfterCollapse`
   * will be shown, with an ellipsis in between.
   */
  maxItems: prop_types__WEBPACK_IMPORTED_MODULE_5___default.a.number,

  /**
   * Custom separator node.
   */
  separator: prop_types__WEBPACK_IMPORTED_MODULE_5___default.a.node
} : undefined;
/* harmony default export */ __webpack_exports__["default"] = (Object(_styles_withStyles__WEBPACK_IMPORTED_MODULE_7__["default"])(styles, {
  name: 'MuiBreadcrumbs'
})(Breadcrumbs));

/***/ }),

/***/ "./node_modules/@material-ui/core/esm/Breadcrumbs/index.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/Breadcrumbs/index.js ***!
  \*****************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Breadcrumbs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Breadcrumbs */ "./node_modules/@material-ui/core/esm/Breadcrumbs/Breadcrumbs.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _Breadcrumbs__WEBPACK_IMPORTED_MODULE_0__["default"]; });



/***/ }),

/***/ "./node_modules/@material-ui/core/esm/Button/Button.js":
/*!*************************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/Button/Button.js ***!
  \*************************************************************/
/*! exports provided: styles, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "styles", function() { return styles; });
/* harmony import */ var _babel_runtime_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/esm/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/esm/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var clsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! clsx */ "./node_modules/clsx/dist/clsx.m.js");
/* harmony import */ var _styles_withStyles__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../styles/withStyles */ "./node_modules/@material-ui/core/esm/styles/withStyles.js");
/* harmony import */ var _styles_colorManipulator__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../styles/colorManipulator */ "./node_modules/@material-ui/core/esm/styles/colorManipulator.js");
/* harmony import */ var _ButtonBase__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../ButtonBase */ "./node_modules/@material-ui/core/esm/ButtonBase/index.js");
/* harmony import */ var _utils_capitalize__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils/capitalize */ "./node_modules/@material-ui/core/esm/utils/capitalize.js");









var styles = function styles(theme) {
  return {
    /* Styles applied to the root element. */
    root: Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_1__["default"])({}, theme.typography.button, {
      boxSizing: 'border-box',
      minWidth: 64,
      padding: '6px 16px',
      borderRadius: theme.shape.borderRadius,
      color: theme.palette.text.primary,
      transition: theme.transitions.create(['background-color', 'box-shadow', 'border'], {
        duration: theme.transitions.duration.short
      }),
      '&:hover': {
        textDecoration: 'none',
        backgroundColor: Object(_styles_colorManipulator__WEBPACK_IMPORTED_MODULE_6__["fade"])(theme.palette.text.primary, theme.palette.action.hoverOpacity),
        // Reset on touch devices, it doesn't add specificity
        '@media (hover: none)': {
          backgroundColor: 'transparent'
        },
        '&$disabled': {
          backgroundColor: 'transparent'
        }
      },
      '&$disabled': {
        color: theme.palette.action.disabled
      }
    }),

    /* Styles applied to the span element that wraps the children. */
    label: {
      width: '100%',
      // Ensure the correct width for iOS Safari
      display: 'inherit',
      alignItems: 'inherit',
      justifyContent: 'inherit'
    },

    /* Styles applied to the root element if `variant="text"`. */
    text: {
      padding: '6px 8px'
    },

    /* Styles applied to the root element if `variant="text"` and `color="primary"`. */
    textPrimary: {
      color: theme.palette.primary.main,
      '&:hover': {
        backgroundColor: Object(_styles_colorManipulator__WEBPACK_IMPORTED_MODULE_6__["fade"])(theme.palette.primary.main, theme.palette.action.hoverOpacity),
        // Reset on touch devices, it doesn't add specificity
        '@media (hover: none)': {
          backgroundColor: 'transparent'
        }
      }
    },

    /* Styles applied to the root element if `variant="text"` and `color="secondary"`. */
    textSecondary: {
      color: theme.palette.secondary.main,
      '&:hover': {
        backgroundColor: Object(_styles_colorManipulator__WEBPACK_IMPORTED_MODULE_6__["fade"])(theme.palette.secondary.main, theme.palette.action.hoverOpacity),
        // Reset on touch devices, it doesn't add specificity
        '@media (hover: none)': {
          backgroundColor: 'transparent'
        }
      }
    },

    /* Styles applied to the root element if `variant="outlined"`. */
    outlined: {
      padding: '5px 15px',
      border: "1px solid ".concat(theme.palette.type === 'light' ? 'rgba(0, 0, 0, 0.23)' : 'rgba(255, 255, 255, 0.23)'),
      '&$disabled': {
        border: "1px solid ".concat(theme.palette.action.disabledBackground)
      }
    },

    /* Styles applied to the root element if `variant="outlined"` and `color="primary"`. */
    outlinedPrimary: {
      color: theme.palette.primary.main,
      border: "1px solid ".concat(Object(_styles_colorManipulator__WEBPACK_IMPORTED_MODULE_6__["fade"])(theme.palette.primary.main, 0.5)),
      '&:hover': {
        border: "1px solid ".concat(theme.palette.primary.main),
        backgroundColor: Object(_styles_colorManipulator__WEBPACK_IMPORTED_MODULE_6__["fade"])(theme.palette.primary.main, theme.palette.action.hoverOpacity),
        // Reset on touch devices, it doesn't add specificity
        '@media (hover: none)': {
          backgroundColor: 'transparent'
        }
      }
    },

    /* Styles applied to the root element if `variant="outlined"` and `color="secondary"`. */
    outlinedSecondary: {
      color: theme.palette.secondary.main,
      border: "1px solid ".concat(Object(_styles_colorManipulator__WEBPACK_IMPORTED_MODULE_6__["fade"])(theme.palette.secondary.main, 0.5)),
      '&:hover': {
        border: "1px solid ".concat(theme.palette.secondary.main),
        backgroundColor: Object(_styles_colorManipulator__WEBPACK_IMPORTED_MODULE_6__["fade"])(theme.palette.secondary.main, theme.palette.action.hoverOpacity),
        // Reset on touch devices, it doesn't add specificity
        '@media (hover: none)': {
          backgroundColor: 'transparent'
        }
      },
      '&$disabled': {
        border: "1px solid ".concat(theme.palette.action.disabled)
      }
    },

    /* Styles applied to the root element if `variant="contained"`. */
    contained: {
      color: theme.palette.getContrastText(theme.palette.grey[300]),
      backgroundColor: theme.palette.grey[300],
      boxShadow: theme.shadows[2],
      '&:hover': {
        backgroundColor: theme.palette.grey.A100,
        boxShadow: theme.shadows[4],
        // Reset on touch devices, it doesn't add specificity
        '@media (hover: none)': {
          boxShadow: theme.shadows[2],
          backgroundColor: theme.palette.grey[300]
        },
        '&$disabled': {
          backgroundColor: theme.palette.action.disabledBackground
        }
      },
      '&$focusVisible': {
        boxShadow: theme.shadows[6]
      },
      '&:active': {
        boxShadow: theme.shadows[8]
      },
      '&$disabled': {
        color: theme.palette.action.disabled,
        boxShadow: theme.shadows[0],
        backgroundColor: theme.palette.action.disabledBackground
      }
    },

    /* Styles applied to the root element if `variant="contained"` and `color="primary"`. */
    containedPrimary: {
      color: theme.palette.primary.contrastText,
      backgroundColor: theme.palette.primary.main,
      '&:hover': {
        backgroundColor: theme.palette.primary.dark,
        // Reset on touch devices, it doesn't add specificity
        '@media (hover: none)': {
          backgroundColor: theme.palette.primary.main
        }
      }
    },

    /* Styles applied to the root element if `variant="contained"` and `color="secondary"`. */
    containedSecondary: {
      color: theme.palette.secondary.contrastText,
      backgroundColor: theme.palette.secondary.main,
      '&:hover': {
        backgroundColor: theme.palette.secondary.dark,
        // Reset on touch devices, it doesn't add specificity
        '@media (hover: none)': {
          backgroundColor: theme.palette.secondary.main
        }
      }
    },

    /* Styles applied to the root element if `disableElevation={true}`. */
    disableElevation: {
      boxShadow: 'none',
      '&:hover': {
        boxShadow: 'none'
      },
      '&$focusVisible': {
        boxShadow: 'none'
      },
      '&:active': {
        boxShadow: 'none'
      },
      '&$disabled': {
        boxShadow: 'none'
      }
    },

    /* Pseudo-class applied to the ButtonBase root element if the button is keyboard focused. */
    focusVisible: {},

    /* Pseudo-class applied to the root element if `disabled={true}`. */
    disabled: {},

    /* Styles applied to the root element if `color="inherit"`. */
    colorInherit: {
      color: 'inherit',
      borderColor: 'currentColor'
    },

    /* Styles applied to the root element if `size="small"` and `variant="text"`. */
    textSizeSmall: {
      padding: '4px 5px',
      fontSize: theme.typography.pxToRem(13)
    },

    /* Styles applied to the root element if `size="large"` and `variant="text"`. */
    textSizeLarge: {
      padding: '8px 11px',
      fontSize: theme.typography.pxToRem(15)
    },

    /* Styles applied to the root element if `size="small"` and `variant="outlined"`. */
    outlinedSizeSmall: {
      padding: '3px 9px',
      fontSize: theme.typography.pxToRem(13)
    },

    /* Styles applied to the root element if `size="large"` and `variant="outlined"`. */
    outlinedSizeLarge: {
      padding: '7px 21px',
      fontSize: theme.typography.pxToRem(15)
    },

    /* Styles applied to the root element if `size="small"` and `variant="contained"`. */
    containedSizeSmall: {
      padding: '4px 10px',
      fontSize: theme.typography.pxToRem(13)
    },

    /* Styles applied to the root element if `size="large"` and `variant="contained"`. */
    containedSizeLarge: {
      padding: '8px 22px',
      fontSize: theme.typography.pxToRem(15)
    },

    /* Styles applied to the root element if `size="small"`. */
    sizeSmall: {},

    /* Styles applied to the root element if `size="large"`. */
    sizeLarge: {},

    /* Styles applied to the root element if `fullWidth={true}`. */
    fullWidth: {
      width: '100%'
    },

    /* Styles applied to the startIcon element if supplied. */
    startIcon: {
      display: 'inherit',
      marginRight: 8,
      marginLeft: -4,
      '&$iconSizeSmall': {
        marginLeft: -2
      }
    },

    /* Styles applied to the endIcon element if supplied. */
    endIcon: {
      display: 'inherit',
      marginRight: -4,
      marginLeft: 8,
      '&$iconSizeSmall': {
        marginRight: -2
      }
    },

    /* Styles applied to the icon element if supplied and `size="small"`. */
    iconSizeSmall: {
      '& > *:first-child': {
        fontSize: 18
      }
    },

    /* Styles applied to the icon element if supplied and `size="medium"`. */
    iconSizeMedium: {
      '& > *:first-child': {
        fontSize: 20
      }
    },

    /* Styles applied to the icon element if supplied and `size="large"`. */
    iconSizeLarge: {
      '& > *:first-child': {
        fontSize: 22
      }
    }
  };
};
var Button = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["forwardRef"](function Button(props, ref) {
  var children = props.children,
      classes = props.classes,
      className = props.className,
      _props$color = props.color,
      color = _props$color === void 0 ? 'default' : _props$color,
      _props$component = props.component,
      component = _props$component === void 0 ? 'button' : _props$component,
      _props$disabled = props.disabled,
      disabled = _props$disabled === void 0 ? false : _props$disabled,
      _props$disableElevati = props.disableElevation,
      disableElevation = _props$disableElevati === void 0 ? false : _props$disableElevati,
      _props$disableFocusRi = props.disableFocusRipple,
      disableFocusRipple = _props$disableFocusRi === void 0 ? false : _props$disableFocusRi,
      endIconProp = props.endIcon,
      focusVisibleClassName = props.focusVisibleClassName,
      _props$fullWidth = props.fullWidth,
      fullWidth = _props$fullWidth === void 0 ? false : _props$fullWidth,
      _props$size = props.size,
      size = _props$size === void 0 ? 'medium' : _props$size,
      startIconProp = props.startIcon,
      _props$type = props.type,
      type = _props$type === void 0 ? 'button' : _props$type,
      _props$variant = props.variant,
      variant = _props$variant === void 0 ? 'text' : _props$variant,
      other = Object(_babel_runtime_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_0__["default"])(props, ["children", "classes", "className", "color", "component", "disabled", "disableElevation", "disableFocusRipple", "endIcon", "focusVisibleClassName", "fullWidth", "size", "startIcon", "type", "variant"]);

  var startIcon = startIconProp && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["createElement"]("span", {
    className: Object(clsx__WEBPACK_IMPORTED_MODULE_4__["default"])(classes.startIcon, classes["iconSize".concat(Object(_utils_capitalize__WEBPACK_IMPORTED_MODULE_8__["default"])(size))])
  }, startIconProp);
  var endIcon = endIconProp && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["createElement"]("span", {
    className: Object(clsx__WEBPACK_IMPORTED_MODULE_4__["default"])(classes.endIcon, classes["iconSize".concat(Object(_utils_capitalize__WEBPACK_IMPORTED_MODULE_8__["default"])(size))])
  }, endIconProp);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["createElement"](_ButtonBase__WEBPACK_IMPORTED_MODULE_7__["default"], Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_1__["default"])({
    className: Object(clsx__WEBPACK_IMPORTED_MODULE_4__["default"])(classes.root, classes[variant], className, color === 'inherit' ? classes.colorInherit : color !== 'default' && classes["".concat(variant).concat(Object(_utils_capitalize__WEBPACK_IMPORTED_MODULE_8__["default"])(color))], size !== 'medium' && [classes["".concat(variant, "Size").concat(Object(_utils_capitalize__WEBPACK_IMPORTED_MODULE_8__["default"])(size))], classes["size".concat(Object(_utils_capitalize__WEBPACK_IMPORTED_MODULE_8__["default"])(size))]], disableElevation && classes.disableElevation, disabled && classes.disabled, fullWidth && classes.fullWidth),
    component: component,
    disabled: disabled,
    focusRipple: !disableFocusRipple,
    focusVisibleClassName: Object(clsx__WEBPACK_IMPORTED_MODULE_4__["default"])(classes.focusVisible, focusVisibleClassName),
    ref: ref,
    type: type
  }, other), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["createElement"]("span", {
    className: classes.label
  }, startIcon, children, endIcon));
});
 true ? Button.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * The content of the button.
   */
  children: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.node,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.object,

  /**
   * @ignore
   */
  className: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.string,

  /**
   * The color of the component. It supports those theme colors that make sense for this component.
   */
  color: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.oneOf(['default', 'inherit', 'primary', 'secondary']),

  /**
   * The component used for the root node.
   * Either a string to use a HTML element or a component.
   */
  component: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a
  /* @typescript-to-proptypes-ignore */
  .elementType,

  /**
   * If `true`, the button will be disabled.
   */
  disabled: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.bool,

  /**
   * If `true`, no elevation is used.
   */
  disableElevation: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.bool,

  /**
   * If `true`, the  keyboard focus ripple will be disabled.
   */
  disableFocusRipple: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.bool,

  /**
   * If `true`, the ripple effect will be disabled.
   *
   * ⚠️ Without a ripple there is no styling for :focus-visible by default. Be sure
   * to highlight the element by applying separate styles with the `focusVisibleClassName`.
   */
  disableRipple: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.bool,

  /**
   * Element placed after the children.
   */
  endIcon: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.node,

  /**
   * @ignore
   */
  focusVisibleClassName: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.string,

  /**
   * If `true`, the button will take up the full width of its container.
   */
  fullWidth: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.bool,

  /**
   * The URL to link to when the button is clicked.
   * If defined, an `a` element will be used as the root node.
   */
  href: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.string,

  /**
   * The size of the button.
   * `small` is equivalent to the dense button styling.
   */
  size: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.oneOf(['large', 'medium', 'small']),

  /**
   * Element placed before the children.
   */
  startIcon: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.node,

  /**
   * @ignore
   */
  type: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.oneOf(['button', 'reset', 'submit']), prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.string]),

  /**
   * The variant to use.
   */
  variant: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.oneOf(['contained', 'outlined', 'text'])
} : undefined;
/* harmony default export */ __webpack_exports__["default"] = (Object(_styles_withStyles__WEBPACK_IMPORTED_MODULE_5__["default"])(styles, {
  name: 'MuiButton'
})(Button));

/***/ }),

/***/ "./node_modules/@material-ui/core/esm/Button/index.js":
/*!************************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/Button/index.js ***!
  \************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Button */ "./node_modules/@material-ui/core/esm/Button/Button.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _Button__WEBPACK_IMPORTED_MODULE_0__["default"]; });



/***/ }),

/***/ "./node_modules/@material-ui/core/esm/ButtonBase/ButtonBase.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/ButtonBase/ButtonBase.js ***!
  \*********************************************************************/
/*! exports provided: styles, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "styles", function() { return styles; });
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/esm/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/esm/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-dom */ "./node_modules/react-dom/index.js");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var clsx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! clsx */ "./node_modules/clsx/dist/clsx.m.js");
/* harmony import */ var _material_ui_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @material-ui/utils */ "./node_modules/@material-ui/utils/esm/index.js");
/* harmony import */ var _utils_useForkRef__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/useForkRef */ "./node_modules/@material-ui/core/esm/utils/useForkRef.js");
/* harmony import */ var _utils_useEventCallback__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils/useEventCallback */ "./node_modules/@material-ui/core/esm/utils/useEventCallback.js");
/* harmony import */ var _styles_withStyles__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../styles/withStyles */ "./node_modules/@material-ui/core/esm/styles/withStyles.js");
/* harmony import */ var _utils_useIsFocusVisible__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../utils/useIsFocusVisible */ "./node_modules/@material-ui/core/esm/utils/useIsFocusVisible.js");
/* harmony import */ var _TouchRipple__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./TouchRipple */ "./node_modules/@material-ui/core/esm/ButtonBase/TouchRipple.js");












var styles = {
  /* Styles applied to the root element. */
  root: {
    display: 'inline-flex',
    alignItems: 'center',
    justifyContent: 'center',
    position: 'relative',
    WebkitTapHighlightColor: 'transparent',
    backgroundColor: 'transparent',
    // Reset default value
    // We disable the focus ring for mouse, touch and keyboard users.
    outline: 0,
    border: 0,
    margin: 0,
    // Remove the margin in Safari
    borderRadius: 0,
    padding: 0,
    // Remove the padding in Firefox
    cursor: 'pointer',
    userSelect: 'none',
    verticalAlign: 'middle',
    '-moz-appearance': 'none',
    // Reset
    '-webkit-appearance': 'none',
    // Reset
    textDecoration: 'none',
    // So we take precedent over the style of a native <a /> element.
    color: 'inherit',
    '&::-moz-focus-inner': {
      borderStyle: 'none' // Remove Firefox dotted outline.

    },
    '&$disabled': {
      pointerEvents: 'none',
      // Disable link interactions
      cursor: 'default'
    },
    '@media print': {
      colorAdjust: 'exact'
    }
  },

  /* Pseudo-class applied to the root element if `disabled={true}`. */
  disabled: {},

  /* Pseudo-class applied to the root element if keyboard focused. */
  focusVisible: {}
};
/**
 * `ButtonBase` contains as few styles as possible.
 * It aims to be a simple building block for creating a button.
 * It contains a load of style reset and some focus/ripple logic.
 */

var ButtonBase = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["forwardRef"](function ButtonBase(props, ref) {
  var action = props.action,
      buttonRefProp = props.buttonRef,
      _props$centerRipple = props.centerRipple,
      centerRipple = _props$centerRipple === void 0 ? false : _props$centerRipple,
      children = props.children,
      classes = props.classes,
      className = props.className,
      _props$component = props.component,
      component = _props$component === void 0 ? 'button' : _props$component,
      _props$disabled = props.disabled,
      disabled = _props$disabled === void 0 ? false : _props$disabled,
      _props$disableRipple = props.disableRipple,
      disableRipple = _props$disableRipple === void 0 ? false : _props$disableRipple,
      _props$disableTouchRi = props.disableTouchRipple,
      disableTouchRipple = _props$disableTouchRi === void 0 ? false : _props$disableTouchRi,
      _props$focusRipple = props.focusRipple,
      focusRipple = _props$focusRipple === void 0 ? false : _props$focusRipple,
      focusVisibleClassName = props.focusVisibleClassName,
      onBlur = props.onBlur,
      onClick = props.onClick,
      onFocus = props.onFocus,
      onFocusVisible = props.onFocusVisible,
      onKeyDown = props.onKeyDown,
      onKeyUp = props.onKeyUp,
      onMouseDown = props.onMouseDown,
      onMouseLeave = props.onMouseLeave,
      onMouseUp = props.onMouseUp,
      onTouchEnd = props.onTouchEnd,
      onTouchMove = props.onTouchMove,
      onTouchStart = props.onTouchStart,
      onDragLeave = props.onDragLeave,
      _props$tabIndex = props.tabIndex,
      tabIndex = _props$tabIndex === void 0 ? 0 : _props$tabIndex,
      TouchRippleProps = props.TouchRippleProps,
      _props$type = props.type,
      type = _props$type === void 0 ? 'button' : _props$type,
      other = Object(_babel_runtime_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(props, ["action", "buttonRef", "centerRipple", "children", "classes", "className", "component", "disabled", "disableRipple", "disableTouchRipple", "focusRipple", "focusVisibleClassName", "onBlur", "onClick", "onFocus", "onFocusVisible", "onKeyDown", "onKeyUp", "onMouseDown", "onMouseLeave", "onMouseUp", "onTouchEnd", "onTouchMove", "onTouchStart", "onDragLeave", "tabIndex", "TouchRippleProps", "type"]);

  var buttonRef = react__WEBPACK_IMPORTED_MODULE_2__["useRef"](null);

  function getButtonNode() {
    // #StrictMode ready
    return react_dom__WEBPACK_IMPORTED_MODULE_4__["findDOMNode"](buttonRef.current);
  }

  var rippleRef = react__WEBPACK_IMPORTED_MODULE_2__["useRef"](null);

  var _React$useState = react__WEBPACK_IMPORTED_MODULE_2__["useState"](false),
      focusVisible = _React$useState[0],
      setFocusVisible = _React$useState[1];

  if (disabled && focusVisible) {
    setFocusVisible(false);
  }

  var _useIsFocusVisible = Object(_utils_useIsFocusVisible__WEBPACK_IMPORTED_MODULE_10__["default"])(),
      isFocusVisible = _useIsFocusVisible.isFocusVisible,
      onBlurVisible = _useIsFocusVisible.onBlurVisible,
      focusVisibleRef = _useIsFocusVisible.ref;

  react__WEBPACK_IMPORTED_MODULE_2__["useImperativeHandle"](action, function () {
    return {
      focusVisible: function focusVisible() {
        setFocusVisible(true);
        buttonRef.current.focus();
      }
    };
  }, []);
  react__WEBPACK_IMPORTED_MODULE_2__["useEffect"](function () {
    if (focusVisible && focusRipple && !disableRipple) {
      rippleRef.current.pulsate();
    }
  }, [disableRipple, focusRipple, focusVisible]);

  function useRippleHandler(rippleAction, eventCallback) {
    var skipRippleAction = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : disableTouchRipple;
    return Object(_utils_useEventCallback__WEBPACK_IMPORTED_MODULE_8__["default"])(function (event) {
      if (eventCallback) {
        eventCallback(event);
      }

      var ignore = skipRippleAction;

      if (!ignore && rippleRef.current) {
        rippleRef.current[rippleAction](event);
      }

      return true;
    });
  }

  var handleMouseDown = useRippleHandler('start', onMouseDown);
  var handleDragLeave = useRippleHandler('stop', onDragLeave);
  var handleMouseUp = useRippleHandler('stop', onMouseUp);
  var handleMouseLeave = useRippleHandler('stop', function (event) {
    if (focusVisible) {
      event.preventDefault();
    }

    if (onMouseLeave) {
      onMouseLeave(event);
    }
  });
  var handleTouchStart = useRippleHandler('start', onTouchStart);
  var handleTouchEnd = useRippleHandler('stop', onTouchEnd);
  var handleTouchMove = useRippleHandler('stop', onTouchMove);
  var handleBlur = useRippleHandler('stop', function (event) {
    if (focusVisible) {
      onBlurVisible(event);
      setFocusVisible(false);
    }

    if (onBlur) {
      onBlur(event);
    }
  }, false);
  var handleFocus = Object(_utils_useEventCallback__WEBPACK_IMPORTED_MODULE_8__["default"])(function (event) {
    // Fix for https://github.com/facebook/react/issues/7769
    if (!buttonRef.current) {
      buttonRef.current = event.currentTarget;
    }

    if (isFocusVisible(event)) {
      setFocusVisible(true);

      if (onFocusVisible) {
        onFocusVisible(event);
      }
    }

    if (onFocus) {
      onFocus(event);
    }
  });

  var isNonNativeButton = function isNonNativeButton() {
    var button = getButtonNode();
    return component && component !== 'button' && !(button.tagName === 'A' && button.href);
  };
  /**
   * IE 11 shim for https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/repeat
   */


  var keydownRef = react__WEBPACK_IMPORTED_MODULE_2__["useRef"](false);
  var handleKeyDown = Object(_utils_useEventCallback__WEBPACK_IMPORTED_MODULE_8__["default"])(function (event) {
    // Check if key is already down to avoid repeats being counted as multiple activations
    if (focusRipple && !keydownRef.current && focusVisible && rippleRef.current && event.key === ' ') {
      keydownRef.current = true;
      event.persist();
      rippleRef.current.stop(event, function () {
        rippleRef.current.start(event);
      });
    }

    if (event.target === event.currentTarget && isNonNativeButton() && event.key === ' ') {
      event.preventDefault();
    }

    if (onKeyDown) {
      onKeyDown(event);
    } // Keyboard accessibility for non interactive elements


    if (event.target === event.currentTarget && isNonNativeButton() && event.key === 'Enter' && !disabled) {
      event.preventDefault();

      if (onClick) {
        onClick(event);
      }
    }
  });
  var handleKeyUp = Object(_utils_useEventCallback__WEBPACK_IMPORTED_MODULE_8__["default"])(function (event) {
    // calling preventDefault in keyUp on a <button> will not dispatch a click event if Space is pressed
    // https://codesandbox.io/s/button-keyup-preventdefault-dn7f0
    if (focusRipple && event.key === ' ' && rippleRef.current && focusVisible && !event.defaultPrevented) {
      keydownRef.current = false;
      event.persist();
      rippleRef.current.stop(event, function () {
        rippleRef.current.pulsate(event);
      });
    }

    if (onKeyUp) {
      onKeyUp(event);
    } // Keyboard accessibility for non interactive elements


    if (onClick && event.target === event.currentTarget && isNonNativeButton() && event.key === ' ' && !event.defaultPrevented) {
      onClick(event);
    }
  });
  var ComponentProp = component;

  if (ComponentProp === 'button' && other.href) {
    ComponentProp = 'a';
  }

  var buttonProps = {};

  if (ComponentProp === 'button') {
    buttonProps.type = type;
    buttonProps.disabled = disabled;
  } else {
    if (ComponentProp !== 'a' || !other.href) {
      buttonProps.role = 'button';
    }

    buttonProps['aria-disabled'] = disabled;
  }

  var handleUserRef = Object(_utils_useForkRef__WEBPACK_IMPORTED_MODULE_7__["default"])(buttonRefProp, ref);
  var handleOwnRef = Object(_utils_useForkRef__WEBPACK_IMPORTED_MODULE_7__["default"])(focusVisibleRef, buttonRef);
  var handleRef = Object(_utils_useForkRef__WEBPACK_IMPORTED_MODULE_7__["default"])(handleUserRef, handleOwnRef);

  var _React$useState2 = react__WEBPACK_IMPORTED_MODULE_2__["useState"](false),
      mountedState = _React$useState2[0],
      setMountedState = _React$useState2[1];

  react__WEBPACK_IMPORTED_MODULE_2__["useEffect"](function () {
    setMountedState(true);
  }, []);
  var enableTouchRipple = mountedState && !disableRipple && !disabled;

  if (true) {
    // eslint-disable-next-line react-hooks/rules-of-hooks
    react__WEBPACK_IMPORTED_MODULE_2__["useEffect"](function () {
      if (enableTouchRipple && !rippleRef.current) {
        console.error(['Material-UI: The `component` prop provided to ButtonBase is invalid.', 'Please make sure the children prop is rendered in this custom component.'].join('\n'));
      }
    }, [enableTouchRipple]);
  }

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__["createElement"](ComponentProp, Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    className: Object(clsx__WEBPACK_IMPORTED_MODULE_5__["default"])(classes.root, className, focusVisible && [classes.focusVisible, focusVisibleClassName], disabled && classes.disabled),
    onBlur: handleBlur,
    onClick: onClick,
    onFocus: handleFocus,
    onKeyDown: handleKeyDown,
    onKeyUp: handleKeyUp,
    onMouseDown: handleMouseDown,
    onMouseLeave: handleMouseLeave,
    onMouseUp: handleMouseUp,
    onDragLeave: handleDragLeave,
    onTouchEnd: handleTouchEnd,
    onTouchMove: handleTouchMove,
    onTouchStart: handleTouchStart,
    ref: handleRef,
    tabIndex: disabled ? -1 : tabIndex
  }, buttonProps, other), children, enableTouchRipple ?
  /*#__PURE__*/

  /* TouchRipple is only needed client-side, x2 boost on the server. */
  react__WEBPACK_IMPORTED_MODULE_2__["createElement"](_TouchRipple__WEBPACK_IMPORTED_MODULE_11__["default"], Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    ref: rippleRef,
    center: centerRipple
  }, TouchRippleProps)) : null);
});
 true ? ButtonBase.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * A ref for imperative actions.
   * It currently only supports `focusVisible()` action.
   */
  action: _material_ui_utils__WEBPACK_IMPORTED_MODULE_6__["refType"],

  /**
   * @ignore
   *
   * Use that prop to pass a ref to the native button component.
   * @deprecated Use `ref` instead.
   */
  buttonRef: _material_ui_utils__WEBPACK_IMPORTED_MODULE_6__["refType"],

  /**
   * If `true`, the ripples will be centered.
   * They won't start at the cursor interaction position.
   */
  centerRipple: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.bool,

  /**
   * The content of the component.
   */
  children: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.node,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.object,

  /**
   * @ignore
   */
  className: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.string,

  /**
   * The component used for the root node.
   * Either a string to use a HTML element or a component.
   */
  component: _material_ui_utils__WEBPACK_IMPORTED_MODULE_6__["elementTypeAcceptingRef"],

  /**
   * If `true`, the base button will be disabled.
   */
  disabled: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.bool,

  /**
   * If `true`, the ripple effect will be disabled.
   *
   * ⚠️ Without a ripple there is no styling for :focus-visible by default. Be sure
   * to highlight the element by applying separate styles with the `focusVisibleClassName`.
   */
  disableRipple: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.bool,

  /**
   * If `true`, the touch ripple effect will be disabled.
   */
  disableTouchRipple: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.bool,

  /**
   * If `true`, the base button will have a keyboard focus ripple.
   */
  focusRipple: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.bool,

  /**
   * This prop can help a person know which element has the keyboard focus.
   * The class name will be applied when the element gain the focus through a keyboard interaction.
   * It's a polyfill for the [CSS :focus-visible selector](https://drafts.csswg.org/selectors-4/#the-focus-visible-pseudo).
   * The rationale for using this feature [is explained here](https://github.com/WICG/focus-visible/blob/master/explainer.md).
   * A [polyfill can be used](https://github.com/WICG/focus-visible) to apply a `focus-visible` class to other components
   * if needed.
   */
  focusVisibleClassName: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.string,

  /**
   * @ignore
   */
  href: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.string,

  /**
   * @ignore
   */
  onBlur: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.func,

  /**
   * @ignore
   */
  onClick: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.func,

  /**
   * @ignore
   */
  onDragLeave: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.func,

  /**
   * @ignore
   */
  onFocus: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.func,

  /**
   * Callback fired when the component is focused with a keyboard.
   * We trigger a `onFocus` callback too.
   */
  onFocusVisible: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.func,

  /**
   * @ignore
   */
  onKeyDown: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.func,

  /**
   * @ignore
   */
  onKeyUp: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.func,

  /**
   * @ignore
   */
  onMouseDown: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.func,

  /**
   * @ignore
   */
  onMouseLeave: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.func,

  /**
   * @ignore
   */
  onMouseUp: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.func,

  /**
   * @ignore
   */
  onTouchEnd: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.func,

  /**
   * @ignore
   */
  onTouchMove: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.func,

  /**
   * @ignore
   */
  onTouchStart: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.func,

  /**
   * @ignore
   */
  tabIndex: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.number, prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.string]),

  /**
   * Props applied to the `TouchRipple` element.
   */
  TouchRippleProps: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.object,

  /**
   * @ignore
   */
  type: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.oneOf(['button', 'reset', 'submit']), prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.string])
} : undefined;
/* harmony default export */ __webpack_exports__["default"] = (Object(_styles_withStyles__WEBPACK_IMPORTED_MODULE_9__["default"])(styles, {
  name: 'MuiButtonBase'
})(ButtonBase));

/***/ }),

/***/ "./node_modules/@material-ui/core/esm/ButtonBase/Ripple.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/ButtonBase/Ripple.js ***!
  \*****************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var clsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! clsx */ "./node_modules/clsx/dist/clsx.m.js");
/* harmony import */ var _utils_useEventCallback__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/useEventCallback */ "./node_modules/@material-ui/core/esm/utils/useEventCallback.js");




var useEnhancedEffect = typeof window === 'undefined' ? react__WEBPACK_IMPORTED_MODULE_0__["useEffect"] : react__WEBPACK_IMPORTED_MODULE_0__["useLayoutEffect"];
/**
 * @ignore - internal component.
 */

function Ripple(props) {
  var classes = props.classes,
      _props$pulsate = props.pulsate,
      pulsate = _props$pulsate === void 0 ? false : _props$pulsate,
      rippleX = props.rippleX,
      rippleY = props.rippleY,
      rippleSize = props.rippleSize,
      inProp = props.in,
      _props$onExited = props.onExited,
      onExited = _props$onExited === void 0 ? function () {} : _props$onExited,
      timeout = props.timeout;

  var _React$useState = react__WEBPACK_IMPORTED_MODULE_0__["useState"](false),
      leaving = _React$useState[0],
      setLeaving = _React$useState[1];

  var rippleClassName = Object(clsx__WEBPACK_IMPORTED_MODULE_2__["default"])(classes.ripple, classes.rippleVisible, pulsate && classes.ripplePulsate);
  var rippleStyles = {
    width: rippleSize,
    height: rippleSize,
    top: -(rippleSize / 2) + rippleY,
    left: -(rippleSize / 2) + rippleX
  };
  var childClassName = Object(clsx__WEBPACK_IMPORTED_MODULE_2__["default"])(classes.child, leaving && classes.childLeaving, pulsate && classes.childPulsate);
  var handleExited = Object(_utils_useEventCallback__WEBPACK_IMPORTED_MODULE_3__["default"])(onExited); // Ripple is used for user feedback (e.g. click or press) so we want to apply styles with the highest priority

  useEnhancedEffect(function () {
    if (!inProp) {
      // react-transition-group#onExit
      setLeaving(true); // react-transition-group#onExited

      var timeoutId = setTimeout(handleExited, timeout);
      return function () {
        clearTimeout(timeoutId);
      };
    }

    return undefined;
  }, [handleExited, inProp, timeout]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__["createElement"]("span", {
    className: rippleClassName,
    style: rippleStyles
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__["createElement"]("span", {
    className: childClassName
  }));
}

 true ? Ripple.propTypes = {
  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.object.isRequired,

  /**
   * @ignore - injected from TransitionGroup
   */
  in: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.bool,

  /**
   * @ignore - injected from TransitionGroup
   */
  onExited: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.func,

  /**
   * If `true`, the ripple pulsates, typically indicating the keyboard focus state of an element.
   */
  pulsate: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.bool,

  /**
   * Diameter of the ripple.
   */
  rippleSize: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.number,

  /**
   * Horizontal position of the ripple center.
   */
  rippleX: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.number,

  /**
   * Vertical position of the ripple center.
   */
  rippleY: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.number,

  /**
   * exit delay
   */
  timeout: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.number.isRequired
} : undefined;
/* harmony default export */ __webpack_exports__["default"] = (Ripple);

/***/ }),

/***/ "./node_modules/@material-ui/core/esm/ButtonBase/TouchRipple.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/ButtonBase/TouchRipple.js ***!
  \**********************************************************************/
/*! exports provided: DELAY_RIPPLE, styles, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DELAY_RIPPLE", function() { return DELAY_RIPPLE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "styles", function() { return styles; });
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/esm/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_esm_toConsumableArray__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/esm/toConsumableArray */ "./node_modules/@babel/runtime/helpers/esm/toConsumableArray.js");
/* harmony import */ var _babel_runtime_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/esm/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_transition_group__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react-transition-group */ "./node_modules/react-transition-group/esm/index.js");
/* harmony import */ var clsx__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! clsx */ "./node_modules/clsx/dist/clsx.m.js");
/* harmony import */ var _styles_withStyles__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../styles/withStyles */ "./node_modules/@material-ui/core/esm/styles/withStyles.js");
/* harmony import */ var _Ripple__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Ripple */ "./node_modules/@material-ui/core/esm/ButtonBase/Ripple.js");









var DURATION = 550;
var DELAY_RIPPLE = 80;
var styles = function styles(theme) {
  return {
    /* Styles applied to the root element. */
    root: {
      overflow: 'hidden',
      pointerEvents: 'none',
      position: 'absolute',
      zIndex: 0,
      top: 0,
      right: 0,
      bottom: 0,
      left: 0,
      borderRadius: 'inherit'
    },

    /* Styles applied to the internal `Ripple` components `ripple` class. */
    ripple: {
      opacity: 0,
      position: 'absolute'
    },

    /* Styles applied to the internal `Ripple` components `rippleVisible` class. */
    rippleVisible: {
      opacity: 0.3,
      transform: 'scale(1)',
      animation: "$enter ".concat(DURATION, "ms ").concat(theme.transitions.easing.easeInOut)
    },

    /* Styles applied to the internal `Ripple` components `ripplePulsate` class. */
    ripplePulsate: {
      animationDuration: "".concat(theme.transitions.duration.shorter, "ms")
    },

    /* Styles applied to the internal `Ripple` components `child` class. */
    child: {
      opacity: 1,
      display: 'block',
      width: '100%',
      height: '100%',
      borderRadius: '50%',
      backgroundColor: 'currentColor'
    },

    /* Styles applied to the internal `Ripple` components `childLeaving` class. */
    childLeaving: {
      opacity: 0,
      animation: "$exit ".concat(DURATION, "ms ").concat(theme.transitions.easing.easeInOut)
    },

    /* Styles applied to the internal `Ripple` components `childPulsate` class. */
    childPulsate: {
      position: 'absolute',
      left: 0,
      top: 0,
      animation: "$pulsate 2500ms ".concat(theme.transitions.easing.easeInOut, " 200ms infinite")
    },
    '@keyframes enter': {
      '0%': {
        transform: 'scale(0)',
        opacity: 0.1
      },
      '100%': {
        transform: 'scale(1)',
        opacity: 0.3
      }
    },
    '@keyframes exit': {
      '0%': {
        opacity: 1
      },
      '100%': {
        opacity: 0
      }
    },
    '@keyframes pulsate': {
      '0%': {
        transform: 'scale(1)'
      },
      '50%': {
        transform: 'scale(0.92)'
      },
      '100%': {
        transform: 'scale(1)'
      }
    }
  };
};
/**
 * @ignore - internal component.
 *
 * TODO v5: Make private
 */

var TouchRipple = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__["forwardRef"](function TouchRipple(props, ref) {
  var _props$center = props.center,
      centerProp = _props$center === void 0 ? false : _props$center,
      classes = props.classes,
      className = props.className,
      other = Object(_babel_runtime_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__["default"])(props, ["center", "classes", "className"]);

  var _React$useState = react__WEBPACK_IMPORTED_MODULE_3__["useState"]([]),
      ripples = _React$useState[0],
      setRipples = _React$useState[1];

  var nextKey = react__WEBPACK_IMPORTED_MODULE_3__["useRef"](0);
  var rippleCallback = react__WEBPACK_IMPORTED_MODULE_3__["useRef"](null);
  react__WEBPACK_IMPORTED_MODULE_3__["useEffect"](function () {
    if (rippleCallback.current) {
      rippleCallback.current();
      rippleCallback.current = null;
    }
  }, [ripples]); // Used to filter out mouse emulated events on mobile.

  var ignoringMouseDown = react__WEBPACK_IMPORTED_MODULE_3__["useRef"](false); // We use a timer in order to only show the ripples for touch "click" like events.
  // We don't want to display the ripple for touch scroll events.

  var startTimer = react__WEBPACK_IMPORTED_MODULE_3__["useRef"](null); // This is the hook called once the previous timeout is ready.

  var startTimerCommit = react__WEBPACK_IMPORTED_MODULE_3__["useRef"](null);
  var container = react__WEBPACK_IMPORTED_MODULE_3__["useRef"](null);
  react__WEBPACK_IMPORTED_MODULE_3__["useEffect"](function () {
    return function () {
      clearTimeout(startTimer.current);
    };
  }, []);
  var startCommit = react__WEBPACK_IMPORTED_MODULE_3__["useCallback"](function (params) {
    var pulsate = params.pulsate,
        rippleX = params.rippleX,
        rippleY = params.rippleY,
        rippleSize = params.rippleSize,
        cb = params.cb;
    setRipples(function (oldRipples) {
      return [].concat(Object(_babel_runtime_helpers_esm_toConsumableArray__WEBPACK_IMPORTED_MODULE_1__["default"])(oldRipples), [/*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__["createElement"](_Ripple__WEBPACK_IMPORTED_MODULE_8__["default"], {
        key: nextKey.current,
        classes: classes,
        timeout: DURATION,
        pulsate: pulsate,
        rippleX: rippleX,
        rippleY: rippleY,
        rippleSize: rippleSize
      })]);
    });
    nextKey.current += 1;
    rippleCallback.current = cb;
  }, [classes]);
  var start = react__WEBPACK_IMPORTED_MODULE_3__["useCallback"](function () {
    var event = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var cb = arguments.length > 2 ? arguments[2] : undefined;
    var _options$pulsate = options.pulsate,
        pulsate = _options$pulsate === void 0 ? false : _options$pulsate,
        _options$center = options.center,
        center = _options$center === void 0 ? centerProp || options.pulsate : _options$center,
        _options$fakeElement = options.fakeElement,
        fakeElement = _options$fakeElement === void 0 ? false : _options$fakeElement;

    if (event.type === 'mousedown' && ignoringMouseDown.current) {
      ignoringMouseDown.current = false;
      return;
    }

    if (event.type === 'touchstart') {
      ignoringMouseDown.current = true;
    }

    var element = fakeElement ? null : container.current;
    var rect = element ? element.getBoundingClientRect() : {
      width: 0,
      height: 0,
      left: 0,
      top: 0
    }; // Get the size of the ripple

    var rippleX;
    var rippleY;
    var rippleSize;

    if (center || event.clientX === 0 && event.clientY === 0 || !event.clientX && !event.touches) {
      rippleX = Math.round(rect.width / 2);
      rippleY = Math.round(rect.height / 2);
    } else {
      var _ref = event.touches ? event.touches[0] : event,
          clientX = _ref.clientX,
          clientY = _ref.clientY;

      rippleX = Math.round(clientX - rect.left);
      rippleY = Math.round(clientY - rect.top);
    }

    if (center) {
      rippleSize = Math.sqrt((2 * Math.pow(rect.width, 2) + Math.pow(rect.height, 2)) / 3); // For some reason the animation is broken on Mobile Chrome if the size if even.

      if (rippleSize % 2 === 0) {
        rippleSize += 1;
      }
    } else {
      var sizeX = Math.max(Math.abs((element ? element.clientWidth : 0) - rippleX), rippleX) * 2 + 2;
      var sizeY = Math.max(Math.abs((element ? element.clientHeight : 0) - rippleY), rippleY) * 2 + 2;
      rippleSize = Math.sqrt(Math.pow(sizeX, 2) + Math.pow(sizeY, 2));
    } // Touche devices


    if (event.touches) {
      // check that this isn't another touchstart due to multitouch
      // otherwise we will only clear a single timer when unmounting while two
      // are running
      if (startTimerCommit.current === null) {
        // Prepare the ripple effect.
        startTimerCommit.current = function () {
          startCommit({
            pulsate: pulsate,
            rippleX: rippleX,
            rippleY: rippleY,
            rippleSize: rippleSize,
            cb: cb
          });
        }; // Delay the execution of the ripple effect.


        startTimer.current = setTimeout(function () {
          if (startTimerCommit.current) {
            startTimerCommit.current();
            startTimerCommit.current = null;
          }
        }, DELAY_RIPPLE); // We have to make a tradeoff with this value.
      }
    } else {
      startCommit({
        pulsate: pulsate,
        rippleX: rippleX,
        rippleY: rippleY,
        rippleSize: rippleSize,
        cb: cb
      });
    }
  }, [centerProp, startCommit]);
  var pulsate = react__WEBPACK_IMPORTED_MODULE_3__["useCallback"](function () {
    start({}, {
      pulsate: true
    });
  }, [start]);
  var stop = react__WEBPACK_IMPORTED_MODULE_3__["useCallback"](function (event, cb) {
    clearTimeout(startTimer.current); // The touch interaction occurs too quickly.
    // We still want to show ripple effect.

    if (event.type === 'touchend' && startTimerCommit.current) {
      event.persist();
      startTimerCommit.current();
      startTimerCommit.current = null;
      startTimer.current = setTimeout(function () {
        stop(event, cb);
      });
      return;
    }

    startTimerCommit.current = null;
    setRipples(function (oldRipples) {
      if (oldRipples.length > 0) {
        return oldRipples.slice(1);
      }

      return oldRipples;
    });
    rippleCallback.current = cb;
  }, []);
  react__WEBPACK_IMPORTED_MODULE_3__["useImperativeHandle"](ref, function () {
    return {
      pulsate: pulsate,
      start: start,
      stop: stop
    };
  }, [pulsate, start, stop]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__["createElement"]("span", Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    className: Object(clsx__WEBPACK_IMPORTED_MODULE_6__["default"])(classes.root, className),
    ref: container
  }, other), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__["createElement"](react_transition_group__WEBPACK_IMPORTED_MODULE_5__["TransitionGroup"], {
    component: null,
    exit: true
  }, ripples));
});
 true ? TouchRipple.propTypes = {
  /**
   * If `true`, the ripple starts at the center of the component
   * rather than at the point of interaction.
   */
  center: prop_types__WEBPACK_IMPORTED_MODULE_4___default.a.bool,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: prop_types__WEBPACK_IMPORTED_MODULE_4___default.a.object.isRequired,

  /**
   * @ignore
   */
  className: prop_types__WEBPACK_IMPORTED_MODULE_4___default.a.string
} : undefined;
/* harmony default export */ __webpack_exports__["default"] = (Object(_styles_withStyles__WEBPACK_IMPORTED_MODULE_7__["default"])(styles, {
  flip: false,
  name: 'MuiTouchRipple'
})( /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__["memo"](TouchRipple)));

/***/ }),

/***/ "./node_modules/@material-ui/core/esm/ButtonBase/index.js":
/*!****************************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/ButtonBase/index.js ***!
  \****************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _ButtonBase__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ButtonBase */ "./node_modules/@material-ui/core/esm/ButtonBase/ButtonBase.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _ButtonBase__WEBPACK_IMPORTED_MODULE_0__["default"]; });



/***/ }),

/***/ "./node_modules/@material-ui/core/esm/ButtonGroup/ButtonGroup.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@material-ui/core/esm/ButtonGroup/ButtonGroup.js ***!
  \***********************************************************************/
/*! exports provided: styles, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "styles", function() { return styles; });
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/esm/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/esm/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_is__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-is */ "./node_modules/react-is/index.js");
/* harmony import */ var react_is__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_is__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var clsx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! clsx */ "./node_modules/clsx/dist/clsx.m.js");
/* harmony import */ var _utils_capitalize__WEBPACK_IMPORTED_MODULE_6__ = __webpack_requi