/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.abeth.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationConnectionRequest;
import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationConnectionResponse;
import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationReadRequest;
import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationReadResponse;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public abstract class CIPEncapsulationPacket
implements Message {
    protected final long sessionHandle;
    protected final long status;
    protected final List<Short> senderContext;
    protected final long options;

    public abstract Integer getCommandType();

    public CIPEncapsulationPacket(long sessionHandle, long status, List<Short> senderContext, long options) {
        this.sessionHandle = sessionHandle;
        this.status = status;
        this.senderContext = senderContext;
        this.options = options;
    }

    public long getSessionHandle() {
        return this.sessionHandle;
    }

    public long getStatus() {
        return this.status;
    }

    public List<Short> getSenderContext() {
        return this.senderContext;
    }

    public long getOptions() {
        return this.options;
    }

    protected abstract void serializeCIPEncapsulationPacketChild(WriteBuffer var1) throws SerializationException;

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("CIPEncapsulationPacket", new WithWriterArgs[0]);
        FieldWriterFactory.writeDiscriminatorField((String)"commandType", (Object)this.getCommandType(), (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        int packetLen = this.getLengthInBytes() - 28;
        FieldWriterFactory.writeImplicitField((String)"packetLen", (Object)packetLen, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        FieldWriterFactory.writeSimpleField((String)"sessionHandle", (Object)this.sessionHandle, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        FieldWriterFactory.writeSimpleField((String)"status", (Object)this.status, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        FieldWriterFactory.writeSimpleTypeArrayField((String)"senderContext", this.senderContext, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        FieldWriterFactory.writeSimpleField((String)"options", (Object)this.options, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)0L, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        this.serializeCIPEncapsulationPacketChild(writeBuffer);
        writeBuffer.popContext("CIPEncapsulationPacket", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        CIPEncapsulationPacket _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.senderContext != null) {
            lengthInBits += 8 * this.senderContext.size();
        }
        lengthInBits += 32;
        return lengthInBits += 32;
    }

    public static CIPEncapsulationPacket staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return CIPEncapsulationPacket.staticParse(readBuffer);
    }

    public static CIPEncapsulationPacket staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("CIPEncapsulationPacket", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        int commandType = (Integer)FieldReaderFactory.readDiscriminatorField((String)"commandType", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        int packetLen = (Integer)FieldReaderFactory.readImplicitField((String)"packetLen", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        long sessionHandle = (Long)FieldReaderFactory.readSimpleField((String)"sessionHandle", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        long status = (Long)FieldReaderFactory.readSimpleField((String)"status", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        List senderContext = FieldReaderFactory.readCountArrayField((String)"senderContext", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (long)8L, (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        long options = (Long)FieldReaderFactory.readSimpleField((String)"options", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        Long reservedField0 = (Long)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (Object)0L, (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        CIPEncapsulationPacketBuilder builder = null;
        if (EvaluationHelper.equals((Object)commandType, (Object)257)) {
            builder = CIPEncapsulationConnectionRequest.staticParseCIPEncapsulationPacketBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)commandType, (Object)513)) {
            builder = CIPEncapsulationConnectionResponse.staticParseCIPEncapsulationPacketBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)commandType, (Object)263)) {
            builder = CIPEncapsulationReadRequest.staticParseCIPEncapsulationPacketBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)commandType, (Object)519)) {
            builder = CIPEncapsulationReadResponse.staticParseCIPEncapsulationPacketBuilder(readBuffer, packetLen);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [commandType=" + commandType + "]");
        }
        readBuffer.closeContext("CIPEncapsulationPacket", new WithReaderArgs[0]);
        CIPEncapsulationPacket _cIPEncapsulationPacket = builder.build(sessionHandle, status, senderContext, options);
        return _cIPEncapsulationPacket;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CIPEncapsulationPacket)) {
            return false;
        }
        CIPEncapsulationPacket that = (CIPEncapsulationPacket)o;
        return this.getSessionHandle() == that.getSessionHandle() && this.getStatus() == that.getStatus() && this.getSenderContext() == that.getSenderContext() && this.getOptions() == that.getOptions();
    }

    public int hashCode() {
        return Objects.hash(this.getSessionHandle(), this.getStatus(), this.getSenderContext(), this.getOptions());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface CIPEncapsulationPacketBuilder {
        public CIPEncapsulationPacket build(long var1, long var3, List<Short> var5, long var6);
    }
}

