/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.examples;

import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.hslf.record.InteractiveInfo;
import org.apache.poi.hslf.record.InteractiveInfoAtom;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFSlide;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFSoundData;

public class SoundFinder {
    public static void main(String[] args) throws Exception {
        HSLFSlideShow ppt = new HSLFSlideShow((InputStream)new FileInputStream(args[0]));
        HSLFSoundData[] sounds = ppt.getSoundData();
        for (HSLFSlide slide : ppt.getSlides()) {
            for (HSLFShape shape : slide.getShapes()) {
                int soundRef = SoundFinder.getSoundReference(shape);
                if (soundRef == -1) continue;
                System.out.println("Slide[" + slide.getSlideNumber() + "], shape[" + shape.getShapeId() + "], soundRef: " + soundRef);
                System.out.println("  " + sounds[soundRef].getSoundName());
                System.out.println("  " + sounds[soundRef].getSoundType());
            }
        }
    }

    protected static int getSoundReference(HSLFShape shape) {
        int soundRef = -1;
        EscherContainerRecord spContainer = shape.getSpContainer();
        for (EscherRecord obj : spContainer.getChildRecords()) {
            if (obj.getRecordId() != -4079) continue;
            byte[] data = obj.serialize();
            for (Record record : Record.findChildRecords((byte[])data, (int)8, (int)(data.length - 8))) {
                InteractiveInfoAtom info;
                if (!(record instanceof InteractiveInfo) || (info = ((InteractiveInfo)record).getInteractiveInfoAtom()).getAction() != 6) continue;
                soundRef = info.getSoundRef();
            }
        }
        return soundRef;
    }
}

