/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import org.apache.poi.POIXMLException;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FontCharset;
import org.apache.poi.ss.usermodel.FontFamily;
import org.apache.poi.ss.usermodel.FontScheme;
import org.apache.poi.ss.usermodel.FontUnderline;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBooleanProperty;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFont;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFontName;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFontScheme;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFontSize;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTIntProperty;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTUnderlineProperty;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTVerticalAlignFontProperty;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STFontScheme;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STUnderlineValues;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STVerticalAlignRun;

public class XSSFFont
implements Font {
    public static final String DEFAULT_FONT_NAME = "Calibri";
    public static final short DEFAULT_FONT_SIZE = 11;
    public static final short DEFAULT_FONT_COLOR = IndexedColors.BLACK.getIndex();
    private CTFont ctFont;
    private short index;

    public XSSFFont(CTFont font) {
        this.ctFont = font;
        this.index = 0;
    }

    public XSSFFont(CTFont font, int index) {
        this.ctFont = font;
        this.index = (short)index;
    }

    protected XSSFFont() {
        this.ctFont = CTFont.Factory.newInstance();
        this.setFontName(DEFAULT_FONT_NAME);
        this.setFontHeight(11.0);
    }

    public CTFont getCTFont() {
        return this.ctFont;
    }

    public boolean getBold() {
        CTBooleanProperty bold = this.ctFont.sizeOfBArray() == 0 ? null : this.ctFont.getBArray(0);
        return bold != null && bold.getVal();
    }

    public byte getCharSet() {
        CTIntProperty charset = this.ctFont.sizeOfCharsetArray() == 0 ? null : this.ctFont.getCharsetArray(0);
        int val = charset == null ? FontCharset.ANSI.getValue() : FontCharset.valueOf((int)charset.getVal()).getValue();
        return (byte)val;
    }

    public short getColor() {
        CTColor color;
        CTColor cTColor = color = this.ctFont.sizeOfColorArray() == 0 ? null : this.ctFont.getColorArray(0);
        if (color == null) {
            return IndexedColors.BLACK.getIndex();
        }
        long index = color.getIndexed();
        if (index == (long)DEFAULT_FONT_COLOR) {
            return IndexedColors.BLACK.getIndex();
        }
        if (index == (long)IndexedColors.RED.getIndex()) {
            return IndexedColors.RED.getIndex();
        }
        return (short)index;
    }

    public XSSFColor getXSSFColor() {
        CTColor ctColor = this.ctFont.sizeOfColorArray() == 0 ? null : this.ctFont.getColorArray(0);
        return ctColor == null ? null : new XSSFColor(ctColor);
    }

    public short getThemeColor() {
        CTColor color = this.ctFont.sizeOfColorArray() == 0 ? null : this.ctFont.getColorArray(0);
        long index = color == null ? 0L : color.getTheme();
        return (short)index;
    }

    public short getFontHeight() {
        CTFontSize size;
        CTFontSize cTFontSize = size = this.ctFont.sizeOfSzArray() == 0 ? null : this.ctFont.getSzArray(0);
        if (size != null) {
            double fontHeight = size.getVal();
            return (short)(fontHeight * 20.0);
        }
        return 220;
    }

    public short getFontHeightInPoints() {
        return (short)(this.getFontHeight() / 20);
    }

    public String getFontName() {
        CTFontName name = this.ctFont.sizeOfNameArray() == 0 ? null : this.ctFont.getNameArray(0);
        return name == null ? DEFAULT_FONT_NAME : name.getVal();
    }

    public boolean getItalic() {
        CTBooleanProperty italic = this.ctFont.sizeOfIArray() == 0 ? null : this.ctFont.getIArray(0);
        return italic != null && italic.getVal();
    }

    public boolean getStrikeout() {
        CTBooleanProperty strike = this.ctFont.sizeOfStrikeArray() == 0 ? null : this.ctFont.getStrikeArray(0);
        return strike != null && strike.getVal();
    }

    public short getTypeOffset() {
        CTVerticalAlignFontProperty vAlign;
        CTVerticalAlignFontProperty cTVerticalAlignFontProperty = vAlign = this.ctFont.sizeOfVertAlignArray() == 0 ? null : this.ctFont.getVertAlignArray(0);
        if (vAlign != null) {
            int val = vAlign.getVal().intValue();
            switch (val) {
                case 1: {
                    return 0;
                }
                case 3: {
                    return 2;
                }
                case 2: {
                    return 1;
                }
            }
            throw new POIXMLException("Wrong offset value " + val);
        }
        return 0;
    }

    public byte getUnderline() {
        CTUnderlineProperty underline;
        CTUnderlineProperty cTUnderlineProperty = underline = this.ctFont.sizeOfUArray() == 0 ? null : this.ctFont.getUArray(0);
        if (underline != null) {
            FontUnderline val = FontUnderline.valueOf((int)underline.getVal().intValue());
            return val.getByteValue();
        }
        return 0;
    }

    public void setBold(boolean bold) {
        if (bold) {
            CTBooleanProperty ctBold = this.ctFont.sizeOfBArray() == 0 ? this.ctFont.addNewB() : this.ctFont.getBArray(0);
            ctBold.setVal(bold);
        } else {
            this.ctFont.setBArray(null);
        }
    }

    public void setBoldweight(short boldweight) {
        this.setBold(boldweight == 700);
    }

    public short getBoldweight() {
        return this.getBold() ? (short)700 : 400;
    }

    public void setCharSet(byte charset) {
        CTIntProperty charsetProperty = this.ctFont.sizeOfCharsetArray() == 0 ? this.ctFont.addNewCharset() : this.ctFont.getCharsetArray(0);
        switch (charset) {
            case 0: {
                charsetProperty.setVal(FontCharset.ANSI.getValue());
                break;
            }
            case 2: {
                charsetProperty.setVal(FontCharset.SYMBOL.getValue());
                break;
            }
            case 1: {
                charsetProperty.setVal(FontCharset.DEFAULT.getValue());
                break;
            }
            default: {
                throw new POIXMLException("Attention: an attempt to set a type of unknow charset and charset");
            }
        }
    }

    public void setCharSet(FontCharset charSet) {
        this.setCharSet((byte)charSet.getValue());
    }

    public void setColor(short color) {
        CTColor ctColor = this.ctFont.sizeOfColorArray() == 0 ? this.ctFont.addNewColor() : this.ctFont.getColorArray(0);
        switch (color) {
            case 32767: {
                ctColor.setIndexed((long)DEFAULT_FONT_COLOR);
                break;
            }
            case 10: {
                ctColor.setIndexed((long)IndexedColors.RED.getIndex());
                break;
            }
            default: {
                ctColor.setIndexed((long)color);
            }
        }
    }

    public void setColor(XSSFColor color) {
        if (color == null) {
            this.ctFont.setColorArray(null);
        } else {
            CTColor ctColor = this.ctFont.sizeOfColorArray() == 0 ? this.ctFont.addNewColor() : this.ctFont.getColorArray(0);
            ctColor.setRgb(color.getRgb());
        }
    }

    public void setFontHeight(short height) {
        this.setFontHeight((double)height / 20.0);
    }

    public void setFontHeight(double height) {
        CTFontSize fontSize = this.ctFont.sizeOfSzArray() == 0 ? this.ctFont.addNewSz() : this.ctFont.getSzArray(0);
        fontSize.setVal(height);
    }

    public void setFontHeightInPoints(short height) {
        this.setFontHeight((double)height);
    }

    public void setThemeColor(short theme) {
        CTColor ctColor = this.ctFont.sizeOfColorArray() == 0 ? this.ctFont.addNewColor() : this.ctFont.getColorArray(0);
        ctColor.setTheme((long)theme);
    }

    public void setFontName(String name) {
        CTFontName fontName = this.ctFont.sizeOfNameArray() == 0 ? this.ctFont.addNewName() : this.ctFont.getNameArray(0);
        fontName.setVal(name == null ? DEFAULT_FONT_NAME : name);
    }

    public void setItalic(boolean italic) {
        if (italic) {
            CTBooleanProperty bool = this.ctFont.sizeOfIArray() == 0 ? this.ctFont.addNewI() : this.ctFont.getIArray(0);
            bool.setVal(italic);
        } else {
            this.ctFont.setIArray(null);
        }
    }

    public void setStrikeout(boolean strikeout) {
        if (!strikeout) {
            this.ctFont.setStrikeArray(null);
        } else {
            CTBooleanProperty strike = this.ctFont.sizeOfStrikeArray() == 0 ? this.ctFont.addNewStrike() : this.ctFont.getStrikeArray(0);
            strike.setVal(strikeout);
        }
    }

    public void setTypeOffset(short offset) {
        if (offset == 0) {
            this.ctFont.setVertAlignArray(null);
        } else {
            CTVerticalAlignFontProperty offsetProperty = this.ctFont.sizeOfVertAlignArray() == 0 ? this.ctFont.addNewVertAlign() : this.ctFont.getVertAlignArray(0);
            switch (offset) {
                case 0: {
                    offsetProperty.setVal(STVerticalAlignRun.BASELINE);
                    break;
                }
                case 2: {
                    offsetProperty.setVal(STVerticalAlignRun.SUBSCRIPT);
                    break;
                }
                case 1: {
                    offsetProperty.setVal(STVerticalAlignRun.SUPERSCRIPT);
                }
            }
        }
    }

    public void setUnderline(byte underline) {
        this.setUnderline(FontUnderline.valueOf((byte)underline));
    }

    public void setUnderline(FontUnderline underline) {
        if (underline == FontUnderline.NONE && this.ctFont.sizeOfUArray() > 0) {
            this.ctFont.setUArray(null);
        } else {
            CTUnderlineProperty ctUnderline = this.ctFont.sizeOfUArray() == 0 ? this.ctFont.addNewU() : this.ctFont.getUArray(0);
            STUnderlineValues.Enum val = STUnderlineValues.Enum.forInt((int)underline.getValue());
            ctUnderline.setVal(val);
        }
    }

    public String toString() {
        return this.ctFont.toString();
    }

    public long putFont(StylesTable styles) {
        short idx;
        this.index = idx = (short)styles.putFont(this);
        return idx;
    }

    public FontScheme getScheme() {
        CTFontScheme scheme = this.ctFont.sizeOfSchemeArray() == 0 ? null : this.ctFont.getSchemeArray(0);
        return scheme == null ? FontScheme.NONE : FontScheme.valueOf((int)scheme.getVal().intValue());
    }

    public void setScheme(FontScheme scheme) {
        CTFontScheme ctFontScheme = this.ctFont.sizeOfSchemeArray() == 0 ? this.ctFont.addNewScheme() : this.ctFont.getSchemeArray(0);
        STFontScheme.Enum val = STFontScheme.Enum.forInt((int)scheme.getValue());
        ctFontScheme.setVal(val);
    }

    public int getFamily() {
        CTIntProperty family = this.ctFont.sizeOfFamilyArray() == 0 ? this.ctFont.addNewFamily() : this.ctFont.getFamilyArray(0);
        return family == null ? FontFamily.NOT_APPLICABLE.getValue() : FontFamily.valueOf((int)family.getVal()).getValue();
    }

    public void setFamily(int value) {
        CTIntProperty family = this.ctFont.sizeOfFamilyArray() == 0 ? this.ctFont.addNewFamily() : this.ctFont.getFamilyArray(0);
        family.setVal(value);
    }

    public void setFamily(FontFamily family) {
        this.setFamily(family.getValue());
    }

    public short getIndex() {
        return this.index;
    }

    public int hashCode() {
        return this.ctFont.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof XSSFFont)) {
            return false;
        }
        XSSFFont cf = (XSSFFont)o;
        return this.ctFont.toString().equals(cf.getCTFont().toString());
    }
}

