/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.util.Internal;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.xmlbeans.XmlCursor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFont;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRElt;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRPrElt;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRst;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STXstring;

public class XSSFRichTextString
implements RichTextString {
    private static final Pattern utfPtrn = Pattern.compile("_x([0-9A-F]{4})_");
    private CTRst st;
    private StylesTable styles;

    public XSSFRichTextString(String str) {
        this.st = CTRst.Factory.newInstance();
        this.st.setT(str);
        XSSFRichTextString.preserveSpaces(this.st.xgetT());
    }

    public XSSFRichTextString() {
        this.st = CTRst.Factory.newInstance();
    }

    public XSSFRichTextString(CTRst st) {
        this.st = st;
    }

    public void applyFont(int startIndex, int endIndex, short fontIndex) {
        XSSFFont font;
        if (this.styles == null) {
            font = new XSSFFont();
            font.setFontName("#" + fontIndex);
        } else {
            font = this.styles.getFontAt(fontIndex);
        }
        this.applyFont(startIndex, endIndex, font);
    }

    public void applyFont(int startIndex, int endIndex, Font font) {
        if (startIndex > endIndex) {
            throw new IllegalArgumentException("Start index must be less than end index.");
        }
        if (startIndex < 0 || endIndex > this.length()) {
            throw new IllegalArgumentException("Start and end index not in range.");
        }
        if (startIndex == endIndex) {
            return;
        }
        if (this.st.sizeOfRArray() == 0 && this.st.isSetT()) {
            this.st.addNewR().setT(this.st.getT());
            this.st.unsetT();
        }
        String text = this.getString();
        XSSFFont xssfFont = (XSSFFont)font;
        ArrayList<CTRElt> runs = new ArrayList<CTRElt>();
        CTRElt[] r = new CTRElt[this.st.getRList().size()];
        this.st.getRList().toArray(r);
        int pos = 0;
        for (int i = 0; i < r.length; ++i) {
            int rStart = pos;
            String t = r[i].getT();
            int rEnd = rStart + t.length();
            if (rEnd <= startIndex) {
                runs.add(r[i]);
                pos += r[i].getT().length();
                continue;
            }
            if (startIndex <= rStart || startIndex >= rEnd) break;
            CTRElt c = (CTRElt)r[i].copy();
            String txt = text.substring(rStart, startIndex);
            c.setT(txt);
            runs.add(c);
            pos += txt.length();
        }
        CTRElt rt = CTRElt.Factory.newInstance();
        String txt = text.substring(startIndex, endIndex);
        rt.setT(txt);
        CTRPrElt pr = rt.addNewRPr();
        this.setRunAttributes(xssfFont.getCTFont(), pr);
        runs.add(rt);
        pos += txt.length();
        for (int i = 0; i < r.length; ++i) {
            int rStart = pos;
            String t = r[i].getT();
            int rEnd = Math.min(rStart + t.length(), text.length());
            if (endIndex >= rEnd) continue;
            CTRElt c = (CTRElt)r[i].copy();
            txt = text.substring(rStart, rEnd);
            c.setT(txt);
            runs.add(c);
            pos += txt.length();
            XSSFRichTextString.preserveSpaces(c.xgetT());
        }
        this.st.setRArray(runs.toArray(new CTRElt[runs.size()]));
    }

    public void applyFont(Font font) {
        if (this.st.sizeOfRArray() == 0 && this.st.isSetT()) {
            CTRElt r = this.st.addNewR();
            r.setT(this.st.getT());
            this.setRunAttributes(((XSSFFont)font).getCTFont(), r.addNewRPr());
            this.st.unsetT();
        } else {
            CTRElt r = CTRElt.Factory.newInstance();
            r.setT(this.getString());
            this.setRunAttributes(((XSSFFont)font).getCTFont(), r.addNewRPr());
            this.st.setRArray(new CTRElt[]{r});
        }
    }

    public void applyFont(short fontIndex) {
        XSSFFont font;
        if (this.styles == null) {
            font = new XSSFFont();
            font.setFontName("#" + fontIndex);
        } else {
            font = this.styles.getFontAt(fontIndex);
        }
        this.applyFont(font);
    }

    public void append(String text, XSSFFont font) {
        if (this.st.sizeOfRArray() == 0 && this.st.isSetT()) {
            this.st.addNewR().setT(this.st.getT());
            this.st.unsetT();
        }
        CTRElt lt = this.st.addNewR();
        lt.setT(text);
        CTRPrElt pr = lt.addNewRPr();
        if (font != null) {
            this.setRunAttributes(font.getCTFont(), pr);
        }
    }

    public void append(String text) {
        this.append(text, null);
    }

    private void setRunAttributes(CTFont ctFont, CTRPrElt pr) {
        if (ctFont.sizeOfBArray() > 0) {
            pr.addNewB().setVal(ctFont.getBArray(0).getVal());
        }
        if (ctFont.sizeOfUArray() > 0) {
            pr.addNewU().setVal(ctFont.getUArray(0).getVal());
        }
        if (ctFont.sizeOfIArray() > 0) {
            pr.addNewI().setVal(ctFont.getIArray(0).getVal());
        }
        if (ctFont.sizeOfColorArray() > 0) {
            CTColor c1 = ctFont.getColorArray(0);
            CTColor c2 = pr.addNewColor();
            if (c1.isSetAuto()) {
                c2.setAuto(c1.getAuto());
            }
            if (c1.isSetIndexed()) {
                c2.setIndexed(c1.getIndexed());
            }
            if (c1.isSetRgb()) {
                c2.setRgb(c1.getRgb());
            }
            if (c1.isSetTheme()) {
                c2.setTheme(c1.getTheme());
            }
            if (c1.isSetTint()) {
                c2.setTint(c1.getTint());
            }
        }
        if (ctFont.sizeOfSzArray() > 0) {
            pr.addNewSz().setVal(ctFont.getSzArray(0).getVal());
        }
        if (ctFont.sizeOfNameArray() > 0) {
            pr.addNewRFont().setVal(ctFont.getNameArray(0).getVal());
        }
        if (ctFont.sizeOfFamilyArray() > 0) {
            pr.addNewFamily().setVal(ctFont.getFamilyArray(0).getVal());
        }
        if (ctFont.sizeOfSchemeArray() > 0) {
            pr.addNewScheme().setVal(ctFont.getSchemeArray(0).getVal());
        }
        if (ctFont.sizeOfCharsetArray() > 0) {
            pr.addNewCharset().setVal(ctFont.getCharsetArray(0).getVal());
        }
        if (ctFont.sizeOfCondenseArray() > 0) {
            pr.addNewCondense().setVal(ctFont.getCondenseArray(0).getVal());
        }
        if (ctFont.sizeOfExtendArray() > 0) {
            pr.addNewExtend().setVal(ctFont.getExtendArray(0).getVal());
        }
        if (ctFont.sizeOfVertAlignArray() > 0) {
            pr.addNewVertAlign().setVal(ctFont.getVertAlignArray(0).getVal());
        }
        if (ctFont.sizeOfOutlineArray() > 0) {
            pr.addNewOutline().setVal(ctFont.getOutlineArray(0).getVal());
        }
        if (ctFont.sizeOfShadowArray() > 0) {
            pr.addNewShadow().setVal(ctFont.getShadowArray(0).getVal());
        }
        if (ctFont.sizeOfStrikeArray() > 0) {
            pr.addNewStrike().setVal(ctFont.getStrikeArray(0).getVal());
        }
    }

    public void clearFormatting() {
        String text = this.getString();
        while (this.st.sizeOfRArray() > 0) {
            this.st.removeR(this.st.sizeOfRArray() - 1);
        }
        this.st.setT(text);
    }

    public int getIndexOfFormattingRun(int index) {
        if (this.st.sizeOfRArray() == 0) {
            return 0;
        }
        int pos = 0;
        for (int i = 0; i < this.st.sizeOfRArray(); ++i) {
            CTRElt r = this.st.getRArray(i);
            if (i == index) {
                return pos;
            }
            pos += r.getT().length();
        }
        return -1;
    }

    public int getLengthOfFormattingRun(int index) {
        if (this.st.sizeOfRArray() == 0) {
            return this.length();
        }
        for (int i = 0; i < this.st.sizeOfRArray(); ++i) {
            CTRElt r = this.st.getRArray(i);
            if (i != index) continue;
            return r.getT().length();
        }
        return -1;
    }

    public String getString() {
        if (this.st.sizeOfRArray() == 0) {
            return XSSFRichTextString.utfDecode(this.st.getT());
        }
        StringBuffer buf = new StringBuffer();
        for (CTRElt r : this.st.getRList()) {
            buf.append(r.getT());
        }
        return XSSFRichTextString.utfDecode(buf.toString());
    }

    public void setString(String s) {
        this.clearFormatting();
        this.st.setT(s);
        XSSFRichTextString.preserveSpaces(this.st.xgetT());
    }

    public String toString() {
        return this.getString();
    }

    public int length() {
        return this.getString().length();
    }

    public int numFormattingRuns() {
        return this.st.sizeOfRArray();
    }

    public XSSFFont getFontOfFormattingRun(int index) {
        if (this.st.sizeOfRArray() == 0) {
            return null;
        }
        for (int i = 0; i < this.st.sizeOfRArray(); ++i) {
            CTRElt r = this.st.getRArray(i);
            if (i != index) continue;
            return new XSSFFont(XSSFRichTextString.toCTFont(r.getRPr()));
        }
        return null;
    }

    public XSSFFont getFontAtIndex(int index) {
        if (this.st.sizeOfRArray() == 0) {
            return null;
        }
        int pos = 0;
        for (int i = 0; i < this.st.sizeOfRArray(); ++i) {
            CTRElt r = this.st.getRArray(i);
            if (index >= pos && index < pos + r.getT().length()) {
                return new XSSFFont(XSSFRichTextString.toCTFont(r.getRPr()));
            }
            pos += r.getT().length();
        }
        return null;
    }

    @Internal
    public CTRst getCTRst() {
        return this.st;
    }

    protected void setStylesTableReference(StylesTable tbl) {
        this.styles = tbl;
        if (this.st.sizeOfRArray() > 0) {
            for (CTRElt r : this.st.getRList()) {
                String fontName;
                CTRPrElt pr = r.getRPr();
                if (pr == null || !(fontName = pr.getRFontArray(0).getVal()).startsWith("#")) continue;
                int idx = Integer.parseInt(fontName.substring(1));
                XSSFFont font = this.styles.getFontAt(idx);
                pr.removeRFont(0);
                this.setRunAttributes(font.getCTFont(), pr);
            }
        }
    }

    protected static CTFont toCTFont(CTRPrElt pr) {
        CTFont ctFont = CTFont.Factory.newInstance();
        if (pr.sizeOfBArray() > 0) {
            ctFont.addNewB().setVal(pr.getBArray(0).getVal());
        }
        if (pr.sizeOfUArray() > 0) {
            ctFont.addNewU().setVal(pr.getUArray(0).getVal());
        }
        if (pr.sizeOfIArray() > 0) {
            ctFont.addNewI().setVal(pr.getIArray(0).getVal());
        }
        if (pr.sizeOfColorArray() > 0) {
            CTColor c1 = pr.getColorArray(0);
            CTColor c2 = ctFont.addNewColor();
            if (c1.isSetAuto()) {
                c2.setAuto(c1.getAuto());
            }
            if (c1.isSetIndexed()) {
                c2.setIndexed(c1.getIndexed());
            }
            if (c1.isSetRgb()) {
                c2.setRgb(c1.getRgb());
            }
            if (c1.isSetTheme()) {
                c2.setTheme(c1.getTheme());
            }
            if (c1.isSetTint()) {
                c2.setTint(c1.getTint());
            }
        }
        if (pr.sizeOfSzArray() > 0) {
            ctFont.addNewSz().setVal(pr.getSzArray(0).getVal());
        }
        if (pr.sizeOfRFontArray() > 0) {
            ctFont.addNewName().setVal(pr.getRFontArray(0).getVal());
        }
        if (pr.sizeOfFamilyArray() > 0) {
            ctFont.addNewFamily().setVal(pr.getFamilyArray(0).getVal());
        }
        if (pr.sizeOfSchemeArray() > 0) {
            ctFont.addNewScheme().setVal(pr.getSchemeArray(0).getVal());
        }
        if (pr.sizeOfCharsetArray() > 0) {
            ctFont.addNewCharset().setVal(pr.getCharsetArray(0).getVal());
        }
        if (pr.sizeOfCondenseArray() > 0) {
            ctFont.addNewCondense().setVal(pr.getCondenseArray(0).getVal());
        }
        if (pr.sizeOfExtendArray() > 0) {
            ctFont.addNewExtend().setVal(pr.getExtendArray(0).getVal());
        }
        if (pr.sizeOfVertAlignArray() > 0) {
            ctFont.addNewVertAlign().setVal(pr.getVertAlignArray(0).getVal());
        }
        if (pr.sizeOfOutlineArray() > 0) {
            ctFont.addNewOutline().setVal(pr.getOutlineArray(0).getVal());
        }
        if (pr.sizeOfShadowArray() > 0) {
            ctFont.addNewShadow().setVal(pr.getShadowArray(0).getVal());
        }
        if (pr.sizeOfStrikeArray() > 0) {
            ctFont.addNewStrike().setVal(pr.getStrikeArray(0).getVal());
        }
        return ctFont;
    }

    protected static void preserveSpaces(STXstring xs) {
        String text = xs.getStringValue();
        if (text != null && (text.startsWith(" ") || text.endsWith(" "))) {
            XmlCursor c = xs.newCursor();
            c.toNextToken();
            c.insertAttributeWithValue(new QName("http://www.w3.org/XML/1998/namespace", "space"), "preserve");
            c.dispose();
        }
    }

    static String utfDecode(String value) {
        if (value == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        Matcher m = utfPtrn.matcher(value);
        int idx = 0;
        while (m.find()) {
            int pos = m.start();
            if (pos > idx) {
                buf.append(value.substring(idx, pos));
            }
            String code = m.group(1);
            int icode = Integer.decode("0x" + code);
            buf.append((char)icode);
            idx = m.end();
        }
        buf.append(value.substring(idx));
        return buf.toString();
    }
}

