/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.poi.hwpf.model.GenericPropertyNode;
import org.apache.poi.hwpf.model.PieceDescriptor;
import org.apache.poi.hwpf.model.PlexOfCps;
import org.apache.poi.hwpf.model.TextPiece;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;

public class TextPieceTable {
    protected ArrayList _textPieces = new ArrayList();
    int _cpMin;

    public TextPieceTable() {
    }

    public TextPieceTable(byte[] documentStream, byte[] tableStream, int offset, int size, int fcMin) throws UnsupportedEncodingException {
        int x;
        PlexOfCps pieceTable = new PlexOfCps(tableStream, offset, size, PieceDescriptor.getSizeInBytes());
        int length = pieceTable.length();
        PieceDescriptor[] pieces = new PieceDescriptor[length];
        for (x = 0; x < length; ++x) {
            GenericPropertyNode node = pieceTable.getProperty(x);
            pieces[x] = new PieceDescriptor(node.getBytes(), 0);
        }
        this._cpMin = pieces[0].getFilePosition() - fcMin;
        for (x = 0; x < pieces.length; ++x) {
            int start = pieces[x].getFilePosition() - fcMin;
            if (start >= this._cpMin) continue;
            this._cpMin = start;
        }
        for (x = 0; x < pieces.length; ++x) {
            int start = pieces[x].getFilePosition();
            GenericPropertyNode node = pieceTable.getProperty(x);
            int nodeStartChars = node.getStart();
            int nodeEndChars = node.getEnd();
            boolean unicode = pieces[x].isUnicode();
            int multiple = 1;
            if (unicode) {
                multiple = 2;
            }
            int textSizeChars = nodeEndChars - nodeStartChars;
            int textSizeBytes = textSizeChars * multiple;
            byte[] buf = new byte[textSizeBytes];
            System.arraycopy(documentStream, start, buf, 0, textSizeBytes);
            this._textPieces.add(new TextPiece(nodeStartChars, nodeEndChars, buf, pieces[x], node.getStart()));
        }
        Object[] tp = this._textPieces.toArray(new TextPiece[this._textPieces.size()]);
        Arrays.sort(tp);
        for (int i = 0; i < tp.length; ++i) {
            this._textPieces.set(i, tp[i]);
        }
    }

    public int getCpMin() {
        return this._cpMin;
    }

    public List getTextPieces() {
        return this._textPieces;
    }

    public boolean isUnicodeAtCharOffset(int cp) {
        boolean lastWas = false;
        for (TextPiece tp : this._textPieces) {
            if (tp.getStart() <= cp && tp.getEnd() >= cp) {
                return tp.isUnicode();
            }
            lastWas = tp.isUnicode();
        }
        return lastWas;
    }

    public boolean isUnicodeAtByteOffset(int bytePos) {
        boolean lastWas = false;
        int curByte = 0;
        for (TextPiece tp : this._textPieces) {
            int nextByte = curByte + tp.bytesLength();
            if (curByte <= bytePos && nextByte >= bytePos) {
                return tp.isUnicode();
            }
            lastWas = tp.isUnicode();
            curByte = nextByte;
        }
        return lastWas;
    }

    public byte[] writeTo(HWPFOutputStream docStream) throws IOException {
        PlexOfCps textPlex = new PlexOfCps(PieceDescriptor.getSizeInBytes());
        int size = this._textPieces.size();
        for (int x = 0; x < size; ++x) {
            TextPiece next = (TextPiece)this._textPieces.get(x);
            PieceDescriptor pd = next.getPieceDescriptor();
            int offset = docStream.getOffset();
            int mod = offset % 512;
            if (mod != 0) {
                mod = 512 - mod;
                byte[] buf = new byte[mod];
                docStream.write(buf);
            }
            pd.setFilePosition(docStream.getOffset());
            docStream.write(next.getRawBytes());
            int nodeStart = next.getStart();
            int nodeEnd = next.getEnd();
            textPlex.addProperty(new GenericPropertyNode(nodeStart, nodeEnd, pd.toByteArray()));
        }
        return textPlex.toByteArray();
    }

    public int adjustForInsert(int listIndex, int length) {
        int size = this._textPieces.size();
        TextPiece tp = (TextPiece)this._textPieces.get(listIndex);
        tp.setEnd(tp.getEnd() + length);
        for (int x = listIndex + 1; x < size; ++x) {
            tp = (TextPiece)this._textPieces.get(x);
            tp.setStart(tp.getStart() + length);
            tp.setEnd(tp.getEnd() + length);
        }
        return length;
    }

    public boolean equals(Object o) {
        TextPieceTable tpt = (TextPieceTable)o;
        int size = tpt._textPieces.size();
        if (size == this._textPieces.size()) {
            for (int x = 0; x < size; ++x) {
                if (tpt._textPieces.get(x).equals(this._textPieces.get(x))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

