/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hsmf.datatypes;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.poi.hsmf.datatypes.ByteChunk;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.ChunkGroup;
import org.apache.poi.hsmf.datatypes.StringChunk;

public class AttachmentChunks
implements ChunkGroup {
    public static final String PREFIX = "__attach_version1.0_#";
    public static final int ATTACH_DATA = 14081;
    public static final int ATTACH_EXTENSION = 14083;
    public static final int ATTACH_FILENAME = 14084;
    public static final int ATTACH_LONG_FILENAME = 14087;
    public static final int ATTACH_RENDERING_WMF = 14089;
    public static final int ATTACH_MIME_TAG = 14094;
    public ByteChunk attachData;
    public StringChunk attachExtension;
    public StringChunk attachFileName;
    public StringChunk attachLongFileName;
    public StringChunk attachMimeTag;
    public ByteChunk attachRenderingWMF;
    private String poifsName;
    private List<Chunk> allChunks = new ArrayList<Chunk>();

    public AttachmentChunks(String poifsName) {
        this.poifsName = poifsName;
    }

    public Chunk[] getAll() {
        return this.allChunks.toArray(new Chunk[this.allChunks.size()]);
    }

    public Chunk[] getChunks() {
        return this.getAll();
    }

    public String getPOIFSName() {
        return this.poifsName;
    }

    public void record(Chunk chunk) {
        switch (chunk.getChunkId()) {
            case 14081: {
                this.attachData = (ByteChunk)chunk;
                break;
            }
            case 14083: {
                this.attachExtension = (StringChunk)chunk;
                break;
            }
            case 14084: {
                this.attachFileName = (StringChunk)chunk;
                break;
            }
            case 14087: {
                this.attachLongFileName = (StringChunk)chunk;
                break;
            }
            case 14094: {
                this.attachMimeTag = (StringChunk)chunk;
                break;
            }
            case 14089: {
                this.attachRenderingWMF = (ByteChunk)chunk;
            }
        }
        this.allChunks.add(chunk);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AttachmentChunksSorter
    implements Comparator<AttachmentChunks> {
        @Override
        public int compare(AttachmentChunks a, AttachmentChunks b) {
            return a.poifsName.compareTo(b.poifsName);
        }
    }
}

