/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hsmf.datatypes;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.StringUtil;

public class StringChunk
extends Chunk {
    private String value;

    public StringChunk(String namePrefix, int chunkId, int type) {
        super(namePrefix, chunkId, type);
    }

    public StringChunk(int chunkId, int type) {
        super(chunkId, type);
    }

    public void readValue(InputStream value) throws IOException {
        String tmpValue;
        byte[] data = IOUtils.toByteArray((InputStream)value);
        switch (this.type) {
            case 30: {
                tmpValue = StringChunk.parseAs7BitData(data);
                break;
            }
            case 31: {
                tmpValue = StringUtil.getFromUnicodeLE((byte[])data);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type " + this.type + " for String Chunk");
            }
        }
        this.value = tmpValue.replace("\u0000", "");
    }

    public void writeValue(OutputStream out) throws IOException {
        byte[] data;
        switch (this.type) {
            case 30: {
                try {
                    data = this.value.getBytes("CP1252");
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Core encoding not found, JVM broken?", e);
                }
            }
            case 31: {
                data = new byte[this.value.length() * 2];
                StringUtil.putUnicodeLE((String)this.value, (byte[])data, (int)0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type " + this.type + " for String Chunk");
            }
        }
        out.write(data);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    protected static String parseAs7BitData(byte[] data) {
        try {
            return new String(data, "CP1252");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Core encoding not found, JVM broken?", e);
        }
    }
}

