/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hmef;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hmef.Attachment;
import org.apache.poi.hmef.Attribute;
import org.apache.poi.hmef.MAPIAttribute;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.poi.util.LittleEndian;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HMEFMessage {
    public static final long HEADER_SIGNATURE = 574529400L;
    private int fileId;
    private List<Attribute> messageAttributes = new ArrayList<Attribute>();
    private List<MAPIAttribute> mapiAttributes = new ArrayList<MAPIAttribute>();
    private List<Attachment> attachments = new ArrayList<Attachment>();

    public HMEFMessage(InputStream inp) throws IOException {
        long sig = LittleEndian.readInt((InputStream)inp);
        if (sig != 574529400L) {
            throw new IllegalArgumentException("TNEF signature not detected in file, expected 574529400 but got " + sig);
        }
        this.fileId = LittleEndian.readUShort((InputStream)inp);
        this.process(inp, 0);
        for (Attribute attr : this.messageAttributes) {
            if (attr.getId() != Attribute.ID_MAPIPROPERTIES) continue;
            this.mapiAttributes.addAll(MAPIAttribute.create(attr));
        }
        for (Attachment attachment : this.attachments) {
            for (Attribute attr : attachment.getAttributes()) {
                if (attr.getId() != Attribute.ID_MAPIPROPERTIES) continue;
                attachment.getMAPIAttributes().addAll(MAPIAttribute.create(attr));
            }
        }
    }

    private void process(InputStream inp, int lastLevel) throws IOException {
        int level = inp.read();
        if (level == -1) {
            return;
        }
        Attribute attr = new Attribute(inp);
        if (level == 1) {
            this.messageAttributes.add(attr);
        } else if (level == 2) {
            if (this.attachments.size() == 0 || attr.getId() == Attribute.ID_ATTACHRENDERDATA) {
                this.attachments.add(new Attachment());
            }
            this.attachments.get(this.attachments.size() - 1).addAttribute(attr);
        } else {
            throw new IllegalStateException("Unhandled level " + level);
        }
        this.process(inp, level);
    }

    public List<Attribute> getMessageAttributes() {
        return this.messageAttributes;
    }

    public List<MAPIAttribute> getMessageMAPIAttributes() {
        return this.mapiAttributes;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public Attribute getMessageAttribute(Attribute.AttributeID id) {
        for (Attribute attr : this.messageAttributes) {
            if (attr.getId() != id) continue;
            return attr;
        }
        return null;
    }

    public MAPIAttribute getMessageMAPIAttribute(MAPIProperty id) {
        for (MAPIAttribute attr : this.mapiAttributes) {
            if (attr.getProperty() != id) continue;
            return attr;
        }
        return null;
    }
}

