/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hmef;

import java.io.UnsupportedEncodingException;
import org.apache.poi.hmef.MAPIAttribute;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.poi.util.StringUtil;

public final class MAPIStringAttribute
extends MAPIAttribute {
    private static final String CODEPAGE = "CP1252";
    private final String data;

    public MAPIStringAttribute(MAPIProperty property, int type, byte[] data) {
        super(property, type, data);
        String tmpData = null;
        if (type == 30) {
            try {
                tmpData = new String(data, CODEPAGE);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("JVM Broken - core encoding CP1252 missing");
            }
        } else if (type == 31) {
            tmpData = StringUtil.getFromUnicodeLE((byte[])data);
        } else {
            throw new IllegalArgumentException("Not a string type " + type);
        }
        if (tmpData.endsWith("\u0000")) {
            tmpData = tmpData.substring(0, tmpData.length() - 1);
        }
        this.data = tmpData;
    }

    public String getDataString() {
        return this.data;
    }

    public String toString() {
        return this.getProperty().toString() + " " + this.data;
    }
}

