/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.poi.hwpf.model.FileInformationBlock;
import org.apache.poi.hwpf.model.GenericPropertyNode;
import org.apache.poi.hwpf.model.PlexOfCps;
import org.apache.poi.hwpf.model.PlexOfField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldsTables {
    public static final int PLCFFLDATN = 0;
    public static final int PLCFFLDEDN = 1;
    public static final int PLCFFLDFTN = 2;
    public static final int PLCFFLDHDR = 3;
    public static final int PLCFFLDHDRTXBX = 4;
    public static final int PLCFFLDMOM = 5;
    public static final int PLCFFLDTXBX = 6;
    private static final int FLD_SIZE = 2;
    private HashMap<Integer, ArrayList<PlexOfField>> _tables = new HashMap();

    public FieldsTables(byte[] tableStream, FileInformationBlock fib) {
        for (int i = 0; i <= 6; ++i) {
            this._tables.put(i, this.readPLCF(tableStream, fib, i));
        }
    }

    public ArrayList<PlexOfField> getFieldsPLCF(int type) {
        return this._tables.get(type);
    }

    private ArrayList<PlexOfField> readPLCF(byte[] tableStream, FileInformationBlock fib, int type) {
        int start = 0;
        int length = 0;
        switch (type) {
            case 0: {
                start = fib.getFcPlcffldAtn();
                length = fib.getLcbPlcffldAtn();
                break;
            }
            case 1: {
                start = fib.getFcPlcffldEdn();
                length = fib.getLcbPlcffldEdn();
                break;
            }
            case 2: {
                start = fib.getFcPlcffldFtn();
                length = fib.getLcbPlcffldFtn();
                break;
            }
            case 3: {
                start = fib.getFcPlcffldHdr();
                length = fib.getLcbPlcffldHdr();
                break;
            }
            case 4: {
                start = fib.getFcPlcffldHdrtxbx();
                length = fib.getLcbPlcffldHdrtxbx();
                break;
            }
            case 5: {
                start = fib.getFcPlcffldMom();
                length = fib.getLcbPlcffldMom();
                break;
            }
            case 6: {
                start = fib.getFcPlcffldTxbx();
                length = fib.getLcbPlcffldTxbx();
            }
        }
        ArrayList<PlexOfField> fields = new ArrayList<PlexOfField>();
        if (start > 0 && length > 0) {
            PlexOfCps plcf = new PlexOfCps(tableStream, start, length, 2);
            fields.ensureCapacity(plcf.length());
            for (int i = 0; i < plcf.length(); ++i) {
                GenericPropertyNode propNode = plcf.getProperty(i);
                PlexOfField plex = new PlexOfField(propNode.getStart(), propNode.getEnd(), propNode.getBytes());
                fields.add(plex);
            }
        }
        return fields;
    }
}

