/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests;

import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.pulsar.buildtools.shaded.org.apache.commons.lang3.StringUtils;
import org.testng.ITestResult;
import org.testng.SkipException;
import org.testng.util.RetryAnalyzerCount;

public class RetryAnalyzer
extends RetryAnalyzerCount {
    static final int MAX_RETRIES = Integer.parseInt(System.getProperty("testRetryCount", "1"));
    private static final Pattern TEST_FILE_PATTERN = Pattern.compile("^.*src/test/java/(.*)\\.java$");
    private static final Set<String> CHANGED_TEST_CLASSES = Optional.ofNullable(System.getenv("CHANGED_TESTS")).map(changedTestsCsv -> Collections.unmodifiableSet(Arrays.stream(StringUtils.split(changedTestsCsv)).map(path -> {
        Matcher matcher = TEST_FILE_PATTERN.matcher((CharSequence)path);
        if (matcher.matches()) {
            return matcher.group(1).replace('/', '.');
        }
        return null;
    }).filter(Objects::nonNull).collect(Collectors.toSet()))).orElse(Collections.emptySet());

    public RetryAnalyzer() {
        this.setCount(MAX_RETRIES);
    }

    public boolean retry(ITestResult result) {
        if (CHANGED_TEST_CLASSES.contains(result.getTestClass().getName())) {
            return false;
        }
        return super.retry(result);
    }

    public boolean retryMethod(ITestResult result) {
        return !(result.getThrowable() instanceof SkipException);
    }
}

