/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jcloud.shade.com.google.inject.internal;

import java.lang.annotation.Annotation;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.inject.Scope;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.AbstractProcessor;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.Annotations;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.Errors;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.ScopeBinding;

final class ScopeBindingProcessor
extends AbstractProcessor {
    ScopeBindingProcessor(Errors errors) {
        super(errors);
    }

    @Override
    public Boolean visit(ScopeBinding command) {
        ScopeBinding existing;
        Scope scope = Preconditions.checkNotNull(command.getScope(), "scope");
        Class<? extends Annotation> annotationType = Preconditions.checkNotNull(command.getAnnotationType(), "annotation type");
        if (!Annotations.isScopeAnnotation(annotationType)) {
            this.errors.missingScopeAnnotation(annotationType);
        }
        if (!Annotations.isRetainedAtRuntime(annotationType)) {
            this.errors.missingRuntimeRetention(annotationType);
        }
        if ((existing = this.injector.getBindingData().getScopeBinding(annotationType)) != null) {
            if (!scope.equals(existing.getScope())) {
                this.errors.duplicateScopes(existing, annotationType, scope);
            }
        } else {
            this.injector.getBindingData().putScopeBinding(annotationType, command);
        }
        return true;
    }
}

