/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.functions;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.functions.ParseSystemAndUserMetadataFromHeaders;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.InvocationContext;

public class ParseBlobFromHeadersAndHttpContent
implements Function<HttpResponse, Blob>,
InvocationContext<ParseBlobFromHeadersAndHttpContent> {
    private final ParseSystemAndUserMetadataFromHeaders metadataParser;
    private final Blob.Factory blobFactory;

    @Inject
    public ParseBlobFromHeadersAndHttpContent(ParseSystemAndUserMetadataFromHeaders metadataParser, Blob.Factory blobFactory) {
        this.metadataParser = Preconditions.checkNotNull(metadataParser, "metadataParser");
        this.blobFactory = Preconditions.checkNotNull(blobFactory, "blobFactory");
    }

    @Override
    public Blob apply(HttpResponse from) {
        Preconditions.checkNotNull(from, "request");
        MutableBlobMetadata metadata = this.metadataParser.apply(from);
        Blob blob = this.blobFactory.create(metadata);
        blob.getAllHeaders().putAll(from.getHeaders());
        blob.setPayload(from.getPayload());
        return blob;
    }

    @Override
    public ParseBlobFromHeadersAndHttpContent setContext(HttpRequest request) {
        this.metadataParser.setContext(request);
        return this;
    }
}

