/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Maps;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.internal.MutableBlobMetadataImpl;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.rest.internal.GeneratedHttpRequest;

public class BlobStoreUtils {
    private static Pattern keyFromContainer = Pattern.compile("/?[^/]+/(.*)");

    public static <T> HttpRequest cleanRequest(HttpRequest returnVal) {
        Preconditions.checkNotNull(returnVal, "http request");
        for (HttpRequestFilter filter : returnVal.getFilters()) {
            returnVal = filter.filter(returnVal);
        }
        return ((HttpRequest.Builder)((HttpRequest.Builder)((HttpMessage.Builder)((HttpRequest.Builder)HttpRequest.builder().method(returnVal.getMethod())).endpoint(returnVal.getEndpoint())).headers(returnVal.getHeaders())).payload(returnVal.getPayload())).build();
    }

    public static String parseDirectoryFromPath(String path) {
        return Preconditions.checkNotNull(path, "path").substring(0, path.lastIndexOf(47));
    }

    public static String getNameFor(GeneratedHttpRequest request) {
        Matcher matcher;
        Preconditions.checkNotNull(request, "request");
        List<Object> args = request.getInvocation().getArgs();
        if (args.size() >= 2 && args.get(0) instanceof String && args.get(1) instanceof String) {
            return args.get(1).toString();
        }
        if (args.size() >= 1 && args.get(0) instanceof String && (matcher = keyFromContainer.matcher(args.get(0).toString())).find()) {
            return matcher.group(1);
        }
        String objectKey = request.getEndpoint().getPath();
        if (objectKey.startsWith("/")) {
            objectKey = objectKey.substring(1);
        }
        return objectKey;
    }

    public static MutableBlobMetadata copy(MutableBlobMetadata in) {
        MutableBlobMetadataImpl metadata = new MutableBlobMetadataImpl(in);
        BlobStoreUtils.convertUserMetadataKeysToLowercase(metadata);
        return metadata;
    }

    public static MutableBlobMetadata copy(MutableBlobMetadata in, String newKey) {
        MutableBlobMetadata newMd = BlobStoreUtils.copy(in);
        newMd.setName(newKey);
        return newMd;
    }

    private static void convertUserMetadataKeysToLowercase(MutableBlobMetadata metadata) {
        HashMap<String, String> lowerCaseUserMetadata = Maps.newHashMap();
        for (Map.Entry<String, String> entry : metadata.getUserMetadata().entrySet()) {
            lowerCaseUserMetadata.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        metadata.setUserMetadata(lowerCaseUserMetadata);
    }
}

