/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.domain;

import java.beans.ConstructorProperties;
import java.util.Date;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Objects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ComparisonChain;
import org.apache.pulsar.jcloud.shade.com.google.common.hash.HashCode;
import org.apache.pulsar.jcloud.shade.com.google.gson.annotations.SerializedName;
import org.jclouds.javax.annotation.Nullable;

public class ArchiveMetadata
implements Comparable<ArchiveMetadata> {
    @SerializedName(value="ArchiveId")
    private final String archiveId;
    @SerializedName(value="ArchiveDescription")
    private final String description;
    @SerializedName(value="CreationDate")
    private final Date creationDate;
    @SerializedName(value="Size")
    private final long size;
    @SerializedName(value="SHA256TreeHash")
    private final HashCode treeHash;

    @ConstructorProperties(value={"ArchiveId", "ArchiveDescription", "CreationDate", "Size", "SHA256TreeHash"})
    public ArchiveMetadata(String archiveId, @Nullable String description, Date creationDate, long size, String hashCode) {
        this.archiveId = Preconditions.checkNotNull(archiveId, "archiveId");
        this.description = description;
        this.creationDate = (Date)Preconditions.checkNotNull(creationDate, "creationDate").clone();
        this.size = size;
        this.treeHash = HashCode.fromString(Preconditions.checkNotNull(hashCode, "hashCode"));
    }

    public String getArchiveId() {
        return this.archiveId;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getCreationDate() {
        return (Date)this.creationDate.clone();
    }

    public long getSize() {
        return this.size;
    }

    public HashCode getTreeHash() {
        return this.treeHash;
    }

    public int hashCode() {
        return Objects.hashCode(this.archiveId, this.description, this.creationDate, this.size, this.treeHash);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArchiveMetadata other = (ArchiveMetadata)obj;
        return Objects.equal(this.archiveId, other.archiveId) && Objects.equal(this.description, other.description) && Objects.equal(this.creationDate, other.creationDate) && Objects.equal(this.treeHash, other.treeHash) && Objects.equal(this.size, other.size);
    }

    public String toString() {
        return "ArchiveMetadata [archiveId=" + this.archiveId + ", description=" + this.description + ", creationDate=" + this.creationDate + ", treeHash=" + this.treeHash + ", size=" + this.size + "]";
    }

    @Override
    public int compareTo(ArchiveMetadata o) {
        return ComparisonChain.start().compare((Comparable<?>)((Object)this.archiveId), (Comparable<?>)((Object)o.archiveId)).result();
    }
}

