/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.blobstore.functions;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.hash.HashCode;
import org.apache.pulsar.jcloud.shade.com.google.common.io.BaseEncoding;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.MutableBlobMetadataImpl;
import org.jclouds.googlecloudstorage.domain.GoogleCloudStorageObject;
import org.jclouds.javax.annotation.Nullable;

public class ObjectToBlobMetadata
implements Function<GoogleCloudStorageObject, MutableBlobMetadata> {
    @Override
    public MutableBlobMetadata apply(GoogleCloudStorageObject from) {
        if (from == null) {
            return null;
        }
        MutableBlobMetadataImpl to = new MutableBlobMetadataImpl();
        to.getContentMetadata().setContentMD5(ObjectToBlobMetadata.toHashCode(from.md5Hash()));
        to.getContentMetadata().setContentType(from.contentType());
        to.getContentMetadata().setContentDisposition(from.contentDisposition());
        to.getContentMetadata().setContentEncoding(from.contentEncoding());
        to.getContentMetadata().setContentLanguage(from.contentLanguage());
        to.getContentMetadata().setContentLength(from.size());
        to.setLastModified(from.updated());
        to.setContainer(from.bucket());
        to.setUserMetadata(from.metadata());
        to.setETag(from.etag());
        to.setName(from.name());
        to.setUri(from.selfLink());
        to.setId(from.id());
        to.setPublicUri(from.mediaLink());
        to.setType(StorageType.BLOB);
        to.setSize(from.size());
        to.setTier(from.storageClass().toTier());
        return to;
    }

    private static HashCode toHashCode(@Nullable String hashCode) {
        return hashCode == null ? null : HashCode.fromBytes(BaseEncoding.base64().decode(hashCode));
    }
}

