/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.domain.templates;

import java.util.List;
import java.util.Map;
import org.apache.pulsar.jcloud.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Lists;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Maps;
import org.apache.pulsar.jcloud.shade.com.google.common.net.MediaType;
import org.jclouds.googlecloudstorage.domain.DomainResourceReferences;
import org.jclouds.googlecloudstorage.domain.ObjectAccessControls;

public class ObjectTemplate {
    private String name;
    private Long size;
    private String cacheControl;
    private String contentDisposition;
    private String contentEncoding;
    private String contentLanguage;
    private String contentType;
    private String crc32c;
    private String md5Hash;
    private DomainResourceReferences.StorageClass storageClass;
    private Map<String, String> metadata;
    private List<ObjectAccessControls> acl;

    public ObjectTemplate name(String name) {
        this.name = name;
        return this;
    }

    public ObjectTemplate size(Long size) {
        this.size = size;
        return this;
    }

    public ObjectTemplate cacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public ObjectTemplate contentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public ObjectTemplate contentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public ObjectTemplate contentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public ObjectTemplate contentType(MediaType contentType) {
        this.contentType = contentType.toString();
        return this;
    }

    public ObjectTemplate contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public ObjectTemplate customMetadata(Map<String, String> metadata) {
        if (this.metadata == null) {
            this.metadata = Maps.newLinkedHashMap();
        }
        this.metadata.putAll(metadata);
        return this;
    }

    public ObjectTemplate customMetadata(String key, String value) {
        if (this.metadata == null) {
            this.metadata = Maps.newLinkedHashMap();
        }
        this.metadata.put(key, value);
        return this;
    }

    public ObjectTemplate crc32c(String crc32c) {
        this.crc32c = crc32c;
        return this;
    }

    public ObjectTemplate md5Hash(String md5Hash) {
        this.md5Hash = md5Hash;
        return this;
    }

    public ObjectTemplate storageClass(DomainResourceReferences.StorageClass storageClass) {
        this.storageClass = Preconditions.checkNotNull(storageClass);
        return this;
    }

    public ObjectTemplate addAcl(ObjectAccessControls acl) {
        if (this.acl == null) {
            this.acl = Lists.newArrayList();
        }
        this.acl.add(acl);
        return this;
    }

    public ObjectTemplate acl(List<ObjectAccessControls> acl) {
        if (this.acl == null) {
            this.acl = Lists.newArrayList();
        }
        this.acl.addAll(acl);
        return this;
    }

    public String cacheControl() {
        return this.cacheControl;
    }

    public String contentDisposition() {
        return this.contentDisposition;
    }

    public String contentEncoding() {
        return this.contentEncoding;
    }

    public String contentLanguage() {
        return this.contentLanguage;
    }

    public String contentType() {
        return this.contentType;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public String crc32c() {
        return this.crc32c;
    }

    public String md5Hash() {
        return this.md5Hash;
    }

    public DomainResourceReferences.StorageClass storageClass() {
        return this.storageClass;
    }

    public String name() {
        return this.name;
    }

    public Long size() {
        return this.size;
    }

    public List<ObjectAccessControls> acl() {
        return this.acl;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("size", this.size).add("cacheControl", this.cacheControl).add("contentDisposition", this.contentDisposition).add("contentEncoding", this.contentEncoding).add("contentLanguage", this.contentLanguage).add("contentType", this.contentType).add("crc32c", this.crc32c).add("md5Hash", this.md5Hash).add("storageClass", (Object)this.storageClass).add("metadata", this.metadata).add("acl", this.acl).toString();
    }
}

