/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.functions;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableList;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMap;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableSet;
import org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.Atomics;
import org.apache.pulsar.jcloud.shade.com.google.gson.stream.JsonReader;
import org.apache.pulsar.jcloud.shade.com.google.gson.stream.JsonToken;
import org.apache.pulsar.jcloud.shade.com.google.inject.TypeLiteral;
import org.apache.pulsar.jcloud.shade.jakarta.annotation.Resource;
import org.jclouds.http.HttpResponse;
import org.jclouds.json.internal.GsonWrapper;
import org.jclouds.logging.Logger;
import org.jclouds.util.Closeables2;

public class ParseFirstJsonValueNamed<T>
implements Function<HttpResponse, T> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final GsonWrapper json;
    private final TypeLiteral<T> type;
    private final ImmutableSet<String> nameChoices;

    public ParseFirstJsonValueNamed(GsonWrapper json, TypeLiteral<T> type, String ... nameChoices) {
        this.json = Preconditions.checkNotNull(json, "json");
        this.type = Preconditions.checkNotNull(type, "type");
        this.nameChoices = ImmutableSet.copyOf(Preconditions.checkNotNull(nameChoices, "nameChoices"));
    }

    @Override
    public T apply(HttpResponse arg0) {
        T t;
        JsonReader reader;
        block9: {
            AtomicReference<String> name;
            block8: {
                if (arg0.getPayload() == null) {
                    return this.nothing();
                }
                reader = null;
                reader = new JsonReader(new InputStreamReader(arg0.getPayload().getInput()));
                reader.setLenient(true);
                name = Atomics.newReference();
                JsonToken token = reader.peek();
                while (token != JsonToken.END_DOCUMENT && this.nnn(reader, token, name)) {
                    token = this.skipAndPeek(token, reader);
                }
                if (name.get() != null) break block8;
                this.logger.trace("did not object named %s in json from response %s", this.nameChoices, arg0);
                T t2 = this.nothing();
                Closeables2.closeQuietly(reader);
                arg0.getPayload().release();
                return t2;
            }
            if (!this.nameChoices.contains(name.get())) break block9;
            Object t3 = this.json.delegate().fromJson(reader, this.type.getType());
            Closeables2.closeQuietly(reader);
            arg0.getPayload().release();
            return t3;
        }
        try {
            t = this.nothing();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(String.format("error reading from stream, parsing object named %s from http response %s", this.nameChoices, arg0), e);
            }
            catch (Throwable throwable) {
                Closeables2.closeQuietly(reader);
                arg0.getPayload().release();
                throw throwable;
            }
        }
        Closeables2.closeQuietly(reader);
        arg0.getPayload().release();
        return t;
    }

    private T nothing() {
        if (this.type.getRawType().isAssignableFrom(Set.class)) {
            return (T)ImmutableSet.of();
        }
        if (this.type.getRawType().isAssignableFrom(List.class)) {
            return (T)ImmutableList.of();
        }
        if (this.type.getRawType().isAssignableFrom(Map.class)) {
            return (T)ImmutableMap.of();
        }
        return null;
    }

    private boolean nnn(JsonReader reader, JsonToken token, AtomicReference<String> name) throws IOException {
        String name2;
        if (token == JsonToken.NAME && this.nameChoices.contains(name2 = reader.nextName())) {
            name.set(name2);
            return false;
        }
        return true;
    }

    private JsonToken skipAndPeek(JsonToken token, JsonReader reader) throws IOException {
        switch (token) {
            case BEGIN_ARRAY: {
                reader.beginArray();
                break;
            }
            case END_ARRAY: {
                reader.endArray();
                break;
            }
            case BEGIN_OBJECT: {
                reader.beginObject();
                break;
            }
            case END_OBJECT: {
                reader.endObject();
                break;
            }
            case NAME: {
                break;
            }
            case STRING: {
                reader.nextString();
                break;
            }
            case NUMBER: {
                reader.nextString();
                break;
            }
            case BOOLEAN: {
                reader.nextBoolean();
                break;
            }
            case NULL: {
                reader.nextNull();
                break;
            }
        }
        return reader.peek();
    }
}

