/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.json.internal;

import java.lang.reflect.Type;
import org.apache.pulsar.jcloud.shade.com.google.common.reflect.Invokable;
import org.apache.pulsar.jcloud.shade.com.google.gson.JsonDeserializationContext;
import org.apache.pulsar.jcloud.shade.com.google.gson.JsonDeserializer;
import org.apache.pulsar.jcloud.shade.com.google.gson.JsonElement;
import org.apache.pulsar.jcloud.shade.com.google.gson.JsonParseException;
import org.apache.pulsar.jcloud.shade.com.google.gson.JsonPrimitive;
import org.apache.pulsar.jcloud.shade.com.google.gson.JsonSerializationContext;
import org.apache.pulsar.jcloud.shade.com.google.gson.JsonSerializer;
import org.jclouds.reflect.Reflection2;

public class EnumTypeAdapterThatReturnsFromValue<T extends Enum<T>>
implements JsonSerializer<T>,
JsonDeserializer<T> {
    @Override
    public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(((Enum)src).toString());
    }

    @Override
    public T deserialize(JsonElement json, Type classOfT, JsonDeserializationContext context) throws JsonParseException {
        try {
            return Enum.valueOf((Class)classOfT, json.getAsString());
        }
        catch (IllegalArgumentException e) {
            try {
                Invokable converter = Reflection2.method((Class)classOfT, "fromValue", String.class);
                return (T)((Enum)converter.invoke(null, json.getAsString()));
            }
            catch (Exception e1) {
                throw e;
            }
        }
    }
}

