/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers.implicit;

import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Predicate;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Predicates;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Iterables;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.Region;
import org.jclouds.location.functions.ToIdAndScope;
import org.jclouds.location.predicates.LocationPredicates;
import org.jclouds.location.suppliers.ImplicitLocationSupplier;

@Singleton
public class OnlyLocationOrFirstRegionOptionallyMatchingRegionId
implements ImplicitLocationSupplier {
    private final Supplier<String> regionSupplier;
    private final Supplier<Set<? extends Location>> locationsSupplier;

    @Inject
    OnlyLocationOrFirstRegionOptionallyMatchingRegionId(@Region Supplier<String> regionSupplier, @Memoized Supplier<Set<? extends Location>> locationsSupplier) {
        this.regionSupplier = Preconditions.checkNotNull(regionSupplier, "regionSupplier");
        this.locationsSupplier = Preconditions.checkNotNull(locationsSupplier, "locationsSupplier");
    }

    @Override
    @Singleton
    public Location get() {
        String region = this.regionSupplier.get();
        Predicate<Location> locationPredicate = region == null ? Predicates.or(LocationPredicates.isZone(), LocationPredicates.isRegion()) : LocationPredicates.isZoneOrRegionWhereRegionIdEquals(region);
        Set<? extends Location> locations = this.locationsSupplier.get();
        if (this.locationsSupplier.get().size() == 1) {
            return (Location)Iterables.getOnlyElement((Iterable)this.locationsSupplier.get());
        }
        try {
            Location toReturn = Iterables.find(locations, locationPredicate);
            return toReturn.getScope() == LocationScope.REGION ? toReturn : toReturn.getParent();
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException(String.format("couldn't find region matching %s in %s", locationPredicate, Iterables.transform(locations, ToIdAndScope.INSTANCE)));
        }
    }
}

