/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.predicates.validators;

import org.apache.pulsar.jcloud.shade.com.google.common.base.CharMatcher;
import org.apache.pulsar.jcloud.shade.com.google.inject.Singleton;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Named;
import org.jclouds.predicates.Validator;

@Singleton
public class DnsNameValidator
extends Validator<String> {
    private int min;
    private int max;

    @Inject
    public DnsNameValidator(@Named(value="jclouds.dns_name_length_min") int min, @Named(value="jclouds.dns_name_length_max") int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public void validate(String name) {
        if (name == null || name.isEmpty() || name.length() < this.min || name.length() > this.max) {
            throw this.exception(name, "Can't be null or empty. Length must be " + this.min + " to " + this.max + " symbols.");
        }
        if (!Character.isLetterOrDigit(name.charAt(0))) {
            throw this.exception(name, "Should start with letter/number");
        }
        if (!name.toLowerCase().equals(name)) {
            throw this.exception(name, "Should be only lowercase");
        }
        CharMatcher range = this.getAcceptableRange();
        if (!range.matchesAllOf(name)) {
            throw this.exception(name, "Should have lowercase ASCII letters, numbers, or dashes");
        }
    }

    protected CharMatcher getAcceptableRange() {
        return CharMatcher.inRange('a', 'z').or(CharMatcher.inRange('0', '9').or(CharMatcher.is('-')));
    }

    protected IllegalArgumentException exception(String vAppName, String reason) {
        return new IllegalArgumentException(String.format("Object '%s' doesn't match dns naming constraints. Reason: %s.", vAppName, reason));
    }
}

