/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudfiles.v1.features;

import java.io.Closeable;
import java.net.URI;
import org.apache.pulsar.jcloud.shade.com.google.common.annotations.Beta;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.FluentIterable;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Named;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.Consumes;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.DELETE;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.GET;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.HEAD;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.HeaderParam;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.POST;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.PUT;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.Path;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.rackspace.cloudfiles.v1.binders.BindCDNPurgeEmailAddressesToHeaders;
import org.jclouds.rackspace.cloudfiles.v1.domain.CDNContainer;
import org.jclouds.rackspace.cloudfiles.v1.functions.ParseCDNContainerFromHeaders;
import org.jclouds.rackspace.cloudfiles.v1.functions.ParseCDNContainerURIFromHeaders;
import org.jclouds.rackspace.cloudfiles.v1.options.ListCDNContainerOptions;
import org.jclouds.rackspace.cloudfiles.v1.options.UpdateCDNContainerOptions;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;

@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Beta
public interface CDNApi
extends Closeable {
    @Named(value="cdn:list")
    @GET
    @QueryParams(keys={"format", "enabled_only"}, values={"json", "true"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    @Path(value="/")
    public FluentIterable<CDNContainer> list();

    @Named(value="cdn:list")
    @GET
    @QueryParams(keys={"format", "enabled_only"}, values={"json", "true"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    @Path(value="/")
    public FluentIterable<CDNContainer> list(ListCDNContainerOptions var1);

    @Named(value="cdn:get")
    @HEAD
    @ResponseParser(value=ParseCDNContainerFromHeaders.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Path(value="/{container}")
    @Nullable
    public CDNContainer get(@PathParam(value="container") String var1);

    @Named(value="cdn:enable")
    @PUT
    @ResponseParser(value=ParseCDNContainerURIFromHeaders.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Path(value="/{containerName}")
    @Headers(keys={"X-Cdn-Enabled"}, values={"true"})
    @Nullable
    public URI enable(@PathParam(value="containerName") String var1);

    @Named(value="cdn:enable")
    @PUT
    @ResponseParser(value=ParseCDNContainerURIFromHeaders.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Path(value="/{containerName}")
    @Headers(keys={"X-Cdn-Enabled"}, values={"true"})
    @Nullable
    public URI enable(@PathParam(value="containerName") String var1, @HeaderParam(value="X-Ttl") int var2);

    @Named(value="cdn:disable")
    @PUT
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Path(value="/{containerName}")
    @Headers(keys={"X-Cdn-Enabled"}, values={"False"})
    public boolean disable(@PathParam(value="containerName") String var1);

    @Named(value="cdn:purge")
    @DELETE
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Path(value="/{containerName}/{objectName}")
    @Headers(keys={"X-Purge-Email"}, values={"{email}"})
    public boolean purgeObject(@PathParam(value="containerName") String var1, @PathParam(value="objectName") String var2, @BinderParam(value=BindCDNPurgeEmailAddressesToHeaders.class) Iterable<String> var3);

    @Named(value="cdn:update")
    @POST
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Path(value="/{containerName}")
    public boolean update(@PathParam(value="containerName") String var1, UpdateCDNContainerOptions var2);
}

